// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

[assembly:System.Reflection.AssemblyVersionAttribute("4.0.0.0")]
[assembly:System.CLSCompliantAttribute(true)]
[assembly:System.Diagnostics.DebuggableAttribute(System.Diagnostics.DebuggableAttribute.DebuggingModes.IgnoreSymbolStoreSequencePoints)]
[assembly:System.Reflection.AssemblyCompanyAttribute("Mono development team")]
[assembly:System.Reflection.AssemblyCopyrightAttribute("(c) Various Mono authors")]
[assembly:System.Reflection.AssemblyDefaultAliasAttribute("System.Runtime.DurableInstancing.dll")]
[assembly:System.Reflection.AssemblyDescriptionAttribute("System.Runtime.DurableInstancing.dll")]
[assembly:System.Reflection.AssemblyFileVersionAttribute("4.6.57.0")]
[assembly:System.Reflection.AssemblyInformationalVersionAttribute("4.6.57.0")]
[assembly:System.Reflection.AssemblyProductAttribute("Mono Common Language Infrastructure")]
[assembly:System.Reflection.AssemblyTitleAttribute("System.Runtime.DurableInstancing.dll")]
[assembly:System.Resources.NeutralResourcesLanguageAttribute("en-US")]
[assembly:System.Resources.SatelliteContractVersionAttribute("4.0.0.0")]
[assembly:System.Runtime.CompilerServices.CompilationRelaxationsAttribute(8)]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("CDF.CIT.Scenarios.Common, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("Microsoft.CDF.Test.Persistence, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.Activities, PublicKey=00000000000000000400000000000000")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.Activities, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.Activities.DurableInstancing, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.IdentityModel, PublicKey=00000000000000000400000000000000")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.IdentityModel.Selectors, PublicKey=00000000000000000400000000000000")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.Runtime.Serialization, PublicKey=00000000000000000400000000000000")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.ServiceModel, PublicKey=00000000000000000400000000000000")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.ServiceModel.Activation, PublicKey=00000000000000000400000000000000")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.ServiceModel.Activation, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.ServiceModel.Activities, PublicKey=00000000000000000400000000000000")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.ServiceModel.Activities, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.ServiceModel.Routing, PublicKey=00000000000000000400000000000000")]
[assembly:System.Runtime.CompilerServices.InternalsVisibleToAttribute("System.ServiceModel.Routing, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly:System.Runtime.CompilerServices.RuntimeCompatibilityAttribute(WrapNonExceptionThrows=true)]
[assembly:System.Runtime.InteropServices.ComCompatibleVersionAttribute(1, 0, 3300, 0)]
[assembly:System.Runtime.InteropServices.ComVisibleAttribute(false)]
[assembly:System.Runtime.InteropServices.GuidAttribute("a9b8c4b5-b4a9-4800-8268-e8ec3b93d9ac")]
[assembly:System.Security.AllowPartiallyTrustedCallersAttribute]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.ActionItem))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.AsyncResult))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.BufferedOutputStream))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.CompletedAsyncResult))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.Diagnostics.DiagnosticsEventProvider))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.Diagnostics.EtwProvider))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.Diagnostics.EventLogger))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.Diagnostics.StringTraceRecord))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.Diagnostics.TraceRecord))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.ExceptionTrace))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.Fx))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.IOThreadScheduler))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.PartialTrustHelpers))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.SynchronizedPool<>))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.TraceEventLevel))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.TracePayload))]
[assembly:System.Runtime.CompilerServices.TypeForwardedToAttribute(typeof(System.Runtime.TypeHelper))]
public static partial class SRCore
{
    public const string AsyncTransactionException = "AsyncTransactionException";
    public const string BindLockRequiresCommandFlag = "BindLockRequiresCommandFlag";
    public const string BindReclaimedLockException = "BindReclaimedLockException";
    public const string BindReclaimSucceeded = "BindReclaimSucceeded";
    public const string CannotAcquireLockDefault = "CannotAcquireLockDefault";
    public const string CannotCompleteWithKeys = "CannotCompleteWithKeys";
    public const string CannotCreateContextWithNullId = "CannotCreateContextWithNullId";
    public const string CannotInvokeBindingFromNonBinding = "CannotInvokeBindingFromNonBinding";
    public const string CannotInvokeTransactionalFromNonTransactional = "CannotInvokeTransactionalFromNonTransactional";
    public const string CannotReplaceTransaction = "CannotReplaceTransaction";
    public const string CommandExecutionCannotOverlap = "CommandExecutionCannotOverlap";
    public const string CompletedMustNotHaveAssociatedKeys = "CompletedMustNotHaveAssociatedKeys";
    public const string ContextAlreadyBoundToInstance = "ContextAlreadyBoundToInstance";
    public const string ContextAlreadyBoundToLock = "ContextAlreadyBoundToLock";
    public const string ContextAlreadyBoundToOwner = "ContextAlreadyBoundToOwner";
    public const string ContextMustBeBoundToInstance = "ContextMustBeBoundToInstance";
    public const string ContextMustBeBoundToOwner = "ContextMustBeBoundToOwner";
    public const string ContextNotFromThisStore = "ContextNotFromThisStore";
    public const string DoNotCompleteTryCommandWithPendingReclaim = "DoNotCompleteTryCommandWithPendingReclaim";
    public const string ExecuteMustBeNested = "ExecuteMustBeNested";
    public const string GenericInstanceCommandNull = "GenericInstanceCommandNull";
    public const string GuidCannotBeEmpty = "GuidCannotBeEmpty";
    public const string HandleFreed = "HandleFreed";
    public const string HandleFreedBeforeInitialized = "HandleFreedBeforeInitialized";
    public const string InstanceCollisionDefault = "InstanceCollisionDefault";
    public const string InstanceCompleteDefault = "InstanceCompleteDefault";
    public const string InstanceHandleConflictDefault = "InstanceHandleConflictDefault";
    public const string InstanceKeyRequiresValidGuid = "InstanceKeyRequiresValidGuid";
    public const string InstanceLockLostDefault = "InstanceLockLostDefault";
    public const string InstanceNotReadyDefault = "InstanceNotReadyDefault";
    public const string InstanceOperationRequiresInstance = "InstanceOperationRequiresInstance";
    public const string InstanceOperationRequiresLock = "InstanceOperationRequiresLock";
    public const string InstanceOperationRequiresNotCompleted = "InstanceOperationRequiresNotCompleted";
    public const string InstanceOperationRequiresNotUninitialized = "InstanceOperationRequiresNotUninitialized";
    public const string InstanceOperationRequiresOwner = "InstanceOperationRequiresOwner";
    public const string InstanceOwnerDefault = "InstanceOwnerDefault";
    public const string InstanceStoreBoundSameVersionTwice = "InstanceStoreBoundSameVersionTwice";
    public const string InvalidInstanceState = "InvalidInstanceState";
    public const string InvalidKeyArgument = "InvalidKeyArgument";
    public const string InvalidLockToken = "InvalidLockToken";
    public const string KeyAlreadyAssociated = "KeyAlreadyAssociated";
    public const string KeyAlreadyCompleted = "KeyAlreadyCompleted";
    public const string KeyAlreadyUnassociated = "KeyAlreadyUnassociated";
    public const string KeyCollisionDefault = "KeyCollisionDefault";
    public const string KeyCompleteDefault = "KeyCompleteDefault";
    public const string KeyNotAssociated = "KeyNotAssociated";
    public const string KeyNotCompleted = "KeyNotCompleted";
    public const string KeyNotReadyDefault = "KeyNotReadyDefault";
    public const string LoadedWriteOnlyValue = "LoadedWriteOnlyValue";
    public const string MayBindLockCommandShouldValidateOwner = "MayBindLockCommandShouldValidateOwner";
    public const string MetadataCannotContainNullKey = "MetadataCannotContainNullKey";
    public const string MustSetTransactionOnFirstCall = "MustSetTransactionOnFirstCall";
    public const string OnCancelRequestedThrew = "OnCancelRequestedThrew";
    public const string OnFreeInstanceHandleThrew = "OnFreeInstanceHandleThrew";
    public const string OwnerBelongsToWrongStore = "OwnerBelongsToWrongStore";
    public const string StoreReportedConflictingLockTokens = "StoreReportedConflictingLockTokens";
    public const string TimedOutWaitingForLockResolution = "TimedOutWaitingForLockResolution";
    public const string TransactionInDoubtNonHost = "TransactionInDoubtNonHost";
    public const string TransactionRolledBackNonHost = "TransactionRolledBackNonHost";
    public const string TryCommandCannotExecuteSubCommandsAndReduce = "TryCommandCannotExecuteSubCommandsAndReduce";
    public const string UninitializedCannotHaveData = "UninitializedCannotHaveData";
    public const string WaitAlreadyInProgress = "WaitAlreadyInProgress";
    public static string CannotAcquireLockSpecific(object arg1) { throw null; }
    public static string CannotAcquireLockSpecificWithOwner(object arg1, object arg2) { throw null; }
    public static string GenericInstanceCommand(object arg1) { throw null; }
    public static string InitialMetadataCannotBeDeleted(object arg1) { throw null; }
    public static string InstanceCollisionSpecific(System.Guid arg1) { throw null; }
    public static string InstanceCompleteSpecific(System.Guid arg1) { throw null; }
    public static string InstanceHandleConflictSpecific(System.Guid arg1) { throw null; }
    public static string InstanceLockLostSpecific(System.Guid arg1) { throw null; }
    public static string InstanceNotReadySpecific(System.Guid arg1) { throw null; }
    public static string InstanceOwnerSpecific(System.Guid arg1) { throw null; }
    public static string KeyCollisionSpecific(object arg1) { throw null; }
    public static string KeyCollisionSpecific(object arg1, object arg2, object arg3) { throw null; }
    public static string KeyCollisionSpecificKeyOnly(object arg1) { throw null; }
    public static string KeyCompleteSpecific(object arg1) { throw null; }
    public static string KeyNotReadySpecific(object arg1) { throw null; }
    public static string MetadataCannotContainNullValue(object arg1) { throw null; }
    public static string NameCollisionOnCollect(System.Xml.Linq.XName arg1, object arg2) { throw null; }
    public static string NameCollisionOnMap(System.Xml.Linq.XName arg1, object arg2) { throw null; }
    public static string OutsideInstanceExecutionScope(object arg1) { throw null; }
    public static string OutsideTransactionalCommand(object arg1) { throw null; }
    public static string PersistencePipelineAbortThrew(object arg1) { throw null; }
    public static string ProviderDoesNotSupportCommand(object arg1) { throw null; }
    public static string WaitForEventsTimedOut(System.TimeSpan arg1) { throw null; }
}
namespace System.Runtime.DurableInstancing
{
    [System.SerializableAttribute]
    public partial class InstanceCollisionException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceCollisionException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceCollisionException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceCollisionException(string message) { }
        public InstanceCollisionException(string message, System.Exception innerException) { }
        public InstanceCollisionException(System.Xml.Linq.XName commandName, System.Guid instanceId) { }
        public InstanceCollisionException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Exception innerException) { }
        public InstanceCollisionException(System.Xml.Linq.XName commandName, System.Guid instanceId, string message, System.Exception innerException) { }
    }
    [System.SerializableAttribute]
    public partial class InstanceCompleteException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceCompleteException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceCompleteException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceCompleteException(string message) { }
        public InstanceCompleteException(string message, System.Exception innerException) { }
        public InstanceCompleteException(System.Xml.Linq.XName commandName, System.Guid instanceId) { }
        public InstanceCompleteException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Exception innerException) { }
        public InstanceCompleteException(System.Xml.Linq.XName commandName, System.Guid instanceId, string message, System.Exception innerException) { }
    }
    public sealed partial class InstanceHandle
    {
        internal InstanceHandle() { }
        public bool IsValid { get { throw null; } }
        public void Free() { }
    }
    [System.SerializableAttribute]
    public partial class InstanceHandleConflictException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceHandleConflictException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceHandleConflictException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceHandleConflictException(string message) { }
        public InstanceHandleConflictException(string message, System.Exception innerException) { }
        public InstanceHandleConflictException(System.Xml.Linq.XName commandName, System.Guid instanceId) { }
        public InstanceHandleConflictException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Exception innerException) { }
        public InstanceHandleConflictException(System.Xml.Linq.XName commandName, System.Guid instanceId, string message, System.Exception innerException) { }
    }
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InstanceKey
    {
        public InstanceKey(System.Guid value) { }
        public InstanceKey(System.Guid value, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> metadata) { }
        public static System.Runtime.DurableInstancing.InstanceKey InvalidKey { get { throw null; } }
        public bool IsValid { get { throw null; } }
        public System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> Metadata { get { throw null; } }
        public System.Guid Value { get { throw null; } }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
    }
    [System.SerializableAttribute]
    public partial class InstanceKeyCollisionException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceKeyCollisionException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceKeyCollisionException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceKeyCollisionException(string message) { }
        public InstanceKeyCollisionException(string message, System.Exception innerException) { }
        public InstanceKeyCollisionException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Runtime.DurableInstancing.InstanceKey instanceKey, System.Guid conflictingInstanceId) { }
        public InstanceKeyCollisionException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Runtime.DurableInstancing.InstanceKey instanceKey, System.Guid conflictingInstanceId, System.Exception innerException) { }
        public InstanceKeyCollisionException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Runtime.DurableInstancing.InstanceKey instanceKey, System.Guid conflictingInstanceId, string message, System.Exception innerException) { }
        public System.Guid ConflictingInstanceId { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceKey InstanceKey { get { throw null; } }
        [System.Security.SecurityCriticalAttribute]
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
    }
    [System.SerializableAttribute]
    public partial class InstanceKeyCompleteException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceKeyCompleteException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceKeyCompleteException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceKeyCompleteException(string message) { }
        public InstanceKeyCompleteException(string message, System.Exception innerException) { }
        public InstanceKeyCompleteException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Runtime.DurableInstancing.InstanceKey instanceKey, string message, System.Exception innerException) { }
        public InstanceKeyCompleteException(System.Xml.Linq.XName commandName, System.Runtime.DurableInstancing.InstanceKey instanceKey) { }
        public InstanceKeyCompleteException(System.Xml.Linq.XName commandName, System.Runtime.DurableInstancing.InstanceKey instanceKey, System.Exception innerException) { }
        public System.Runtime.DurableInstancing.InstanceKey InstanceKey { get { throw null; } }
        [System.Security.SecurityCriticalAttribute]
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
    }
    [System.SerializableAttribute]
    public partial class InstanceKeyNotReadyException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceKeyNotReadyException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceKeyNotReadyException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceKeyNotReadyException(string message) { }
        public InstanceKeyNotReadyException(string message, System.Exception innerException) { }
        public InstanceKeyNotReadyException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Runtime.DurableInstancing.InstanceKey instanceKey, string message, System.Exception innerException) { }
        public InstanceKeyNotReadyException(System.Xml.Linq.XName commandName, System.Runtime.DurableInstancing.InstanceKey instanceKey) { }
        public InstanceKeyNotReadyException(System.Xml.Linq.XName commandName, System.Runtime.DurableInstancing.InstanceKey instanceKey, System.Exception innerException) { }
        public System.Runtime.DurableInstancing.InstanceKey InstanceKey { get { throw null; } }
        [System.Security.SecurityCriticalAttribute]
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
    }
    public enum InstanceKeyState
    {
        Associated = 1,
        Completed = 2,
        Unknown = 0,
    }
    public sealed partial class InstanceKeyView
    {
        internal InstanceKeyView() { }
        public System.Guid InstanceKey { get { throw null; } }
        public System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> InstanceKeyMetadata { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceValueConsistency InstanceKeyMetadataConsistency { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceKeyState InstanceKeyState { get { throw null; } }
    }
    [System.SerializableAttribute]
    public partial class InstanceLockedException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceLockedException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceLockedException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceLockedException(string message) { }
        public InstanceLockedException(string message, System.Exception innerException) { }
        public InstanceLockedException(System.Xml.Linq.XName commandName, System.Guid instanceId) { }
        public InstanceLockedException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Exception innerException) { }
        public InstanceLockedException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Guid instanceOwnerId, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, object> serializableInstanceOwnerMetadata) { }
        public InstanceLockedException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Guid instanceOwnerId, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, object> serializableInstanceOwnerMetadata, System.Exception innerException) { }
        public InstanceLockedException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Guid instanceOwnerId, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, object> serializableInstanceOwnerMetadata, string message, System.Exception innerException) { }
        public InstanceLockedException(System.Xml.Linq.XName commandName, System.Guid instanceId, string message, System.Exception innerException) { }
        public System.Guid InstanceOwnerId { get { throw null; } }
        public System.Collections.Generic.IDictionary<System.Xml.Linq.XName, object> SerializableInstanceOwnerMetadata { get { throw null; } }
        [System.Security.SecurityCriticalAttribute]
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
    }
    [System.SerializableAttribute]
    public partial class InstanceLockLostException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceLockLostException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceLockLostException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceLockLostException(string message) { }
        public InstanceLockLostException(string message, System.Exception innerException) { }
        public InstanceLockLostException(System.Xml.Linq.XName commandName, System.Guid instanceId) { }
        public InstanceLockLostException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Exception innerException) { }
        public InstanceLockLostException(System.Xml.Linq.XName commandName, System.Guid instanceId, string message, System.Exception innerException) { }
    }
    public sealed partial class InstanceLockQueryResult : System.Runtime.DurableInstancing.InstanceStoreQueryResult
    {
        public InstanceLockQueryResult() { }
        public InstanceLockQueryResult(System.Collections.Generic.IDictionary<System.Guid, System.Guid> instanceOwnerIds) { }
        public InstanceLockQueryResult(System.Guid instanceId, System.Guid instanceOwnerId) { }
        public System.Collections.Generic.IDictionary<System.Guid, System.Guid> InstanceOwnerIds { get { throw null; } }
    }
    [System.SerializableAttribute]
    public partial class InstanceNotReadyException : System.Runtime.DurableInstancing.InstancePersistenceCommandException
    {
        public InstanceNotReadyException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceNotReadyException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceNotReadyException(string message) { }
        public InstanceNotReadyException(string message, System.Exception innerException) { }
        public InstanceNotReadyException(System.Xml.Linq.XName commandName, System.Guid instanceId) { }
        public InstanceNotReadyException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Exception innerException) { }
        public InstanceNotReadyException(System.Xml.Linq.XName commandName, System.Guid instanceId, string message, System.Exception innerException) { }
    }
    public sealed partial class InstanceOwner
    {
        internal InstanceOwner() { }
        public System.Guid InstanceOwnerId { get { throw null; } }
    }
    [System.SerializableAttribute]
    public partial class InstanceOwnerException : System.Runtime.DurableInstancing.InstancePersistenceException
    {
        public InstanceOwnerException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstanceOwnerException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstanceOwnerException(string message) { }
        public InstanceOwnerException(string message, System.Exception innerException) { }
        public InstanceOwnerException(System.Xml.Linq.XName commandName, System.Guid instanceOwnerId) { }
        public InstanceOwnerException(System.Xml.Linq.XName commandName, System.Guid instanceOwnerId, System.Exception innerException) { }
        public InstanceOwnerException(System.Xml.Linq.XName commandName, System.Guid instanceOwnerId, string message, System.Exception innerException) { }
        public System.Guid InstanceOwnerId { get { throw null; } }
        [System.Security.SecurityCriticalAttribute]
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
    }
    public sealed partial class InstanceOwnerQueryResult : System.Runtime.DurableInstancing.InstanceStoreQueryResult
    {
        public InstanceOwnerQueryResult() { }
        public InstanceOwnerQueryResult(System.Collections.Generic.IDictionary<System.Guid, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue>> instanceOwners) { }
        public InstanceOwnerQueryResult(System.Guid instanceOwnerId, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> metadata) { }
        public System.Collections.Generic.IDictionary<System.Guid, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue>> InstanceOwners { get { throw null; } }
    }
    public abstract partial class InstancePersistenceCommand
    {
        protected InstancePersistenceCommand(System.Xml.Linq.XName name) { }
        protected internal virtual bool AutomaticallyAcquiringLock { get { throw null; } }
        protected internal virtual bool IsTransactionEnlistmentOptional { get { throw null; } }
        public System.Xml.Linq.XName Name { get { throw null; } }
        protected internal virtual void Validate(System.Runtime.DurableInstancing.InstanceView view) { }
    }
    [System.SerializableAttribute]
    public partial class InstancePersistenceCommandException : System.Runtime.DurableInstancing.InstancePersistenceException
    {
        public InstancePersistenceCommandException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstancePersistenceCommandException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstancePersistenceCommandException(string message) { }
        public InstancePersistenceCommandException(string message, System.Exception innerException) { }
        public InstancePersistenceCommandException(System.Xml.Linq.XName commandName) { }
        public InstancePersistenceCommandException(System.Xml.Linq.XName commandName, System.Exception innerException) { }
        public InstancePersistenceCommandException(System.Xml.Linq.XName commandName, System.Guid instanceId) { }
        public InstancePersistenceCommandException(System.Xml.Linq.XName commandName, System.Guid instanceId, System.Exception innerException) { }
        public InstancePersistenceCommandException(System.Xml.Linq.XName commandName, System.Guid instanceId, string message, System.Exception innerException) { }
        public InstancePersistenceCommandException(System.Xml.Linq.XName commandName, string message, System.Exception innerException) { }
        public System.Guid InstanceId { get { throw null; } }
        [System.Security.SecurityCriticalAttribute]
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
    }
    public sealed partial class InstancePersistenceContext
    {
        internal InstancePersistenceContext() { }
        public System.Runtime.DurableInstancing.InstanceHandle InstanceHandle { get { throw null; } }
        public long InstanceVersion { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceView InstanceView { get { throw null; } }
        public System.Guid LockToken { get { throw null; } }
        public object UserContext { get { throw null; } }
        public void AssociatedInstanceKey(System.Guid key) { }
        public System.IAsyncResult BeginBindReclaimedLock(long instanceVersion, System.TimeSpan timeout, System.AsyncCallback callback, object state) { throw null; }
        public System.IAsyncResult BeginExecute(System.Runtime.DurableInstancing.InstancePersistenceCommand command, System.TimeSpan timeout, System.AsyncCallback callback, object state) { throw null; }
        public void BindAcquiredLock(long instanceVersion) { }
        public void BindEvent(System.Runtime.DurableInstancing.InstancePersistenceEvent persistenceEvent) { }
        public void BindInstance(System.Guid instanceId) { }
        public void BindInstanceOwner(System.Guid instanceOwnerId, System.Guid lockToken) { }
        public void BindReclaimedLock(long instanceVersion, System.TimeSpan timeout) { }
        public void CompletedInstance() { }
        public void CompletedInstanceKey(System.Guid key) { }
        public System.Exception CreateBindReclaimedLockException(long instanceVersion) { throw null; }
        public void EndBindReclaimedLock(System.IAsyncResult result) { }
        public void EndExecute(System.IAsyncResult result) { }
        public void Execute(System.Runtime.DurableInstancing.InstancePersistenceCommand command, System.TimeSpan timeout) { }
        public void LoadedInstance(System.Runtime.DurableInstancing.InstanceState state, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> instanceData, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> instanceMetadata, System.Collections.Generic.IDictionary<System.Guid, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue>> associatedInstanceKeyMetadata, System.Collections.Generic.IDictionary<System.Guid, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue>> completedInstanceKeyMetadata) { }
        public void PersistedInstance(System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> data) { }
        public void QueriedInstanceStore(System.Runtime.DurableInstancing.InstanceStoreQueryResult queryResult) { }
        public void ReadInstanceKeyMetadata(System.Guid key, System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> metadata, bool complete) { }
        public void ReadInstanceMetadata(System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> metadata, bool complete) { }
        public void ReadInstanceOwnerMetadata(System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> metadata, bool complete) { }
        public void SetCancellationHandler(System.Action<System.Runtime.DurableInstancing.InstancePersistenceContext> cancellationHandler) { }
        public void UnassociatedInstanceKey(System.Guid key) { }
        public void WroteInstanceKeyMetadataValue(System.Guid key, System.Xml.Linq.XName name, System.Runtime.DurableInstancing.InstanceValue value) { }
        public void WroteInstanceMetadataValue(System.Xml.Linq.XName name, System.Runtime.DurableInstancing.InstanceValue value) { }
        public void WroteInstanceOwnerMetadataValue(System.Xml.Linq.XName name, System.Runtime.DurableInstancing.InstanceValue value) { }
    }
    public abstract partial class InstancePersistenceEvent : System.IEquatable<System.Runtime.DurableInstancing.InstancePersistenceEvent>
    {
        internal InstancePersistenceEvent() { }
        public System.Xml.Linq.XName Name { get { throw null; } }
        public override bool Equals(object obj) { throw null; }
        public bool Equals(System.Runtime.DurableInstancing.InstancePersistenceEvent persistenceEvent) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(System.Runtime.DurableInstancing.InstancePersistenceEvent left, System.Runtime.DurableInstancing.InstancePersistenceEvent right) { throw null; }
        public static bool operator !=(System.Runtime.DurableInstancing.InstancePersistenceEvent left, System.Runtime.DurableInstancing.InstancePersistenceEvent right) { throw null; }
    }
    public abstract partial class InstancePersistenceEvent<T> : System.Runtime.DurableInstancing.InstancePersistenceEvent where T : System.Runtime.DurableInstancing.InstancePersistenceEvent<T>, new()
    {
        protected InstancePersistenceEvent(System.Xml.Linq.XName name) { }
        public static T Value { get { throw null; } }
    }
    [System.SerializableAttribute]
    public partial class InstancePersistenceException : System.Exception
    {
        public InstancePersistenceException() { }
        [System.Security.SecurityCriticalAttribute]
        protected InstancePersistenceException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public InstancePersistenceException(string message) { }
        public InstancePersistenceException(string message, System.Exception innerException) { }
        public InstancePersistenceException(System.Xml.Linq.XName commandName) { }
        public InstancePersistenceException(System.Xml.Linq.XName commandName, System.Exception innerException) { }
        public InstancePersistenceException(System.Xml.Linq.XName commandName, string message) { }
        public InstancePersistenceException(System.Xml.Linq.XName commandName, string message, System.Exception innerException) { }
        public System.Xml.Linq.XName CommandName { get { throw null; } }
        [System.Security.SecurityCriticalAttribute]
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
    }
    public enum InstanceState
    {
        Completed = 3,
        Initialized = 2,
        Uninitialized = 1,
        Unknown = 0,
    }
    public abstract partial class InstanceStore
    {
        protected InstanceStore() { }
        public System.Runtime.DurableInstancing.InstanceOwner DefaultInstanceOwner { get { throw null; } set { } }
        public System.IAsyncResult BeginExecute(System.Runtime.DurableInstancing.InstanceHandle handle, System.Runtime.DurableInstancing.InstancePersistenceCommand command, System.TimeSpan timeout, System.AsyncCallback callback, object state) { throw null; }
        protected internal virtual System.IAsyncResult BeginTryCommand(System.Runtime.DurableInstancing.InstancePersistenceContext context, System.Runtime.DurableInstancing.InstancePersistenceCommand command, System.TimeSpan timeout, System.AsyncCallback callback, object state) { throw null; }
        public System.IAsyncResult BeginWaitForEvents(System.Runtime.DurableInstancing.InstanceHandle handle, System.TimeSpan timeout, System.AsyncCallback callback, object state) { throw null; }
        public System.Runtime.DurableInstancing.InstanceHandle CreateInstanceHandle() { throw null; }
        public System.Runtime.DurableInstancing.InstanceHandle CreateInstanceHandle(System.Guid instanceId) { throw null; }
        public System.Runtime.DurableInstancing.InstanceHandle CreateInstanceHandle(System.Runtime.DurableInstancing.InstanceOwner owner) { throw null; }
        public System.Runtime.DurableInstancing.InstanceHandle CreateInstanceHandle(System.Runtime.DurableInstancing.InstanceOwner owner, System.Guid instanceId) { throw null; }
        public System.Runtime.DurableInstancing.InstanceView EndExecute(System.IAsyncResult result) { throw null; }
        protected internal virtual bool EndTryCommand(System.IAsyncResult result) { throw null; }
        public System.Collections.Generic.List<System.Runtime.DurableInstancing.InstancePersistenceEvent> EndWaitForEvents(System.IAsyncResult result) { throw null; }
        public System.Runtime.DurableInstancing.InstanceView Execute(System.Runtime.DurableInstancing.InstanceHandle handle, System.Runtime.DurableInstancing.InstancePersistenceCommand command, System.TimeSpan timeout) { throw null; }
        protected System.Runtime.DurableInstancing.InstancePersistenceEvent[] GetEvents(System.Runtime.DurableInstancing.InstanceOwner owner) { throw null; }
        protected System.Runtime.DurableInstancing.InstanceOwner[] GetInstanceOwners() { throw null; }
        protected virtual void OnFreeInstanceHandle(System.Runtime.DurableInstancing.InstanceHandle instanceHandle, object userContext) { }
        protected virtual object OnNewInstanceHandle(System.Runtime.DurableInstancing.InstanceHandle instanceHandle) { throw null; }
        protected void ResetEvent(System.Runtime.DurableInstancing.InstancePersistenceEvent persistenceEvent, System.Runtime.DurableInstancing.InstanceOwner owner) { }
        protected void SignalEvent(System.Runtime.DurableInstancing.InstancePersistenceEvent persistenceEvent, System.Runtime.DurableInstancing.InstanceOwner owner) { }
        protected internal virtual bool TryCommand(System.Runtime.DurableInstancing.InstancePersistenceContext context, System.Runtime.DurableInstancing.InstancePersistenceCommand command, System.TimeSpan timeout) { throw null; }
        public System.Collections.Generic.List<System.Runtime.DurableInstancing.InstancePersistenceEvent> WaitForEvents(System.Runtime.DurableInstancing.InstanceHandle handle, System.TimeSpan timeout) { throw null; }
    }
    public abstract partial class InstanceStoreQueryResult
    {
        protected InstanceStoreQueryResult() { }
    }
    [System.Runtime.Serialization.DataContractAttribute]
    public sealed partial class InstanceValue
    {
        public InstanceValue(object value) { }
        public InstanceValue(object value, System.Runtime.DurableInstancing.InstanceValueOptions options) { }
        public static System.Runtime.DurableInstancing.InstanceValue DeletedValue { get { throw null; } }
        public bool IsDeletedValue { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceValueOptions Options { get { throw null; } }
        public object Value { get { throw null; } }
    }
    [System.FlagsAttribute]
    public enum InstanceValueConsistency
    {
        InDoubt = 1,
        None = 0,
        Partial = 2,
    }
    [System.FlagsAttribute]
    [System.Runtime.Serialization.DataContractAttribute]
    public enum InstanceValueOptions
    {
        [System.Runtime.Serialization.EnumMemberAttribute]
        None = 0,
        [System.Runtime.Serialization.EnumMemberAttribute]
        Optional = 1,
        [System.Runtime.Serialization.EnumMemberAttribute]
        WriteOnly = 2,
    }
    public sealed partial class InstanceView
    {
        internal InstanceView() { }
        public System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> InstanceData { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceValueConsistency InstanceDataConsistency { get { throw null; } }
        public System.Guid InstanceId { get { throw null; } }
        public System.Collections.Generic.IDictionary<System.Guid, System.Runtime.DurableInstancing.InstanceKeyView> InstanceKeys { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceValueConsistency InstanceKeysConsistency { get { throw null; } }
        public System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> InstanceMetadata { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceValueConsistency InstanceMetadataConsistency { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceOwner InstanceOwner { get { throw null; } }
        public System.Collections.Generic.IDictionary<System.Xml.Linq.XName, System.Runtime.DurableInstancing.InstanceValue> InstanceOwnerMetadata { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceValueConsistency InstanceOwnerMetadataConsistency { get { throw null; } }
        public System.Runtime.DurableInstancing.InstanceState InstanceState { get { throw null; } }
        public System.Collections.ObjectModel.ReadOnlyCollection<System.Runtime.DurableInstancing.InstanceStoreQueryResult> InstanceStoreQueryResults { get { throw null; } }
        public bool IsBoundToInstance { get { throw null; } }
        public bool IsBoundToInstanceOwner { get { throw null; } }
        public bool IsBoundToLock { get { throw null; } }
    }
}
