/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GribAddressMode.h
    \brief Definition of the Template class GribAddressMode.
    
    Magics Team - ECMWF 2006
    
    Started: Mon 13-Feb-2006
    
    Changes:
    
*/

#ifndef GribAddressMode_H
#define GribAddressMode_H

#include "magics.h"
#include "MagTranslator.h"
#include "Factory.h"

#include "grib_api.h"


namespace magics {

class XmlNode;

class GribAddressMode {

public:
	GribAddressMode() {}
	virtual ~GribAddressMode() {}
    
    virtual void set(const XmlNode&) {
		
    }
    virtual void set(const map<string, string>&) {
    }
    
     virtual bool accept(const string&) { return false; }
    
    virtual GribAddressMode* clone() const {
        MagLog::dev() << "GribAddressMode::set(const map<string, string&)---> to be checked!...\n";
        return new GribAddressMode();
    }
    virtual void toxml(ostream&, int = 0) const {
        MagLog::dev() << "GribAddressMode::toxml(ostream&, int = 0)---> to be checked!...\n";
    }
    virtual grib_handle* operator()(grib_context*, FILE*, int) const {
        MagLog::dev() << "GribAddressMode::toxml(ostream&, int = 0)---> to be checked!...\n";
        return 0;
    }
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const { out << "GribAddressMode\n"; } 

private:
    //! Copy constructor - No copy allowed
	GribAddressMode(const GribAddressMode&);
    //! Overloaded << operator to copy - No copy allowed
	GribAddressMode& operator=(const GribAddressMode&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const GribAddressMode& p)
		{ p.print(s); return s; }

};

class GribAddressRecordMode : public GribAddressMode
{
public :
	GribAddressRecordMode() {}
	~GribAddressRecordMode() {}

	virtual GribAddressMode* clone() const {
		GribAddressMode* mode = new GribAddressRecordMode();
		return mode;
	}

	virtual grib_handle* operator()(grib_context* context, FILE* file, int position) const
	{
		grib_handle* handle = 0;


		int error;
		for (int i = 0; i < position-1; i++)
		{
			//MagLog::debug() << "call to grib_handle_new_from_file for position " << i << "\n";
			handle = grib_handle_new_from_file(context, file, &error) ; 
			grib_handle_delete(handle);
		}
		handle = grib_handle_new_from_file(context, file, &error) ; 
		//grib_handle_delete(handle);

		return handle;
	}
    
protected :
	void print(ostream& out) const { out << "GribAddressRecordMode\n"; }
};

class GribAddressByteMode : public GribAddressMode
{
public:
	GribAddressByteMode() {}
	~GribAddressByteMode() {}
	virtual GribAddressMode* clone() const {
		GribAddressMode* mode = new GribAddressByteMode();
		return mode;
	}
	
	virtual grib_handle* operator()(grib_context* context, FILE* file, int position) const
	{
		fseek(file, position, SEEK_SET);
        grib_handle* handle = 0;

		int error;
		handle = grib_handle_new_from_file(context, file, &error) ;
         return handle;
           
    }
    
protected :
    void print(ostream& out) const { out << "GribAddressRecordMode\n"; } 
    
};



template <>
class MagTranslator<string, GribAddressMode> { 
public:
	GribAddressMode* operator()(const string& val )
	{
		return SimpleObjectMaker<GribAddressMode>::create(val);
	}     

	GribAddressMode* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}

};

} // namespace magics
#endif
