/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

/** An utility class providing default implementation of usefull actions for pop-up
 * menus in tab container selectors.
 *<p>
 *
 * @author Lilian Chamontin, VLSolutions
 *
 *@update 2005/10/07 Lilian Chamontin : added the attach action for floating tabs
 */
public class TabbedContainerActions {
  // label resources taken from BasicInternalFrameUI...
  private static final String CLOSE_TEXT = UIManager.getString("DockTabbedPane.closeButtonText");
  private static final String ICONIFY_TEXT = UIManager.getString("DockTabbedPane.minimizeButtonText");
  private static final String RESTORE_TEXT = UIManager.getString("DockTabbedPane.restoreButtonText");
  private static final String MAXIMIZE_TEXT = UIManager.getString("DockTabbedPane.maximizeButtonText");
  private static final String FLOAT_TEXT = UIManager.getString("DockTabbedPane.floatButtonText");
  private static final String ATTACH_TEXT = UIManager.getString("DockTabbedPane.attachButtonText");

  private static final Icon CLOSE_ICON = UIManager.getIcon("DockTabbedPane.menu.close");
  private static final Icon CLOSE_ALL_ICON = UIManager.getIcon("DockTabbedPane.closeAll");
  private static final Icon CLOSE_OTHER_ICON = UIManager.getIcon("DockTabbedPane.closeAllOther");
  private static final Icon ICONIFY_ICON = UIManager.getIcon("DockTabbedPane.menu.hide");
  private static final Icon MAXIMIZE_ICON = UIManager.getIcon("DockTabbedPane.menu.maximize");
  private static final Icon FLOAT_ICON = UIManager.getIcon("DockTabbedPane.menu.float");
  private static final Icon ATTACH_ICON = UIManager.getIcon("DockTabbedPane.menu.attach");

  private TabbedContainerActions() {
  }

  /** returns an action suitable for closing a dockable contained in a tab.
   *<p> 
   * Action properties : The icon is provided, and also the standard localized "close" message.
   */
  public static Action createCloseAction(final Dockable dockable, final DockingDesktop desktop){
    
    AbstractAction action = new AbstractAction(CLOSE_TEXT){
      public void actionPerformed(ActionEvent e){
          desktop.close(dockable);        
      }
    };
    action.putValue(AbstractAction.SMALL_ICON, CLOSE_ICON);    
    KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.closeActionAccelerator");
    if (ks != null){
      action.putValue(AbstractAction.ACCELERATOR_KEY, ks);    
    }
    
    return action;
  }

  /** returns an action suitable for closing every dockable contained in a tab.
   *<p>
   * Action properties : The icon is provided, and also an unlocalized "Close all documents" message.
   */
  public static Action createCloseAllAction(final Dockable base, final DockingDesktop desktop){
    
    AbstractAction action = new AbstractAction("Close all documents"){
      public void actionPerformed(ActionEvent e){
          desktop.closeAllDockablesInTab(base);        
      }
    };
    action.putValue(AbstractAction.SMALL_ICON, CLOSE_ALL_ICON);    
    
    return action;
  }

  /** returns an action suitable for closing every dockable contained in a tab excepted the current one.
   *<p>
   * Action properties : The icon is provided, and also an unlocalized "Close all other documents" message.
   */
  public static Action createCloseAllOtherAction(final Dockable exception, final DockingDesktop desktop){
    
    AbstractAction action = new AbstractAction("Close all other documents"){
      public void actionPerformed(ActionEvent e){
          desktop.closeAllOtherDockablesInTab(exception);        
      }
    };
    action.putValue(AbstractAction.SMALL_ICON, CLOSE_OTHER_ICON);    
    
    return action;
  }

  /** returns an action suitable for maximizing a dockable contained in a tab.
   *<p>
   * Action properties : The icon is provided, and also a localized "Maximize" message.
   */
  public static Action createMaximizeTabAction(final Dockable dockable, final DockingDesktop desktop){
    
    AbstractAction action = new AbstractAction(MAXIMIZE_TEXT){
      public void actionPerformed(ActionEvent e){
          desktop.maximize(dockable);        
      }
    };
    action.putValue(AbstractAction.SMALL_ICON, MAXIMIZE_ICON);    
    KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.maximizeActionAccelerator");
    if (ks != null){
      action.putValue(AbstractAction.ACCELERATOR_KEY, ks);    
    }
    
    return action;
  }

  /** returns an action suitable for hiding a dockable contained in a tab.
   *<p>
   * Action properties : The icon is provided, and also a localized "Iconify" message.
   */
  public static Action createHideTabAction(final Dockable dockable, final DockingDesktop desktop){
    
    AbstractAction action = new AbstractAction(ICONIFY_TEXT){
      public void actionPerformed(ActionEvent e){
          desktop.setAutoHide(dockable, true);        
      }
    };
    action.putValue(AbstractAction.SMALL_ICON, ICONIFY_ICON);    
    KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.dockActionAccelerator");
    if (ks != null){
      action.putValue(AbstractAction.ACCELERATOR_KEY, ks);    
    }

    return action;
  }

  /** returns an action suitable for floating (detach) a dockable contained in a tab.
   *<p>
   * Action properties : The icon is provided, and a default "Detach" message.
   */
  public static Action createFloatTabAction(final Dockable dockable, final DockingDesktop desktop){
    
    AbstractAction action = new AbstractAction(FLOAT_TEXT){
      public void actionPerformed(ActionEvent e){
          desktop.setFloating(dockable, true);        
      }
    };
    action.putValue(AbstractAction.SMALL_ICON, FLOAT_ICON);    
    KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator");
    if (ks != null){
      action.putValue(AbstractAction.ACCELERATOR_KEY, ks);    
    }
    
    return action;
  }

  /** returns an action suitable for attaching a dockable contained in a floating tab.
   *<p>
   * Action properties : The icon is provided, and a default "Attach" message.
   * @since 2.0.1
   */
  public static Action createAttachTabAction(final Dockable dockable, final DockingDesktop desktop){
    
    AbstractAction action = new AbstractAction(ATTACH_TEXT){
      public void actionPerformed(ActionEvent e){
          desktop.setFloating(dockable, false);        
      }
    };
    action.putValue(AbstractAction.SMALL_ICON, ATTACH_ICON);    
    KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator");
    if (ks != null){
      action.putValue(AbstractAction.ACCELERATOR_KEY, ks);    
    }
    
    return action;
  }
  
  
}
