/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.GeneralNameInterface;

public class OIDName
implements GeneralNameInterface {
    private ObjectIdentifier oid;

    public OIDName(DerValue derValue) throws IOException {
        this.oid = derValue.getOID();
    }

    public OIDName(ObjectIdentifier objectIdentifier) {
        this.oid = objectIdentifier;
    }

    public OIDName(String string) throws IOException {
        try {
            this.oid = new ObjectIdentifier(string);
        }
        catch (Exception exception) {
            throw new IOException("Unable to create OIDName: " + exception);
        }
    }

    public int getType() {
        return 8;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOID(this.oid);
    }

    public String toString() {
        return "OIDName: " + this.oid.toString();
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OIDName)) {
            return false;
        }
        OIDName oIDName = (OIDName)object;
        return this.oid.equals(oIDName.oid);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        if (generalNameInterface == null) {
            n = -1;
        } else if (generalNameInterface.getType() != 8) {
            n = -1;
        } else if (this.equals((OIDName)generalNameInterface)) {
            n = 0;
        } else {
            throw new UnsupportedOperationException("Narrowing and widening are not supported for OIDNames");
        }
        return n;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for OIDName.");
    }
}

