#if   !defined(__RESTORECASECOMMAND_HPP)
#define  __RESTORECASECOMMAND_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__COMMAND_HPP)
#include <corelinux/Command.hpp>
#endif

/**
RestoreCaseCommand restores the original string
*/

DECLARE_CLASS( RestoreCaseCommand );

class RestoreCaseCommand : public CORELINUX(Command)
{

public:

   //
   // Constructors and destructors
   //

                     /// Default takes string argument

                     RestoreCaseCommand( void );

                     /// Virtual Destructor

   virtual           ~RestoreCaseCommand( void );

   //
   // Operator overloads
   //
            /// Equality operator

            bool operator==( RestoreCaseCommandCref ) const;

   //
   // Accessors
   //

   //
   // Mutators
   //
            /**
            Set the value locations to correct
            @param string the original value location
            @param string the location to restore to
            @exception Assertion if either is NULLPTR
            */

            void  setValues( std::string **, std::string ** )
               throw ( CORELINUX( Assertion ) );
   //
   // Methods supplied as per command interface
   //

   virtual  void  execute( void ) ;

protected:

                     /// Copy constructor is no good!

                     RestoreCaseCommand( RestoreCaseCommandCref )
                        throw ( CORELINUX( Assertion ) );

                     /// Assignment operator no good

            RestoreCaseCommandRef  operator=( RestoreCaseCommandCref )
               throw ( CORELINUX( Assertion ) );


private:

            std::string **theOriginalValue;
            std::string **theRestoredValue;

};

#endif // if !defined(__RESTORECASECOMMAND_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/04 05:41:59 $
   $Locker:  $
*/



