// 
//  Lynkeos
//  $Id: MyUserPrefsController.h,v 1.5 2005/02/01 22:55:44 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Sun Feb 8 2004.
//  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// This class is a singleton object controlling the user preferences window
#ifndef __MYUSERPREFSCONTROLLER_H
#define __MYUSERPREFSCONTROLLER_H

#ifdef GNUSTEP
#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "LynkeosCommon.h"
#else
#import <Cocoa/Cocoa.h>
#endif


// Preferences keys
#define K_PREF_ADJUST_FFT_SIZES @"Adjust FFT sizes"
#define K_PREF_ALIGN_FREQUENCY_CUTOFF @"Align frequency cutoff"
#define K_PREF_ALIGN_PRECISION_THRESHOLD @"Align precision threshold"
#define K_PREF_ALIGN_IMAGE_UPDATING @"Align image updating"
#define K_PREF_ALIGN_MULTIPROC @"Multiprocessor align"
#define K_PREF_ANALYSIS_LOWER_CUTOFF @"Analysis lower cutoff"
#define K_PREF_ANALYSIS_UPPER_CUTOFF @"Analysis upper cutoff"
#define K_PREF_ANALYSIS_IMAGE_UPDATING @"Analysis image updating"
#define K_PREF_ANALYSIS_MULTIPROC @"Multiprocessor analysis"
#define K_PREF_STACK_IMAGE_UPDATING @"Stack image updating"
#define K_PREF_STACK_MULTIPROC @"Multiprocessor stack"
#define K_PREF_PROCESS_MULTIPROC @"Multiprocessor processing"

// Types
typedef enum
{
   NoParallelOptimization = 0,
   FFTW3ThreadsOptimization,
   ListThreadsOptimizations
} ParalelOptimization_t;

@interface MyUserPrefsController : NSObject
{
@private
   // GUI controls
   IBOutlet NSPanel*          _panel;
   IBOutlet NSButton*         _adjustFFTSizesButton;
   IBOutlet NSPopUpButton*    _soundPopup;
   IBOutlet NSSlider*         _alignFrequencyCutoffSlider;
   IBOutlet NSTextField*      _alignFrequencyCutoffText;
   IBOutlet NSSlider*         _alignThresholdSlider;
   IBOutlet NSTextField*      _alignThresholdText;
   IBOutlet NSButton*         _alignImageUpdatingButton;
   IBOutlet NSPopUpButton*    _alignMultiProcPopup;
   IBOutlet NSSlider*         _analysisLowerCutoffSlider;
   IBOutlet NSTextField*      _analysisLowerCutoffText;
   IBOutlet NSSlider*         _analysisUpperCutoffSlider;
   IBOutlet NSTextField*      _analysisUpperCutoffText;
   IBOutlet NSButton*         _analysisImageUpdatingButton;
   IBOutlet NSPopUpButton*    _analysisMultiProcPopup;
   IBOutlet NSButton*         _stackImageUpdatingButton;
   IBOutlet NSPopUpButton*    _stackMultiProcPopup;
   IBOutlet NSPopUpButton*    _processMultiProcPopup;

   // Internals
   NSUserDefaults*            _user;

   // Preferences
   bool                       _adjustFFTSizes;
   double                     _alignFrequencyCutoff;
   double                     _alignThreshold;
   bool                       _alignImageUpdating;
   ParalelOptimization_t      _alignMultiProc;
   double                     _analysisLowerCutoff;
   double                     _analysisUpperCutoff;
   bool                       _analysisImageUpdating;
   ParalelOptimization_t      _analysisMultiProc;
   bool                       _stackImageUpdating;
   bool                       _stackMultiProc;
   bool                       _processMultiProc;
}

// Accessors
+ (MyUserPrefsController*) getUserPref ;

+ (bool) adjustFFTSizes;
+ (double) alignFrequencyCutoff;
+ (double) alignThreshold;
+ (bool) alignImageUpdating;
+ (ParalelOptimization_t) alignMultiProc;
+ (double) analysisLowerCutoff;
+ (double) analysisUpperCutoff;
+ (bool) analysisImageUpdating;
+ (ParalelOptimization_t) analysisMultiProc;
+ (bool) stackImageUpdating;
+ (bool) stackMultiProc;
+ (bool) processMultiProc;


// GUI actions
- (IBAction)changeAdjustFFTSizes:(id)sender;
- (IBAction)changeEndProcessingSound:(id)sender;
- (IBAction)changeAlignFrequencyCutoff:(id)sender;
- (IBAction)changeAlignThreshold:(id)sender;
- (IBAction)changeAlignImageUpdating:(id)sender;
- (IBAction)changeAlignMultiProc:(id)sender;
- (IBAction)changeAnalysisLowerCutoff:(id)sender;
- (IBAction)changeAnalysisUpperCutoff:(id)sender;
- (IBAction)changeAnalysisImageUpdating:(id)sender;
- (IBAction)changeAnalysisMultiProc:(id)sender;
- (IBAction)changeStackImageUpdating:(id)sender;
- (IBAction)changeStackMultiProc:(id)sender;
- (IBAction)changeProcessMultiProc:(id)sender;

- (IBAction)resetPrefs:(id)sender;
- (IBAction)applyChanges:(id)sender;
- (IBAction)cancelChanges:(id)sender;
- (IBAction)confirmChanges:(id)sender;

- (IBAction) showPrefs:(id)sender;
@end

#endif
