// Code generated by smithy-go-codegen DO NOT EDIT.

package nimble

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/nimble/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all the launch profiles a studio.
func (c *Client) ListLaunchProfiles(ctx context.Context, params *ListLaunchProfilesInput, optFns ...func(*Options)) (*ListLaunchProfilesOutput, error) {
	if params == nil {
		params = &ListLaunchProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLaunchProfiles", params, optFns, c.addOperationListLaunchProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLaunchProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLaunchProfilesInput struct {

	// The studio ID.
	//
	// This member is required.
	StudioId *string

	// The max number of results to return in the response.
	MaxResults *int32

	// The token for the next set of results, or null if there are no more results.
	NextToken *string

	// The principal ID. This currently supports a IAM Identity Center UserId.
	PrincipalId *string

	// Filter this request to launch profiles in any of the given states.
	States []types.LaunchProfileState

	noSmithyDocumentSerde
}

type ListLaunchProfilesOutput struct {

	// A collection of launch profiles.
	LaunchProfiles []types.LaunchProfile

	// The token for the next set of results, or null if there are no more results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLaunchProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListLaunchProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListLaunchProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLaunchProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListLaunchProfilesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLaunchProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListLaunchProfilesAPIClient is a client that implements the ListLaunchProfiles
// operation.
type ListLaunchProfilesAPIClient interface {
	ListLaunchProfiles(context.Context, *ListLaunchProfilesInput, ...func(*Options)) (*ListLaunchProfilesOutput, error)
}

var _ ListLaunchProfilesAPIClient = (*Client)(nil)

// ListLaunchProfilesPaginatorOptions is the paginator options for
// ListLaunchProfiles
type ListLaunchProfilesPaginatorOptions struct {
	// The max number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLaunchProfilesPaginator is a paginator for ListLaunchProfiles
type ListLaunchProfilesPaginator struct {
	options   ListLaunchProfilesPaginatorOptions
	client    ListLaunchProfilesAPIClient
	params    *ListLaunchProfilesInput
	nextToken *string
	firstPage bool
}

// NewListLaunchProfilesPaginator returns a new ListLaunchProfilesPaginator
func NewListLaunchProfilesPaginator(client ListLaunchProfilesAPIClient, params *ListLaunchProfilesInput, optFns ...func(*ListLaunchProfilesPaginatorOptions)) *ListLaunchProfilesPaginator {
	if params == nil {
		params = &ListLaunchProfilesInput{}
	}

	options := ListLaunchProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLaunchProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLaunchProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLaunchProfiles page.
func (p *ListLaunchProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLaunchProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListLaunchProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListLaunchProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLaunchProfiles",
	}
}
