/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.basic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleJavaNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokenNullCheck
extends AbstractRule {
    @Override
    public Object visit(ASTIfStatement node, Object data) {
        ASTConditionalOrExpression conditionalOrExpression;
        ASTExpression expression = (ASTExpression)node.jjtGetChild(0);
        ASTConditionalAndExpression conditionalAndExpression = expression.getFirstChildOfType(ASTConditionalAndExpression.class);
        if (conditionalAndExpression != null) {
            this.checkForViolations(node, data, conditionalAndExpression);
        }
        if ((conditionalOrExpression = expression.getFirstChildOfType(ASTConditionalOrExpression.class)) != null) {
            this.checkForViolations(node, data, conditionalOrExpression);
        }
        return super.visit(node, data);
    }

    private void checkForViolations(ASTIfStatement node, Object data, SimpleJavaNode conditionalExpression) {
        ASTEqualityExpression equalityExpression = this.getFirstDirectChildOfType(ASTEqualityExpression.class, conditionalExpression);
        if (equalityExpression == null) {
            return;
        }
        if (conditionalExpression instanceof ASTConditionalAndExpression && !"==".equals(equalityExpression.getImage())) {
            return;
        }
        if (conditionalExpression instanceof ASTConditionalOrExpression && !"!=".equals(equalityExpression.getImage())) {
            return;
        }
        ASTNullLiteral nullLiteral = equalityExpression.getFirstChildOfType(ASTNullLiteral.class);
        if (nullLiteral == null) {
            return;
        }
        if (conditionalExpression.getFirstChildOfType(ASTAssignmentOperator.class) != null) {
            return;
        }
        ASTPrimaryExpression nullCompareExpression = this.findNullCompareExpression(equalityExpression);
        if (nullCompareExpression == null) {
            return;
        }
        for (int i = 0; i < conditionalExpression.jjtGetNumChildren(); ++i) {
            ASTPrimaryExpression conditionalPrimaryExpression;
            ASTEqualityExpression nullEqualityExpression;
            SimpleJavaNode conditionalSubnode = (SimpleJavaNode)conditionalExpression.jjtGetChild(i);
            if (conditionalSubnode.equals(nullEqualityExpression = nullLiteral.getFirstParentOfType(ASTEqualityExpression.class)) || !this.primaryExpressionsAreEqual(nullCompareExpression, conditionalPrimaryExpression = conditionalSubnode instanceof ASTPrimaryExpression ? (ASTPrimaryExpression)conditionalSubnode : conditionalSubnode.getFirstChildOfType(ASTPrimaryExpression.class))) continue;
            this.addViolation(data, node);
        }
    }

    private boolean primaryExpressionsAreEqual(ASTPrimaryExpression nullCompareVariable, ASTPrimaryExpression expressionUsage) {
        ArrayList<String> nullCompareNames = new ArrayList<String>();
        this.findExpressionNames(nullCompareVariable, nullCompareNames);
        ArrayList<String> expressionUsageNames = new ArrayList<String>();
        this.findExpressionNames(expressionUsage, expressionUsageNames);
        for (int i = 0; i < nullCompareNames.size(); ++i) {
            String expressionUsageName;
            if (expressionUsageNames.size() == i) {
                return false;
            }
            String nullCompareExpressionName = (String)nullCompareNames.get(i);
            if (nullCompareExpressionName.equals(expressionUsageName = (String)expressionUsageNames.get(i)) || expressionUsageName.startsWith(nullCompareExpressionName + ".")) continue;
            return false;
        }
        return true;
    }

    private void findExpressionNames(Node nullCompareVariable, List<String> results) {
        for (int i = 0; i < nullCompareVariable.jjtGetNumChildren(); ++i) {
            String name;
            Node child = nullCompareVariable.jjtGetChild(i);
            if (child.getClass().equals(ASTName.class)) {
                results.add(((ASTName)child).getImage());
            } else if (child.getClass().equals(ASTLiteral.class)) {
                String literalImage = ((ASTLiteral)child).getImage();
                if (literalImage != null) {
                    results.add(literalImage);
                }
            } else if (child.getClass().equals(ASTPrimarySuffix.class)) {
                name = ((ASTPrimarySuffix)child).getImage();
                if (name != null && !name.equals("")) {
                    results.add(name);
                }
            } else if (child.getClass().equals(ASTClassOrInterfaceType.class)) {
                name = ((ASTClassOrInterfaceType)child).getImage();
                results.add(name);
            }
            if (child.jjtGetNumChildren() <= 0) continue;
            this.findExpressionNames(child, results);
        }
    }

    private ASTPrimaryExpression findNullCompareExpression(ASTEqualityExpression equalityExpression) {
        List<ASTPrimaryExpression> primaryExpressions = equalityExpression.findChildrenOfType(ASTPrimaryExpression.class);
        for (ASTPrimaryExpression primaryExpression : primaryExpressions) {
            List<ASTPrimaryPrefix> primaryPrefixes = primaryExpression.findChildrenOfType(ASTPrimaryPrefix.class);
            for (ASTPrimaryPrefix primaryPrefix : primaryPrefixes) {
                ASTName name = primaryPrefix.getFirstChildOfType(ASTName.class);
                if (name == null) continue;
                return primaryExpression;
            }
        }
        return null;
    }

    private <T> T getFirstDirectChildOfType(Class<T> childType, Node node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleJavaNode simpleNode = (SimpleJavaNode)node.jjtGetChild(i);
            if (!simpleNode.getClass().equals(childType)) continue;
            return (T)simpleNode;
        }
        return null;
    }
}

