/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"
#include "opt.h"
#include "proto.h"

#include <cstdio>
#include <cstdlib>
#include <cstring>

typedef struct proto_t {
  const char *name;
  proto_start_t start;
  proto_open_t open;
  struct proto_t *next;
} proto_t;


static proto_t *protocols = 0;
static proto_start_t selected_start = 0;
static proto_open_t selected_open = 0;

void
proto_register (const char *name, proto_start_t start, proto_open_t open)
{
  proto_t *p = new proto_t;

  p->name = name;
  p->start = start;
  p->open = open;
  p->next = protocols;
  protocols = p;
}

void
proto_select (const char *name)
{
  proto_t *p = protocols;

  while (p) {
    if (strcasecmp (name, p->name) == 0) {
      selected_start = p->start;
      selected_open = p->open;
      return;
    }

    p = p->next;
  }

  fprintf (stderr, "%s: invalid protocol module '%s'\n",
           opt_program, name);
  exit (EXIT_FAILURE);
}

bool
proto_start (subnets& n)
{
  return selected_start (n);
}

void
proto_open (struct scan_host_t *s)
{
  selected_open (s);
}

/* arch-tag: d99526b8-edfd-49d5-9e19-7784d538b220
 */
