define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/dom-class",
	"dojo/dom-construct",
	"./iconUtils",
	"dojo/has",
	"dojo/has!dojo-bidi?dojox/mobile/bidi/Badge"
], function(declare, lang, domClass, domConstruct, iconUtils, has, BidiBadge){
	// module:
	//		dojox/mobile/Badge

	var Badge = declare(has("dojo-bidi") ? "dojox.mobile.NonBidiBadge" : "dojox.mobile.Badge", null, {
		// summary:
		//		A utility class to create and update a badge node.
		// description:
		//		Badge is not a widget, but a simple utility class for creating and 
		//		updating a badge node. A badge consists of a simple DOM button. 
		//		It is intended to be used from other widgets such as dojox/mobile/IconItem 
		//		or dojox/mobile/TabBarButton.

		// value: [const] String
		//		A text to show in a badge.
		//		Note that changing the value of the property after the badge
		//		creation has no effect.
		value: "0",

		// className: [const] String
		//		A CSS class name of a DOM button.
		className: "mblDomButtonRedBadge",

		// fontSize: [const] Number
		//		Font size in pixel. The other style attributes are determined by the DOM
		//		button itself.
		//		Note that changing the value of the property after the badge
		//		creation has no effect.
		fontSize: 16, // [px]

		constructor: function(/*Object?*/params, /*DomNode?*/node){
			// summary:
			//		Creates a new instance of the class.
			// params:
			//		Contains properties to be set.
			// node:
			//		The DOM node. If none is specified, it is automatically created. 
			if (params){
				lang.mixin(this, params);
			}
			this.domNode = node ? node : domConstruct.create("div");
			domClass.add(this.domNode, "mblBadge");
			if(this.domNode.className.indexOf("mblDomButton") === -1){
				domClass.add(this.domNode, this.className);
			}
			if(this.fontSize !== 16){
				this.domNode.style.fontSize = this.fontSize + "px";
			}
			iconUtils.createDomButton(this.domNode);
			this.setValue(this.value);
		},

		getValue: function(){
			// summary:
			//		Returns the text shown in the badge.
			return this.domNode.firstChild.innerHTML || "";
		},

		setValue: function(/*String*/value){
			// summary:
			//		Set a label text to the badge.
			this.domNode.firstChild.innerHTML = value;
		}
	});

	return has("dojo-bidi") ? declare("dojox.mobile.Badge", [Badge, BidiBadge]) : Badge;
});
