/*
 *  userfiledialog.h
 *  ui
 *
 *  Created by Mikael Gransell on 4/13/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */


#ifndef USER_FILE_DIALOG_H
#define USER_FILE_DIALOG_H

#include <boost/shared_ptr.hpp>

#include <QDialog>

#include "backendconnection.h"
#include "userfilemodel.h"
#include "ui_userfilelisting.h"

class GlobalUserModel;

class UserFileDialog : public QDialog
{
	Q_OBJECT
public:
	UserFileDialog( const UserFileModelPtr& mdl,
					BackendConnectionPtr backendConn,
					boost::shared_ptr<GlobalUserModel> userModel,
					QWidget* parent = NULL );
	~UserFileDialog() {	}
	
public slots:
	void on_treeView_customContextMenuRequested( const QPoint& pos );
	void on_treeView_doubleClicked();
	void onDownload();
	void onDownloadTo();
	
private:
	void download( const QModelIndex& index );
	void downloadTo( const QModelIndex& index, const QString& path );
	
	QString formatFileName( const UserFileModel::TreeItem* item ) const;
	
	void createMenu();
	
	boost::shared_ptr<QMenu> contextMenu;

	Ui::UserFileDialog ui;
	BackendConnectionPtr backendConnection;
	UserFileModelPtr model;
};

#endif
