package definitions

func init() {
	add(`ConnectionInformation`, &defConnectionInformation{})
}

type defConnectionInformation struct{}

func (*defConnectionInformation) String() string {
	return `<interface>
  <object class="GtkDialog" id="ConnectionInformation">
    <property name="title" translatable="yes">Connection Information</property>
    <signal name="close" handler="on_close_signal" />
    <child internal-child="vbox">
      <object class="GtkBox" id="Vbox">
        <property name="margin">10</property>

        <child>
          <object class="GtkGrid" id="connectionInfoGrid">
            <property name="margin-top">2</property>
            <property name="margin-bottom">10</property>
            <property name="margin-start">10</property>
            <property name="margin-end">10</property>
            <property name="row-spacing">2</property>
            <property name="column-spacing">12</property>
            <child>
              <object class="GtkLabel" id="serverLabel">
                <property name="label" translatable="yes">Server connected to:</property>
                <property name="halign">GTK_ALIGN_START</property>
                <property name="justify">GTK_JUSTIFY_LEFT</property>
                <property name="selectable">TRUE</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">0</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="serverValue">
                <property name="label" translatable="yes"></property>
                <property name="halign">GTK_ALIGN_START</property>
                <property name="justify">GTK_JUSTIFY_LEFT</property>
                <property name="selectable">TRUE</property>
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">0</property>
              </packing>
            </child>

            <child>
              <object class="GtkLabel" id="tlsVersionLabel">
                <property name="label" translatable="yes">Secure connection version:</property>
                <property name="halign">GTK_ALIGN_START</property>
                <property name="justify">GTK_JUSTIFY_LEFT</property>
                <property name="selectable">TRUE</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">1</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="tlsVersionValue">
                <property name="label" translatable="yes"></property>
                <property name="halign">GTK_ALIGN_START</property>
                <property name="justify">GTK_JUSTIFY_LEFT</property>
                <property name="selectable">TRUE</property>
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">1</property>
              </packing>
            </child>

            <child>
              <object class="GtkLabel" id="tlsAlgoLabel">
                <property name="label" translatable="yes">Secure connection algorithm:</property>
                <property name="halign">GTK_ALIGN_START</property>
                <property name="justify">GTK_JUSTIFY_LEFT</property>
                <property name="selectable">TRUE</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">2</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="tlsAlgoValue">
                <property name="label" translatable="yes"></property>
                <property name="halign">GTK_ALIGN_START</property>
                <property name="justify">GTK_JUSTIFY_LEFT</property>
                <property name="selectable">TRUE</property>
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">2</property>
              </packing>
            </child>

            <child>
              <object class="GtkLabel" id="tlsFingerprintLabel">
                <property name="label" translatable="yes">Secure connection fingerprint:</property>
                <property name="valign">GTK_ALIGN_START</property>
                <property name="halign">GTK_ALIGN_START</property>
                <property name="justify">GTK_JUSTIFY_LEFT</property>
                <property name="selectable">TRUE</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">3</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="tlsFingerprintValue">
                <property name="label" translatable="yes"></property>
                <property name="halign">GTK_ALIGN_START</property>
                <property name="justify">GTK_JUSTIFY_LEFT</property>
                <property name="selectable">TRUE</property>
                <attributes>
                  <attribute name="font-desc" value="Monospace"/>
                </attributes>
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">3</property>
              </packing>
            </child>

            <child>
              <object class="GtkButton" id="pin-cert">
                <property name="label" translatable="yes">Pin certificate</property>
                <signal name="clicked" handler="on_pin_signal"/>
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">4</property>
              </packing>
            </child>
          </object>
        </child>
      </object>
    </child>
    
    <child internal-child="action_area">
      <object class="GtkButtonBox" id="button_box">
        <property name="orientation">GTK_ORIENTATION_HORIZONTAL</property>
        <child>
          <object class="GtkButton" id="close">
            <property name="label" translatable="yes">Close</property>
            <signal name="clicked" handler="on_close_signal"/>
          </object>
        </child>
      </object>
    </child>
  </object>
</interface>
`
}
