/* ramachandran.cpp: ramachandran plot class */
//C Copyright (C) 2000-2006 Kevin Cowtan and University of York
//L
//L  This library is free software and is distributed under the terms
//L  and conditions of version 2.1 of the GNU Lesser General Public
//L  Licence (LGPL) with the following additional clause:
//L
//L     `You may also combine or link a "work that uses the Library" to
//L     produce a work containing portions of the Library, and distribute
//L     that work under terms of your choice, provided that you give
//L     prominent notice with each copy of the work that the specified
//L     version of the Library is used in it, and that you include or
//L     provide public access to the complete corresponding
//L     machine-readable source code for the Library including whatever
//L     changes were used in the work. (i.e. If you make changes to the
//L     Library you must distribute those, but you do not need to
//L     distribute source or object code to those portions of the work
//L     not covered by this licence.)'
//L
//L  Note that this clause grants an additional right and does not impose
//L  any additional restriction, and so does not affect compatibility
//L  with the GNU General Public Licence (GPL). If you wish to negotiate
//L  other terms, please contact the maintainer.
//L
//L  You can redistribute it and/or modify the library under the terms of
//L  the GNU Lesser General Public License as published by the Free Software
//L  Foundation; either version 2.1 of the License, or (at your option) any
//L  later version.
//L
//L  This library is distributed in the hope that it will be useful, but
//L  WITHOUT ANY WARRANTY; without even the implied warranty of
//L  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//L  Lesser General Public License for more details.
//L
//L  You should have received a copy of the CCP4 licence and/or GNU
//L  Lesser General Public License along with this library; if not, write
//L  to the CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
//L  The GNU Lesser General Public can also be obtained by writing to the
//L  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
//L  MA 02111-1307 USA


#include "ramachandran.h"


namespace clipper {

namespace data {

  int rama_data_size = 36;
  ftype32 rama_gly[] = {
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     1,    9,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 0
     0,    0,    0,    0,    0,    0,    0,    7,    1,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1,    7,
     0,    2,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 1
     0,    0,    0,    0,    0,    0,    0,    3,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    5,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 2
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    3,
     3,    0,    0,    0,    0,    0,    0,    0,    3,    3,    0,    0,// 3
     0,    0,    0,   11,   37,   21,   10,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    4,   15,   18,   74,
    36,    3,    5,    2,    0,    0,    0,    0,    3,    3,    0,    0,// 4
     1,    3,   30,  146,  193,  137,   30,    6,    0,    0,    0,    0,
     0,    0,    0,    0,    1,    0,    0,    1,   16,   60,  237,  329,
   131,   25,    7,    2,    0,    3,    2,    0,    0,    0,    0,    1,// 5
    42,  154,  432,  857,  603,  201,   52,    3,    0,    0,    0,    0,
     3,    8,    0,    3,    8,    8,   49,   97,  204,  334,  409,  593,
   320,   63,   11,    0,    0,    4,    3,    0,    0,    2,    5,   15,// 6
   616, 1527, 1975, 1407,  577,  144,   51,    0,    0,    0,    0,    0,
     1,    0,    0,    5,   34,   93,  178,  366,  452,  310,  236,  305,
   210,   53,   22,   16,    3,    2,    0,    0,    7,    9,   26,  111,// 7
  2655, 2916, 2032,  816,  205,   61,   14,   10,    5,    2,    7,   11,
    13,    5,   19,   73,  171,  337,  524,  493,  460,  222,  127,   97,
    57,   28,   21,   12,    4,   19,   31,   29,   24,   41,  196, 1032,// 8
  2461, 1984,  840,  240,   74,   29,   16,    5,   10,   15,   15,   22,
    23,   40,   75,  253,  356,  406,  464,  420,  289,  144,   53,   24,
    20,   19,   15,   15,    0,   19,   26,   30,   41,  145,  798, 1998,// 9
  1122,  937,  278,   55,   30,    6,   16,    6,   19,   12,   29,   39,
    51,   83,  119,  216,  327,  228,  292,  250,  168,  101,   47,   32,
     9,   19,    6,    9,   12,    0,    9,   30,   40,  218,  929, 1231,//10
   467,  301,  148,   54,    6,    3,    3,    0,    6,    2,   26,   28,
    41,   50,   66,  173,  205,  172,  190,  206,  112,   45,   17,   22,
     2,   12,   11,    7,    3,    0,    5,   12,   58,  195,  402,  443,//11
   190,  104,   33,   19,   24,   10,    5,    0,    1,   10,   17,   15,
    29,   36,   71,   87,  127,  173,  156,  135,   68,   48,   32,   13,
     7,   16,    5,    4,    7,    1,   16,   13,   16,   86,  102,  111,//12
    64,   32,   12,   11,   32,    9,    0,    0,    0,    7,    8,   11,
    10,   38,   43,   61,   86,  106,  112,  140,  132,   67,   40,   15,
     9,   12,    1,    0,   13,   10,    2,   11,   11,   24,   68,  101,//13
    15,   11,    9,    2,    3,    1,    0,    0,    0,    2,    3,    0,
    14,    9,   28,   45,  101,  102,  169,  169,  162,  112,   60,   18,
     2,    1,    0,    0,    5,    2,    0,   10,   16,   15,   26,   36,//14
     7,   12,    5,    0,    0,    0,    0,    0,    0,    2,    5,    4,
    10,    4,   31,   40,   76,  139,  259,  193,  137,  116,   51,   18,
     4,    0,    0,    1,    0,    4,    6,    1,   21,    8,   11,   18,//15
     4,    8,    0,    0,    0,    0,    0,    1,   12,    0,    1,    6,
     0,    7,    6,   27,   93,  150,  202,  253,  211,  105,   30,   23,
     6,    5,    3,    8,    1,   17,   16,    0,    0,    1,    3,   10,//16
     0,    0,    0,    0,    0,    6,    1,   10,    0,    0,    1,    6,
     9,    6,    9,   30,  104,  187,  324,  399,  208,  126,   48,   19,
    12,    6,    3,    0,    0,    3,    1,    0,    0,    0,    0,    0,//17
     0,    2,    1,    0,    0,    6,    0,    0,    0,    0,    0,   10,
    10,   16,   38,   35,  153,  303,  421,  352,  184,   72,   54,   19,
    21,    8,    7,    0,    0,    0,    0,    5,    4,    1,    0,    1,//18
     4,    6,    3,    0,    1,    3,    1,    9,    0,    0,    0,    3,
     3,   18,   38,   72,  191,  401,  430,  252,  172,   74,   40,    9,
     9,    0,   11,    6,    7,    0,    0,    3,   12,   10,    2,    8,//19
    18,    1,    0,    3,   12,    8,   11,    3,    0,    2,    0,    0,
     1,   23,   71,  164,  338,  358,  286,  185,  125,   46,   17,    5,
     1,    7,    4,   10,    2,    0,    0,    0,    0,    1,    0,    1,//20
     4,   14,   12,    6,    5,    4,    0,    0,    2,    8,    0,    1,
    14,   39,   97,  183,  245,  212,  178,  143,  107,   51,   36,   13,
    11,    1,    4,    7,    0,    0,    0,    0,    0,    0,    0,    0,//21
     7,   21,   18,   46,   23,    4,   10,    1,    0,    0,    0,    6,
    25,   62,  150,  258,  187,  143,  150,  125,   62,   16,   35,   17,
    14,    7,    4,    1,    3,    6,    0,    0,    0,    1,    6,    2,//22
    24,   31,   34,   55,   25,   13,    9,    4,    0,    0,    1,   20,
    40,   82,  144,  259,  208,  150,  148,  151,   88,   50,   33,   26,
    25,   11,    7,   14,    8,    4,   14,    0,    0,   10,   19,   21,//23
    24,   61,   51,   26,   24,    5,    6,    2,    0,    0,    0,   15,
    42,  107,  142,  154,  151,  140,  113,  141,   96,   76,   31,   22,
     9,   16,   19,   13,    7,    8,   12,    1,    0,    4,   23,   28,//24
    86,  126,  147,   42,   16,   27,   25,    3,    0,    1,    3,   35,
    54,   94,  145,  114,  153,  147,  180,  151,  129,  114,   86,   33,
    24,   31,   22,   22,   25,   11,   24,    6,    9,   20,   24,   40,//25
   244,  273,  176,   62,    6,   16,   20,    6,    1,    4,   31,   58,
    80,   90,  107,  157,  181,  206,  254,  225,  269,  151,  100,   87,
    41,   43,   30,   20,   18,   24,   10,    1,   10,   34,   73,  137,//26
   499,  309,  145,   71,   18,   30,   21,   36,   30,   25,   22,   43,
    45,  132,  180,  216,  225,  325,  436,  455,  378,  138,   72,   51,
    21,   37,   28,    3,   17,   26,    5,   21,   32,   79,  158,  357,//27
   463,  119,   15,   44,   15,   33,   40,   30,   24,   27,   19,   35,
    53,  113,  225,  313,  425,  594,  531,  432,  223,   92,   34,    8,
     0,    5,    4,    7,    8,   13,   28,  104,  249,  318,  354,  531,//28
   174,   21,    1,    0,    1,   17,   10,    3,    4,   13,   20,   23,
    72,  120,  275,  490,  579,  477,  271,  124,   48,   17,    2,    0,
     0,    0,    8,    7,    0,   13,   91,  851, 2514, 1280,  752,  630,//29
    36,    3,    7,    1,    0,    1,    0,    0,    0,    0,    1,    5,
    48,  158,  339,  299,  137,  111,   57,   29,    2,    1,    0,    0,
     0,    0,    0,    0,    0,   11,  179, 2348, 4535, 1658,  748,  240,//30
     4,    0,   16,    1,    0,    0,    0,    0,    0,    0,    5,   12,
    14,   74,  122,   40,    1,   10,    7,    2,    0,    0,    0,    0,
     0,    0,    0,    0,   10,   12,  140,  626,  736,  309,   95,   15,//31
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    2,    1,
    13,    6,    4,    0,    0,    0,   11,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    4,   10,   60,   85,   28,    8,    0,    0,//32
     0,    0,    0,    0,    0,    3,    9,    0,    0,    0,    0,    0,
     3,    9,    3,    6,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,   11,   10,    5,    6,    5,    0,    0,    0,    0,//33
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    5,    7,    3,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,   10,    4,    0,    0,    0,    0,    0,    0,    0,//34
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//35
  };
  ftype32 rama_pro[] = {
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 0
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 1
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 2
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 3
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 4
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 5
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 6
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 7
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 8
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 9
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//10
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//11
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//12
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//13
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//14
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//15
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//16
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//17
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//18
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//19
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//20
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//21
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//22
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//23
     0,    0,    0,    0,    0,    2,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//24
     3,    7,    8,    8,   18,   16,    7,    0,    0,    0,    0,    0,
     0,    0,    3,    7,   11,   11,    6,    4,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//25
    89,   84,   65,   44,    8,    7,   10,    0,    0,    0,    0,    4,
    23,   29,   25,   34,   70,   44,   34,    9,    0,    0,    0,    1,
     3,    0,    0,    0,    0,    0,    0,    0,    0,    0,    9,   47,//26
   245,  142,  121,   55,   11,   26,   52,   86,   22,   15,   15,   16,
    45,   95,  111,  269,  327,  234,  109,   37,    3,    2,    2,    2,
     6,    0,    0,    0,    0,    0,    0,    0,    0,    9,  122,  217,//27
   399,  100,   43,   21,   45,  111,  203,  246,  126,   59,   69,   61,
   149,  349,  658, 1240, 1354,  828,  239,   58,   16,   12,    7,    6,
     1,    4,    2,    0,    0,    0,    0,    0,   28,  138,  434,  704,//28
   309,   35,   10,    3,   10,   67,  101,   68,   42,   34,   26,   75,
   280,  912, 2196, 3282, 2681, 1103,  162,   21,    3,    1,    1,    2,
    11,    4,    2,    4,    2,    1,    7,   45,  400, 1155, 1852, 1359,//29
    62,    9,    2,    5,    4,    3,    8,    0,    0,    9,   36,   37,
   404, 1893, 3871, 3571, 1491,  290,   38,   11,    0,    0,    0,    0,
     0,    0,    0,    4,    2,   14,   48,  615, 2889, 4269, 2608,  601,//30
     0,    4,    3,    0,    0,    0,    0,    0,    0,    4,   14,   19,
   366, 1302, 1543,  683,  130,    8,    1,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    3,   93,  961, 2346, 1684,  400,   18,//31
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    3,   20,
    82,  119,   85,   14,    1,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,   19,   81,  230,  242,   85,   11,    0,//32
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   10,   11,
     8,    2,    5,    3,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    4,    0,    0,    5,   33,   31,    4,    1,    0,    0,//33
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    3,    6,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    8,    0,    0,    0,    2,    3,    0,    0,    0,    0,//34
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//35
  };
  ftype32 rama_ngp[] = {
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    4,    0,    0,    2,    3,    0,    0,    0,    0,// 0
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    1,    1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    1,    7,    5,    2,    0,    0,    0,    0,    0,    0,// 1
     0,    0,    0,    0,    0,    3,    4,    0,    0,    0,    0,    0,
     0,    5,    4,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    3,    1,    3,    8,    0,    0,    0,    0,// 2
     0,    0,    0,    0,    1,   26,   46,   23,    2,    1,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     1,   10,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 3
     0,    0,    1,   14,  170,  518,  444,  135,   18,    3,    4,    5,
     0,    0,    0,    0,    0,    0,    0,    0,    1,    7,   10,   29,
    22,    6,    5,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 4
     0,    7,  164,  821, 2467, 2335,  972,  229,   38,    7,   10,    8,
     0,    0,    0,    0,    0,    0,    0,    1,    4,   29,   51,  157,
    87,   29,   22,    0,    0,    0,    0,    0,    0,    5,    2,    0,// 5
    46,  354, 1203, 2297, 2859, 1352,  417,  140,   36,    3,   19,   19,
     3,    0,    0,    1,    2,    7,   29,    9,   36,   49,   58,   85,
    90,   45,   22,    1,    3,   14,   22,   11,   18,   16,   15,   10,// 6
   276,  752,  962,  848,  373,   77,   42,   30,   15,    5,   10,   10,
     9,    3,    6,    8,   14,   16,   42,   15,    9,   13,   11,   10,
    16,   14,    8,    0,    2,   26,   99,   65,   35,   12,   32,   65,// 7
   166,  207,  109,   52,    7,   10,    9,   15,   17,    5,    5,    7,
     3,    6,   18,   22,   16,    7,    3,    1,    0,    0,    1,    0,
     0,    0,    0,    0,    0,    7,   33,   39,   17,    6,   21,  111,// 8
    18,   15,    0,    0,    0,    3,    6,    1,   12,    0,   10,    1,
     9,   11,    5,    8,    1,    0,    0,    0,    2,   10,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    1,    0,    0,    2,   14,// 9
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//10
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    4,    1,//11
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    5,    2,//12
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    1,    4,    0,    0,    0,//13
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     1,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    5,   14,    3,    1,    0,//14
     0,    0,    0,    0,    0,    5,    3,    0,    0,    0,    0,    3,
     8,    9,    0,    0,    0,    0,    0,    1,    1,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    7,    2,    0,//15
     0,    0,    0,    0,    0,    3,    2,    0,    0,    0,    0,    0,
     0,    3,    0,    0,    0,    0,    0,    4,    6,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    3,    1,    0,    0,//16
     0,    0,    0,    0,    0,    0,    0,    0,    3,    3,    0,    0,
     0,    0,    6,   16,   12,   16,    3,    0,    1,    2,    0,    0,
     0,    0,    0,    0,    0,    5,    2,    0,    5,    2,    0,    0,//17
     0,    0,    0,    0,    0,    0,    0,    4,    5,    7,    8,    5,
     4,   11,   36,   74,  164,  192,   69,   20,    4,    7,    0,    0,
     0,    0,    0,    0,    0,    7,    3,    0,    0,    0,    0,    0,//18
     2,    2,    3,    1,    3,    7,    9,   23,   37,   57,   40,   35,
    62,  161,  397,  884, 1539, 1299,  524,  153,   31,    8,    0,    0,
     0,    1,    6,    0,    0,    5,    3,    0,    0,    0,    0,    0,//19
    16,   22,   24,   18,   31,   41,   55,  135,  119,  122,  187,  269,
   365,  760, 1462, 2646, 4068, 2973, 1140,  323,   91,   27,    2,    0,
     1,    2,   16,    2,   20,   13,   11,    2,    8,    9,    5,    2,//20
    65,  105,  141,   97,  107,  112,  206,  297,  260,  302,  376,  583,
   976, 1843, 3301, 4919, 5142, 3134, 1234,  421,  112,   36,   12,    2,
     5,   15,    9,    9,   13,   42,   22,   11,   15,   40,   34,   36,//21
   215,  326,  337,  260,  286,  224,  427,  636,  531,  416,  627, 1304,
  2420, 4039, 5543, 6810, 6445, 3344, 1056,  322,  109,   11,   10,   11,
    15,   17,    3,   19,   33,   92,   76,   61,   39,   78,  103,  174,//22
   807,  852,  845,  653,  539,  340,  574, 1144, 1005,  652,  999, 2377,
  5342, 8103, 7864, 7454, 6508, 3025,  893,  281,  109,   29,   13,   17,
    29,   18,   15,   42,   72,   91,  122,  192,  213,  318,  367,  670,//23
  1774, 1897, 1793, 1122,  556,  188,  227,  471,  600,  823, 1461, 3182,
  7185,10522, 7989, 5999, 4607, 1941,  688,  286,  147,   58,   60,   21,
    49,   29,   27,   68,   76,  128,  222,  341,  383,  670, 1032, 1362,//24
  2961, 3726, 2711, 1208,  435,  157,  106,   90,  221,  646, 1795, 4095,
  8039, 9609, 6837, 4629, 3183, 1428,  604,  199,   87,   32,   29,    7,
    19,   30,   48,   55,   93,  136,  278,  545,  710, 1067, 1726, 2191,//25
  5516, 5175, 2490,  769,  268,  141,  209,  303,  458,  875, 2273, 4174,
  6766, 7542, 5419, 3686, 2828, 1522,  709,  257,   65,   18,   29,    8,
    15,   30,   19,   34,   83,  147,  324, 1002, 1361, 1833, 2523, 3674,//26
  7319, 4002, 1093,  251,  193,  284,  568,  878, 1058, 1420, 2200, 3704,
  5133, 6007, 4894, 3567, 3106, 1918,  926,  405,   72,    4,    4,    6,
     4,   31,    3,    7,   51,  130,  424, 1324, 2216, 3224, 4255, 6717,//27
  4905, 1403,  224,   68,   80,  205,  495,  811,  922,  945, 1401, 2495,
  4199, 6009, 5594, 5039, 4551, 2869,  990,  337,   49,    5,    0,    0,
     0,    2,    0,    2,   39,  113,  547, 2674, 6560, 7703, 7839, 8289,//28
  1646,  228,   24,   16,   11,   52,   44,   93,  153,  115,  312, 1043,
  2929, 6120, 7732, 6801, 4734, 1953,  396,   36,    4,    1,    0,    0,
     0,    0,    5,    3,   12,   65, 1086,21027,57767,28567,15321, 8073,//29
   188,   23,    3,    0,    5,    3,    0,    2,   15,   23,   40,  295,
  1803, 5781, 7356, 4257, 1641,  351,   28,    4,    0,    0,    0,    0,
     6,    5,    2,    3,   14,   74, 2655,49493,86255,29323,10531, 2193,//30
     5,    4,    3,    0,    0,    0,    0,    0,    0,    6,    6,   85,
   795, 2705, 2139,  709,   97,    7,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    2,   14,   85, 1433,10936,11859, 4044,  687,   60,//31
     0,    0,    0,    0,    0,    0,    0,    0,    0,    5,    4,   39,
   187,  346,  118,   18,    3,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    1,   17,   48,  323,  729,  469,  110,    5,    2,//32
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   17,
    36,   15,    1,    4,    7,    0,    0,    0,    0,    0,    0,    0,
     4,    3,    0,    2,   12,   25,   26,   41,    8,    4,   15,    1,//33
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    6,    6,
    18,    4,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     3,    2,    0,    0,    0,    7,    3,   13,    0,    0,    2,    0,//34
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,   12,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    4,    2,    6,    0,    0,    0,    0,//35
  };

  int rama5_data_size = 72;
  ftype32 rama5_gly[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,0,1,3,4,5,4,4,3,2,1,1,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,2,3,4,5,5,3,2,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,1,4,7,12,16,18,17,14,10,7,4,3,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,4,7,10,13,15,14,10,5,2,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,2,5,12,21,35,51,61,62,53,40,25,15,8,4,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,1,2,4,8,14,21,28,33,34,30,22,12,5,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  1,5,12,25,44,75,117,157,178,175,145,111,84,30,14,6,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,
  2,3,5,9,15,24,35,48,58,63,62,55,40,23,11,4,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  10,22,43,74,121,192,279,346,381,402,336,227,143,56,23,9,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,5,
  7,11,17,26,38,53,71,90,105,121,128,100,67,41,20,8,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,4,
  // 10
  35,65,108,169,259,374,560,622,689,668,551,400,230,102,35,12,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,8,13,
  20,30,43,59,78,98,137,164,193,228,188,137,103,65,34,14,5,1,
  0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,6,16,
  // 11
  96,147,220,318,465,682,931,1045,1207,1190,812,494,305,135,80,14,3,1,
  0,0,0,0,0,0,0,0,0,0,0,1,2,4,8,13,21,33,
  48,80,91,114,138,160,205,248,291,319,234,224,167,89,44,20,8,3,
  1,0,0,0,0,0,0,0,1,1,1,1,2,3,4,10,24,58,
  // 12
  202,282,397,606,852,1104,1390,1687,1973,2022,1179,573,352,158,52,15,4,1,
  0,0,0,0,0,0,0,0,0,1,2,3,7,13,21,34,60,74,
  102,181,167,193,221,306,391,445,331,346,251,204,183,95,49,24,11,5,
  2,1,1,1,2,2,2,2,2,2,3,3,4,7,14,32,69,133,
  // 13
  375,506,662,940,1119,1290,1398,1690,2039,1881,1042,595,312,140,48,14,4,1,
  1,1,1,1,1,0,0,0,1,3,6,11,19,31,48,73,116,136,
  169,304,324,369,379,402,405,379,321,295,251,213,183,127,50,25,14,9,
  4,3,3,4,5,5,6,6,6,6,7,8,11,20,42,85,152,246,
  // 14
  609,800,1069,1226,1286,1271,1376,1477,1329,1078,715,462,246,114,37,12,5,3,
  2,3,3,3,3,2,2,3,5,9,16,26,41,61,95,156,164,218,
  283,435,431,536,475,407,399,321,294,260,216,183,146,105,58,25,22,19,
  6,5,6,7,9,9,10,10,10,11,12,15,25,49,97,173,280,435,
  // 15
  966,1261,1585,1748,1363,1171,1121,1041,860,687,480,340,178,87,24,10,5,5,
  5,5,6,6,6,6,6,7,12,20,32,49,73,103,148,258,253,372,
  408,525,541,559,550,499,389,326,301,266,226,153,104,61,40,35,21,14,
  7,8,9,11,12,13,14,14,15,16,19,28,50,97,177,298,483,753,
  // 16
  1481,1628,1517,1393,1176,1029,881,687,567,447,294,182,93,45,17,9,7,7,
  7,8,10,11,11,11,12,15,22,41,52,80,158,212,215,322,372,439,
  558,560,591,509,472,439,323,264,247,183,160,140,94,57,39,67,24,10,
  9,9,12,15,16,16,52,17,18,21,28,45,85,159,273,447,670,1042,
  // 17
  1415,1475,1546,1259,1001,793,550,414,318,254,153,82,45,40,21,9,8,9,
  10,12,14,16,18,18,20,24,37,78,83,118,173,226,295,418,502,540,
  485,432,562,535,414,347,268,278,200,174,133,103,61,54,37,46,38,16,
  9,10,14,17,17,19,35,22,47,26,38,66,123,230,407,608,858,1192,
  // 18
  1393,1359,1277,988,726,527,395,285,166,106,63,60,28,20,13,9,11,12,
  14,16,18,22,24,25,28,41,68,88,116,153,184,261,331,379,421,477,
  576,441,419,361,308,344,244,227,163,132,106,61,48,43,34,24,21,12,
  9,9,12,14,49,16,22,19,66,30,47,84,180,294,510,721,1014,1286,
  // 19
  1058,958,910,751,502,342,246,148,86,52,28,21,20,13,9,11,14,16,
  37,20,25,34,45,34,34,56,112,99,117,176,242,315,329,341,328,354,
  478,430,407,312,247,207,168,178,141,98,72,55,48,40,31,22,14,10,
  8,7,8,9,10,11,14,32,25,33,53,97,209,355,668,852,1018,1065,
  // 20
  805,696,619,469,329,225,150,102,52,32,17,16,19,13,9,13,16,19,
  29,21,27,35,43,35,49,91,106,102,142,192,193,337,342,281,272,322,
  360,332,268,234,207,186,149,114,98,80,68,81,49,39,26,18,19,15,
  7,5,5,5,7,9,14,29,23,33,54,93,169,374,575,832,819,831,
  // 21
  572,548,395,308,278,176,92,45,27,17,12,10,10,9,9,16,27,18,
  19,35,35,28,30,44,48,60,61,86,116,232,179,253,292,269,268,317,
  294,248,247,200,183,168,135,153,113,96,60,53,48,38,23,16,22,17,
  5,3,3,3,4,7,15,21,21,30,50,84,151,298,484,530,546,633,
  // 22
  379,320,280,235,193,101,55,27,17,12,9,8,8,8,9,16,28,15,
  16,17,28,50,29,48,45,53,69,94,106,111,143,213,188,214,189,207,
  256,243,202,182,177,135,136,133,119,87,82,58,50,46,55,29,19,6,
  3,2,1,2,3,5,10,14,17,26,42,97,129,223,343,355,427,404,
  // 23
  261,210,160,122,98,57,32,19,18,22,10,8,7,7,8,9,10,11,
  13,16,19,21,24,29,34,38,52,60,81,93,133,193,166,194,165,196,
  192,167,203,171,153,129,130,131,115,81,58,63,53,34,20,17,10,4,
  2,1,1,2,3,4,6,9,13,21,35,77,103,184,216,206,234,243,
  // 24
  130,112,111,75,51,34,22,15,16,19,9,7,7,6,6,7,7,9,
  11,13,16,19,21,24,29,32,50,63,97,83,99,164,146,210,163,176,
  179,191,204,185,164,131,135,132,105,104,62,60,53,34,20,9,5,3,
  2,1,1,2,2,4,5,7,18,45,27,46,98,82,108,137,163,193,
  // 25
  88,76,55,43,32,22,16,12,9,8,7,6,6,5,5,5,9,15,
  10,11,13,15,17,19,29,34,33,40,55,70,85,105,109,132,185,212,
  162,154,198,189,165,171,132,157,107,81,59,45,33,22,13,8,5,3,
  1,1,1,2,2,3,4,6,9,14,35,45,42,64,102,101,102,111,
  // 26
  70,52,35,30,26,17,11,9,8,6,6,5,4,4,3,4,9,17,
  10,9,11,12,14,15,24,32,58,42,44,57,105,101,123,153,151,207,
  167,172,201,224,212,198,206,160,117,88,61,44,32,24,12,7,4,2,
  1,1,1,2,2,2,3,5,9,13,17,23,32,75,73,76,61,81,
  // 27
  34,29,24,24,22,14,8,6,6,5,4,3,3,2,2,2,3,5,
  6,7,8,9,10,12,14,20,25,27,33,44,58,73,94,124,119,195,
  198,216,204,227,253,203,180,153,119,93,59,38,32,33,12,6,3,2,
  1,1,1,2,2,2,21,8,9,12,16,47,26,83,43,45,45,41,
  // 28
  23,20,17,16,13,8,6,4,4,3,3,2,2,1,1,2,2,3,
  5,6,7,7,8,9,12,15,19,23,29,39,52,67,85,125,135,166,
  262,215,202,197,185,183,167,137,167,86,52,37,23,17,8,5,3,1,
  1,1,2,2,2,2,15,7,9,13,17,29,22,25,29,33,34,30,
  // 29
  15,13,13,11,7,5,4,2,2,2,1,1,1,1,1,1,2,3,
  4,5,6,6,6,7,10,13,17,21,28,50,65,103,124,116,142,183,
  216,202,255,203,213,187,191,130,124,74,43,46,26,11,6,3,2,1,
  1,1,2,3,3,3,4,6,9,12,16,18,19,19,20,23,26,21,
  // 30
  9,7,21,18,3,2,2,1,1,1,0,0,0,0,1,1,2,3,
  4,5,5,5,5,5,8,11,15,19,28,49,82,81,97,135,197,270,
  252,273,276,240,244,209,163,166,111,62,38,24,14,8,4,2,1,1,
  1,2,2,3,3,4,4,6,7,10,12,14,14,13,12,15,16,14,
  // 31
  4,3,3,2,1,1,0,0,0,0,0,0,0,0,0,1,2,3,
  3,4,4,5,4,5,7,9,13,18,26,41,62,98,109,153,194,320,
  305,309,288,271,260,217,174,130,80,76,50,19,11,6,3,1,1,1,
  1,2,3,3,4,4,5,5,6,6,8,9,9,8,8,8,12,6,
  // 32
  3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,1,2,2,
  3,3,3,27,11,5,6,9,12,18,27,51,71,101,133,168,239,292,
  314,351,341,386,303,213,211,144,68,47,28,16,10,5,3,1,1,1,
  1,2,3,4,4,4,39,5,4,4,4,5,5,4,4,4,32,5,
  // 33
  2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,2,
  3,3,3,4,4,5,7,9,13,19,30,51,71,98,141,212,276,334,
  338,362,362,396,338,226,198,126,65,39,24,15,10,6,4,2,1,1,
  1,2,3,3,4,4,5,4,3,3,2,2,2,2,2,2,2,2,
  // 34
  1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,2,
  2,3,3,5,6,8,8,10,14,20,32,50,79,147,170,236,292,307,
  424,431,387,349,233,176,164,93,61,37,23,15,11,8,5,3,1,1,
  1,1,2,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,
  // 35
  1,1,1,1,1,1,1,0,0,0,35,0,0,0,1,1,1,2,
  2,2,3,6,10,11,11,12,17,31,64,81,82,173,229,324,379,467,
  529,415,378,362,272,199,112,72,51,39,22,15,12,11,8,5,2,1,
  1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,
  // 36
  1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,
  1,2,3,6,11,13,13,14,23,43,56,59,88,138,206,372,381,418,
  611,418,381,372,206,138,88,59,56,43,23,14,13,13,11,6,3,2,
  1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,
  // 37
  1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,
  1,1,2,5,8,11,12,15,22,39,51,72,112,199,272,362,378,415,
  529,467,379,324,229,173,82,81,64,31,17,12,11,11,10,6,3,2,
  2,2,1,1,1,0,0,0,35,0,0,0,1,1,1,1,1,1,
  // 38
  1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,1,
  1,1,1,3,5,8,11,15,23,37,61,93,164,176,233,350,387,431,
  424,307,292,236,170,147,79,50,32,20,14,10,8,8,6,5,3,3,
  2,2,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,
  // 39
  2,2,2,2,2,2,2,2,2,3,3,4,5,4,4,3,3,2,
  1,1,1,2,4,6,10,15,24,39,65,126,198,226,338,396,362,362,
  338,334,276,212,141,98,71,51,30,19,13,9,7,5,4,4,3,3,
  3,2,2,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,
  // 40
  3,5,32,4,4,4,5,5,4,4,4,5,39,4,4,4,3,2,
  1,1,1,1,3,5,10,16,28,47,68,144,211,213,303,386,341,351,
  314,292,239,168,133,101,71,51,27,18,12,9,6,5,11,27,3,3,
  3,2,2,1,0,0,0,0,0,0,0,0,0,0,1,1,1,2,
  // 41
  4,6,12,8,8,8,9,9,8,6,6,5,5,4,4,3,3,2,
  1,1,1,1,3,6,11,19,50,76,80,130,174,217,260,271,288,309,
  305,320,194,153,109,98,62,41,26,18,13,9,7,5,4,5,4,4,
  3,3,2,1,0,0,0,0,0,0,0,0,0,1,1,2,3,3,
  // 42
  9,14,16,15,12,13,14,14,12,10,7,6,4,4,3,3,2,2,
  1,1,1,2,4,8,14,24,38,62,111,166,163,209,244,240,276,273,
  252,270,197,135,97,81,82,49,28,19,15,11,8,5,5,5,5,5,
  4,3,2,1,1,0,0,0,0,1,1,1,2,2,3,18,21,7,
  // 43
  15,21,26,23,20,19,19,18,16,12,9,6,4,3,3,3,2,1,
  1,1,2,3,6,11,26,46,43,74,124,130,191,187,213,203,255,202,
  216,183,142,116,124,103,65,50,28,21,17,13,10,7,6,6,6,5,
  4,3,2,1,1,1,1,1,1,2,2,2,4,5,7,11,13,13,
  // 44
  23,30,34,33,29,25,22,29,17,13,9,7,15,2,2,2,2,1,
  1,1,3,5,8,17,23,37,52,86,167,137,167,183,185,197,202,215,
  262,166,135,125,85,67,52,39,29,23,19,15,12,9,8,7,7,6,
  5,3,2,2,1,1,2,2,3,3,4,4,6,8,13,16,17,20,
  // 45
  34,41,45,45,43,83,26,47,16,12,9,8,21,2,2,2,1,1,
  1,2,3,6,12,33,32,38,59,93,119,153,180,203,253,227,204,216,
  198,195,119,124,94,73,58,44,33,27,25,20,14,12,10,9,8,7,
  6,5,3,2,2,2,3,3,4,5,6,6,8,14,22,24,24,29,
  // 46
  70,81,61,76,73,75,32,23,17,13,9,5,3,2,2,2,1,1,
  1,2,4,7,12,24,32,44,61,88,117,160,206,198,212,224,201,172,
  167,207,151,153,123,101,105,57,44,42,58,32,24,15,14,12,11,9,
  10,17,9,4,3,4,4,5,6,6,8,9,11,17,26,30,35,52,
  // 47
  88,111,102,101,102,64,42,45,35,14,9,6,4,3,2,2,1,1,
  1,3,5,8,13,22,33,45,59,81,107,157,132,171,165,189,198,154,
  162,212,185,132,109,105,85,70,55,40,33,34,29,19,17,15,13,11,
  10,15,9,5,5,5,6,6,7,8,9,12,16,22,32,43,55,76,
  // 48
  130,193,163,137,108,82,98,46,27,45,18,7,5,4,2,2,1,1,
  2,3,5,9,20,34,53,60,62,104,105,132,135,131,164,185,204,191,
  179,176,163,210,146,164,99,83,97,63,50,32,29,24,21,19,16,13,
  11,9,7,7,6,6,7,7,9,19,16,15,22,34,51,75,111,112,
  // 49
  261,243,234,206,216,184,103,77,35,21,13,9,6,4,3,2,1,1,
  2,4,10,17,20,34,53,63,58,81,115,131,130,129,153,171,203,167,
  192,196,165,194,166,193,133,93,81,60,52,38,34,29,24,21,19,16,
  13,11,10,9,8,7,7,8,10,22,18,19,32,57,98,122,160,210,
  // 50
  379,404,427,355,343,223,129,97,42,26,17,14,10,5,3,2,1,2,
  3,6,19,29,55,46,50,58,82,87,119,133,136,135,177,182,202,243,
  256,207,189,214,188,213,143,111,106,94,69,53,45,48,29,50,28,17,
  16,15,28,16,9,8,8,8,9,12,17,27,55,101,193,235,280,320,
  // 51
  572,633,546,530,484,298,151,84,50,30,21,21,15,7,4,3,3,3,
  5,17,22,16,23,38,48,53,60,96,113,153,135,168,183,200,247,248,
  294,317,268,269,292,253,179,232,116,86,61,60,48,44,30,28,35,35,
  19,18,27,16,9,9,10,10,12,17,27,45,92,176,278,308,395,548,
  // 52
  805,831,819,832,575,374,169,93,54,33,23,29,14,9,7,5,5,5,
  7,15,19,18,26,39,49,81,68,80,98,114,149,186,207,234,268,332,
  360,322,272,281,342,337,193,192,142,102,106,91,49,35,43,35,27,21,
  29,19,16,13,9,13,19,16,17,32,52,102,150,225,329,469,619,696,
  // 53
  1058,1065,1018,852,668,355,209,97,53,33,25,32,14,11,10,9,8,7,
  8,10,14,22,31,40,48,55,72,98,141,178,168,207,247,312,407,430,
  478,354,328,341,329,315,242,176,117,99,112,56,34,34,45,34,25,20,
  37,16,14,11,9,13,20,21,28,52,86,148,246,342,502,751,910,958,
  // 54
  1393,1286,1014,721,510,294,180,84,47,30,66,19,22,16,49,14,12,9,
  9,12,21,24,34,43,48,61,106,132,163,227,244,344,308,361,419,441,
  576,477,421,379,331,261,184,153,116,88,68,41,28,25,24,22,18,16,
  14,12,11,9,13,20,28,60,63,106,166,285,395,527,726,988,1277,1359,
  // 55
  1415,1192,858,608,407,230,123,66,38,26,47,22,35,19,17,17,14,10,
  9,16,38,46,37,54,61,103,133,174,200,278,268,347,414,535,562,432,
  485,540,502,418,295,226,173,118,83,78,37,24,20,18,18,16,14,12,
  10,9,8,9,21,40,45,82,153,254,318,414,550,793,1001,1259,1546,1475,
  // 56
  1481,1042,670,447,273,159,85,45,28,21,18,17,52,16,16,15,12,9,
  9,10,24,67,39,57,94,140,160,183,247,264,323,439,472,509,591,560,
  558,439,372,322,215,212,158,80,52,41,22,15,12,11,11,11,10,8,
  7,7,7,9,17,45,93,182,294,447,566,687,880,1029,1175,1393,1517,1628,
  // 57
  966,753,483,298,177,97,50,28,19,16,15,14,14,13,12,11,9,8,
  7,14,21,35,40,61,104,153,226,266,301,326,389,499,550,559,541,525,
  408,372,253,258,148,103,73,49,32,20,12,7,6,6,6,6,6,5,
  5,5,5,10,24,87,178,340,480,687,860,1040,1120,1170,1362,1748,1585,1261,
  // 58
  609,435,280,173,97,49,25,15,12,11,10,10,10,9,9,7,6,5,
  6,19,22,25,58,105,146,183,216,260,294,321,399,407,475,536,431,435,
  283,218,164,156,95,61,41,26,16,9,5,3,2,2,3,3,3,3,
  2,3,5,12,37,114,246,462,714,1078,1329,1476,1375,1271,1285,1226,1069,800,
  // 59
  375,246,152,85,42,20,11,8,7,6,6,6,6,5,5,4,3,3,
  4,9,14,25,50,127,183,213,251,295,321,379,405,402,379,369,324,304,
  169,136,116,73,48,31,19,11,6,3,1,0,0,0,1,1,1,1,
  1,1,4,14,48,140,312,595,1041,1881,2038,1689,1397,1289,1118,940,662,506,
  // 60
  202,133,69,32,14,7,4,3,3,2,2,2,2,2,2,1,1,1,
  2,5,11,24,49,95,183,204,251,346,331,445,391,306,221,193,167,181,
  102,74,60,34,21,13,7,3,2,1,0,0,0,0,0,0,0,0,
  0,1,4,15,52,158,352,573,1178,2021,1972,1686,1389,1103,852,606,397,282,
  // 61
  96,58,24,10,4,3,2,1,1,1,1,0,0,0,0,0,0,0,
  1,3,8,20,44,89,167,224,234,319,291,248,205,160,138,114,91,80,
  48,33,21,13,8,4,2,1,0,0,0,0,0,0,0,0,0,0,
  0,1,3,14,80,135,305,494,812,1190,1206,1044,930,681,464,318,220,147,
  // 62
  35,16,6,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,
  0,1,5,14,34,65,103,137,188,228,193,164,137,98,78,59,43,30,
  20,13,8,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,12,35,102,230,400,551,668,688,622,560,374,259,169,108,65,
  // 63
  10,4,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,8,20,41,67,100,128,121,105,90,71,53,38,26,17,11,
  7,5,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,9,23,56,143,227,336,402,381,346,279,191,121,74,43,22,
  // 64
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,4,11,23,40,55,62,63,58,48,35,24,15,9,5,3,
  2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,6,14,30,84,111,145,175,178,157,117,75,44,25,12,5,
  // 65
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,2,5,12,22,30,34,33,28,21,14,8,4,2,1,1,
  1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,4,8,15,25,40,53,62,61,51,35,21,12,5,2,0,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,5,10,14,15,13,10,7,4,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,3,4,7,10,14,17,18,16,12,7,4,1,0,0,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,2,3,5,5,4,3,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,1,2,3,4,4,5,4,3,1,0,0,0,0,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  ftype32 rama5_pro[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 10
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 11
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 12
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 13
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 14
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 15
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 16
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 17
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 18
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 19
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 20
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 21
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 22
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 23
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 24
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 25
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 26
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 27
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 28
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 29
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 30
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 31
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 32
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 33
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 34
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 35
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 36
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 37
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 38
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 39
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 40
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 41
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 42
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 43
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 44
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 45
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 46
  0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 47
  1,1,2,2,3,3,4,4,4,4,3,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,
  2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 48
  7,8,9,10,10,10,10,10,8,7,6,4,3,1,0,0,0,0,
  0,0,0,0,0,0,1,2,3,4,5,6,8,10,11,11,10,9,
  7,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,
  // 49
  24,26,26,26,26,24,22,18,15,11,9,7,5,3,2,0,0,0,
  0,0,0,0,1,3,5,7,8,10,13,16,20,24,26,26,24,21,
  16,12,8,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,2,5,8,14,19,
  // 50
  56,59,59,56,51,45,38,30,23,17,13,49,51,8,6,4,2,0,
  0,0,1,3,6,9,13,17,20,24,31,40,49,56,60,58,53,44,
  34,24,16,9,4,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,4,9,17,27,40,50,
  // 51
  112,111,105,95,83,71,57,45,34,27,23,46,49,24,22,17,11,7,
  4,4,5,9,15,22,30,37,45,56,73,94,114,129,135,128,114,94,
  70,47,29,16,8,4,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,5,14,27,45,68,90,105,
  // 52
  200,197,178,139,116,96,76,61,48,42,42,47,53,56,52,44,33,24,
  17,14,16,23,33,45,60,76,97,127,167,212,253,281,288,271,235,186,
  134,87,52,29,15,7,4,2,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,6,17,36,66,106,147,177,194,
  // 53
  549,301,257,189,146,114,90,73,63,61,69,82,95,101,98,84,67,51,
  38,32,34,43,60,82,111,149,202,344,415,452,529,573,572,523,439,336,
  233,148,85,47,25,13,7,4,3,2,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,2,7,19,46,91,156,230,291,326,332,
  // 54
  440,356,283,253,180,120,95,80,74,81,99,121,142,157,156,136,106,81,
  63,54,56,70,96,135,192,273,388,538,712,887,1019,1156,1059,910,834,539,
  485,223,128,67,35,18,10,6,4,3,1,1,1,1,1,1,1,1,
  0,0,0,0,0,0,0,3,10,27,64,129,224,341,453,604,589,517,
  // 55
  596,432,308,236,161,113,89,129,110,174,122,151,180,302,301,181,142,106,
  85,74,78,98,138,206,312,471,695,1058,1289,1616,1869,1981,1657,1392,1115,844,
  507,316,196,94,43,22,12,8,5,3,2,1,1,2,2,2,2,1,
  0,0,0,0,0,0,4,15,46,110,216,363,533,697,818,906,881,776,
  // 56
  721,493,320,204,133,93,74,88,85,134,131,190,206,269,337,202,159,119,
  96,87,94,122,185,297,481,766,1192,1752,2124,2509,2701,2849,2510,2098,1523,1066,
  624,413,247,110,46,23,12,8,6,3,2,1,2,2,3,3,2,2,
  1,0,0,0,0,5,20,69,179,356,610,867,1104,1276,1381,1386,1267,1001,
  // 57
  817,526,303,171,100,66,54,55,67,91,123,226,262,227,290,184,148,113,
  93,88,100,148,249,414,730,1187,1810,2681,3165,3521,3561,3703,3479,2832,1876,1126,
  690,492,243,105,43,20,11,7,5,3,2,1,2,2,3,3,3,2,
  1,0,0,0,4,20,77,218,468,815,1263,1639,1911,2046,2116,1977,1623,1168,
  // 58
  872,555,348,126,64,39,34,38,51,72,99,125,144,153,153,139,115,91,
  78,77,96,172,315,547,1052,1676,2350,3241,4104,4390,4452,4223,4187,3139,1965,1186,
  673,362,184,78,33,15,8,5,3,2,1,1,1,2,3,3,2,2,
  1,0,0,2,13,59,192,465,892,1424,1979,2471,2875,3010,2804,2445,2093,1463,
  // 59
  781,440,195,79,33,19,18,23,34,49,67,85,98,102,99,88,74,61,
  55,59,85,168,342,643,1264,2006,2729,4348,5144,5262,5401,4751,3633,2907,1712,1047,
  571,284,129,53,21,10,6,3,2,1,0,0,1,2,2,2,2,1,
  0,0,0,5,31,121,344,753,1341,2021,2903,3684,4287,4109,3624,2862,1957,1231,
  // 60
  603,306,120,41,14,8,8,13,19,27,37,47,53,55,53,47,39,34,
  33,40,70,154,339,679,1266,2017,2892,4099,4624,5144,4698,3924,3003,2018,1331,791,
  408,188,78,29,11,5,3,1,0,0,0,0,0,1,1,1,1,0,
  0,0,1,10,53,186,479,979,1680,2519,3559,4542,4411,3925,3198,2384,1673,1038,
  // 61
  390,167,58,16,5,3,4,6,9,13,17,20,22,22,21,18,16,15,
  16,24,54,136,315,639,1172,1809,2626,3504,3932,4174,3645,3010,2225,1429,889,491,
  236,99,37,13,5,2,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,16,72,226,545,1091,1862,2726,3711,4199,4050,3519,2733,1944,1282,757,
  // 62
  204,73,21,5,1,1,2,3,4,5,5,6,7,6,5,5,4,5,
  7,14,39,107,257,525,1089,1532,2111,2774,2967,2742,2357,1871,1349,870,497,248,
  106,39,13,5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,4,20,77,226,532,1047,1936,2975,3469,3210,3129,2600,2046,1379,851,456,
  // 63
  77,22,4,0,0,0,1,1,1,1,1,1,1,1,0,0,1,2,
  3,9,26,73,180,372,803,1081,1407,1849,1755,1661,1415,1076,722,422,214,92,
  34,11,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,5,21,69,188,412,863,1440,1763,1987,2118,2015,1697,1254,811,452,210,
  // 64
  17,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,5,16,44,106,220,392,594,801,934,965,881,704,491,294,149,64,23,
  7,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,6,19,53,133,281,501,773,1044,1236,1288,1172,926,629,362,172,63,
  // 65
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,8,23,52,107,191,290,379,431,425,361,262,160,81,34,11,3,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,5,15,36,81,162,279,418,547,624,618,524,375,221,106,38,9,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,10,22,42,73,109,139,150,137,104,66,34,13,4,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,4,11,23,44,79,128,182,226,240,218,164,100,48,17,4,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,4,8,14,21,30,35,36,30,20,11,4,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,3,7,13,22,35,50,63,70,66,52,32,15,6,2,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,4,5,6,6,6,5,3,2,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,3,6,10,14,17,18,16,12,7,3,1,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,3,4,5,5,4,3,1,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  ftype32 rama5_ngp[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,1,2,2,3,3,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,1,3,5,7,9,10,9,7,4,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,1,3,7,13,19,23,24,24,21,15,9,5,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,1,1,7,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,0,2,6,13,24,35,45,51,57,46,37,26,17,9,5,2,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,2,2,2,2,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  0,1,4,10,19,34,53,71,89,90,96,86,65,42,27,14,7,3,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,5,3,3,4,4,4,3,2,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  2,6,12,24,41,65,91,114,140,147,142,121,97,58,39,18,9,4,
  2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,7,4,6,9,6,5,4,3,2,1,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 10
  7,14,26,43,68,101,130,158,208,235,211,149,129,73,46,22,10,5,
  2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,3,5,6,13,16,8,7,6,4,3,2,1,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,3,
  // 11
  14,25,41,64,102,148,206,247,317,288,202,153,108,68,41,19,9,4,
  2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,1,1,2,2,4,5,6,13,19,9,9,8,4,3,2,1,
  0,0,0,0,1,1,2,2,1,1,1,1,1,1,1,1,3,7,
  // 12
  21,36,56,95,144,181,210,250,245,212,173,128,80,53,38,20,8,4,
  2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,3,
  5,1,1,2,5,4,3,5,6,7,9,9,8,6,4,3,2,1,
  0,0,0,1,1,2,3,3,3,2,2,7,1,1,2,6,7,12,
  // 13
  28,48,76,105,132,167,174,181,170,142,112,83,55,33,19,12,7,3,
  2,1,1,1,1,1,0,0,0,0,0,0,0,2,1,0,1,1,
  5,1,1,1,2,2,3,3,4,5,7,8,6,4,3,2,1,1,
  0,0,1,1,2,5,6,5,4,3,3,3,2,2,3,7,12,16,
  // 14
  32,51,73,92,98,125,122,123,109,91,69,48,31,18,10,6,3,2,
  1,1,1,1,1,1,1,1,0,0,0,0,0,4,1,1,3,1,
  5,1,1,1,1,2,2,2,3,3,4,4,3,3,2,1,1,0,
  0,0,1,1,2,5,7,6,5,4,3,2,2,3,4,6,16,19,
  // 15
  38,41,55,57,70,87,73,70,58,47,34,23,13,8,9,3,2,1,
  1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,3,2,
  1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,0,0,
  0,0,1,1,2,3,4,5,4,4,3,2,2,3,4,6,11,24,
  // 16
  22,26,31,36,39,39,37,32,26,19,13,7,4,3,4,1,1,1,
  1,1,0,0,0,0,1,1,1,1,3,1,1,6,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,2,3,3,3,3,2,2,2,2,3,6,14,22,
  // 17
  13,16,18,20,20,18,16,12,9,5,3,2,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,2,2,2,2,2,1,1,1,2,3,4,8,10,
  // 18
  7,8,9,9,8,7,5,3,2,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,1,0,0,1,2,3,4,6,
  // 19
  3,4,3,3,2,2,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,
  // 20
  1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
  // 21
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 22
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 23
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 24
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 25
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 26
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 27
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 28
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 29
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 30
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 31
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 32
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 33
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,3,3,2,
  2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 34
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,3,5,7,10,11,12,11,8,
  6,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  // 35
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,1,1,1,1,2,3,4,7,11,16,21,27,30,30,27,22,
  16,10,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
  // 36
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,
  2,2,2,3,3,4,5,8,12,18,26,37,49,60,67,68,59,47,
  34,22,12,6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 37
  0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,4,
  4,5,6,6,7,10,13,19,29,40,57,75,96,122,126,128,107,86,
  63,42,23,12,6,3,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 38
  1,1,1,1,1,1,1,1,1,1,2,2,4,5,6,6,7,11,
  13,9,11,12,15,19,26,38,59,75,107,137,167,208,208,205,196,141,
  101,69,39,20,11,5,3,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 39
  2,2,3,3,3,3,3,3,3,3,4,12,8,10,10,13,16,14,
  15,16,22,25,27,36,49,65,91,127,171,229,296,332,361,353,264,218,
  137,93,56,31,15,8,4,2,1,0,0,0,0,0,0,0,0,0,
  0,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,
  // 40
  4,5,6,6,7,7,7,6,5,6,7,9,12,22,32,18,19,29,
  24,24,29,37,54,78,84,108,146,215,278,328,381,429,457,434,342,261,
  180,105,76,45,25,12,11,3,1,0,0,0,0,0,0,0,0,1,
  1,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,3,3,
  // 41
  8,10,11,12,12,12,12,14,13,14,12,15,19,27,31,29,28,32,
  37,39,45,56,79,100,132,182,230,298,365,453,489,546,529,508,381,289,
  204,121,73,40,23,12,6,3,1,0,0,0,0,0,1,1,1,1,
  1,2,2,3,6,3,3,2,2,2,2,6,2,3,4,4,5,7,
  // 42
  16,18,20,21,21,20,18,23,23,22,20,25,30,40,43,50,44,43,
  45,56,66,86,117,154,195,264,328,404,484,568,599,663,613,595,435,312,
  218,126,74,44,24,14,6,3,1,1,1,1,1,1,1,1,1,1,
  2,2,3,4,9,4,4,4,4,4,4,8,5,7,7,9,11,13,
  // 43
  29,32,34,35,38,32,29,34,27,33,36,39,50,62,56,60,62,58,
  62,74,93,127,163,227,298,385,457,563,632,705,761,773,712,615,498,334,
  232,130,76,46,26,16,7,3,2,1,1,1,1,1,1,1,1,2,
  2,3,4,5,6,6,7,7,7,7,8,8,17,15,15,17,20,24,
  // 44
  49,53,55,58,71,52,49,52,46,44,41,53,61,71,77,77,90,74,
  76,102,129,173,234,329,455,547,647,719,818,893,900,863,816,673,497,332,
  213,140,75,43,25,13,7,4,2,1,1,2,2,2,2,2,2,2,
  3,4,5,7,8,9,10,10,11,12,13,15,18,23,26,30,44,44,
  // 45
  87,90,92,97,87,87,86,62,69,48,50,59,77,85,109,90,104,106,
  102,116,170,247,320,441,602,704,800,899,957,953,908,906,852,654,474,318,
  200,131,72,46,23,13,7,4,3,2,2,2,2,2,2,2,2,3,
  4,5,7,8,10,16,15,15,21,22,31,25,30,39,45,51,71,87,
  // 46
  125,134,146,142,122,117,99,72,62,59,54,62,68,86,89,87,103,118,
  119,136,190,275,387,531,719,826,938,1035,1020,961,922,873,758,604,440,298,
  186,114,65,39,22,13,8,5,3,2,2,2,2,2,2,2,3,5,
  7,6,11,10,12,16,18,23,30,33,36,41,50,60,74,102,110,118,
  // 47
  183,205,205,198,184,150,115,89,71,65,51,57,61,77,86,87,102,120,
  134,159,229,323,453,633,845,992,1098,1123,1092,975,916,833,712,568,405,264,
  164,100,58,34,21,13,8,6,4,3,3,2,4,4,3,3,4,5,
  8,8,15,14,17,22,23,31,39,47,53,60,74,83,104,138,157,163,
  // 48
  268,274,276,264,252,214,165,110,84,64,45,42,52,56,73,91,93,112,
  160,190,258,389,519,713,950,1152,1199,1156,1103,945,873,781,637,497,351,236,
  171,95,53,32,23,16,8,13,5,4,3,3,10,5,3,4,5,6,
  7,9,11,19,20,28,32,43,52,60,70,84,117,128,167,182,208,258,
  // 49
  337,366,358,347,335,227,179,124,81,63,41,35,36,41,49,62,84,99,
  149,192,294,443,598,802,1022,1212,1201,1141,1084,974,821,647,617,454,310,223,
  145,79,49,30,19,12,8,12,4,4,3,2,3,3,3,4,7,7,
  7,9,11,14,20,29,37,58,71,80,92,121,154,168,197,258,286,314,
  // 50
  461,473,471,407,331,254,204,125,76,48,41,39,34,35,42,56,77,95,
  136,205,304,453,615,808,1065,1099,1132,1117,1006,878,735,617,497,364,264,185,
  124,80,47,29,18,11,7,5,3,3,2,2,2,3,4,5,5,5,
  11,10,11,20,21,36,49,70,85,102,115,145,183,214,276,324,396,404,
  // 51
  541,533,521,421,342,247,176,111,71,47,33,33,39,38,45,61,81,105,
  153,229,327,470,604,778,927,1001,1028,998,880,762,635,554,443,355,255,181,
  117,79,47,31,18,11,6,7,3,2,2,2,2,3,4,5,4,5,
  6,9,12,18,24,40,58,81,106,134,157,192,232,277,345,406,454,498,
  // 52
  638,615,559,438,339,244,153,99,69,45,33,34,47,49,56,74,94,123,
  170,248,344,465,575,732,850,960,988,928,828,707,592,514,432,368,263,190,
  127,84,50,32,20,12,5,6,4,1,1,1,2,2,3,3,3,4,
  5,9,13,18,28,46,69,95,134,178,219,260,314,360,451,516,585,601,
  // 53
  814,726,639,464,305,192,126,76,57,39,35,46,50,59,76,91,110,146,
  178,258,339,464,571,709,859,894,952,898,795,719,610,502,436,336,262,208,
  157,96,62,32,18,9,4,4,4,1,1,1,1,1,6,5,2,3,
  4,7,10,20,31,47,82,132,210,280,340,397,468,530,554,615,720,748,
  // 54
  852,709,512,344,227,147,90,57,36,32,35,51,71,78,96,123,130,159,
  227,251,312,382,536,628,744,808,846,858,774,675,614,541,489,438,286,224,
  154,104,79,36,19,9,4,1,0,0,0,1,1,1,1,1,1,2,
  3,6,9,16,34,61,125,205,336,500,598,665,709,732,762,806,855,846,
  // 55
  774,587,424,286,174,102,58,36,28,27,41,50,70,93,110,119,120,150,
  193,219,273,360,481,558,670,741,804,827,776,728,651,584,532,446,304,229,
  159,100,63,38,18,8,3,1,0,0,0,0,0,1,1,1,1,1,
  2,6,10,18,39,89,210,437,726,978,1131,1221,1151,1058,1013,981,960,853,
  // 56
  653,464,312,199,117,65,35,24,21,21,31,36,52,70,84,96,96,112,
  133,174,216,287,383,465,590,707,785,833,789,764,703,633,547,452,333,239,
  158,98,52,31,16,7,2,0,0,0,0,0,0,0,0,0,0,1,
  1,4,9,19,56,171,440,872,1360,1764,2020,2034,1906,1590,1327,1128,1023,807,
  // 57
  540,383,230,131,71,36,19,14,14,15,20,27,36,46,55,77,71,82,
  92,131,160,215,310,406,530,694,782,850,847,806,752,669,560,471,344,230,
  152,86,43,22,13,6,1,0,0,0,0,0,0,0,0,0,0,0,
  1,3,8,25,96,330,783,1436,2174,2765,3134,3095,2745,2166,1700,1356,1078,746,
  // 58
  419,265,154,78,37,17,8,6,6,9,15,18,22,28,33,38,42,47,
  56,77,110,147,225,341,495,613,759,893,913,893,788,694,570,422,272,182,
  129,59,30,14,6,2,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,8,35,159,506,1132,1975,3103,4118,4744,4533,3614,2736,2105,1578,1098,695,
  // 59
  306,178,90,40,17,7,3,2,3,4,8,10,12,15,18,20,22,25,
  31,42,63,105,197,283,407,577,692,871,986,872,719,592,439,311,204,126,
  74,39,18,8,3,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,9,47,209,626,1346,2431,4229,6649,7923,6169,4175,3105,2229,1507,828,503,
  // 60
  202,102,45,17,6,2,1,1,1,1,2,3,4,6,7,8,9,11,
  14,21,37,68,122,215,323,471,611,774,747,628,522,411,334,216,138,83,
  45,22,9,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,9,52,223,647,1372,2484,4373,5829,5886,4645,3662,2606,1686,1025,599,365,
  // 61
  113,50,19,6,2,1,0,0,0,0,0,1,1,1,2,3,3,4,
  5,10,20,43,86,155,245,360,468,572,531,458,375,280,205,136,82,46,
  22,9,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,11,47,191,548,1175,2068,3274,4073,4070,3486,2735,1907,1190,691,395,224,
  // 62
  50,18,5,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
  2,4,11,27,57,111,183,257,327,370,347,310,237,177,115,71,39,19,
  8,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,10,34,133,386,852,1473,2138,2530,2611,2330,1790,1198,711,397,218,112,
  // 63
  15,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,6,15,35,66,112,165,195,222,212,171,126,86,53,29,14,6,
  2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,6,21,75,215,503,860,1219,1444,1493,1293,957,611,343,183,93,42,
  // 64
  2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,8,19,37,66,89,110,109,104,81,57,35,19,9,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,4,12,36,97,225,399,560,666,668,560,391,231,123,61,27,9,
  // 65
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,4,9,19,30,40,47,48,42,32,20,11,5,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,4,6,17,40,78,138,198,231,220,172,111,63,35,14,4,1,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,2,4,8,13,16,18,17,14,9,5,2,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,3,6,13,24,40,55,61,54,40,25,13,9,2,0,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,3,5,5,5,5,3,2,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,5,7,11,13,13,11,7,4,2,1,0,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,2,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,2,2,3,3,3,2,1,0,0,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  ftype32 rama5_ngl[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,1,1,2,3,3,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,1,2,5,7,8,9,8,6,4,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,1,3,7,12,18,22,23,22,19,14,9,5,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,1,1,6,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,0,2,6,13,22,33,43,48,54,44,35,25,16,9,4,2,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  0,1,4,9,18,32,50,67,84,85,90,81,61,39,25,13,7,3,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,5,2,3,4,4,3,3,2,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  2,5,12,22,39,62,86,107,131,138,133,114,91,55,37,17,8,4,
  2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,7,4,6,8,6,5,4,3,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 10
  6,13,24,40,64,95,123,148,198,221,201,144,121,68,43,21,9,4,
  2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,3,4,5,12,15,8,6,5,4,3,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,
  // 11
  13,23,39,60,96,139,193,234,299,271,189,145,101,63,38,17,9,4,
  2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,1,1,2,2,4,5,6,12,19,8,9,8,4,3,2,1,
  0,0,0,0,1,1,1,2,1,1,1,1,1,1,1,1,3,6,
  // 12
  20,34,53,89,139,169,198,238,232,200,163,120,78,50,36,19,8,3,
  2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,
  5,1,1,1,5,4,3,4,5,6,8,8,7,6,4,3,2,1,
  0,0,0,1,1,2,3,3,3,2,2,7,1,1,2,6,7,11,
  // 13
  26,45,72,100,126,157,164,172,160,133,106,79,52,31,18,11,6,3,
  1,1,1,1,1,1,0,0,0,0,0,0,0,2,0,0,1,1,
  5,1,1,1,2,2,2,3,4,5,7,7,6,4,3,2,1,1,
  0,0,1,1,2,5,6,5,4,3,2,3,2,2,3,6,12,15,
  // 14
  30,48,68,86,93,118,114,115,104,85,65,46,29,17,9,6,3,2,
  1,1,1,1,1,1,1,1,0,0,0,0,0,3,1,0,2,1,
  5,1,1,1,1,1,2,2,2,3,4,4,3,2,2,1,1,0,
  0,0,1,1,2,5,6,5,5,4,3,2,2,2,3,6,15,18,
  // 15
  36,39,52,54,66,82,69,67,55,44,33,21,13,8,8,3,2,1,
  1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,3,2,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
  0,0,0,1,2,3,4,4,4,3,3,2,2,2,4,6,11,24,
  // 16
  21,24,29,34,36,37,35,30,25,18,12,7,4,3,3,1,1,1,
  1,0,0,0,0,0,1,1,1,1,2,1,1,5,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,2,3,3,3,3,2,2,2,2,3,6,15,21,
  // 17
  13,15,17,19,19,17,15,11,8,5,3,2,1,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,2,2,2,1,1,1,1,2,4,7,9,
  // 18
  7,8,9,9,8,6,5,3,2,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,2,4,5,
  // 19
  3,3,3,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,
  // 20
  1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  // 21
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 22
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 23
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 24
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 25
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 26
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 27
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 28
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 29
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 30
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 31
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 32
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 33
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,3,3,2,
  2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 34
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,2,3,5,7,9,11,11,10,8,
  6,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  // 35
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,1,1,1,1,2,3,4,7,10,15,20,25,29,29,26,21,
  15,9,5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
  // 36
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,
  2,2,2,2,3,4,5,8,12,17,25,35,46,56,63,64,55,44,
  32,20,12,6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 37
  0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,3,4,
  4,5,5,6,7,9,12,18,27,38,53,71,91,115,119,121,101,81,
  59,39,22,12,6,3,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 38
  0,1,1,1,1,1,1,1,1,1,2,2,3,5,5,5,7,10,
  12,9,10,12,14,18,25,36,55,70,101,129,158,196,195,192,185,134,
  96,65,37,19,10,5,2,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 39
  2,2,3,3,3,3,2,2,3,3,4,11,7,9,10,13,15,13,
  14,15,21,24,26,34,46,62,85,120,162,216,280,313,342,337,250,206,
  130,88,53,30,14,7,3,2,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,
  // 40
  4,5,5,6,6,7,7,5,5,6,7,9,11,20,30,17,19,27,
  23,23,27,34,51,73,79,102,138,202,262,310,358,404,431,410,322,246,
  171,99,71,42,24,11,10,3,1,0,0,0,0,0,0,0,0,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,
  // 41
  8,9,10,11,12,12,11,13,12,13,12,14,18,25,29,27,26,30,
  34,36,42,53,75,95,123,171,217,280,346,426,460,516,498,479,359,272,
  193,114,69,38,21,11,6,2,1,0,0,0,0,0,0,1,1,1,
  1,1,2,2,5,3,2,2,2,2,2,5,2,3,3,4,5,6,
  // 42
  15,17,18,19,20,18,17,22,22,20,18,24,28,38,40,47,41,41,
  43,52,62,82,112,146,183,249,308,381,460,536,565,629,578,561,409,294,
  206,118,70,41,23,13,6,3,1,1,0,1,1,1,1,1,1,1,
  2,2,3,4,8,4,4,4,3,3,4,8,5,6,7,8,10,12,
  // 43
  27,30,32,33,36,30,28,32,26,31,36,37,47,58,53,57,59,55,
  58,70,88,120,154,215,282,364,431,533,596,667,718,729,671,581,469,314,
  218,123,71,43,24,15,6,3,2,1,1,1,1,1,1,1,1,2,
  2,3,4,5,6,6,6,6,6,7,7,8,16,14,14,16,19,23,
  // 44
  46,50,52,54,67,49,46,49,44,41,38,50,57,70,72,73,85,70,
  72,96,123,164,220,309,429,516,613,679,772,844,848,813,770,634,467,314,
  201,132,70,41,23,12,6,3,2,1,1,1,2,2,2,2,2,2,
  3,4,5,6,7,8,9,10,10,11,13,14,17,22,25,29,41,42,
  // 45
  82,85,87,91,82,82,81,58,65,45,47,56,72,80,101,86,99,100,
  96,109,161,233,302,416,568,665,755,851,900,903,857,854,804,617,449,301,
  189,123,68,43,22,12,7,4,2,2,2,2,2,2,2,2,2,3,
  4,5,6,8,9,15,14,14,19,21,29,24,29,37,43,49,67,82,
  // 46
  118,127,139,133,115,110,94,68,58,56,51,58,64,81,84,82,97,111,
  111,128,180,260,365,501,679,777,884,977,958,907,870,824,717,571,415,281,
  176,108,62,37,20,12,7,4,3,2,2,2,2,2,2,2,3,4,
  7,6,10,9,12,15,17,21,28,31,34,39,47,57,70,96,104,112,
  // 47
  173,193,196,186,174,143,109,84,67,62,49,54,58,73,81,81,96,114,
  126,150,216,305,430,598,799,936,1036,1064,1031,919,864,786,672,537,381,250,
  155,94,55,32,20,12,8,5,4,3,2,2,3,4,3,3,3,5,
  7,7,14,13,16,21,22,29,36,45,51,57,70,78,98,130,148,154,
  // 48
  253,259,261,250,237,202,157,104,80,61,44,40,50,52,69,86,88,106,
  151,179,243,367,489,673,896,1088,1134,1093,1042,892,823,740,603,469,330,223,
  161,89,50,31,22,15,8,12,4,4,3,2,10,5,3,3,5,5,
  6,8,10,18,19,27,30,41,49,57,66,80,111,121,157,175,196,244,
  // 49
  319,347,340,331,319,216,170,117,76,60,39,33,34,39,46,58,79,93,
  139,181,278,418,563,758,968,1145,1133,1078,1024,923,776,614,583,429,293,211,
  137,75,47,29,18,11,7,11,4,3,3,2,2,3,3,4,6,7,
  6,8,10,13,19,27,36,54,66,76,86,114,146,158,186,246,271,297,
  // 50
  437,449,449,388,314,241,194,120,73,47,39,37,32,34,40,53,73,90,
  129,193,287,427,580,763,1003,1038,1068,1053,950,829,694,586,475,346,251,176,
  120,76,45,28,17,10,6,5,3,2,2,2,2,3,4,4,5,5,
  10,9,10,19,20,34,46,65,80,96,109,137,172,203,261,309,376,385,
  // 51
  516,509,498,403,327,238,169,107,69,46,33,33,39,38,45,58,77,100,
  145,216,308,445,571,735,876,943,971,946,834,723,604,528,426,342,246,175,
  116,77,46,30,17,10,6,6,3,2,2,2,2,2,4,4,4,4,
  6,8,11,17,23,38,55,76,100,126,149,181,218,262,328,388,433,475,
  // 52
  614,593,537,420,325,235,148,97,68,44,34,37,49,50,56,72,90,118,
  161,235,325,441,543,696,803,908,940,886,790,678,570,498,423,363,258,189,
  127,84,50,32,20,12,5,6,3,1,1,1,1,2,3,3,3,3,
  5,9,12,17,26,44,65,90,127,168,209,246,299,343,430,495,562,577,
  // 53
  790,703,618,447,297,188,124,76,57,40,36,49,53,61,77,90,107,140,
  171,245,321,440,543,679,816,851,907,869,773,702,603,503,446,342,269,213,
  160,99,64,33,18,9,4,4,4,1,1,1,1,1,6,4,2,3,
  4,7,10,19,29,44,78,125,198,264,321,377,446,510,534,596,696,723,
  // 54
  832,691,500,343,223,147,95,59,38,34,38,55,75,87,99,123,130,154,
  218,242,298,363,512,599,712,776,823,836,770,684,637,574,517,461,319,240,
  177,110,81,38,20,9,4,2,1,0,0,0,1,1,1,1,1,2,
  3,5,9,15,32,59,118,194,317,473,569,633,682,708,743,792,836,829,
  // 55
  761,577,417,282,173,102,60,41,32,35,45,55,75,104,120,121,119,147,
  187,210,259,345,463,537,647,723,794,839,799,774,722,655,595,494,347,264,
  178,112,68,40,20,9,4,1,0,0,0,0,0,1,1,1,1,1,
  2,6,10,17,36,84,198,413,687,929,1081,1172,1113,1036,1000,976,953,847,
  // 56
  655,464,312,199,118,66,38,28,24,27,36,45,66,80,101,102,98,112,
  131,169,207,278,372,455,582,707,810,884,854,859,819,759,655,545,404,283,
  184,120,60,34,18,8,3,1,0,0,0,0,0,0,0,0,0,1,
  1,4,9,18,52,162,416,827,1293,1683,1937,1964,1851,1566,1326,1145,1046,812,
  // 57
  557,392,234,133,72,38,21,16,16,19,26,39,54,56,72,84,75,83,
  92,129,156,210,305,405,540,719,839,946,970,954,909,848,721,602,441,279,
  180,109,52,25,15,7,2,1,0,0,0,0,0,0,0,0,0,0,
  1,3,7,23,91,313,744,1368,2073,2648,3019,3011,2691,2153,1721,1398,1117,768,
  // 58
  442,280,160,80,39,18,10,7,9,12,21,26,29,35,41,44,45,49,
  57,76,109,147,228,350,527,666,843,1036,1098,1109,998,922,799,580,372,238,
  157,74,37,17,8,3,1,0,0,0,0,0,0,0,0,0,0,0,
  1,2,7,33,151,482,1078,1887,2976,3952,4590,4416,3572,2748,2146,1646,1160,748,
  // 59
  328,188,95,42,18,7,4,3,4,7,11,13,16,19,22,24,25,27,
  32,43,64,107,203,301,450,649,811,1076,1235,1155,991,833,649,458,287,176,
  99,51,24,10,4,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,8,44,200,598,1287,2335,4067,6371,7643,6046,4198,3171,2316,1590,899,552,
  // 60
  221,110,48,18,7,3,1,1,2,3,4,5,7,8,9,10,11,12,
  15,22,40,76,132,240,374,555,733,974,1001,923,764,607,496,312,200,119,
  63,30,12,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,9,49,214,621,1319,2397,4211,5632,5760,4704,3736,2721,1783,1107,650,398,
  // 61
  127,56,20,6,2,1,0,0,0,1,1,1,2,2,3,3,4,4,
  6,10,22,48,97,180,299,439,591,747,727,668,553,424,315,202,123,68,
  33,14,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,10,45,185,530,1138,2010,3190,4002,4060,3558,2821,2007,1271,754,439,251,
  // 62
  58,21,6,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,
  2,5,12,30,68,135,237,329,441,519,494,435,348,265,181,111,62,31,
  13,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,9,33,130,377,833,1446,2124,2554,2655,2400,1864,1274,777,446,249,129,
  // 63
  18,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,7,18,42,82,147,213,268,314,295,249,193,137,87,49,24,10,
  3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,5,21,74,213,497,862,1225,1462,1518,1336,1006,663,388,214,111,50,
  // 64
  3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,4,10,23,46,82,115,145,152,149,122,90,58,33,16,6,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,4,12,36,99,228,408,570,684,695,595,429,265,149,76,34,12,
  // 65
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,5,11,23,38,52,63,67,62,48,32,18,9,3,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,4,6,18,42,82,150,209,248,240,194,132,79,45,18,6,1,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,2,5,10,16,21,24,24,20,14,8,4,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,3,7,15,27,46,61,70,63,49,32,18,11,3,0,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,4,5,7,7,6,4,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,3,5,9,13,16,16,14,10,6,3,1,0,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,2,2,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,3,3,4,3,2,1,0,0,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  ftype32 rama5_all[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,1,2,5,7,8,9,8,6,4,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,1,3,7,12,18,21,23,22,18,13,8,5,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,2,2,1,1,6,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,0,2,6,13,24,35,45,50,54,44,34,24,15,8,4,2,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,2,3,4,5,5,5,4,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  0,1,4,10,21,37,56,75,93,93,95,83,63,38,24,12,6,3,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,3,4,9,8,9,9,9,7,5,3,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  3,7,14,27,46,74,104,130,155,159,151,129,99,55,36,16,8,3,
  1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,2,3,4,6,9,15,14,16,18,14,10,7,5,3,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  // 10
  9,18,32,53,82,125,165,195,246,267,235,169,132,73,43,19,9,4,
  2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
  2,3,5,7,9,12,15,18,21,27,31,20,15,11,7,4,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,
  // 11
  21,36,57,89,133,190,265,312,377,347,250,185,119,73,43,17,8,4,
  2,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,2,4,
  6,8,10,12,15,18,24,29,32,37,41,28,27,16,9,5,2,1,
  0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,5,11,
  // 12
  38,61,90,143,209,249,303,364,405,366,251,166,101,60,38,19,7,3,
  2,1,1,1,1,0,0,0,0,0,0,0,0,1,2,4,6,11,
  15,14,18,21,25,35,42,40,33,33,34,26,22,15,9,5,3,1,
  1,0,0,1,1,2,3,3,3,2,2,7,2,2,3,9,13,23,
  // 13
  60,93,131,177,215,255,278,297,312,259,182,124,76,42,21,13,6,2,
  1,1,1,1,1,1,0,0,0,0,1,1,2,5,5,8,13,15,
  23,28,28,31,35,38,39,34,33,31,28,26,20,13,8,5,2,1,
  1,1,1,1,2,5,6,5,4,4,3,4,3,4,7,14,26,39,
  // 14
  85,115,153,186,201,222,221,229,219,173,124,84,50,26,12,6,3,2,
  1,1,1,1,1,1,1,1,1,1,2,3,4,9,10,14,20,22,
  31,41,39,42,42,40,39,32,32,28,23,20,16,11,7,4,2,1,
  1,1,1,2,3,6,7,6,5,4,4,4,4,7,13,23,42,58,
  // 15
  120,147,180,182,186,184,170,162,130,110,75,49,29,15,12,3,2,1,
  1,1,1,1,1,1,1,2,2,3,4,6,8,11,16,24,26,31,
  33,45,48,47,48,39,37,30,27,28,21,15,11,8,5,4,2,1,
  1,1,1,2,3,4,5,5,5,5,4,5,7,12,22,36,54,84,
  // 16
  154,167,150,161,142,128,115,94,74,56,39,24,13,6,5,2,1,1,
  1,1,1,1,1,2,2,2,3,5,7,9,15,25,21,28,36,37,
  54,49,57,48,45,37,32,28,23,18,14,10,7,6,4,5,3,1,
  1,1,1,2,3,4,7,5,5,4,5,6,10,18,31,48,88,113,
  // 17
  135,135,150,133,107,85,65,51,38,27,18,10,6,3,2,1,1,1,
  1,2,2,2,2,2,2,3,4,6,9,12,15,23,25,35,51,45,
  48,45,48,40,37,32,25,29,20,16,11,10,6,4,3,2,3,1,
  1,1,1,2,2,3,6,4,6,4,5,8,14,24,41,62,86,114,
  // 18
  117,113,116,97,73,55,40,27,18,12,7,4,3,2,3,1,1,1,
  2,2,2,2,2,3,3,4,7,7,9,13,17,22,29,35,36,39,
  45,41,39,32,31,25,21,20,16,10,8,7,5,4,3,2,2,1,
  1,0,1,2,2,2,2,3,4,4,5,9,17,29,45,70,87,111,
  // 19
  99,90,87,68,51,34,24,14,9,5,3,2,2,1,2,1,1,1,
  2,2,2,2,3,3,3,5,7,8,12,16,19,23,27,33,31,33,
  36,36,36,29,25,20,17,17,13,8,6,5,4,3,2,2,1,1,
  0,0,0,0,1,1,1,2,2,3,6,10,20,31,46,74,85,101,
  // 20
  77,67,63,46,33,22,14,10,4,3,2,1,1,1,1,1,1,1,
  2,2,2,2,3,3,4,10,11,10,17,18,19,29,26,30,26,30,
  30,31,26,24,20,16,13,11,9,7,6,7,4,3,2,2,1,1,
  0,0,0,0,0,1,1,1,2,3,6,9,17,32,46,69,72,84,
  // 21
  54,49,40,29,25,18,8,5,2,1,1,1,1,1,1,1,1,1,
  2,2,2,2,4,5,3,4,6,9,10,21,16,18,29,24,28,28,
  27,23,23,18,17,15,14,12,8,9,5,5,4,3,5,1,1,1,
  0,0,0,0,0,0,1,3,2,3,4,8,17,33,45,53,50,58,
  // 22
  36,29,25,21,19,9,5,3,1,1,1,1,0,0,1,1,1,1,
  1,2,2,2,3,4,3,4,5,7,8,12,14,17,16,19,18,18,
  18,22,19,15,16,14,10,9,10,7,8,7,4,2,2,1,1,0,
  0,0,0,0,0,0,0,1,1,2,4,7,14,21,26,33,38,37,
  // 23
  22,18,16,12,9,5,3,2,1,2,0,0,0,0,0,0,1,1,
  1,1,1,2,2,2,4,3,5,6,7,9,11,13,16,19,17,18,
  16,17,18,16,15,12,11,11,10,8,5,5,4,2,1,1,0,0,
  0,0,0,0,0,0,0,0,1,2,3,5,12,14,17,21,22,22,
  // 24
  14,11,11,7,4,3,2,1,1,2,0,0,0,0,0,0,0,1,
  1,1,1,1,2,2,3,3,4,5,6,7,9,13,14,20,15,17,
  16,16,18,18,15,12,12,11,9,10,6,5,4,4,1,1,0,0,
  0,0,0,0,0,0,0,0,1,1,2,4,9,8,11,14,14,16,
  // 25
  8,7,5,4,3,2,1,1,0,0,0,0,0,0,0,0,0,0,
  1,1,1,1,2,2,2,2,3,3,7,5,8,11,10,11,14,17,
  14,16,16,18,17,13,12,13,10,7,5,4,2,2,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,3,4,4,6,7,8,9,10,
  // 26
  5,4,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,1,1,1,2,5,3,3,4,8,7,13,15,12,17,
  16,17,15,18,20,14,18,12,10,8,6,4,2,1,1,0,0,0,
  0,0,0,2,0,0,0,0,1,1,2,2,3,4,5,6,8,6,
  // 27
  3,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,1,1,2,2,3,4,5,6,9,11,13,14,
  20,17,17,18,20,16,18,14,12,9,6,4,2,1,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,2,7,3,3,4,4,5,4,
  // 28
  2,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,2,2,3,3,5,7,8,10,13,15,
  16,16,18,17,19,18,16,13,12,8,5,3,2,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,3,2,3,3,3,3,2,
  // 29
  1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,2,2,3,5,8,10,10,13,18,
  17,19,20,19,18,18,14,12,9,6,5,4,2,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,1,1,
  // 30
  0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,2,2,5,7,8,12,12,20,24,
  25,26,25,23,22,22,16,14,12,5,4,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,
  // 31
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,1,2,4,6,11,12,13,17,28,
  30,26,29,26,25,23,16,10,7,9,4,1,1,0,0,0,0,0,
  0,0,0,0,0,0,1,0,0,0,1,1,1,1,1,0,0,0,
  // 32
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,2,5,8,10,15,16,19,25,
  33,31,35,32,30,18,21,12,6,4,2,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,
  // 33
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,2,3,6,9,12,18,21,25,29,
  33,33,33,32,23,18,15,11,5,3,2,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 34
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,1,2,2,4,6,9,13,21,27,31,36,37,
  40,40,35,33,23,18,13,10,5,3,2,1,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  // 35
  0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,1,1,
  1,1,1,1,1,2,2,4,6,9,14,21,26,40,49,51,64,61,
  60,44,36,34,26,20,12,7,4,3,2,1,0,3,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  // 36
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,
  2,2,2,3,3,4,6,8,12,19,27,38,51,66,80,86,82,76,
  72,64,43,34,23,16,10,6,5,2,1,1,0,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 37
  0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,3,
  4,4,5,6,7,9,12,17,26,38,53,72,93,121,131,137,124,109,
  92,80,50,38,26,18,10,6,6,2,1,1,0,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 38
  1,1,1,1,1,1,1,1,1,1,2,2,3,5,5,5,6,9,
  11,8,9,11,13,17,23,34,52,68,98,126,158,195,204,205,206,158,
  121,93,61,37,26,17,9,6,3,2,1,3,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 39
  2,2,3,3,3,2,2,2,2,3,4,11,7,9,9,12,14,12,
  13,13,19,21,23,31,43,57,79,112,153,206,272,305,338,340,260,223,
  151,107,71,49,30,16,9,6,3,2,1,1,0,0,0,0,1,1,
  1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,
  // 40
  4,5,6,6,6,7,7,5,5,5,7,8,11,18,27,16,17,24,
  21,20,24,31,47,67,72,94,128,187,243,293,341,386,416,407,324,259,
  181,120,90,57,34,19,15,6,3,2,1,1,0,0,1,3,1,1,
  1,1,1,1,1,1,1,1,1,0,1,1,1,1,2,2,2,3,
  // 41
  8,9,11,11,11,12,12,13,11,12,11,13,16,24,27,25,24,28,
  31,32,38,49,68,86,112,157,202,261,321,399,434,487,474,467,354,278,
  200,130,81,50,29,19,11,6,3,2,1,1,1,1,1,1,1,1,
  1,2,2,2,5,2,2,2,2,1,1,5,2,3,3,4,5,6,
  // 42
  14,16,18,19,20,18,17,22,23,19,17,22,26,35,37,45,37,37,
  38,49,56,74,101,135,167,230,286,352,430,503,532,592,549,535,397,291,
  207,130,81,51,30,21,12,6,4,2,2,1,1,1,1,1,1,1,
  2,2,3,3,8,4,4,3,3,3,3,7,5,6,7,8,10,12,
  // 43
  26,29,33,32,34,30,28,31,25,29,32,34,44,53,49,53,55,51,
  54,64,80,109,140,196,256,336,397,492,555,622,675,681,636,551,454,303,
  214,126,81,53,35,22,12,7,4,3,2,2,2,2,2,1,1,2,
  2,3,4,4,5,6,6,6,6,6,7,7,14,14,13,15,18,22,
  // 44
  44,48,50,52,63,47,44,47,41,39,35,46,53,64,66,67,77,63,
  67,88,111,149,201,281,390,470,561,623,717,780,788,754,717,598,444,303,
  206,133,76,49,32,17,11,7,5,3,3,3,3,3,2,2,2,2,
  3,4,5,6,7,8,8,9,10,11,12,13,16,21,23,27,38,40,
  // 45
  77,80,84,87,77,80,76,56,60,41,43,51,65,73,93,78,90,91,
  87,100,145,211,274,381,519,608,692,781,832,840,801,793,749,580,431,293,
  188,129,74,51,29,18,12,8,5,4,4,4,3,3,3,3,3,3,
  4,5,6,7,9,14,13,13,18,20,26,22,26,36,42,46,62,78,
  // 46
  112,120,132,125,108,105,89,65,57,51,47,54,58,74,77,75,89,101,
  100,118,162,236,331,459,618,712,815,900,888,846,808,764,666,533,399,272,
  175,114,69,46,28,20,13,10,7,5,6,4,4,4,3,3,3,5,
  7,6,9,9,11,14,16,20,26,29,32,36,43,54,66,90,98,108,
  // 47
  164,183,186,178,168,135,105,81,64,57,45,49,53,67,74,76,87,103,
  115,134,195,278,391,547,732,856,950,971,948,855,805,734,629,499,361,240,
  156,102,65,43,29,22,15,12,8,6,7,5,6,6,4,4,4,6,
  8,7,13,13,16,20,20,26,34,41,49,54,64,72,93,123,139,147,
  // 48
  243,253,253,236,225,192,153,101,76,60,41,37,46,48,62,79,80,96,
  137,161,220,335,447,616,822,997,1037,1000,957,822,756,683,564,445,314,219,
  161,98,61,43,33,25,17,18,12,9,6,6,11,7,4,5,6,7,
  7,8,10,17,18,25,27,38,45,52,61,74,103,114,148,166,188,233,
  // 49
  318,342,336,318,309,215,164,116,73,57,37,31,32,36,42,52,71,85,
  126,166,253,379,512,692,884,1044,1033,986,936,849,719,572,546,405,282,207,
  141,88,59,42,32,26,20,19,11,12,7,6,5,5,6,7,7,8,
  7,8,13,13,18,25,32,50,60,69,79,105,136,150,176,234,263,289,
  // 50
  433,451,448,386,314,239,188,116,70,44,37,35,30,31,37,49,66,81,
  116,178,263,391,528,698,917,951,974,965,879,768,648,550,447,327,243,180,
  130,94,62,45,34,28,20,15,12,11,9,7,6,7,7,8,6,6,
  10,9,11,19,19,31,42,59,73,87,100,126,161,197,249,300,364,379,
  // 51
  524,523,509,413,335,238,168,106,67,47,31,31,37,34,41,53,70,91,
  132,195,279,407,524,676,806,873,893,871,772,668,560,499,409,331,241,183,
  132,97,66,51,41,32,22,19,14,11,8,7,6,6,7,8,5,5,
  7,11,12,17,21,35,51,76,91,116,137,168,207,252,317,381,429,482,
  // 52
  633,617,561,447,339,242,152,98,67,46,33,36,46,45,51,65,82,107,
  147,213,297,403,499,638,742,837,865,817,734,625,531,471,407,353,263,199,
  151,104,73,56,47,37,23,22,16,10,7,7,6,5,6,5,5,5,
  7,10,12,15,27,42,60,83,118,155,194,231,284,332,423,494,571,597,
  // 53
  822,738,655,478,327,200,132,79,57,39,36,46,50,57,71,83,97,128,
  156,221,289,404,499,616,750,782,831,800,713,650,560,476,431,339,277,229,
  193,123,89,60,46,40,25,19,14,10,9,5,5,4,10,6,4,4,
  6,7,10,18,27,40,72,115,182,245,302,357,427,495,531,612,719,759,
  // 54
  890,745,551,381,249,161,101,61,39,34,40,52,70,81,95,114,118,140,
  198,220,272,334,468,544,652,713,758,768,710,640,600,548,501,454,331,258,
  209,146,110,64,47,34,21,16,11,8,10,4,4,3,3,3,3,3,
  5,6,9,15,29,55,109,181,292,440,534,604,654,690,740,814,876,893,
  // 55
  824,629,462,310,194,118,68,43,32,34,44,53,70,97,110,112,109,135,
  171,191,238,320,423,490,595,667,734,773,740,729,690,629,582,492,359,280,
  205,143,102,73,44,30,20,13,8,5,4,3,2,2,2,2,2,2,
  3,6,10,16,34,79,183,381,634,863,1007,1099,1058,1009,996,995,1002,904,
  // 56
  705,509,346,221,133,75,42,30,25,27,35,42,62,74,93,95,92,104,
  121,159,188,254,341,417,533,658,753,819,795,799,774,732,643,544,415,302,
  212,152,87,61,38,28,15,9,5,3,2,2,1,1,1,1,1,2,
  3,4,8,17,49,150,383,763,1195,1559,1804,1847,1758,1507,1313,1165,1087,868,
  // 57
  589,424,258,148,82,43,23,18,17,18,24,36,50,52,67,78,69,76,
  85,118,143,192,281,376,501,670,781,882,908,905,864,818,706,597,450,297,
  200,133,73,46,28,16,9,5,3,2,1,1,1,1,1,1,1,1,
  2,3,7,22,85,288,685,1266,1926,2462,2823,2832,2543,2059,1679,1401,1145,797,
  // 58
  459,297,172,89,44,21,11,8,9,12,22,24,27,33,38,40,42,45,
  53,72,102,135,212,327,493,624,791,963,1034,1043,944,884,781,578,372,247,
  168,87,50,30,16,9,5,3,1,1,0,0,0,0,0,0,0,0,
  1,2,7,31,139,444,994,1752,2774,3735,4334,4174,3385,2628,2069,1607,1153,756,
  // 59
  331,194,101,46,20,9,5,4,5,6,11,12,15,18,20,22,23,25,
  29,40,59,99,189,283,428,612,765,1003,1158,1087,943,805,629,450,289,179,
  108,59,34,16,8,4,2,1,0,0,0,0,0,0,0,0,0,0,
  0,2,7,41,184,553,1192,2171,3797,6007,7154,5665,3961,3008,2204,1534,885,552,
  // 60
  218,112,50,20,7,3,2,2,2,3,4,5,6,8,9,9,10,11,
  14,20,37,71,124,226,354,526,692,913,946,872,724,577,473,300,196,124,
  67,35,17,7,3,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,8,46,198,577,1224,2225,3944,5350,5434,4448,3531,2581,1697,1057,627,388,
  // 61
  123,55,21,7,2,1,0,0,0,1,1,1,2,2,3,3,3,4,
  5,10,20,45,92,171,283,416,561,711,688,628,521,399,297,193,120,70,
  35,16,7,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,9,42,172,495,1058,1870,2989,3761,3808,3338,2658,1888,1193,710,417,241,
  // 62
  55,20,6,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
  2,4,11,29,64,130,225,310,415,495,468,410,328,249,171,106,60,31,
  14,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,8,31,121,351,773,1345,1975,2385,2478,2236,1740,1188,725,416,234,122,
  // 63
  17,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,6,17,40,77,139,202,253,295,279,235,182,128,82,46,23,10,
  4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,5,19,69,198,461,800,1138,1359,1407,1240,935,614,359,199,103,47,
  // 64
  3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,9,22,44,78,110,137,143,140,115,85,54,31,15,6,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,11,35,93,211,377,527,633,643,550,396,245,137,71,32,11,
  // 65
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,5,11,22,36,50,60,63,58,45,30,17,8,3,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,4,6,17,39,76,139,193,229,222,179,122,72,41,17,5,1,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,2,5,9,15,20,23,22,19,13,7,3,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,3,7,14,25,43,57,64,58,45,29,16,10,2,0,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,4,5,6,7,6,4,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,3,5,8,12,15,15,13,9,5,3,1,0,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,2,2,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,3,3,3,3,2,1,0,0,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  
  /***** Rama2 data set *****/
  
    // export : rjcmod.py (Version 0.5.0 for Python 2.7.8)
  int rama2_data_size = 180;
  
  // type   : gly
  // tiling : [180, 180]
  // range  : [[-180.0, 178.0], [-180.0, 178.0]]
  ftype32 rama2_gly_data[] = {
 0.0111508615425   , 0.0138022174606   , 0.0135024115292   , 0.0104467251891   ,
 0.00639356414861  , 0.00309442550871  , 0.00118352649237  , 0.000357327109971 ,
 8.50480297768e-05 , 1.59345783917e-05 , 2.34747784735e-06 , 2.74858607938e-07 ,
 3.59750160245e-08 , 2.97984553398e-08 , 5.42069008978e-08 , 8.19032769088e-08 ,
 9.74157471847e-08 , 9.11956814491e-08 , 6.72914294084e-08 , 3.91904339234e-08 ,
 1.80358521587e-08 , 6.57037683362e-09 , 2.02490478585e-09 , 2.70692452113e-09 ,
 3.09979728985e-08 , 3.35744369535e-07 , 2.89915740939e-06 , 1.98519350214e-05 ,
 0.00010764376181  , 0.000461994855352 , 0.0015694445937   , 0.0042203119478   ,
 0.00898224465421  , 0.0151245265302   , 0.0201323638494   , 0.0211613422423   ,
 0.0175405652224   , 0.0114487356494   , 0.00587551358032  , 0.00236780596886  ,
 0.000748825746501 , 0.000186200077759 , 3.68624963191e-05 , 6.13553326117e-06 ,
 1.02037337689e-06 , 2.15974432345e-07 , 5.47773953975e-08 , 1.29300998854e-08 ,
 2.49663295236e-09 , 3.80081036488e-10 , 4.52174208937e-11 , 4.19478198224e-12 ,
 3.03267946609e-13 , 1.70834264391e-14 , 7.49712709925e-16 , 2.56440116732e-17 ,
 7.99034139393e-19 , 7.8210625135e-19  , 3.95423376656e-18 , 1.98857034609e-17 ,
 2.75553969058e-16 , 8.94672859542e-15 , 2.71723505284e-13 , 6.5777543642e-12  ,
 1.25655707716e-10 , 1.89535593489e-09 , 2.25959116959e-08 , 2.13048878629e-07 ,
 1.58899393404e-06 , 9.37205024382e-06 , 4.3681682513e-05  , 0.000160709928919 ,
 0.000466104251842 , 0.00106410165     , 0.00190939947081  , 0.00268909712985  ,
 0.00296860938917  , 0.00256621927194  , 0.00173727060103  , 0.000928383153519 ,
 0.000419073369986 , 0.000232371176817 , 0.000267019186082 , 0.000406152709712 ,
 0.0005369683065   , 0.000568157427489 , 0.000475957572136 , 0.000315264051348 ,
 0.000165195310368 , 6.86071029778e-05 , 2.26746898657e-05 , 6.00682124975e-06 ,
 1.2902296792e-06  , 2.28348816287e-07 , 3.39268089737e-08 , 4.29797239872e-09 ,
 4.66759128677e-10 , 4.31216376991e-11 , 3.3443009833e-12  , 2.52435548022e-13 ,
 1.20046964176e-13 , 2.30469250803e-13 , 3.83285450068e-13 , 5.0499689953e-13  ,
 5.25764098798e-13 , 4.32045523129e-13 , 2.79844286572e-13 , 1.42663828945e-13 ,
 5.72176546067e-14 , 2.07224998904e-14 , 1.07164344055e-13 , 3.00228422057e-12 ,
 6.83188253829e-11 , 1.21117634672e-09 , 1.67233531538e-08 , 1.79842468399e-07 ,
 1.50633455859e-06 , 9.82698976457e-06 , 4.99346199374e-05 , 0.000197642773825 ,
 0.00060936607001  , 0.00146359046096  , 0.00273865846796  , 0.00399277980752  ,
 0.0045361331271   , 0.0040164057056   , 0.0027721550387   , 0.00149188517455  ,
 0.000626223682315 , 0.000205103452563 , 5.24422463219e-05 , 1.04741811241e-05 ,
 1.63535961254e-06 , 1.99779204265e-07 , 1.91160635445e-08 , 1.44419672157e-09 ,
 3.09370744936e-10 , 4.02478772129e-09 , 5.61329922001e-08 , 6.12132969648e-07 ,
 5.21830132908e-06 , 3.48060678342e-05 , 0.000181836052326 , 0.000744954888284 ,
 0.00239658190843  , 0.00606315791557  , 0.0120808533297   , 0.0189850427416   ,
 0.02356077931     , 0.0231128979747   , 0.0179331544759   , 0.0110064307486   ,
 0.00534154601655  , 0.00204820287995  , 0.000619826098811 , 0.000147830346312 ,
 2.7746773021e-05  , 4.09234840403e-06 , 4.73622552955e-07 , 4.29571114473e-08 ,
 3.04993404848e-09 , 1.69347222653e-10 , 7.34853852839e-12 , 2.68282816504e-13 ,
 3.15329334689e-13 , 3.89591114444e-12 , 3.88194621785e-11 , 3.05178781269e-10 ,
 1.89295645663e-09 , 9.31557307351e-09 , 3.74697015656e-08 , 1.38467960335e-07 ,
 6.10458680658e-07 , 3.55273072081e-06 , 2.13089014412e-05 , 0.000108538067474 ,
 0.000441721456181 , 0.0014171564859   , 0.00357768430319  , 0.007112849528    ,
 0.0197476213167   , 0.0244430922774   , 0.0239121600584   , 0.0185006793753   ,
 0.0113227140829   , 0.00548008819327  , 0.00209597210912  , 0.000632810211755 ,
 0.000150616184774 , 2.82191225584e-05 , 4.15574450727e-06 , 4.80600544141e-07 ,
 4.43417201153e-08 , 5.11146347679e-09 , 4.08581944951e-09 , 5.95780558261e-09 ,
 7.12658111615e-09 , 6.74383091759e-09 , 5.06099053375e-09 , 3.02557665371e-09 ,
 1.44905391766e-09 , 5.62475214172e-10 , 2.36629724096e-10 , 1.12539521967e-09 ,
 1.52205527732e-08 , 1.69016978507e-07 , 1.48043310624e-06 , 1.02251464197e-05 ,
 5.57314520075e-05 , 0.000239927133101 , 0.000816526799334 , 0.00219798838875  ,
 0.00468091009567  , 0.00788460532247  , 0.0104973964154   , 0.0110353184424   ,
 0.0091481688245   , 0.00597245688492  , 0.00306789589009  , 0.0012412775362   ,
 0.000399457166411 , 0.000106917368735 , 2.76842698051e-05 , 8.91120130094e-06 ,
 3.54692570889e-06 , 1.35575076496e-06 , 4.28718191367e-07 , 1.07244111486e-07 ,
 2.09888464358e-08 , 3.20501142282e-09 , 3.81551367226e-10 , 3.54014876072e-11 ,
 2.5595090615e-12  , 1.44179874752e-13 , 6.32743518764e-15 , 2.16978907838e-16 ,
 1.13888777711e-17 , 3.72225243478e-17 , 1.91041058181e-16 , 7.79419671948e-16 ,
 3.02007250865e-15 , 2.94226785317e-14 , 7.33198176913e-13 , 1.75014911864e-11 ,
 3.34036858544e-10 , 5.03824019358e-09 , 6.00643051184e-08 , 5.66325018183e-07 ,
 4.22385234893e-06 , 2.49127171187e-05 , 0.000116114336719 , 0.000427197983672 ,
 0.00123899496299  , 0.00282858708711  , 0.0050755490966   , 0.00714811332528  ,
 0.00789093824834  , 0.00682020437152  , 0.00461104001035  , 0.00243803593753  ,
 0.00101267057276  , 0.000344466904219 , 0.000125990257224 , 9.17827566964e-05 ,
 0.000104272412571 , 0.000108335066916 , 9.05322395004e-05 , 5.98196517389e-05 ,
 3.11877467408e-05 , 1.28352192718e-05 , 4.17787956969e-06 , 1.08004146429e-06 ,
 2.23389926139e-07 , 3.740730328e-08   , 5.1567197346e-09  , 5.96792303956e-10 ,
 5.89529336783e-11 , 5.00023235442e-12 , 3.61556351713e-13 , 2.29324423959e-14 ,
 3.98296809316e-15 , 6.14880137551e-15 , 1.01741408727e-14 , 1.34036371971e-14 ,
 1.39549019864e-14 , 1.14682506615e-14 , 7.43469956981e-15 , 3.83013279502e-15 ,
 1.86933688931e-15 , 8.02921131377e-15 , 2.55207058499e-13 , 7.38809920919e-12 ,
 1.68045718334e-10 , 2.97898419603e-09 , 4.11321982532e-08 , 4.42334560745e-07 ,
 3.70493378351e-06 , 2.41701905024e-05 , 0.00012281801188  , 0.000486118597113 ,
 0.00149879023695  , 0.00359984547519  , 0.00673603625413  , 0.0098207554403   ,
 0.0111573059311   , 0.00987908110108  , 0.00681873635339  , 0.00366971223512  ,
 0.00154042441404  , 0.000504549874084 , 0.000129015351611 , 2.57704598817e-05 ,
 4.02417458258e-06 , 4.91704859127e-07 , 4.70634810117e-08 , 3.54709667994e-09 ,
 5.2932050096e-10  , 5.74976553038e-09 , 8.01343238187e-08 , 8.73867083529e-07 ,
 7.44952821148e-06 , 4.96883505469e-05 , 0.000259585011736 , 0.00106348065241  ,
 0.00342130581644  , 0.0086556263202   , 0.0172463514084   , 0.0271026151628   ,
 0.0336348326032   , 0.0329954473971   , 0.0256009634024   , 0.0157125301723   ,
 0.00762546958854  , 0.00292396784073  , 0.000884849639416 , 0.000211039239684 ,
 3.96106620061e-05 , 5.84214349252e-06 , 6.76132783059e-07 , 6.13245951523e-08 ,
 4.35401646889e-09 , 2.41756192685e-10 , 1.04893251762e-11 , 3.57134211892e-13 ,
 3.73465731162e-14 , 3.53037418053e-13 , 3.52301279043e-12 , 2.79606438598e-11 ,
 1.81179751678e-10 , 1.06826986066e-09 , 7.41357143983e-09 , 6.86512853668e-08 ,
 6.66849386599e-07 , 5.53137734342e-06 , 3.66461733752e-05 , 0.000190993405283 ,
 0.000781199163716 , 0.00250899014354  , 0.00633552900851  , 0.0125963747604   ,
 0.0275032906576   , 0.0340428618246   , 0.0333034122475   , 0.025766628917    ,
 0.0157695923726   , 0.00763233588309  , 0.00291914337407  , 0.000881339846104 ,
 0.00020976912363  , 3.93018729801e-05 , 5.78778441536e-06 , 6.69010270076e-07 ,
 6.0698207634e-08  , 4.57102764597e-09 , 9.51927426583e-10 , 1.55319005737e-09 ,
 2.71769482194e-09 , 3.86002406557e-09 , 4.38867479299e-09 , 3.97311690571e-09 ,
 2.85608197708e-09 , 1.63126763608e-09 , 7.68612901276e-10 , 7.1634730374e-10  ,
 6.24106509912e-09 , 6.85292665379e-08 , 6.01664174533e-07 , 4.16342921612e-06 ,
 2.27190016569e-05 , 9.78747930067e-05 , 0.0003332268089   , 0.000897220000549 ,
 0.00191101978043  , 0.00321924624716  , 0.0042864181651   , 0.00450699607204  ,
 0.00373917074595  , 0.00244927154904  , 0.00127637708893  , 0.000548871789088 ,
 0.000221919032567 , 0.000108327014206 , 6.70616273994e-05 , 4.12718012236e-05 ,
 2.13091348965e-05 , 8.74198648552e-06 , 2.81064821054e-06 , 7.0570897529e-07  ,
 1.38228026226e-07 , 2.11111704476e-08 , 2.51333281149e-09 , 2.33195499565e-10 ,
 1.68599014027e-11 , 9.49734437476e-13 , 4.16816135785e-14 , 1.44990874931e-15 ,
 2.49313157838e-16 , 1.3941423885e-15  , 7.17425600079e-15 , 2.88956580258e-14 ,
 9.21689048207e-14 , 2.73461222529e-13 , 1.95047055816e-12 , 3.74137228143e-11 ,
 7.02975354893e-10 , 1.05924176029e-08 , 1.26271665112e-07 , 1.19056615777e-06 ,
 8.87966150976e-06 , 5.23731593252e-05 , 0.000244103227362 , 0.000898083815135 ,
 0.00260469703735  , 0.00594644255694  , 0.0106701541917   , 0.0150272326444   ,
 0.0165888240692   , 0.0143376971185   , 0.00969261606854  , 0.00512100942308  ,
 0.00211388029217  , 0.000683460446039 , 0.000177569272461 , 4.47812819469e-05 ,
 2.03054691849e-05 , 1.67474238076e-05 , 1.35817098504e-05 , 8.93652743474e-06 ,
 4.6457863794e-06  , 1.90231518204e-06 , 6.13779771458e-07 , 1.56368742372e-07 ,
 3.1589749826e-08  , 5.09883587414e-09 , 6.65510657015e-10 , 7.14551737123e-11 ,
 6.4402779003e-12  , 4.95796089772e-13 , 3.28274965579e-14 , 1.91297960816e-15 ,
 2.42660662278e-16 , 3.09615051205e-16 , 4.76158324608e-16 , 5.8449497798e-16  ,
 5.7221799153e-16  , 4.83084475986e-16 , 5.89567737767e-16 , 1.96975858686e-15 ,
 8.93119421959e-15 , 4.55439593435e-14 , 5.85355440953e-13 , 1.44672173306e-11 ,
 3.24346643306e-10 , 5.74259965612e-09 , 7.92818567691e-08 , 8.52587792583e-07 ,
 7.14117908262e-06 , 4.65877715519e-05 , 0.000236732139329 , 0.000937004733305 ,
 0.00288899112725  , 0.00693899991059  , 0.012984570932    , 0.0189313514779   ,
 0.0215087023967   , 0.0190456568419   , 0.0131467016174   , 0.00707605461169  ,
 0.00297073695691  , 0.000973238668438 , 0.000248935941658 , 4.97459896964e-05 ,
 7.77302756524e-06 , 9.50663784262e-07 , 9.11193599106e-08 , 6.87024189525e-09 ,
 7.63718514413e-10 , 6.4260030016e-09  , 8.9446362826e-08  , 9.75411863089e-07 ,
 8.31517545992e-06 , 5.5462217393e-05  , 0.000289749210728 , 0.00118705882748  ,
 0.00381886709623  , 0.00966142412428  , 0.0192504053882   , 0.0302519829621   ,
 0.037543254654    , 0.0368295718509   , 0.0285758368339   , 0.0175383516391   ,
 0.00851156151114  , 0.00326373764186  , 0.000987670601338 , 0.000235562341306 ,
 4.42134851168e-05 , 6.52101003304e-06 , 7.54700508065e-07 , 6.84506124801e-08 ,
 4.85996023777e-09 , 2.69848650466e-10 , 1.17081110795e-11 , 3.96803578776e-13 ,
 1.24704600562e-14 , 2.54773503369e-14 , 2.62099581966e-13 , 2.44773216324e-12 ,
 2.65225773686e-11 , 3.89132091585e-10 , 6.12788994031e-09 , 8.30401321997e-08 ,
 8.99249753043e-07 , 7.64962501367e-06 , 5.0960893559e-05  , 0.000265917019254 ,
 0.00108793084981  , 0.00349431795584  , 0.00882371450715  , 0.0175434585575   ,
 0.0300804356107   , 0.0372327853957   , 0.0364240471008   , 0.0281810433879   ,
 0.0172472529609   , 0.00834750984993  , 0.0031926763237   , 0.000963924171996 ,
 0.000229425152793 , 4.29845836277e-05 , 6.33012959245e-06 , 7.31784007955e-07 ,
 6.6854177759e-08  , 6.9500420237e-09  , 7.29025741763e-09 , 1.72124525221e-08 ,
 3.29592503809e-08 , 4.95019504096e-08 , 5.83521992133e-08 , 5.40661663698e-08 ,
 3.94537621394e-08 , 2.27671674157e-08 , 1.0552065412e-08  , 4.35063908995e-09 ,
 3.89886028188e-09 , 2.34098931501e-08 , 1.93747701602e-07 , 1.33089097856e-06 ,
 7.25532872412e-06 , 3.12543769685e-05 , 0.000106414739832 , 0.000286540514009 ,
 0.000610364405383 , 0.00102843026281  , 0.00137042522232  , 0.0014453845613   ,
 0.00121439623293  , 0.000837968824402 , 0.000531218343671 , 0.000393299462318 ,
 0.000374850865143 , 0.000368168285578 , 0.000308677178157 , 0.000206932947234 ,
 0.000109017539268 , 4.49231338375e-05 , 1.4456541582e-05  , 3.63037788839e-06 ,
 7.11091022215e-07 , 1.08601210043e-07 , 1.29290443443e-08 , 1.19958937052e-09 ,
 8.67291328021e-11 , 4.8855221139e-12  , 2.14469210419e-13 , 8.06186962041e-15 ,
 6.37835832752e-15 , 4.07639307592e-14 , 2.09868623361e-13 , 8.44672810549e-13 ,
 2.66145900712e-12 , 6.63921150554e-12 , 1.51997683543e-11 , 8.03650142799e-11 ,
 1.19067735165e-09 , 1.76351265255e-08 , 2.09999915453e-07 , 1.97987373233e-06 ,
 1.47665335294e-05 , 8.70945150248e-05 , 0.000405934110818 , 0.0014934782244   ,
 0.00433150919826  , 0.0098887011645   , 0.0177440486474   , 0.0249896992092   ,
 0.0275865618702   , 0.0238430075503   , 0.016118323514    , 0.00851552791508  ,
 0.00351354711967  , 0.00113180147173  , 0.000285034866202 , 5.70138880209e-05 ,
 1.0283577353e-05  , 2.90208319142e-06 , 1.67844385175e-06 , 1.05320201498e-06 ,
 5.43994777619e-07 , 2.22032624638e-07 , 7.12823371247e-08 , 1.80074634904e-08 ,
 3.58741211478e-09 , 5.66069374128e-10 , 7.12905112995e-11 , 7.25358734961e-12 ,
 6.06719137151e-13 , 4.274015615e-14   , 3.17621488223e-15 , 2.06387820583e-15 ,
 4.68467167297e-15 , 8.84708736375e-15 , 1.30732073034e-14 , 1.51365791039e-14 ,
 1.39395039977e-14 , 1.15472773672e-14 , 1.65938145857e-14 , 6.21816193517e-14 ,
 2.7211211955e-13  , 1.02540437352e-12 , 3.74595190539e-12 , 2.87609998214e-11 ,
 5.03992665685e-10 , 8.70738119193e-09 , 1.19944384609e-07 , 1.28959383439e-06 ,
 1.08014008078e-05 , 7.04678737666e-05 , 0.000358088791926 , 0.00141740764504  ,
 0.00437044032292  , 0.010498092499    , 0.0196465813086   , 0.0286485194199   ,
 0.0325549367266   , 0.0288343131988   , 0.0199104943086   , 0.0107217490432   ,
 0.00450433672203  , 0.0014770629017   , 0.000378318742599 , 7.57499061814e-05 ,
 1.18702396707e-05 , 1.4578875249e-06  , 1.40603886187e-07 , 1.06876113069e-08 ,
 9.52243129912e-10 , 5.6177900816e-09  , 7.80033233403e-08 , 8.5061970609e-07  ,
 7.25134912923e-06 , 4.83664961386e-05 , 0.000252679296657 , 0.00103518897899  ,
 0.0033302891472   , 0.00842536152657  , 0.0167875483824   , 0.0263816069011   ,
 0.0327400483899   , 0.0321176726869   , 0.0249199034379   , 0.015294531245    ,
 0.00742260995527  , 0.00284618180579  , 0.000861310069654 , 0.00020542498311  ,
 3.85569033785e-05 , 5.68672551168e-06 , 6.5814568773e-07  , 5.96931828519e-08 ,
 4.23818698788e-09 , 2.35324772671e-10 , 1.02101945689e-11 , 3.45935996131e-13 ,
 9.25708139651e-15 , 1.86228386333e-15 , 2.8054180625e-14  , 6.45121075027e-13 ,
 1.64346700297e-11 , 3.64420671499e-10 , 6.46839049363e-09 , 9.01211853514e-08 ,
 9.81869875413e-07 , 8.36340436288e-06 , 5.57317647928e-05 , 0.000290829435924 ,
 0.00118986916399  , 0.00382174368458  , 0.00965052287085  , 0.0191873353677   ,
 0.0258002679886   , 0.0319349045962   , 0.0312412422782   , 0.0241711417105   ,
 0.0147931284764   , 0.00715973644892  , 0.00273838802894  , 0.00082676668293  ,
 0.000196780078592 , 3.68682953384e-05 , 5.42958072605e-06 , 6.28775555868e-07 ,
 6.30757980015e-08 , 2.8935338376e-08  , 7.81779067928e-08 , 1.90866142875e-07 ,
 3.65814104881e-07 , 5.49536997076e-07 , 6.47879050197e-07 , 6.00398185342e-07 ,
 4.38363404995e-07 , 2.53567058014e-07 , 1.18829853598e-07 , 5.0150854801e-08  ,
 2.75604841538e-08 , 3.08277771462e-08 , 7.78824056912e-08 , 3.65551325552e-07 ,
 1.84639590761e-06 , 7.84256234207e-06 , 2.66265522621e-05 , 7.16665943065e-05 ,
 0.000152807175979 , 0.00025852193878  , 0.000349497670218 , 0.00038835299825  ,
 0.000391241360843 , 0.000444019990838 , 0.000642899787382 , 0.000988033020178 ,
 0.00132622200806  , 0.00143954244845  , 0.00123513755971  , 0.000831819563216 ,
 0.000438494583531 , 0.000180672870118 , 5.813201457e-05   , 1.45965460664e-05 ,
 2.8588404812e-06  , 4.36595150865e-07 , 5.19754567423e-08 , 4.82233158029e-09 ,
 3.48646253029e-10 , 1.96394945311e-11 , 8.63415309519e-13 , 4.61501240844e-14 ,
 1.41690400301e-13 , 9.28877021591e-13 , 4.78261185494e-12 , 1.92481172529e-11 ,
 6.0605932681e-11  , 1.49537632765e-10 , 2.92205776437e-10 , 5.18866125215e-10 ,
 2.05894944551e-09 , 2.36554600447e-08 , 2.76516175913e-07 , 2.60395121171e-06 ,
 1.94196982718e-05 , 0.000114538839506 , 0.000533847728762 , 0.00196408708467  ,
 0.00569640797253  , 0.0130047227349   , 0.0233353631573   , 0.0328641854706   ,
 0.0362793434255   , 0.0313561587116   , 0.0211973462452   , 0.0111988032512   ,
 0.00462053788123  , 0.00148800478984  , 0.000373907403638 , 7.3367952166e-05  ,
 1.13516680028e-05 , 1.50532372863e-06 , 2.68876499732e-07 , 1.04896850259e-07 ,
 5.03363175699e-08 , 2.03476556997e-08 , 6.50915573795e-09 , 1.6363841266e-09  ,
 3.23378997159e-10 , 5.0350634127e-11  , 6.20454606103e-12 , 6.09938757733e-13 ,
 4.95343276545e-14 , 9.04761971841e-15 , 2.36208293153e-14 , 7.27699316129e-14 ,
 1.76198048817e-13 , 3.33157260677e-13 , 4.9231133994e-13  , 5.69930559166e-13 ,
 5.23596776514e-13 , 4.20761616273e-13 , 5.12644153478e-13 , 1.64256107967e-12 ,
 6.80101022964e-12 , 2.45937930704e-11 , 7.3351535414e-11  , 1.98264107813e-10 ,
 9.16920158419e-10 , 1.08640146668e-08 , 1.43322019678e-07 , 1.53425316021e-06 ,
 1.28450392885e-05 , 8.38032286748e-05 , 0.000425910019598 , 0.00168619084428  ,
 0.00520059052998  , 0.0124966203649   , 0.0233978323961   , 0.0341402520443   ,
 0.0388286101197   , 0.034430670251    , 0.023812284767    , 0.0128506703275   ,
 0.00541503633481  , 0.00178325573857  , 0.000459508362423 , 9.28052481085e-05 ,
 1.47250278611e-05 , 1.84123298377e-06 , 1.82196745008e-07 , 1.4352747098e-08  ,
 1.11681534401e-09 , 3.85030995655e-09 , 5.31123651015e-08 , 5.79173814746e-07 ,
 4.9373312404e-06  , 3.29319976271e-05 , 0.000172045417019 , 0.000704844132231 ,
 0.00226754226684  , 0.00573669808549  , 0.0114303815168   , 0.0179628272715   ,
 0.0222921915368   , 0.0218684255663   , 0.0169675760372   , 0.010413809287    ,
 0.00505394008144  , 0.00193792108087  , 0.000586452677671 , 0.000139870687282 ,
 2.62527979478e-05 , 3.87200326689e-06 , 4.48121198702e-07 , 4.06441630669e-08 ,
 2.88571583578e-09 , 1.60228990593e-10 , 6.95196302487e-12 , 2.35538070295e-13 ,
 6.23295566246e-15 , 4.35677272485e-16 , 1.28138793726e-14 , 4.64942358707e-13 ,
 1.35492783101e-11 , 3.09906103821e-10 , 5.53783312807e-09 , 7.726732401e-08   ,
 8.42087438987e-07 , 7.17323819197e-06 , 4.78014622838e-05 , 0.000249446887774 ,
 0.00102056160893  , 0.00327794480003  , 0.00827734270843  , 0.016457155083    ,
 0.0173331442086   , 0.0214545177168   , 0.0209885012788   , 0.0162386640769   ,
 0.00993832425674  , 0.004810056408    , 0.00183970471268  , 0.000555438655869 ,
 0.000132200870996 , 2.47690458647e-05 , 3.64918559728e-06 , 4.32171127964e-07 ,
 9.23757698513e-08 , 2.19738849561e-07 , 6.79553093603e-07 , 1.66340377534e-06 ,
 3.18823535994e-06 , 4.78950566753e-06 , 5.64680449321e-06 , 5.23381134267e-06 ,
 3.82423885449e-06 , 2.22029533198e-06 , 1.0592792975e-06  , 4.81826897237e-07 ,
 3.09116108769e-07 , 3.25123455603e-07 , 3.97384317717e-07 , 4.97388454064e-07 ,
 8.02679934697e-07 , 2.02628521128e-06 , 5.91861440192e-06 , 1.53462892545e-05 ,
 3.30429387704e-05 , 6.01895420278e-05 , 0.000101237428549 , 0.000184132977528 ,
 0.000394427946243 , 0.000888353948529 , 0.00180831261991  , 0.00306818332135  ,
 0.00419545451764  , 0.00455619628154  , 0.00390104616896  , 0.00262261629007  ,
 0.00138094897138  , 0.000568601951631 , 0.000182874773139 , 4.59075140295e-05 ,
 8.99003683521e-06 , 1.37281964778e-06 , 1.63422111055e-07 , 1.51619949409e-08 ,
 1.09616612205e-09 , 6.17487655717e-11 , 2.73710816054e-12 , 3.88873763557e-13 ,
 2.50412071947e-12 , 1.64911304573e-11 , 8.49109292319e-11 , 3.41732026639e-10 ,
 1.07595723e-09    , 2.65310246526e-09 , 5.1323900647e-09  , 7.86838682443e-09 ,
 1.08862936026e-08 , 3.28036503275e-08 , 2.93468370267e-07 , 2.7098011428e-06  ,
 2.01841773734e-05 , 0.000119038678441 , 0.000554818144073 , 0.0020412390486   ,
 0.00592017037736  , 0.01351556535     , 0.024252006915    , 0.0341551338998   ,
 0.0377044437336   , 0.0325878697303   , 0.0220300051231   , 0.0116387036383   ,
 0.00480202716728  , 0.00154642408965  , 0.000388526899947 , 7.61335623274e-05 ,
 1.16404266902e-05 , 1.39703273267e-06 , 1.38893024798e-07 , 1.61684918591e-08 ,
 4.09540888267e-09 , 1.47907905613e-09 , 4.66387368791e-10 , 1.16775372916e-10 ,
 2.29683076891e-11 , 3.54885259934e-12 , 4.32382981458e-13 , 4.67366637281e-14 ,
 3.71083206105e-14 , 1.73242483857e-13 , 6.88391375689e-13 , 2.13608711181e-12 ,
 5.17268156514e-12 , 9.78061460129e-12 , 1.44530377496e-11 , 1.67306495283e-11 ,
 1.53484103096e-11 , 1.20941223656e-11 , 1.29665007718e-11 , 3.5266171338e-11  ,
 1.36366503269e-10 , 4.7722265031e-10  , 1.38218558498e-09 , 3.27387212439e-09 ,
 6.78180426081e-09 , 1.96428567442e-08 , 1.47486666506e-07 , 1.45573707334e-06 ,
 1.20732486854e-05 , 7.86952885365e-05 , 0.00040010117143  , 0.00158528485888  ,
 0.00489502312927  , 0.0117808858643   , 0.022104411775    , 0.0323444067227   ,
 0.0369260298658   , 0.0329114047874   , 0.0229197979783   , 0.0124865133347   ,
 0.00533036322813  , 0.00178713628034  , 0.000472082962172 , 9.86697420242e-05 ,
 1.64071317413e-05 , 2.18491768876e-06 , 2.34705657767e-07 , 2.04793595173e-08 ,
 1.57032685334e-09 , 2.10616353952e-09 , 2.8223745414e-08  , 3.07738447281e-07 ,
 2.62340253963e-06 , 1.74980939858e-05 , 9.14146451393e-05 , 0.000374512017482 ,
 0.00120483634643  , 0.00304813826979  , 0.00607342112488  , 0.00954437211507  ,
 0.0118447373608   , 0.0116195734681   , 0.00901555513184  , 0.00553327543978  ,
 0.00268536149992  , 0.00102969536175  , 0.000311605879129 , 7.43189180206e-05 ,
 1.39491667369e-05 , 2.05735096438e-06 , 2.3810480435e-07  , 2.15958774615e-08 ,
 1.53329681006e-09 , 8.51361028374e-11 , 3.69385737026e-12 , 1.25150695392e-13 ,
 3.30945071914e-15 , 2.36703371564e-16 , 8.22668303963e-15 , 3.09356642962e-13 ,
 9.08411077038e-12 , 2.08110866585e-10 , 3.72008364382e-09 , 5.19087241269e-08 ,
 5.65729024141e-07 , 4.81912270084e-06 , 3.21139871379e-05 , 0.000167583479963 ,
 0.000685634016972 , 0.00220218990913  , 0.00556088699684  , 0.0110562511375   ,
 0.00911139249308  , 0.0112778460339   , 0.0110328784375   , 0.00853606478938  ,
 0.00522420929158  , 0.00252846865636  , 0.000967064689175 , 0.0002919735553   ,
 6.9493217405e-05  , 1.3021376995e-05  , 1.92840378592e-06 , 2.93967093643e-07 ,
 3.91183427209e-07 , 1.48805501917e-06 , 4.65393043245e-06 , 1.13941399419e-05 ,
 2.18392071111e-05 , 3.28081856068e-05 , 3.86827589294e-05 , 3.58625540181e-05 ,
 2.62351237289e-05 , 1.53187866903e-05 , 7.50665166228e-06 , 3.77602133312e-06 ,
 2.88359219423e-06 , 3.290104788e-06   , 3.96384438079e-06 , 4.36567327591e-06 ,
 4.46509388985e-06 , 4.95993226935e-06 , 7.2488722953e-06  , 1.31284171337e-05 ,
 2.60374896133e-05 , 5.81823928318e-05 , 0.000149457646305 , 0.00040412882642  ,
 0.00104217827279  , 0.00240873231042  , 0.00478349936242  , 0.00790271289136  ,
 0.0106085421433   , 0.0113915632543   , 0.00968947486707  , 0.00648936596882  ,
 0.00340951031688  , 0.00140207099519  , 0.000450601754187 , 0.000113066348817 ,
 2.21359979229e-05 , 3.37975044914e-06 , 4.02292851033e-07 , 3.73219321571e-08 ,
 2.69817497711e-09 , 1.52011809914e-10 , 7.04832948513e-12 , 4.32592188721e-12 ,
 3.46119383035e-11 , 2.28124449753e-10 , 1.17458947838e-09 , 4.72724525347e-09 ,
 1.4883889377e-08  , 3.66994266054e-08 , 7.09524837393e-08 , 1.07757819515e-07 ,
 1.29823887864e-07 , 1.40514412929e-07 , 3.24946750452e-07 , 2.27243044666e-06 ,
 1.65823075225e-05 , 9.76702129289e-05 , 0.000455187105826 , 0.00167467681328  ,
 0.00485703475435  , 0.0110884594838   , 0.0198968662273   , 0.0280216038412   ,
 0.030933533694    , 0.0267357867202   , 0.0180738882925   , 0.009548641711    ,
 0.00393968535559  , 0.0012687176953   , 0.000318751961767 , 6.24550417456e-05 ,
 9.54117857374e-06 , 1.13668720767e-06 , 1.05995573054e-07 , 8.00696701199e-09 ,
 6.2935264142e-10  , 1.00345204432e-10 , 2.66864565578e-11 , 6.538125044e-12   ,
 1.27996428436e-12 , 1.98150186616e-13 , 3.79072920127e-14 , 1.2092433719e-13  ,
 7.76697374226e-13 , 3.96143563913e-12 , 1.5758676072e-11  , 4.88999901713e-11 ,
 1.18414718007e-10 , 2.23901888639e-10 , 3.30869321589e-10 , 3.83010094964e-10 ,
 3.51103995662e-10 , 2.73308060994e-10 , 2.66864386254e-10 , 6.19483660001e-10 ,
 2.20631305237e-09 , 7.40956015999e-09 , 2.09307879281e-08 , 4.84642550914e-08 ,
 9.22349680474e-08 , 1.52385516487e-07 , 2.98755850522e-07 , 1.3266261728e-06  ,
 9.35059237013e-06 , 5.9563968734e-05  , 0.000302298533392 , 0.00120088599341  ,
 0.00372533313672  , 0.00902506903111  , 0.0170856874892   , 0.0253006333      ,
 0.0293445392484   , 0.0267056627606   , 0.0191163192473   , 0.0107969323013   ,
 0.00483104897556  , 0.00172095146155  , 0.000490836221023 , 0.000112744453838 ,
 2.09659991311e-05 , 3.16761640315e-06 , 3.89197296946e-07 , 3.88194297734e-08 ,
 3.17643385251e-09 , 1.04064304097e-09 , 1.17066271822e-08 , 1.2754752823e-07  ,
 1.08731147954e-06 , 7.25236709293e-06 , 3.78882731302e-05 , 0.000155222542157 ,
 0.000499363843739 , 0.00126335003684  , 0.00251722727866  , 0.00395581886251  ,
 0.00490924231666  , 0.00481591951207  , 0.00373664214016  , 0.00229335519322  ,
 0.00111299135721  , 0.000426773839657 , 0.000129150079174 , 3.08026734711e-05 ,
 5.78145699149e-06 , 8.52702268266e-07 , 9.86863740169e-08 , 8.95075950356e-09 ,
 6.35499577125e-10 , 3.52860300734e-11 , 1.53097872575e-12 , 5.18707190074e-14 ,
 1.37159263448e-15 , 1.15983571402e-16 , 4.31434454884e-15 , 1.62537835556e-13 ,
 4.77468892917e-12 , 1.09393787835e-10 , 1.95550116499e-09 , 2.72864679869e-08 ,
 2.97382748784e-07 , 2.53323435303e-06 , 1.6881134483e-05  , 8.80924337583e-05 ,
 0.000360412430497 , 0.00115760974253  , 0.00292315251215  , 0.00581186208361  ,
 0.00374418070918  , 0.00463445006824  , 0.00453378456078  , 0.0035077590106   ,
 0.00214680507564  , 0.00103903366857  , 0.000397399736515 , 0.00011998189633  ,
 2.85577262599e-05 , 5.35743348767e-06 , 8.47269099741e-07 , 4.81124400124e-07 ,
 2.00913843585e-06 , 8.01607199302e-06 , 2.50922535966e-05 , 6.14339251777e-05 ,
 0.000117751198637 , 0.000176896150538 , 0.000208587973192 , 0.000193454907597 ,
 0.000141778708846 , 8.350436697e-05   , 4.25440694052e-05 , 2.42740494591e-05 ,
 2.18269602275e-05 , 2.64403904428e-05 , 3.18789338142e-05 , 3.45836954401e-05 ,
 3.42158979029e-05 , 3.51108206466e-05 , 4.51963739966e-05 , 7.1726679214e-05  ,
 0.000123315251139 , 0.000234729223055 , 0.000519489971541 , 0.00123192224687  ,
 0.00280978388342  , 0.00582681139314  , 0.0106420547086   , 0.0166070948636   ,
 0.0215143651458   , 0.0226202950369   , 0.019006972096    , 0.0126406193858   ,
 0.00661463139303  , 0.00271375351952  , 0.000870970676348 , 0.000218372758107 ,
 4.27327117365e-05 , 6.52266698997e-06 , 7.76266719671e-07 , 7.20094986887e-08 ,
 5.20560408226e-09 , 2.9350747703e-10  , 1.69484764129e-11 , 4.4613598259e-11  ,
 3.7304825379e-10  , 2.45908355174e-09 , 1.26615756276e-08 , 5.09576953451e-08 ,
 1.60441981211e-07 , 3.95603297778e-07 , 7.64808969427e-07 , 1.16088902295e-06 ,
 1.3861786009e-06  , 1.3145577651e-06  , 1.11691749883e-06 , 2.0003040797e-06  ,
 1.09706009379e-05 , 6.3261829121e-05  , 0.000294436355539 , 0.00108316989145  ,
 0.00314148181788  , 0.0071719031172   , 0.0128690909922   , 0.0181240887388   ,
 0.0200074953885   , 0.0172924352837   , 0.0116900073617   , 0.00617596446095  ,
 0.00254814844264  , 0.00082059364076  , 0.000206165362701 , 4.03949977442e-05 ,
 6.17074627999e-06 , 7.34780157759e-07 , 6.8205742241e-08  , 4.94663747767e-09 ,
 2.86455834436e-10 , 1.57488779229e-11 , 1.55402832046e-12 , 2.95761526631e-13 ,
 5.76813869838e-14 , 3.19837037446e-14 , 2.53425405972e-13 , 2.1191646552e-12  ,
 1.38667989429e-11 , 7.07402719138e-11 , 2.81405499511e-10 , 8.73213498902e-10 ,
 2.11454751862e-09 , 3.9982717336e-09  , 5.90856280771e-09 , 6.84012573408e-09 ,
 6.26898421634e-09 , 4.84627711948e-09 , 4.43674110829e-09 , 8.94046564099e-09 ,
 2.90161261454e-08 , 9.2577366946e-08  , 2.53458503771e-07 , 5.74610004521e-07 ,
 1.07263867074e-06 , 1.67735787871e-06 , 2.32300469252e-06 , 3.46755605698e-06 ,
 9.10609729879e-06 , 4.23584921196e-05 , 0.000203034203952 , 0.000804969632443 ,
 0.00253080604665  , 0.00626884840462  , 0.0122361873254   , 0.0188553553325   ,
 0.0229969404417   , 0.0222679886775   , 0.0171766337993   , 0.0105914656846   ,
 0.00523790198261  , 0.00208308177651  , 0.000667337690573 , 0.000172297041096 ,
 3.58202428598e-05 , 5.98417943123e-06 , 8.00988387243e-07 , 8.56043224935e-08 ,
 7.29357848682e-09 , 7.6140479571e-10  , 3.80621791854e-09 , 4.12231555046e-08 ,
 3.51409184835e-07 , 2.34389889864e-06 , 1.22451443084e-05 , 5.01665098879e-05 ,
 0.000161389839752 , 0.000408303209277 , 0.000813544897605 , 0.00127848457655  ,
 0.00158662234105  , 0.00155646126178  , 0.00120764865893  , 0.00074119148146  ,
 0.000359708655396 , 0.000137929412504 , 4.17401276507e-05 , 9.95514312412e-06 ,
 1.86851416875e-06 , 2.75585595867e-07 , 3.18945359941e-08 , 2.89280383442e-09 ,
 2.0538766713e-10  , 1.14041230867e-11 , 4.94798360572e-13 , 1.67641432054e-14 ,
 4.43284938499e-16 , 4.52115804343e-17 , 1.77270143995e-15 , 6.679067381e-14   ,
 1.96207171141e-12 , 4.49535742539e-11 , 8.03581672165e-10 , 1.12129361097e-08 ,
 1.22204672883e-07 , 1.04099205269e-06 , 6.93703164433e-06 , 3.62001737185e-05 ,
 0.00014810571168  , 0.000475701169716 , 0.00120122267308  , 0.00238829157172  ,
 0.00120190093915  , 0.00148768190483  , 0.00145536776795  , 0.0011260083785   ,
 0.000689135284074 , 0.000333535061685 , 0.000127567335226 , 3.85149806285e-05 ,
 9.1697383823e-06  , 1.7474483006e-06  , 5.05180943617e-07 , 1.68708739716e-06 ,
 8.50690663095e-06 , 3.40676326605e-05 , 0.000106646644716 , 0.000261105592455 ,
 0.000500467153025 , 0.000751865802297 , 0.000886677163137 , 0.000822828548307 ,
 0.00060469325296  , 0.000360775001318 , 0.000194142593676 , 0.000128287161257 ,
 0.00013288270802  , 0.000167633519232 , 0.000201766701856 , 0.000216293215271 ,
 0.000209566096454 , 0.000206474507811 , 0.000251165349907 , 0.000377096132209 ,
 0.000596287796948 , 0.000972852577558 , 0.00176887284966  , 0.00352143057149  ,
 0.00692673366146  , 0.0125670927707   , 0.0204529625104   , 0.0292241095648   ,
 0.035658760153    , 0.0361149007379   , 0.0296776922495   , 0.0194831805516   ,
 0.0101192522931   , 0.00413366493914  , 0.00132335902472  , 0.000331310506431 ,
 6.47772350362e-05 , 9.88247059166e-06 , 1.17576246782e-06 , 1.09048539095e-07 ,
 7.8824351068e-09  , 4.46425432433e-10 , 5.37702261165e-11 , 3.71786389752e-10 ,
 3.13404089489e-09 , 2.06597031348e-08 , 1.06374756826e-07 , 4.28115157822e-07 ,
 1.34793465572e-06 , 3.32361468257e-06 , 6.42543927405e-06 , 9.75272441065e-06 ,
 1.16391345882e-05 , 1.0943285633e-05  , 8.18171869756e-06 , 5.47271027663e-06 ,
 7.64559627312e-06 , 3.29636922777e-05 , 0.00015013292208  , 0.000551555745296 ,
 0.00159952328457  , 0.00365164151282  , 0.00655241581117  , 0.00922804596136  ,
 0.0101869997128   , 0.00880460196705  , 0.00595207442569  , 0.00314454892814  ,
 0.00129741314081  , 0.000417812772988 , 0.000104970978834 , 2.05674735456e-05 ,
 3.14187861409e-06 , 3.74105703444e-07 , 3.47155046124e-08 , 2.51063752925e-09 ,
 1.41701270829e-10 , 6.32716180581e-12 , 2.50970746766e-13 , 1.66718560076e-14 ,
 2.5635765295e-14  , 3.26843692492e-13 , 3.51782802616e-12 , 2.95327810664e-11 ,
 1.9324943498e-10  , 9.85821477128e-10 , 3.92154903008e-09 , 1.21686380673e-08 ,
 2.9467157623e-08  , 5.57182140327e-08 , 8.23425955171e-08 , 9.53383946285e-08 ,
 8.74005764678e-08 , 6.7365803189e-08  , 5.92011788303e-08 , 1.06146359464e-07 ,
 3.12345459289e-07 , 9.37447626506e-07 , 2.46842608694e-06 , 5.45159922815e-06 ,
 9.97925535681e-06 , 1.53165060509e-05 , 2.0406683128e-05  , 2.51000835924e-05 ,
 3.25632725465e-05 , 6.10519787809e-05 , 0.000190351709629 , 0.000679086972026 ,
 0.00212579350677  , 0.00542859589882  , 0.0111326809618   , 0.0182730721773   ,
 0.0239899495118   , 0.0251880574794   , 0.0211477654599   , 0.0141956385461   ,
 0.00761600580482  , 0.00326422127085  , 0.00111694782776  , 0.000304867501582 ,
 6.63013284499e-05 , 1.14722550423e-05 , 1.57672255355e-06 , 1.71796008839e-07 ,
 1.48131679577e-08 , 1.07614517417e-09 , 1.00644042616e-09 , 1.03881397505e-08 ,
 8.85372902725e-08 , 5.90543193403e-07 , 3.08515295038e-06 , 1.2639406453e-05  ,
 4.06620230621e-05 , 0.000102871621519 , 0.000204971895625 , 0.000322113024068 ,
 0.000399748053049 , 0.000392148996609 , 0.000304265979172 , 0.000186742518358 ,
 9.06282679496e-05 , 3.47511897948e-05 , 1.05163871267e-05 , 2.50818923869e-06 ,
 4.7077044217e-07  , 6.94335397568e-08 , 8.03579928044e-09 , 7.2883929007e-10  ,
 5.17472355779e-11 , 2.8732584199e-12  , 1.24663996071e-13 , 4.22371060325e-15 ,
 1.11685214707e-16 , 1.38949595382e-17 , 5.69042663606e-16 , 2.1440116802e-14  ,
 6.29834771772e-13 , 1.4430323813e-11  , 2.57953776744e-10 , 3.59940917723e-09 ,
 3.92283178706e-08 , 3.34163712386e-07 , 2.22682223312e-06 , 1.16204388006e-05 ,
 4.75426823084e-05 , 0.000152702480742 , 0.000385598551736 , 0.000766653670315 ,
 0.0003011990103   , 0.000372816346822 , 0.000364718353277 , 0.000282180168223 ,
 0.000172698813057 , 8.35846193198e-05 , 3.19686897807e-05 , 9.65256613301e-06 ,
 2.30659564383e-06 , 5.31006527879e-07 , 9.1010681638e-07  , 5.57039812695e-06 ,
 2.85338488958e-05 , 0.000114296001897 , 0.000357790951559 , 0.000875982632867 ,
 0.00167902618093  , 0.00252254994582  , 0.00297541233057  , 0.00276358230341  ,
 0.00203931065564  , 0.00123987814717  , 0.000718204083428 , 0.000556106256648 ,
 0.000645774190515 , 0.000836388770537 , 0.00100342510676  , 0.0010644411518   ,
 0.0010129778705   , 0.000963181804213 , 0.00111387464595  , 0.00160037564429  ,
 0.0023968939931   , 0.00351307189354  , 0.00541487901844  , 0.00911633893722  ,
 0.015542586792    , 0.0246673850898   , 0.0352094826491   , 0.0447243392944   ,
 0.0497899822797   , 0.0473453982973   , 0.037390516063    , 0.0239687675796   ,
 0.0122766693875   , 0.00497455288206  , 0.00158510138082  , 0.000395754501835 ,
 7.72531811775e-05 , 1.17746730379e-05 , 1.40010182082e-06 , 1.29812102967e-07 ,
 9.38217565573e-09 , 5.4450016435e-10  , 2.47746470172e-10 , 2.43133757832e-09 ,
 2.0525393422e-08  , 1.35304709283e-07 , 6.96670502135e-07 , 2.80381559371e-06 ,
 8.8279056142e-06  , 2.17670466151e-05 , 4.20815382605e-05 , 6.38724906845e-05 ,
 7.62244727075e-05 , 7.16298707868e-05 , 5.31069863231e-05 , 3.13463271728e-05 ,
 1.65428184192e-05 , 1.81238998452e-05 , 6.1512641152e-05  , 0.000221069256514 ,
 0.000640217940114 , 0.00146146318007  , 0.00262239945724  , 0.00369323547547  ,
 0.0040770264998   , 0.00352376524037  , 0.0023821307364   , 0.00125850688651  ,
 0.00051924883651  , 0.000167216431951 , 4.20113352601e-05 , 8.23148465937e-06 ,
 1.25743781804e-06 , 1.497236669e-07   , 1.38934663877e-08 , 1.00458975894e-09 ,
 5.66002641232e-11 , 2.4869432753e-12  , 8.65935178263e-14 , 1.70552788582e-14 ,
 2.57446476896e-13 , 3.55570224799e-12 , 3.82927969023e-11 , 3.21422337383e-10 ,
 2.10302085407e-09 , 1.07274090485e-08 , 4.26713701206e-08 , 1.32406973012e-07 ,
 3.20629523681e-07 , 6.06272658187e-07 , 8.96032926431e-07 , 1.0377011541e-06  ,
 9.5202806799e-07  , 7.34056306082e-07 , 6.31084197441e-07 , 1.03543742718e-06 ,
 2.76739470874e-06 , 7.74963080409e-06 , 1.94687897478e-05 , 4.1636170595e-05  ,
 7.44166436788e-05 , 0.000111927264321 , 0.000146090986087 , 0.000173761231761 ,
 0.000200034972632 , 0.000250388875569 , 0.000433409024506 , 0.00109690686177  ,
 0.00303709846134  , 0.00747082076387  , 0.015244907171    , 0.0252863436953   ,
 0.0338224345041   , 0.0363206852392   , 0.0312187766961   , 0.0214311477337   ,
 0.0117320648372   , 0.00511604125354  , 0.00177571294659  , 0.000490201172864 ,
 0.000107543875692 , 1.8731218744e-05  , 2.58680653342e-06 , 2.82827790024e-07 ,
 2.44408824235e-08 , 1.67961255285e-09 , 2.76479907685e-10 , 2.04324383142e-09 ,
 1.73861466733e-08 , 1.15964760904e-07 , 6.05830393843e-07 , 2.4819957752e-06  ,
 7.98478708843e-06 , 2.02008639368e-05 , 4.02502586547e-05 , 6.32532206198e-05 ,
 7.84983838049e-05 , 7.70061597792e-05 , 5.97486027251e-05 , 3.66705622877e-05 ,
 1.77966409262e-05 , 6.82407885012e-06 , 2.06509922091e-06 , 4.92532233771e-07 ,
 9.24450252392e-08 , 1.36346396466e-08 , 1.57798706281e-09 , 1.43121913634e-10 ,
 1.01615863498e-11 , 5.64220739778e-13 , 2.44802248205e-14 , 8.29408557428e-16 ,
 2.19315861141e-17 , 3.35985789359e-18 , 1.42603339022e-16 , 5.37294027414e-15 ,
 1.57837974604e-13 , 3.61627078339e-12 , 6.46437819688e-11 , 9.02019830864e-10 ,
 9.83070245932e-09 , 8.37421589171e-08 , 5.58046533523e-07 , 2.91210743913e-06 ,
 1.19143004152e-05 , 3.82675764463e-05 , 9.66318424199e-05 , 0.00019212509053  ,
 5.88972091188e-05 , 7.29014425382e-05 , 7.13179405958e-05 , 5.51782171224e-05 ,
 3.37699589436e-05 , 1.63443516906e-05 , 6.25134451409e-06 , 1.88923009919e-06 ,
 4.74384793576e-07 , 3.5269330696e-07  , 2.26342634617e-06 , 1.47668351306e-05 ,
 7.56820994005e-05 , 0.000303078122172 , 0.000948646608712 , 0.00232248078448  ,
 0.00445156616276  , 0.00668837682331  , 0.00789138565304  , 0.00733925844085  ,
 0.00544890294441  , 0.00340368887958  , 0.00216685229949  , 0.00196625834     ,
 0.00249105668356  , 0.00327923293518  , 0.00391801781387  , 0.00411806052956  ,
 0.00385956414472  , 0.00355948846153  , 0.00393445701177  , 0.00544557528327  ,
 0.00785938539102  , 0.0107139283888   , 0.0145030087531   , 0.020945875434    ,
 0.0312396742602   , 0.0439723685229   , 0.0554009740473   , 0.0617804753751   ,
 0.0609634965166   , 0.052664709525    , 0.0388954390995   , 0.0238907705347   ,
 0.0119248618389   , 0.00475913199259  , 0.00150308909116  , 0.000373348319108 ,
 7.266019378e-05   , 1.10550589419e-05 , 1.31316291486e-06 , 1.21676297684e-07 ,
 8.79469807114e-09 , 5.77551338958e-10 , 1.16849474885e-09 , 1.24127723978e-08 ,
 1.04816645762e-07 , 6.90958626677e-07 , 3.5576773139e-06  , 1.43182050915e-05 ,
 4.50813396642e-05 , 0.000111157466451 , 0.000214897189971 , 0.00032617669707  ,
 0.000389253613505 , 0.000365778803791 , 0.000271052054039 , 0.000158673693793 ,
 7.40202094373e-05 , 3.08649845429e-05 , 2.66060392943e-05 , 7.11125173594e-05 ,
 0.00020141804245  , 0.000459144015307 , 0.000823799928363 , 0.0011601856958   ,
 0.00128074860361  , 0.00110694824052  , 0.000748317564768 , 0.00039534471978  ,
 0.00016311574292  , 5.25290200143e-05 , 1.31973529424e-05 , 2.58582136016e-06 ,
 3.95008877356e-07 , 4.70338714025e-08 , 4.36445772912e-09 , 3.15575322456e-10 ,
 1.7778168547e-11  , 7.80962329486e-13 , 3.31096574716e-14 , 1.26181949766e-13 ,
 2.19618785223e-12 , 3.02877041619e-11 , 3.25924233251e-10 , 2.73447699929e-09 ,
 1.78861779714e-08 , 9.12203280881e-08 , 3.62815466339e-07 , 1.12572450674e-06 ,
 2.72591475301e-06 , 5.15445552431e-06 , 7.618770075e-06   , 8.82684486251e-06 ,
 8.10940360536e-06 , 6.27523211689e-06 , 5.36231339141e-06 , 8.27823716736e-06 ,
 2.02544335775e-05 , 5.26537932381e-05 , 0.000125268106437 , 0.000257792384255 ,
 0.000447694593365 , 0.000657227977307 , 0.000838299380841 , 0.00097318644991  ,
 0.00107888538148  , 0.00120560088442  , 0.00154457781914  , 0.0026877432399   ,
 0.00587797156768  , 0.0127944762657   , 0.0242807213314   , 0.0383102919718   ,
 0.0493820002526   , 0.0515654279679   , 0.0433917219414   , 0.029315781707    ,
 0.0158584317069   , 0.00685499477868  , 0.00236411479226  , 0.000649643405764 ,
 0.000142061245373 , 2.46874308115e-05 , 3.40412882965e-06 , 3.71807706154e-07 ,
 3.21078020746e-08 , 2.19007112507e-09 , 1.46063653081e-10 , 3.17046837448e-10 ,
 2.66066542321e-09 , 1.77455463556e-08 , 9.27073792151e-08 , 3.79808153741e-07 ,
 1.22187445779e-06 , 3.0912433101e-06  , 6.15930799721e-06 , 9.67934320509e-06 ,
 1.20122389097e-05 , 1.17838908771e-05 , 9.14304799241e-06 , 5.61152387859e-06 ,
 2.72333635718e-06 , 1.04425672877e-06 , 3.16012432504e-07 , 7.5369893952e-08  ,
 1.41464279309e-08 , 2.08644485331e-09 , 2.41471947269e-10 , 2.19012740958e-11 ,
 1.55497982276e-12 , 8.63400492532e-14 , 3.74609380287e-15 , 1.26920495208e-16 ,
 3.35608759444e-18 , 6.38174758678e-19 , 2.78850142005e-17 , 1.05063820294e-15 ,
 3.08640330121e-14 , 7.07134649436e-13 , 1.26406070891e-11 , 1.76383217709e-10 ,
 1.92232018941e-09 , 1.6375151568e-08  , 1.09121817333e-07 , 5.6944078484e-07  ,
 2.32975215408e-06 , 7.4829377765e-06  , 1.88956325748e-05 , 3.75686215655e-05 ,
 8.98292628784e-06 , 1.11188339118e-05 , 1.08773203702e-05 , 8.41571116329e-06 ,
 5.15055437338e-06 , 2.49285054825e-06 , 9.53805164083e-07 , 2.92670419128e-07 ,
 1.25998534517e-07 , 5.95991243224e-07 , 4.79019268661e-06 , 3.11452450265e-05 ,
 0.000159090362866 , 0.000636197803977 , 0.00199016342988  , 0.00487119079876  ,
 0.00933612716377  , 0.0140284110933   , 0.0165591993713   , 0.0154319807409   ,
 0.0115616978214   , 0.00750296216866  , 0.00535829886676  , 0.00563581981736  ,
 0.00760324420077  , 0.0100994271849   , 0.012009237648    , 0.012518457043    ,
 0.0115834162786   , 0.0104174298899   , 0.0110791545853   , 0.0148563962099   ,
 0.0208853850548   , 0.0271137708074   , 0.0332728682534   , 0.0419546323081   ,
 0.0551120830132   , 0.0697830558011   , 0.0791781150829   , 0.0784100084498   ,
 0.0679513768126   , 0.0518558700318   , 0.0346164192969   , 0.0197874824882   ,
 0.00942853295965  , 0.00365782743173  , 0.00113606921781  , 0.000279435284356 ,
 5.40733524453e-05 , 8.19969676201e-06 , 9.72084148762e-07 , 8.99687943745e-08 ,
 6.51345177745e-09 , 6.9470137041e-10  , 4.58387886814e-09 , 4.9439984851e-08  ,
 4.17504232046e-07 , 2.75221738764e-06 , 1.4170893872e-05  , 5.70320877773e-05 ,
 0.000179567404358 , 0.00044276097242  , 0.000855975696115 , 0.00129922281634  ,
 0.00155046995133  , 0.00145696302176  , 0.00107961626723  , 0.000631686612782 ,
 0.000292278930207 , 0.000107835749479 , 3.55544800235e-05 , 2.41492973317e-05 ,
 5.08003425157e-05 , 0.00011323563404  , 0.00020287921725  , 0.000285696032652 ,
 0.000315382854171 , 0.000272584611118 , 0.00018427225329  , 9.73531366707e-05 ,
 4.01670451497e-05 , 1.29352046634e-05 , 3.2498314508e-06  , 6.36755235537e-07 ,
 9.72704357565e-08 , 1.15820312582e-08 , 1.0747426905e-09  , 7.77124384916e-11 ,
 4.38571832507e-12 , 2.13047025617e-13 , 8.18864705587e-14 , 8.9415674752e-13  ,
 1.47802842189e-11 , 2.02438748959e-10 , 2.17358066774e-09 , 1.82135299127e-08 ,
 1.19043695518e-07 , 6.06840586956e-07 , 2.41291048056e-06 , 7.48533332824e-06 ,
 1.8123954822e-05  , 3.42708692742e-05 , 5.06642813041e-05 , 5.87362827476e-05 ,
 5.40875243564e-05 , 4.21629133891e-05 , 3.633153893e-05   , 5.4132625573e-05  ,
 0.00012268137337  , 0.000295683933384 , 0.00066229442199  , 0.00130378190406  ,
 0.00218935464902  , 0.00312388130209  , 0.00387803184517  , 0.00438255012167  ,
 0.00472268542733  , 0.00502065175932  , 0.00559687690944  , 0.00742420988611  ,
 0.0123406029258   , 0.0223478211804   , 0.0376602617867   , 0.0545372986675   ,
 0.0657079629531   , 0.0649347757013   , 0.0522311282121   , 0.0340220759946   ,
 0.0178773976963   , 0.00755471997276  , 0.0025607934673   , 0.000694661731472 ,
 0.000150478228237 , 2.59740826976e-05 , 3.5646440819e-06  , 3.88079792833e-07 ,
 3.34401955275e-08 , 2.27584553138e-09 , 1.25450327835e-10 , 4.23593575111e-11 ,
 3.17388988486e-10 , 2.11585130353e-09 , 1.10537406266e-08 , 4.52855082958e-08 ,
 1.4568725118e-07  , 3.68576933338e-07 , 7.34390219521e-07 , 1.15409311962e-06 ,
 1.43225030699e-06 , 1.40502378059e-06 , 1.09014925464e-06 , 6.69076502575e-07 ,
 3.24710435992e-07 , 1.24509430058e-07 , 3.76789794866e-08 , 8.98654735076e-09 ,
 1.68671518267e-09 , 2.48772215083e-10 , 2.87913246819e-11 , 2.61134554374e-12 ,
 1.85404265204e-13 , 1.02945473344e-14 , 4.46656450934e-16 , 1.51330588404e-17 ,
 4.00155002207e-19 , 9.50788958677e-20 , 4.25298635898e-18 , 1.60241982062e-16 ,
 4.70734246143e-15 , 1.07851263635e-13 , 1.92792907089e-12 , 2.69017406079e-11 ,
 2.93189793068e-10 , 2.49751697252e-09 , 1.66431186747e-08 , 8.6850373206e-08  ,
 3.55330790218e-07 , 1.14128800724e-06 , 2.88193748114e-06 , 5.72991765081e-06 ,
 1.06827639854e-06 , 1.32228548779e-06 , 1.29356692353e-06 , 1.00083675032e-06 ,
 6.1257923333e-07  , 2.96742243066e-07 , 1.15338079576e-07 , 5.01420903932e-08 ,
 1.44648453029e-07 , 1.14282191317e-06 , 8.53256346929e-06 , 5.32652120025e-05 ,
 0.000267424761887 , 0.00106176877596  , 0.00331154591067  , 0.00809560881071  ,
 0.0155094471179   , 0.0233057080944   , 0.0275325268029   , 0.0257460377446   ,
 0.0195633801071   , 0.0133977563735   , 0.0109286097238   , 0.0130587106532   ,
 0.0183685880131   , 0.0244685515909   , 0.0289239199269   , 0.0299150418093   ,
 0.0273882708821   , 0.0241577873113   , 0.0249240733457   , 0.0325760789917   ,
 0.044922232569    , 0.0564055262066   , 0.0643862937702   , 0.0722984869101   ,
 0.0840733065023   , 0.0964753871324   , 0.100474289593    , 0.0905545813474   ,
 0.0700157231654   , 0.0469305019673   , 0.0275682239059   , 0.0141574208375   ,
 0.00624033998619  , 0.0023004144623   , 0.000692384289597 , 0.000167154345838 ,
 3.19944260307e-05 , 4.82083058671e-06 , 5.6939284734e-07  , 5.25858844888e-08 ,
 3.84869429649e-09 , 1.23628036793e-09 , 1.42067993606e-08 , 1.53664452212e-07 ,
 1.29765684997e-06 , 8.55424585691e-06 , 4.40449620003e-05 , 0.000177263069292 ,
 0.000558118606919 , 0.00137615811452  , 0.00266048280488  , 0.00403815258676  ,
 0.00481906344114  , 0.00452843801445  , 0.00335560292552  , 0.00196334082938  ,
 0.000908011025245 , 0.00033233498181  , 9.70400963301e-05 , 2.53246690956e-05 ,
 1.35501322181e-05 , 2.23763381541e-05 , 3.91802250755e-05 , 5.50904957914e-05 ,
 6.08086191183e-05 , 5.25563032465e-05 , 3.55290068639e-05 , 1.87703782922e-05 ,
 7.74449233291e-06 , 2.49399956377e-06 , 6.26590643751e-07 , 1.22770943409e-07 ,
 1.87544331939e-08 , 2.23310191519e-09 , 2.07237747176e-10 , 1.50630334004e-11 ,
 1.0970989544e-12  , 6.70788889929e-13 , 1.42399503961e-12 , 6.36642530971e-12 ,
 8.04819333928e-11 , 1.06962791365e-09 , 1.1407773165e-08  , 9.52739875277e-08 ,
 6.21457145839e-07 , 3.16398426899e-06 , 1.25707613526e-05 , 3.89785260132e-05 ,
 9.43531787222e-05 , 0.00017840545955  , 0.000263818731428 , 0.000306189263153 ,
 0.000283032480491 , 0.000223388313643 , 0.000196959754903 , 0.000289524867361 ,
 0.000615597316191 , 0.00137842825165  , 0.00289662801366  , 0.00542837640875  ,
 0.00877634485036  , 0.0121253752797   , 0.0145925672954   , 0.0159850429733   ,
 0.0167244587327   , 0.0172079187221   , 0.0179239656366   , 0.0202904308174   ,
 0.0267196970089   , 0.0390826729354   , 0.0561932958972   , 0.0723124766986   ,
 0.0793447874239   , 0.0725476904092   , 0.0546398105743   , 0.0336720985089   ,
 0.0168999997293   , 0.00688176661868  , 0.00226566038668  , 0.000601051875311 ,
 0.000128060042115 , 2.18411585571e-05 , 2.97232932839e-06 , 3.21753051648e-07 ,
 2.7623431089e-08  , 1.8759059746e-09  , 1.00855153302e-10 , 7.70392667643e-12 ,
 2.96094940802e-11 , 1.96550897534e-10 , 1.02681252218e-09 , 4.20669541513e-09 ,
 1.3533289392e-08  , 3.4238124896e-08  , 6.82195270167e-08 , 1.07206883579e-07 ,
 1.33045669653e-07 , 1.30516522767e-07 , 1.01266962171e-07 , 6.21523562936e-08 ,
 3.01632453625e-08 , 1.15660233645e-08 , 3.50010402387e-09 , 8.34785097039e-10 ,
 1.56683611919e-10 , 2.31091352046e-11 , 2.6745053286e-12  , 2.42575069023e-13 ,
 1.72227120763e-14 , 9.56288813037e-16 , 4.14911460832e-17 , 1.40575145335e-18 ,
 3.71714986285e-20 , 1.10968335328e-20 , 5.05777773606e-19 , 1.90564525923e-17 ,
 5.5981115122e-16  , 1.2825992702e-14  , 2.29275053066e-13 , 3.19923491926e-12 ,
 3.48670012706e-11 , 2.970121386e-10   , 1.97924912024e-09 , 1.03285044187e-08 ,
 4.22569932886e-08 , 1.35725360794e-07 , 3.4272856928e-07  , 6.81418845994e-07 ,
 9.90355524824e-08 , 1.225944852e-07   , 1.19985690021e-07 , 9.30515288334e-08 ,
 5.77164763908e-08 , 3.07161172507e-08 , 2.48624213531e-08 , 8.33630620051e-08 ,
 4.69205447112e-07 , 2.69129964595e-06 , 1.51902277673e-05 , 8.06628390637e-05 ,
 0.00037449121983  , 0.00143617354783  , 0.00441347293133  , 0.0107234955327   ,
 0.0204970156229   , 0.0307925240266   , 0.0364434311632   , 0.0343173397323   ,
 0.026731348756    , 0.0198049351086   , 0.0186952000247   , 0.0246475725963   ,
 0.035379793521    , 0.0468934800886   , 0.0549461812428   , 0.0563480699289   ,
 0.0511363486133   , 0.0445199047634   , 0.0450083861996   , 0.0577231821875   ,
 0.0784246835818   , 0.0961490251683   , 0.104099432959    , 0.106287179731    ,
 0.110185447407    , 0.114791390479    , 0.110939883123    , 0.0930552741651   ,
 0.065977852735    , 0.0396042013538   , 0.0204273153265   , 0.00918698118239  ,
 0.00361047497521  , 0.00122185318853  , 0.000347382636767 , 8.09523884804e-05 ,
 1.51719181481e-05 , 2.25807270195e-06 , 2.64799236393e-07 , 2.43584946477e-08 ,
 1.89098976731e-09 , 2.58087725419e-09 , 3.44549435453e-08 , 3.72871772823e-07 ,
 3.14881168301e-06 , 2.07571897399e-05 , 0.000106876707822 , 0.000430135309899 ,
 0.00135429520436  , 0.00333929818842  , 0.00645576052625  , 0.00979873401967  ,
 0.0116936695167   , 0.0109885292056   , 0.00814274939012  , 0.00476458278942  ,
 0.00220393090781  , 0.000806753604248 , 0.000234107922068 , 5.44195700226e-05 ,
 1.13970216225e-05 , 4.79428205315e-06 , 6.09588562913e-06 , 8.33174908619e-06 ,
 9.17366729612e-06 , 7.92651084862e-06 , 5.3582559258e-06  , 2.83080996509e-06 ,
 1.16796596674e-06 , 3.76126149592e-07 , 9.44976585234e-08 , 1.85153861046e-08 ,
 2.82841632159e-09 , 3.36876073543e-10 , 3.17514782338e-11 , 4.27848766712e-12 ,
 6.50839706861e-12 , 1.58524630029e-11 , 3.17174456939e-11 , 6.71202285627e-11 ,
 3.94152327475e-10 , 4.56390396138e-09 , 4.76009978996e-08 , 3.94004727322e-07 ,
 2.55652890612e-06 , 1.29732031143e-05 , 5.14377019092e-05 , 0.000159293007269 ,
 0.000385318359652 , 0.000728406124453 , 0.00107760990744  , 0.00125308995015  ,
 0.00116575618064  , 0.000938680430592 , 0.000860731943659 , 0.00127091812091  ,
 0.00256382186086  , 0.0053553755785   , 0.0105471379596   , 0.0187574563844   ,
 0.0291077489354   , 0.0388364309437   , 0.0451787627898   , 0.047779455416    ,
 0.0483355979114   , 0.0482644052422   , 0.0483339877145   , 0.0502894557248   ,
 0.0567960679943   , 0.0688216413138   , 0.0831362588764   , 0.0925975660972   ,
 0.0902128300923   , 0.0745920052362   , 0.0514891997096   , 0.0294046643603   ,
 0.0138184820328   , 0.00532296578381  , 0.00167464607391  , 0.00042863575368  ,
 8.88831405128e-05 , 1.48662622791e-05 , 1.99692194145e-06 , 2.14592730309e-07 ,
 1.83932843407e-08 , 1.25568313524e-09 , 6.8507181367e-11  , 3.33159860771e-12 ,
 2.28214224449e-12 , 1.42410404486e-11 , 7.43111134156e-11 , 3.04426960345e-10 ,
 9.79364750153e-10 , 2.47771330752e-09 , 4.93684866901e-09 , 7.75825084474e-09 ,
 9.6281296028e-09  , 9.44510344391e-09 , 7.32839799374e-09 , 4.49778719661e-09 ,
 2.18282747639e-09 , 8.3699997849e-10  , 2.53292521082e-10 , 6.04110148386e-11 ,
 1.13387464557e-11 , 1.67234233852e-12 , 1.93546346171e-13 , 1.75544686311e-14 ,
 1.24635878108e-15 , 6.92039082484e-17 , 3.00259657911e-18 , 1.01730247637e-19 ,
 2.68999601227e-21 , 1.01346166544e-21 , 4.6887542021e-20  , 1.76660634023e-18 ,
 5.18966436253e-17 , 1.18901878049e-15 , 2.12546779264e-14 , 2.96581363362e-13 ,
 3.23230492278e-12 , 2.75341659625e-11 , 1.8348399614e-10  , 9.57492051471e-10 ,
 3.91738590491e-09 , 1.25822659511e-08 , 3.177229072e-08   , 6.31704495844e-08 ,
 7.19033711357e-09 , 9.06035123752e-09 , 9.64741018757e-09 , 1.05688159273e-08 ,
 1.66391854046e-08 , 3.84180616981e-08 , 1.16974056993e-07 , 4.75069623096e-07 ,
 2.17135517696e-06 , 9.40013762478e-06 , 3.73351508152e-05 , 0.000140960815077 ,
 0.000512371080817 , 0.00171248782072  , 0.00492556178483  , 0.011625252826    ,
 0.021970838243    , 0.0329362372697   , 0.0391906334257   , 0.0376029186935   ,
 0.0308909531649   , 0.0258681985378   , 0.0282357842138   , 0.0391864960099   ,
 0.0556443453241   , 0.0722671466208   , 0.083288112399    , 0.0844166333205   ,
 0.0760259139923   , 0.0658303182356   , 0.0660083237128   , 0.0835988169088   ,
 0.112027160478    , 0.134670723383    , 0.140190249141    , 0.132888811907    ,
 0.124417975659    , 0.11794852685     , 0.10628275473     , 0.0841524896814   ,
 0.0560330328113   , 0.0310005681136   , 0.0143523006652   , 0.00565712675454  ,
 0.00193320514594  , 0.000577107052419 , 0.000149022893863 , 3.25330973549e-05 ,
 5.85361138052e-06 , 8.50285631451e-07 , 9.83093437811e-08 , 8.97890517877e-09 ,
 9.06312087632e-10 , 4.74178789902e-09 , 6.5305914305e-08  , 7.06812461798e-07 ,
 5.96886170697e-06 , 3.93471594728e-05 , 0.000202594616865 , 0.000815361012418 ,
 0.00256719125539  , 0.00632994898223  , 0.0122375032616   , 0.018574480394    ,
 0.0221667332088   , 0.0208306969251   , 0.0154375236741   , 0.00903574754031  ,
 0.00418356651516  , 0.00153576555448  , 0.000449267864012 , 0.00010619566822  ,
 2.11345449098e-05 , 4.11265132684e-06 , 1.35039406634e-06 , 1.09641085423e-06 ,
 1.10064912567e-06 , 9.37060879339e-07 , 6.31877483119e-07 , 3.33683176585e-07 ,
 1.37664306199e-07 , 4.43321727589e-08 , 1.11379604814e-08 , 2.18234871613e-09 ,
 3.33665923547e-10 , 4.16399608181e-11 , 1.36906297766e-11 , 4.06098009596e-11 ,
 1.27504112875e-10 , 3.16191208488e-10 , 6.19401196905e-10 , 1.02107897998e-09 ,
 2.37364227013e-09 , 1.68459703856e-08 , 1.61904121048e-07 , 1.30787219008e-06 ,
 8.37285118331e-06 , 4.21322902357e-05 , 0.000166165279262 , 0.000512884089983 ,
 0.00123825317367  , 0.00233900595266  , 0.00346260025281  , 0.00404042437123  ,
 0.00380077019738  , 0.00316024276113  , 0.00307212828146  , 0.00461707275395  ,
 0.00890472638509  , 0.0174275941659   , 0.0321978173896   , 0.0542796142267   ,
 0.080742972836    , 0.103959938091    , 0.116816016192    , 0.119016050137    ,
 0.115918612492    , 0.111966534932    , 0.108664687564    , 0.107693430755    ,
 0.111198334838    , 0.118176478987    , 0.122979435553    , 0.118472160791    ,
 0.101204149548    , 0.0744719046983   , 0.046340879247    , 0.0241156236761   ,
 0.0104302753259   , 0.00373616588112  , 0.00110558462297  , 0.000269574166587 ,
 5.40068748662e-05 , 8.8675461211e-06  , 1.19221869402e-06 , 1.31607483109e-07 ,
 1.20351257564e-08 , 9.3231818295e-10  , 6.6872212845e-11  , 6.73145449708e-12 ,
 1.62879847543e-12 , 1.245382604e-12   , 4.33542922515e-12 , 1.7341311127e-11  ,
 5.57255057062e-11 , 1.40978009032e-10 , 2.80909013659e-10 , 4.41466950989e-10 ,
 5.47893898147e-10 , 5.375050085e-10   , 4.17067737949e-10 , 2.55987070082e-10 ,
 1.24239384323e-10 , 4.76414206954e-11 , 1.44178075617e-11 , 3.43881314614e-12 ,
 6.45462466458e-13 , 9.52012397998e-14 , 1.10182337431e-14 , 9.99361449213e-16 ,
 7.09552312103e-17 , 3.93982707708e-18 , 1.70941570247e-19 , 5.79167418546e-21 ,
 1.5314692683e-22  , 7.2394363185e-23  , 3.3877878241e-21  , 1.27643439324e-19 ,
 3.74971235698e-18 , 8.59107219226e-17 , 1.53572392753e-15 , 2.14290275461e-14 ,
 2.33545215058e-13 , 1.98943982461e-12 , 1.32573845108e-11 , 6.91826564244e-11 ,
 2.83051706344e-10 , 9.09185301233e-10 , 2.29630622406e-09 , 4.56934674592e-09 ,
 8.54769827412e-10 , 2.96496950397e-09 , 1.1974780242e-08  , 4.45317777877e-08 ,
 1.39236492892e-07 , 3.71124481108e-07 , 9.49343597963e-07 , 2.84689908831e-06 ,
 1.03500774408e-05 , 3.81278053005e-05 , 0.000125353305543 , 0.000360311427494 ,
 0.000939081441941 , 0.00232019677842  , 0.00543766044272  , 0.0115013024792   ,
 0.02073181494     , 0.0307541841584   , 0.0372605712764   , 0.037846766907    ,
 0.0351430218435   , 0.0351288418975   , 0.0423906194398   , 0.0572171503846   ,
 0.0761131176872   , 0.0936888907769   , 0.104184141144    , 0.103396043064    ,
 0.0923674133476   , 0.0802998256241   , 0.0809123934346   , 0.101433917936    ,
 0.133348382141    , 0.156809272922    , 0.158145211786    , 0.141986855334    ,
 0.122792603783    , 0.107283905324    , 0.0907720257095   , 0.0684909793965   ,
 0.0435157972244   , 0.0227230613383   , 0.00971970095264  , 0.00343812893669  ,
 0.00102425870678  , 0.000262570810901 , 5.87550727811e-05 , 1.14437691079e-05 ,
 1.90227425178e-06 , 2.62864366936e-07 , 2.95026082688e-08 , 2.66231191684e-09 ,
 5.79311749871e-10 , 6.98422428549e-09 , 9.67777544913e-08 , 1.04745557398e-06 ,
 8.84551165712e-06 , 5.83102405738e-05 , 0.000300233649934 , 0.00120831859548  ,
 0.003804432778    , 0.00938063971926  , 0.0181353887677   , 0.0275268523634   ,
 0.0328518896134   , 0.0308761073348   , 0.0228921602788   , 0.013417429389    ,
 0.00623862508438  , 0.0023195302952   , 0.000704005875124 , 0.000183439487362 ,
 4.50219122744e-05 , 1.13478273783e-05 , 2.91050319324e-06 , 7.37227582373e-07 ,
 2.21835529595e-07 , 1.04470093877e-07 , 6.03275157413e-08 , 3.09164512544e-08 ,
 1.26866188604e-08 , 4.08163186607e-09 , 1.02535022864e-09 , 2.01465848005e-10 ,
 3.54491267823e-11 , 3.46375724802e-11 , 1.59155014241e-10 , 6.39348510586e-10 ,
 2.01954857017e-09 , 5.00876405949e-09 , 9.77775311496e-09 , 1.52712603925e-08 ,
 2.22818538466e-08 , 6.58357443505e-08 , 4.77290557533e-07 , 3.6056800433e-06  ,
 2.23391729487e-05 , 0.000110114956247 , 0.000428543854716 , 0.00131164193389  ,
 0.00315082796329  , 0.00593828277868  , 0.00879835882071  , 0.0103325778576   ,
 0.00991466828911  , 0.0086808569013   , 0.0091458310782   , 0.0140883105442   ,
 0.0260547638039   , 0.0479284008567   , 0.0832334839623   , 0.133114538609    ,
 0.18999408866     , 0.236534776876    , 0.257432078129    , 0.253117900262    ,
 0.236932553793    , 0.220253922514    , 0.206633489636    , 0.197231063306    ,
 0.192605045801    , 0.188692593294    , 0.177271019881    , 0.15258163629     ,
 0.116444956882    , 0.0771149377813   , 0.0436850236752   , 0.0209752153086   ,
 0.00849260638055  , 0.00289427449459  , 0.00083105375117  , 0.00020189647433  ,
 4.18602393666e-05 , 7.51094136085e-06 , 1.18568416619e-06 , 1.66598077204e-07 ,
 2.0923770931e-08  , 2.4450647523e-09  , 3.4677057668e-10  , 9.0386269566e-11  ,
 3.1795877388e-11  , 1.01606194991e-11 , 3.58972798635e-12 , 5.01624873318e-12 ,
 1.46851781651e-11 , 3.70855915572e-11 , 7.41317051636e-11 , 1.16943992754e-10 ,
 1.45732173737e-10 , 1.43585389617e-10 , 1.11902031816e-10 , 6.89809726919e-11 ,
 3.36179326871e-11 , 1.2941088464e-11  , 3.93007184006e-12 , 9.40258698034e-13 ,
 1.76955834498e-13 , 2.61586515993e-14 , 3.03319960847e-15 , 2.75539074368e-16 ,
 1.95880637052e-17 , 1.08874191484e-18 , 4.72768222975e-20 , 1.60282281876e-21 ,
 4.24045818525e-23 , 4.84133343144e-24 , 1.94679664794e-22 , 7.33382254446e-21 ,
 2.1541560495e-19  , 4.93499689638e-18 , 8.82101950184e-17 , 1.23078437385e-15 ,
 1.34135526768e-14 , 1.14275723412e-13 , 7.61898858437e-13 , 3.98227245565e-12 ,
 1.63719396915e-11 , 5.33778150876e-11 , 1.41531520245e-10 , 3.31922637371e-10 ,
 4.88784430913e-09 , 2.44980850097e-08 , 1.08550677309e-07 , 4.0565636293e-07  ,
 1.25054943465e-06 , 3.20731784007e-06 , 7.2945976543e-06  , 1.71095699741e-05 ,
 4.76599630847e-05 , 0.000147488850589 , 0.000431440637419 , 0.00109512087766  ,
 0.00238059256017  , 0.00456483570091  , 0.008118454435    , 0.0138207377051   ,
 0.0221136890443   , 0.0318367472939   , 0.0403771048679   , 0.0463358134178   ,
 0.0516884557473   , 0.0600025258674   , 0.0726902693043   , 0.0879343770419   ,
 0.102578060387    , 0.113509748666    , 0.117448117417    , 0.111861198538    ,
 0.0986338442272   , 0.0867662473345   , 0.0883852930453   , 0.108475830849    ,
 0.137373285101    , 0.15604588357     , 0.152433888211    , 0.131918819592    ,
 0.108911939654    , 0.0906194032709   , 0.0735975269591   , 0.0536972501055   ,
 0.0330040336947   , 0.0165632456062   , 0.00671730507981  , 0.00220403878355  ,
 0.000590618523155 , 0.000131500916044 , 2.48923474651e-05 , 4.09147244527e-06 ,
 5.88193486165e-07 , 7.30424382651e-08 , 7.64069737527e-09 , 6.75685425949e-10 ,
 4.99635328835e-10 , 8.08934843479e-09 , 1.12224000853e-07 , 1.21463962177e-06 ,
 1.02573412318e-05 , 6.76171250227e-05 , 0.000348153935955 , 0.00140117907567  ,
 0.00441166852714  , 0.0108779716466   , 0.0210305414658   , 0.0319231981916   ,
 0.0381061220402   , 0.0358366428681   , 0.0266223896344   , 0.0156998177857   ,
 0.00743709637408  , 0.00291753595548  , 0.00101606309003  , 0.000349248017612 ,
 0.000124976767981 , 4.33657290582e-05 , 1.31003796679e-05 , 3.22861902639e-06 ,
 6.35000023311e-07 , 1.02043936629e-07 , 1.5603087799e-08  , 3.2683668061e-09  ,
 9.87341246347e-10 , 2.97618260809e-10 , 7.46643028905e-11 , 2.21589883071e-11 ,
 6.36255385419e-11 , 3.94157791101e-10 , 2.00522783539e-09 , 8.04763260164e-09 ,
 2.53965460067e-08 , 6.29998011335e-08 , 1.23014333679e-07 , 1.90222260079e-07 ,
 2.4368295986e-07  , 3.64249491071e-07 , 1.39791955723e-06 , 8.84277016819e-06 ,
 5.09381821596e-05 , 0.000239751035766 , 0.000904531859525 , 0.00271266026603  ,
 0.00643508892021  , 0.0120537847632   , 0.0178740713936   , 0.0212472671069   ,
 0.0211389361853   , 0.0200842481693   , 0.0234252714781   , 0.0369450468006   ,
 0.0654161982664   , 0.113260195639    , 0.185314136538    , 0.281843364298    ,
 0.387285652694    , 0.468679171822    , 0.497679039372    , 0.475878649375    ,
 0.429823407649    , 0.383419306164    , 0.345132417243    , 0.316014978217    ,
 0.294561205241    , 0.273304887096    , 0.241513869739    , 0.194894587083    ,
 0.13988789476     , 0.0881863641934   , 0.0485819516723   , 0.0233381155528   ,
 0.00976028600112  , 0.00355064565745  , 0.00112666520363  , 0.000314692403272 ,
 7.84247663763e-05 , 1.758336305e-05   , 3.52118162857e-06 , 6.17846890957e-07 ,
 9.51988649566e-08 , 1.49303386083e-08 , 3.67724466297e-09 , 1.44104678211e-09 ,
 5.62506642469e-10 , 1.82380716894e-10 , 6.19737695207e-11 , 7.89895483895e-11 ,
 2.27905872731e-10 , 5.75437312619e-10 , 1.15100280652e-09 , 1.81709078559e-09 ,
 2.26624076884e-09 , 2.23474818227e-09 , 1.74312677285e-09 , 1.07544057511e-09 ,
 5.24538006776e-10 , 2.02068981342e-10 , 6.14073337693e-11 , 1.47001886186e-11 ,
 2.76796498295e-12 , 4.09352152193e-13 , 4.74829239777e-14 , 4.31466134471e-15 ,
 3.06802038612e-16 , 1.70559061715e-17 , 7.40738601557e-19 , 2.51282025861e-20 ,
 8.41930082231e-22 , 2.09259115952e-21 , 1.93202418206e-20 , 1.44425689784e-19 ,
 9.24692128128e-19 , 6.24570234758e-18 , 5.82646796705e-17 , 6.60533231714e-16 ,
 6.84528907748e-15 , 5.77662229982e-14 , 3.88436368617e-13 , 2.10847397597e-12 ,
 9.66747378352e-12 , 4.11780912305e-11 , 1.85043129125e-10 , 9.28540621932e-10 ,
 4.46699658661e-08 , 2.02442080926e-07 , 8.4044532509e-07  , 3.02383380119e-06 ,
 9.12166706832e-06 , 2.29012446226e-05 , 4.93296373156e-05 , 9.99615526459e-05 ,
 0.000219016331985 , 0.000544043010013 , 0.00137856874184  , 0.00317746508934  ,
 0.00633436028272  , 0.0109190441923   , 0.0168597936571   , 0.0246287946745   ,
 0.0353089201311   , 0.049330701511    , 0.0657116211377   , 0.0835443043797   ,
 0.103187355325    , 0.124065891087    , 0.142258405222    , 0.152924343031    ,
 0.154842624811    , 0.150221037911    , 0.140550593479    , 0.125701872665    ,
 0.108058740751    , 0.0952282077893   , 0.0958133781866   , 0.111048692305    ,
 0.130790426994    , 0.139851967323    , 0.130829370589    , 0.110218252845    ,
 0.0899302430108   , 0.074610220528    , 0.0603785724015   , 0.043675240926    ,
 0.0264910175793   , 0.013070890536    , 0.00519228208356  , 0.00166034019754  ,
 0.000430077578902 , 9.13036267475e-05 , 1.61440813992e-05 , 2.41846597538e-06 ,
 3.10543560297e-07 , 3.41863812624e-08 , 3.18996094791e-09 , 2.65770004173e-10 ,
 4.28450311757e-10 , 7.34654595493e-09 , 1.01939091897e-07 , 1.10332317675e-06 ,
 9.31730121691e-06 , 6.14203293382e-05 , 0.000316247490672 , 0.00127277169153  ,
 0.00400740497327  , 0.00988142506879  , 0.0191055132125   , 0.0290090144536   ,
 0.034657891706    , 0.0326850842167   , 0.0244954905249   , 0.0148377101695   ,
 0.00758566362289  , 0.00358292028429  , 0.00174066757035  , 0.000876341283844 ,
 0.000411573823971 , 0.000163241825978 , 5.20054233242e-05 , 1.304896111e-05   ,
 2.56083485594e-06 , 3.92277407177e-07 , 4.69939525055e-08 , 4.47101659548e-09 ,
 3.66428426396e-10 , 3.55859101234e-11 , 1.49565756571e-11 , 8.64100402869e-11 ,
 6.4529829088e-10  , 4.02668800181e-09 , 2.02270677246e-08 , 8.06815593657e-08 ,
 2.5402863892e-07  , 6.30132226231e-07 , 1.23211955186e-06 , 1.90558702114e-06 ,
 2.37142881271e-06 , 2.68799287384e-06 , 4.99143169562e-06 , 2.14987542125e-05 ,
 0.000107614242812 , 0.000464214833149 , 0.00164439710754  , 0.00471791151622  ,
 0.0108749159513   , 0.0200678567103   , 0.0297655794264   , 0.036215240654    ,
 0.0384351947003   , 0.0411831999257   , 0.0537408452405   , 0.0859494769851   ,
 0.145154321567    , 0.236723291562    , 0.365968432364    , 0.531396324649    ,
 0.706923637655    , 0.838580103632    , 0.879064698193    , 0.828912176278    ,
 0.731033220479    , 0.6281062032      , 0.5391144801      , 0.4681381595      ,
 0.413170958779    , 0.364635431601    , 0.309815662216    , 0.244200829385    ,
 0.174977478057    , 0.11337317511     , 0.0663685037384   , 0.0349128827222   ,
 0.0163293037522   , 0.00673225888455  , 0.00244831944102  , 0.000792817786823 ,
 0.000230266705316 , 5.95499117117e-05 , 1.34274631858e-05 , 2.60476290451e-06 ,
 4.64079053278e-07 , 1.05510291959e-07 , 4.16365140945e-08 , 1.95453548541e-08 ,
 7.89740161616e-09 , 2.5764326909e-09  , 8.84058805763e-10 , 1.15042925201e-09 ,
 3.33095198232e-09 , 8.41186325768e-09 , 1.68257729484e-08 , 2.65629414088e-08 ,
 3.31288506477e-08 , 3.26685397747e-08 , 2.54818480835e-08 , 1.57213258977e-08 ,
 7.66797131592e-09 , 2.95395502141e-09 , 8.97687357222e-10 , 2.14896029103e-10 ,
 4.04638593003e-11 , 5.98431087144e-12 , 6.94365816215e-13 , 6.33574150059e-14 ,
 4.75929511095e-15 , 4.59517008832e-16 , 1.38234107066e-16 , 6.14551650601e-17 ,
 2.31759081243e-17 , 7.03735162093e-18 , 2.58842734578e-18 , 7.31196465866e-18 ,
 4.21449375612e-17 , 2.27028513701e-16 , 1.42389171554e-15 , 1.23757112419e-14 ,
 1.17663726375e-13 , 9.7025523709e-13  , 6.45161805922e-12 , 3.44167531048e-11 ,
 1.51565559851e-10 , 5.91442183062e-10 , 2.29747341919e-09 , 9.7615599542e-09  ,
 3.53658743067e-07 , 1.41884747657e-06 , 5.42219371818e-06 , 1.8542057326e-05  ,
 5.44064648206e-05 , 0.000134411878881 , 0.000282721196948 , 0.000534288587635 ,
 0.00100099786324  , 0.00201633877148  , 0.0042644722843   , 0.00866709958527  ,
 0.0158836795243   , 0.0258257223938   , 0.0381300422552   , 0.0536463178043   ,
 0.0749016332733   , 0.104013593467    , 0.140539626943    , 0.182146279206    ,
 0.225342122541    , 0.263112944708    , 0.284704891146    , 0.283079419217    ,
 0.262187895752    , 0.232796095186    , 0.202044901279    , 0.171112851492    ,
 0.141887720154    , 0.120708939493    , 0.113372234473    , 0.117962885431    ,
 0.124248632754    , 0.121207879291    , 0.106209793291    , 0.0865121967786   ,
 0.0707550746978   , 0.0601915755906   , 0.0499189411608   , 0.0367288037378   ,
 0.0226314250446   , 0.0114313159186   , 0.00472773629753  , 0.00161542415611  ,
 0.000461994153203 , 0.000111807566689 , 2.2973609354e-05  , 3.98218857882e-06 ,
 5.74700228613e-07 , 6.80515486118e-08 , 6.53111564538e-09 , 5.16347553635e-10 ,
 3.25027161506e-10 , 5.23470287685e-09 , 7.26225319254e-08 , 7.8601928951e-07  ,
 6.63774787598e-06 , 4.3756566925e-05  , 0.000225299236205 , 0.000906750985815 ,
 0.00285506850278  , 0.00704083027517  , 0.0136184626864   , 0.0207031112374   ,
 0.0248322204518   , 0.0237119076793   , 0.0184569756705   , 0.0124247927705   ,
 0.0080731940443   , 0.00555153854859  , 0.00386921715922  , 0.00242194159886  ,
 0.00125151097635  , 0.00051451091271  , 0.000166012901053 , 4.18415548557e-05 ,
 8.22374963993e-06 , 1.25977348227e-06 , 1.50414459817e-07 , 1.40152771363e-08 ,
 1.03225475515e-09 , 8.24499083926e-11 , 1.18791020187e-10 , 8.21409438383e-10 ,
 5.64310083262e-09 , 3.3533320342e-08  , 1.64270709948e-07 , 6.47377977354e-07 ,
 2.0281520667e-06  , 5.02662349024e-06 , 9.84799688071e-06 , 1.52885398967e-05 ,
 1.89895885604e-05 , 1.98784584199e-05 , 2.35517967042e-05 , 5.83460476822e-05 ,
 0.000230993350747 , 0.000874757410343 , 0.00280181186404  , 0.00743232583798  ,
 0.0162089700915   , 0.0290121374734   , 0.0430185212888   , 0.0546323030226   ,
 0.0643286568844   , 0.079988826844    , 0.115266204482    , 0.184225209696    ,
 0.296331209131    , 0.456804576591    , 0.670795576411    , 0.935329738109    ,
 1.21291946984     , 1.42368096332     , 1.49248613589     , 1.41039829981     ,
 1.23483816093     , 1.0340280106      , 0.848226243109    , 0.693116169844    ,
 0.571096780135    , 0.473416327624    , 0.386340788471    , 0.302470634393    ,
 0.223785526895    , 0.155220822732    , 0.0996010824637   , 0.057874793917    ,
 0.0298737836879   , 0.0136158148247   , 0.00552255934388  , 0.0020129289632   ,
 0.000656694239163 , 0.000187775008905 , 4.6024715489e-05  , 9.83918671603e-06 ,
 2.21756967585e-06 , 8.01150286253e-07 , 4.23567531546e-07 , 2.13313683008e-07 ,
 8.72356992399e-08 , 2.8536698686e-08  , 9.90097062436e-09 , 1.32017298334e-08 ,
 3.83780761176e-08 , 9.69391401356e-08 , 1.9390379917e-07  , 3.06117149186e-07 ,
 3.81784133238e-07 , 3.76479411517e-07 , 2.93658402559e-07 , 1.81176006142e-07 ,
 8.83673827503e-08 , 3.40420255457e-08 , 1.03451463586e-08 , 2.47651015137e-09 ,
 4.66317335339e-10 , 6.89703186106e-11 , 8.01104734071e-12 , 7.41204544722e-13 ,
 6.55536048868e-14 , 1.34890305823e-14 , 6.55261640417e-15 , 3.08308210942e-15 ,
 1.16742477079e-15 , 3.57449370442e-16 , 1.34289166412e-16 , 3.21447212622e-16 ,
 1.64068154963e-15 , 7.75119499925e-15 , 3.65303131823e-14 , 2.24684182237e-13 ,
 1.80362020729e-12 , 1.41611557712e-11 , 9.26751006138e-11 , 4.8710588304e-10  ,
 2.07827769597e-09 , 7.54285843566e-09 , 2.55856271772e-08 , 9.09838443609e-08 ,
 2.4450923584e-06  , 8.56093858811e-06 , 2.96712903388e-05 , 9.51723150071e-05 ,
 0.00026924111173  , 0.000653490326666 , 0.00135862054336  , 0.00249594591255  ,
 0.00432056692519  , 0.00754225965631  , 0.0134933387774   , 0.023736076742    ,
 0.0392234768737   , 0.0600317421524   , 0.0867352170872   , 0.122444281402    ,
 0.172178909286    , 0.238470512123    , 0.317788310702    , 0.401640125693    ,
 0.478378805603    , 0.532280023522    , 0.546953459412    , 0.517651575172    ,
 0.458681559252    , 0.392010971499    , 0.329543610215    , 0.271303190898    ,
 0.217409048765    , 0.174036336388    , 0.146812378551    , 0.132988056089    ,
 0.12261136097     , 0.107028296197    , 0.0858938795498   , 0.0659148707936   ,
 0.052871781501    , 0.0457866547606   , 0.0393585858207   , 0.0303752860577   ,
 0.0200442664017   , 0.0112061305659   , 0.00533910434313  , 0.00217690953821  ,
 0.000755289920653 , 0.000219740425858 , 5.26670997696e-05 , 1.02405057339e-05 ,
 1.59773712627e-06 , 1.98682386623e-07 , 1.96194989417e-08 , 1.54291901171e-09 ,
 2.59726694427e-10 , 2.93262579998e-09 , 4.06322430119e-08 , 4.39775727592e-07 ,
 3.71380841865e-06 , 2.44818463588e-05 , 0.000126057174029 , 0.000507362090137 ,
 0.00159778286376  , 0.00394235181292  , 0.00763842901583  , 0.0116763144498   ,
 0.01425145794     , 0.0143455058123   , 0.0128702365361   , 0.0116394077077   ,
 0.0112647121703   , 0.0106879961675   , 0.00881165473711  , 0.00589974203099  ,
 0.00312298441768  , 0.00129466804661  , 0.00041896801839  , 0.000105718478202 ,
 2.07942342809e-05 , 3.18914667211e-06 , 3.81919193583e-07 , 3.60127364988e-08 ,
 2.92530865118e-09 , 5.71085134422e-10 , 1.32482319094e-09 , 7.15111771345e-09 ,
 4.24916549033e-08 , 2.32512504832e-07 , 1.08897616965e-06 , 4.19488283038e-06 ,
 1.30089132647e-05 , 3.21515323989e-05 , 6.31257641623e-05 , 9.86095148653e-05 ,
 0.000123508567703 , 0.000127831679223 , 0.000126616193018 , 0.000192032009713 ,
 0.000540861790332 , 0.00173176236837  , 0.00490990020544  , 0.0117629798892   ,
 0.0237198969944   , 0.0406002253457   , 0.0603930295746   , 0.0819934763377   ,
 0.109766536966    , 0.156054892106    , 0.239148330428    , 0.37701904785     ,
 0.580443672502    , 0.853786734165    , 1.20252954272     , 1.62318299144     ,
 2.06491490188     , 2.41342706753     , 2.55016899077     , 2.43991318671     ,
 2.14773529318     , 1.77711612169     , 1.40956789005     , 1.09015918185     ,
 0.835387360901    , 0.640968400958    , 0.492397543408    , 0.376405596614    ,
 0.283989643886    , 0.207767037138    , 0.142808257749    , 0.0892393025102   ,
 0.0498283532137   , 0.0249220409939   , 0.0112793203397   , 0.0046119405917   ,
 0.00166823130452  , 0.000519133798318 , 0.000137868143127 , 3.40353180892e-05 ,
 1.09814878576e-05 , 5.8737692149e-06  , 3.56327532739e-06 , 1.84259807022e-06 ,
 7.56958904472e-07 , 2.48030214935e-07 , 8.71712366871e-08 , 1.19499193756e-07 ,
 3.48933902526e-07 , 8.81576989524e-07 , 1.76340530202e-06 , 2.78390045601e-06 ,
 3.47203366275e-06 , 3.42379129365e-06 , 2.6705977838e-06  , 1.64765672051e-06 ,
 8.03633523405e-07 , 3.09586097935e-07 , 9.40811798568e-08 , 2.25220030889e-08 ,
 4.24090865241e-09 , 6.27449848318e-10 , 7.31926137187e-11 , 7.15528044886e-12 ,
 9.97477234337e-13 , 4.29794341088e-13 , 2.45552387782e-13 , 1.17220499593e-13 ,
 4.46413336912e-14 , 1.39425955166e-14 , 5.31974870005e-15 , 1.07453926112e-14 ,
 4.99984134151e-14 , 2.20979007891e-13 , 8.86545768564e-13 , 3.91510852808e-12 ,
 2.37060018962e-11 , 1.67113451809e-10 , 1.06032188037e-09 , 5.49376764716e-09 ,
 2.29582538079e-08 , 7.9492486281e-08  , 2.44294126126e-07 , 7.43774019316e-07 ,
 1.49063897075e-05 , 4.51716449997e-05 , 0.000140366900618 , 0.000417406231088 ,
 0.00112718764054  , 0.00267305704304  , 0.00550580427592  , 0.0100114700876   ,
 0.0167558870486   , 0.0270970277231   , 0.0433235216283   , 0.0676480477114   ,
 0.101192759131    , 0.145199607691    , 0.204322902033    , 0.287607997426    ,
 0.402911659705    , 0.547958678341    , 0.707097451674    , 0.856530125394    ,
 0.970558088528    , 1.02488940349     , 1.00419200574     , 0.915350078118    ,
 0.789485399527    , 0.661368586434    , 0.546322591365    , 0.441329315583    ,
 0.3436808257      , 0.259949170587    , 0.197759770044    , 0.155876092274    ,
 0.125080055604    , 0.0969235752162   , 0.0701687042081   , 0.0491430564987   ,
 0.0371086856987   , 0.0322317203319   , 0.0296350447928   , 0.0257455883732   ,
 0.019972919331    , 0.0135177138446   , 0.00782604894504  , 0.00378912408882  ,
 0.00150201364867  , 0.000479705709028 , 0.000122163793218 , 2.46616921788e-05 ,
 3.93522505599e-06 , 4.95838308821e-07 , 4.93341896626e-08 , 3.88130081731e-09 ,
 3.13410803384e-10 , 1.30028706297e-09 , 1.78805276406e-08 , 1.93522997687e-07 ,
 1.63427052884e-06 , 1.07735417545e-05 , 5.54770297962e-05 , 0.000223338573953 ,
 0.000703858792262 , 0.00174085281775  , 0.00339898095209  , 0.00532325503936  ,
 0.00698384453771  , 0.00846032203784  , 0.0107273675255   , 0.0144543654334   ,
 0.0183906131859   , 0.0197975582637   , 0.0171104820188   , 0.0116443010572   ,
 0.0061982244397   , 0.00257474142875  , 0.000834058618162 , 0.00021069789517  ,
 4.15405237173e-05 , 6.40861807837e-06 , 7.81072975918e-07 , 7.9850299215e-08  ,
 1.10993913242e-08 , 6.98113475304e-09 , 1.48867380094e-08 , 5.89534596309e-08 ,
 2.86811399975e-07 , 1.38570273551e-06 , 6.02676508692e-06 , 2.22962551044e-05 ,
 6.78084948716e-05 , 0.000166455766248 , 0.000327346481859 , 0.000515676439524 ,
 0.000655600333958 , 0.000689428955569 , 0.000656786683882 , 0.000759643929503 ,
 0.00147594828835  , 0.00379711554247  , 0.00941874067992  , 0.0204153390396   ,
 0.038235743519    , 0.0630405047383   , 0.0951244135822   , 0.138565131477    ,
 0.204663366853    , 0.31285328026     , 0.48810682279     , 0.753374377624    ,
 1.1206976931      , 1.59384064027     , 2.17980735583     , 2.87313917163     ,
 3.60021820648     , 4.19287770007     , 4.46252625189     , 4.32290939186     ,
 3.83844271336     , 3.16490280616     , 2.45911198205     , 1.82751569221     ,
 1.31841047811     , 0.936312603564    , 0.663410409157    , 0.475797140984    ,
 0.348314030029    , 0.256241871921    , 0.182042507797    , 0.120316387788    ,
 0.0729182287152   , 0.0406166820195   , 0.0207201869688   , 0.0094624176401   ,
 0.00374430307851  , 0.00125634886349  , 0.000367125871624 , 0.00011376125524  ,
 5.49617576687e-05 , 3.73328063638e-05 , 2.40016832172e-05 , 1.25420772951e-05 ,
 5.1623785041e-06  , 1.69399296213e-06 , 6.04310818151e-07 , 8.54308659698e-07 ,
 2.50642005739e-06 , 6.33400103728e-06 , 1.26699532887e-05 , 2.00021555409e-05 ,
 2.4946351374e-05  , 2.45997329009e-05 , 1.91880831909e-05 , 1.18383136624e-05 ,
 5.7740581706e-06  , 2.22435744793e-06 , 6.75967983632e-07 , 1.61820533237e-07 ,
 3.04739461479e-08 , 4.51464571336e-09 , 5.35912475888e-10 , 6.36959202973e-11 ,
 1.90547217097e-11 , 1.21825580859e-11 , 7.26984039888e-12 , 3.48351296002e-12 ,
 1.33126261858e-12 , 4.22016079625e-13 , 1.64422115657e-13 , 2.90819332266e-13 ,
 1.22149157348e-12 , 5.11319150117e-12 , 1.88681407864e-11 , 6.64812552345e-11 ,
 2.86862925613e-10 , 1.64894231003e-09 , 9.78170012932e-09 , 4.95864689688e-08 ,
 2.03935617713e-07 , 6.85330153743e-07 , 1.97073569044e-06 , 5.31046937582e-06 ,
 8.0748998056e-05  , 0.000212106056234 , 0.000586501946296 , 0.00160221316001  ,
 0.00409015638263  , 0.00940058462415  , 0.0191121942086   , 0.0345562020077   ,
 0.0570441598302   , 0.0889238413865   , 0.133624600571    , 0.193660939213    ,
 0.269986583468    , 0.366841176054    , 0.498039202781    , 0.683124242093    ,
 0.93009027156     , 1.21961743032     , 1.50750485052     , 1.74170214362     ,
 1.87796447377     , 1.88925471288     , 1.77477695049     , 1.56637486798     ,
 1.31884408765     , 1.08140946207     , 0.873621138373    , 0.690014488357    ,
 0.523926428676    , 0.380293364232    , 0.267959282597    , 0.187831745067    ,
 0.131654771847    , 0.0897873891788   , 0.0578046052815   , 0.036055607324    ,
 0.0250274835172   , 0.0224653469751   , 0.0241304629117   , 0.025775301347    ,
 0.0244840497741   , 0.0195935817531   , 0.0128156299543   , 0.00672722627176  ,
 0.00280415135133  , 0.000922937090076 , 0.000239219383912 , 4.87871397657e-05 ,
 7.83049746878e-06 , 9.89915269605e-07 , 9.86749834732e-08 , 7.76566031105e-09 ,
 5.07897002146e-10 , 4.7033546853e-10  , 6.19848279845e-09 , 6.70793585629e-08 ,
 5.6649279599e-07  , 3.73485441675e-06 , 1.92384512242e-05 , 7.75306507558e-05 ,
 0.000245159220531 , 0.0006128748029   , 0.00123734106969  , 0.00213575141639  ,
 0.00353932261831  , 0.00630408416149  , 0.0116681786754   , 0.0196615686301   ,
 0.0274648275559   , 0.0305606655878   , 0.0267085813586   , 0.0182458463438   ,
 0.00972763863649  , 0.00404598832028  , 0.00131351836197  , 0.000333480812381 ,
 6.65568340503e-05 , 1.05968528865e-05 , 1.4223710423e-06  , 2.17641608304e-07 ,
 8.81707414444e-08 , 8.99159129694e-08 , 1.6034905475e-07  , 4.69153493569e-07 ,
 1.7967391385e-06  , 7.36218388887e-06 , 2.87316644222e-05 , 9.95861680129e-05 ,
 0.000292628821116 , 0.000708325289711 , 0.00139243927301  , 0.00221613165104  ,
 0.00287588784698  , 0.00311776813955  , 0.00303527663608  , 0.00321978065062  ,
 0.00482198492694  , 0.00972202755422  , 0.0206179142409   , 0.0404922767437   ,
 0.0716517599864   , 0.116035254069    , 0.178263113893    , 0.269955736163    ,
 0.41236498631     , 0.636628994766    , 0.980242000074    , 1.47548806087     ,
 2.13694270139     , 2.96812587933     , 3.97748227982     , 5.15016348418     ,
 6.36700482706     , 7.36883947294     , 7.85577636882     , 7.65993409871     ,
 6.8406042854      , 5.6348441794      , 4.32649044356     , 3.13381453667     ,
 2.16704903615     , 1.4466343971      , 0.94474106185     , 0.616869413137    ,
 0.414131796995    , 0.289033891445    , 0.205091881846    , 0.142991387574    ,
 0.0957440656992   , 0.0603352377718   , 0.0346267349067   , 0.0173888466706   ,
 0.0074113601127   , 0.0026747061      , 0.000891710544208 , 0.000376561084308 ,
 0.000253559038896 , 0.000194366914681 , 0.000128103569592 , 6.72480628438e-05 ,
 2.77087136426e-05 , 9.10701778827e-06 , 3.30454169247e-06 , 4.82858653292e-06 ,
 1.42356353524e-05 , 3.59840017958e-05 , 7.19799075977e-05 , 0.000113635306616 ,
 0.000141724042709 , 0.000139754850188 , 0.000109010439375 , 6.72552730903e-05 ,
 3.28033092538e-05 , 1.2636917681e-05  , 3.84028715856e-06 , 9.19357571133e-07 ,
 1.73203169502e-07 , 2.57982111376e-08 , 3.27718797843e-09 , 6.46688723704e-10 ,
 3.83727367807e-10 , 2.79869811449e-10 , 1.68811769673e-10 , 8.10255436427e-11 ,
 3.11246078836e-11 , 1.00928195854e-11 , 4.1350932305e-12  , 6.55238887639e-12 ,
 2.41955177092e-11 , 9.49715604767e-11 , 3.3280642906e-10  , 1.03750760118e-09 ,
 3.37075542665e-09 , 1.44157905474e-08 , 7.46492094496e-08 , 3.62291022366e-07 ,
 1.46318870011e-06 , 4.81994304514e-06 , 1.32943418466e-05 , 3.28726593447e-05 ,
 0.000390363010134 , 0.000903225914268 , 0.00222028340883  , 0.00553686222702  ,
 0.0132448202595   , 0.0292131212378   , 0.0581383673419   , 0.104129273737    ,
 0.170347291612    , 0.260393734437    , 0.378345549372    , 0.525838353949    ,
 0.70277051998     , 0.917899690203    , 1.1982036421      , 1.57475582024     ,
 2.04629426449     , 2.55652495633     , 3.01199962359     , 3.32175734614     ,
 3.42622831204     , 3.30983929106     , 3.00427390447     , 2.57963393171     ,
 2.12033019114     , 1.69349913036     , 1.32791696115     , 1.0193322871      ,
 0.755367297871    , 0.533606264339    , 0.359014124743    , 0.232304151591    ,
 0.145569455947    , 0.087463566558    , 0.0494754663534   , 0.0271165753999   ,
 0.0175631097417   , 0.0177434893866   , 0.0236893945043   , 0.0303140863605   ,
 0.0325113523792   , 0.0280486249728   , 0.0191799262293   , 0.0103291557709   ,
 0.00436865101825  , 0.00144969666939  , 0.000377475635902 , 7.71770724995e-05 ,
 1.24035746011e-05 , 1.56902680565e-06 , 1.5643641863e-07  , 1.23098469757e-08 ,
 7.72160087539e-10 , 1.59731223543e-10 , 1.69599238407e-09 , 1.83416508851e-08 ,
 1.54920071355e-07 , 1.02185594384e-06 , 5.27141899276e-06 , 2.13438313782e-05 ,
 6.85046916985e-05 , 0.000179301640568 , 0.000411684556567 , 0.000944191555498 ,
 0.00235430451518  , 0.00590303737844  , 0.0130450740305   , 0.0235386661466   ,
 0.0336565886838   , 0.0377424339122   , 0.0330791167495   , 0.0226352932218   ,
 0.0120946795334   , 0.00505404379554  , 0.00165871249136  , 0.000432106408922 ,
 9.16484620749e-05 , 1.68567782903e-05 , 3.27034703822e-06 , 1.14116309444e-06 ,
 8.77446096036e-07 , 9.85721853687e-07 , 1.5595331921e-06  , 3.56412046516e-06 ,
 1.06220989523e-05 , 3.58932393931e-05 , 0.00012202458618  , 0.000385672410205 ,
 0.00107354871616  , 0.00253344880259  , 0.00495608902903  , 0.00797302831735  ,
 0.0106066750687   , 0.0119571354266   , 0.0121879707016   , 0.0129639076856   ,
 0.0171992455395   , 0.0286940546749   , 0.0519152842258   , 0.0916694549086   ,
 0.153034932756    , 0.242858034226    , 0.373190631609    , 0.565110340327    ,
 0.852127508286    , 1.28307092204     , 1.91736541921     , 2.80407375609     ,
 3.96190585344     , 5.39236341304     , 7.10150275419     , 9.05044372054     ,
 11.0378221304     , 12.6577235242     , 13.4437922443     , 13.1150246373     ,
 11.7315320655     , 9.65513880141     , 7.36366979693     , 5.25323760914     ,
 3.53855135201     , 2.26763997335     , 1.39245478148     , 0.831077549211    ,
 0.49765962122     , 0.313238918264    , 0.214092961067    , 0.157083240577    ,
 0.117359059933    , 0.0832399832941   , 0.0526200625614   , 0.0284060383775   ,
 0.0128647013659   , 0.00502716473634  , 0.00201765885298  , 0.00119273350626  ,
 0.000997767853496 , 0.000810588522641 , 0.000540383354861 , 0.000284354031053 ,
 0.000117274415291 , 3.86267275286e-05 , 1.4284362215e-05  , 2.15917043358e-05 ,
 6.39574852758e-05 , 0.000161705547161 , 0.00032346782706  , 0.000510661674809 ,
 0.000636888657898 , 0.000628039373469 , 0.00048987815438  , 0.000302236092116 ,
 0.00014741363865  , 5.67886399599e-05 , 1.72579039732e-05 , 4.13202072169e-06 ,
 7.79734380665e-07 , 1.18657494502e-07 , 1.89535745021e-08 , 8.07870778015e-09 ,
 6.72442619516e-09 , 5.079505827e-09   , 3.07193521162e-09 , 1.47711086707e-09 ,
 5.72113392705e-10 , 1.92051009523e-10 , 8.52893069926e-11 , 1.24280500585e-10 ,
 3.93966250132e-10 , 1.41879325901e-09 , 4.7420094715e-09  , 1.3866119315e-08  ,
 3.78015008872e-08 , 1.19240824857e-07 , 4.93459675031e-07 , 2.19245645287e-06 ,
 8.58605555844e-06 , 2.78000935672e-05 , 7.47868088563e-05 , 0.000175287421423 ,
 0.00168632841216  , 0.00354228727775  , 0.00781904585758  , 0.0177625926701   ,
 0.0395257993455   , 0.0827737619417   , 0.159364978927    , 0.280010060976    ,
 0.451981443966    , 0.679979822075    , 0.96646350751     , 1.30911642637     ,
 1.70413215282     , 2.16229098651     , 2.71883651613     , 3.40509024572     ,
 4.19120387695     , 4.96202811663     , 5.56199266113     , 5.86577639607     ,
 5.81815693448     , 5.43880423201     , 4.80836293621     , 4.04066753242     ,
 3.25027959268     , 2.52638287572     , 1.91583372034     , 1.42238939459     ,
 1.02685938106     , 0.711598092262    , 0.468414692473    , 0.291466967937    ,
 0.170770505064    , 0.0932971497835   , 0.0470059193439   , 0.0227378039935   ,
 0.0140177922561   , 0.016261230965    , 0.0251981218449   , 0.035031436908    ,
 0.0392312669244   , 0.034633951623    , 0.0239773942416   , 0.0129982896761   ,
 0.00551651676455  , 0.00183368880592  , 0.000477781059029 , 9.76915104033e-05 ,
 1.56955749281e-05 , 1.98431116608e-06 , 1.97690516283e-07 , 1.55419344468e-08 ,
 9.66922389416e-10 , 7.39125365261e-11 , 3.67903792745e-10 , 3.9620771305e-09  ,
 3.34865285157e-08 , 2.2134399766e-07  , 1.14945657622e-06 , 4.75197092603e-06 ,
 1.62379494526e-05 , 5.02140064184e-05 , 0.000160789853249 , 0.000556832360406 ,
 0.00186690307188  , 0.00536962222319  , 0.0124734790449   , 0.022884152221    ,
 0.0329065416436   , 0.0369958340809   , 0.0325060224609   , 0.0223466296267   ,
 0.0120642938721   , 0.00516182814223  , 0.00178701549231  , 0.000522179614329 ,
 0.000138367575701 , 3.71299431574e-05 , 1.28346199539e-05 , 7.96110202009e-06 ,
 7.57744782712e-06 , 8.8061296037e-06  , 1.30675186255e-05 , 2.50416429154e-05 ,
 5.91742806151e-05 , 0.000162704541443 , 0.000473164694947 , 0.00133570014736  ,
 0.00345274454665  , 0.00783070575281  , 0.0151281617277   , 0.0245449995134   ,
 0.0335176044647   , 0.0394162717435   , 0.0423324519182   , 0.0464703769202   ,
 0.0590088796746   , 0.0878326793253   , 0.140282756727    , 0.224026818308    ,
 0.349845187657    , 0.534660521834    , 0.802580757369    , 1.18542993978     ,
 1.72900641686     , 2.50399289559     , 3.60094279793     , 5.09358589754     ,
 7.00530782951     , 9.32984402525     , 12.0609562706     , 15.1142927485     ,
 18.1618413        , 20.5879836769     , 21.7049836402     , 21.0991087822     ,
 18.853012844      , 15.5047038599     , 11.7921847586     , 8.35428529086     ,
 5.55550534736     , 3.48646323365     , 2.06902977007     , 1.16465629134     ,
 0.633809948964    , 0.354028652361    , 0.224335804837    , 0.168634054461    ,
 0.137263019447    , 0.106057108972    , 0.0715462626828   , 0.0406182096363   ,
 0.019379211202    , 0.00835299814584  , 0.0042689960675   , 0.00339137766051  ,
 0.0032149619862   , 0.00268761915481  , 0.00180242152488  , 0.000950202036991 ,
 0.000392486684118 , 0.000129710850222 , 4.89660916243e-05 , 7.64224825606e-05 ,
 0.000227289097518 , 0.000574763840506 , 0.00114973628453  , 0.00181509957621  ,
 0.00226376166179  , 0.0022323076982   , 0.00174122646464  , 0.00107427017934  ,
 0.000523968233338 , 0.000201850575535 , 6.13441059063e-05 , 1.46947798132e-05 ,
 2.79123879343e-06 , 4.60620959213e-07 , 1.27627828086e-07 , 1.024137326e-07   ,
 9.50932741315e-08 , 7.24439702522e-08 , 4.38488914506e-08 , 2.11449771964e-08 ,
 8.29895557329e-09 , 2.93219811039e-09 , 1.44977110748e-09 , 1.99059775362e-09 ,
 5.35196005921e-09 , 1.72168468286e-08 , 5.42673238209e-08 , 1.52157755137e-07 ,
 3.78760625401e-07 , 9.55276058601e-07 , 3.00702467549e-06 , 1.14433492279e-05 ,
 4.22281056541e-05 , 0.000133535153159 , 0.000353336138929 , 0.000804617492911 ,
 0.00652090781818  , 0.0128761306209   , 0.0260664822339   , 0.0541996426474   ,
 0.111725157733    , 0.220075523323    , 0.404743092377    , 0.688622097426    ,
 1.08607645606     , 1.60174469597     , 2.23138521911     , 2.96214340178     ,
 3.77896600633     , 4.68109402791     , 5.68698233921     , 6.79529803631     ,
 7.91995159988     , 8.87774732439     , 9.46586650654     , 9.55962919549     ,
 9.15013020732     , 8.3228101979      , 7.21430037043     , 5.97089110837     ,
 4.72531513313     , 3.5886866917      , 2.63580399588     , 1.88845442711     ,
 1.32323515144     , 0.900954834968    , 0.588789546689    , 0.363908624565    ,
 0.209149650676    , 0.109694307609    , 0.0517712019517   , 0.0228689453207   ,
 0.0130231651059   , 0.0154980691228   , 0.0251542662045   , 0.0357903852222   ,
 0.0405033968771   , 0.0359245588508   , 0.0249165176455   , 0.0135119415131   ,
 0.00573155090068  , 0.0019031422739   , 0.000495149105996 , 0.000101058418488 ,
 1.62015517577e-05 , 2.04320446912e-06 , 2.02993168053e-07 , 1.59137459845e-08 ,
 9.89880552932e-10 , 5.69721896779e-11 , 6.78129939963e-11 , 6.80877142319e-10 ,
 5.74775609422e-09 , 3.83270150536e-08 , 2.04882462511e-07 , 9.22041492873e-07 ,
 3.8917002032e-06  , 1.74789834971e-05 , 8.31502683505e-05 , 0.000368533344766 ,
 0.00137144482944  , 0.00409063008682  , 0.00961794328229  , 0.0177268406692   ,
 0.0255723353273   , 0.0288919755825   , 0.0256488967815   , 0.0180404540432   ,
 0.0102414277802   , 0.00486770823377  , 0.00205206553361  , 0.000813160244494 ,
 0.000311384282428 , 0.000121551951242 , 6.1848975331e-05  , 5.05500856987e-05 ,
 5.31477979939e-05 , 6.36274307388e-05 , 9.1735731512e-05  , 0.000156848464728 ,
 0.0003066320689   , 0.000687659299755 , 0.00169452397108  , 0.00422694800092  ,
 0.0100079819655   , 0.021514342405    , 0.0406288230881   , 0.0660835191454   ,
 0.0923290878368   , 0.112948547589    , 0.127348930385    , 0.144772033694    ,
 0.181313716563    , 0.252675746807    , 0.370183051515    , 0.544968040236    ,
 0.797320219961    , 1.16149895111     , 1.67933856523     , 2.39228517929     ,
 3.35209341639     , 4.64710555691     , 6.40127712226     , 8.71797319117     ,
 11.6255036114     , 15.1016166456     , 19.1115060748     , 23.4997458218     ,
 27.7745019599     , 31.0698866441     , 32.4533977598     , 31.3856009091     ,
 27.9999891639     , 23.0437504834     , 17.5493340553     , 12.4366610538     ,
 8.25457990867     , 5.15368997718     , 3.02419976102     , 1.66015919213     ,
 0.856503319276    , 0.435914791159    , 0.249679039261    , 0.181043354023    ,
 0.151391460857    , 0.12177259491     , 0.0850775173536   , 0.0499440605241   ,
 0.0250591556896   , 0.0123075590274   , 0.00829543416672  , 0.00820964311673  ,
 0.00833633086902  , 0.00707514573801  , 0.00476442437349  , 0.00251836355123  ,
 0.00104383126979  , 0.000347183484286 , 0.00013392193493  , 0.000214226687103 ,
 0.000638613087846 , 0.00161498132789  , 0.0032305364631   , 0.00510007523839  ,
 0.00636072758411  , 0.00627234806841  , 0.00489250592763  , 0.00301848948335  ,
 0.00147224986613  , 0.000567167837149 , 0.000172393094767 , 4.13783155465e-05 ,
 8.06459672807e-06 , 1.73024031874e-06 , 1.03398409815e-06 , 1.11304661208e-06 ,
 1.06377458841e-06 , 8.11834470797e-07 , 4.91765814853e-07 , 2.38294207379e-07 ,
 9.55043802266e-08 , 3.62980612996e-08 , 2.03651447793e-08 , 2.68135528384e-08 ,
 6.13656613532e-08 , 1.72216270729e-07 , 5.01551226287e-07 , 1.3499504921e-06  ,
 3.2058070283e-06  , 7.12382356828e-06 , 1.76744347899e-05 , 5.452691474e-05   ,
 0.000181298271754 , 0.000549704282237 , 0.00142913088394  , 0.00320800723471  ,
 0.0227233395834   , 0.0433201568392   , 0.0823553852567   , 0.158452427214    ,
 0.302746569469    , 0.557877810155    , 0.970536972272    , 1.57961858642     ,
 2.40674544353     , 3.45314184833     , 4.70047728477     , 6.11387928094     ,
 7.64860089419     , 9.25839490276     , 10.8924150732     , 12.4632639205     ,
 13.8050463098     , 14.6894272641     , 14.9255764883     , 14.460639705      ,
 13.3906122762     , 11.8935892577     , 10.1526744722     , 8.31696181765     ,
 6.51230640009     , 4.86397336463     , 3.48051832203     , 2.41175895016     ,
 1.63656628693     , 1.09245450356     , 0.712328566199    , 0.444842678754    ,
 0.258642123478    , 0.13601555075     , 0.0634186410229   , 0.0269340573345   ,
 0.0137983599852   , 0.0147987131398   , 0.0234452095658   , 0.0332236942786   ,
 0.0374989930151   , 0.0331592379244   , 0.0229218448694   , 0.0123856762277   ,
 0.0052334337543   , 0.00173032351376  , 0.000448029688299 , 9.09440151406e-05 ,
 1.44895541422e-05 , 1.81444914992e-06 , 1.78901684495e-07 , 1.39943211757e-08 ,
 9.65280441636e-10 , 1.43903845029e-10 , 9.2307957907e-11  , 1.75243806152e-10 ,
 9.21786964879e-10 , 5.72886452485e-09 , 3.33086816177e-08 , 1.9284363028e-07  ,
 1.21212592873e-06 , 7.81926723703e-06 , 4.5369218465e-05  , 0.000217426075388 ,
 0.000830958186307 , 0.00250168923618  , 0.005910168456    , 0.0109541913918   ,
 0.0159737159122   , 0.0184701042657   , 0.0172302759292   , 0.0134097232208   ,
 0.00916798259938  , 0.00579142456849  , 0.00342065919074  , 0.0018327674609   ,
 0.000877988525014 , 0.000421012815325 , 0.000275755623895 , 0.000267567026874 ,
 0.000301339779639 , 0.000372760428983 , 0.000533017265602 , 0.000850005578285 ,
 0.00144818766284  , 0.00271023512508  , 0.0056465926095   , 0.0123824374067   ,
 0.0266739748044   , 0.0538058403481   , 0.0982431536231   , 0.158680336088    ,
 0.225029252928    , 0.284129813987    , 0.333418678527    , 0.390555837229    ,
 0.487308808296    , 0.652046944344    , 0.900200695857    , 1.24567831179     ,
 1.72253681758     , 2.3908492794      , 3.3146349165      , 4.53756801716     ,
 6.09903869841     , 8.08528043254     , 10.6421908784     , 13.9019340623     ,
 17.9008637631     , 22.5971949748     , 27.9126414876     , 33.6029729892     ,
 39.0092893161     , 43.0373909481     , 44.5481299512     , 42.9051629136     ,
 38.2912073261     , 31.6345780158     , 24.234607086      , 17.2887964749     ,
 11.549342233      , 7.25031617066     , 4.26647686773     , 2.33272528111     ,
 1.17949982528     , 0.568597967093    , 0.294455793628    , 0.19314365268     ,
 0.154592575532    , 0.1237392814      , 0.0872797204835   , 0.052308974039    ,
 0.0277736677634   , 0.0162232643368   , 0.0143499207494   , 0.0164072973107   ,
 0.0173021136224   , 0.0148251797456   , 0.0100323867226   , 0.00533320680236  ,
 0.00222946805274  , 0.000751739548542 , 0.000296199070191 , 0.000476361850032 ,
 0.00141757348517  , 0.00358388196828  , 0.00716883391426  , 0.0113174680604   ,
 0.0141149505186   , 0.0139188293805   , 0.0108568536282   , 0.00669826872257  ,
 0.00326705457274  , 0.00125865735223  , 0.000382807120199 , 9.26116671507e-05 ,
 1.98597323812e-05 , 7.69337454533e-06 , 8.25690838007e-06 , 9.74794896984e-06 ,
 9.37915816179e-06 , 7.1590645277e-06  , 4.34274934699e-06 , 2.12153135237e-06 ,
 8.78383694478e-07 , 3.68603764857e-07 , 2.36468105159e-07 , 3.01314353856e-07 ,
 5.96654924723e-07 , 1.44329574266e-06 , 3.79250450397e-06 , 9.69354420878e-06 ,
 2.23232987143e-05 , 4.66779437855e-05 , 9.94196255837e-05 , 0.000249486387149 ,
 0.000717060227532 , 0.00202473473777  , 0.00511092861772  , 0.0113367613792   ,
 0.0723433367952   , 0.134669264928    , 0.244308185752    , 0.440008053167    ,
 0.782428031966    , 1.34732263566     , 2.20681528123     , 3.40979094184     ,
 4.97473556597     , 6.89188390644     , 9.12209048659     , 11.5918908241     ,
 14.1897706381     , 16.7634917076     , 19.121649635      , 21.0403985866     ,
 22.278103434      , 22.6260552343     , 22.0030546325     , 20.5193724376     ,
 18.4316580239     , 16.0199744982     , 13.4884690594     , 10.9549208122     ,
 8.51392578742     , 6.29165171652     , 4.4240775457      , 2.98881620713     ,
 1.97125092301     , 1.28851938177     , 0.836454914603    , 0.528462490778    ,
 0.313182862277    , 0.167727028356    , 0.0792494429993   , 0.0336747472516   ,
 0.0162145941196   , 0.0152965047679   , 0.0228461856208   , 0.031746189094    ,
 0.0354470720398   , 0.0310795470031   , 0.0213189083937   , 0.0114327461177   ,
 0.00479310843125  , 0.00157135801702  , 0.000403022502569 , 8.0923476092e-05  ,
 1.27321555701e-05 , 1.57199027905e-06 , 1.53630419048e-07 , 1.35136635192e-08 ,
 2.83136829117e-09 , 1.95528765634e-09 , 1.55111459552e-09 , 1.5639726814e-09  ,
 2.50730939099e-09 , 4.95318392872e-09 , 1.24504908091e-08 , 6.12928453102e-08 ,
 4.69772808676e-07 , 3.48768850711e-06 , 2.14107337626e-05 , 0.000104659597706 ,
 0.000403310437011 , 0.00122270879533  , 0.00292275602827  , 0.00555038086729  ,
 0.00851581568901  , 0.0108971637919   , 0.0121954415864   , 0.0124853132541   ,
 0.011801639425    , 0.00996603873201  , 0.00720034125315  , 0.00436194849     ,
 0.00231132047967  , 0.00130672191438  , 0.00106356389386  , 0.00116756211657  ,
 0.00139186348832  , 0.00178585634994  , 0.00256138833006  , 0.00391677132711  ,
 0.00609399654819  , 0.00991770504795  , 0.0176949406558   , 0.0340580775733   ,
 0.0665083738281   , 0.125039461226    , 0.218507994872    , 0.346487037684    ,
 0.493201301331    , 0.635829045673    , 0.768394377848    , 0.920551778268    ,
 1.14676977141     , 1.492047143       , 1.97370019324     , 2.60533911204     ,
 3.43727902053     , 4.56108043261     , 6.06172970344     , 7.96886654407     ,
 10.2790914374     , 13.0414346827     , 16.3965383221     , 20.4953708723     ,
 25.3892294461     , 31.0283179256     , 37.2967248605     , 43.8764625616     ,
 49.9993096163     , 54.447577869      , 55.9730798838     , 53.8630206808     ,
 48.2771711882     , 40.2094765787     , 31.1307196818     , 22.4732287668     ,
 15.1982984235     , 9.65539154445     , 5.74112123524     , 3.16120641072     ,
 1.59765566347     , 0.753740896956    , 0.362556832739    , 0.208994833074    ,
 0.150110388995    , 0.113876893977    , 0.0787824021805   , 0.047544521032    ,
 0.027036980539    , 0.0194310280568   , 0.0214854989108   , 0.0267577777272   ,
 0.0288400866346   , 0.0249376169441   , 0.0170357612514   , 0.00918090589504  ,
 0.00391794871766  , 0.00136120816009  , 0.000546085116594 , 0.000844379263079 ,
 0.0024842143741   , 0.00627374921764  , 0.012548190514    , 0.0198096897401   ,
 0.0247062675876   , 0.0243629861613   , 0.0190034441453   , 0.0117244608991   ,
 0.00571869877888  , 0.0022036421094   , 0.000671887592517 , 0.000167680842448 ,
 4.8516203682e-05  , 4.03761495199e-05 , 5.60121788403e-05 , 6.77241328208e-05 ,
 6.52251010275e-05 , 4.97865920605e-05 , 3.028468836e-05   , 1.49945150211e-05 ,
 6.52142847819e-06 , 3.10487040132e-06 , 2.26572516514e-06 , 2.80250896663e-06 ,
 4.90794134006e-06 , 1.02746793665e-05 , 2.38977291456e-05 , 5.70128158303e-05 ,
 0.00012748916633  , 0.000259541221509 , 0.000512375782111 , 0.00110842468356  ,
 0.00273694660736  , 0.00700928745178  , 0.016842406661    , 0.0365660109865   ,
 0.214192315793    , 0.388202093463    , 0.675362435619    , 1.14690055853     ,
 1.90639924025     , 3.07091244461     , 4.73094550387     , 6.92075995499     ,
 9.62814163663     , 12.8197726096     , 16.4327370681     , 20.3323851439     ,
 24.2796035115     , 27.9357910343     , 30.911105363      , 32.8415108312     ,
 33.4632361718     , 32.6774734134     , 30.6095831308     , 27.6080903875     ,
 24.123016814      , 20.5267250244     , 17.0190003785     , 13.671830851      ,
 10.5418339231     , 7.73859532819     , 5.39683396361     , 3.59947784075     ,
 2.33280188926     , 1.4995620104      , 0.965723288412    , 0.612406372277    ,
 0.367274535346    , 0.199934133214    , 0.0965539135359   , 0.0423565408145   ,
 0.0207399204359   , 0.0182112052705   , 0.0253242928951   , 0.0340852158775   ,
 0.0374580652257   , 0.032498516499    , 0.0221004271929   , 0.0117562480143   ,
 0.00488810180014  , 0.001588161639    , 0.000403207110772 , 8.00080039136e-05 ,
 1.24170834601e-05 , 1.51745969409e-06 , 1.63059184872e-07 , 3.9000103389e-08  ,
 3.23851177549e-08 , 2.86646032998e-08 , 2.30952395306e-08 , 2.30199179195e-08 ,
 3.53384095637e-08 , 6.12019493534e-08 , 9.36259803287e-08 , 1.30562592484e-07 ,
 2.79462078587e-07 , 1.40089328482e-06 , 8.24364833554e-06 , 4.04361458639e-05 ,
 0.000157806503239 , 0.000491050422563 , 0.00123841657767  , 0.00261146961526  ,
 0.00481489964462  , 0.00807522029977  , 0.0123812658517   , 0.016794379536    ,
 0.0193110743894   , 0.0182699154161   , 0.0140740424594   , 0.0089925234092   ,
 0.0052378778992   , 0.00357948482729  , 0.00352204290983  , 0.00423273351975  ,
 0.00531807910691  , 0.00709676441106  , 0.0102599860923   , 0.0152785501898   ,
 0.0224586839237   , 0.0332865980809   , 0.0525074784783   , 0.0894955418608   ,
 0.15822991665     , 0.275823074263    , 0.457213914691    , 0.70363996425     ,
 0.993143405176    , 1.29175449636     , 1.5895843934      , 1.93060598996     ,
 2.3952941254      , 3.04493919001     , 3.89342054576     , 4.9477023113      ,
 6.26995719279     , 7.97787180878     , 10.1658796118     , 12.8295270465     ,
 15.8943951784     , 19.3375979223     , 23.2590246917     , 27.8055979279     ,
 33.0476458067     , 38.9576741929     , 45.4272929483     , 52.132872765      ,
 58.3155068093     , 62.7926658508     , 64.3248255328     , 62.1150445435     ,
 56.1689111353     , 47.3708218115     , 37.2201745139     , 27.3042497572     ,
 18.7754847877     , 12.1269231427     , 7.3264763748      , 4.09683015097     ,
 2.1014865125      , 0.999620420443    , 0.468809881992    , 0.245202706779    ,
 0.153803706609    , 0.105262251584    , 0.0687123034989   , 0.0409139670781   ,
 0.0250435040549   , 0.0217742557184   , 0.0276531005254   , 0.0359061482568   ,
 0.0392693810561   , 0.0344456663355   , 0.0240316799089   , 0.0133643533314   ,
 0.00596744948091  , 0.00219972756393  , 0.000891142167118 , 0.00120986893825  ,
 0.00343726609227  , 0.00865271460651  , 0.0173011385898   , 0.0273119683452   ,
 0.0340626714279   , 0.0335894259819   , 0.0262004745915   , 0.0161653728109   ,
 0.00788599888675  , 0.00304194162967  , 0.000937315182701 , 0.000262736866544 ,
 0.000143435714389 , 0.000204571578577 , 0.000306568538726 , 0.000372469205194 ,
 0.000358554391833 , 0.000273819677246 , 0.000167423757655 , 8.4719639723e-05  ,
 3.95893973924e-05 , 2.18756068367e-05 , 1.78709131038e-05 , 2.14664078047e-05 ,
 3.39629054184e-05 , 6.26223535052e-05 , 0.00012815911113  , 0.000280480313206 ,
 0.000605007104189 , 0.00121693286077  , 0.0023361291085   , 0.00465881588199  ,
 0.0102141810984   , 0.0235968446544   , 0.0530485513672   , 0.110901994462    ,
 0.598220053354    , 1.04499312016     , 1.73849134945     , 2.79005184053     ,
 4.34698695757     , 6.55744661586     , 9.50322133897     , 13.1622260924     ,
 17.4549008023     , 22.3126132317     , 27.646924045      , 33.2260255179     ,
 38.6003208547     , 43.1695094185     , 46.3459659932     , 47.7072721181     ,
 47.0728270074     , 44.5307720927     , 40.4567813627     , 35.462419676      ,
 30.1978375934     , 25.1193959943     , 20.4212688591     , 16.1458505508     ,
 12.3190142824     , 9.00418309008     , 6.28020444563     , 4.19106430775     ,
 2.7090761256      , 1.73071516673     , 1.10780287282     , 0.701493312031    ,
 0.423455671778    , 0.23500521825     , 0.118532363619    , 0.0565639283724   ,
 0.0302835520562   , 0.0249217363837   , 0.0304561755302   , 0.0383843104998   ,
 0.0410674958103   , 0.0352043324263   , 0.0237822818666   , 0.0125926275921   ,
 0.00521539986759  , 0.00168805307879  , 0.000426833795145 , 8.4325469907e-05  ,
 1.3066100688e-05  , 1.69886565784e-06 , 3.82947408879e-07 , 3.450597162e-07   ,
 3.75213458484e-07 , 3.38436693448e-07 , 2.73839003668e-07 , 2.718602596e-07   ,
 4.1101264229e-07  , 7.02549267622e-07 , 1.05493260306e-06 , 1.30296931753e-06 ,
 1.34588343444e-06 , 1.44917073097e-06 , 3.22293392018e-06 , 1.32234538447e-05 ,
 5.33157459004e-05 , 0.000184786998949 , 0.000563186384118 , 0.00155888271765  ,
 0.00391543817055  , 0.00862033348849  , 0.0159621412556   , 0.0241466894034   ,
 0.0294162337607   , 0.0287961370931   , 0.0229396082414   , 0.015600789489    ,
 0.0104440902071   , 0.00883937135537  , 0.0101096325098   , 0.0130125449277   ,
 0.0172076738124   , 0.0238631275879   , 0.0347646831288   , 0.0507860461154   ,
 0.0720386365175   , 0.100963162982    , 0.146588767802    , 0.226437198619    ,
 0.364685063028    , 0.588065954353    , 0.918417103344    , 1.35855631367     ,
 1.88033140499     , 2.43899176954     , 3.02078337747     , 3.68186787446     ,
 4.52298244159     , 5.61384408754     , 6.95750698517     , 8.5455343018      ,
 10.4359953659     , 12.7488091767     , 15.5656153374     , 18.8380888819     ,
 22.4209972555     , 26.2129228218     , 30.2468766596     , 34.6319359688     ,
 39.447591422      , 44.7237259915     , 50.4346199367     , 56.3570237014     ,
 61.8775571653     , 65.9939463532     , 67.5701968377     , 65.7170597005     ,
 60.1792774541     , 51.575143393      , 41.2730637107     , 30.886037999      ,
 21.6870081976     , 14.3101814947     , 8.83812415947     , 5.06384231181     ,
 2.67497030439     , 1.31683053183     , 0.632665576343    , 0.322685906457    ,
 0.185111809251    , 0.114136293139    , 0.069113510752    , 0.0401937584672   ,
 0.0259045881205   , 0.0244423040599   , 0.0317926799737   , 0.0413638559458   ,
 0.0457814604083   , 0.0412532478133   , 0.0300501201494   , 0.0177645032226   ,
 0.00859125554971  , 0.00346785289569  , 0.00140415773262  , 0.00145604557712  ,
 0.00377032259481  , 0.00939846660807  , 0.0187697494329   , 0.0296230135118   ,
 0.0369426101055   , 0.0364298832251   , 0.0284190119358   , 0.0175398521465   ,
 0.00856631450179  , 0.00332372946973  , 0.00107296075707  , 0.000430505387686 ,
 0.000496560223705 , 0.000877699331349 , 0.00133799592063  , 0.00162480454487  ,
 0.00156298393525  , 0.00119556128993  , 0.000737840700781 , 0.000386544533519 ,
 0.000199546283045 , 0.00012948629362  , 0.000115866287263 , 0.000135274867005 ,
 0.000196874709044 , 0.000327467213902 , 0.000596473751291 , 0.00118745004826  ,
 0.00244881747444  , 0.0048855801944   , 0.0093439859959   , 0.0179995385878   ,
 0.036597329142    , 0.0774968691294   , 0.162163608316    , 0.321972273658    ,
 1.58187607138     , 2.63815092254     , 4.17640692147     , 6.33259841282     ,
 9.26213782979     , 13.0961776615     , 17.8601877401     , 23.4406467351     ,
 29.6766104169     , 36.4665387659     , 43.6839583012     , 50.9367584904     ,
 57.4711495163     , 62.3883374528     , 64.9904119777     , 64.9670221433     ,
 62.3587592046     , 57.4782483986     , 50.9208704565     , 43.5281288758     ,
 36.1415046839     , 29.3130211029     , 23.257634368      , 18.0131572645     ,
 13.5688185822     , 9.89414060355     , 6.94810976664     , 4.69052102583     ,
 3.06604940963     , 1.97386527855     , 1.26920644561     , 0.808965194291    ,
 0.49732897999     , 0.288738848343    , 0.159804248383    , 0.08852622782     ,
 0.0536463012841   , 0.0401531580611   , 0.0389036683028   , 0.0421347134862   ,
 0.0422328978019   , 0.0353310337674   , 0.0236821695851   , 0.0125301074677   ,
 0.00520422987768  , 0.00169335478394  , 0.000431433800301 , 8.62382325158e-05 ,
 1.3986690662e-05  , 2.87463437462e-06 , 2.36680647268e-06 , 3.14547828957e-06 ,
 3.51411928987e-06 , 3.18496336821e-06 , 2.5959305976e-06  , 2.57796213395e-06 ,
 3.83113808809e-06 , 6.44039162335e-06 , 9.58293056878e-06 , 1.17645431705e-05 ,
 1.1773811547e-05  , 9.67494658753e-06 , 7.03337855727e-06 , 7.31814768952e-06 ,
 2.10648516386e-05 , 9.01366078923e-05 , 0.000371008332375 , 0.00133523306275  ,
 0.0040138188134   , 0.00979746472988  , 0.0191420309725   , 0.0297915127659   ,
 0.0370263591946   , 0.0371901367776   , 0.0311775494914   , 0.0236854289999   ,
 0.0193484342009   , 0.0201716001737   , 0.0257551012112   , 0.035055229452    ,
 0.0486129604113   , 0.06956334007     , 0.10161341549     , 0.145951425131    ,
 0.202093182958    , 0.274311231772    , 0.378928082585    , 0.545823128362    ,
 0.812678536725    , 1.2166367719      , 1.78519421426     , 2.52188277102     ,
 3.39350438273     , 4.34607825956     , 5.35908078835     , 6.48874183978     ,
 7.83677791721     , 9.46560115748     , 11.3619193903     , 13.4957914038     ,
 15.8970312402     , 18.6479925568     , 21.7903280437     , 25.2441371209     ,
 28.8393082347     , 32.4378643266     , 36.0102409167     , 39.5979127472     ,
 43.2627574142     , 47.1042339413     , 51.2380423902     , 55.6280032998     ,
 59.8949939148     , 63.2912201602     , 64.8431268474     , 63.6139836559     ,
 59.0979254918     , 51.5861860835     , 42.1738451971     , 32.321350681      ,
 23.2829144437     , 15.7793734046     , 10.0257946623     , 5.93365227808     ,
 3.26386310209     , 1.69050642799     , 0.857018834293    , 0.450900199682    ,
 0.255025878898    , 0.150872401882    , 0.0887254062126   , 0.0520475417364   ,
 0.0342822083948   , 0.0305947695299   , 0.0362302909083   , 0.0451878194085   ,
 0.0504582484021   , 0.0474574802763   , 0.0369838594335   , 0.0238314001429   ,
 0.0127107569044   , 0.00565088093267  , 0.00229783674633  , 0.0016337845657   ,
 0.00336445087905  , 0.00809238537253  , 0.0160565849255   , 0.0252952844733   ,
 0.031529839575    , 0.031097486203    , 0.0242830997724   , 0.0150319242539   ,
 0.00741196380699  , 0.00298770192168  , 0.00117849488733  , 0.000932123499339 ,
 0.00165601725743  , 0.00306382687223  , 0.00466083042755  , 0.00564473094125  ,
 0.00542744842095  , 0.00416757025146  , 0.0026144139252   , 0.00144546051033  ,
 0.000848944517456 , 0.000644793710068 , 0.000618100690102 , 0.000703554409202 ,
 0.000956358271144 , 0.00146971131594  , 0.00244420424349  , 0.00446296482265  ,
 0.00875935207809  , 0.0172912591675   , 0.0332016149688   , 0.0632027475473   ,
 0.122916755327    , 0.243679008278    , 0.47706462811     , 0.894314363354    ,
 3.93254798754     , 6.22998871911     , 9.35693741252     , 13.4048310116     ,
 18.4394381479     , 24.4825076439     , 31.4585919994     , 39.1801393244     ,
 47.4527434436     , 56.1652397758     , 65.1127843658     , 73.6497215686     ,
 80.6411019349     , 84.9166677728     , 85.8273982824     , 83.3910491062     ,
 78.0180762692     , 70.2639043672     , 60.8733990405     , 50.8423588383     ,
 41.1706620763     , 32.5137147348     , 25.1248411326     , 19.0327542359     ,
 14.1551349051     , 10.3202124693     , 7.32971318213     , 5.04070918711     ,
 3.36690222459     , 2.21594040319     , 1.45731880901     , 0.955431699592    ,
 0.615326632131    , 0.387990015553    , 0.244598870135    , 0.158444560288    ,
 0.10642314801     , 0.0747984720199   , 0.0573213918809   , 0.0487887135717   ,
 0.0424800535008   , 0.0335215571593   , 0.0221310073799   , 0.0117787907255   ,
 0.00497943586499  , 0.00166319464891  , 0.000438684174505 , 9.26478801671e-05 ,
 1.91388714486e-05 , 1.12549469872e-05 , 1.68116770981e-05 , 2.34956876973e-05 ,
 2.63240472711e-05 , 2.39854989035e-05 , 1.97960834749e-05 , 1.97905653932e-05 ,
 2.88650926051e-05 , 4.74120522886e-05 , 6.95322547105e-05 , 8.4801232025e-05  ,
 8.47180881763e-05 , 6.91871202128e-05 , 4.63640822336e-05 , 2.67872949946e-05 ,
 2.2065189136e-05  , 6.72068272958e-05 , 0.000308096044104 , 0.00121126100069  ,
 0.00381651313109  , 0.00954094307865  , 0.0189054804987   , 0.0298261882949   ,
 0.0379278391923   , 0.0399791941375   , 0.0371018273673   , 0.033915822792    ,
 0.0351356104146   , 0.0435893753099   , 0.0603207544533   , 0.0860025828506   ,
 0.123694535173    , 0.180101065231    , 0.261613918974    , 0.369247103131    ,
 0.501705302718    , 0.667308467998    , 0.894095700617    , 1.22795440359     ,
 1.71977183184     , 2.41216125339     , 3.33206559792     , 4.48199353202     ,
 5.82822507409     , 7.31138227555     , 8.89585996409     , 10.6125781749     ,
 12.5321135005     , 14.6908192543     , 17.061376336      , 19.5966972138     ,
 22.2788458089     , 25.1123668821     , 28.0757987237     , 31.087723004      ,
 34.0309471531     , 36.8120762952     , 39.3815702836     , 41.7096791439     ,
 43.8118826556     , 45.831633196      , 48.0214580142     , 50.5417228179     ,
 53.2469205217     , 55.6339932011     , 56.9225508036     , 56.2384126975     ,
 52.9641272859     , 47.1212992784     , 39.4491161204     , 31.07893183       ,
 23.0732259002     , 16.1390103111     , 10.6021493275     , 6.51642891584     ,
 3.75481923385     , 2.06099155824     , 1.11587179197     , 0.622497543952    ,
 0.365223284099    , 0.22068772374     , 0.133317303678    , 0.0813882512291   ,
 0.0541253320547   , 0.0440410772343   , 0.0456159113469   , 0.0531680939267   ,
 0.0595598976665   , 0.0586537111831   , 0.0489709779416   , 0.0341633549831   ,
 0.0197822426528   , 0.00954349644932  , 0.00406549890965  , 0.0021852895091   ,
 0.00285317189054  , 0.00588044779717  , 0.0111737758173   , 0.0173531942224   ,
 0.0215431843649   , 0.0212873002597   , 0.0167801147267   , 0.0106743106311   ,
 0.00569265466828  , 0.00288176086763  , 0.00195826912077  , 0.0025666094194   ,
 0.00482162758539  , 0.00869574794196  , 0.013052055742    , 0.0157278368916   ,
 0.0151251041388   , 0.0117063262734   , 0.00755288208031  , 0.00452474256415  ,
 0.00309637150643  , 0.00270360588369  , 0.00272519153074  , 0.00304195626245  ,
 0.00391773287046  , 0.00568104938283  , 0.00889942887739  , 0.0152754345657   ,
 0.0286843687519   , 0.0557392548092   , 0.107010220289    , 0.202214019862    ,
 0.381430931585    , 0.718233089848    , 1.32523285975     , 2.34544083606     ,
 9.08277883748     , 13.6510513988     , 19.4460239447     , 26.3619045059     ,
 34.2113474578     , 42.8037472283     , 51.979082746      , 61.593237669      ,
 71.537098348      , 81.7110548655     , 91.7497232827     , 100.659056894     ,
 106.915020157     , 109.183566874     , 107.046423723     , 101.039419268     ,
 92.0800898016     , 81.0107764906     , 68.6742555246     , 56.1150000432     ,
 44.3930915316     , 34.2083827505     , 25.8138267825     , 19.1844103786     ,
 14.1272754287     , 10.3210792233     , 7.42838188714     , 5.22225196938     ,
 3.59089430593     , 2.44829728495     , 1.67827903184     , 1.15761038697     ,
 0.798698634095    , 0.554136921535    , 0.392593209292    , 0.284067794367    ,
 0.204552331194    , 0.143015700896    , 0.0982088609495   , 0.0693659832424   ,
 0.0512192173072   , 0.0370922981338   , 0.0240133499496   , 0.0130351221626   ,
 0.00574777404634  , 0.0020319667538   , 0.000575598184133 , 0.000138468830946 ,
 4.92782222386e-05 , 6.05448705103e-05 , 0.000101117543852 , 0.000141446495972 ,
 0.000158394762702 , 0.000145374261585 , 0.000122292743226 , 0.000124062914423 ,
 0.000177488599179 , 0.000282758966555 , 0.000405689554251 , 0.00048885932554  ,
 0.000486177359008 , 0.000397246322542 , 0.000266445774859 , 0.000147894119465 ,
 7.5978126939e-05  , 7.89208046056e-05 , 0.000260595579052 , 0.000977089582283 ,
 0.00304128849263  , 0.00758717335386  , 0.0151342344332   , 0.0243779067294   ,
 0.0325611326999   , 0.0380662189653   , 0.0425096510612   , 0.0498882472846   ,
 0.0646888517587   , 0.0913770761106   , 0.134235401683    , 0.197735504639    ,
 0.289501491107    , 0.42157723501     , 0.603671005532    , 0.835889700399    ,
 1.11611630161     , 1.45976217191     , 1.91122377417     , 2.53354374552     ,
 3.38405724675     , 4.49628641612     , 5.88096476503     , 7.53371183532     ,
 9.42831657931     , 11.509943591      , 13.7205857729     , 16.0365360464     ,
 18.4644390162     , 21.0028566251     , 23.6236933037     , 26.2786258147     ,
 28.8964378666     , 31.3800796359     , 33.6341906679     , 35.606765578      ,
 37.3033192509     , 38.7542827695     , 39.9512435173     , 40.823266665      ,
 41.3322055777     , 41.6223260596     , 42.0189776513     , 42.8072436772     ,
 43.9947556831     , 45.2525898618     , 45.9948897781     , 45.5281255554     ,
 43.306797899      , 39.2164934231     , 33.6530462622     , 27.3279968479     ,
 20.9828514021     , 15.2016810151     , 10.359078507      , 6.63245591021     ,
 4.01569960151     , 2.34502590915     , 1.36622642691     , 0.822196090086    ,
 0.515993887206    , 0.329893245178    , 0.209095035648    , 0.131794508701    ,
 0.0868088705847   , 0.065826574868    , 0.0623690585435   , 0.0696362863583   ,
 0.0786358948834   , 0.0803810066758   , 0.0706341073093   , 0.0522334775947   ,
 0.0323383947282   , 0.0170399551099   , 0.00822675217452  , 0.00453161586348  ,
 0.00394595929296  , 0.00531920183293  , 0.00813644685731  , 0.0115315408447   ,
 0.013929122021    , 0.0139912284502   , 0.0118490869106   , 0.00898695152063  ,
 0.00683904769158  , 0.00583034425996  , 0.0058920254187   , 0.00759804573845  ,
 0.0122926817483   , 0.0204857199056   , 0.0298464372828   , 0.0356175798022   ,
 0.0342911476519   , 0.0269407552212   , 0.0182101489683   , 0.012195631692    ,
 0.00980917073539  , 0.00957657858633  , 0.0100153949567   , 0.0110560306528   ,
 0.0136969747693   , 0.0190936171134   , 0.0290008837676   , 0.0482458702081   ,
 0.0878550754533   , 0.167320757776    , 0.31790035059     , 0.59274934885     ,
 1.08667078699     , 1.95580982614     , 3.41760182105     , 5.71909411189     ,
 19.2838951946     , 27.5021918374     , 37.2003417946     , 47.8482497004     ,
 58.8287122665     , 69.7094910663     , 80.3942507104     , 91.0115227291     ,
 101.680135641     , 112.277883511     , 122.150514518     , 129.910468391     ,
 133.768272582     , 132.434883236     , 125.888090402     , 115.276539275     ,
 102.100754741     , 87.5533518506     , 72.5596752537     , 58.0827962181     ,
 45.0578502772     , 34.0743146592     , 25.2865361601     , 18.5632865635     ,
 13.5989554069     , 9.97219153055     , 7.273597263       , 5.23439584914     ,
 3.72437348384     , 2.65475367746     , 1.9173603374      , 1.40296600714     ,
 1.03716254296     , 0.779702010661    , 0.600027330283    , 0.466004292308    ,
 0.353021634513    , 0.253564603402    , 0.173036818489    , 0.116593204921    ,
 0.0806442300428   , 0.0559938332464   , 0.036103347542    , 0.0200834795799   ,
 0.00922901692432  , 0.00343747128743  , 0.00104506501724  , 0.000302167779232 ,
 0.000186013841289 , 0.000296928501703 , 0.000498459063392 , 0.00069015065776  ,
 0.000770879008353 , 0.000714148857447 , 0.00061669516742  , 0.000640115931343 ,
 0.000898767911407 , 0.00137902064441  , 0.00191894160314  , 0.00226802706411  ,
 0.00223368393582  , 0.00182067746515  , 0.00122512403744  , 0.000684057066871 ,
 0.000335113221026 , 0.000207196498511 , 0.000326724979514 , 0.000872484832411 ,
 0.00231486367815  , 0.00536685383951  , 0.0105335091138   , 0.0176091744804   ,
 0.0261737121008   , 0.0371820722151   , 0.0537691878562   , 0.0804342441105   ,
 0.122836049962    , 0.188777109052    , 0.287531691537    , 0.428930837058    ,
 0.626660111292    , 0.899631706026    , 1.26166161859     , 1.71119394674     ,
 2.24413508201     , 2.88360746197     , 3.69194774508     , 4.74690537097     ,
 6.10036260925     , 7.75435802951     , 9.67758232143     , 11.8437116888     ,
 14.2392919649     , 16.8305526982     , 19.5439995976     , 22.2912800254     ,
 25.0042506631     , 27.6497434633     , 30.2184459474     , 32.676024905      ,
 34.8998641466     , 36.688457524      , 37.8787010129     , 38.4671724902     ,
 38.6095405857     , 38.4940748222     , 38.1968574835     , 37.6516754645     ,
 36.7906150163     , 35.7356627831     , 34.814013359      , 34.3353835452     ,
 34.3504774343     , 34.6097270448     , 34.6850055284     , 34.1156370807     ,
 32.5498384922     , 29.8720511746     , 26.2344067718     , 21.9695153791     ,
 17.4751239107     , 13.1423623738     , 9.31309879028     , 6.22866921655     ,
 3.97721013759     , 2.48565624151     , 1.57442844465     , 1.03847698689     ,
 0.710120560403    , 0.4861330411      , 0.321596090926    , 0.204207832613    ,
 0.129904114259    , 0.0927522180729   , 0.0846480775351   , 0.0952398859611   ,
 0.111109491419    , 0.118420578538    , 0.109159209084    , 0.0855165884285   ,
 0.0572647653767   , 0.0339961873257   , 0.019612199675    , 0.0128415815891   ,
 0.0107498658188   , 0.0111601630504   , 0.0129789364026   , 0.0154301730762   ,
 0.0175228680977   , 0.0184669259748   , 0.0184507510129   , 0.0184936786535   ,
 0.0192091484107   , 0.0200779687197   , 0.0206287438634   , 0.0224190515727   ,
 0.0289043748985   , 0.0418971079021   , 0.0575668148766   , 0.0673671067279   ,
 0.0649792504211   , 0.0523960075002   , 0.038041596818    , 0.029237581072    ,
 0.027264634994    , 0.0288629124451   , 0.0310619194494   , 0.0342617813308   ,
 0.0415282998648   , 0.0566465746186   , 0.085304378702    , 0.140892100419    ,
 0.252114609177    , 0.469571699129    , 0.874055127493    , 1.59384469728     ,
 2.83105727125     , 4.87765382685     , 8.09090339609     , 12.816851865      ,
 37.3731338555     , 50.5945431709     , 65.0661786289     , 79.6326262944     ,
 93.1833443838     , 105.185906072     , 115.903018739     , 126.009278877     ,
 135.929049062     , 145.38758882      , 153.289504247     , 157.900873648     ,
 157.445547207     , 150.993078736     , 139.057197533     , 123.361340293     ,
 105.92426757      , 88.2799792241     , 71.4095130341     , 56.0598605452     ,
 42.8295292395     , 32.0118721079     , 23.5612998836     , 17.220157211      ,
 12.6123385751     , 9.29687247063     , 6.87096193087     , 5.06679818586     ,
 3.74162641517     , 2.79551597035     , 2.12472395985     , 1.63853012852     ,
 1.28212586162     , 1.02542792056     , 0.838129639085    , 0.684796223649    ,
 0.540369978597    , 0.402098123314    , 0.283270994572    , 0.19552841883     ,
 0.136891457439    , 0.0955777126015   , 0.0621569735793   , 0.0351303416108   ,
 0.0165383913228   , 0.00639082304971  , 0.00209802182125  , 0.000784652782997 ,
 0.000727629657277 , 0.00124086396701  , 0.00202919829277  , 0.00275724408602  ,
 0.00306237502149  , 0.0028682332039   , 0.00255869235886  , 0.00273480923943  ,
 0.00377362858139  , 0.00554768031171  , 0.00742317645705  , 0.00853185520309  ,
 0.00826428556239  , 0.00669100310295  , 0.00451325457079  , 0.00255703697368  ,
 0.00129887592732  , 0.00080382509145  , 0.000965748925316 , 0.00172894704922  ,
 0.00317981692637  , 0.00560077412278  , 0.00953982958779  , 0.0160310375254   ,
 0.0273424077453   , 0.0480090166232   , 0.0848368631266   , 0.145918488065    ,
 0.241071796555    , 0.383366875915    , 0.587883374557    , 0.870065851502    ,
 1.24996084449     , 1.7540282949      , 2.40057929435     , 3.18457950308     ,
 4.09500769566     , 5.15675557599     , 6.44564508866     , 8.04925288956     ,
 10.0031009095     , 12.2572853528     , 14.7118133967     , 17.2964171311     ,
 20.0052430432     , 22.8399051864     , 25.735649865      , 28.5645353074     ,
 31.209874908      , 33.6336197294     , 35.8623854601     , 37.8770531686     ,
 39.5014524673     , 40.44131727       , 40.4861776869     , 39.6854496974     ,
 38.3239047309     , 36.7253860998     , 35.057133637      , 33.2949790352     ,
 31.3809871628     , 29.4234250792     , 27.7142768036     , 26.5160048096     ,
 25.8377342438     , 25.4296751306     , 24.9584126543     , 24.1624164689     ,
 22.8979106311     , 21.1253405931     , 18.8826978804     , 16.2590570412     ,
 13.388866599      , 10.4661184797     , 7.73565644113     , 5.42979794445     ,
 3.6824384446      , 2.48867393014     , 1.73536884021     , 1.26737938136     ,
 0.947103051777    , 0.689993197631    , 0.469882961433    , 0.295648763141    ,
 0.179626588962    , 0.12176884226     , 0.111340541536    , 0.131979946154    ,
 0.163291092264    , 0.183851366745    , 0.179456315327    , 0.150731088741    ,
 0.110935760654    , 0.0749530181415   , 0.050452646561    , 0.0375626169113   ,
 0.0331237556041   , 0.0340009218453   , 0.0380238509743   , 0.0434913382567   ,
 0.0486782748358   , 0.0524202344899   , 0.0552008711328   , 0.0587074150965   ,
 0.063277247443    , 0.0663735914942   , 0.0654744128161   , 0.0629467656519   ,
 0.0660647528466   , 0.0798501975426   , 0.0995548723746   , 0.112302685892    ,
 0.108416409016    , 0.0909000352719   , 0.0725208037688   , 0.0641750577973   ,
 0.0670082475879   , 0.0748204417421   , 0.0825251390204   , 0.0919778023773   ,
 0.11109788291     , 0.150922840204    , 0.228697383007    , 0.379483539027    ,
 0.671564231877    , 1.22163255992     , 2.21264177676     , 3.91744988729     ,
 6.71610123503     , 11.0751256301     , 17.4627323154     , 26.2118253968     ,
 65.8593506412     , 84.674978706      , 103.654265454     , 121.032857451     ,
 135.408828419     , 146.486813171     , 155.217541842     , 162.978337504     ,
 170.423935788     , 176.930236423     , 180.86215466      , 180.302567395     ,
 173.865404277     , 161.327152767     , 143.83266153      , 123.514926869     ,
 102.665564359     , 82.9890423815     , 65.4237421        , 50.3972844534     ,
 38.0442664121     , 28.2600222328     , 20.7636656917     , 15.1972289918     ,
 11.1730332129     , 8.29596355537     , 6.22217382185     , 4.71247590578     ,
 3.61767692914     , 2.82604013769     , 2.2427077586      , 1.80440195426     ,
 1.48109130926     , 1.24997229051     , 1.07449691646     , 0.913008490559    ,
 0.74247504725     , 0.568719108489    , 0.414137380918    , 0.295777997056    ,
 0.212450988765    , 0.150402139554    , 0.0987277759549   , 0.0565832124675   ,
 0.0273699395989   , 0.0111923832673   , 0.00423159204639  , 0.00222948265156  ,
 0.00264554036488  , 0.0044292094206   , 0.00692085741283  , 0.00913925469324  ,
 0.0100465353039   , 0.00951702369107  , 0.00880373768607  , 0.00971116785227  ,
 0.0131841516299   , 0.0185296979747   , 0.023683521926    , 0.0262451355981   ,
 0.0248090552423   , 0.0198525645729   , 0.0134251524036   , 0.00779811139209  ,
 0.00426667580578  , 0.00301689528714  , 0.00372196353404  , 0.00598011306362  ,
 0.00937806802117  , 0.01373375421     , 0.0198515726164   , 0.0304857915077   ,
 0.051374236605    , 0.0922523656634   , 0.1666492554      , 0.290066832408    ,
 0.479235840219    , 0.753209488637    , 1.1323966709      , 1.63730231385     ,
 2.29362130747     , 3.13383681725     , 4.17775015379     , 5.41075900816     ,
 6.80441123517     , 8.37322465412     , 10.1983218964     , 12.3738608471     ,
 14.9154972626     , 17.713589159      , 20.5877663492     , 23.4097049985     ,
 26.1687729437     , 28.9018987936     , 31.5756193994     , 34.0663779595     ,
 36.2600111842     , 38.151766501      , 39.8158366522     , 41.2400454491     ,
 42.1928689217     , 42.3090373479     , 41.3551636788     , 39.4217555972     ,
 36.8699246713     , 34.1053561325     , 31.3698929809     , 28.701071007      ,
 26.0795157556     , 23.612560923      , 21.545075611      , 20.0638865302     ,
 19.1062943009     , 18.3899477468     , 17.6233123931     , 16.666520259      ,
 15.5202593068     , 14.2279233598     , 12.809896411      , 11.2570627161     ,
 9.5635343799      , 7.77651232333     , 6.02335546469     , 4.47492077308     ,
 3.26197772386     , 2.41466758499     , 1.86679673821     , 1.5027596094      ,
 1.21045344238     , 0.924096022624    , 0.641315951922    , 0.400230338698    ,
 0.236110485933    , 0.157093886973    , 0.149228148177    , 0.189071785628    ,
 0.247971400112    , 0.294399698663    , 0.304500400692    , 0.274736396311    ,
 0.22143612264     , 0.166447716685    , 0.124213886461    , 0.0995547967698   ,
 0.091404151433    , 0.0961707286842   , 0.109407410908    , 0.12628917176     ,
 0.141984222422    , 0.153394754574    , 0.161458767323    , 0.170036865757    ,
 0.179879807561    , 0.184619009332    , 0.176959231436    , 0.159874497669    ,
 0.147514522096    , 0.151631314497    , 0.168114141072    , 0.179661265698    ,
 0.172837849952    , 0.151509835868    , 0.132809476657    , 0.131063889461    ,
 0.146536926151    , 0.168962522319    , 0.190827593977    , 0.217315230182    ,
 0.266411021749    , 0.366518427247    , 0.563653075199    , 0.941260656782    ,
 1.64647482901     , 2.91885482351     , 5.12124106636     , 8.75857003584     ,
 14.4458858513     , 22.7893314077     , 34.1980959534     , 48.7053233199     ,
 105.32219566      , 128.781901743     , 150.317517585     , 167.943029219     ,
 180.468857228     , 188.246868952     , 193.059101063     , 196.849716183     ,
 200.249440154     , 202.129155133     , 200.391472414     , 193.227217743     ,
 179.996369196     , 161.414361475     , 139.239675719     , 115.756819824     ,
 93.1676010303     , 73.0431788836     , 56.1159667238     , 42.4506832798     ,
 31.7341918502     , 23.5024896395     , 17.2929588843     , 12.7085664475     ,
 9.40097561619     , 7.05069879387     , 5.38717667487     , 4.20809559067     ,
 3.36404286742     , 2.73812526803     , 2.25312975558     , 1.88072489932     ,
 1.61569944178     , 1.43456895123     , 1.28614173373     , 1.12147842729     ,
 0.925639178844    , 0.719150169138    , 0.534262553699    , 0.39039643035     ,
 0.285238631605    , 0.203900385413    , 0.1354063269      , 0.0796934202656   ,
 0.0408474781709   , 0.0188089548199   , 0.00902141398133  , 0.00658946424084  ,
 0.00861198867256  , 0.0136275707692   , 0.0200818242159   , 0.0255203270441   ,
 0.0276042209688   , 0.0264098237318   , 0.0253208721965   , 0.0287271282594   ,
 0.0383618188642   , 0.0515775671437   , 0.0627732260789   , 0.0666297681945   ,
 0.0610238674419   , 0.0480642447183   , 0.032706323562    , 0.0198715135478   ,
 0.0122558862113   , 0.0102775799273   , 0.0133158721519   , 0.0204547356164   ,
 0.030504002835    , 0.0427380530912   , 0.0588846765691   , 0.0848799256229   ,
 0.131699127897    , 0.216343839892    , 0.361780158055    , 0.593415227064    ,
 0.935456456804    , 1.41155140444     , 2.04598064537     , 2.86363953776     ,
 3.8941079687      , 5.17026129036     , 6.70302283914     , 8.45442762362     ,
 10.3639746945     , 12.4249415753     , 14.7212792853     , 17.358343169      ,
 20.3375588508     , 23.4956809139     , 26.5828704877     , 29.4229337475     ,
 31.9964501622     , 34.3595562545     , 36.5052784774     , 38.3381260487     ,
 39.7875395103     , 40.9142294995     , 41.8502654958     , 42.5916447023     ,
 42.867185188      , 42.2734690121     , 40.5733960104     , 37.8727428534     ,
 34.5482021376     , 31.0346302411     , 27.6308718435     , 24.4409153665     ,
 21.4841021803     , 18.8530481386     , 16.7290087549     , 15.2214503416     ,
 14.2158543656     , 13.4195835037     , 12.5686287471     , 11.577642887      ,
 10.5092710509     , 9.4533849162      , 8.45135910106     , 7.48877456626     ,
 6.52072253451     , 5.51710626979     , 4.50919327781     , 3.58907642041     ,
 2.85023598397     , 2.32585778194     , 1.97617887224     , 1.71610065478     ,
 1.45621767978     , 1.14794761193     , 0.810822203493    , 0.5107293701      ,
 0.305409573234    , 0.211560729408    , 0.213085379188    , 0.28113537338     ,
 0.38020160458     , 0.468129342352    , 0.508100338477    , 0.487654382911    ,
 0.42287759127     , 0.343065867476    , 0.273787846533    , 0.230481080879    ,
 0.218538581015    , 0.23487651662     , 0.270687651679    , 0.314480867284    ,
 0.354670332385    , 0.383402225123    , 0.401126969466    , 0.415089408784    ,
 0.427837944505    , 0.428313829638    , 0.40240338061     , 0.354252476928    ,
 0.309030164819    , 0.289434616091    , 0.293183144882    , 0.297398848212    ,
 0.283721118381    , 0.256860739085    , 0.239204764239    , 0.249370998838    ,
 0.286819951589    , 0.336869523339    , 0.390203746849    , 0.458893661237    ,
 0.580468928702    , 0.8200808521      , 1.28473186472     , 2.15157788293     ,
 3.70466290667     , 6.37845704268     , 10.7972966609     , 17.7598374066     ,
 28.0926437557     , 42.3610762723     , 60.5629218688     , 81.991651722      ,
 152.801890945     , 178.183003035     , 198.922296418     , 213.486295451     ,
 221.487940195     , 224.158547942     , 223.899691523     , 222.770602777     ,
 221.04117157      , 217.09282179      , 208.692752767     , 194.528413684     ,
 174.921992104     , 151.50675025      , 126.456187207     , 101.900239838     ,
 79.6013777364     , 60.7008984678     , 45.580261113      , 33.9684753197     ,
 25.231866359      , 18.6844041062     , 13.7878043336     , 10.1774963648     ,
 7.58081480275     , 5.75793360588     , 4.50165207        , 3.64246380524     ,
 3.03639681672     , 2.56925129586     , 2.18510047997     , 1.88842381449     ,
 1.69260656965     , 1.56714586923     , 1.44413728307     , 1.27101568813     ,
 1.04728770761     , 0.812016845283    , 0.605954784101    , 0.446902254054    ,
 0.329332249972    , 0.23797259944     , 0.162398741643    , 0.101821666298    ,
 0.0588880794013   , 0.0330385617708   , 0.0207101302551   , 0.0185764303311   ,
 0.0245178363943   , 0.036314428702    , 0.0502184322129   , 0.060983820324    ,
 0.0645375346298   , 0.062151259943    , 0.0614165044192   , 0.0710039530764   ,
 0.0929957052374   , 0.11986645128     , 0.139028496517    , 0.140993139364    ,
 0.12462203768     , 0.0965931812158   , 0.0669341527342   , 0.0440678352801   ,
 0.0322010027666   , 0.031951175281    , 0.0423786145507   , 0.061886794206    ,
 0.0882481479008   , 0.120546763499    , 0.163262334729    , 0.228425591017    ,
 0.334619050431    , 0.507159560797    , 0.778772843488    , 1.18424579264     ,
 1.75304920335     , 2.5103347137      , 3.48209319597     , 4.69607263299     ,
 6.18161547015     , 7.96134813197     , 10.0194079911     , 12.2744567416     ,
 14.6205343539     , 17.0293015386     , 19.5995806894     , 22.4639102254     ,
 25.6211538346     , 28.8666361898     , 31.9067533218     , 34.5521233802     ,
 36.7905195775     , 38.6781801802     , 40.2001452028     , 41.2698600534     ,
 41.8623708585     , 42.1123846917     , 42.2192332932     , 42.2087651373     ,
 41.811256735      , 40.6279986261     , 38.4310169439     , 35.3121405681     ,
 31.6140838285     , 27.7630364123     , 24.0999509096     , 20.7870528177     ,
 17.8592838154     , 15.3569072849     , 13.3698919414     , 11.9380591337     ,
 10.9403600034     , 10.1274595763     , 9.28178455451     , 8.33846263857     ,
 7.36129818383     , 6.44283038851     , 5.6408821716      , 4.96636545139     ,
 4.38773692606     , 3.85473903039     , 3.34356344962     , 2.87865396811     ,
 2.50212408926     , 2.22860731975     , 2.0304211437      , 1.8491951544      ,
 1.61940755384     , 1.307753419       , 0.946762200939    , 0.618017126959    ,
 0.393705928197    , 0.298153768362    , 0.316815383965    , 0.420421933465    ,
 0.570981389454    , 0.717375506869    , 0.806638977505    , 0.810533837351    ,
 0.739562918021    , 0.631092245286    , 0.527795388898    , 0.462721865933    ,
 0.451896543686    , 0.493047806208    , 0.570727848046    , 0.663590122719    ,
 0.749485472332    , 0.810993606587    , 0.843745409582    , 0.857449261671    ,
 0.8594088317      , 0.837698477363    , 0.77389348805     , 0.675666092845    ,
 0.582365676608    , 0.529562283587    , 0.51541722363     , 0.507911365741    ,
 0.481114203261    , 0.440964239763    , 0.418193184713    , 0.43950262208     ,
 0.50642233084     , 0.601958770714    , 0.718081716896    , 0.881108775434    ,
 1.16517619574     , 1.70502071003     , 2.71926368519     , 4.54181801574     ,
 7.65869406321     , 12.7545977596     , 20.7413988331     , 32.6651994413     ,
 49.3830496        , 71.071067094      , 96.8594590364     , 124.89503008      ,
 201.511654118     , 225.016278486     , 241.429657931     , 250.270829283     ,
 252.236081099     , 249.264844821     , 243.851941855     , 237.625234346     ,
 230.28908758      , 219.992540547     , 204.868294124     , 184.464091495     ,
 160.062064974     , 133.921542066     , 108.272850098     , 84.7964143961     ,
 64.5870606296     , 48.197636269      , 35.6191462011     , 26.3416182533     ,
 19.5799769331     , 14.5800772364     , 10.8268323628     , 8.03888027961     ,
 6.03588275094     , 4.65056139631     , 3.72550012998     , 3.12096603741     ,
 2.70595300993     , 2.37342827881     , 2.08132137266     , 1.852767957       ,
 1.71073545149     , 1.61981213608     , 1.50436868724     , 1.31561905645     ,
 1.06866943407     , 0.817342154356    , 0.606050176984    , 0.447900595498    ,
 0.333609235735    , 0.248218741789    , 0.18136295988     , 0.128938789945    ,
 0.0895538799992   , 0.062228342512    , 0.0473314215882   , 0.0465801519404   ,
 0.060143087351    , 0.0838402122208   , 0.10918957539     , 0.126510571025    ,
 0.130531962443    , 0.125967547414    , 0.127023427681    , 0.147582866176    ,
 0.188422915923    , 0.233217229445    , 0.258803304926    , 0.251548868423    ,
 0.215248836633    , 0.165698579427    , 0.120036145091    , 0.0897976814902   ,
 0.0797342557107   , 0.0900789214842   , 0.119172581941    , 0.164410150149    ,
 0.222902513331    , 0.295686528213    , 0.394216196742    , 0.541166509493    ,
 0.76469549731     , 1.09676513353     , 1.57583000782     , 2.24058505529     ,
 3.11937465298     , 4.23372681112     , 5.60904603486     , 7.2739075703      ,
 9.25071009408     , 11.5375454213     , 14.0723999464     , 16.714639369      ,
 19.3098723141     , 21.8207336363     , 24.3824566524     , 27.1748244693     ,
 30.2076542422     , 33.2490926522     , 35.9895656455     , 38.2650775504     ,
 40.0955295285     , 41.5284775476     , 42.5055449987     , 42.9080214171     ,
 42.721467403      , 42.1302728135     , 41.3991505185     , 40.6157183691     ,
 39.5665191589     , 37.9019109225     , 35.4120960905     , 32.1540532681     ,
 28.4060182091     , 24.5581814643     , 20.9725070314     , 17.8509851346     ,
 15.2196937108     , 13.0358524298     , 11.2789351416     , 9.93128932436     ,
 8.90770917351     , 8.04969982294     , 7.2097357342      , 6.33367503044     ,
 5.45779681845     , 4.64896237947     , 3.96156239118     , 3.42355730841     ,
 3.02747999153     , 2.73489270373     , 2.50601258622     , 2.32344938389     ,
 2.18302976888     , 2.07356654471     , 1.97163013421     , 1.84287500302     ,
 1.64640879673     , 1.3615098189      , 1.02212013667     , 0.708886443851    ,
 0.496971626247    , 0.417190984206    , 0.462270153758    , 0.609481548749    ,
 0.82330440841     , 1.04440240851     , 1.1991932447      , 1.23731792553     ,
 1.1617640177      , 1.0225910197      , 0.886135727251    , 0.806203078498    ,
 0.808680444215    , 0.890414354545    , 1.02911073813     , 1.19433404271     ,
 1.35156452903     , 1.46643912596     , 1.51966266634     , 1.51852264139     ,
 1.48032956575     , 1.40396017901     , 1.27673323315     , 1.11391026375     ,
 0.968101567398    , 0.884335306207    , 0.856648458657    , 0.839048789134    ,
 0.79466632843     , 0.730794752688    , 0.690674129398    , 0.715869821796    ,
 0.817498094082    , 0.983743340275    , 1.21681867245     , 1.5724541917      ,
 2.19001378745     , 3.32171265491     , 5.36307103942     , 8.87224746718     ,
 14.5780570185     , 23.3941038686     , 36.4029541912     , 54.6607602606     ,
 78.6965900163     , 107.87939996      , 140.139148076     , 172.401095722     ,
 242.795041465     , 260.898710238     , 270.728626635     , 272.994440482     ,
 269.182294275     , 261.358224993     , 251.514015584     , 240.531875531     ,
 227.671534473     , 211.301772023     , 190.386893333     , 165.491645229     ,
 138.613335053     , 112.181999157     , 88.0932213911     , 67.3748458462     ,
 50.3950662503     , 37.1362449615     , 27.2829890601     , 20.2310043196     ,
 15.2023443207     , 11.4903794816     , 8.65630103232     , 6.51062246558     ,
 4.95479533529     , 3.87994568372     , 3.17119396044     , 2.7239907368      ,
 2.43158452204     , 2.19584424282     , 1.97400100421     , 1.7880678268      ,
 1.66294873749     , 1.5681851234      , 1.43694468399     , 1.23242136994     ,
 0.980026234206    , 0.736763903154    , 0.542839322097    , 0.405352019257    ,
 0.312734554267    , 0.250865011787    , 0.208195959968    , 0.175218559079    ,
 0.145107710632    , 0.117254432668    , 0.0990781366217   , 0.100923124631    ,
 0.12657615979     , 0.167795341702    , 0.207750387372    , 0.230727511873    ,
 0.232175468539    , 0.223570515972    , 0.227273200844    , 0.261191028361    ,
 0.32221758062     , 0.382915884541    , 0.408920358881    , 0.384676218001    ,
 0.323327890956    , 0.253429960971    , 0.199883373591    , 0.175914178555    ,
 0.185173058548    , 0.225762323024    , 0.293122240493    , 0.382462292944    ,
 0.492369471914    , 0.631926455375    , 0.827475873883    , 1.11825522737     ,
 1.54297836727     , 2.13584216172     , 2.93166289595     , 3.95861616189     ,
 5.22734433987     , 6.74511557668     , 8.53716638029     , 10.6376887749     ,
 13.0590724718     , 15.7614345263     , 18.6242553176     , 21.4493372549     ,
 24.0498413355     , 26.3975875169     , 28.6751947884     , 31.1170026721     ,
 33.7574304714     , 36.3599358871     , 38.6219753327     , 40.4189886393     ,
 41.8074788266     , 42.8272604162     , 43.3742076042     , 43.2812265598     ,
 42.5065841029     , 41.2381104573     , 39.7817478056     , 38.3043455916     ,
 36.6918811427     , 34.675891446      , 32.0691970138     , 28.8838087085     ,
 25.3201620145     , 21.7114685989     , 18.4126250046     , 15.6431447671     ,
 13.4109943758     , 11.5908375483     , 10.060885563      , 8.76511097521     ,
 7.67669040591     , 6.74322808384     , 5.89139797203     , 5.0754883683      ,
 4.29999964671     , 3.5978987939      , 3.00384843555     , 2.54248776814     ,
 2.21960865        , 2.01809669566     , 1.90840796418     , 1.85991377458     ,
 1.84073042082     , 1.81914307762     , 1.77203179484     , 1.68253286138     ,
 1.5298033046      , 1.30158837495     , 1.02477509841     , 0.766741650179    ,
 0.596416949631    , 0.549966342085    , 0.632266402465    , 0.832547618028    ,
 1.11949670095     , 1.42267349957     , 1.64356341561     , 1.70972594382     ,
 1.62355805853     , 1.45641161793     , 1.30035502837     , 1.2237998235      ,
 1.25465456449     , 1.38663521175     , 1.59551472693     , 1.84898376186     ,
 2.10148339264     , 2.29229314975     , 2.37211773862     , 2.33765222981     ,
 2.22308462234     , 2.05536056861     , 1.8424695554      , 1.61097171156     ,
 1.42072808973     , 1.31819325751     , 1.28846129187     , 1.26945909773     ,
 1.21167388574     , 1.12251204289     , 1.05924657151     , 1.0848822774      ,
 1.23217815408     , 1.51065511388     , 1.95285885719     , 2.67180988866     ,
 3.91336660402     , 6.1032537286      , 9.87591883634     , 16.0554945706     ,
 25.5854233642     , 39.4500268214     , 58.5841749492     , 83.6170930782     ,
 114.314579509     , 148.972906169     , 184.385890942     , 216.718434151     ,
 269.488035417     , 280.177889883     , 283.171130232     , 279.946035646     ,
 272.031706919     , 260.893781687     , 247.636638473     , 232.48785265      ,
 214.701762395     , 193.347985908     , 168.444473391     , 141.414113419     ,
 114.538463134     , 89.9598059358     , 68.9633855184     , 51.8842544088     ,
 38.4723490976     , 28.2922783638     , 20.874610608      , 15.6628948222     ,
 12.0004399015     , 9.29069836699     , 7.17775174329     , 5.53625756288     ,
 4.31692360204     , 3.44951144362     , 2.85787692182     , 2.48054638569     ,
 2.24536487875     , 2.06457898237     , 1.88343108549     , 1.70800258567     ,
 1.56068508629     , 1.42609017894     , 1.2613142063      , 1.04782169247     ,
 0.81379286375     , 0.606041669078    , 0.452565421331    , 0.354212229629    ,
 0.298904806898    , 0.273055539118    , 0.262868576855    , 0.25368217842     ,
 0.234384980284    , 0.205788586438    , 0.183704696143    , 0.189012111245    ,
 0.2300358548      , 0.292692735799    , 0.348480970966    , 0.374356100059    ,
 0.368850610774    , 0.353312621475    , 0.358015001802    , 0.401447060881    ,
 0.474447784413    , 0.54080154567     , 0.560120430047    , 0.519032617507    ,
 0.441089497442    , 0.366328574327    , 0.325749214526    , 0.333641626458    ,
 0.391923286518    , 0.493241503595    , 0.624497543806    , 0.776020792923    ,
 0.952957008308    , 1.18391182979     , 1.52152356307     , 2.02760366625     ,
 2.75140463683     , 3.72379739345     , 4.96131456912     , 6.4540676586      ,
 8.1618253772      , 10.0584900484     , 12.1772586433     , 14.581353483      ,
 17.2863620048     , 20.21071771       , 23.1752289378     , 25.9451011198     ,
 28.3308254995     , 30.3239059589     , 32.1389768518     , 34.0502355682     ,
 36.1304710482     , 38.1713893095     , 39.8905409211     , 41.1783075631     ,
 42.0970655492     , 42.6837611149     , 42.828519805      , 42.3510155479     ,
 41.1787014376     , 39.4632240659     , 37.5075767439     , 35.5386797986     ,
 33.5479746174     , 31.3570123927     , 28.8016560086     , 25.8494061235     ,
 22.6247518633     , 19.3930769778     , 16.4750152429     , 14.083706093      ,
 12.2102195252     , 10.6754367915     , 9.29658809329     , 8.00848821755     ,
 6.84590752657     , 5.84454305258     , 4.98646561604     , 4.23012014159     ,
 3.55509396606     , 2.96451506955     , 2.46626843447     , 2.0666141253      ,
 1.77083140924     , 1.5795062994      , 1.48403337427     , 1.4621141588      ,
 1.47626930813     , 1.48643287149     , 1.4687038729      , 1.41443630081     ,
 1.31361750382     , 1.15741759429     , 0.962851732982    , 0.780363597152    ,
 0.668450225244    , 0.666338867152    , 0.791353760279    , 1.04504096358     ,
 1.39813334664     , 1.76651039949     , 2.02981612792     , 2.10468859616     ,
 2.00543665176     , 1.82790600767     , 1.68014538197     , 1.62976306016     ,
 1.69686791775     , 1.87365388744     , 2.14447366921     , 2.48657168792     ,
 2.84697420579     , 3.13079462112     , 3.24522169298     , 3.16867932        ,
 2.9573230266      , 2.67983772261     , 2.37599000933     , 2.08415965689     ,
 1.8633956884      , 1.75417782953     , 1.73230874747     , 1.72408174794     ,
 1.67002888893     , 1.57528747746     , 1.50699368741     , 1.55131792098     ,
 1.77645122271     , 2.23948352165     , 3.03888604577     , 4.3878984593      ,
 6.6866930049      , 10.5791189855     , 16.9632783133     , 26.9025617207     ,
 41.4204600379     , 61.2658580607     , 86.7483711478     , 117.557114539     ,
 152.388916776     , 188.58291449      , 222.384508231     , 250.107473977     ,
 278.477844313     , 281.756235935     , 279.375194226     , 272.843860291     ,
 262.949527826     , 250.04998252      , 234.337156982     , 215.786364448     ,
 194.175767756     , 169.577410399     , 142.962611815     , 116.205075573     ,
 91.4011711272     , 70.0860493352     , 52.8544916001     , 39.4760568048     ,
 29.3077771199     , 21.7067905992     , 16.1924471404     , 12.3403373871     ,
 9.66314357292     , 7.69146029143     , 6.13652443195     , 4.90087805551     ,
 3.95036327566     , 3.23457727827     , 2.7099386825      , 2.35719630019     ,
 2.13970316492     , 1.9808474529      , 1.812575123       , 1.62243868865     ,
 1.43011526835     , 1.23963787093     , 1.03789059753     , 0.825867977969    ,
 0.628816796212    , 0.475469707362    , 0.377788823787    , 0.330737399425    ,
 0.32174661788     , 0.335940917414    , 0.356941403845    , 0.368074629521    ,
 0.357572469278    , 0.328196538891    , 0.302330385438    , 0.31043247837     ,
 0.366117472549    , 0.449913629158    , 0.520575801299    , 0.546653596079    ,
 0.53049285662     , 0.504598588895    , 0.505930658732    , 0.550132892233    ,
 0.6215794352      , 0.68176768584     , 0.693708642252    , 0.650134384344    ,
 0.580416176731    , 0.528489400703    , 0.528077229636    , 0.596663944406    ,
 0.736493273797    , 0.930767049406    , 1.14955089561     , 1.37481832084     ,
 1.62580827298     , 1.9648927308      , 2.48218912687     , 3.26555588382     ,
 4.37300916939     , 5.82543814194     , 7.60208078292     , 9.61862624477     ,
 11.7425916448     , 13.8944190586     , 16.1326180512     , 18.5905020506     ,
 21.3209510082     , 24.2157111541     , 27.0492701837     , 29.5740432739     ,
 31.6188683281     , 33.1877431628     , 34.4928192301     , 35.8210692823     ,
 37.2937595154     , 38.7604106676     , 39.9581948792     , 40.7478131966     ,
 41.1561130511     , 41.2289634094     , 40.9104475546     , 40.0714103998     ,
 38.6410172174     , 36.7210282974     , 34.5608453994     , 32.3892996107     ,
 30.265187434      , 28.088009227      , 25.723116012      , 23.1112637807     ,
 20.3190477456     , 17.5445633452     , 15.0497693998     , 13.0114381551     ,
 11.4014650541     , 10.0258702392     , 8.69794157288     , 7.37863184026     ,
 6.1574687468      , 5.12462838092     , 4.28902282815     , 3.60625191728     ,
 3.03763171782     , 2.56226514833     , 2.1616489128      , 1.82089514951     ,
 1.53947961806     , 1.3290117705      , 1.19994730405     , 1.14679546093     ,
 1.14180186019     , 1.14846233879     , 1.14366233006     , 1.11984955254     ,
 1.06904171022     , 0.981476216031    , 0.865397338788    , 0.756821428628    ,
 0.703113166944    , 0.742103775822    , 0.89792633861     , 1.17960375731     ,
 1.55814496446     , 1.9420728653      , 2.20610157652     , 2.27505988007     ,
 2.18137301997     , 2.03246452719     , 1.92990319774     , 1.92358354202     ,
 2.02205199282     , 2.22301410095     , 2.53042415382     , 2.94035869373     ,
 3.39747237035     , 3.77348993694     , 3.92982015855     , 3.82354874109     ,
 3.53117224331     , 3.16313916894     , 2.79028045424     , 2.4588405         ,
 2.22131244275     , 2.11037101682     , 2.09867228467     , 2.11214565937     ,
 2.08961739094     , 2.03254748079     , 2.00876799607     , 2.12230593966     ,
 2.48866527175     , 3.24628050159     , 4.60916665987     , 6.94423874796     ,
 10.8470733203     , 17.1867789378     , 27.0746289529     , 41.6807462142     ,
 61.861666893      , 87.7441387642     , 118.539267596     , 152.634302793     ,
 187.683381549     , 220.631241596     , 248.135278756     , 267.650482649     ,
 271.051790548     , 268.589649422     , 263.116563367     , 255.48736885      ,
 245.307240915     , 231.755323537     , 214.400024194     , 193.42853567      ,
 169.487526718     , 143.651273468     , 117.505270323     , 92.9154189294     ,
 71.4573940921     , 53.9519152295     , 40.3976044298     , 30.217133042      ,
 22.625250602      , 16.9622116721     , 12.8210374364     , 9.91571116023     ,
 7.91208928035     , 6.45575825395     , 5.31162912424     , 4.39063559693     ,
 3.65600823741     , 3.06634696781     , 2.60129606301     , 2.27127922784     ,
 2.06411801461     , 1.91188473901     , 1.73938144384     , 1.52402885326     ,
 1.2872539161      , 1.05114681791     , 0.827030455668    , 0.629515281482    ,
 0.477697039667    , 0.383032555371    , 0.344495461913    , 0.352798317358    ,
 0.392995886971    , 0.445541787659    , 0.491028864924    , 0.514781047432    ,
 0.508899029492    , 0.478308581975    , 0.448112842746    , 0.455076382764    ,
 0.51877433863     , 0.617765668628    , 0.700417337204    , 0.726076887278    ,
 0.69853324873     , 0.660044982923    , 0.654007130517    , 0.693234729118    ,
 0.757432603625    , 0.811638022287    , 0.829203006653    , 0.809515945109    ,
 0.779374626527    , 0.776530995027    , 0.834676665486    , 0.979554650093    ,
 1.21883942199     , 1.52485781809     , 1.84511012283     , 2.15126684528     ,
 2.48230414696     , 2.94270719794     , 3.66415322476     , 4.75887148782     ,
 6.28811352879     , 8.25152587164     , 10.5699562694     , 13.0578167915     ,
 15.4713556243     , 17.6775042667     , 19.7797121142     , 22.0134100996     ,
 24.5033163067     , 27.1442126315     , 29.6857484874     , 31.8779450546     ,
 33.563434606      , 34.7374495451     , 35.578056814      , 36.3603956481     ,
 37.2520051038     , 38.1714798364     , 38.8729030896     , 39.1649248315     ,
 39.0256839401     , 38.5285340892     , 37.7121816996     , 36.5429461961     ,
 34.9864272658     , 33.099002567      , 31.033970975      , 28.9490112248     ,
 26.9096923408     , 24.8760153618     , 22.7655293443     , 20.5311662133     ,
 18.2119306039     , 15.9428073078     , 13.9018771567     , 12.1963751219     ,
 10.7737977838     , 9.46206530557     , 8.12192521031     , 6.7655549807      ,
 5.5230931463      , 4.50731270744     , 3.7314786225      , 3.14284087253     ,
 2.6867092259      , 2.32051646752     , 2.00352441044     , 1.70762713118     ,
 1.43262521093     , 1.1991770711      , 1.02946387686     , 0.930900910353    ,
 0.888942397143    , 0.876950044143    , 0.875228191608    , 0.874556336909    ,
 0.863969667752    , 0.830127969956    , 0.774528158462    , 0.722719836161    ,
 0.711430045237    , 0.771844305406    , 0.926426637387    , 1.18519880995     ,
 1.52200404163     , 1.85484519642     , 2.07906717968     , 2.14400464218     ,
 2.09272153601     , 2.01848970689     , 1.99237209155     , 2.03776047659     ,
 2.15566720657     , 2.35612728223     , 2.66599843096     , 3.1017698387      ,
 3.6124276232      , 4.05084663615     , 4.24725343613     , 4.14078970156     ,
 3.81820944329     , 3.4160254068      , 3.02320881656     , 2.68642348802     ,
 2.44916552934     , 2.33931531679     , 2.33595853908     , 2.37908917358     ,
 2.41815246886     , 2.45253774694     , 2.54079513189     , 2.79537482117     ,
 3.38754776062     , 4.57156925671     , 6.72968602519     , 10.4330205817     ,
 16.4918649395     , 25.9537564894     , 40.0006279513     , 59.6644018057     ,
 85.3120946113     , 116.107355191     , 149.912865811     , 183.822851136     ,
 214.8727052       , 240.439421226     , 258.541874542     , 268.429439185     ,
 251.509521907     , 245.764712563     , 239.37539297      , 232.165457184     ,
 222.586928086     , 208.972336131     , 190.696356648     , 168.463486907     ,
 143.814738642     , 118.560359947     , 94.492107607      , 73.139483468      ,
 55.4445624978     , 41.5989022859     , 31.190277572      , 23.5027237244     ,
 17.7961937159     , 13.5151114022     , 10.3508522097     , 8.1117551203      ,
 6.56591935593     , 5.45056430696     , 4.58136242714     , 3.87861924904     ,
 3.30267309976     , 2.81863063253     , 2.42027341717     , 2.13111970551     ,
 1.94764907797     , 1.8053969602      , 1.62868729325     , 1.39576900116     ,
 1.13547006777     , 0.88329317421     , 0.66296354583     , 0.492386106371    ,
 0.38365110362     , 0.338684241051    , 0.352124844151    , 0.413806136715    ,
 0.504176239958    , 0.594667396155    , 0.660326716639    , 0.689767241152    ,
 0.682354403461    , 0.646622802584    , 0.60789979178     , 0.60555971682     ,
 0.665131209434    , 0.768309731777    , 0.858746663771    , 0.886968467986    ,
 0.853182118109    , 0.804887389905    , 0.792737933945    , 0.831402662802    ,
 0.899817265599    , 0.967693339864    , 1.01740526881     , 1.0503328128      ,
 1.08270153874     , 1.13944012687     , 1.25429465719     , 1.46734628359     ,
 1.79854021296     , 2.21399380823     , 2.64167783906     , 3.04417817002     ,
 3.47744746707     , 4.08099894359     , 5.02011258962     , 6.42465441012     ,
 8.34881711067     , 10.751825901      , 13.4769865558     , 16.2405903671     ,
 18.7210300978     , 20.7700330675     , 22.5481694925     , 24.3833326166     ,
 26.4721916178     , 28.7354279441     , 30.9214707245     , 32.7784400565     ,
 34.1443135838     , 34.9864303707     , 35.4332883662     , 35.7296450441     ,
 36.0715614176     , 36.4438712435     , 36.6343726665     , 36.4257306463     ,
 35.7681912738     , 34.7685813016     , 33.5534103196     , 32.1801352451     ,
 30.6595088328     , 29.0098017524     , 27.268115898      , 25.4713427806     ,
 23.6435252225     , 21.7926096104     , 19.9160331836     , 18.0216595593     ,
 16.1505618657     , 14.3782031777     , 12.7813200066     , 11.3804357275     ,
 10.1049404279     , 8.83380625814     , 7.49973426259     , 6.1626486359      ,
 4.96825343793     , 4.02878831339     , 3.35290611162     , 2.87906773927     ,
 2.53599062554     , 2.25882748725     , 1.99012685916     , 1.70222447595     ,
 1.40982098506     , 1.14796937381     , 0.944305885484    , 0.808755619697    ,
 0.734130721855    , 0.70382922721     , 0.703300000356    , 0.721139266929    ,
 0.740756862471    , 0.743382277664    , 0.725269547939    , 0.705358406977    ,
 0.711948631382    , 0.767152722274    , 0.885411830701    , 1.07267719162     ,
 1.30993538626     , 1.54150281319     , 1.70275193282     , 1.77259274501     ,
 1.79003314143     , 1.81295106644     , 1.87108976572     , 1.96408598352     ,
 2.09149722055     , 2.27490433089     , 2.55569859942     , 2.9640056753      ,
 3.46057662677     , 3.90428536726     , 4.1218163184      , 4.0440075455      ,
 3.75414182731     , 3.39106564001     , 3.04329393548     , 2.7490206273      ,
 2.54079265828     , 2.44419389988     , 2.45209416404     , 2.53088378996     ,
 2.65312993302     , 2.82087625596     , 3.07822104525     , 3.53996807838     ,
 4.43978806274     , 6.17315213196     , 9.32690303406     , 14.7031120734     ,
 23.3121576785     , 36.2836070627     , 54.6587173277     , 79.0173418664     ,
 108.916706547     , 142.393481826     , 176.094008921     , 206.27688991      ,
 230.050117137     , 245.96267682      , 253.924502717     , 255.054245968     ,
 225.218297091     , 218.526781424     , 212.708024662     , 206.544536751     ,
 197.71903726      , 184.253797703     , 165.718345286     , 143.397128904     ,
 119.482266041     , 96.1346816864     , 75.0239207261     , 57.2068373585     ,
 43.0634830044     , 32.3455861972     , 24.4231384337     , 18.5818274981     ,
 14.2163747747     , 10.9185541721     , 8.46759578479     , 6.71733387866     ,
 5.49012691172     , 4.5929608462      , 3.89233733863     , 3.32506455569     ,
 2.85404860071     , 2.45163746614     , 2.11990240385     , 1.88416479057     ,
 1.73915334767     , 1.62079791112     , 1.45705364263     , 1.23225117074     ,
 0.982772538584    , 0.749978180667    , 0.557929601504    , 0.419707148649    ,
 0.342866775431    , 0.330394359187    , 0.382788862667    , 0.493373827505    ,
 0.636877972152    , 0.771300174395    , 0.860598465429    , 0.893128581961    ,
 0.876407657439    , 0.826180952674    , 0.769526072335    , 0.74629047794     ,
 0.786867718121    , 0.880916296774    , 0.975246970528    , 1.01414387896     ,
 0.98816698103     , 0.941992772673    , 0.932627567008    , 0.983346511133    ,
 1.07801761262     , 1.18871640667     , 1.29868069987     , 1.4036459736      ,
 1.50552623875     , 1.61663875219     , 1.77355787091     , 2.03414371744     ,
 2.43538664402     , 2.94656742438     , 3.48804474499     , 4.01705102228     ,
 4.594132537       , 5.37194403748     , 6.53235023312     , 8.21402728323     ,
 10.4510913064     , 13.1388023653     , 16.0310614692     , 18.7804836262     ,
 21.0666331179     , 22.7944057505     , 24.1847577627     , 25.6068551038     ,
 27.2840103942     , 29.1581644024     , 30.9917434251     , 32.5350793819     ,
 33.6150576466     , 34.1695491548     , 34.277904599      , 34.1411209223     ,
 33.9599573141     , 33.7812127407     , 33.4627114463     , 32.8152194672     ,
 31.7850789489     , 30.4867167194     , 29.0837819506     , 27.6857660771     ,
 26.3376844127     , 25.0316036946     , 23.7044173271     , 22.2731196011     ,
 20.7038081633     , 19.0358373179     , 17.3454150882     , 15.7081000368     ,
 14.1833665088     , 12.8011582574     , 11.5505970927     , 10.3843999319     ,
 9.23619852655     , 8.04771519608     , 6.81093745512     , 5.60134316357     ,
 4.54991335343     , 3.75566316875     , 3.22348149501     , 2.88441507622     ,
 2.64795024534     , 2.42631979186     , 2.15346097698     , 1.8187438221      ,
 1.46894900559     , 1.16153664354     , 0.925271645611    , 0.761998002064    ,
 0.663724966898    , 0.621345866853    , 0.62551599103     , 0.661442556998    ,
 0.703917337417    , 0.726675018398    , 0.722384550864    , 0.708601681526    ,
 0.710893923515    , 0.744717812227    , 0.813943934428    , 0.915834220186    ,

 1.03793508472     , 1.15607515962     , 1.2496635492      , 1.32273045937     ,
 1.40072989051     , 1.50237606858     , 1.62264309585     , 1.74737027274     ,
 1.87746712112     , 2.03740343706     , 2.26778256071     , 2.60138588933     ,
 3.01568136992     , 3.39933927806     , 3.60487958595     , 3.56861858579     ,
 3.36054582441     , 3.10063402647     , 2.86019395653     , 2.66086955858     ,
 2.52079029119     , 2.46182204338     , 2.49245155809     , 2.61147625523     ,
 2.82244800669     , 3.13652890134     , 3.58816042372     , 4.29987519839     ,
 5.57465679532     , 7.95517136057     , 12.2319657223     , 19.4192319081     ,
 30.6704445083     , 47.0708148682     , 69.2975178139     , 97.186650782      ,
 129.273925977     , 162.564109696     , 193.001450331     , 216.782533452     ,
 231.782968605     , 238.070248982     , 237.361523668     , 232.18628337      ,
 196.879198632     , 190.926560435     , 186.360978541     , 181.186618199     ,
 172.841585978     , 159.557892953     , 141.339457596     , 119.920436964     ,
 97.7868850697     , 77.1003404543     , 59.2231557266     , 44.7494817325     ,
 33.6457759069     , 25.418506331      , 19.373756195      , 14.874067696      ,
 11.4644914824     , 8.87407482407     , 6.94947470467     , 5.56350192331     ,
 4.56726740866     , 3.82015170711     , 3.23194841425     , 2.75504990621     ,
 2.35576330137     , 2.01320817196     , 1.73553968745     , 1.54722924801     ,
 1.44100221769     , 1.35680722777     , 1.22984797302     , 1.04839695906     ,
 0.847831091931    , 0.664582553721    , 0.514845858739    , 0.405087660707    ,
 0.344038726422    , 0.345267477027    , 0.42294810173     , 0.577641870637    ,
 0.778643436171    , 0.967505839332    , 1.09069976534     , 1.12936734981     ,
 1.09683631792     , 1.01994551063     , 0.932540740532    , 0.875720845843    ,
 0.883543520219    , 0.956882738475    , 1.05344592945     , 1.11543720143     ,
 1.11838271945     , 1.09387540425     , 1.10080192355     , 1.1759188214      ,
 1.31394673817     , 1.48696698138     , 1.67030390973     , 1.84882483296     ,
 2.01364637996     , 2.17199287613     , 2.36651513665     , 2.66915290052     ,
 3.13030796635     , 3.72836886034     , 4.38927270418     , 5.06993476341     ,
 5.82241407556     , 6.7899533311      , 8.15440608712     , 10.0546570302     ,
 12.493125261      , 15.2850906534     , 18.0969640297     , 20.5625502401     ,
 22.440544422      , 23.7501888503     , 24.7723476965     , 25.8629067231     ,
 27.2121753897     , 28.7538095823     , 30.261371755      , 31.4954557775     ,
 32.2867779784     , 32.5651245993     , 32.3780685624     , 31.8815950044     ,
 31.2623963027     , 30.6186923439     , 29.899834371      , 28.9803765414     ,
 27.8056134993     , 26.452172943      , 25.0605523641     , 23.7531024826     ,
 22.6023681045     , 21.6007462954     , 20.6365878954     , 19.5545126285     ,
 18.2721608379     , 16.825810821      , 15.3183268974     , 13.8577034835     ,
 12.5234099842     , 11.3372045476     , 10.2570088596     , 9.21914824672     ,
 8.18452867969     , 7.14244219083     , 6.10399049819     , 5.12185379083     ,
 4.2936430151      , 3.70330989766     , 3.35277239744     , 3.16119805578     ,
 3.01400319554     , 2.80429718847     , 2.47163573792     , 2.03982168605     ,
 1.59901931248     , 1.23052389736     , 0.958885612534    , 0.771282883418    ,
 0.654356250895    , 0.604065774638    , 0.614557897404    , 0.665429016875    ,
 0.720554004208    , 0.745902072331    , 0.734030432696    , 0.70787393938     ,
 0.697776373287    , 0.717021742992    , 0.757402855239    , 0.800851621811    ,
 0.833779043936    , 0.856906470988    , 0.886863970921    , 0.946842728364    ,
 1.04939007589     , 1.18454591082     , 1.32752603642     , 1.46035968701     ,
 1.58473457901     , 1.7183381153      , 1.88816671904     , 2.12045626862     ,
 2.40958851545     , 2.68645013527     , 2.8487325496      , 2.8508490806      ,
 2.74650831012     , 2.62450784685     , 2.5290739194      , 2.46076932513     ,
 2.42031962513     , 2.42280872975     , 2.49000464481     , 2.65144744439     ,
 2.9419039469      , 3.38861440603     , 4.03280622034     , 5.02316500367     ,
 6.73667241253     , 9.84194348331     , 15.2841443037     , 24.2154106513     ,
 37.8315625108     , 57.0378756875     , 81.974405301      , 111.571599641     ,
 143.343388295     , 173.614101782     , 198.347094948     , 214.475991008     ,
 221.092708595     , 219.659579712     , 213.124555045     , 204.688181789     ,
 169.506954226     , 165.233024107     , 162.01841792      , 157.478788761     ,
 149.279007581     , 136.21125547      , 118.781463225     , 98.959725676      ,
 79.204641114      , 61.4512219658     , 46.7026201281     , 35.1703366845     ,
 26.5450926509     , 20.228305174      , 15.5623969979     , 12.0234594073     ,
 9.29223294544     , 7.20568624589     , 5.66112348277     , 4.54583994943     ,
 3.73241227948     , 3.11620844936     , 2.63276635742     , 2.23958374638     ,
 1.90209084715     , 1.60427806116     , 1.36038196398     , 1.19717094154     ,
 1.11239095974     , 1.0590453932      , 0.984186567519    , 0.874415263001    ,
 0.751141961589    , 0.634629238625    , 0.529587901256    , 0.439243810146    ,
 0.379887043272    , 0.381191914853    , 0.473947857758    , 0.667212971563    ,
 0.925991157292    , 1.17590138507     , 1.34323449115     , 1.39547398593     ,
 1.34621521287     , 1.23408861349     , 1.10508249797     , 1.00507589209     ,
 0.971620773519    , 1.01762516714     , 1.11623081806     , 1.21146949053     ,
 1.26139111658     , 1.27683284607     , 1.31299130047     , 1.42099010185     ,
 1.60924712843     , 1.84757441141     , 2.09749299081     , 2.33333762774     ,
 2.54673841271     , 2.75335789145     , 3.00404542168     , 3.37231055267     ,
 3.90627565466     , 4.58844245644     , 5.35675579936     , 6.17392277891     ,
 7.08088106493     , 8.2029176265      , 9.71299264584     , 11.7420882158     ,
 14.2554669052     , 16.9933785149     , 19.5565500316     , 21.5935066023     ,
 22.9726824991     , 23.8422398453     , 24.5368100437     , 25.3760825221     ,
 26.486298476      , 27.7627012673     , 28.9707145617     , 29.8825928726     ,
 30.3572187286     , 30.3546066025     , 29.9271833721     , 29.2031251435     ,
 28.3414620798     , 27.4579110974     , 26.5669719653     , 25.598595278      ,
 24.4864134384     , 23.241441714      , 21.949895403      , 20.7313331833     ,
 19.6920179746     , 18.8585294373     , 18.1326106981     , 17.3488429689     ,
 16.3938384064     , 15.2541381314     , 13.97807441       , 12.6446261706     ,
 11.3488964179     , 10.1561564095     , 9.06792224669     , 8.05857714143     ,
 7.12275333958     , 6.26265526941     , 5.46658275931     , 4.7442187489      ,
 4.16187743504     , 3.79366678188     , 3.63364438651     , 3.57856798572     ,
 3.48701762043     , 3.24500314679     , 2.81715478656     , 2.2734004371      ,
 1.74397969384     , 1.32315186431     , 1.02417946212     , 0.818723048042    ,
 0.688097079127    , 0.630822831607    , 0.641348545161    , 0.692864401862    ,
 0.740954028696    , 0.748922493051    , 0.714956198096    , 0.672421629355    ,
 0.660278156816    , 0.690995845454    , 0.741275522362    , 0.770418361564    ,
 0.754381254617    , 0.709256379078    , 0.680780500047    , 0.708523483958    ,
 0.798457400003    , 0.925129753175    , 1.05619538816     , 1.17503936073     ,
 1.28252624783     , 1.38530311316     , 1.49301096272     , 1.62211479957     ,
 1.78046959571     , 1.93977457474     , 2.04614028302     , 2.07688243023     ,
 2.07034121007     , 2.08194957712     , 2.12826824015     , 2.19034121993     ,
 2.25267520205     , 2.32328037006     , 2.43400886388     , 2.63774265758     ,
 2.99452670472     , 3.55486319784     , 4.38973283602     , 5.69533941316     ,
 7.91554640561     , 11.7946536081     , 18.3434382892     , 28.736050363      ,
 44.079569513      , 64.9738024919     , 90.9451740219     , 120.064610154     ,
 149.083564592     , 174.160565213     , 191.939391487     , 200.616420461     ,
 200.588233848     , 194.275900901     , 185.104902567     , 176.212599019     ,
 144.415395267     , 142.122047206     , 140.050661037     , 135.818776745     ,
 127.620894391     , 114.93240677      , 98.6855968837     , 80.8754630683     ,
 63.7201786709     , 48.8336539211     , 36.9002907313     , 27.8539383343     ,
 21.2119434034     , 16.3473755996     , 12.6860778119     , 9.82959963024     ,
 7.57505473056     , 5.84065481233     , 4.56477001162     , 3.65451077506     ,
 3.00249899442     , 2.52275810366     , 2.15576480181     , 1.85276438875     ,
 1.57541355823     , 1.3117863239      , 1.08233208679     , 0.919458575506    ,
 0.833012617617    , 0.796920978853    , 0.773346543868    , 0.742479397773    ,
 0.702434154018    , 0.651157426973    , 0.582932200476    , 0.502887733027    ,
 0.438480588298    , 0.434986431906    , 0.536678737237    , 0.758926133923    ,
 1.0644092012      , 1.36861746586     , 1.58193145642     , 1.65560893169     ,
 1.59642619332     , 1.45096667729     , 1.27963527876     , 1.13655275703     ,
 1.06268011806     , 1.08073356535     , 1.1792380252      , 1.30727377561     ,
 1.40871054869     , 1.47364701105     , 1.5505370693      , 1.70152830669     ,
 1.94609392624     , 2.24804185882     , 2.5514083606      , 2.82325861759     ,
 3.06932882331     , 3.32824868956     , 3.65998994108     , 4.12378110073     ,
 4.74449342592     , 5.49610436116     , 6.32755825849     , 7.21299022295     ,
 8.1895095717      , 9.36965185874     , 10.9161305933     , 12.9463101942     ,
 15.3939211353     , 17.9546864249     , 20.2049574547     , 21.8243196783     ,
 22.7652152048     , 23.261435743      , 23.6787283516     , 24.3074095961     ,
 25.2213670435     , 26.2718061721     , 27.1998567254     , 27.784924166      ,
 27.9318300337     , 27.6659392801     , 27.0848311266     , 26.3145551002     ,
 25.4745780719     , 24.6450194456     , 23.8403378597     , 23.0057851897     ,
 22.0580634746     , 20.955165884      , 19.7425884585     , 18.5459683751     ,
 17.512406531      , 16.7201198679     , 16.121627595      , 15.5837342848     ,
 14.9749105737     , 14.1988129447     , 13.191680773      , 11.9608561678     ,
 10.6145189839     , 9.29705842074     , 8.10198325653     , 7.06889460174     ,
 6.21562180373     , 5.52569530147     , 4.94347092023     , 4.43844542721     ,
 4.05915015468     , 3.87534770942     , 3.86777365761     , 3.90569936299     ,
 3.8271042736      , 3.52807746137     , 3.01313603811     , 2.39575727471     ,
 1.82709096173     , 1.39571905765     , 1.09834339996     , 0.894750386983    ,
 0.762286968218    , 0.698267114976    , 0.69442249817     , 0.72084385327     ,
 0.734266576889    , 0.70577521418     , 0.644924918206    , 0.595001480342    ,
 0.599802180985    , 0.667313931002    , 0.756655407014    , 0.802577283222    ,
 0.767509255877    , 0.677023463453    , 0.599088516655    , 0.587406361439    ,
 0.646802678666    , 0.745205392345    , 0.848076759132    , 0.940172867957    ,
 1.02045911776     , 1.08690496972     , 1.13706111954     , 1.1803664628      ,
 1.23339814349     , 1.29753736937     , 1.35647435223     , 1.40555478114     ,
 1.46944182429     , 1.57612038407     , 1.72221537847     , 1.8769727873      ,
 2.01528132468     , 2.14172564854     , 2.29530995047     , 2.54264375361     ,
 2.96217822505     , 3.63521565069     , 4.68124609369     , 6.35094064991     ,
 9.12520952527     , 13.7515522657     , 21.2022880989     , 32.5489688364     ,
 48.6794709501     , 69.8001468293     , 94.8710752945     , 121.369851588     ,
 145.753513906     , 164.536381022     , 175.420250408     , 177.959053661     ,
 173.621188639     , 165.273991411     , 156.1825609       , 148.884024752     ,
 121.917373534     , 121.405231922     , 120.143259448     , 116.057236005     ,
 107.978410615     , 95.9896217752     , 81.2805727981     , 65.6974504415     ,
 51.1115040623     , 38.817803373      , 29.2740042595     , 22.2517392188     ,
 17.1768966558     , 13.4289965271     , 10.5208522433     , 8.16707033041     ,
 6.25945415336     , 4.77749789279     , 3.69534962614     , 2.9450897044      ,
 2.43738459223     , 2.09050234863     , 1.83566864323     , 1.61431777823     ,
 1.38765768787     , 1.14959030462     , 0.925301474522    , 0.751792381597    ,
 0.651826360907    , 0.620895097683    , 0.635302946208    , 0.667115583289    ,
 0.69071210712     , 0.684463283006    , 0.637739212216    , 0.561784419635    ,
 0.493774223295    , 0.487522601339    , 0.592431686888    , 0.82596991424     ,
 1.15226999837     , 1.48734443981     , 1.73577673167     , 1.8346741316      ,
 1.77845987941     , 1.61522859357     , 1.41702055177     , 1.24583679132     ,
 1.14419460125     , 1.14001978105     , 1.23401561305     , 1.38397917549     ,
 1.52937496123     , 1.64741994406     , 1.77894340845     , 1.98959275353     ,
 2.30310515777     , 2.67434630387     , 3.02897410378     , 3.32816847706     ,
 3.5972069792      , 3.90350628366     , 4.31523719767     , 4.86855829154     ,
 5.55455381625     , 6.33187103654     , 7.15797428592     , 8.0192809219      ,
 8.95337514027     , 10.0657301727     , 11.5108005796     , 13.3935155304     ,
 15.6339753205     , 17.928730558      , 19.8780278264     , 21.1972860047     ,
 21.8677136582     , 22.1322530179     , 22.3462907721     , 22.7818965135     ,
 23.4958189572     , 24.3216323604     , 24.987088101      , 25.2825216933     ,
 25.1603647882     , 24.7149469779     , 24.0999016049     , 23.4521820068     ,
 22.8472890767     , 22.2925004447     , 21.744298312      , 21.1221665547     ,
 20.3300874867     , 19.3130389925     , 18.1173473702     , 16.8925329061     ,
 15.820197913      , 15.0176874209     , 14.4869540207     , 14.1364034916     ,
 13.8236813569     , 13.3706820055     , 12.60321927       , 11.4600089539     ,
 10.0607886432     , 8.62415471253     , 7.33148199032     , 6.27997795481     ,
 5.49640701085     , 4.93482855126     , 4.49950726168     , 4.13358836649     ,
 3.8778102841      , 3.79976446733     , 3.86995080717     , 3.94127308723     ,
 3.84715204081     , 3.50554098095     , 2.95890716319     , 2.34555878659     ,
 1.81258177037     , 1.42852564993     , 1.17432896291     , 1.00285890736     ,
 0.886595345597    , 0.816809816638    , 0.781660590812    , 0.755444747358    ,
 0.70877715471     , 0.6312808079      , 0.546099430902    , 0.499734623434    ,
 0.531074278098    , 0.638133326809    , 0.765177126576    , 0.831075976848    ,
 0.791141583261    , 0.677407587836    , 0.570127703572    , 0.530181408905    ,
 0.562573584952    , 0.633531538488    , 0.707932115154    , 0.769964864009    ,
 0.816861270519    , 0.844093092183    , 0.846427946491    , 0.831224247388    ,
 0.818528435297    , 0.824530540402    , 0.853581193246    , 0.909912076186    ,
 1.00719000625     , 1.15601080244     , 1.34429339228     , 1.54014245483     ,
 1.7185566624      , 1.88548714424     , 2.08290617108     , 2.38200507237     ,
 2.87630212892     , 3.68471220708     , 4.98001576056     , 7.0485487221      ,
 10.3547326768     , 15.5699988587     , 23.5375976605     , 35.1285338945     ,
 50.9206733198     , 70.7115723148     , 93.0687980794     , 115.292315927     ,
 134.073705318     , 146.653866007     , 151.811255563     , 150.165486376     ,
 143.833043444     , 135.697002983     , 128.474429936     , 123.835676655     ,
 102.056629752     , 102.807236172     , 102.009402259     , 98.0665482257     ,
 90.3946330567     , 79.4933469608     , 66.6101802891     , 53.3181855804     ,
 41.1150227592     , 31.0327001577     , 23.4065925294     , 17.9551997147     ,
 14.0851313416     , 11.2006237614     , 8.88207698657     , 6.92739138635     ,
 5.29722166334     , 4.01482561945     , 3.08311222292     , 2.45802192331     ,
 2.06466284697     , 1.81941427631     , 1.64301829279     , 1.47330158815     ,
 1.27861649898     , 1.06098038054     , 0.846814132729    , 0.67194289264     ,
 0.56551082104     , 0.537256601126    , 0.572628601681    , 0.63716540344     ,
 0.689506546865    , 0.698632424704    , 0.656816903906    , 0.583013443515    ,
 0.517826104082    , 0.512394137346    , 0.611340434147    , 0.831137054082    ,
 1.14315586199     , 1.47575559201     , 1.73896689823     , 1.86099865683     ,
 1.82225465093     , 1.66600117809     , 1.46879382592     , 1.29605925199     ,
 1.18900877339     , 1.17591709027     , 1.2651384608      , 1.42674753698     ,
 1.60834604688     , 1.78480681517     , 1.98734746917     , 2.2741190978      ,
 2.66626418935     , 3.11304515109     , 3.52787834755     , 3.86498834045     ,
 4.15969243599     , 4.49706105982     , 4.94844164859     , 5.53136998601     ,
 6.21384836551     , 6.94842760072     , 7.70242301979     , 8.46788160104     ,
 9.2745854812      , 10.2176106013     , 11.4456820335     , 13.0599684142     ,
 14.9887305004     , 16.9675307292     , 18.6563693505     , 19.8070179735     ,
 20.3825047815     , 20.5684205765     , 20.6662884756     , 20.9280622794     ,
 21.4229315024     , 22.0102506105     , 22.4451482566     , 22.5476955229     ,
 22.3023716617     , 21.8326102664     , 21.3115389325     , 20.8757229856     ,
 20.5682915584     , 20.3337592981     , 20.0603970292     , 19.625151349      ,
 18.92678474       , 17.9332450617     , 16.7260280921     , 15.4837913221     ,
 14.4002096789     , 13.6008135742     , 13.1129147826     , 12.8753524631     ,
 12.7421833183     , 12.4863862438     , 11.8740938164     , 10.8120679093     ,
 9.4256658948      , 7.966425053       , 6.6582119704      , 5.62782430136     ,
 4.90422268654     , 4.42300680665     , 4.06768131706     , 3.76835117892     ,
 3.55889742627     , 3.50389416004     , 3.57577475285     , 3.63498903703     ,
 3.52882396244     , 3.19569325592     , 2.69549320454     , 2.16450321204     ,
 1.72810181315     , 1.43350340389     , 1.25373191183     , 1.13915490582     ,
 1.05450365772     , 0.980908478161    , 0.904177207406    , 0.810235003919    ,
 0.692992588002    , 0.565879794686    , 0.46281088405     , 0.423972764295    ,
 0.473272742792    , 0.595933553179    , 0.730518623051    , 0.797117164976    ,
 0.756041415561    , 0.64252987195     , 0.534645906946    , 0.488575119298    ,
 0.507611006021    , 0.55980456336     , 0.611268291249    , 0.645072116105    ,
 0.658236547352    , 0.649813802252    , 0.619233723319    , 0.574600284224    ,
 0.533730546671    , 0.514311919523    , 0.527008123905    , 0.578541209688    ,
 0.676163720309    , 0.822878468185    , 1.00730452666     , 1.20585254495     ,
 1.40257999778     , 1.60731880703     , 1.8586182512      , 2.22473184125     ,
 2.81419826337     , 3.78622015505     , 5.35497521363     , 7.80280345164     ,
 11.5155063541     , 17.0227092045     , 24.981446264      , 36.0137475259     ,
 50.3667336598     , 67.5060366708     , 85.8653164981     , 102.993309873     ,
 116.224879881     , 123.66080004      , 124.907482663     , 121.168110461     ,
 114.744253009     , 108.229556039     , 103.643690792     , 101.784493466     ,
 84.9297912278     , 86.3488679123     , 85.7571643774     , 82.0528842732     ,
 75.0909803235     , 65.5762768745     , 54.6479808244     , 43.5476154245     ,
 33.4345518343     , 25.1535987163     , 18.9982278828     , 14.7071467001     ,
 11.7197764807     , 9.47999710723     , 7.61847531028     , 5.98832116713     ,
 4.59515760108     , 3.48863399728     , 2.68724212856     , 2.16037492503     ,
 1.84189195592     , 1.64918854079     , 1.50330904719     , 1.35004114477     ,
 1.1707224643      , 0.974876148268    , 0.785802739102    , 0.631556082456    ,
 0.538201362253    , 0.518788635498    , 0.56165424839     , 0.629618463302    ,
 0.677257738477    , 0.676232696056    , 0.62816735841     , 0.558313433197    ,
 0.502591605463    , 0.499103471134    , 0.580801797649    , 0.762986171416    ,
 1.0298392691      , 1.33001082539     , 1.58673354799     , 1.7255462108      ,
 1.71485400121     , 1.58843558882     , 1.41943221213     , 1.27223709893     ,
 1.18572769307     , 1.18488302714     , 1.27977384332     , 1.4529606139      ,
 1.66921820088     , 1.90890882651     , 2.18988761355     , 2.5515783216      ,
 3.00898771588     , 3.51758683959     , 3.99451166611     , 4.38772110039     ,
 4.72202137908     , 5.07369883544     , 5.50684152816     , 6.03390359644     ,
 6.62626729428     , 7.25152712116     , 7.89138666609     , 8.53272455798     ,
 9.18219096619     , 9.91619884761     , 10.8802175115     , 12.1806627245     ,
 13.7651482753     , 15.420812298      , 16.8789176887     , 17.9300219209     ,
 18.5059544244     , 18.711036683      , 18.7690940613     , 18.8972444803     ,
 19.1817459218     , 19.5398548284     , 19.8003672919     , 19.838288105      ,
 19.6485467949     , 19.3231992981     , 18.9906424397     , 18.7582235325     ,
 18.658585359      , 18.6230277664     , 18.510755115      , 18.1729207903     ,
 17.5138951462     , 16.5374628936     , 15.3606994908     , 14.1701177333     ,
 13.1407545106     , 12.380171074      , 11.9206159656     , 11.7190584776     ,
 11.636473322      , 11.4410872266     , 10.9006612661     , 9.92855658263     ,
 8.64385416185     , 7.28002675411     , 6.04918162359     , 5.07809775954     ,
 4.39922236963     , 3.95153841859     , 3.62191609796     , 3.3382071494      ,
 3.12379760907     , 3.03709701969     , 3.06428513886     , 3.09559206768     ,
 3.00446849915     , 2.73844302811     , 2.34740036924     , 1.94238117398     ,
 1.62175100404     , 1.42091936887     , 1.31649221462     , 1.26124324312     ,
 1.21173095929     , 1.1382586442      , 1.0255685659      , 0.87328871158     ,
 0.69911460902     , 0.537470078549    , 0.42709164469     , 0.394806007003    ,
 0.444669834164    , 0.550607951073    , 0.656096875979    , 0.698334300764    ,
 0.652866358467    , 0.554717428222    , 0.467150081798    , 0.431425313765    ,
 0.44698512301     , 0.486418223736    , 0.519701048663    , 0.530217752943    ,
 0.516625559931    , 0.484441555052    , 0.43995819075     , 0.391236341839    ,
 0.34898240429     , 0.324255994445    , 0.326568826699    , 0.363620591706    ,
 0.441325910012    , 0.561717865399    , 0.719341533283    , 0.904547050368    ,
 1.11557762428     , 1.36564425395     , 1.68352648626     , 2.1293159489      ,
 2.82547525985     , 3.96557125105     , 5.78194772013     , 8.51165207352     ,
 12.4160909686     , 17.8477542552     , 25.2586657217     , 35.0265635432     ,
 47.1236929249     , 60.835097358      , 74.7195807892     , 86.865076121      ,
 95.4172453784     , 99.2506033895     , 98.4617291425     , 94.3903368085     ,
 89.148179022      , 84.8486672476     , 82.8272389627     , 83.1963114138     ,
 70.6425970801     , 72.2523914033     , 71.7286804265     , 68.3725342973     ,
 62.3074585928     , 54.27393093       , 45.2099511819     , 36.0402900162     ,
 27.6644352103     , 20.8101414355     , 15.7644539346     , 12.3067911442     ,
 9.93003077095     , 8.13180801174     , 6.59296361223     , 5.21053605365     ,
 4.0193625387      , 3.07825000471     , 2.40271076107     , 1.9590226188      ,
 1.68322843458     , 1.50150610983     , 1.35020764212     , 1.19290203684     ,
 1.02398895636     , 0.85626686493     , 0.706861478246    , 0.593021739219    ,
 0.531020838256    , 0.528096949437    , 0.57070466345     , 0.623200749502    ,
 0.646208815075    , 0.622594844837    , 0.565723449857    , 0.503825340018    ,
 0.462092757341    , 0.460253302036    , 0.517633852399    , 0.649927853902    ,
 0.85656294104     , 1.10802515114     , 1.34344743912     , 1.4911025899      ,
 1.51139180891     , 1.42658364478     , 1.3015877911      , 1.19861287357     ,
 1.15555943014     , 1.19128941466     , 1.30998193445     , 1.50144777165     ,
 1.74918655995     , 2.04261149126     , 2.38441432576     , 2.78913494379     ,
 3.26598539141     , 3.79166043738     , 4.30795480866     , 4.7622661384      ,
 5.14958406559     , 5.50872645154     , 5.88376861165     , 6.2945425698      ,
 6.74089215997     , 7.22392966472     , 7.74241121769     , 8.2696348365      ,
 8.77999135317     , 9.32762957683     , 10.056193166      , 11.0785984828     ,
 12.356399673      , 13.7159241355     , 14.950953772      , 15.8975183088     ,
 16.4770165358     , 16.7325673351     , 16.8129023944     , 16.8812968291     ,
 17.0183927894     , 17.1983939747     , 17.3463424327     , 17.41218718       ,
 17.3932881738     , 17.3113549688     , 17.2001739512     , 17.1086321906     ,
 17.0713526484     , 17.0531106845     , 16.938295218      , 16.5932773533     ,
 15.9482412055     , 15.0375951737     , 13.9826583836     , 12.9362706538     ,
 12.0273236042     , 11.3367472029     , 10.8968553139     , 10.6776475515     ,
 10.5577793342     , 10.3358636563     , 9.8231269171      , 8.96023801312     ,
 7.84718705739     , 6.6631726075      , 5.57063489722     , 4.67549297622     ,
 4.01658438899     , 3.55597099416     , 3.20557268049     , 2.90202038454     ,
 2.65686991899     , 2.51822380023     , 2.48902808032     , 2.4979084628      ,
 2.44685582112     , 2.28074921742     , 2.02034368628     , 1.73992667743     ,
 1.5137083654      , 1.37595890354     , 1.31640937233     , 1.29694097549     ,
 1.27195356971     , 1.20544729523     , 1.0808915749      , 0.905421981363    ,
 0.710584871134    , 0.54239831225     , 0.439159902942    , 0.413878220755    ,
 0.453403420152    , 0.524696683324    , 0.581804552182    , 0.584688457842    ,
 0.526898173191    , 0.441810754766    , 0.374604915196    , 0.349580327378    ,
 0.362144829591    , 0.390281284798    , 0.409352372051    , 0.404765206041    ,
 0.377561424054    , 0.338685335507    , 0.298872739231    , 0.263538252941    ,
 0.234097074407    , 0.21292444941     , 0.207003711407    , 0.225985488681    ,
 0.27752216353     , 0.365215155326    , 0.490533864847    , 0.65856845741     ,
 0.882226201506    , 1.17694119932     , 1.55981935697     , 2.08088593063     ,
 2.87042136596     , 4.14005230669     , 6.11540107684     , 8.96596791038     ,
 12.8183559153     , 17.847608121      , 24.310726062      , 32.3837153729     ,
 41.8728099743     , 52.0576911817     , 61.7998626946     , 69.808082742      ,
 74.9635219116     , 76.7015506247     , 75.3302710746     , 72.0516550826     ,
 68.5758694812     , 66.4526985996     , 66.4330100695     , 68.2093963506     ,
 59.1641558422     , 60.6505157375     , 60.1104375099     , 57.1311175409     ,
 51.9678174175     , 45.2954700194     , 37.8328010224     , 30.2520862101     ,
 23.276210758      , 17.5559898046     , 13.3661919694     , 10.5113398977     ,
 8.53760392375     , 7.01036941455     , 5.67413478125     , 4.47113391064     ,
 3.45420322812     , 2.67426637378     , 2.12657573596     , 1.76166361358     ,
 1.51514963151     , 1.32938871479     , 1.16495798254     , 1.00479937907     ,
 0.851058394574    , 0.715272740751    , 0.609010262712    , 0.540888851929    ,
 0.51587727774     , 0.53080432077     , 0.56809041873     , 0.597177020365    ,
 0.590831327896    , 0.546028764718    , 0.485785011796    , 0.437419589759    ,
 0.413277806363    , 0.415013469729    , 0.449811304657    , 0.534674728803    ,
 0.682806822092    , 0.8833195245      , 1.09050535258     , 1.23936647394     ,
 1.28699211622     , 1.24501519398     , 1.16888145561     , 1.11908533295     ,
 1.13376628959     , 1.22364582614     , 1.38040258937     , 1.59272833496     ,
 1.85744549834     , 2.17336960836     , 2.53182060821     , 2.92508318912     ,
 3.35891940885     , 3.83960888152     , 4.34783921383     , 4.83909914147     ,
 5.2727996375      , 5.6366442235      , 5.94724364041     , 6.23617317529     ,
 6.5409027751      , 6.8996797004      , 7.32482238057     , 7.77352046699     ,
 8.19098680918     , 8.61205245409     , 9.17564872522     , 9.99378909203     ,
 11.0304781196     , 12.1342243083     , 13.1474377065     , 13.9576535082     ,
 14.5063813718     , 14.8133198855     , 14.9715112827     , 15.0780611542     ,
 15.1734100136     , 15.2559020969     , 15.3339313156     , 15.439605042      ,
 15.5872173175     , 15.7359688067     , 15.8203156925     , 15.817840284      ,
 15.7552834552     , 15.6370883835     , 15.4019933008     , 14.9730914935     ,
 14.3336776174     , 13.54124032       , 12.6851137969     , 11.8482369183     ,
 11.1000322947     , 10.4993238024     , 10.0811746553     , 9.82574968495     ,
 9.63464852002     , 9.35491293814     , 8.85905483321     , 8.12025807638     ,
 7.21165399396     , 6.24298733125     , 5.31065290961     , 4.48906552834     ,
 3.82348594097     , 3.30905752195     , 2.89697969063     , 2.5440905153      ,
 2.25457246783     , 2.0641572042      , 1.98697210459     , 1.98353915197     ,
 1.97798656777     , 1.90659753176     , 1.75747699422     , 1.5695746689      ,
 1.39788631925     , 1.27985861519     , 1.22198517297     , 1.20234331579     ,
 1.1840047133      , 1.13266610015     , 1.02882201125     , 0.875273306862    ,
 0.701705208126    , 0.554626850613    , 0.470243677672    , 0.453798102599    ,
 0.482939886312    , 0.52247413856     , 0.536334571022    , 0.502244354438    ,
 0.426978839604    , 0.342583181263    , 0.281745865823    , 0.257682756896    ,
 0.26360509191     , 0.281605775584    , 0.291552522507    , 0.28127780933     ,
 0.253688189243    , 0.222292122378    , 0.198621252258    , 0.183671780326    ,
 0.17046609133     , 0.154769089774    , 0.142680441       , 0.146737013835    ,
 0.176583857955    , 0.236348968531    , 0.331624868173    , 0.47826165773     ,
 0.700647612245    , 1.0171075943      , 1.43804804191     , 2.00586102966     ,
 2.84854704513     , 4.17334620266     , 6.18052236467     , 8.97520135896     ,
 12.5730136053     , 16.9979794044     , 22.3383362239     , 28.6262984679     ,
 35.6200796872     , 42.7342650426     , 49.1945816354     , 54.2386150108     ,
 57.2674463436     , 58.0458076005     , 56.9302149467     , 54.8944311115     ,
 53.2026351352     , 52.8602384015     , 54.1628021655     , 56.6087373045     ,
 50.2275203735     , 51.3962599256     , 50.7316314237     , 48.0277557543     ,
 43.600897508      , 38.0308761513     , 31.8521208425     , 25.5558748838     ,
 19.7345076572     , 14.9573496153     , 11.4598168897     , 9.05547291885     ,
 7.347161069       , 5.98203700914     , 4.77869927353     , 3.72129363104     ,
 2.86639425535     , 2.24273603765     , 1.81817039719     , 1.5281534121      ,
 1.31300776436     , 1.1347468734      , 0.974952596117    , 0.827174019758    ,
 0.693659969664    , 0.583784378435    , 0.508786311865    , 0.474608846216    ,
 0.477300533164    , 0.502662496846    , 0.529071371816    , 0.533466907466    ,
 0.503034630004    , 0.447159208144    , 0.393308529305    , 0.364204937013    ,
 0.360572829308    , 0.370097987742    , 0.390563934171    , 0.439431305589    ,
 0.539580285683    , 0.693986484353    , 0.87062717906     , 1.01458450916     ,
 1.08455652815     , 1.0837956069      , 1.05725187345     , 1.06172330281     ,
 1.13498875253     , 1.28055590899     , 1.47666738723     , 1.70432480921     ,
 1.96442397829     , 2.26260216604     , 2.58690005027     , 2.91785813643     ,
 3.26045293666     , 3.64621564846     , 4.0926127146      , 4.56898368872     ,
 5.01057709575     , 5.36474660761     , 5.62516103628     , 5.83183034564     ,
 6.05035412657     , 6.34347485387     , 6.72833361167     , 7.14927854563     ,
 7.53338737552     , 7.89890281959     , 8.36900067139     , 9.04321499101     ,
 9.88568381164     , 10.7666283439     , 11.5713217303     , 12.2365660357     ,
 12.7372511611     , 13.0954517267     , 13.371415409      , 13.6005912669     ,
 13.7611635028     , 13.8331002108     , 13.868434426      , 13.969757872      ,
 14.191104888      , 14.4722051008     , 14.6876089685     , 14.7560649651     ,
 14.6750742567     , 14.456432947      , 14.0831968923     , 13.5522436086     ,
 12.9170780375     , 12.2545073331     , 11.6064014214     , 10.9793570164     ,
 10.3905842636     , 9.8848811728      , 9.49826374865     , 9.21356660732     ,
 8.95260121023     , 8.61450901609     , 8.1363081893      , 7.52296816093     ,
 6.81885487869     , 6.06334133616     , 5.28584564818     , 4.52732267199     ,
 3.83728966406     , 3.243798855       , 2.74142768313     , 2.31564502253     ,
 1.97199120226     , 1.73597330039     , 1.62429460822     , 1.61447104814     ,
 1.64210148601     , 1.63507617986     , 1.55760500373     , 1.42308445872     ,
 1.27147919325     , 1.14131275482     , 1.05363505083     , 1.00671933845     ,
 0.981259882219    , 0.95098534873     , 0.891079870278    , 0.789477948806    ,
 0.661490697326    , 0.547132688815    , 0.482472003461    , 0.473060125963    ,
 0.495626591254    , 0.516521057356    , 0.506451210841    , 0.452222189985    ,
 0.365615875242    , 0.27664464118     , 0.212669076721    , 0.183752582817    ,
 0.183453252941    , 0.195782260937    , 0.202499968667    , 0.192879697204    ,
 0.170972110743    , 0.15103878619     , 0.143631326       , 0.145677597671    ,
 0.1445613321      , 0.132764766725    , 0.117463925621    , 0.114130409999    ,
 0.13295890051     , 0.175662947745    , 0.246760542582    , 0.365755472129    ,
 0.563248557796    , 0.862472080464    , 1.27638706178     , 1.84604290772     ,
 2.68883530693     , 3.98796665309     , 5.90786089796     , 8.50580805748     ,
 11.7252226493     , 15.4799431052     , 19.727380206      , 24.4126622434     ,
 29.3314703923     , 34.099193556      , 38.2696801123     , 41.4438362922     ,
 43.3191006057     , 43.8167138856     , 43.2743490041     , 42.4558845389     ,
 42.2420954255     , 43.1877548485     , 45.2589260974     , 47.8890252573     ,
 43.2994726463     , 44.0456893001     , 43.1361599164     , 40.5326737029     ,
 36.5997202809     , 31.8467171877     , 26.6826305227     , 21.4677894944     ,
 16.6635614593     , 12.7209836408     , 9.81025848105     , 7.75800521988     ,
 6.24069205248     , 4.99704335811     , 3.91490098863     , 3.00403061273     ,
 2.30786674683     , 1.82622330104     , 1.50534462234     , 1.27811420527     ,
 1.09922937113     , 0.949219360144    , 0.818751761524    , 0.698194111865    ,
 0.583572279326    , 0.484916753443    , 0.420220885482    , 0.399025904733    ,
 0.41223078807     , 0.436590303145    , 0.447690455163    , 0.430669730397    ,
 0.385956391918    , 0.330905936001    , 0.291549130824    , 0.283504463683    ,
 0.299266061973    , 0.318620899671    , 0.333187242316    , 0.358863632892    ,
 0.422846734812    , 0.537240163945    , 0.682840944778    , 0.81817142172     ,
 0.908087791089    , 0.949001767229    , 0.972102142054    , 1.02516607194     ,
 1.14396736893     , 1.32969367015     , 1.55342069711     , 1.78727423407     ,
 2.02706335729     , 2.27933007303     , 2.53571395871     , 2.77844352631     ,
 3.01523827716     , 3.28978720019     , 3.63917782928     , 4.04496150606     ,
 4.43840865013     , 4.7545470716      , 4.9793606597      , 5.1553355781      ,
 5.35613044494     , 5.64832815561     , 6.04561129299     , 6.48832010786     ,
 6.89875783225     , 7.27635667468     , 7.70985361053     , 8.27353244938     ,
 8.94021289822     , 9.61917500601     , 10.2429770421     , 10.786865648      ,
 11.2487708475     , 11.6562844106     , 12.0547212722     , 12.4400536863     ,
 12.7332629914     , 12.8682945671     , 12.8942477953     , 12.9532413321     ,
 13.1467653434     , 13.4385095783     , 13.6982579245     , 13.8192134285     ,
 13.7621845589     , 13.5129161688     , 13.0690120049     , 12.4847728637     ,
 11.8717744639     , 11.3178690313     , 10.8251784001     , 10.3486524063     ,
 9.87755260163     , 9.45112186955     , 9.10059867565     , 8.80184722979     ,
 8.48910078081     , 8.10699631828     , 7.65015674822     , 7.15025939615     ,
 6.62428990536     , 6.05051790327     , 5.40315783001     , 4.69584547923     ,
 3.97937849989     , 3.30634461193     , 2.70849631658     , 2.20175839171     ,
 1.80139184039     , 1.52787796471     , 1.39395019741     , 1.3796161545      ,
 1.42264883325     , 1.44634320773     , 1.40357380116     , 1.29350858395     ,
 1.14452702348     , 0.992515562317    , 0.868257943237    , 0.788982932962    ,
 0.754363037588    , 0.746529298497    , 0.73333376966     , 0.684580106125    ,
 0.598605427114    , 0.508743220072    , 0.453904975723    , 0.44491456187     ,
 0.462074266773    , 0.475298197681    , 0.460341323935    , 0.407354275641    ,
 0.32628709102     , 0.242343349677    , 0.180453511996    , 0.152046367799    ,
 0.152613202765    , 0.166290033178    , 0.1741681479      , 0.165729468319    ,
 0.146110266533    , 0.130470776329    , 0.129052715731    , 0.136971707026    ,
 0.139475051847    , 0.128603509316    , 0.113342212759    , 0.111083561684    ,
 0.130959942401    , 0.1699051354      , 0.226632402136    , 0.317060662586    ,
 0.472094876126    , 0.720590998609    , 1.08565770501     , 1.61388549583     ,
 2.4098056412      , 3.62283959428     , 5.37734657656     , 7.69729876987     ,
 10.4890995263     , 13.602346337      , 16.909704868      , 20.3127392119     ,
 23.6775836754     , 26.8115743667     , 29.5125518629     , 31.5980490263     ,
 32.9147001051     , 33.449617553      , 33.5016645328     , 33.6647030041     ,
 34.5257098859     , 36.310845952      , 38.7701055179     , 41.3279632796     ,
 37.6794633847     , 37.9903735998     , 36.7827722951     , 34.1557653779     ,
 30.5286808613     , 26.3815918271     , 22.0517175265     , 17.7955484522     ,
 13.9260128589     , 10.7427045857     , 8.34116183892     , 6.5781966004      ,
 5.2212523104      , 4.09943842323     , 3.15252003175     , 2.39574209408     ,
 1.84862116223     , 1.48471227553     , 1.24026509819     , 1.05801484113     ,
 0.913042835182    , 0.800705662663    , 0.710604561656    , 0.621065546676    ,
 0.51942444424     , 0.418819544565    , 0.347325265748    , 0.320993105805    ,
 0.329195568566    , 0.343787717294    , 0.339857223228    , 0.309348504936    ,
 0.261396118576    , 0.215687894198    , 0.192642259346    , 0.200627541309    ,
 0.228540600766    , 0.254858167737    , 0.268666649294    , 0.28224510654     ,
 0.321366472781    , 0.402459565011    , 0.518239043354    , 0.643170669422    ,
 0.751489724083    , 0.833674720437    , 0.904135820254    , 0.996528604383    ,
 1.14257596892     , 1.34590769525     , 1.57901889263     , 1.80932968967     ,
 2.02301317864     , 2.22069635549     , 2.39930514805     , 2.55309855928     ,
 2.69744673979     , 2.87610268372     , 3.12500862365     , 3.43011077139     ,
 3.73445985643     , 3.98785703367     , 4.18543002135     , 4.36783476864     ,
 4.59735271817     , 4.92572974923     , 5.359830008       , 5.84924191898     ,
 6.3256073848      , 6.76681748634     , 7.20931132896     , 7.6895071971      ,
 8.19568356049     , 8.6929804413      , 9.16786114597     , 9.62348553946     ,
 10.0633419225     , 10.5103999256     , 11.002778859      , 11.5230234718     ,
 11.960355749      , 12.2010088457     , 12.2585133733     , 12.2761258677     ,
 12.3875303177     , 12.5983555856     , 12.8125916538     , 12.9343047914     ,
 12.9052804809     , 12.6829890496     , 12.2603166535     , 11.7137555467     ,
 11.1730136121     , 10.7166123695     , 10.3204565075     , 9.9214530504      ,
 9.50825451551     , 9.1248924348      , 8.798875185       , 8.49786913316     ,
 8.16200809222     , 7.76543641593     , 7.33913794455     , 6.92717877748     ,
 6.52343387157     , 6.06782527246     , 5.50595597082     , 4.83765084773     ,
 4.11036952071     , 3.38577086479     , 2.7176316165      , 2.14611581446     ,
 1.70006358678     , 1.40052294029     , 1.25425478083     , 1.23559750249     ,
 1.28013598266     , 1.31124014164     , 1.27992333095     , 1.17893509854     ,
 1.02834631636     , 0.860426970493    , 0.71198967733     , 0.613966066448    ,
 0.578713319554    , 0.591340724672    , 0.611324465777    , 0.59481654786     ,
 0.529757670291    , 0.447130344573    , 0.389945541662    , 0.374464540427    ,
 0.38495580557     , 0.395364897543    , 0.386448946994    , 0.350439610461    ,
 0.292909601319    , 0.231686611047    , 0.187810817483    , 0.173383741573    ,
 0.185017505297    , 0.205877218066    , 0.21562294193     , 0.204044763863    ,
 0.1779772852      , 0.154125058424    , 0.143785016972    , 0.143275378404    ,
 0.139437667353    , 0.125918212162    , 0.11281724863     , 0.117666515081    ,
 0.147888830324    , 0.195748380856    , 0.252244039753    , 0.324614921491    ,
 0.438611117712    , 0.626624801374    , 0.923666884045    , 1.38492759771     ,
 2.10400638953     , 3.19684563443     , 4.74900243995     , 6.76093876866     ,
 9.12930408745     , 11.6821854269     , 14.2484015028     , 16.7058826452     ,
 18.9797800772     , 21.0213722312     , 22.7920247234     , 24.2375988762     ,
 25.2889736924     , 25.9657742948     , 26.5170975759     , 27.3858832416     ,
 28.9366518083     , 31.1816821109     , 33.7568514686     , 36.1100563103     ,
 32.7483225661     , 32.6955823941     , 31.2457125234     , 28.5957611019     ,
 25.2130987808     , 21.5714987134     , 17.9671768463     , 14.5686978419     ,
 11.5400646665     , 9.02896003131     , 7.06683343972     , 5.55385081621     ,
 4.34879190873     , 3.35594174117     , 2.54759698945     , 1.93363969352     ,
 1.51147029045     , 1.23782104191     , 1.04761143544     , 0.89600929688     ,
 0.775605390113    , 0.692700154932    , 0.634718483746    , 0.569665469684    ,
 0.477571768512    , 0.372998835089    , 0.290419933356    , 0.250797312533    ,
 0.245128288228    , 0.246190865957    , 0.231760162213    , 0.197909450461    ,
 0.15610279345     , 0.123125512376    , 0.112410234025    , 0.127298780605    ,
 0.157767701145    , 0.186476801822    , 0.203243445425    , 0.215122221282    ,
 0.241141836932    , 0.297194888117    , 0.386075712994    , 0.498652207775    ,
 0.62006169281     , 0.737037675881    , 0.848762649352    , 0.973767535148    ,
 1.1367574274      , 1.34258723411     , 1.56862492948     , 1.78363258647     ,
 1.96703814245     , 2.11125187481     , 2.21655124434     , 2.2926591783      ,
 2.36621202515     , 2.47567185041     , 2.64322707443     , 2.85172776102     ,
 3.06121573434     , 3.24903844492     , 3.42873299296     , 3.63711301025     ,
 3.91276129184     , 4.28046690182     , 4.73996969224     , 5.26216917632     ,
 5.80170350667     , 6.32014317944     , 6.7976900128      , 7.22582432892     ,
 7.60363640892     , 7.95072090579     , 8.30659892592     , 8.69938859983     ,
 9.13120055597     , 9.61010960225     , 10.1621726047     , 10.7693873148     ,
 11.3170982038     , 11.663743593      , 11.7798090822     , 11.7816972318     ,
 11.8110163535     , 11.9096048765     , 12.0249730473     , 12.0895919214     ,
 12.0510322426     , 11.8633462693     , 11.5195792894     , 11.0914204337     ,
 10.6848894947     , 10.343937625      , 10.0222461389     , 9.65776990059     ,
 9.2545621122      , 8.87188700641     , 8.54559425109     , 8.24769761884     ,
 7.92413510156     , 7.55610449283     , 7.17520370208     , 6.81399897283     ,
 6.45134355053     , 6.02416000462     , 5.48673678936     , 4.84236645688     ,
 4.12929549963     , 3.39935512028     , 2.70827139176     , 2.10800730196     ,
 1.63928073832     , 1.32774466945     , 1.1762337998      , 1.15227908736     ,
 1.18969840946     , 1.21576970541     , 1.18389044584     , 1.08341642276     ,
 0.929220392835    , 0.752702661179    , 0.595926562379    , 0.497343023157    ,
 0.472489941747    , 0.502168530447    , 0.537855434266    , 0.530165040399    ,
 0.466096515735    , 0.37846331774     , 0.312926084608    , 0.288391098946    ,
 0.291689929625    , 0.30036745712     , 0.300263907807    , 0.286822688832    ,
 0.262899571212    , 0.239049547179    , 0.229605370099    , 0.242808890251    ,
 0.272989982854    , 0.302006373937    , 0.310316509328    , 0.290487332455    ,
 0.251672638005    , 0.211095278874    , 0.180795979938    , 0.160377949973    ,
 0.14149678091     , 0.121014287951    , 0.109282039613    , 0.122742108953    ,
 0.167975884918    , 0.234975353807    , 0.307691115154    , 0.381931763477    ,
 0.474048190231    , 0.616282518001    , 0.852221490556    , 1.24334866462     ,
 1.87377411094     , 2.83140986794     , 4.16988387163     , 5.87654510272     ,
 7.85924415924     , 9.95446695228     , 11.9698032534     , 13.7585825424     ,
 15.277796967      , 16.5772233869     , 17.7302586304     , 18.7678711737     ,
 19.6782707031     , 20.4967301713     , 21.4095995565     , 22.7168121311     ,
 24.616007696      , 27.0014609772     , 29.4806098174     , 31.5530075734     ,
 28.1925056925     , 27.8833668777     , 26.3066331505     , 23.7181132715     ,
 20.6096425214     , 17.4457506119     , 14.4891766813     , 11.8336676659     ,
 9.51835346179     , 7.57086132818     , 5.98194471325     , 4.69667346894     ,
 3.64642145247     , 2.7855018247      , 2.10260185749     , 1.60194309555     ,
 1.27004310793     , 1.05939755687     , 0.908636297487    , 0.780396321729    ,
 0.675619100369    , 0.607605637721    , 0.566671337254    , 0.518883469977    ,
 0.43988414761     , 0.340440910213    , 0.253412923715    , 0.200955639189    ,
 0.178514131573    , 0.165531582036    , 0.14541363676     , 0.115783484391    ,
 0.0850382185367   , 0.0638597473942   , 0.0596430310666   , 0.0739015951838   ,
 0.101109569236    , 0.13123153099     , 0.156598549567    , 0.177624698926    ,
 0.202297226814    , 0.241760609697    , 0.306571836986    , 0.402909827281    ,
 0.52724162027     , 0.666349041273    , 0.810181803801    , 0.965191562984    ,
 1.14577981484     , 1.35122453974     , 1.56018802788     , 1.74658962227     ,
 1.89113311125     , 1.98276815932     , 2.02367774534     , 2.03560264736     ,
 2.05514776928     , 2.11556960155     , 2.22473969665     , 2.36092287216     ,
 2.49892907249     , 2.64151739258     , 2.81971902751     , 3.06510791435     ,
 3.38804522636     , 3.78087223098     , 4.23444006467     , 4.74425876928     ,
 5.29658408509     , 5.85193044205     , 6.35151757119     , 6.74848903647     ,
 7.04134719353     , 7.28372845957     , 7.55521594113     , 7.90913608631     ,
 8.34992040082     , 8.86563652813     , 9.45827142263     , 10.1069544273     ,
 10.7117992329     , 11.1310703072     , 11.3051419939     , 11.3159035419     ,
 11.2992925637     , 11.3222908288     , 11.3624021498     , 11.3683331944     ,
 11.2987285062     , 11.1281341399     , 10.86942825       , 10.5863847198     ,
 10.3429747066     , 10.1340441486     , 9.8878244713      , 9.54591271699     ,
 9.1303963652      , 8.72013624611     , 8.3708239714      , 8.07520479478     ,
 7.79119593023     , 7.48861615771     , 7.16421414918     , 6.8156382572      ,
 6.41665532758     , 5.93519288933     , 5.36572108403     , 4.72795938047     ,
 4.04683719068     , 3.350845277       , 2.6813667252      , 2.08928594556     ,
 1.62199646325     , 1.31098557884     , 1.15811576045     , 1.12646252531     ,
 1.15059780614     , 1.16410932957     , 1.12347235848     , 1.01482189276     ,
 0.850591403829    , 0.665779682769    , 0.508761070308    , 0.420411439445    ,
 0.411414982324    , 0.453386896249    , 0.491908868613    , 0.47944667037     ,
 0.408632161693    , 0.315109984488    , 0.243761159936    , 0.212804851571    ,
 0.210421475875    , 0.217243064911    , 0.223700480339    , 0.22968969722     ,
 0.238834855671    , 0.257004727004    , 0.290029823427    , 0.336921502096    ,
 0.385631862796    , 0.417845054757    , 0.420001037078    , 0.391556364684    ,
 0.343418402664    , 0.289440664066    , 0.239259967713    , 0.195592934485    ,
 0.156696824719    , 0.12430050843     , 0.109740186253    , 0.129085140619    ,
 0.189928556571    , 0.282534413048    , 0.385027797232    , 0.480697571465    ,
 0.574275566183    , 0.695073205398    , 0.890776551205    , 1.22414710763     ,
 1.76894877496     , 2.59088261936     , 3.72141355718     , 5.14541981071     ,
 6.79351594404     , 8.52268323215     , 10.1278168724     , 11.4364979312     ,
 12.4227175615     , 13.2081266976     , 13.9464450303     , 14.7224133136     ,
 15.5531479427     , 16.4677045954     , 17.5826278578     , 19.0758452282     ,
 21.0353849821     , 23.3151907792     , 25.5533735697     , 27.3138246877     ,
 24.0017590562     , 23.5076990839     , 21.8901783624     , 19.4417430265     ,
 16.6511853731     , 13.9540504349     , 11.5721700066     , 9.53564010445     ,
 7.79396540652     , 6.29881073672     , 5.02499657239     , 3.95613507638     ,
 3.07065090009     , 2.34722846276     , 1.77751018206     , 1.3614662419      ,
 1.08586866864     , 0.911245410489    , 0.785827553875    , 0.676392474762    ,
 0.583906544008    , 0.523934819812    , 0.493019909139    , 0.462135781493    ,
 0.40471515879     , 0.322770794977    , 0.240662633824    , 0.179109457622    ,
 0.140441595184    , 0.114475041511    , 0.0915019254356   , 0.0688209982736   ,
 0.0490586640959   , 0.0361910507713   , 0.033672192544    , 0.0439561430498   ,
 0.0676538700795   , 0.102676371558    , 0.143918226228    , 0.183920506729    ,
 0.216925246298    , 0.246552239339    , 0.28921823627     , 0.364963758164    ,
 0.481348736798    , 0.628245041383    , 0.791876946139    , 0.970267020874    ,
 1.16640115566     , 1.36934708245     , 1.5548244151      , 1.7025322691      ,
 1.8011450723      , 1.8433167466      , 1.83301760548     , 1.79671233653     ,
 1.77519639473     , 1.79892841281     , 1.86914649792     , 1.96362813084     ,
 2.06691626213     , 2.19628459884     , 2.39160359332     , 2.67713930906     ,
 3.03768959297     , 3.43580652593     , 3.85118482683     , 4.29676012496     ,
 4.78910392832     , 5.30518727298     , 5.77872873485     , 6.14576666705     ,
 6.39722206937     , 6.59402505679     , 6.83242309323     , 7.18318848219     ,
 7.6551860551      , 8.21693907574     , 8.84089115912     , 9.49883514316     ,
 10.1130604268     , 10.5611111284     , 10.7723250083     , 10.8047153683     ,
 10.7926867739     , 10.8230876272     , 10.8812620957     , 10.9011647828     ,
 10.8348456105     , 10.6824298807     , 10.4919512831     , 10.3301145443     ,
 10.2231941128     , 10.1198125306     , 9.92733621197     , 9.59588800357     ,
 9.16547694224     , 8.72705894424     , 8.34875360426     , 8.04613482116     ,
 7.79651468196     , 7.55661529925     , 7.27541421222     , 6.90820054551     ,
 6.43301726611     , 5.86429221325     , 5.24314328395     , 4.60366393133     ,
 3.95563354869     , 3.30411568885     , 2.67351901397     , 2.10772322365     ,
 1.65530996568     , 1.35146131969     , 1.19796504794     , 1.15550347372     ,
 1.16113873732     , 1.15552684787     , 1.09819560947     , 0.97258623117     ,
 0.791066527585    , 0.595104345451    , 0.439380314383    , 0.363436381303    ,
 0.368915562505    , 0.417450711362    , 0.451939792276    , 0.431281531435    ,
 0.356090147958    , 0.263317222986    , 0.193419409136    , 0.161236730686    ,
 0.15552152034     , 0.159647479906    , 0.167878626608    , 0.184935013427    ,
 0.217957016656    , 0.271194272033    , 0.341974341879    , 0.417038400903    ,
 0.476158281418    , 0.503875106818    , 0.498486195391    , 0.469341931482    ,
 0.426452017455    , 0.374647728478    , 0.316471641214    , 0.255527967613    ,
 0.196636425567    , 0.148117895464    , 0.125007279865    , 0.145385673401    ,
 0.219190444155    , 0.337661457652    , 0.473773879411    , 0.59905900649     ,
 0.707244923281    , 0.824282263176    , 0.999259256761    , 1.29201329829     ,
 1.76402373843     , 2.46250587978     , 3.40458601836     , 4.57824347853     ,
 5.93638416531     , 7.35630972848     , 8.63026825641     , 9.57602358833     ,
 10.1877131192     , 10.6399051488     , 11.1345913069     , 11.7750643915     ,
 12.5735768973     , 13.531513694      , 14.7011622436     , 16.1751413914     ,
 17.989468359      , 20.0137505062     , 21.9433352604     , 23.3943428485     ,
 20.2817432939     , 19.5983553594     , 17.9522921969     , 15.6717599969     ,
 13.219130986      , 10.972757327      , 9.09735322534     , 7.56719926232     ,
 6.27570893855     , 5.13783504181     , 4.13056006111     , 3.2673971251      ,
 2.55375551929     , 1.97539088592     , 1.51679689718     , 1.17128152054     ,
 0.930293289893    , 0.770309399657    , 0.655920755567    , 0.560038236499    ,
 0.480573372586    , 0.430910237256    , 0.412341039921    , 0.402486588754    ,
 0.373825013507    , 0.317840875093    , 0.247471239774    , 0.181169005797    ,
 0.129444234837    , 0.093381273922    , 0.0694654679819   , 0.0534519508456   ,
 0.0418596838915   , 0.0330908260787   , 0.028797246112    , 0.0340888344887   ,
 0.055801961       , 0.0986886721177   , 0.159404006268    , 0.222725075745    ,
 0.269338590634    , 0.294591651108    , 0.318834520899    , 0.373507101454    ,
 0.475681892703    , 0.618654747129    , 0.786400047113    , 0.970070915255    ,
 1.16371115712     , 1.34983751705     , 1.50344784641     , 1.60974985927     ,
 1.66597630018     , 1.6708487689      , 1.62892800081     , 1.56433203613     ,
 1.51647603031     , 1.51666490424     , 1.56920252985     , 1.65641888636     ,
 1.76635689692     , 1.91633893478     , 2.14161546152     , 2.45560129073     ,
 2.82650192041     , 3.20073988844     , 3.55100314918     , 3.8971447514      ,
 4.27525337581     , 4.68759666787     , 5.08892928953     , 5.42376125019     ,
 5.67742543036     , 5.89770820163     , 6.17058630838     , 6.56465221803     ,
 7.08703322666     , 7.69312829384     , 8.33574863765     , 8.98207737845     ,
 9.57353342183     , 10.0105161337     , 10.2278262375     , 10.2811920079     ,
 10.316495493      , 10.4359947573     , 10.6125294867     , 10.7401058118     ,
 10.7456184979     , 10.646321587      , 10.5240366813     , 10.4510789813     ,
 10.4226376953     , 10.3544240887     , 10.1550342425     , 9.80651742555     ,
 9.37362230167     , 8.93940842165     , 8.55113085947     , 8.22621059242     ,
 7.96405904111     , 7.72534883285     , 7.43058806623     , 7.01050376854     ,
 6.45841434101     , 5.82890347495     , 5.18649300733     , 4.55780175276     ,
 3.93385268976     , 3.3085359795      , 2.70256946517     , 2.15707079143     ,
 1.71823227733     , 1.42042240079     , 1.26419371563     , 1.20854356634     ,
 1.19255178269     , 1.16297598129     , 1.08371003504     , 0.938651776276    ,
 0.741699409782    , 0.539144833145    , 0.388627756051    , 0.325926382572    ,
 0.343633609287    , 0.395295929638    , 0.423259285714    , 0.394144725088    ,
 0.31685421899     , 0.229002073663    , 0.165203541945    , 0.135365905324    ,
 0.127715381917    , 0.127552587509    , 0.132020073275    , 0.150103005132    ,
 0.193312461039    , 0.266240770355    , 0.359364372829    , 0.448280983986    ,
 0.506652825337    , 0.525393394682    , 0.517310030527    , 0.50080067311     ,
 0.481222898676    , 0.450429833681    , 0.400774548592    , 0.33399885499     ,
 0.259794798101    , 0.194016942233    , 0.158385558823    , 0.175138619017    ,
 0.256193049828    , 0.392606479028    , 0.553109404947    , 0.700843181741    ,
 0.821987808328    , 0.940403521356    , 1.10539541306     , 1.37138096214     ,
 1.7858282274      , 2.37901941701     , 3.15776638209     , 4.11315263286     ,
 5.21338470157     , 6.35417241821     , 7.34279495947     , 8.01374914011     ,
 8.38680470377     , 8.66429837485     , 9.06081188229     , 9.66934777786     ,
 10.4767149425     , 11.4481099956     , 12.5842549366     , 13.9251931261     ,
 15.4941554734     , 17.204179614      , 18.8082746361     , 19.9500225988     ,
 17.0946827939     , 16.1680568735     , 14.4564115953     , 12.3327304277     ,
 10.216547576      , 8.40059606277     , 6.97344356179     , 5.85874367575     ,
 4.92115287298     , 4.06738491574     , 3.28544186357     , 2.60929460131     ,
 2.0595475588      , 1.62296919491     , 1.27372593447     , 0.995765726628    ,
 0.783951049239    , 0.631427545395    , 0.521398968383    , 0.43556323821     ,
 0.369676369622    , 0.33293518235     , 0.328429070131    , 0.339574830565    ,
 0.339549132058    , 0.311225303494    , 0.256707787756    , 0.191712965143    ,
 0.133733087104    , 0.0931565136736   , 0.0708468870615   , 0.0606936891595   ,
 0.0543102734197   , 0.0462335779498   , 0.037696639319    , 0.0368293677247   ,
 0.055431679813    , 0.10292937761     , 0.177159501846    , 0.257984185341    ,
 0.317010924963    , 0.343048192295    , 0.357282239562    , 0.397191618704    ,
 0.485587892397    , 0.617835855779    , 0.775081155212    , 0.941884531397    ,
 1.10739993169     , 1.25599219575     , 1.36911326563     , 1.43789481101     ,
 1.46393099759     , 1.44857433577     , 1.39448307709     , 1.3199580715      ,
 1.26144594869     , 1.25516914191     , 1.31542485737     , 1.4316100379      ,
 1.58897441237     , 1.79101555922     , 2.05330281023     , 2.37252790376     ,
 2.71107992756     , 3.02071839051     , 3.28145476611     , 3.51598722315     ,
 3.76649961809     , 4.05660036111     , 4.37421372769     , 4.68923413825     ,
 4.98798118848     , 5.29567490422     , 5.66701555317     , 6.14648716555     ,
 6.73016315799     , 7.3701655618      , 8.01724250045     , 8.63890165124     ,
 9.18502711258     , 9.57329641237     , 9.75926728627     , 9.81961170074     ,
 9.9184576673      , 10.1610350465     , 10.4952151706     , 10.7742282208     ,
 10.9013694317     , 10.9025514966     , 10.8764299486     , 10.885867158      ,
 10.8906402675     , 10.7868192202     , 10.5165376962     , 10.1299070056     ,
 9.72884477524     , 9.36366506265     , 9.01489328977     , 8.6656284834      ,
 8.33050012324     , 7.99642550578     , 7.59446847957     , 7.06848398485     ,
 6.44359293313     , 5.79921787607     , 5.1866552689      , 4.59320231642     ,
 3.98343974285     , 3.35450648128     , 2.74316103479     , 2.19821309439     ,
 1.76257756742     , 1.46526618364     , 1.30390387311     , 1.23560512159     ,
 1.19917403173     , 1.14557423695     , 1.04623636241     , 0.890877815092    ,
 0.694762154239    , 0.502280223587    , 0.367760692808    , 0.322775073083    ,
 0.354430061614    , 0.41066461292     , 0.432430657777    , 0.392136662219    ,
 0.307188465824    , 0.218501238089    , 0.157292569933    , 0.128708829443    ,
 0.118842490685    , 0.113090237981    , 0.109948496454    , 0.121256788003    ,
 0.161998085138    , 0.23771119447     , 0.334884814096    , 0.422763338953    ,
 0.473451437853    , 0.485456972384    , 0.483007998209    , 0.489044488526    ,
 0.502356509023    , 0.502934796964    , 0.473699136401    , 0.41256429592     ,
 0.3311537641      , 0.251922105788    , 0.204326929858    , 0.215047029229    ,
 0.296092608005    , 0.436632738555    , 0.6031468549      , 0.756085335959    ,
 0.879387889427    , 0.996298748403    , 1.15464392429     , 1.40115584773     ,
 1.76827188489     , 2.27075688712     , 2.90792327778     , 3.67322076285     ,
 4.5447832496      , 5.43783977412     , 6.19157205888     , 6.67523962913     ,
 6.92823259791     , 7.151308613       , 7.54510628578     , 8.18384505345     ,
 9.03106451385     , 10.0205082336     , 11.1098845441     , 12.2991108371     ,
 13.6095462874     , 15.0006569441     , 16.2740521797     , 17.0843880038     ,
 14.4264940747     , 13.2234174359     , 11.4179840081     , 9.43182703702     ,
 7.63426561826     , 6.21621876619     , 5.17920781449     , 4.40313381178     ,
 3.74485566613     , 3.11990999046     , 2.52737959297     , 2.01075758436     ,
 1.59880856965     , 1.28129848427     , 1.02723574807     , 0.813477727131    ,
 0.635897051895    , 0.498664399312    , 0.398435164189    , 0.324229574994    ,
 0.271038838368    , 0.244593766323    , 0.248613703619    , 0.271823046394    ,
 0.290810079701    , 0.284616119628    , 0.247666680449    , 0.192021115492    ,
 0.13792204532     , 0.100466137582    , 0.0827386308859   , 0.0777278567895   ,
 0.0745819763757   , 0.0657655789855   , 0.0523519390565   , 0.0442877270991   ,
 0.0558741306797   , 0.0985594061139   , 0.171384887496    , 0.254403456713    ,
 0.317980308514    , 0.348262448806    , 0.363359585823    , 0.398881170553    ,
 0.478066288524    , 0.597777883139    , 0.738054546414    , 0.878614265004    ,
 1.00590114352     , 1.10975618988     , 1.18153528619     , 1.21838598478     ,
 1.22308304522     , 1.19679740288     , 1.13987397099     , 1.06561029754     ,
 1.00859200807     , 1.01168315218     , 1.1008232087      , 1.27218754844     ,
 1.50450889031     , 1.77949211307     , 2.08238331222     , 2.38670536818     ,
 2.65521364688     , 2.86325941492     , 3.01599652916     , 3.14364753353     ,
 3.28577844938     , 3.47588643094     , 3.73043029471     , 4.04753209583     ,
 4.41892641849     , 4.84708439752     , 5.34851461893     , 5.93402962388     ,
 6.58487637334     , 7.25609284257     , 7.90459064871     , 8.49618256638     ,
 8.97902035691     , 9.28702859746     , 9.41152117741     , 9.46211921658     ,
 9.61097358285     , 9.94653778588     , 10.3925334566     , 10.7873618019     ,
 11.0339148076     , 11.1636175003     , 11.268159761      , 11.3772752056     ,
 11.4058323154     , 11.2392617542     , 10.8776682747     , 10.4655381473     ,
 10.1514146469     , 9.93698429813     , 9.70252897114     , 9.36194935811     ,
 8.92623829692     , 8.41836983621     , 7.81610579823     , 7.11720101518     ,
 6.39799442385     , 5.75271557417     , 5.19359863723     , 4.64654964892     ,
 4.04202850406     , 3.38634180978     , 2.74427654756     , 2.18161031889     ,
 1.74013282347     , 1.44117478548     , 1.27743487661     , 1.20281025333     ,
 1.15336381383     , 1.08312955481     , 0.97462441401     , 0.827631483077    ,
 0.656190944413    , 0.494014030413    , 0.386017333563    , 0.361495617036    ,
 0.408145846406    , 0.471451119376    , 0.488689061348    , 0.433839707543    ,
 0.331785613061    , 0.230301492295    , 0.162020906575    , 0.129562727521    ,
 0.116085464497    , 0.105136519423    , 0.0945717788634   , 0.0968884096864   ,
 0.128518569867    , 0.195822630925    , 0.284748542291    , 0.364122037051    ,
 0.408177167047    , 0.420183145708    , 0.428364323001    , 0.455416673822    ,
 0.495948966076    , 0.524515651723    , 0.518636590428    , 0.471455610615    ,
 0.392970089104    , 0.309222996485    , 0.255706397894    , 0.261883787729    ,
 0.337455860035    , 0.468239132972    , 0.620930108354    , 0.759836699459    ,
 0.872855333254    , 0.983942027181    , 1.13644963649     , 1.36634583884     ,
 1.69091268499     , 2.1123128217      , 2.62603996455     , 3.22899212746     ,
 3.90778698908     , 4.59903342584     , 5.18089960702     , 5.55880111334     ,
 5.77692452088     , 6.01236163549     , 6.44244907576     , 7.13171056978     ,
 8.03518538811     , 9.06330387446     , 10.1317823448     , 11.1981574684     ,
 12.276596538      , 13.3647844014     , 14.3064853983     , 14.7673223434     ,
 12.1993453269     , 10.7652402469     , 8.8976925291      , 7.05190529304     ,
 5.54457363241     , 4.46883483404     , 3.74773119375     , 3.23221150902     ,
 2.78705903645     , 2.343091096       , 1.90441464395     , 1.51336297118     ,
 1.20206371061     , 0.967747102762    , 0.783324541347    , 0.624767241492    ,
 0.487518393694    , 0.378737949158    , 0.299709979721    , 0.242445288732    ,
 0.20158270174     , 0.180840104539    , 0.184404817656    , 0.205981731799    ,
 0.228363255501    , 0.232848794861    , 0.211181696009    , 0.171209622042    ,
 0.130388184804    , 0.102802971036    , 0.0917901284705   , 0.0912782655207   ,
 0.0909705796924   , 0.0828177522341   , 0.0669206021017   , 0.0526131763399   ,
 0.0538412225639   , 0.0819551243711   , 0.137669107091    , 0.205978660619    ,
 0.263318886       , 0.297409879352    , 0.320537601216    , 0.359532940856    ,
 0.433441723829    , 0.541702543759    , 0.668223971795    , 0.791931927265    ,
 0.895569740182    , 0.968993516581    , 1.00845298874     , 1.01607494567     ,
 0.997890261706    , 0.958106066703    , 0.898253811641    , 0.828968596408    ,
 0.782233143604    , 0.803962547842    , 0.927848492277    , 1.15509122168     ,
 1.45887848498     , 1.80113532404     , 2.13728268824     , 2.41659831222     ,
 2.60308566328     , 2.70150524351     , 2.7507051713      , 2.79325866913     ,
 2.86231808156     , 2.99023512817     , 3.21001419864     , 3.54080994389     ,
 3.97939307787     , 4.51107971249     , 5.12347153125     , 5.80296667631     ,
 6.52081404614     , 7.2327086591      , 7.89343827204     , 8.45839331691     ,
 8.8729528703      , 9.09650357834     , 9.16447587905     , 9.20974441398     ,
 9.3848458223      , 9.74250054983     , 10.1980053409     , 10.6169836612     ,
 10.934342696      , 11.1866323619     , 11.4365059289     , 11.6626307603     ,
 11.7327957221     , 11.5278459704     , 11.1085973198     , 10.7112827411     ,
 10.5299417049     , 10.5211987943     , 10.4636676701     , 10.1845932792     ,
 9.66661814522     , 8.96124516231     , 8.11154654462     , 7.19437779133     ,
 6.34734276276     , 5.67596586219     , 5.15064799331     , 4.6376350501      ,
 4.03251389493     , 3.34541870072     , 2.66580066776     , 2.07919122633     ,
 1.63090363014     , 1.3356038696      , 1.17885395435     , 1.10932143481     ,
 1.05984850394     , 0.988113566037    , 0.888516972579    , 0.770023464069    ,
 0.641141695018    , 0.519010295873    , 0.436439115291    , 0.423626820103    ,
 0.475806805175    , 0.541884726975    , 0.55627293017     , 0.490119069791    ,
 0.370540366523    , 0.250935469663    , 0.168397175525    , 0.126786730147    ,
 0.108201040272    , 0.0942203099009   , 0.0805181891241   , 0.0777080991495   ,
 0.101313012108    , 0.158374539386    , 0.237438498924    , 0.311051441896    ,
 0.35577094216     , 0.373607339361    , 0.389195905298    , 0.423360995117    ,
 0.472778002983    , 0.515269399541    , 0.528032972207    , 0.499459589662    ,
 0.434727799632    , 0.359122328834    , 0.310195727398    , 0.317319671202    ,
 0.385747650475    , 0.496791813025    , 0.619336341048    , 0.727590756237    ,
 0.819857919232    , 0.92261908865     , 1.07188633564     , 1.29009564543     ,
 1.58000763748     , 1.93390093216     , 2.34551686535     , 2.8160771405      ,
 3.34161915223     , 3.88111339233     , 4.34944114369     , 4.67898713604     ,
 4.90490248827     , 5.17102878912     , 5.63361213936     , 6.35970251045     ,
 7.30838807576     , 8.37287642049     , 9.42924490001     , 10.3945467369     ,
 11.2720771834     , 12.0864772398     , 12.7179417948     , 12.8531794086     ,
 10.2704302007     , 8.73595809379     , 6.91482771103     , 5.25568299267     ,
 4.01607644093     , 3.21191057787     , 2.71695302375     , 2.37738182316     ,
 2.07780074437     , 1.7637711104      , 1.43765383347     , 1.1342849561      ,
 0.886590698672    , 0.701605175718    , 0.562077557273    , 0.447742053892    ,
 0.352338629484    , 0.279613195858    , 0.229028743468    , 0.192806646854    ,
 0.165534097533    , 0.149298497002    , 0.147436424345    , 0.157050981878    ,
 0.168506531061    , 0.170502599744    , 0.157278672819    , 0.133151219928    ,
 0.10904434639     , 0.0940424692797   , 0.0906619563149   , 0.095305619851    ,
 0.100185685534    , 0.0971413217666   , 0.0836088174586   , 0.065746374487    ,
 0.0554320328032   , 0.0636492212227   , 0.0937004524708   , 0.137657271768    ,
 0.181130868378    , 0.215782126413    , 0.247728311775    , 0.292330395016    ,
 0.362345655219    , 0.461172297176    , 0.58133678898     , 0.704833276954    ,
 0.808214596359    , 0.872393521937    , 0.890281398639    , 0.868171116642    ,
 0.820947495293    , 0.762635065777    , 0.700599242385    , 0.643515636949    ,
 0.616052500796    , 0.658561584258    , 0.804918375138    , 1.0594311099      ,
 1.39494723273     , 1.76436302265     , 2.10574284552     , 2.35311891036     ,
 2.47316739042     , 2.49439716851     , 2.48166522463     , 2.48430880205     ,
 2.52460879299     , 2.62707473365     , 2.83157197637     , 3.16909544946     ,
 3.63863350927     , 4.21660116128     , 4.88006223813     , 5.61051484324     ,
 6.377795841       , 7.1314274495      , 7.81064632265     , 8.35535768501     ,
 8.71722888382     , 8.89249494935     , 8.95532753415     , 9.03415157462     ,
 9.22923957471     , 9.546811598       , 9.91595577345     , 10.2679590962     ,
 10.5952922669     , 10.9392237464     , 11.3206647332     , 11.6642621844     ,
 11.8011459578     , 11.6115885609     , 11.1965423796     , 10.8495765404     ,
 10.7949768734     , 10.9649940461     , 11.0707148637     , 10.8654286563     ,
 10.2908358479     , 9.41421245665     , 8.34301398534     , 7.2296465763      ,
 6.2589118657      , 5.54009288176     , 5.01598883213     , 4.51735718327     ,
 3.91513764436     , 3.21331794658     , 2.51097793685     , 1.90833488429     ,
 1.45840269512     , 1.17306038019     , 1.03070947118     , 0.975121842912    ,
 0.938889609275    , 0.88459518071     , 0.814119334118    , 0.738475816221    ,
 0.656461276117    , 0.568601127866    , 0.497063451555    , 0.475272532952    ,
 0.511529694295    , 0.566908218583    , 0.579207529575    , 0.514376949952    ,
 0.392339955117    , 0.263854657149    , 0.168999712234    , 0.116660740883    ,
 0.0923936343102   , 0.0782380842861   , 0.0674331555844   , 0.0666686970649   ,
 0.0886619599274   , 0.141212484847    , 0.217378566418    , 0.294382392991    ,
 0.348053922705    , 0.372889402681    , 0.385609866593    , 0.407063462567    ,
 0.442908606194    , 0.481474241549    , 0.504118927308    , 0.495840913391    ,
 0.455225038848    , 0.4020584255      , 0.370350571965    , 0.385696673711    ,
 0.447559859356    , 0.53271782666     , 0.61417162023     , 0.680807804687    ,
 0.746467186603    , 0.841951664366    , 0.994836155818    , 1.21366889401     ,
 1.48772542443     , 1.79858865247     , 2.13491997977     , 2.50108250522     ,
 2.90614295475     , 3.3340327576      , 3.73029590921     , 4.04148636122     ,
 4.283913858       , 4.56677770999     , 5.02961064091     , 5.74790110196     ,
 6.69059811892     , 7.74150001042     , 8.75083559301     , 9.61028185356     ,
 10.3128790981     , 10.8931807646     , 11.2580276716     , 11.1320886839     ,
 8.48009878163     , 7.01525547049     , 5.3904094219      , 3.99373471331     ,
 3.01305154074     , 2.41473303146     , 2.06107239673     , 1.8189831521      ,
 1.60069569229     , 1.36428422751     , 1.10773046895     , 0.857856903643    ,
 0.647434027408    , 0.491735491577    , 0.383137383833    , 0.305388345023    ,
 0.248787981635    , 0.210570059381    , 0.186791910266    , 0.17067448269     ,
 0.157922105352    , 0.148408665337    , 0.142115915131    , 0.136872494569    ,
 0.130077541871    , 0.120146220323    , 0.10700840773     , 0.0929585728527   ,
 0.0820618312393   , 0.0780067441537   , 0.0828949869216   , 0.0960722613687   ,
 0.111833310637    , 0.120231293268    , 0.113667746785    , 0.0936147490443   ,
 0.0705355902192   , 0.0572060836286   , 0.061014577214    , 0.080681841297    ,
 0.109679289584    , 0.143332817212    , 0.182707483297    , 0.232787306844    ,
 0.300240588058    , 0.392582512039    , 0.511914408316    , 0.644008092926    ,
 0.757673823913    , 0.821141159041    , 0.821223786425    , 0.769263640634    ,
 0.69241108006     , 0.617832384514    , 0.560701021279    , 0.526903643053    ,
 0.528060587228    , 0.589286706197    , 0.736339656161    , 0.975139224781    ,
 1.28503277504     , 1.6233941205      , 1.92830522452     , 2.1343459564      ,
 2.21629621789     , 2.21664935904     , 2.20762395207     , 2.22974248352     ,
 2.2875592461      , 2.3955892747      , 2.59669499918     , 2.92783982554     ,
 3.38863578265     , 3.95444870477     , 4.60637241154     , 5.33338198001     ,
 6.1075255457      , 6.8694798648      , 7.54322296012     , 8.06246718012     ,
 8.39729403105     , 8.58084567151     , 8.70674352578     , 8.87144591783     ,
 9.10654585772     , 9.37465889895     , 9.63237595888     , 9.88742174681     ,
 10.1918764038     , 10.5901150583     , 11.0660667795     , 11.5073248794     ,
 11.7291060352     , 11.6123170663     , 11.263145477      , 10.9786765757     ,
 10.9846424366     , 11.2119550758     , 11.3594346392     , 11.1521081677     ,
 10.5079733543     , 9.50790283029     , 8.30799141963     , 7.10226892784     ,
 6.0812533417      , 5.33834677888     , 4.80561879226     , 4.31224104973     ,
 3.72446484249     , 3.03526220904     , 2.33673433889     , 1.73287077756     ,
 1.28432110124     , 1.00512417434     , 0.871384833806    , 0.827399348247    ,
 0.811093983188    , 0.789903403194    , 0.764473665746    , 0.7376164597      ,
 0.695939265401    , 0.628109406981    , 0.549761318371    , 0.498017234225    ,
 0.496204860281    , 0.524982287834    , 0.53377009123     , 0.484044909525    ,
 0.380256430836    , 0.260370829818    , 0.162766554759    , 0.103042379968    ,
 0.0745311623449   , 0.0630425428794   , 0.0602669042896   , 0.0680298731596   ,
 0.09514610691     , 0.150122770015    , 0.230916796045    , 0.318403223116    ,
 0.384585368958    , 0.413205731085    , 0.412447192639    , 0.405697389574    ,
 0.41133743417     , 0.431633353032    , 0.455412825566    , 0.467207081237    ,
 0.459244631319    , 0.441615069059    , 0.438370210974    , 0.467281298294    ,
 0.52227801821     , 0.57835813374     , 0.615735997355    , 0.640463586744    ,
 0.682980889657    , 0.778113727141    , 0.945480249288    , 1.18227951409     ,
 1.46565829881     , 1.76220098051     , 2.04786473628     , 2.32813839815     ,
 2.63190757864     , 2.9738754134      , 3.32444676365     , 3.63095452426     ,
 3.88270981865     , 4.15487958475     , 4.57244994635     , 5.21916446511     ,
 6.07652754676     , 7.03209686139     , 7.93397870979     , 8.66833341696     ,
 9.21465059129     , 9.59492733559     , 9.73415031447     , 9.41945256245     ,
 6.76083757947     , 5.50632142376     , 4.19396753588     , 3.11179986803     ,
 2.3764884509      , 1.9326385733      , 1.66076479147     , 1.46317718769     ,
 1.28132825431     , 1.0846105457      , 0.86821244691     , 0.652945945076    ,
 0.470003663963    , 0.338790679501    , 0.257790829535    , 0.212811583608    ,
 0.189459037783    , 0.178195855322    , 0.173286577979    , 0.171575074323    ,
 0.171418354018    , 0.169969180676    , 0.162036545117    , 0.144144934506    ,
 0.11917746129     , 0.0945659512913   , 0.0761767143327   , 0.0654064185525   ,
 0.0613909544416   , 0.0647115857087   , 0.0785978708785   , 0.105065323719    ,
 0.138293761267    , 0.163427188922    , 0.165494131792    , 0.141333838114    ,
 0.102636722468    , 0.0673952813399   , 0.0486871154998   , 0.0504323628944   ,
 0.0708672422696   , 0.107107720732    , 0.155860881262    , 0.213616744608    ,
 0.281925193214    , 0.371529247767    , 0.491584034544    , 0.629108478162    ,
 0.74539306861     , 0.800068689331    , 0.779071279787    , 0.700924188495    ,
 0.602812651978    , 0.521369412264    , 0.477951322669    , 0.475686891941    ,
 0.511055744879    , 0.587956161593    , 0.717707601229    , 0.906524511252    ,
 1.14556339658     , 1.40680408748     , 1.64173961882     , 1.79899780348     ,
 1.86698972615     , 1.89363114218     , 1.94130270848     , 2.02834407127     ,
 2.13789407274     , 2.27542178349     , 2.48540083263     , 2.80761516067     ,
 3.24325228691     , 3.77234239898     , 4.38300861511     , 5.066779773       ,
 5.79174515805     , 6.49522959067     , 7.10697684489     , 7.57849604065     ,
 7.90549317685     , 8.14069222512     , 8.37056468559     , 8.64936054608     ,
 8.95451671347     , 9.22404403272     , 9.43794618601     , 9.65018201372     ,
 9.94230228258     , 10.358784364      , 10.8727518556     , 11.3714862854     ,
 11.6802723525     , 11.6792701339     , 11.4446986862     , 11.2240643229     ,
 11.2095199952     , 11.3412851055     , 11.3569654115     , 11.0146786442     ,
 10.2520068317     , 9.17517549717     , 7.96634484793     , 6.8118151314      ,
 5.85521804686     , 5.14757425543     , 4.62033106435     , 4.13083182919     ,
 3.56411433406     , 2.90631370523     , 2.23193967222     , 1.63613134747     ,
 1.18238265694     , 0.891253191306    , 0.745523054354    , 0.698900341722    ,
 0.699709570949    , 0.717933327262    , 0.743878075699    , 0.763663564181    ,
 0.751240661128    , 0.689618356487    , 0.592935499926    , 0.501695202239    ,
 0.451986613639    , 0.44490707181     , 0.445667872383    , 0.414553112599    ,
 0.339510242861    , 0.241116265632    , 0.151460627885    , 0.0910417347744   ,
 0.061908747515    , 0.0555261905586   , 0.0632625425833   , 0.0821987309899   ,
 0.116721007367    , 0.175403717165    , 0.2604471623      , 0.355924626914    ,
 0.430477525258    , 0.458647359634    , 0.441460737104    , 0.404534343647    ,
 0.377151876231    , 0.374386542359    , 0.394205875595    , 0.424420317419    ,
 0.453043385559    , 0.478059371071    , 0.508263577805    , 0.550606647657    ,
 0.596014436185    , 0.623519529381    , 0.624390490331    , 0.62060465328     ,
 0.654503428278    , 0.761313171428    , 0.953369177997    , 1.22034399223     ,
 1.52953149067     , 1.82975533105     , 2.07892059871     , 2.28247852507     ,
 2.49440812908     , 2.76462129451     , 3.08412248565     , 3.39136409489     ,
 3.64326515567     , 3.88143830106     , 4.21602190368     , 4.73614254399     ,
 5.43793399659     , 6.22668005258     , 6.96962229559     , 7.56024624527     ,
 7.95793434776     , 8.15708458729     , 8.10177588252     , 7.66364391855     ,
 5.17707873006     , 4.19575943659     , 3.22070737849     , 2.43717200308     ,
 1.90806295736     , 1.5789060573      , 1.36019897255     , 1.18794647584     ,
 1.02741547592     , 0.858415134483    , 0.6758601957      , 0.495227762772    ,
 0.343225227581    , 0.239384049633    , 0.185735223331    , 0.169426745729    ,
 0.171973956991    , 0.178714807591    , 0.184230605071    , 0.190415823259    ,
 0.198519323284    , 0.202847339083    , 0.193358194167    , 0.165438782471    ,
 0.1262726477      , 0.0898613573351   , 0.0659596315911   , 0.0550258407695   ,
 0.0532264310691   , 0.060519600379    , 0.0826633039605   , 0.12393088695     ,
 0.176540173265    , 0.218730733461    , 0.227537221633    , 0.196526703372    ,
 0.141066428579    , 0.0863198970924   , 0.051426747862    , 0.0441400144382   ,
 0.0651416337849   , 0.111452754897    , 0.174903482781    , 0.24414786236     ,
 0.31648023592     , 0.405489925687    , 0.524786096218    , 0.659678411659    ,
 0.765127146825    , 0.799202741652    , 0.754765480858    , 0.658917205821    ,
 0.55271253252     , 0.47428607866     , 0.447659237068    , 0.475233903707    ,
 0.541891163697    , 0.630920817638    , 0.736828979924    , 0.86432923434     ,
 1.0174495406      , 1.18631628485     , 1.34112460699     , 1.44971168464     ,
 1.51463742728     , 1.58325129817     , 1.7014059005      , 1.86480760361     ,
 2.03930029906     , 2.22230526714     , 2.4553197695      , 2.77701914277     ,
 3.19267141774     , 3.69152487667     , 4.2644906035      , 4.8905593122      ,
 5.52226921958     , 6.10281912572     , 6.59683749182     , 6.99979911569     ,
 7.3322397875      , 7.63949530606     , 7.97677511314     , 8.36437651786     ,
 8.76262529678     , 9.11225868216     , 9.39840314253     , 9.66445238345     ,
 9.973011757       , 10.3674161039     , 10.8494317423     , 11.3501995316     ,
 11.7277084688     , 11.8580432162     , 11.7639018306     , 11.6105736078     ,
 11.5321195865     , 11.4768911467     , 11.2473184735     , 10.6778601866     ,
 9.76464523144     , 8.65200263367     , 7.52855293911     , 6.53438294657     ,
 5.72995760902     , 5.10537556543     , 4.59464713218     , 4.10077869602     ,
 3.54616283539     , 2.91878790966     , 2.27155267714     , 1.68039654629     ,
 1.20533724502     , 0.876565557153    , 0.69254545792     , 0.623854934719    ,
 0.630815878009    , 0.682376704748    , 0.753220885573    , 0.809643683015    ,
 0.814210337414    , 0.749040488199    , 0.631181188545    , 0.504528524971    ,
 0.412866991666    , 0.371319063479    , 0.358599767191    , 0.337873872025    ,
 0.287202740061    , 0.212761352966    , 0.137852382877    , 0.0833611310403   ,
 0.0573154523682   , 0.0566251570845   , 0.0734105317452   , 0.100964528023    ,
 0.139172536529    , 0.195458662438    , 0.275083836407    , 0.366432694188    ,
 0.439372472391    , 0.464904846667    , 0.438961080756    , 0.385652597335    ,
 0.338238342401    , 0.319261049772    , 0.335043658216    , 0.379689512059    ,
 0.440348593219    , 0.503606043406    , 0.561513878014    , 0.610174119501    ,
 0.641771693027    , 0.645675828852    , 0.626273256302    , 0.615924552144    ,
 0.65982254391     , 0.788060949339    , 1.00608666633     , 1.29970463343     ,
 1.63073163986     , 1.93465456882     , 2.15429227137     , 2.29427568158     ,
 2.42930304334     , 2.63899448039     , 2.93070864519     , 3.23308861857     ,
 3.47350871195     , 3.66320794443     , 3.89698206291     , 4.26654007753     ,
 4.78299606753     , 5.37517931058     , 5.93678292345     , 6.37251614513     ,
 6.62341116846     , 6.66115401715     , 6.45605173793     , 5.96408601464     ,
 3.83342757891     , 3.10984152279     , 2.4136662201      , 1.85718521175     ,
 1.47740009844     , 1.23354804447     , 1.06199733325     , 0.920055629974    ,
 0.787626253877    , 0.653241159144    , 0.512824941836    , 0.375578147734    ,
 0.260649049408    , 0.185349340133    , 0.154954282154    , 0.159395680001    ,
 0.178735752643    , 0.195900848318    , 0.206831443381    , 0.217213432932    ,
 0.229341452023    , 0.234700792958    , 0.220664676148    , 0.183695485316    ,
 0.134941488363    , 0.0921001634268   , 0.065868532114    , 0.0549318714886   ,
 0.0535009745595   , 0.0619333923109   , 0.0884558735215   , 0.138983689805    ,
 0.203893283674    , 0.256223227358    , 0.267787796655    , 0.230926271753    ,
 0.164522574117    , 0.0989754076224   , 0.0574500303858   , 0.0503136694345   ,
 0.079900694875    , 0.142247433386    , 0.223579120785    , 0.304828462978    ,
 0.3800322417      , 0.466449983908    , 0.581889711566    , 0.70961848337     ,
 0.800099398976    , 0.814072683241    , 0.754475603072    , 0.655084887138    ,
 0.554015543824    , 0.483543699454    , 0.467300636474    , 0.510497659492    ,
 0.594626765547    , 0.689878139744    , 0.776243232284    , 0.85405002856     ,
 0.935506023443    , 1.02548351861     , 1.11126651422     , 1.17802103907     ,
 1.23870558729     , 1.33725426637     , 1.50666181372     , 1.73045980445     ,
 1.96573440374     , 2.20032817744     , 2.46432943284     , 2.7901263875      ,
 3.1893404575      , 3.66446317705     , 4.20710024982     , 4.77502063091     ,
 5.29902432289     , 5.73426396215     , 6.09656926189     , 6.43689025335     ,
 6.79390665234     , 7.1854121873      , 7.62371676659     , 8.10975947125     ,
 8.61883860741     , 9.11202907398     , 9.5586373735      , 9.94427794956     ,
 10.2787891608     , 10.6099016494     , 11.0002032969     , 11.4524339502     ,
 11.8653957717     , 12.1061101687     , 12.1375900881     , 12.0421110891     ,
 11.8991916979     , 11.6669349564     , 11.2103446433     , 10.4396433687     ,
 9.41119269936     , 8.30354360157     , 7.30131745555     , 6.49072467379     ,
 5.84850020924     , 5.30524676246     , 4.79823570859     , 4.27948094281     ,
 3.71589369898     , 3.10336702346     , 2.47281208248     , 1.87511945438     ,
 1.36211587287     , 0.974905014679    , 0.732496848341    , 0.624522685305    ,
 0.620813196501    , 0.686405510517    , 0.781384309318    , 0.856227144983    ,
 0.865598008454    , 0.792646255842    , 0.65849132002     , 0.509574583035    ,
 0.391916449872    , 0.325855538968    , 0.297972575001    , 0.277194540376    ,
 0.240396951932    , 0.185725241864    , 0.127323792929    , 0.0820011855483   ,
 0.0598631047768   , 0.0619898236869   , 0.08221514798     , 0.111784101065    ,
 0.146770036192    , 0.192163243346    , 0.254543225685    , 0.327717995289    ,
 0.388356376311    , 0.410928846179    , 0.389035076974    , 0.341024515632    ,
 0.295538310057    , 0.274821247759    , 0.289987794929    , 0.342225206682    ,
 0.421163805926    , 0.505953827044    , 0.57546461733     , 0.61840901215     ,
 0.632369816462    , 0.620403144021    , 0.59839653325     , 0.600947522408    ,
 0.666482305531    , 0.815286935996    , 1.04676013266     , 1.34632970504     ,
 1.67712904776     , 1.97321987274     , 2.17340412632     , 2.28022270538     ,
 2.37292239393     , 2.54152820013     , 2.80150419378     , 3.07820853816     ,
 3.2831830158      , 3.40797173569     , 3.53571409503     , 3.76001188794     ,
 4.10405438148     , 4.51404658846     , 4.90256649872     , 5.18567252166     ,
 5.30115573556     , 5.21840712517     , 4.93572484439     , 4.46521651889     ,
 2.77031979533     , 2.24872400265     , 1.74726902778     , 1.34126130227     ,
 1.06254319027     , 0.885713370363    , 0.76300317193     , 0.660960934834    ,
 0.566497327548    , 0.474701825044    , 0.38262816327     , 0.292597311051    ,
 0.214811134099    , 0.163581164694    , 0.148023640691    , 0.16297838615     ,
 0.190151915322    , 0.212259228611    , 0.226049611294    , 0.238307171199    ,
 0.250411801479    , 0.251898332449    , 0.230441468928    , 0.185717966651    ,
 0.132193181076    , 0.0884054756933   , 0.0634865821596   , 0.0539135030943   ,
 0.052634132769    , 0.0601023025834   , 0.0852597334335   , 0.134404825237    ,
 0.197799778937    , 0.248441368407    , 0.258667162699    , 0.221692331285    ,
 0.156865397638    , 0.0943459296037   , 0.0572427621797   , 0.0570758881277   ,
 0.0977684191569   , 0.174641549883    , 0.269190667286    , 0.356339488527    ,
 0.428372963274    , 0.50669484838     , 0.61411850631     , 0.734814928404    ,
 0.818590365235    , 0.829871031437    , 0.777876294446    , 0.696162680064    ,
 0.613108780044    , 0.550531732721    , 0.530736082571    , 0.566554235331    ,
 0.646957931988    , 0.741052211787    , 0.819781448542    , 0.87479423643     ,
 0.916770981814    , 0.956902451054    , 0.994599640713    , 1.0287034674      ,
 1.07951052152     , 1.18818736305     , 1.38187119601     , 1.64222929583     ,
 1.92362085202     , 2.20216144737     , 2.49082591574     , 2.81256558568     ,
 3.18469943662     , 3.62286616387     , 4.12208538841     , 4.62648486841     ,
 5.05338420607     , 5.37175852471     , 5.64151660047     , 5.95704428231     ,
 6.36541378032     , 6.85470818491     , 7.40043650224     , 7.99443667915     ,
 8.63337453103     , 9.29397838049     , 9.91625550008     , 10.4185745886     ,
 10.7620575979     , 11.0102938499     , 11.2915360695     , 11.6734157283     ,
 12.0850889473     , 12.3814367079     , 12.4777394539     , 12.4010947761     ,
 12.2079673409     , 11.8785711121     , 11.320936884      , 10.4806682792     ,
 9.4345253971      , 8.37044074783     , 7.4670820181      , 6.7790561802      ,
 6.23238231292     , 5.72010984443     , 5.18464997785     , 4.61836352281     ,
 4.02629840314     , 3.4117655128      , 2.78522408263     , 2.17228425417     ,
 1.61485022447     , 1.16372388308     , 0.857187583361    , 0.700106363484    ,
 0.666514215695    , 0.716591052814    , 0.802965500919    , 0.871208378538    ,
 0.874609820131    , 0.7965625208      , 0.657973119182    , 0.503784355291    ,
 0.37797348067     , 0.30058331385     , 0.26191800872     , 0.237506522933    ,
 0.208181396641    , 0.168823102215    , 0.125445423562    , 0.0887319640036   ,
 0.068281205504    , 0.0681449603062   , 0.0847443127378   , 0.109471513665    ,
 0.136064394894    , 0.166230888594    , 0.205596816426    , 0.252702575905    ,
 0.293976766141    , 0.31255221327     , 0.303058242697    , 0.27656442426     ,
 0.251362896386    , 0.242686961645    , 0.26152144084     , 0.314256218011    ,
 0.394774832638    , 0.480055870585    , 0.542422460222    , 0.568213754311    ,
 0.562536347877    , 0.541425673764    , 0.528113702905    , 0.552237085509    ,
 0.638992974899    , 0.796876840561    , 1.02098074399     , 1.29962236388     ,
 1.60408477579     , 1.88008332326     , 2.07546384781     , 2.19020152432     ,
 2.28888750698     , 2.44615205697     , 2.671998241       , 2.89530201165     ,
 3.03098507151     , 3.06851691476     , 3.08825799233     , 3.18683594639     ,
 3.39406462494     , 3.66113050764     , 3.9063114511      , 4.05695201002     ,
 4.06610247233     , 3.91978207826     , 3.63593523121     , 3.24453056474     ,
 1.95727280278     , 1.58190432445     , 1.21349820096     , 0.910999141977    ,
 0.706438918578    , 0.584838404267    , 0.507473172207    , 0.445157382922    ,
 0.388530453163    , 0.337306726186    , 0.289350364533    , 0.240955499571    ,
 0.194153404529    , 0.160335977151    , 0.152571934841    , 0.17159264705     ,
 0.201852015372    , 0.225355293028    , 0.237586286722    , 0.245191003713    ,
 0.250104070714    , 0.24305472875     , 0.214208533787    , 0.166075526119    ,
 0.113873818161    , 0.0740726084529   , 0.0529616352126   , 0.0456097987276   ,
 0.0449116233148   , 0.0509470161411   , 0.0710856662378   , 0.11018573601     ,
 0.159836065507    , 0.198198880169    , 0.203902593       , 0.172814901499    ,
 0.12124155574     , 0.0734303867618   , 0.0482558446286   , 0.0565260012847   ,
 0.103259198285    , 0.183984380471    , 0.278691949278    , 0.360635939759    ,
 0.422153890318    , 0.486795205176    , 0.581016287279    , 0.693919197131    ,
 0.781420110362    , 0.81326665192     , 0.798254205556    , 0.759538590326    ,
 0.708323716289    , 0.653118789797    , 0.61609845076     , 0.623536470067    ,
 0.682569432831    , 0.772827740809    , 0.861424184971    , 0.926217633866    ,
 0.965032017241    , 0.985515440284    , 0.994312633061    , 1.00262910769     ,
 1.03891049878     , 1.14422650999     , 1.34324836655     , 1.61837600217     ,
 1.92312107314     , 2.22436065255     , 2.5211013632      , 2.82718816592     ,
 3.1594127766      , 3.53835385033     , 3.96518622838     , 4.38968528723     ,
 4.73753839125     , 4.99398940866     , 5.24039950936     , 5.58515042829     ,
 6.07140381043     , 6.66835947021     , 7.33259770229     , 8.05115099025     ,
 8.82718388088     , 9.63366862139     , 10.3807910573     , 10.9470913233     ,
 11.279292567      , 11.4648321468     , 11.6712884715     , 11.9950055685     ,
 12.3763281469     , 12.663502285      , 12.7498891796     , 12.6460116383     ,
 12.4217160724     , 12.0919205546     , 11.5837055181     , 10.8268177468     ,
 9.86521244214     , 8.86514569877     , 8.00238955963     , 7.33381993944     ,
 6.78045375404     , 6.22965587759     , 5.63343447216     , 5.00912321342     ,
 4.38243243343     , 3.75658294432     , 3.12454547392     , 2.49297295769     ,
 1.89654594101     , 1.39282426606     , 1.0324993735      , 0.827324908487    ,
 0.749121504672    , 0.753717002676    , 0.796146439158    , 0.831224645422    ,
 0.819657398378    , 0.743568976244    , 0.61580115266     , 0.472765364579    ,
 0.35323737475     , 0.276087636355    , 0.234673628961    , 0.21053230221     ,
 0.188833022307    , 0.162778561647    , 0.132073284941    , 0.102003673101    ,
 0.0810183003268   , 0.0753020100377   , 0.0842461562512   , 0.101091042829    ,
 0.118796052909    , 0.135605172175    , 0.154195553747    , 0.175608550879    ,
 0.195415795789    , 0.20702095694     , 0.208723251025    , 0.205982281504    ,
 0.206372210752    , 0.21587477123     , 0.241760616462    , 0.292016686408    ,
 0.363913346788    , 0.435932231009    , 0.47987643847     , 0.483591079479    ,
 0.459347447872    , 0.432969647268    , 0.431022661205    , 0.474610509322    ,
 0.574024617758    , 0.727036533953    , 0.926823098001    , 1.1665692751      ,
 1.42857284144     , 1.6766068057      , 1.87566880572     , 2.02522515282     ,
 2.16504989726     , 2.33644176801     , 2.53166426892     , 2.68612877092     ,
 2.73280666179     , 2.67363742101     , 2.59296499232     , 2.58996923773     ,
 2.69638204521     , 2.86077392464     , 2.99971467602     , 3.05137730372     ,
 2.99232432263     , 2.8304912212      , 2.59138650525     , 2.29768936861     ,
 1.34644758096     , 1.07736602857     , 0.810322264701    , 0.591281982096    ,
 0.447684730891    , 0.36951235866     , 0.325582976985    , 0.291866382862    ,
 0.26258699464     , 0.24069373616     , 0.224750531519    , 0.207145553471    ,
 0.184027884815    , 0.164388727823    , 0.164474670624    , 0.18977815158     ,
 0.225275224547    , 0.248516512352    , 0.25108692161     , 0.24139136926     ,
 0.227761662263    , 0.207329281218    , 0.17361386249     , 0.128788065461    ,
 0.0845835195491   , 0.052808255475    , 0.036872404596    , 0.0320898763766   ,
 0.0329264295776   , 0.039312599807    , 0.0557158505979   , 0.0838095137033   ,
 0.116084052136    , 0.137682574205    , 0.136388809683    , 0.112138076935    ,
 0.0770452914945   , 0.0469517157383   , 0.0341708616616   , 0.046911650924    ,
 0.0900076517928   , 0.159999521335    , 0.239547814298    , 0.305619890006    ,
 0.352104244189    , 0.400499888097    , 0.476482807866    , 0.576187604234    ,
 0.668914125897    , 0.733743636163    , 0.775108501508    , 0.797822460287    ,
 0.789952913282    , 0.744799523081    , 0.686112082875    , 0.658207665592    ,
 0.6927925899      , 0.786130144215    , 0.904040085089    , 1.00701975146     ,
 1.07172915994     , 1.09413013547     , 1.08426871648     , 1.06686933399     ,
 1.08244053145     , 1.17477990629     , 1.36493488902     , 1.63304560694     ,
 1.93327584302     , 2.2317939989      , 2.5230681291      , 2.81290181688     ,
 3.10761104451     , 3.42022086648     , 3.75725785504     , 4.09111160942     ,
 4.37794591263     , 4.62417850758     , 4.91234522128     , 5.3362681976      ,
 5.92227726937     , 6.62936674724     , 7.40924379647     , 8.24376771761     ,
 9.12577626104     , 10.0113919295     , 10.7962864637     , 11.3628851432     ,
 11.6809266392     , 11.8564040616     , 12.0527009509     , 12.3521974383     ,
 12.6937036994     , 12.9345697142     , 12.9743581137     , 12.8332400619     ,
 12.6095157073     , 12.3523708119     , 11.9911567873     , 11.4095708325     ,
 10.5856879417     , 9.64366683748     , 8.75887468244     , 8.01513182892     ,
 7.3642517237      , 6.71683099394     , 6.04151529861     , 5.36554575643     ,
 4.71261173895     , 4.07261499891     , 3.42434493889     , 2.76845679419     ,
 2.14152608049     , 1.60554418455     , 1.21315661083     , 0.972277604471    ,
 0.846558197396    , 0.788214387758    , 0.762298591665    , 0.743992465611    ,
 0.70943500894     , 0.639833837281    , 0.534222360789    , 0.41417806507     ,
 0.310606066555    , 0.241996768252    , 0.205755858145    , 0.188247429743    ,
 0.176800306418    , 0.162691914838    , 0.14163896747     , 0.116107287239    ,
 0.0941723604881   , 0.0834577066833   , 0.0856812483944   , 0.096186248547    ,
 0.108036385395    , 0.116609119692    , 0.121010751399    , 0.122659501187    ,
 0.123499830958    , 0.12546041643     , 0.131075834346    , 0.143053506431    ,
 0.162136668431    , 0.187768757435    , 0.222844191831    , 0.273198199608    ,
 0.336362404527    , 0.393144831615    , 0.418382783436    , 0.403483383249    ,
 0.366178342915    , 0.338234727817    , 0.346591228443    , 0.403403607954    ,
 0.506148778527    , 0.645330395244    , 0.814960230573    , 1.01319489209     ,
 1.23078478728     , 1.44679328887     , 1.64358867683     , 1.82352833607     ,
 2.00414857947     , 2.19238661342     , 2.36123331622     , 2.45473985777     ,
 2.42794701386     , 2.29591315659     , 2.14261584981     , 2.06459245992     ,
 2.09479128552     , 2.18324208792     , 2.24824730182     , 2.23711648972     ,
 2.14390661429     , 1.99056290556     , 1.80184778597     , 1.58851639094     ,
 0.903060656725    , 0.711540935405    , 0.527584969217    , 0.38076853857     ,
 0.288026265864    , 0.240805511317    , 0.215865796821    , 0.196148925105    ,
 0.179894782652    , 0.172548981951    , 0.173923110627    , 0.175322561645    ,
 0.170042839418    , 0.165438464241    , 0.179266337229    , 0.218755519326    ,
 0.26543703189     , 0.288379784527    , 0.273914887346    , 0.235563421504    ,
 0.194128679082    , 0.157320767303    , 0.121663748966    , 0.0854807433823   ,
 0.0535898357795   , 0.0318631168944   , 0.021533570331    , 0.0195703005622   ,
 0.023246814957    , 0.0331482148354   , 0.0509184335937   , 0.073942794957    ,
 0.0935043244989   , 0.0998280403955   , 0.08941213414     , 0.0673559210051   ,
 0.0432672418897   , 0.0257684651315   , 0.0206104837538   , 0.0322035830793   ,
 0.0638194649953   , 0.113228341612    , 0.168503401676    , 0.213867573766    ,
 0.245499210709    , 0.279230493768    , 0.335163770843    , 0.415330338613    ,
 0.505528454022    , 0.597458261757    , 0.691888608561    , 0.774842321726    ,
 0.811423840587    , 0.780267582359    , 0.707029175444    , 0.653676095193    ,
 0.67504796736     , 0.782969115334    , 0.942916070591    , 1.09943240555     ,
 1.20632736461     , 1.24261551873     , 1.21695466274     , 1.16738576216     ,
 1.15028281232     , 1.21530179045     , 1.37913439909     , 1.61796014025     ,
 1.88984621091     , 2.16884448982     , 2.45180264378     , 2.73599826677     ,
 3.01125688752     , 3.27697532315     , 3.54270675978     , 3.80633421562     ,
 4.06007219187     , 4.33286785848     , 4.70153968711     , 5.23488453103     ,
 5.93578600805     , 6.75154783604     , 7.62731578049     , 8.53326594654     ,
 9.44509491797     , 10.3090472222     , 11.0368375321     , 11.5561000295     ,
 11.8796022177     , 12.1116012643     , 12.3685274684     , 12.6891192713     ,
 13.0107790775     , 13.2188943784     , 13.2356117561     , 13.0904930046     ,
 12.8964833709     , 12.7267116269     , 12.5167158702     , 12.1133496171     ,
 11.4283402344     , 10.5323294767     , 9.59025642844     , 8.71655594723     ,
 7.91248902914     , 7.13396804532     , 6.37589835113     , 5.66549376472     ,
 5.00275009447     , 4.34784015004     , 3.66713534933     , 2.97219415763     ,
 2.31659515458     , 1.76685398356     , 1.36615614184     , 1.10803507292     ,
 0.944309880593    , 0.824430039172    , 0.725760130476    , 0.646986923565    ,
 0.583294591638    , 0.517700568174    , 0.435895060575    , 0.342968149086    ,
 0.260178080672    , 0.205318579747    , 0.179862723614    , 0.173348463757    ,
 0.172710090728    , 0.166818840832    , 0.150008546623    , 0.125338175974    ,
 0.102112377121    , 0.0887218936041   , 0.0875210968382   , 0.0947569836913   ,
 0.103794434902    , 0.108517733264    , 0.105536273784    , 0.0957120149673   ,
 0.0841965736023   , 0.077852425655    , 0.0819465408767   , 0.0984335648904   ,
 0.126059879136    , 0.162612473355    , 0.208135107601    , 0.263639416231    ,
 0.323213947973    , 0.369097941291    , 0.381205805783    , 0.356101573841    ,
 0.315346995622    , 0.292649790195    , 0.312341788006    , 0.378112576292    ,
 0.478197668762    , 0.600217668234    , 0.741668992894    , 0.904827413122    ,
 1.08403557956     , 1.26633524378     , 1.446131799       , 1.63017917359     ,
 1.82261189625     , 2.00791786603     , 2.14975156529     , 2.20482023633     ,
 2.14592996491     , 1.98960812125     , 1.8055538546      , 1.67901373124     ,
 1.64684679136     , 1.67285442882     , 1.68758390349     , 1.64511482645     ,
 1.54312131334     , 1.40400629277     , 1.24839491515     , 1.08262956773     ,
 0.597834297307    , 0.46038581254     , 0.341936580248    , 0.254543617312    ,
 0.202394492265    , 0.176325663357    , 0.160088295852    , 0.143420496759    ,
 0.12829770113     , 0.122375387308    , 0.127603155596    , 0.136859138163    ,
 0.143474815554    , 0.153764906284    , 0.184612267163    , 0.241616935329    ,
 0.301032474868    , 0.323819791452    , 0.292440034248    , 0.226555393516    ,
 0.159664346952    , 0.109581190608    , 0.0748274440155   , 0.0488416355522   ,
 0.0292634831883   , 0.0167449699977   , 0.0113059978971   , 0.0120682993672   ,
 0.0193633309055   , 0.0350699209464   , 0.0588575057692   , 0.0837027608369   ,
 0.0976980664108   , 0.0930182429941   , 0.0726529137912   , 0.047177602198    ,
 0.026222378067    , 0.0140350212338   , 0.011285684024    , 0.0185345816044   ,
 0.036885773464    , 0.0650893798704   , 0.0968651149614   , 0.124024212062    ,
 0.145063936423    , 0.169387977458    , 0.209404928633    , 0.269646777492    ,
 0.348974934518    , 0.450312724579    , 0.573536424274    , 0.693153126196    ,
 0.759897737219    , 0.742677491668    , 0.667486578089    , 0.606586088636    ,
 0.628497033097    , 0.754810083398    , 0.952752219769    , 1.15877150539     ,
 1.30985313591     , 1.36672335305     , 1.32992351711     , 1.24512629537     ,
 1.18385421446     , 1.20476953035     , 1.32424812242     , 1.51817104672     ,
 1.7517792312      , 2.00868091359     , 2.28720475274     , 2.57567009505     ,
 2.85165380435     , 3.10713454726     , 3.35390247869     , 3.60363119369     ,
 3.86900522783     , 4.19302132025     , 4.65033498414     , 5.29511713854     ,
 6.11267307222     , 7.03238976453     , 7.97782364132     , 8.89493128396     ,
 9.74424279497     , 10.4851944074     , 11.0831791856     , 11.5408301501     ,
 11.91378572       , 12.2760190301     , 12.6646176646     , 13.0610123956     ,
 13.4086329864     , 13.6343423603     , 13.6825453294     , 13.5694952217     ,
 13.3932465347     , 13.245397947      , 13.0997819024     , 12.8123357379     ,
 12.249231413      , 11.4096370219     , 10.4149639261     , 9.39450119139     ,
 8.40946599644     , 7.48185775275     , 6.64454764541     , 5.91988642561     ,
 5.26749339225     , 4.60186722945     , 3.87512747684     , 3.12372756252     ,
 2.43381981419     , 1.87900306618     , 1.48458588296     , 1.22315942497     ,
 1.03542375243     , 0.870067123216    , 0.71399225471     , 0.583547714373    ,
 0.490069607949    , 0.421311179375    , 0.355389550697    , 0.284731037044    ,
 0.2214012911      , 0.181366689716    , 0.168628106219    , 0.173710338835    ,
 0.181053766139    , 0.177028116657    , 0.157022829668    , 0.127831413913    ,
 0.101557164093    , 0.0866209821445   , 0.0839760172936   , 0.0891683160966   ,
 0.095976197893    , 0.0986237881521   , 0.0932738602542   , 0.0804086538607   ,
 0.0658963980674   , 0.0578240998053   , 0.0617309001753   , 0.0791647567815   ,
 0.109834079686    , 0.153694773482    , 0.210161083288    , 0.274621821156    ,
 0.335209474849    , 0.374393096885    , 0.378556388738    , 0.351147554595    ,
 0.316422799649    , 0.306041701286    , 0.338475636973    , 0.409545412782    ,
 0.502053087079    , 0.604581914284    , 0.719711877165    , 0.853014474869    ,
 0.999378849213    , 1.14830482698     , 1.30008284462     , 1.46434309865     ,
 1.63906055997     , 1.79971002583     , 1.91212863083     , 1.94864147245     ,
 1.89395856067     , 1.75541309179     , 1.57710561512     , 1.42548706513     ,
 1.34263363395     , 1.31605921707     , 1.29794205165     , 1.24760452143     ,
 1.15431513609     , 1.0296458865      , 0.889181103777    , 0.743158635603    ,
 0.395588975201    , 0.294979718958    , 0.224219164541    , 0.181315371595    ,
 0.159590358293    , 0.148272890106    , 0.135909349172    , 0.117379200791    ,
 0.0974852419028   , 0.0855762750963   , 0.0859041508561   , 0.0942576208621   ,
 0.105700550565    , 0.125478734032    , 0.167228385047    , 0.233207629421    ,
 0.297208039021    , 0.318459970246    , 0.279255880033    , 0.20213056915     ,
 0.12590497055     , 0.0729965770489   , 0.0428595768738   , 0.025993951701    ,
 0.0156117212478   , 0.00933850133341  , 0.00694102922069  , 0.00941945395534  ,
 0.019450058055    , 0.0400986149413   , 0.0699534749062   , 0.0987761508207   ,
 0.111567685679    , 0.100639612956    , 0.0727611833403   , 0.0426156536526   ,
 0.0209298089609   , 0.00995354658955  , 0.00719836483184  , 0.010305817301    ,
 0.0185504998384   , 0.031382269334    , 0.046815903596    , 0.062467614804    ,
 0.0789058204755   , 0.100977418124    , 0.134413841271    , 0.182579198244    ,
 0.249555933305    , 0.34325252728     , 0.464146770695    , 0.585496843772    ,
 0.657363721642    , 0.647523119141    , 0.580008072211    , 0.525701948622    ,
 0.553463003696    , 0.687857693603    , 0.901349869545    , 1.13345528758     ,
 1.31591408759     , 1.39578986386     , 1.36054383817     , 1.25289164182     ,
 1.1511187252      , 1.12244840329     , 1.18964619744     , 1.33585118794     ,
 1.53539690848     , 1.77663762851     , 2.05403951562     , 2.34962314838     ,
 2.6408246693      , 2.92416097476     , 3.21267013104     , 3.51416429631     ,
 3.83741777913     , 4.22510070742     , 4.75536008003     , 5.48701922119     ,
 6.40261043038     , 7.41113363398     , 8.39948037702     , 9.27842288134     ,
 9.99993112056     , 10.5612383642     , 11.0101765512     , 11.4368622138     ,
 11.9269035916     , 12.4981234702     , 13.0891500475     , 13.6196342124     ,
 14.0442956852     , 14.3356357781     , 14.4508118892     , 14.3664027204     ,
 14.1410653161     , 13.8921505289     , 13.6794066605     , 13.4252239951     ,
 12.9716538523     , 12.2174071967     , 11.1938249069     , 10.0237828498     ,
 8.84028153011     , 7.75213195931     , 6.83946147974     , 6.11689468882     ,
 5.49526487389     , 4.83394918639     , 4.06533500425     , 3.2533180414      ,
 2.52373394498     , 1.9611390153      , 1.57240123841     , 1.31030660408     ,
 1.10969203002     , 0.921395381543    , 0.735861841755    , 0.575202472988    ,
 0.4587488516      , 0.380153255818    , 0.317354508106    , 0.257116362027    ,
 0.205346517909    , 0.175813467347    , 0.173127682763    , 0.186715888803    ,
 0.197386897987    , 0.189507258992    , 0.161166693475    , 0.124333133749    ,
 0.0941243978148   , 0.0779535536424   , 0.073908515146    , 0.0760404952788   ,
 0.0790721905579   , 0.0792784629639   , 0.0742804452302   , 0.0648319431691   ,
 0.0561843165243   , 0.055167526952    , 0.0654865944167   , 0.0873245294609   ,
 0.121557781432    , 0.171711547519    , 0.238818030371    , 0.314229202249    ,
 0.379661954917    , 0.416188446307    , 0.415990556461    , 0.389720890868    ,
 0.363465466372    , 0.364186133286    , 0.402810968187    , 0.469267815564    ,
 0.545275138921    , 0.6232486305      , 0.710717666376    , 0.815373999887    ,
 0.931826079812    , 1.0500059365      , 1.17206607538     , 1.30819732725     ,
 1.45392201899     , 1.58316723587     , 1.66786243803     , 1.6938596314      ,
 1.65506814224     , 1.55018272588     , 1.39804671862     , 1.24281109795     ,
 1.12734725803     , 1.06230146676     , 1.02409584494     , 0.978099078229    ,
 0.901807430659    , 0.792069685457    , 0.659539155301    , 0.521393315035    ,
 0.260054685824    , 0.187218066051    , 0.149227281283    , 0.135990456496    ,
 0.134354626739    , 0.132395959765    , 0.121834639848    , 0.101207569036    ,
 0.0770237369574   , 0.0590431400046   , 0.0526286310317   , 0.0560379007074   ,
 0.0661881643213   , 0.0867731296933   , 0.126895376869    , 0.186061217393    ,
 0.241208546514    , 0.258318081617    , 0.223282535272    , 0.156122366208    ,
 0.0909332384841   , 0.0478591848311   , 0.0265117085796   , 0.0173827581483   ,
 0.0126787365838   , 0.00929670096166  , 0.0075339446534   , 0.0097318185428   ,
 0.0197185790398   , 0.0409587755344   , 0.0716580078089   , 0.100760207561    ,
 0.11269513021     , 0.100081110231    , 0.0707623084968   , 0.0403920989379   ,
 0.0198017007486   , 0.010400971101    , 0.00821947472531  , 0.00921344941765  ,
 0.0115952564628   , 0.0155079301444   , 0.0218858802979   , 0.0321678241154   ,
 0.0488284041895   , 0.0748906477083   , 0.111940568546    , 0.159716243072    ,
 0.219683325016    , 0.297255827377    , 0.392936574263    , 0.486657114948    ,
 0.539837725862    , 0.527419520935    , 0.469996159995    , 0.42711376632     ,
 0.457075223433    , 0.582241536635    , 0.782586441455    , 1.00908233646     ,
 1.20000657846     , 1.29870283811     , 1.28079066959     , 1.17642025223     ,
 1.05729611233     , 0.992533711391    , 1.01439705764     , 1.11957423041     ,
 1.29275647142     , 1.52286310865     , 1.79870408133     , 2.1028395644      ,
 2.42390463931     , 2.76818815676     , 3.14325646386     , 3.53764034094     ,
 3.94040891615     , 4.38617630572     , 4.96091606325     , 5.74060781027     ,
 6.71635023322     , 7.78036064705     , 8.78136472129     , 9.59701553823     ,
 10.1807591465     , 10.5801969448     , 10.9298029893     , 11.3967712008     ,
 12.0779025121     , 12.9212563796     , 13.7642515765     , 14.4666509874     ,
 14.994240827      , 15.361551385      , 15.5310014618     , 15.4289620366     ,
 15.0694486098     , 14.6079672754     , 14.2222126614     , 13.9350032548     ,
 13.5743661804     , 12.9176555688     , 11.8766311077     , 10.5566693861     ,
 9.17090235242     , 7.92309102814     , 6.93847312097     , 6.22072621511     ,
 5.63652174172     , 4.99616392615     , 4.20861814177     , 3.35339310166     ,
 2.58826713746     , 2.01152946314     , 1.62022192039     , 1.35561891258     ,
 1.15247783576     , 0.964585594868    , 0.778888364617    , 0.611490318367    ,
 0.481566459887    , 0.388876107955    , 0.317211761559    , 0.254272248687    ,
 0.203568179597    , 0.177051119552    , 0.178529594768    , 0.195351823508    ,
 0.205249495261    , 0.191894711627    , 0.156490053991    , 0.115041461994    ,
 0.0838849961575   , 0.0681575703753   , 0.0627654528289   , 0.0606957662285   ,
 0.0584513034894   , 0.0553612080369   , 0.0514563539021   , 0.0482726974767   ,
 0.0502587777826   , 0.0623881161182   , 0.0858329594673   , 0.118283392802    ,
 0.16008445937     , 0.217448447433    , 0.294736330808    , 0.382673531334    ,
 0.458088702898    , 0.498310111493    , 0.497213883045    , 0.46997317882     ,
 0.443866800227    , 0.441636715856    , 0.468565103583    , 0.512833374523    ,
 0.559807264269    , 0.607648911572    , 0.667255506761    , 0.746143607849    ,
 0.837483979625    , 0.930467720408    , 1.02712750766     , 1.13759754645     ,
 1.25730462235     , 1.3605065909      , 1.42196805193     , 1.43546478777     ,
 1.4048561704      , 1.32948260351     , 1.21196468449     , 1.07392177092     ,
 0.950044116124    , 0.864116403638    , 0.812838783388    , 0.770767817551    ,
 0.709467641077    , 0.615041443067    , 0.493873693174    , 0.367345073961    ,
 0.165662387022    , 0.116768742752    , 0.100317213965    , 0.103771376193    ,
 0.112193405178    , 0.114046788083    , 0.103833784864    , 0.0829753665752   ,
 0.0586021175319   , 0.0392101618549   , 0.0294243234088   , 0.0285722175474   ,
 0.0346940872328   , 0.0497123951431   , 0.0785011707623   , 0.119518759357    ,
 0.156879725752    , 0.168162651559    , 0.144544397165    , 0.0999889971236   ,
 0.0578857316087   , 0.032127331095    , 0.0220605178729   , 0.019835887178    ,
 0.0185664402767   , 0.0157130448146   , 0.0125340811758   , 0.0122490498544   ,
 0.0187731121249   , 0.0351220323808   , 0.0596811134527   , 0.0831380227847   ,
 0.0925496173549   , 0.0819128937923   , 0.0579586961254   , 0.0339390946319   ,
 0.0190025041779   , 0.0139959741604   , 0.014468572579    , 0.015471683877    ,
 0.0147246458386   , 0.013309990603    , 0.0144795066153   , 0.022337615301    ,
 0.041184181985    , 0.0741908089207   , 0.12093339591     , 0.176560897868    ,
 0.235486005412    , 0.296273387836    , 0.35872759306     , 0.412686806827    ,
 0.43589906092     , 0.414026815748    , 0.36397703026     , 0.330476773561    ,
 0.357444360941    , 0.462619289958    , 0.632530929119    , 0.831197916048    ,
 1.00973061474     , 1.11749848659     , 1.12476105509     , 1.04637805152     ,
 0.937628445799    , 0.860327159945    , 0.852560635533    , 0.924806089352    ,
 1.07281224223     , 1.28775008        , 1.55877842871     , 1.87809761853     ,
 2.24961201436     , 2.68216596221     , 3.1638092056      , 3.65410879852     ,
 4.12325237714     , 4.60467287876     , 5.19583204748     , 5.98729760041     ,
 6.97709886701     , 8.04854738568     , 9.02972679967     , 9.78454069851     ,
 10.2792881901     , 10.6069551395     , 10.9646338633     , 11.5633438539     ,
 12.4883689191     , 13.6181394918     , 14.7041069311     , 15.5585614963     ,
 16.1590990882     , 16.5577610337     , 16.7244153179     , 16.5476440088     ,
 16.0090697462     , 15.301628825      , 14.7090848837     , 14.3466693575     ,
 14.0344005118     , 13.4439450077     , 12.3808003752     , 10.9346803765     ,
 9.38692413804     , 8.01468688213     , 6.96811295608     , 6.23663634458     ,
 5.66307801444     , 5.03638147555     , 4.24996332913     , 3.38102522763     ,
 2.59848047769     , 2.01165051148     , 1.61879604807     , 1.35857359544     ,
 1.1666391225      , 0.99644170976     , 0.826835282928    , 0.663472150429    ,
 0.523248944107    , 0.413102752857    , 0.325622139237    , 0.252533899455    ,
 0.196744829731    , 0.168180061435    , 0.168850384683    , 0.184416211158    ,
 0.191678428927    , 0.17540483678     , 0.139197016714    , 0.100224555297    ,
 0.0733858714555   , 0.0608425427569   , 0.0552275668218   , 0.0495825902777   ,
 0.0426454015216   , 0.0366510683895   , 0.0337739761578   , 0.0363351463727   ,
 0.048446128779    , 0.0742129951027   , 0.113370422146    , 0.161126648669    ,
 0.215356810097    , 0.282425852739    , 0.369928712408    , 0.471198011751    ,
 0.561217798341    , 0.612081267801    , 0.613594474004    , 0.580216886597    ,
 0.539750049741    , 0.514426498379    , 0.509355886397    , 0.516024822165    ,
 0.526523015885    , 0.544814469412    , 0.582880159229    , 0.645327189675    ,
 0.721577302865    , 0.798064388396    , 0.875601066925    , 0.965130689722    ,
 1.06390994369     , 1.14630519176     , 1.18594625992     , 1.18046447958     ,
 1.14541043236     , 1.08921272906     , 1.00720658007     , 0.900419106272    ,
 0.788126004607    , 0.695811242553    , 0.633551796089    , 0.587983758818    ,
 0.534105483389    , 0.45492250522     , 0.353240252982    , 0.248950365946    ,
 0.100924371854    , 0.072323400067    , 0.0685592031656   , 0.0785682443273   ,
 0.0890751727137   , 0.0904304338886   , 0.0798148872998   , 0.0607816117834   ,
 0.0401211584418   , 0.0239545019007   , 0.0149881567668   , 0.0125210555289   ,
 0.0150919544423   , 0.0232561112362   , 0.0390244539966   , 0.0610889545588   ,
 0.0809159748733   , 0.0869081506808   , 0.0748362338917   , 0.0525857110808   ,
 0.0331274069958   , 0.0241899289928   , 0.0247495508737   , 0.0286000523203   ,
 0.029928234197    , 0.0269188474806   , 0.0216656339613   , 0.017772832446    ,
 0.0186370563565   , 0.0265670156946   , 0.0406722399952   , 0.0548605111722   ,
 0.0605156204247   , 0.0536081985778   , 0.038701705217    , 0.0249626915353   ,
 0.0188937740255   , 0.0207384588625   , 0.0257685997262   , 0.028205145157    ,
 0.0254079687879   , 0.0196350915652   , 0.016427607026    , 0.0221682592378   ,
 0.0428252953748   , 0.0822283761128   , 0.138514172016    , 0.202136879965    ,
 0.260332932803    , 0.305797058053    , 0.338895891831    , 0.35872867344     ,
 0.356533679715    , 0.326144505651    , 0.281031059736    , 0.254093372113    ,
 0.277905216831    , 0.365548331266    , 0.506433339985    , 0.673377895184    ,
 0.829732434691    , 0.935426680624    , 0.962300298147    , 0.91474178054     ,
 0.831355519624    , 0.761409539019    , 0.741171386867    , 0.788632493989    ,
 0.909211619396    , 1.10163910114     , 1.3651858211      , 1.70871111163     ,
 2.14815734229     , 2.68156577643     , 3.26390886457     , 3.82397906014     ,
 4.3255609038      , 4.81605359879     , 5.40602335589     , 6.18681493617     ,
 7.15245207326     , 8.188058363       , 9.13039154502     , 9.85672160303     ,
 10.3536410896     , 10.741882883      , 11.2421016481     , 12.0640016179     ,
 13.2548877918     , 14.6296113017     , 15.8805370694     , 16.7964911099     ,
 17.3762050343     , 17.7126910241     , 17.7984554301     , 17.512938082      ,
 16.8205180728     , 15.9239430848     , 15.1537976627     , 14.6775125886     ,
 14.3252089751     , 13.7262571403     , 12.6358555939     , 11.1339517794     ,
 9.52842185926     , 8.11531610653     , 7.03381430074     , 6.25626271051     ,
 5.63187952978     , 4.97237264639     , 4.18057381312     , 3.32177379712     ,
 2.55137560409     , 1.97711593575     , 1.6005339574      , 1.35993752387     ,
 1.18821054934     , 1.03514507672     , 0.873766665028    , 0.704975452414    ,
 0.547830487214    , 0.41754001301     , 0.31438107137     , 0.232787825427    ,
 0.174004549541    , 0.144677345033    , 0.144241075951    , 0.157631144081    ,
 0.162943008015    , 0.147277829083    , 0.115473739268    , 0.0834187648108   ,
 0.0631987218073   , 0.0547460964761   , 0.0501754363838   , 0.0435283039115   ,
 0.0352061026912   , 0.0289112804872   , 0.0276651682135   , 0.0340469089952   ,
 0.0523082060783   , 0.0871909615881   , 0.139129993806    , 0.202355261738    ,
 0.271501729279    , 0.35007946897     , 0.44655477206     , 0.558208716991    ,
 0.662121105932    , 0.726674126481    , 0.733760794971    , 0.691325496579    ,
 0.62618083251     , 0.564793064885    , 0.518988275364    , 0.487356955084    ,
 0.467937208042    , 0.467433565322    , 0.496373324389    , 0.555139459845    ,
 0.628348018645    , 0.698494267035    , 0.764525538967    , 0.838251885685    ,
 0.918759942209    , 0.980080033241    , 0.994283488103    , 0.962718209003    ,
 0.912897907551    , 0.86428110344     , 0.809458526005    , 0.733336680794    ,
 0.639286204064    , 0.548084974766    , 0.476469769985    , 0.422669844478    ,
 0.370983124171    , 0.307320495544    , 0.231449026776    , 0.156997281467    ,
 0.0622536004655   , 0.0480967309016   , 0.0493950895752   , 0.0587133215096   ,
 0.0664012450838   , 0.0654497205975   , 0.0549806967749   , 0.0393319094619   ,
 0.0241237264441   , 0.0130253426991   , 0.00689602794813  , 0.00474886646376  ,
 0.0054224653919   , 0.00879982104396  , 0.0154696790976   , 0.0247249151354   ,
 0.0330085216328   , 0.0356734463452   , 0.0313030793944   , 0.0237422027297   ,
 0.0191950556197   , 0.0214293586619   , 0.0292490381552   , 0.0376102175382   ,
 0.0414681455983   , 0.0393541110382   , 0.0334048593302   , 0.0267387456423   ,
 0.021952182285    , 0.0211004272188   , 0.0246168426079   , 0.0297323359282   ,
 0.031767492379    , 0.0283313076305   , 0.0219434362878   , 0.0181106288449   ,
 0.0209742732544   , 0.030110113195    , 0.0402761804368   , 0.0447079816061   ,
 0.0403518674601   , 0.0305545396712   , 0.0230015010206   , 0.0262166137111   ,
 0.0476247981133   , 0.0911708079564   , 0.152777798702    , 0.2183705602      ,
 0.270659981025    , 0.301034557911    , 0.313250242689    , 0.313288260483    ,
 0.299238566323    , 0.267484545716    , 0.228214821342    , 0.207961957078    ,
 0.23343146386     , 0.313654886955    , 0.436537961411    , 0.577985970969    ,
 0.710010864236    , 0.803314788632    , 0.835990601236    , 0.809865213738    ,
 0.753540710476    , 0.704225211937    , 0.690070188852    , 0.728168585392    ,
 0.829205976409    , 1.00154944365     , 1.25940107503     , 1.62908626586     ,
 2.13280586601     , 2.750395556       , 3.40239453986     , 3.99457800091     ,
 4.49703249095     , 4.97967119252     , 5.56272483699     , 6.3254319867      ,
 7.2505357523      , 8.23660174993     , 9.15394670038     , 9.91156427819     ,
 10.5154693453     , 11.0947426606     , 11.8601667164     , 12.9816824499     ,
 14.4442608865     , 16.0040302745     , 17.3206628815     , 18.1849849945     ,
 18.6298813238     , 18.7998220556     , 18.7337837463     , 18.3348679422     ,
 17.5590564082     , 16.5740100975     , 15.6774094517     , 15.0387639774     ,
 14.5262723298     , 13.8141045386     , 12.6827066489     , 11.2097871622     ,
 9.67501886457     , 8.32582480917     , 7.24981981605     , 6.39808123193     ,
 5.65306156044     , 4.89299411863     , 4.0650166483      , 3.22755244023     ,
 2.50274197791     , 1.97452330849     , 1.63602471361     , 1.42101378661     ,
 1.25846306275     , 1.09838346083     , 0.917882209461    , 0.723496055105    ,
 0.540844211549    , 0.391345711828    , 0.278577962637    , 0.196236927837    ,
 0.141846657853    , 0.117526113027    , 0.119738804941    , 0.133327496708    ,
 0.138583239638    , 0.12496584817     , 0.097661483886    , 0.0706843603865   ,
 0.0540997370554   , 0.0476155523462   , 0.0446879399048   , 0.0406453281261   ,
 0.036028460723    , 0.0337310329679   , 0.035851319078    , 0.0445151929018   ,
 0.0643484548347   , 0.10167158888     , 0.159189574737    , 0.231917638956    ,
 0.311848774421    , 0.397893423278    , 0.496647373933    , 0.609176357898    ,
 0.718511912124    , 0.793606441004    , 0.808338099       , 0.760036483856    ,
 0.672035136814    , 0.577829681628    , 0.500902602968    , 0.448043925639    ,
 0.418940133453    , 0.417411774249    , 0.4499589246      , 0.513748717372    ,
 0.591040395761    , 0.662267510927    , 0.724587608622    , 0.788580271707    ,
 0.852496640734    , 0.889816123811    , 0.87391217556     , 0.811913972113    ,
 0.741055409798    , 0.688336191416    , 0.645151032051    , 0.587021611812    ,
 0.50667555688     , 0.419207961374    , 0.342896424637    , 0.28359426714     ,
 0.234787269475    , 0.187246780996    , 0.138333509371    , 0.0938395837524   ,
 0.047099405814    , 0.0402260564063   , 0.0401010659591   , 0.0438651080711   ,
 0.0463333637633   , 0.0431430762765   , 0.0341015721696   , 0.022717257555    ,
 0.0128362864299   , 0.00627304124283  , 0.0028535131324   , 0.00157799695878  ,
 0.00160806867093  , 0.00267954600215  , 0.00488566730811  , 0.00797394108306  ,
 0.0108529213507   , 0.0121812026449   , 0.0117821905323   , 0.0113772181342   ,
 0.0137002351246   , 0.0205486011658   , 0.030989321174    , 0.0412914719006   ,
 0.047449977993    , 0.0480410493105   , 0.0440894884221   , 0.0370481196866   ,
 0.0284880446128   , 0.0208794117134   , 0.0164490391187   , 0.0150815529761   ,
 0.0145948566367   , 0.013449283962    , 0.0128227735051   , 0.0159980370072   ,
 0.0255993333614   , 0.040496200745    , 0.0547927836663   , 0.06098419129     ,
 0.0557306189524   , 0.0429511451457   , 0.0317117278237   , 0.0323105281888   ,
 0.0535194333268   , 0.0989915455383   , 0.161956718019    , 0.224488276931    ,
 0.267402244736    , 0.284107812729    , 0.283048505533    , 0.27474094791     ,
 0.259424765703    , 0.23244558312     , 0.201045466474    , 0.188995117764    ,
 0.220307313652    , 0.299787657405    , 0.410947587349    , 0.529699073429    ,
 0.634798840581    , 0.70747541578     , 0.734694764845    , 0.721390374754    ,
 0.692191320631    , 0.6751855304      , 0.68886238729     , 0.74439983907     ,
 0.851640617591    , 1.02311662039     , 1.28260090926     , 1.66799439606     ,
 2.20462281584     , 2.85957650118     , 3.53356647545     , 4.12430049542     ,
 4.61310674221     , 5.08661372929     , 5.66658887276     , 6.41696605085     ,
 7.31244478712     , 8.27336503538     , 9.21270853028     , 10.0737214881     ,
 10.8743075362     , 11.7374490272     , 12.8460486134     , 14.3117860832     ,
 16.0474338802     , 17.7581738792     , 19.0900327052     , 19.8482999862     ,
 20.1000786208     , 20.0435075635     , 19.7829796079     , 19.2736663691     ,
 18.4735086974     , 17.4844325453     , 16.5100530214     , 15.6757991069     ,
 14.8987271958     , 13.9608328033     , 12.732688949      , 11.3076679424     ,
 9.9050605624      , 8.67703029244     , 7.63003530856     , 6.68755158086     ,
 5.77704953685     , 4.86802723617     , 3.97821671245     , 3.16958987081     ,
 2.51846086133     , 2.06140420533     , 1.76641489629     , 1.56004561606     ,
 1.37505638219     , 1.17392065939     , 0.949400603018    , 0.719164644075    ,
 0.512843217132    , 0.351616997462    , 0.237464559439    , 0.16144166462     ,
 0.116953017325    , 0.101563240374    , 0.108986091057    , 0.124322303105    ,
 0.130046138081    , 0.117402014363    , 0.0914571854892   , 0.0648893915699   ,
 0.0473705799809   , 0.040322792625    , 0.0397516885791   , 0.0419891359406   ,
 0.0459986258916   , 0.0517085226102   , 0.0588741316703   , 0.0688985417339   ,
 0.0870917785699   , 0.121398863016    , 0.176506874547    , 0.248400266235    ,
 0.327391299344    , 0.408436658062    , 0.495782699567    , 0.594142298081    ,
 0.694875465631    , 0.771835278358    , 0.793887039823    , 0.747371866966    ,
 0.650054119283    , 0.541443710562    , 0.45663018022     , 0.408763098637    ,
 0.3943379109      , 0.408963290957    , 0.452887564962    , 0.522165154212    ,
 0.601492869719    , 0.673607188181    , 0.734898678304    , 0.792039291345    ,
 0.83954665555     , 0.851353156215    , 0.806206157905    , 0.718203882101    ,
 0.629212151889    , 0.567413334826    , 0.523095911474    , 0.46930893376     ,
 0.395182864821    , 0.312174458676    , 0.237346606323    , 0.179521166312    ,
 0.137741160924    , 0.106458573951    , 0.0812336740894   , 0.061091980896    ,
 0.050840317311    , 0.0446688003098   , 0.0384678438052   , 0.0340763652145   ,
 0.0306046712587   , 0.0257568030328   , 0.0189208915947   , 0.0117363943153   ,
 0.0061140294666   , 0.0027081658433   , 0.00107088635501  , 0.000469925314893 ,
 0.000397863545392 , 0.000666712078002 , 0.00128641423075  , 0.00227428951132  ,
 0.00355433141084  , 0.00506574847364  , 0.00695816459415  , 0.00967665261246  ,
 0.0139442084623   , 0.0204672196988   , 0.0290622202583   , 0.038050996532    ,
 0.0452209077808   , 0.049206704573    , 0.0491690447602   , 0.0441682571636   ,
 0.0346162834224   , 0.0236105884363   , 0.0150389047333   , 0.0105203481227   ,
 0.00903992036752  , 0.00924529799505  , 0.0116240289621   , 0.0185442218474   ,
 0.0319080335959   , 0.0499594367986   , 0.066337202486    , 0.0734651027065   ,
 0.0680623954814   , 0.0539111259606   , 0.0402234368549   , 0.0383019258274   ,
 0.0582337394598   , 0.103995242003    , 0.167517506601    , 0.228794992046    ,
 0.267355603483    , 0.276935588353    , 0.267824241875    , 0.253451201386    ,
 0.236653280483    , 0.213137422536    , 0.188222478009    , 0.183064436082    ,
 0.218438199886    , 0.294383141144    , 0.39020993877     , 0.482611699478    ,
 0.557631684725    , 0.607268365781    , 0.627920793055    , 0.628466093901    ,
 0.63068918012     , 0.65599485024     , 0.716561783885    , 0.818489329827    ,
 0.965826885539    , 1.16476200782     , 1.43600356122     , 1.81978382257     ,
 2.34533033451     , 2.98139885852     , 3.63124237456     , 4.20018156949     ,
 4.67873329973     , 5.1563489962      , 5.74764725071     , 6.50508134652     ,
 7.40260308292     , 8.38375710742     , 9.4012198707      , 10.4288878009     ,
 11.4900687806     , 12.6898447082     , 14.1710683018     , 15.984005784      ,
 17.980421778      , 19.8356352252     , 21.198415671      , 21.8850432088     ,
 21.9749350861     , 21.7004503703     , 21.2332645614     , 20.6019090024     ,
 19.7892143931     , 18.8365379514     , 17.8317220218     , 16.8190402442     ,
 15.7399069335     , 14.4915338135     , 13.065269364      , 11.598763304      ,
 10.2623729221     , 9.11170153592     , 8.06811791595     , 7.02348647575     ,
 5.94459447996     , 4.88760903791     , 3.94134899475     , 3.17295963688     ,
 2.60744007747     , 2.22219816845     , 1.95293247322     , 1.72395603404     ,
 1.485066304       , 1.22362260972     , 0.953245271995    , 0.699200140642    ,
 0.486186266846    , 0.327028936428    , 0.218904782857    , 0.151153451013    ,
 0.115179885817    , 0.105609068743    , 0.114434328203    , 0.127820049273    ,
 0.130961053099    , 0.116882591536    , 0.0902122815068   , 0.0622711999437   ,
 0.0428101964186   , 0.0355430196943   , 0.0392098480527   , 0.050615496732    ,
 0.0659715925548   , 0.0810773466295   , 0.0930452740884   , 0.103287818645    ,
 0.118589623945    , 0.147974096933    , 0.195997488557    , 0.257681327434    ,
 0.322057182219    , 0.382715939311    , 0.443802679689    , 0.513903390081    ,
 0.592377610847    , 0.659882251767    , 0.684764706308    , 0.646322909211    ,
 0.556606118814    , 0.456801417109    , 0.388314303613    , 0.367056755478    ,
 0.3841317909      , 0.424929776439    , 0.482139866881    , 0.551639609896    ,
 0.623899407083    , 0.687721789933    , 0.740643390136    , 0.785438543795    ,
 0.813516261248    , 0.802352167705    , 0.739248797955    , 0.643608658976    ,
 0.554220904435    , 0.492192075861    , 0.444700428825    , 0.387318282097    ,
 0.31252049303     , 0.232271827939    , 0.16241589269     , 0.111598139493    ,
 0.0804394943089   , 0.0646930223574   , 0.0582200722469   , 0.05502133198     ,
 0.0659128189752   , 0.055755579157    , 0.0414094160168   , 0.0287820021554   ,
 0.0200986442911   , 0.014131225016    , 0.0093114628206   , 0.00535528619395  ,
 0.00259693781707  , 0.00105726450702  , 0.000371205720644 , 0.0001313821423   ,
 9.00478414448e-05 , 0.000170906507097 , 0.000444122781639 , 0.00115523696876  ,
 0.00276730530189  , 0.00580028356277  , 0.0102977841404   , 0.0153834357874   ,
 0.0198151847378   , 0.023284110234    , 0.0267422951006   , 0.0312562160888   ,
 0.0369696514393   , 0.0428031085106   , 0.0462644004906   , 0.0444189518353   ,
 0.0366924761834   , 0.0263247294899   , 0.0178934065611   , 0.0137080306954   ,
 0.013026633589    , 0.0142121525818   , 0.0173347185195   , 0.0247016620814   ,
 0.0383097214759   , 0.0562792257093   , 0.0722736423926   , 0.0792512454156   ,
 0.0742226222692   , 0.0602521305927   , 0.0455721980317   , 0.0414946900336   ,
 0.0592324754275   , 0.104427607459    , 0.170681757759    , 0.238460258118    ,
 0.284704317078    , 0.297704697753    , 0.283701403526    , 0.258096551256    ,
 0.230541351329    , 0.202047746956    , 0.177560978104    , 0.173611913435    ,
 0.205415090038    , 0.268768144832    , 0.342018059012    , 0.405618462545    ,
 0.453468870086    , 0.486940950229    , 0.509397728357    , 0.530379156205    ,
 0.566607409981    , 0.634842223365    , 0.747014585106    , 0.909051327001    ,
 1.11777936328     , 1.36463711374     , 1.65561416657     , 2.02468442892     ,
 2.50617947533     , 3.08384723483     , 3.68220839842     , 4.22544590543     ,
 4.70960468639     , 5.21524810523     , 5.84402392332     , 6.64058398671     ,
 7.5809962295      , 8.62702858313     , 9.76584781032     , 11.0044133861     ,
 12.3727871434     , 13.9452065775     , 15.8040592484     , 17.9339361914     ,
 20.1487937435     , 22.1299824411     , 23.552144764      , 24.2366282064     ,
 24.2428869971     , 23.8004184107     , 23.1315126747     , 22.3505637526     ,
 21.4964016663     , 20.5801671943     , 19.5839316508     , 18.4506595613     ,
 17.1056667832     , 15.524810263      , 13.8088239448     , 12.159553637      ,
 10.7385683367     , 9.54517547535     , 8.44043159835     , 7.28779045947     ,
 6.07534518366     , 4.91534148927     , 3.94165545259     , 3.21760943246     ,
 2.72182180613     , 2.38130581193     , 2.10804136467     , 1.83318690614     ,
 1.53135273918     , 1.21749470893     , 0.922606738927    , 0.672028649226    ,
 0.477333234816    , 0.337107581204    , 0.241731265886    , 0.180364155781    ,
 0.145658330808    , 0.132287811286    , 0.13250185685     , 0.135029349046    ,
 0.12922236812     , 0.110741625761    , 0.0835331110199   , 0.0565259324555   ,
 0.0383609114337   , 0.0340590860308   , 0.0443658320206   , 0.0659976007475   ,
 0.0920322993639   , 0.114265162696    , 0.128170190419    , 0.136768832717    ,
 0.149334797192    , 0.175132077537    , 0.215938986523    , 0.263345636241    ,
 0.305325164512    , 0.337231538769    , 0.366044590098    , 0.403636143412    ,
 0.454066396563    , 0.503601493502    , 0.524161077785    , 0.4942978573      ,
 0.422265603497    , 0.345971959502    , 0.305948232712    , 0.317581304956    ,
 0.368025076826    , 0.434768740499    , 0.503187738618    , 0.567689829021    ,
 0.623625833736    , 0.66648743767     , 0.697352138464    , 0.71909484867     ,
 0.724744657964    , 0.698980079797    , 0.638059679121    , 0.562499514033    ,
 0.500083283263    , 0.456632029347    , 0.412256519915    , 0.347536104427    ,
 0.264828652827    , 0.182346563821    , 0.116558147782    , 0.0742344947604   ,
 0.0546207143203   , 0.0526335454582   , 0.0600181640018   , 0.0669473793737   ,
 0.0822727247115   , 0.0661320117553   , 0.0444662964964   , 0.0259036631092   ,
 0.014016529024    , 0.00761282640562  , 0.0041942617975   , 0.00219139463311  ,
 0.00101272930862  , 0.000401106122747 , 0.00013678374081  , 4.51214290306e-05 ,
 3.61833995078e-05 , 0.00012371789881  , 0.000501405930923 , 0.00172012774367  ,
 0.00478864088926  , 0.010693931776    , 0.0190950278683   , 0.0273478109893   ,
 0.0318359938929   , 0.0311927305426   , 0.0278294728596   , 0.0258213714926   ,
 0.0276570759357   , 0.0327057294036   , 0.0376861301308   , 0.0388802262801   ,
 0.035202364541    , 0.0292670357907   , 0.0250200247365   , 0.0244391119275   ,
 0.0263805318846   , 0.0283626548284   , 0.0298550695946   , 0.0336674613868   ,
 0.0430215247977   , 0.0570694650397   , 0.0702475128373   , 0.0762291067151   ,
 0.0720703697455   , 0.0596801277957   , 0.0456740926414   , 0.0405161720292   ,
 0.0560475379798   , 0.100493008825    , 0.171630646163    , 0.25247731466     ,
 0.316091712863    , 0.340419064506    , 0.3229073908      , 0.280343229446    ,
 0.232810593639    , 0.190833248844    , 0.160223741068    , 0.151070471816    ,
 0.171579813038    , 0.215317957244    , 0.264017788862    , 0.30451598484     ,
 0.337217708411    , 0.36855639237     , 0.403386554595    , 0.447076380832    ,
 0.50970153682     , 0.606577075641    , 0.755357665013    , 0.966726754044    ,
 1.23215214089     , 1.52705668134     , 1.83843844223     , 2.18831691209     ,
 2.61401335245     , 3.12008049886     , 3.66298635533     , 4.19241042503     ,
 4.70751212759     , 5.27307962494     , 5.9749090459      , 6.85240207725     ,
 7.883458513       , 9.0395868267      , 10.334919018      , 11.8138420952     ,
 13.5201783105     , 15.4872152038     , 17.7126976483     , 20.105469658      ,
 22.4627270534     , 24.5101757221     , 25.9787538079     , 26.7008556729     ,
 26.6923625729     , 26.138293584      , 25.2797683443     , 24.3157787171     ,
 23.3660714436     , 22.4448991393     , 21.4549258499     , 20.2447171115     ,
 18.7019934312     , 16.8363856404     , 14.8155416247     , 12.8976167698     ,
 11.2704565317     , 9.92990832656     , 8.71473823227     , 7.46762992695     ,
 6.17564900399     , 4.9669626259      , 3.98612171977     , 3.28463674505     ,
 2.81240502693     , 2.47151253508     , 2.16783469242     , 1.84449164546     ,
 1.49617502137     , 1.15625515943     , 0.864960320691    , 0.643368362288    ,
 0.488168989747    , 0.381906517401    , 0.306063223647    , 0.249317176303    ,
 0.207993326319    , 0.180272099387    , 0.161214729492    , 0.143644619548    ,
 0.122278972995    , 0.0962801501252   , 0.0689103695212   , 0.0456917539057   ,
 0.0325157414814   , 0.0340440658133   , 0.0518470324948   , 0.0821215553534   ,
 0.115167181612    , 0.139857012282    , 0.151595648154    , 0.156424807295    ,
 0.166506242393    , 0.190402793282    , 0.225563055935    , 0.259408577647    ,
 0.279951241517    , 0.286714511781    , 0.290832013493    , 0.305197108079    ,
 0.33348486546     , 0.364240429982    , 0.37504700163     , 0.349187063938    ,
 0.294006632647    , 0.241310384136    , 0.225531219435    , 0.259731321427    ,
 0.33064953689     , 0.413206051251    , 0.487794855523    , 0.545213274924    ,
 0.581561468492    , 0.596716181462    , 0.597139537148    , 0.590989270786    ,
 0.577790520544    , 0.550471183414    , 0.511307993573    , 0.477642936372    ,
 0.462373319514    , 0.452330962428    , 0.417713819167    , 0.344526692669    ,
 0.249009194805    , 0.159822911904    , 0.0954466668031   , 0.0598005073667   ,
 0.0493878932937   , 0.0574674462493   , 0.0735475067056   , 0.0848260833907   ,
 0.0899450064651   , 0.0690647657647   , 0.0435356884841   , 0.022869736723    ,
 0.0104297804605   , 0.00451337121799  , 0.00209647988954  , 0.00110066126503  ,
 0.000606112033449 , 0.000315103038646 , 0.000144241565214 , 6.06397918565e-05 ,
 5.59020468811e-05 , 0.000212073851979 , 0.000892270388044 , 0.00305345905072  ,
 0.00833298083575  , 0.0181034219144   , 0.0313056700601   , 0.0431432762603   ,
 0.0475986804602   , 0.042657789838    , 0.032531764531    , 0.0240723202687   ,
 0.0215256667133   , 0.0245229215904   , 0.0296365631055   , 0.0334085219997   ,
 0.0347967656833   , 0.0354478148759   , 0.0378811664422   , 0.0430648739537   ,
 0.0488542145645   , 0.0512130157596   , 0.0485778180764   , 0.044700455614    ,
 0.0453283335566   , 0.0521254871535   , 0.0610923377673   , 0.0663167118185   ,
 0.0640451546209   , 0.0545014131025   , 0.042545005211    , 0.0374346632562   ,
 0.0509428203017   , 0.0934381077875   , 0.167176890936    , 0.258602773396    ,
 0.337828089194    , 0.373022809642    , 0.352707735953    , 0.294164819885    ,
 0.226976928502    , 0.170985376516    , 0.133085619861    , 0.116981400486    ,
 0.124633578158    , 0.14990586386     , 0.180925948541    , 0.211573184278    ,
 0.245711572086    , 0.288930323679    , 0.341085963004    , 0.399769726013    ,
 0.470099185026    , 0.570976348055    , 0.729748837499    , 0.963621441082    ,
 1.26115534048     , 1.58627394199     , 1.90995691286     , 2.23982112914     ,
 2.6110668978      , 3.04831080097     , 3.54519812851     , 4.08195363149     ,
 4.66011838394     , 5.32391360498     , 6.14122562387     , 7.14997090271     ,
 8.33203744917     , 9.65898740063     , 11.1545125085     , 12.8912606553     ,
 14.9294806526     , 17.2627609118     , 19.7990458758     , 22.3724685439     ,
 24.779288159      , 26.8135285599     , 28.2856856404     , 29.0538830442     ,
 29.0820510271     , 28.4737104781     , 27.4457374094     , 26.2627171295     ,
 25.1364801532     , 24.114168557      , 23.0575532739     , 21.7550881527     ,
 20.0650406457     , 18.0008514401     , 15.7477673719     , 13.5896641425     ,
 11.7489428145     , 10.2497022308     , 8.93491574543     , 7.63193781079     ,
 6.31033156461     , 5.08562789452     , 4.0915078376      , 3.3693699519      ,
 2.8633103728      , 2.47756610911     , 2.12751451563     , 1.7674903052      ,
 1.39992335639     , 1.06216274519     , 0.795365284314    , 0.616229199764    ,
 0.51029339702     , 0.445961862538    , 0.394509070284    , 0.342566574381    ,
 0.290830078908    , 0.2432757242      , 0.199686215528    , 0.157715002765    ,
 0.117481066749    , 0.0816673271233   , 0.053051162419    , 0.0337395195842   ,
 0.0261878072963   , 0.0334408609991   , 0.0568105044009   , 0.0918431527161   ,
 0.127019553291    , 0.149712407509    , 0.156261467182    , 0.15580199478     ,
 0.162686805491    , 0.18414749621     , 0.213750320954    , 0.23645065386     ,
 0.24220910284     , 0.235521375917    , 0.230635254395    , 0.238355570696    ,
 0.257564008033    , 0.275712311439    , 0.275933820227    , 0.248921149487    ,
 0.203603575567    , 0.165553216591    , 0.161013845742    , 0.199885976624    ,
 0.271501913226    , 0.353947284195    , 0.426795769278    , 0.47675063234     ,
 0.496896288208    , 0.48839604109     , 0.463100038146    , 0.436521775224    ,
 0.415488118507    , 0.398421141504    , 0.388995741001    , 0.399291753386    ,
 0.429811913183    , 0.452694771424    , 0.430343952882    , 0.353363046089    ,
 0.249870483945    , 0.157073172836    , 0.0941224152533   , 0.0618822508517   ,
 0.0550852486707   , 0.066671642474    , 0.0851280830951   , 0.0959811687257   ,
 0.0834858611998   , 0.0618330228371   , 0.0373299760197   , 0.0185634505305   ,
 0.00796043814209  , 0.00346711941651  , 0.00205885261078  , 0.0016475444377   ,
 0.00130691418377  , 0.000868176766498 , 0.000460854996066 , 0.000202416170105 ,
 0.000133181390076 , 0.000375977127541 , 0.00147300690878  , 0.00480542713172  ,
 0.0125515842479   , 0.02616727927     , 0.0435164117129   , 0.0577407461935   ,
 0.0612488241304   , 0.0523726821168   , 0.0373270885308   , 0.0249715105296   ,
 0.0202865015332   , 0.022547228313    , 0.0280592483053   , 0.0338687334598   ,
 0.0394680706379   , 0.0460411885024   , 0.0549241531082   , 0.0659536991535   ,
 0.0755705104932   , 0.077685314293    , 0.0694631367737   , 0.0559018914892   ,
 0.0461025713269   , 0.0452020637301   , 0.0511479881513   , 0.0577443242016   ,
 0.0591557074224   , 0.0532506593846   , 0.0434208680361   , 0.0380354383702   ,
 0.0481127582153   , 0.0844151329577   , 0.151912846054    , 0.240681440163    ,
 0.321766522263    , 0.35993331266     , 0.33895550745     , 0.27475692908     ,
 0.200261366063    , 0.13963993921     , 0.100154106127    , 0.0814113229667   ,
 0.0819519827848   , 0.0979052824517   , 0.124151016318    , 0.159932435615    ,
 0.208959537903    , 0.271017632683    , 0.336613441477    , 0.395226363317    ,
 0.451655513261    , 0.533620506372    , 0.679218943672    , 0.910477005736    ,
 1.21406382544     , 1.54798545727     , 1.87280871295     , 2.18176410185     ,
 2.50286106405     , 2.8770740834      , 3.33734827037     , 3.89985469858     ,
 4.57129438652     , 5.37302060703     , 6.35186021073     , 7.54615647899     ,
 8.94519455794     , 10.5120139682     , 12.2543359494     , 14.2460184936     ,
 16.5552907214     , 19.1510722962     , 21.8806645344     , 24.5323351877     ,
 26.9160459548     , 28.8920927447     , 30.3465590558     , 31.1694417848     ,
 31.275875508      , 30.6667144083     , 29.4940788837     , 28.0560042223     ,
 26.6523889437     , 25.3897080624     , 24.1368275067     , 22.6703795889     ,
 20.8417577004     , 18.6557494803     , 16.2821824059     , 13.9990061604     ,
 12.0446274181     , 10.4655724965     , 9.1109337644      , 7.7964635009      ,
 6.47398177816     , 5.24149780488     , 4.21924648902     , 3.44518928225     ,
 2.87189646577     , 2.41974553338     , 2.0207891214      , 1.6386947756      ,
 1.27456402685     , 0.958894208975    , 0.727267099119    , 0.592317753155    ,
 0.533057382382    , 0.508166056983    , 0.480485139925    , 0.434311014865    ,
 0.37394569438     , 0.308794007276    , 0.243304953229    , 0.179587118151    ,
 0.122150173384    , 0.0762840809582   , 0.0444692783026   , 0.0264825923329   ,
 0.0220677881615   , 0.0322899175611   , 0.0574166427841   , 0.0924225585978   ,
 0.125298014639    , 0.143359851357    , 0.14396770106     , 0.137928879024    ,
 0.140254316926    , 0.156862750043    , 0.179521253955    , 0.193588830735    ,
 0.192370814976    , 0.184174786446    , 0.183846831983    , 0.198004318962    ,
 0.219343175136    , 0.23282863954     , 0.225792423708    , 0.195993510062    ,
 0.154993951067    , 0.123462850108    , 0.1196139313      , 0.149514655403    ,
 0.205878734651    , 0.27352883822     , 0.335639011048    , 0.376982896912    ,
 0.386832505599    , 0.365503712321    , 0.328047949188    , 0.294961671634    ,
 0.277124759829    , 0.274218044169    , 0.287657262755    , 0.32450918022     ,
 0.379457914722    , 0.420490859517    , 0.40972347214     , 0.341254627716    ,
 0.246815647326    , 0.163326895554    , 0.106409006246    , 0.0746775340976   ,
 0.0642674831088   , 0.0710157361841   , 0.0850190291751   , 0.0921251745476   ,
 0.0656698591776   , 0.0476574167739   , 0.028242830411    , 0.0140174047541   ,
 0.00665715158869  , 0.00432630536998  , 0.00429897643454  , 0.0044683103978   ,
 0.00387978021109  , 0.0026634096883   , 0.00143259554303  , 0.000621188048241 ,
 0.000323117051155 , 0.000639999520423 , 0.00223232713504  , 0.00677632198862  ,
 0.0166447705124   , 0.0328538947888   , 0.0519975262161   , 0.0659370881072   ,
 0.0670884306816   , 0.0552786681223   , 0.0384656638291   , 0.0262733546313   ,
 0.0232518327465   , 0.0275486681153   , 0.0345212227      , 0.041272396875    ,
 0.0482052507808   , 0.0572251823818   , 0.0696035904353   , 0.0844278737454   ,
 0.096647451768    , 0.0981856473574   , 0.0851594448745   , 0.0638182092847   ,
 0.046398149273    , 0.0413457628505   , 0.0482959560453   , 0.0599508870352   ,
 0.067245194366    , 0.0652407702439   , 0.056525336731    , 0.049281073686    ,
 0.0530966706809   , 0.0769422915957   , 0.126336324253    , 0.195482048736    ,
 0.261521388157    , 0.293911034648    , 0.276750670333    , 0.221916475311    ,
 0.157441882011    , 0.105137793621    , 0.0719213529967   , 0.0570114843734   ,
 0.0593373913464   , 0.0782550372595   , 0.113169479824    , 0.164800456774    ,
 0.233125662451    , 0.310232619502    , 0.378074420481    , 0.421899505058    ,
 0.451045364103    , 0.503764600937    , 0.626215766721    , 0.842038940274    ,
 1.13661714161     , 1.46642272319     , 1.78630528905     , 2.07662551381     ,
 2.35538262027     , 2.67509826314     , 3.10597426821     , 3.703976881       ,
 4.4879774725      , 5.45943308928     , 6.63997019412     , 8.06311303205     ,
 9.72466467138     , 11.5752441664     , 13.5871584646     , 15.8049853332     ,
 18.2891136257     , 21.005227607      , 23.7922964902     , 26.441299011      ,
 28.7865883402     , 30.7253587343     , 32.1817190736     , 33.0651666101     ,
 33.2558491039     , 32.6630308674     , 31.358868433      , 29.6410088431     ,
 27.8749371357     , 26.2393391021     , 24.6542249063     , 22.9305225907     ,
 20.9362880996     , 18.6688976626     , 16.2722236783     , 13.9964686464     ,
 12.0619090767     , 10.504787051      , 9.16767970669     , 7.8642734564      ,
 6.5462507993      , 5.30735751882     , 4.26112345213     , 3.44454356776     ,
 2.81801071873     , 2.31553203971     , 1.88386667645     , 1.49541803299     ,
 1.14888602466     , 0.864926406601    , 0.670169009129    , 0.572393637129    ,
 0.547205242452    , 0.549229532526    , 0.53805774843     , 0.497608638514    ,
 0.434206262101    , 0.35984065661     , 0.281673745061    , 0.204977662674    ,
 0.136895970019    , 0.0836597333147   , 0.0474894333508   , 0.0276654889389   ,
 0.0230785922633   , 0.0331863432487   , 0.0564816220813   , 0.0872296767377   ,
 0.114285188528    , 0.126521506011    , 0.122165006087    , 0.111607163494    ,
 0.108625826572    , 0.118217511692    , 0.132877143344    , 0.14079501292     ,
 0.138649510715    , 0.136090353299    , 0.14605123442     , 0.170859972661    ,
 0.198838279045    , 0.213315490559    , 0.204157346786    , 0.173752843613    ,
 0.135783118335    , 0.107691308736    , 0.101232253932    , 0.118257215509    ,
 0.153485402334    , 0.198660053811    , 0.243260260058    , 0.273688528625    ,
 0.277428509489    , 0.253200402588    , 0.215927113188    , 0.186508563319    ,
 0.175850075159    , 0.182383399935    , 0.204235891582    , 0.244762833836    ,
 0.298730241338    , 0.340193012733    , 0.339299547481    , 0.292829504304    ,
 0.226646371102    , 0.167270831076    , 0.122575462859    , 0.0903054964288   ,
 0.0712480428124   , 0.0670856685034   , 0.0720925213648   , 0.0743634365551   ,
 0.0462002972216   , 0.034069025663    , 0.0209016993152   , 0.0114716749582   ,
 0.0074905110046   , 0.00782481747849  , 0.00984650821495  , 0.0108596154445   ,
 0.00955372374895  , 0.00658060846767  , 0.0035429241546   , 0.0015283069346   ,
 0.000722481864738 , 0.00111246074998  , 0.00337543699873  , 0.00926056203208  ,
 0.0207993049757   , 0.0379015655593   , 0.0558699272205   , 0.0665118804508   ,
 0.0640398629795   , 0.0505788133889   , 0.0350548453329   , 0.0264806021198   ,
 0.0280937060849   , 0.0364857898541   , 0.0454785481297   , 0.0515657494142   ,
 0.0561491848993   , 0.0630102283752   , 0.0747121231835   , 0.0902703304325   ,
 0.103444943114    , 0.104764866531    , 0.0898058513308   , 0.0656327526186   ,
 0.0463782209639   , 0.0426730740996   , 0.0552075790118   , 0.0751362543349   ,
 0.0898621213285   , 0.0919406800969   , 0.0840175431247   , 0.0744715053412   ,
 0.0705294840611   , 0.0776853838412   , 0.101038949888    , 0.140043245214    ,
 0.181723605136    , 0.205221456938    , 0.197482707874    , 0.163694989262    ,
 0.121012036994    , 0.0845184824974   , 0.0612067751002   , 0.0537759510808   ,
 0.0649137243386   , 0.0970114607051   , 0.149973149834    , 0.220521227872    ,
 0.301698034107    , 0.37988134127     , 0.435366282611    , 0.456561723919    ,
 0.459498503605    , 0.488296507572    , 0.590402057407    , 0.788290913271    ,
 1.06846379099     , 1.39015304761     , 1.7061339811      , 1.98644727812     ,
 2.2391046739      , 2.5235945626      , 2.9405336089      , 3.58372055583     ,
 4.49015291567     , 5.64765969233     , 7.04953186015     , 8.71443263304     ,
 10.6402905591     , 12.7696903118     , 15.0383448269     , 17.4446605888     ,
 20.02550072       , 22.7574016256     , 25.5161221506     , 28.1366116274     ,
 30.4791840938     , 32.4381586894     , 33.9258818287     , 34.8494858163     ,
 35.0755079549     , 34.4622967705     , 33.0176454258     , 31.0126108303     ,
 28.8411981674     , 26.7470580513     , 24.7287811389     , 22.666984185      ,
 20.4691787387     , 18.1356040887     , 15.7833938059     , 13.6155325936     ,
 11.7973068751     , 10.3224001371     , 9.02112383043     , 7.72368856026     ,
 6.40502840596     , 5.16890885247     , 4.12627446919     , 3.31013379835     ,
 2.6803246619      , 2.17372042675     , 1.74371431267     , 1.36945016088     ,
 1.04984872535     , 0.798602834623    , 0.634095609716    , 0.559300914293    ,
 0.548874235068    , 0.559173448652    , 0.552816535339    , 0.515951895724    ,
 0.454978460832    , 0.381094253568    , 0.30202450998     , 0.224580546297    ,
 0.156021919024    , 0.101074426733    , 0.0614228192364   , 0.0379596940018   ,
 0.0311819382386   , 0.0397481247867   , 0.059562130778    , 0.0835720870013   ,
 0.102504645448    , 0.108489205152    , 0.100784696745    , 0.0875219972764   ,
 0.0794926477143   , 0.0811313948129   , 0.087654873673    , 0.0914426061407   ,
 0.0917001757892   , 0.0970518056785   , 0.116972168988    , 0.150532474974    ,
 0.184433450152    , 0.201966547646    , 0.194269472194    , 0.165741495768    ,
 0.13114286789     , 0.106268154382    , 0.0986894649218   , 0.106279348567    ,
 0.123423976397    , 0.14628652765     , 0.170854132564    , 0.188235953479    ,
 0.187293648471    , 0.165462574456    , 0.134586751666    , 0.111978830762    ,
 0.106230759123    , 0.114694791124    , 0.133605526582    , 0.164048555372    ,
 0.203184731814    , 0.235192324545    , 0.241743243861    , 0.221599084665    ,
 0.190239323951    , 0.159858439257    , 0.129955693504    , 0.098541329714    ,
 0.0716672933175   , 0.056973297174    , 0.0535274283012   , 0.052505696889    ,
 0.0348368077213   , 0.0279323031833   , 0.0191373597392   , 0.0126144085518   ,
 0.0110542376599   , 0.0141845509389   , 0.018890295436    , 0.0210514289012   ,
 0.0185530532117   , 0.0127838141464   , 0.00688454868652  , 0.00297334528981  ,
 0.00139231769409  , 0.00196540943633  , 0.00537112943953  , 0.0133002497489   ,
 0.0269154388291   , 0.0442394449244   , 0.0590744360795   , 0.0641458324799   ,
 0.0568872219392   , 0.0421970146194   , 0.0291949739757   , 0.0252661714007   ,
 0.0319781913056   , 0.0445609167957   , 0.0553297163203   , 0.0596944732961   ,
 0.0596322950632   , 0.0611178736717   , 0.0688375438915   , 0.082440135458    ,
 0.0951705628436   , 0.0970893091778   , 0.0837098766417   , 0.0620517657373   ,
 0.0463456250548   , 0.0479074142923   , 0.0679405283417   , 0.0963741903077   ,
 0.11802705082     , 0.124162877845    , 0.118237208091    , 0.108470865709    ,
 0.0986108158798   , 0.0899993289965   , 0.0877938984581   , 0.0978286809874   ,
 0.11789665746     , 0.136906803109    , 0.143686262346    , 0.134925229568    ,
 0.115224956619    , 0.0927555992248   , 0.0764961518437   , 0.0756166412096   ,
 0.0983133569266   , 0.148605977417    , 0.222436261969    , 0.307447983033    ,
 0.387985917509    , 0.449457833034    , 0.480374165007    , 0.48009291419     ,
 0.469937375972    , 0.490527376097    , 0.581922516697    , 0.763906058716    ,
 1.02835198537     , 1.34226335268     , 1.65983130845     , 1.94376287054     ,
 2.19422595368     , 2.47526089246     , 2.90920525497     , 3.61833653898     ,
 4.65528493309     , 5.99733368621     , 7.60928322098     , 9.48940125947     ,
 11.6375237369     , 14.0018425463     , 16.4983538064     , 19.0803701972     ,
 21.7473026778     , 24.4789506557     , 27.197117193      , 29.792682317      ,
 32.1502080551     , 34.1453282598     , 35.6579896762     , 36.5814567725     ,
 36.7819810216     , 36.100631004      , 34.5013197271     , 32.2127077019     ,
 29.6254201931     , 27.0347268616     , 24.5299865505     , 22.0836627363     ,
 19.6623050319     , 17.2795258212     , 15.0198299869     , 13.0152321287     ,
 11.3484194865     , 9.95973586083     , 8.6794504009      , 7.37537370998     ,
 6.0586505238      , 4.84472308159     , 3.83911919681     , 3.06759007538     ,
 2.48426177121     , 2.02074523322     , 1.62854168541     , 1.28888708812     ,
 1.00198843979     , 0.778744203779    , 0.632566039045    , 0.563218570392    ,
 0.546864443799    , 0.546446869207    , 0.532498923938    , 0.494805804179    ,
 0.437852891484    , 0.369915530023    , 0.298525232433    , 0.230983653394    ,
 0.172079665194    , 0.122291148137    , 0.0819679449803   , 0.0551057578841   ,
 0.0460042632922   , 0.0535851131366   , 0.0707121066753   , 0.0883151880579   ,
 0.0993185359684   , 0.10004417592     , 0.0908074114413   , 0.0762848098518   ,
 0.0633666945736   , 0.0564607505961   , 0.0547663564729   , 0.055311708782    ,
 0.0590126394287   , 0.072213794503    , 0.100320571184    , 0.139639479341    ,
 0.17647539138     , 0.195089681026    , 0.187899380112    , 0.160529213621    ,
 0.128417339546    , 0.106672007993    , 0.100444191876    , 0.104219096344    ,
 0.110160993646    , 0.115720077522    , 0.121891981077    , 0.125965439931    ,
 0.120767571096    , 0.103263309075    , 0.0806205327646   , 0.0644708578659   ,
 0.0605595941196   , 0.0665751729803   , 0.0790490844551   , 0.0980860772356   ,
 0.12260790728     , 0.144649301371    , 0.154925066434    , 0.153292123161    ,
 0.146733847067    , 0.137166846788    , 0.119288327876    , 0.0918423360214   ,
 0.0635883379367   , 0.0450451493129   , 0.0384011232016   , 0.0374469129895   ,
 0.0345456795211   , 0.0306440123527   , 0.0232163061597   , 0.0170501546426   ,
 0.0163656310393   , 0.0216511637929   , 0.0289005226852   , 0.0321729496688   ,
 0.0283368889212   , 0.0195209863798   , 0.01051635158     , 0.0045650248536   ,
 0.00222142555705  , 0.00324435640864  , 0.00849411036415  , 0.0197129993217   ,
 0.036923774193    , 0.0555520584157   , 0.0672923868668   , 0.0659059149191   ,
 0.0526995283687   , 0.0357453260202   , 0.024182230204    , 0.0234303610146   ,
 0.0334435589121   , 0.0486941616836   , 0.0606420548392   , 0.0635591492925   ,
 0.0592139709208   , 0.0550393375616   , 0.0576905507082   , 0.0678502203698   ,
 0.0791712870059   , 0.0823937885685   , 0.0733314003872   , 0.0578286959433   ,
 0.0482767326514   , 0.0552682083298   , 0.0803848269523   , 0.113481153051    ,
 0.138692271263    , 0.147550173886    , 0.144614241135    , 0.137282890917    ,
 0.125434788145    , 0.106815344799    , 0.0874913903679   , 0.079516472677    ,
 0.0894542936324   , 0.112673551783    , 0.137105435442    , 0.15051427089     ,
 0.147006319747    , 0.130882521075    , 0.115635324245    , 0.118148204421    ,
 0.151555501489    , 0.219104964965    , 0.309816676742    , 0.400670440066    ,
 0.468552494327    , 0.502567261975    , 0.506030632599    , 0.492978214648    ,
 0.486695011774    , 0.516215589087    , 0.608250091689    , 0.779680532239    ,
 1.03143311929     , 1.34252205621     , 1.67165115757     , 1.97650426979     ,
 2.25161743921     , 2.56538861126     , 3.05491180627     , 3.85787797468     ,
 5.03146061946     , 6.53996215704     , 8.32350089445     , 10.3643875801     ,
 12.6716991936     , 15.217081102      , 17.9217910649     , 20.7073188437     ,
 23.5228299348     , 26.318655277      , 29.0272311414     , 31.5731782609     ,
 33.8695525728     , 35.8051747487     , 37.2644979445     , 38.141856128      ,
 38.2972423907     , 37.5475628634     , 35.809632471      , 33.2612575308     ,
 30.2782738942     , 27.2026971774     , 24.2170874486     , 21.3923150005     ,
 18.7625178075     , 16.3577234424     , 14.2191684046     , 12.3889950036     ,
 10.8581759429     , 9.52565627641     , 8.24481029594     , 6.93480291474     ,
 5.63890317314     , 4.47208106863     , 3.52691118934     , 2.82145956037     ,
 2.30587208551     , 1.9059324027      , 1.56765881502     , 1.27055050369     ,
 1.01546855225     , 0.813045443113    , 0.674290468549    , 0.596892527748    ,
 0.559925074625    , 0.535775574815    , 0.505391125477    , 0.462177000917    ,
 0.406958955013    , 0.344080685325    , 0.281278022897    , 0.226711310301    ,
 0.181936958064    , 0.14165130016     , 0.103615523156    , 0.0747586717763   ,
 0.0640609565052   , 0.0718201623301   , 0.0884363716535   , 0.102734305071    ,
 0.109353091089    , 0.108082738225    , 0.0994484473232   , 0.0841892024754   ,
 0.0656873679826   , 0.0493116259902   , 0.0388906542965   , 0.0359541591915   ,
 0.042700334406    , 0.0630367679395   , 0.098124822604    , 0.14086197698     ,
 0.176572793382    , 0.191001409243    , 0.179399871151    , 0.149896064857    ,
 0.118762787056    , 0.100156351507    , 0.0971213559926   , 0.101331240303    ,
 0.102300785309    , 0.0969783013278   , 0.08954276111     , 0.0830832444635   ,
 0.0752248494945   , 0.0630711726049   , 0.0489536551261   , 0.0386535748501   ,
 0.0355322550087   , 0.0386414314527   , 0.046131330035    , 0.0579810968968   ,
 0.0736025635257   , 0.0886977932085   , 0.0983442040878   , 0.102606563542    ,
 0.104529602522    , 0.102790735742    , 0.0920207356763   , 0.0716393977559   ,
 0.0495595335152   , 0.0352087370048   , 0.0313954135994   , 0.0335039883713   ,
 0.0406892023446   , 0.0376279737712   , 0.0296703421175   , 0.0223773587946   ,
 0.0211066781028   , 0.0268745149523   , 0.0351357297646   , 0.0388144536904   ,
 0.0340959533285   , 0.0234678464059   , 0.0126466100005   , 0.00553427977721  ,
 0.00288253136611  , 0.00461879659322  , 0.0120693674713   , 0.0272930785874   ,
 0.0493377226068   , 0.0709363705306   , 0.081232191382    , 0.0744045983821   ,
 0.0552231274953   , 0.0349753096528   , 0.0231386647746   , 0.0233980337015   ,
 0.034266362352    , 0.0500183427654   , 0.0622134000586   , 0.0645525746286   ,
 0.0581381611381   , 0.0506928633089   , 0.0497912634107   , 0.0568718131907   ,
 0.0666805329091   , 0.0716961742438   , 0.0682867614914   , 0.0600160218559   ,
 0.0557564171157   , 0.0643956712818   , 0.0883230443222   , 0.11909086686     ,
 0.142301273537    , 0.150776040582    , 0.14970432886     , 0.14531893223     ,
 0.134837951294    , 0.114131725236    , 0.0902322901526   , 0.0789924985832   ,
 0.091646514535    , 0.125871414216    , 0.166715693713    , 0.194777426803    ,
 0.198178907945    , 0.181503026079    , 0.164193366098    , 0.169407853098    ,
 0.212025291069    , 0.291587946054    , 0.390252668126    , 0.478282593863    ,
 0.529995276115    , 0.540278712213    , 0.5260167778      , 0.513151845551    ,
 0.524185445579    , 0.574995597956    , 0.678860047496    , 0.850160062344    ,
 1.09942132762     , 1.41931559545     , 1.77551945353     , 2.12249788297     ,
 2.45001168139     , 2.8299646783      , 3.40824027208     , 4.32580348876     ,
 5.63296230348     , 7.27953553563     , 9.18954991249     , 11.3392540159     ,
 13.7534368292     , 16.4372081485     , 19.3372205769     , 22.3626159945     ,
 25.4081061698     , 28.3550262811     , 31.086034572      , 33.5136716431     ,
 35.5838777398     , 37.2585951852     , 38.5035991625     , 39.2562611921     ,
 39.3622298319     , 38.5843056434     , 36.7711820969     , 34.0425718802     ,
 30.7559846065     , 27.2928274936     , 23.9170382784     , 20.7866169826     ,
 17.9970552822     , 15.5919389596     , 13.5670906019     , 11.8768546321     ,
 10.4333354544     , 9.1167072845      , 7.82244374609     , 6.52209721618     ,
 5.27537060087     , 4.1791514424      , 3.30475936087     , 2.66352403676     ,
 2.20677328645     , 1.85959144961     , 1.5651582132      , 1.30154815973     ,
 1.07028865884     , 0.882292343263    , 0.746269324656    , 0.657181457891    ,
 0.59660052901     , 0.546614384415    , 0.498759161852    , 0.449425826494    ,
 0.39440799869     , 0.332857218389    , 0.272786355695    , 0.225075792992    ,
 0.190434234254    , 0.158654478456    , 0.123674178525    , 0.0934547642035   ,
 0.0809056898839   , 0.0885925152058   , 0.106029362327    , 0.120657973822    ,
 0.12781143806     , 0.128696473891    , 0.122714264564    , 0.107009955161    ,
 0.0827237808384   , 0.0569468309368   , 0.0378499024334   , 0.0307783026691   ,
 0.0390420925694   , 0.0645470390769   , 0.104411135741    , 0.147540031216    ,
 0.177716993895    , 0.182887481572    , 0.162958722766    , 0.129819772778    ,
 0.100160575643    , 0.0858274487355   , 0.0870659692726   , 0.0934137390664   ,
 0.092912454071    , 0.0822125010734   , 0.0674558493793   , 0.0558456117956   ,
 0.0487517517967   , 0.0432722454741   , 0.0374935802133   , 0.0324037787282   ,
 0.0299115743306   , 0.0307341616597   , 0.0346665607104   , 0.0417750659423   ,
 0.0515015504444   , 0.0609431815046   , 0.0666549660891   , 0.068426394451    ,
 0.0684190672226   , 0.0664376615341   , 0.0596671970628   , 0.0479536935031   ,
 0.0362208556489   , 0.0303444113025   , 0.0319925331123   , 0.0374896032455   ,
 0.0463764779282   , 0.0428465716438   , 0.034537618897    , 0.0264992800346   ,
 0.0238169562497   , 0.027771538003    , 0.0344234213992   , 0.0372138514975   ,
 0.0324323938092   , 0.0222608003772   , 0.01199444896     , 0.00530817036538  ,
 0.00303223780683  , 0.00546295692676  , 0.0145203608544   , 0.0327460913924   ,
 0.0588094738076   , 0.0837617795958   , 0.0947827163716   , 0.0857983721012   ,
 0.0635651146127   , 0.0416538551109   , 0.0299442889556   , 0.0306506009751   ,
 0.0408053970887   , 0.0547193469946   , 0.065129278127    , 0.0665585232831   ,
 0.0600304759913   , 0.0528604255635   , 0.0521098446901   , 0.05880139768     ,
 0.0684880214216   , 0.0757217168687   , 0.0775248600612   , 0.0746101429891   ,
 0.0715526212232   , 0.0753347043994   , 0.0900376792075   , 0.110792906861    ,
 0.126433518667    , 0.131198776982    , 0.129690245275    , 0.126884437808    ,
 0.119557208121    , 0.103832506331    , 0.0867327985725   , 0.0838216360629   ,
 0.106173484501    , 0.150725207397    , 0.200230969249    , 0.232566938787    ,
 0.235626356807    , 0.217543136158    , 0.202645994515    , 0.215924603597    ,
 0.268590974435    , 0.353480470619    , 0.448805295412    , 0.526619522901    ,
 0.566237576067    , 0.567889522834    , 0.554072007737    , 0.554799164117    ,
 0.590635264852    , 0.669190790424    , 0.795091667493    , 0.980318295126    ,
 1.24215363857     , 1.58596869061     , 1.98691437955     , 2.39961640464     ,
 2.80998753958     , 3.2894827639      , 3.9832516522      , 5.02449878431     ,
 6.45286131835     , 8.21214107175     , 10.2241440087     , 12.4644940979     ,
 14.9652972304     , 17.7547048298     , 20.8104862532     , 24.0528523555     ,
 27.3397585004     , 30.4689371083     , 33.2267824521     , 35.466997605      ,
 37.1574411881     , 38.3681009057     , 39.2045000871     , 39.6945748323     ,
 39.6882931673     , 38.8929178095     , 37.0841609556     , 34.3171790268     ,
 30.9141039918     , 27.2661768819     , 23.6846703049     , 20.3853134158     ,
 17.5064768619     , 15.1026001794     , 13.1395299877     , 11.5132981522     ,
 10.0895926187     , 8.7520922335      , 7.44206264842     , 6.17059225345     ,
 4.99587993878     , 3.98429498747     , 3.18103785939     , 2.5910175904      ,
 2.17090588328     , 1.85150187762     , 1.57884562915     , 1.33281792721     ,
 1.11659122162     , 0.940726853414    , 0.810190959162    , 0.7158247786      ,
 0.640265235822    , 0.573385797029    , 0.515681170647    , 0.465943685148    ,
 0.414266298358    , 0.352892229765    , 0.289204531075    , 0.238977231318    ,
 0.206137851545    , 0.178060126749    , 0.144201986544    , 0.111320468051    ,
 0.0948284123854   , 0.100007592916    , 0.117076938823    , 0.132998119597    ,
 0.14283811414     , 0.147463370345    , 0.14477334216     , 0.129648891313    ,
 0.102060865888    , 0.0701322056141   , 0.0445914725161   , 0.0332753223333   ,
 0.0404526883812   , 0.0667623204677   , 0.106350519945    , 0.145253481706    ,
 0.166834900026    , 0.162126097454    , 0.135812842713    , 0.10263991718     ,
 0.0781712491525   , 0.0705194998262   , 0.0765908964915   , 0.0846615151525   ,
 0.083235090711    , 0.0701667015404   , 0.0532797679398   , 0.0420556941525   ,
 0.0396568561269   , 0.042310505589    , 0.0443381330373   , 0.0432067694536   ,
 0.0404361143989   , 0.0385222044416   , 0.0383838720684   , 0.0399657045982   ,
 0.0429921371228   , 0.0459530080952   , 0.0465087822217   , 0.0441679991985   ,
 0.040773609947    , 0.0377095372278   , 0.0346613991668   , 0.0316481557993   ,
 0.0303029066726   , 0.0323666981063   , 0.0377196832041   , 0.0437526676083   ,
 0.0484452506829   , 0.0441727044142   , 0.0371666880401   , 0.029995033247    ,
 0.0257586121651   , 0.025869528542    , 0.0283590899202   , 0.0288837912125   ,
 0.0245817674973   , 0.0167245058624   , 0.00899329931266  , 0.00404205855664  ,
 0.00260724979294  , 0.00535823693437  , 0.0146451176011   , 0.0334448480813   ,
 0.0608653823884   , 0.0881551430548   , 0.102208986043    , 0.0964850802886   ,
 0.0777273040526   , 0.0598669419108   , 0.0524174550634   , 0.055826577338    ,
 0.0651620433086   , 0.0747024039456   , 0.0795291187032   , 0.0770532282208   ,
 0.0699165843487   , 0.0653548095498   , 0.0688091505506   , 0.0790419395181   ,
 0.0907739587704   , 0.0998407436199   , 0.10401455897     , 0.101755840437    ,
 0.0940411835972   , 0.0865624058285   , 0.0858013457883   , 0.0915082610531   ,
 0.0965839532008   , 0.0962886289139   , 0.0933577942139   , 0.0913328316175   ,
 0.0881923614521   , 0.0816077840151   , 0.0771269684973   , 0.0861750880204   ,
 0.116022800302    , 0.162020488844    , 0.207775160907    , 0.234343337145    ,
 0.234479088966    , 0.220868602938    , 0.219221245418    , 0.250314395089    ,
 0.315844185641    , 0.399581477982    , 0.479875771283    , 0.540075040483    ,
 0.572598048305    , 0.582299083344    , 0.587790044579    , 0.613485634475    ,
 0.676753552176    , 0.783688822003    , 0.937088223758    , 1.14758221192     ,
 1.43602088857     , 1.81821384304     , 2.28077703669     , 2.78382834585     ,
 3.31252170644     , 3.93180339723     , 4.77110348755     , 5.94367438823     ,
 7.48265633505     , 9.34559859925     , 11.4691400403     , 13.8230328398     ,
 16.4175525227     , 19.2710693975     , 22.3836697261     , 25.7132671805     ,
 29.1243987185     , 32.3588273311     , 35.1045477668     , 37.13482695       ,
 38.4116534925     , 39.0870482883     , 39.3956234108     , 39.4750153853     ,
 39.2240958706     , 38.3430678556     , 36.5676219366     , 33.8953645362     ,
 30.5908896279     , 27.0107304822     , 23.460904162      , 20.1678128523     ,
 17.2825500087     , 14.8676829424     , 12.8877287386     , 11.2298254573     ,
 9.75873919963     , 8.37876765375     , 7.06211577421     , 5.83367042183     ,
 4.73647525966     , 3.80720931011     , 3.06819936177     , 2.51770284523     ,
 2.11805832144     , 1.8092979219      , 1.54450615221     , 1.30788331711     ,
 1.10492004818     , 0.945107838459    , 0.828521585303    , 0.741010647544    ,
 0.664694498405    , 0.594208526831    , 0.536520031427    , 0.492915973903    ,
 0.449044204396    , 0.39012017263     , 0.321866021608    , 0.265303211545    ,
 0.229633138782    , 0.201684136653    , 0.166721989735    , 0.129346268124    ,
 0.106488280826    , 0.10601622904     , 0.119514960361    , 0.133959099483    ,
 0.14383407752     , 0.149482973704    , 0.148589900698    , 0.135752355086    ,
 0.110061708241    , 0.0784774713754   , 0.051303129512    , 0.0369683326101   ,
 0.0403387676499   , 0.0616980510456   , 0.0943151192296   , 0.12429528157     ,
 0.137055196911    , 0.127070119949    , 0.101782621399    , 0.0760002527977   ,
 0.0623397723855   , 0.0645453924849   , 0.0761067340341   , 0.0845672722461   ,
 0.0803998603785   , 0.0644688016253   , 0.0469513461898   , 0.0386342804566   ,
 0.0428158777246   , 0.0538563463716   , 0.0624977199952   , 0.0635797698158   ,
 0.0590019240777   , 0.0531989727818   , 0.0479467224572   , 0.0429136791341   ,
 0.0383265287907   , 0.0345046134836   , 0.0306540774326   , 0.0262138906628   ,
 0.0222826743842   , 0.0206581575429   , 0.0223720247974   , 0.0273610852434   ,
 0.0344293817358   , 0.0414802074545   , 0.0466705301016   , 0.0491548354838   ,
 0.0482384312256   , 0.0439083528903   , 0.0399260743588   , 0.0350198606975   ,
 0.0293646194274   , 0.0246193564173   , 0.0216288017661   , 0.0190603741368   ,
 0.0151599377221   , 0.0100391801189   , 0.00535351308798  , 0.0024600291264   ,
 0.0018741934312   , 0.00446771525142  , 0.0127116125158   , 0.0298922499676   ,
 0.0563193386917   , 0.0853646616411   , 0.105633641274    , 0.110404764084    ,
 0.104586361153    , 0.0999745815818   , 0.103937937167    , 0.114169104075    ,
 0.123214703069    , 0.125415886057    , 0.119321891163    , 0.107174803592    ,
 0.0952843497189   , 0.0921067719721   , 0.101238112158    , 0.11727478981     ,
 0.13155611336     , 0.139746541467    , 0.140980389707    , 0.133497420517    ,
 0.116568640005    , 0.0952746136518   , 0.0780999910762   , 0.0687990408278   ,
 0.0639800784622   , 0.0595995859526   , 0.056151628022    , 0.0557041159191   ,
 0.0577447220151   , 0.0613087833225   , 0.0690753675322   , 0.0862480990001   ,
 0.115158091041    , 0.150927637085    , 0.181976487646    , 0.197133668108    ,
 0.196297975422    , 0.195207465222    , 0.216699220228    , 0.272520235634    ,
 0.351447007244    , 0.427802972976    , 0.483577355581    , 0.519798452929    ,
 0.547750693558    , 0.577428667511    , 0.617129224174    , 0.676813411027    ,
 0.766821848442    , 0.89555395266     , 1.07129351349     , 1.30864197809     ,
 1.63286249872     , 2.06781262618     , 2.61041759526     , 3.22984794381     ,
 3.91461652416     , 4.71843189371     , 5.74026886356     , 7.06194410303     ,
 8.71608330162     , 10.6944784243     , 12.9625162968     , 15.4708434581     ,
 18.1682062114     , 21.021489626      , 24.0395370244     , 27.2452659905     ,
 30.5639797821     , 33.7366258106     , 36.3922998148     , 38.2376595931     ,
 39.2012963522     , 39.4457501105     , 39.2574557191     , 38.8560686296     ,
 38.2266523726     , 37.1304859518     , 35.3227471728     , 32.7770817718     ,
 29.7030143094     , 26.3923567722     , 23.0916523258     , 19.9786611782     ,
 17.175305121      , 14.7445677957     , 12.6796635696     , 10.912322031      ,
 9.35249457886     , 7.93404249104     , 6.63201607802     , 5.45328942745     ,
 4.4199539065      , 3.5545559073      , 2.86958130945     , 2.35683869558     ,
 1.97941796088     , 1.68417509187     , 1.43110473225     , 1.20895333499     ,
 1.02590036275     , 0.890713569649    , 0.798569419805    , 0.729738793469    ,
 0.663948816796    , 0.59745851613     , 0.541625702148    , 0.501749784596    ,
 0.463411279946    , 0.408288161641    , 0.340219261963    , 0.282500605112    ,
 0.247214990938    , 0.220676235205    , 0.1852326763      , 0.143861198263    ,
 0.114442025183    , 0.106758945192    , 0.113712962401    , 0.122653662072    ,
 0.127922154032    , 0.13023862038     , 0.12883798367     , 0.119727145412    ,
 0.101101012638    , 0.0767293006839   , 0.0537462743429   , 0.0390909915035   ,
 0.0374741292726   , 0.0496674130261   , 0.0704670382189   , 0.0891877057025   ,
 0.0953833249663   , 0.0864742890954   , 0.0700519783718   , 0.0584761168675   ,
 0.060502616711    , 0.0755761535606   , 0.0935906319803   , 0.101047122308    ,
 0.0909519955028   , 0.0686607343      , 0.0478716729483   , 0.0405674646318   ,
 0.0492903792921   , 0.0661475513292   , 0.0788878199165   , 0.0804739178096   ,
 0.0733028161754   , 0.0634951197071   , 0.053672736516    , 0.0433630371457   ,
 0.0331008610943   , 0.0245824938027   , 0.0183754740329   , 0.0140437882299   ,
 0.011945610642    , 0.0136556998078   , 0.020693020341    , 0.0326213981945   ,
 0.045812075775    , 0.0549092696981   , 0.0568783046841   , 0.053340037429    ,
 0.0477474835431   , 0.0444624149986   , 0.0439917684344   , 0.0414345385144   ,
 0.0344844732465   , 0.0252843104674   , 0.0173228855779   , 0.0118690841134   ,
 0.00803397727349  , 0.00492928427284  , 0.00255673422192  , 0.00121553296526  ,
 0.00117824353128  , 0.00332494929263  , 0.0100191622656   , 0.0248192971638   ,
 0.0498021628669   , 0.0819063946175   , 0.113219555857    , 0.137490651255    ,
 0.156170650271    , 0.175573610145    , 0.197911748932    , 0.217142624857    ,
 0.224181816566    , 0.2148003725      , 0.191944782307    , 0.163435535294    ,
 0.140454287976    , 0.134121494736    , 0.146620224016    , 0.166972008171    ,
 0.1808957393      , 0.183003038197    , 0.175360683259    , 0.158770887884    ,
 0.132519807991    , 0.100646519325    , 0.0717650388434   , 0.0517047514826   ,
 0.0397752048736   , 0.0328089946262   , 0.0299150723089   , 0.0321833998518   ,
 0.040106908312    , 0.0529568821865   , 0.0696038340464   , 0.0888635797843   ,
 0.109133247838    , 0.127510923572    , 0.139738623265    , 0.143674960552    ,
 0.1453599373      , 0.160780020101    , 0.206910175551    , 0.285047074919    ,
 0.372126643745    , 0.435787546548    , 0.463897624652    , 0.475844748138    ,
 0.502210520603    , 0.558808675193    , 0.642074014261    , 0.742151807674    ,
 0.856428682706    , 0.994673468222    , 1.1770099226      , 1.43193122374     ,
 1.79515193903     , 2.29666121065     , 2.93817689289     , 3.6960833691      ,
 4.56441359179     , 5.58581108188     , 6.82445673406     , 8.32602947821     ,
 10.1225508525     , 12.2451642123     , 14.6911066223     , 17.3801613397     ,
 20.1698073155     , 22.9452000946     , 25.7163102212     , 28.5930143264     ,
 31.6034864535     , 34.5387383004     , 37.0196194411     , 38.7189523553     ,
 39.5187967194     , 39.5220614373     , 38.973354919      , 38.1157284197     ,
 37.0263406508     , 35.5783485593     , 33.607108983      , 31.1127584621     ,
 28.2784977484     , 25.327422236      , 22.4100781139     , 19.6044655685     ,
 16.9627192284     , 14.5362638714     , 12.3670244803     , 10.4691895462     ,
 8.82650176622     , 7.40002979031     , 6.13999970414     , 5.01204816518     ,
 4.02054277273     , 3.19569742445     , 2.55721273795     , 2.09162149946     ,
 1.75459384117     , 1.49197524868     , 1.26654191523     , 1.0706625879      ,
 0.916406218312    , 0.813558984767    , 0.753094585105    , 0.708842759211    ,
 0.656185944267    , 0.590861777666    , 0.527784157107    , 0.478722362499    ,
 0.435227206457    , 0.381339624151    , 0.319574755228    , 0.270345525667    ,
 0.243229692178    , 0.222897058637    , 0.190548964517    , 0.148529883298    ,
 0.114980477217    , 0.100808629756    , 0.100363002742    , 0.102056941412    ,
 0.100706648205    , 0.0978714794092   , 0.094896576183    , 0.0899024362524   ,
 0.080690182785    , 0.0676112468093   , 0.0533729167636   , 0.0416359872309   ,
 0.0358965728679   , 0.0379848222752   , 0.0460403109513   , 0.0543305632535   ,
 0.0570026925123   , 0.0533578489006   , 0.0495278783202   , 0.0545810544083   ,
 0.0736240678981   , 0.102188372173    , 0.126390272527    , 0.131259252614    ,
 0.112397956335    , 0.0802602066477   , 0.052503883967    , 0.0420634197306   ,
 0.0503559154607   , 0.0678693619508   , 0.0810090683732   , 0.0819727232274   ,
 0.0731662268651   , 0.0613017823252   , 0.0495681148586   , 0.0376078945711   ,
 0.0258807943021   , 0.0163605311541   , 0.0101789403822   , 0.00714312961263  ,
 0.00742618504708  , 0.0125539841266   , 0.0241830500625   , 0.0412348168895   ,
 0.0580483351234   , 0.0670302197081   , 0.0649128413067   , 0.0559357591714   ,
 0.0474321866546   , 0.0458177447558   , 0.0475581296317   , 0.0459224237841   ,
 0.0377482166903   , 0.0257691627062   , 0.0149505576481   , 0.00788966388381  ,
 0.00409774286184  , 0.00211067597267  , 0.00101463451597  , 0.000514836698129 ,
 0.000705758498211 , 0.00236393780373  , 0.00766444248544  , 0.0204805499478   ,
 0.044994659421    , 0.0826878938882   , 0.130706661877    , 0.184128300011    ,
 0.239004156697    , 0.291354246505    , 0.334081978441    , 0.357695728979    ,
 0.355526897031    , 0.328357069241    , 0.284142489037    , 0.235212271777    ,
 0.197049166133    , 0.183689747633    , 0.19594261182     , 0.216615011349    ,
 0.225297199207    , 0.216310407852    , 0.196768560034    , 0.172048053044    ,
 0.141597672719    , 0.106485643613    , 0.0728627320425   , 0.0467878436003   ,
 0.029743144109    , 0.020247923337    , 0.0174981983498   , 0.0223721019763   ,
 0.0357557262682   , 0.0561394138848   , 0.0785478226714   , 0.096609392621    ,
 0.106466879771    , 0.108346473558    , 0.105096777797    , 0.101802713421    ,
 0.107957721484    , 0.137449375836    , 0.200628093149    , 0.290320942       ,
 0.376556386598    , 0.425582895195    , 0.432122357417    , 0.428990510221    ,
 0.459967863402    , 0.545378413105    , 0.672890289171    , 0.814264366032    ,
 0.950278986225    , 1.08774500425     , 1.26077400207     , 1.52053368293     ,
 1.92041538724     , 2.49555897641     , 3.24571705062     , 4.14884774044     ,
 5.20418815211     , 6.44956072724     , 7.92450568745     , 9.64261702988     ,
 11.6246998694     , 13.9238608868     , 16.5603250742     , 19.4221052595     ,
 22.271243082      , 24.9043256833     , 27.3319382985     , 29.7588364351     ,
 32.3323654487     , 34.9217646802     , 37.1751246108     , 38.7565412212     ,
 39.4981639111     , 39.4051593678     , 38.6190921632     , 37.3528396617     ,
 35.7618261867     , 33.8608301551     , 31.6122168587     , 29.0790323094     ,
 26.4350566553     , 23.8356761405     , 21.32663269       , 18.8724624792     ,
 16.4416365813     , 14.0662979502     , 11.8392452978     , 9.86296123163     ,
 8.19283593571     , 6.80470402505     , 5.61159152675     , 4.53596631484     ,
 3.57379989733     , 2.77712445598     , 2.1837868886      , 1.77742181085     ,
 1.50066896245     , 1.29023990853     , 1.10641060112     , 0.944321907826    ,
 0.821835207516    , 0.751936838152    , 0.722359351085    , 0.700266954292    ,
 0.65624969642     , 0.585254684618    , 0.505430233618    , 0.435682917997    ,
 0.376944775871    , 0.320298858043    , 0.268210299709    , 0.234436703109    ,
 0.221394624171    , 0.210842101756    , 0.184216017402    , 0.144156068826    ,
 0.108734848181    , 0.0896892966206   , 0.0832000160147   , 0.0792626394144   ,
 0.0731965180719   , 0.0667915630015   , 0.0626892984186   , 0.0610260373068   ,
 0.060314956545    , 0.0588763913272   , 0.0551682423329   , 0.0484721986096   ,
 0.0402024896747   , 0.0336217162801   , 0.0310771179152   , 0.0318161536728   ,
 0.0335165260999   , 0.0360908158769   , 0.043635425606    , 0.0622013225476   ,
 0.0939989799893   , 0.13158585222     , 0.158348301008    , 0.158706998012    ,
 0.130927458449    , 0.0895724862043   , 0.0547253038321   , 0.0390424130257   ,
 0.0426757855959   , 0.0559128164901   , 0.0661521993118   , 0.0662391545522   ,
 0.0579731479679   , 0.047141636339    , 0.0367936728648   , 0.0268014448046   ,
 0.0173530272584   , 0.00987306916082  , 0.00536003753853  , 0.00390966749236  ,
 0.00603022950115  , 0.0134888726732   , 0.0278928815355   , 0.0474072797927   ,
 0.0650602006982   , 0.0725375777322   , 0.0674404688349   , 0.0560014568776   ,
 0.0481125757083   , 0.0480175195959   , 0.0495222214602   , 0.0464743893395   ,
 0.03686202765     , 0.0239980189818   , 0.0128064505928   , 0.00576334275253  ,
 0.00234207264496  , 0.000944549863951 , 0.00041410666633  , 0.00026928933816  ,
 0.000509878225544 , 0.00177024234004  , 0.0060165439413   , 0.0174046888357   ,
 0.0422107323511   , 0.086870681023    , 0.154751500713    , 0.243064991037    ,
 0.340525988779    , 0.427962913176    , 0.485405999249    , 0.502133435705    ,
 0.480228232924    , 0.429891289162    , 0.363770345203    , 0.296119207259    ,
 0.244607161472    , 0.224771437141    , 0.235190607676    , 0.25291026503     ,
 0.253247994066    , 0.232317078917    , 0.20348092568     , 0.176608596391    ,
 0.149848373991    , 0.11897506347     , 0.0857679586961   , 0.0558825034014   ,
 0.0334563184236   , 0.0197989935318   , 0.0153248691957   , 0.0210579410608   ,
 0.0377297480222   , 0.0627650547365   , 0.0884964715      , 0.105482114073    ,
 0.108934322602    , 0.101485429029    , 0.0905246150574   , 0.0851386705766   ,
 0.0956853245876   , 0.132934626769    , 0.201836290268    , 0.290770354807    ,
 0.369217132958    , 0.407574689529    , 0.407044758232    , 0.405561530335    ,
 0.449162610362    , 0.558330390094    , 0.717948761832    , 0.891087373236    ,
 1.04539824603     , 1.18043436942     , 1.33970401812     , 1.59771361729     ,
 2.02883832079     , 2.67436713391     , 3.52961689262     , 4.56994918051     ,
 5.7979982187      , 7.2535042216      , 8.96570049441     , 10.9222898633     ,
 13.1170064887     , 15.598485112      , 18.3988392259     , 21.3864076098     ,
 24.2488013026     , 26.7083859014     , 28.7759968065     , 30.737535124      ,
 32.8486856044     , 35.0653274101     , 37.0819090219     , 38.5620124436     ,
 39.2818353398     , 39.1377916312     , 38.1515050493     , 36.4840419356     ,
 34.3631048603     , 31.9670485353     , 29.4115455686     , 26.8221898972     ,
 24.3402839763     , 22.0395095914     , 19.8757742828     , 17.7330107707     ,
 15.5211116578     , 13.2561431171     , 11.0660668043     , 9.11469466928     ,
 7.50008059647     , 6.19713282687     , 5.08865136806     , 4.07196913593     ,
 3.14471649866     , 2.38037788649     , 1.83452827815     , 1.49086158992     ,
 1.28000068598     , 1.12655261574     , 0.985156134926    , 0.853151465781    ,
 0.75526108006     , 0.709061762611    , 0.700753131193    , 0.693111020104    ,
 0.65428439393     , 0.579277028209    , 0.487298197912    , 0.400397200778    ,
 0.32681429506     , 0.266272035029    , 0.223794425298    , 0.20674688059     ,
 0.208468707871    , 0.206408540533    , 0.182825423477    , 0.142290976319    ,
 0.10403647641     , 0.0809535678372   , 0.0707123386151   , 0.0642472482582   ,
 0.0566406531962   , 0.048981244883    , 0.0441782195776   , 0.044055655182    ,
 0.0488389552487   , 0.0564162298505   , 0.0618676011587   , 0.0600507601814   ,
 0.0502265607114   , 0.0373538917945   , 0.0278484734193   , 0.0247276925749   ,
 0.0274024238095   , 0.0351310434179   , 0.0496997219386   , 0.0744941565158   ,
 0.109707020871    , 0.146870117037    , 0.16961841007     , 0.16415334143     ,
 0.131232364684    , 0.086743522473    , 0.0498640293307   , 0.0311224619836   ,
 0.029526408127    , 0.0366447726955   , 0.042712389659    , 0.0422988637974   ,
 0.036348902588    , 0.0287520098961   , 0.0217507244736   , 0.0153753129447   ,
 0.00960937223501  , 0.00517911648034  , 0.00272251222172  , 0.00259506603181  ,
 0.00577401087264  , 0.0142703331176   , 0.0294559591948   , 0.0488353650722   ,
 0.0650536426944   , 0.0705724903435   , 0.064639611324    , 0.0543909822928   ,
 0.0522624308457   , 0.0535993795324   , 0.0530182418775   , 0.0465037984081   ,
 0.0346321146874   , 0.0214692197362   , 0.0110341482217   , 0.00478659184866  ,
 0.00186859266176  , 0.000781951132732 , 0.000489475119361 , 0.000526159187112 ,
 0.000819490998998 , 0.00182169969649  , 0.00522583949605  , 0.0152314729297   ,
 0.0396363410693   , 0.0891783484033   , 0.173314486276    , 0.291745416798    ,
 0.425660712839    , 0.53978356565     , 0.601641622534    , 0.602533010401    ,
 0.557302896924    , 0.48655565228     , 0.405170040291    , 0.326276969105    ,
 0.267646366883    , 0.244729336072    , 0.253452896352    , 0.267197807471    ,
 0.260364223619    , 0.232373648539    , 0.201598659898    , 0.180204627496    ,
 0.16340707765     , 0.140774685779    , 0.109537762264    , 0.0755511883167   ,
 0.0465048442833   , 0.0271087684904   , 0.0191285879095   , 0.0234041067978   ,
 0.0400653996272   , 0.065845937799    , 0.0922457111665   , 0.109167760085    ,
 0.111800314678    , 0.103533502006    , 0.0930414268827   , 0.0902123071907   ,
 0.104227146943    , 0.142531036211    , 0.206899612895    , 0.286019973896    ,
 0.354829386748    , 0.392038198902    , 0.403751276866    , 0.424030642471    ,
 0.48865398692     , 0.611208961107    , 0.779273960323    , 0.961928176701    ,
 1.12538292765     , 1.26182432313     , 1.41515507441     , 1.67457131354     ,
 2.1332034009      , 2.84231440592     , 3.79775443994     , 4.97284664093     ,
 6.36890384124     , 8.02303934641     , 9.95434302965     , 12.1256939211     ,
 14.4988287201     , 17.1086039427     , 19.9968647999     , 23.0282643448     ,
 25.8481944172     , 28.1331147488     , 29.8924889586     , 31.4587819673     ,
 33.1596185585     , 35.0294953099     , 36.8208370693     , 38.2001712578     ,
 38.881174219      , 38.6543873277     , 37.4370981701     , 35.3531471657     ,
 32.7120847644     , 29.8626400213     , 27.0663991666     , 24.4788465837     ,
 22.1674105751     , 20.1084687395     , 18.1955806569     , 16.2857797755     ,
 14.2749979663     , 12.1739719692     , 10.1222663157     , 8.30336863624     ,
 6.82067351201     , 5.63609242874     , 4.61932274625     , 3.6675472159      ,
 2.78817951337     , 2.067107304       , 1.56912445841     , 1.27918269538     ,
 1.12126670837     , 1.01115476739     , 0.898806803508    , 0.783580116563    ,
 0.696039791611    , 0.658092972137    , 0.657053284682    , 0.656471672241    ,
 0.626501803543    , 0.562373541743    , 0.479105091924    , 0.393905549779    ,
 0.316619141739    , 0.255361559691    , 0.221443325281    , 0.219046780396    ,
 0.232350719681    , 0.232879731821    , 0.204144837563    , 0.155661934323    ,
 0.110597285551    , 0.0832759464279   , 0.0711496079428   , 0.0642729138679   ,
 0.0566117122205   , 0.0482443483271   , 0.0419384427824   , 0.0408399766084   ,
 0.0471228585471   , 0.0591380084602   , 0.0698008703307   , 0.0707783078912   ,
 0.0600264459297   , 0.0441186657065   , 0.0323005492802   , 0.0293651193277   ,
 0.0345972338002   , 0.045673325582    , 0.0620605212193   , 0.0848503277104   ,
 0.113154396212    , 0.139896891577    , 0.152584053354    , 0.141686730482    ,
 0.109650044739    , 0.0702237226489   , 0.038323670389    , 0.0210502153843   ,
 0.0167273543958   , 0.0190923935291   , 0.021763323572    , 0.021306526484    ,
 0.0180052661709   , 0.0138835873357   , 0.0102051186517   , 0.00704073318794  ,
 0.00431999431812  , 0.00232458336535  , 0.00142535586713  , 0.0021566261963   ,
 0.0058277738116   , 0.0145408886019   , 0.0293327918639   , 0.0472413327214   ,
 0.0611913502109   , 0.065246250153    , 0.0605495897994   , 0.0542980928442   ,
 0.0619601044053   , 0.0659544260562   , 0.063816616435    , 0.0533663644375   ,
 0.0380004660404   , 0.0231217406799   , 0.0122818018423   , 0.00599548766266  ,
 0.00298658769019  , 0.00184845886519  , 0.00171122343924  , 0.00209644143611  ,
 0.00273187115318  , 0.00374289440796  , 0.00639296049724  , 0.0145325536421   ,
 0.0364405050041   , 0.0852962071025   , 0.174656578418    , 0.306268415986    ,
 0.456607955207    , 0.580258718939    , 0.638408838329    , 0.626819977203    ,
 0.570488137838    , 0.494984871765    , 0.412562336563    , 0.332715529809    ,
 0.272586972928    , 0.247781430499    , 0.253493545495    , 0.26324682426     ,
 0.253507025961    , 0.22616683434     , 0.200891784006    , 0.189245773909    ,
 0.183303527693    , 0.167872759674    , 0.137249762338    , 0.0986108666611   ,
 0.0634533055533   , 0.0391948435795   , 0.0278912681213   , 0.0295124934043   ,
 0.0435693226232   , 0.0668018881538   , 0.0913097899842   , 0.107983671406    ,
 0.112675021678    , 0.108567796604    , 0.103512663805    , 0.105938860011    ,
 0.122213834415    , 0.156206630399    , 0.208431523031    , 0.272001727625    ,
 0.332161193872    , 0.378746639057    , 0.420940153317    , 0.481695380488    ,
 0.576137944073    , 0.703155180686    , 0.854581438797    , 1.01789681075     ,
 1.1732181103      , 1.31198877953     , 1.47197028048     , 1.74463297711     ,
 2.23537083772     , 3.00986760206     , 4.07409798895     , 5.40324407579     ,
 6.98773388211     , 8.8401231972      , 10.9482368363     , 13.2480826292     ,
 15.6892816859     , 18.3139505318     , 21.1791473886     , 24.1508412881     ,
 26.8601740563     , 28.9759147231     , 30.5128366439     , 31.8081635515     ,
 33.2030835716     , 34.7779389884     , 36.3427441381     , 37.5777192074     ,
 38.1462747063     , 37.7583886021     , 36.2693211248     , 33.8030260788     ,
 30.7543387127     , 27.6053145715     , 24.7074857928     , 22.2022278946     ,
 20.0690473874     , 18.2016004689     , 16.4636464654     , 14.7241952451     ,
 12.8962964171     , 10.9939090793     , 9.14977203306     , 7.533606554       ,
 6.22670305882     , 5.17217372764     , 4.24165369707     , 3.35152400651     ,
 2.52544699242     , 1.85360876277     , 1.39949767925     , 1.14661217182     ,
 1.01738201261     , 0.926278516734    , 0.823758194719    , 0.711458518739    ,
 0.622232304173    , 0.579687463587    , 0.57442865007     , 0.576503854897    ,
 0.562409238728    , 0.526842534762    , 0.475067814132    , 0.412410876667    ,
 0.345425820093    , 0.289704153241    , 0.265140512381    , 0.275383140361    ,
 0.296029723762    , 0.292113438835    , 0.249566658702    , 0.186031887648    ,
 0.130879443785    , 0.0992370060903   , 0.0860075874248   , 0.0786741588338   ,
 0.0699298647081   , 0.059406398805    , 0.0498835417189   , 0.0452953952221   ,
 0.049148348757    , 0.0604630332254   , 0.0715056894338   , 0.0729196267857   ,
 0.0625881397042   , 0.0479851967899   , 0.0390487155765   , 0.0400650073678   ,
 0.0487696726383   , 0.0611254444322   , 0.0750982964698   , 0.0903871445569   ,
 0.105797487966    , 0.117018876624    , 0.117417234191    , 0.102811337581    ,
 0.07629326953     , 0.0471972893537   , 0.0245976686962   , 0.0120793801803   ,
 0.0078613353356   , 0.0079376806961   , 0.0087455866373   , 0.00845383278388  ,
 0.00703655647447  , 0.00530365578024  , 0.00380505136232  , 0.00259903519512  ,
 0.00165237293088  , 0.00107031260569  , 0.0010891158809   , 0.00231189748986  ,
 0.00619672584568  , 0.014855188141    , 0.0290711174433   , 0.0456181968875   ,
 0.0578654969287   , 0.0614430632016   , 0.0592136589261   , 0.0583226455689   ,
 0.0771023367327   , 0.0867989111798   , 0.086477269484    , 0.0737407798715   ,
 0.0538975455984   , 0.0346097646232   , 0.0204977673638   , 0.0119882570626   ,
 0.00753499655863  , 0.00580483551608  , 0.00605276940122  , 0.00756283606586  ,
 0.00946085575114  , 0.0111478136616   , 0.013178309624    , 0.0187396191549   ,
 0.0357199241782   , 0.0776802711417   , 0.159368540179    , 0.283406234123    ,
 0.425878667072    , 0.54119310459     , 0.593251715314    , 0.58285429153     ,
 0.537526358308    , 0.479094321863    , 0.412296942099    , 0.341361682861    ,
 0.282748890912    , 0.253948715807    , 0.253304891525    , 0.258642886402    ,
 0.249679413998    , 0.227945710691    , 0.210323786592    , 0.206089337048    ,
 0.205774249746    , 0.192527088662    , 0.16023616318     , 0.118270486995    ,
 0.0809480692459   , 0.056179744528    , 0.0443049011427   , 0.0438667654335   ,
 0.0545069085375   , 0.0738643091936   , 0.0950145639224   , 0.110047438153    ,
 0.115880517355    , 0.115753383062    , 0.116340027621    , 0.123753358206    ,
 0.140786744713    , 0.167573135088    , 0.204071907533    , 0.249590858028    ,
 0.302045043805    , 0.363709294783    , 0.445655992861    , 0.556439442618    ,
 0.686410369134    , 0.81550909494     , 0.937242277148    , 1.06071907435     ,
 1.19058102907     , 1.32872509249     , 1.50844415373     , 1.81470185779     ,
 2.3561184148      , 3.21256978893     , 4.40682189668     , 5.91895463986     ,
 7.71654129921     , 9.75851466848     , 11.9737545752     , 14.2751346837     ,
 16.6390446129     , 19.1508833862     , 21.8845787344     , 24.6965315313     ,
 27.2209214825     , 29.1594896245     , 30.55080439       , 31.7053838598     ,
 32.9145778199     , 34.2487514992     , 35.5535987727     , 36.5377525539     ,
 36.8572265255     , 36.2042903579     , 34.44009889       , 31.7272990083     ,
 28.5172810371     , 25.3326492838     , 22.5175089754     , 20.1615355957     ,
 18.1868239742     , 16.458534735      , 14.8463532811     , 13.2432103091     ,
 11.5828055165     , 9.88331077617     , 8.26367129663     , 6.86604678417     ,
 5.73964147037     , 4.80890822583     , 3.95430180888     , 3.11883477603     ,
 2.34537454441     , 1.7240060516      , 1.30812819099     , 1.07474796197     ,
 0.948637229964    , 0.852660697316    , 0.745200397385    , 0.630003452716    ,
 0.536556694196    , 0.485677525053    , 0.471691574213    , 0.474293818486    ,
 0.47811838849     , 0.476640347898    , 0.463928726109    , 0.432506169365    ,
 0.384470123016    , 0.340693569545    , 0.327679702169    , 0.348550492989    ,
 0.37218425238     , 0.359432646603    , 0.30044106899     , 0.221690146414    ,
 0.157993638431    , 0.123532901339    , 0.109223610582    , 0.0997689791914   ,
 0.0874576008472   , 0.0725683868062   , 0.0583274692081   , 0.0488455930531   ,
 0.0478739034803   , 0.0548764772298   , 0.0628994972958   , 0.0636897043954   ,
 0.0559423315757   , 0.0468656293385   , 0.0448758149188   , 0.0519584988202   ,
 0.0637250339819   , 0.075210676572    , 0.0845257870485   , 0.0913514254815   ,
 0.0944595129116   , 0.0917625215692   , 0.0818342330914   , 0.0652547781819   ,
 0.0452459374271   , 0.026637724328    , 0.0132293704761   , 0.00590472187272  ,
 0.00312721580645  , 0.002657857818    , 0.00277372926971  , 0.00263941627313  ,
 0.00216861695138  , 0.00161188865293  , 0.00117104327454  , 0.000913950293896 ,
 0.0008862549449   , 0.00115636509946  , 0.00184162843851  , 0.00342548338334  ,
 0.00731125463402  , 0.015635927726    , 0.0292233412198   , 0.0449261465669   ,
 0.0565230152817   , 0.0606496521505   , 0.0614016058089   , 0.0662975070938   ,
 0.0960050205822   , 0.115169573006    , 0.121354412555    , 0.109351414998    ,
 0.085036955901    , 0.0591997770053   , 0.0391517413943   , 0.0261590767356   ,
 0.0187645810256   , 0.0160703118406   , 0.0176597926637   , 0.0222192734049   ,
 0.0274551245973   , 0.0312262194417   , 0.0329054896303   , 0.0349779356301   ,
 0.0450187575296   , 0.0763379034656   , 0.14307067938     , 0.247375848734    ,
 0.367459765423    , 0.464524048212    , 0.511211606019    , 0.512499919445    ,
 0.492292864139    , 0.463814948925    , 0.422992511948    , 0.368209207797    ,
 0.314262450757    , 0.281118638435    , 0.272850686413    , 0.27358191291     ,
 0.265641989055    , 0.247897931268    , 0.232923476954    , 0.228262215193    ,
 0.225237069184    , 0.208341440572    , 0.173249698916    , 0.131662919672    ,
 0.0986943961098   , 0.0797615302475   , 0.0713282194057   , 0.0703153489668   ,
 0.0777408738863   , 0.0931688334025   , 0.110541212042    , 0.122609347462    ,
 0.127409498359    , 0.12874897537     , 0.132401934341    , 0.142384741783    ,
 0.158739157365    , 0.17883866155     , 0.201994792961    , 0.232419470073    ,
 0.279099322641    , 0.355175376729    , 0.472486939907    , 0.626526642558    ,
 0.787643755302    , 0.920752898509    , 1.01825144365     , 1.10390416238     ,
 1.20599744082     , 1.34566345668     , 1.56052251278     , 1.9278595877      ,
 2.55049686818     , 3.51468240138     , 4.85725319292     , 6.56103368384     ,
 8.56193345972     , 10.7493998738     , 12.9840693871     , 15.1704761484     ,
 17.3452419019     , 19.6577584293     , 22.1901665407     , 24.77545918       ,
 27.0607188586     , 28.8064949343     , 30.088091376      , 31.1746526201     ,
 32.2694613535     , 33.3854241822     , 34.3714505717     , 34.9728594001     ,
 34.8943382756     , 33.8943417772     , 31.9134728307     , 29.1728452614     ,
 26.1203962063     , 23.2034717608     , 20.6590496368     , 18.5025479707     ,
 16.6491501438     , 15.0028164621     , 13.4737159583     , 11.9765511324     ,
 10.4537806368     , 8.92441181954     , 7.49581704821     , 6.28532123244     ,
 5.31500212593     , 4.49586104868     , 3.7165340034      , 2.94102070711     ,
 2.2263484281      , 1.65848834965     , 1.27603558527     , 1.04756048292     ,
 0.905236497926    , 0.789513097283    , 0.672195758722    , 0.556985759385    ,
 0.4640506738      , 0.407898275869    , 0.386605714433    , 0.389403098824    ,
 0.406977304681    , 0.430478414037    , 0.445898928257    , 0.438537593766    ,
 0.408488626268    , 0.378459863031    , 0.376043215816    , 0.402348267916    ,
 0.42347978323     , 0.401129642163    , 0.330898284563    , 0.245018350547    ,
 0.179604486575    , 0.145785105746    , 0.130810508921    , 0.117941757673    ,
 0.100289858397    , 0.079717180307    , 0.0604345925515   , 0.0464460060774   ,
 0.0408127769159   , 0.0429663257974   , 0.047429980139    , 0.0481672449402   ,
 0.0448996306636   , 0.0435811056206   , 0.0497679082045   , 0.062438367148    ,
 0.0754173897134   , 0.0840665310376   , 0.0882917567033   , 0.0889293640119   ,
 0.0845262485175   , 0.0735104930243   , 0.0573571448819   , 0.0398851320958   ,
 0.0245616704429   , 0.0132042461276   , 0.00610566699354  , 0.00248658915869  ,
 0.00108004874702  , 0.000730379410852 , 0.000697127417735 , 0.000649519830546 ,
 0.000533599371215 , 0.000424362553773 , 0.000435756976413 , 0.00072346754612  ,
 0.00148018093459  , 0.00279185806507  , 0.00451302136626  , 0.00663493124136  ,
 0.0101733294233   , 0.0173377324561   , 0.0295117595159   , 0.0442858394766   ,
 0.0559943494715   , 0.0615992301843   , 0.0656735076168   , 0.0765140917131   ,
 0.115371989163    , 0.145644175778    , 0.161380505076    , 0.153161274323    ,
 0.126386491018    , 0.0949307639223   , 0.0690788460111   , 0.0511228838394   ,
 0.040261691118    , 0.0370890296057   , 0.0421875102883   , 0.0531963844091   ,
 0.0651495012922   , 0.0731140361156   , 0.074598454576    , 0.0716392379509   ,
 0.0727901744086   , 0.0926999879206   , 0.14542318903     , 0.231684848525    ,
 0.330592998785    , 0.409801305355    , 0.450372054304    , 0.460274985952    ,
 0.459499316524    , 0.455229112948    , 0.438167653102    , 0.401938988416    ,
 0.357947604138    , 0.326408292387    , 0.315311552404    , 0.313133448776    ,
 0.303399370327    , 0.282867347804    , 0.26198853203     , 0.248658897913    ,
 0.236468391496    , 0.212729154982    , 0.175889249234    , 0.139258445785    ,
 0.116519079323    , 0.108448000802    , 0.10669747677     , 0.106787474918    ,
 0.111804005583    , 0.123780759186    , 0.137747171819    , 0.147148379122    ,
 0.150990095936    , 0.153102554284    , 0.157688011587    , 0.167116688183    ,
 0.181071850127    , 0.197003252278    , 0.214090237755    , 0.238532733898    ,
 0.285206378619    , 0.372746911287    , 0.511106387597    , 0.686667253657    ,
 0.861425003286    , 0.997646296548    , 1.08840539664     , 1.16113065311     ,
 1.25597818295     , 1.41282217628     , 1.68190676734     , 2.1378530741      ,
 2.87281989469     , 3.96787637308     , 5.46139659273     , 7.3291503032      ,
 9.47299465558     , 11.7235512815     , 13.8956902339     , 15.9071918929     ,
 17.8601804352     , 19.9551851071     , 22.2684239207     , 24.6103015652     ,
 26.649204049      , 28.200764496      , 29.3625744262     , 30.3578109531     ,
 31.3093654229     , 32.1717103368     , 32.78252501       , 32.922698051      ,
 32.3803953204     , 31.0375256502     , 28.9551677583     , 26.4045185356     ,
 23.7691605966     , 21.3410050441     , 19.1965140287     , 17.2731238595     ,
 15.5132923026     , 13.9013908802     , 12.4105999289     , 10.9763609306     ,
 9.541540215       , 8.12454859896     , 6.82659736955     , 5.74931466672     ,
 4.89982825422     , 4.18414463914     , 3.49442835641     , 2.80024125587     ,
 2.15892561545     , 1.64732986804     , 1.29134415124     , 1.05684064984     ,
 0.890190106706    , 0.753785230975    , 0.631933482706    , 0.523379281515    ,
 0.435054967938    , 0.375578245938    , 0.349044779895    , 0.3532660327      ,
 0.380326561058    , 0.41607808715     , 0.441681603638    , 0.442252586265    ,
 0.419789532586    , 0.39641277525     , 0.396247985955    , 0.417968924269    ,
 0.42962899787     , 0.398543194413    , 0.325382164379    , 0.242957930263    ,
 0.183678463289    , 0.154387025332    , 0.140371318113    , 0.12521228734     ,
 0.103353966398    , 0.0782582644774   , 0.0554112197376   , 0.0389476013754   ,
 0.0310069937996   , 0.0305743492289   , 0.0334048638259   , 0.0354948580704   ,
 0.037313985046    , 0.0432815776564   , 0.056001445867    , 0.0717739029729   ,
 0.0835044470783   , 0.0879927698165   , 0.0878330236874   , 0.0854116116228   ,
 0.0786132346119   , 0.0647747734316   , 0.0460061159273   , 0.0279074971961   ,
 0.0145979482841   , 0.00667397832907  , 0.00268321915877  , 0.000960461900521 ,
 0.000343145764191 , 0.000175860809553 , 0.000145068571643 , 0.000132904024862 ,
 0.000126147033689 , 0.000185566905998 , 0.000486016906531 , 0.00139158984709  ,
 0.00337736022331  , 0.00658856028262  , 0.0103494086392   , 0.0135855791718   ,
 0.0164327198841   , 0.021224088616    , 0.0305845516199   , 0.0437117455298   ,
 0.0558106056051   , 0.0635391201892   , 0.071001095466    , 0.0872241823484   ,
 0.130086295879    , 0.168271797106    , 0.192526453752    , 0.190373666178    ,
 0.166171387502    , 0.134911590069    , 0.107785175174    , 0.0873102340848   ,
 0.0742554255468   , 0.0724300246459   , 0.0843707246134   , 0.106076835079    ,
 0.12840261547     , 0.142275841328    , 0.142771167984    , 0.132111325227    ,
 0.121985333543    , 0.131457432488    , 0.176681315162    , 0.256292560543    ,
 0.346203272792    , 0.414386094367    , 0.445254532455    , 0.449011228211    ,
 0.446207024372    , 0.445255563852    , 0.437875386132    , 0.415763279378    ,
 0.386094407983    , 0.365527182359    , 0.360457142544    , 0.359011266539    ,
 0.344931964069    , 0.315885862814    , 0.283982784753    , 0.259048561097    ,
 0.236800885082    , 0.207264767285    , 0.171351664624    , 0.142550234893    ,
 0.131659349847    , 0.135137202318    , 0.141454158302    , 0.145468542814    ,
 0.151388284365    , 0.162655165779    , 0.175668443864    , 0.185414619753    ,
 0.191524610365    , 0.196053380113    , 0.200011030458    , 0.20469663288     ,
 0.212683717558    , 0.225468778933    , 0.243789195693    , 0.273404700494    ,
 0.328763069987    , 0.426261021811    , 0.569446967275    , 0.739194941735    ,
 0.901835074907    , 1.03242688646     , 1.13207061315     , 1.22519323012     ,
 1.34891199002     , 1.55105718889     , 1.89447821627     , 2.45717975051     ,
 3.32297394791     , 4.5604091219      , 6.19368708504     , 8.17704866503     ,
 10.3821160651     , 12.6129747515     , 14.6815539006     , 16.5338913574     ,
 18.3094378546     , 20.2201871463     , 22.3278257324     , 24.4427132655     ,
 26.26614266       , 27.6408025336     , 28.6447401132     , 29.4506729869     ,
 30.1449405754     , 30.67422971       , 30.8848895387     , 30.5885211934     ,
 29.6505404677     , 28.0725858532     , 26.0221559772     , 23.790840216      ,
 21.6678045931     , 19.7813951819     , 18.0621108304     , 16.3840687566     ,
 14.7178620878     , 13.1239576217     , 11.6390685876     , 10.2233139002     ,
 8.82404667105     , 7.46325331641     , 6.24070324114     , 5.24960763947     ,
 4.49295149959     , 3.8791143881      , 3.29783599987     , 2.706395748       ,
 2.14658901598     , 1.6837647867      , 1.34100182998     , 1.09370043387     ,
 0.90782324836     , 0.763955888567    , 0.650544704948    , 0.55500467168     ,
 0.470414554308    , 0.40373896554     , 0.369760293229    , 0.375560483527    ,
 0.410917953659    , 0.452275775995    , 0.475505007148    , 0.468491616741    ,
 0.437969103787    , 0.406189720396    , 0.393957152061    , 0.399283774906    ,
 0.395232680163    , 0.356283527739    , 0.286066587556    , 0.213590569696    ,
 0.164568066979    , 0.141867215823    , 0.130905600297    , 0.116830537679    ,
 0.0949534706617   , 0.0692879646751   , 0.0462001145635   , 0.0303109121919   ,
 0.0233086408625   , 0.0236963360014   , 0.0276993659831   , 0.0323101198113   ,
 0.0382850344589   , 0.048947715236    , 0.0648585388847   , 0.0806552541019   ,
 0.0893791385952   , 0.0900050042425   , 0.0877783668405   , 0.0859422243226   ,
 0.0807280573234   , 0.0671717047487   , 0.0468572478866   , 0.026792107226    ,
 0.0125412071734   , 0.00486501321483  , 0.00160290426504  , 0.000474661929358 ,
 0.000152271094811 , 7.59614688959e-05 , 5.8501389488e-05  , 5.68681613698e-05 ,
 9.19088682624e-05 , 0.000267881471527 , 0.000897416119343 , 0.00266364711785  ,
 0.00647467471335  , 0.0126041224155   , 0.0196268157185   , 0.0248741088068   ,
 0.0270959831718   , 0.0286979215491   , 0.0340500003226   , 0.044664672708    ,
 0.0569610182657   , 0.0668960809222   , 0.07714069019     , 0.0966552693317   ,
 0.138060737328    , 0.17691295346     , 0.205058576436    , 0.210529949298    ,
 0.196256517127    , 0.174410580441    , 0.15324553076     , 0.134531094823    ,
 0.12213352582     , 0.124924806081    , 0.14781106366     , 0.183956188965    ,
 0.218376768836    , 0.237010398447    , 0.232939196035    , 0.210200243754    ,
 0.1861693191      , 0.187180362281    , 0.233353853213    , 0.320418149206    ,
 0.416433533584    , 0.482261125225    , 0.499605589246    , 0.480644098096    ,
 0.452062835503    , 0.430647578911    , 0.414389007106    , 0.395953091224    ,
 0.378730152855    , 0.373165195554    , 0.379392042463    , 0.381799375023    ,
 0.364523550503    , 0.328507821735    , 0.288844025352    , 0.256584910775    ,
 0.228583342724    , 0.197210823514    , 0.164919374402    , 0.14362452578     ,
 0.140962074882    , 0.152022793337    , 0.166170460097    , 0.178801349445    ,
 0.192751657581    , 0.209990483857    , 0.227708513012    , 0.242891135619    ,
 0.254914831159    , 0.262243417364    , 0.262173867987    , 0.256642725661    ,
 0.254034927137    , 0.262468200032    , 0.285331700472    , 0.326572457689    ,
 0.395664395536    , 0.50044002827     , 0.634121390425    , 0.774401042413    ,
 0.900527492762    , 1.01164498937     , 1.12579451245     , 1.26537628645     ,
 1.45465118777     , 1.73392945074     , 2.16872228145     , 2.84203803525     ,
 3.8366961372      , 5.21073248709     , 6.96647061801     , 9.02858208985     ,
 11.2484349047     , 13.4377986657     , 15.4381807465     , 17.2150933624     ,
 18.8937092507     , 20.6535774079     , 22.5499421843     , 24.4354159576     ,
 26.06389982       , 27.2746587189     , 28.0776010147     , 28.5844754927     ,
 28.8925022056     , 29.0106319283     , 28.8373082827     , 28.2123550017     ,
 27.0402268241     , 25.387119746      , 23.4734454877     , 21.5789186385     ,
 19.9057781254     , 18.4681757614     , 17.110904761      , 15.6704458443     ,
 14.1235021748     , 12.5679972638     , 11.0841443386     , 9.66066908156     ,
 8.26179659933     , 6.92176218268     , 5.74288374193     , 4.81330004758     ,
 4.13619744625     , 3.62412697891     , 3.15877748487     , 2.67348779927     ,
 2.18611231878     , 1.75369710787     , 1.40924929419     , 1.14899473892     ,
 0.958837740896    , 0.827534101978    , 0.736382697713    , 0.656971332052    ,
 0.571180179159    , 0.489421996024    , 0.441008033528    , 0.44400093079     ,
 0.485540533796    , 0.530460594501    , 0.546325423683    , 0.521863948508    ,
 0.469171019522    , 0.413694594009    , 0.376724422491    , 0.358177564543    ,
 0.33647289018     , 0.291514753887    , 0.227054845721    , 0.166035770571    ,
 0.127114371534    , 0.11054466155     , 0.103569415851    , 0.0936268509021   ,
 0.076305070486    , 0.0548696772147   , 0.0355370637012   , 0.0232997915289   ,
 0.0199710469094   , 0.0238718915433   , 0.0310298772564   , 0.0382847294957   ,
 0.046217899773    , 0.0577824052843   , 0.0729209328839   , 0.0861257174839   ,
 0.0918010593295   , 0.0915073001065   , 0.0922903120151   , 0.0964123348786   ,
 0.0965042852759   , 0.0841195996815   , 0.0603906836076   , 0.0348984742468   ,
 0.0161274312622   , 0.00598255785608  , 0.00183761279936  , 0.00055475856584  ,
 0.000267149667031 , 0.000218026108816 , 0.00019172354142  , 0.000178916160714 ,
 0.000253103140217 , 0.000583016399169 , 0.00160905094325  , 0.00430929074195  ,
 0.0100463826417   , 0.0193303858686   , 0.0301251888584   , 0.0381762092846   ,
 0.040598251664    , 0.0394677850215   , 0.0406776077089   , 0.0482537740033   ,
 0.0603124996987   , 0.0723283961288   , 0.084820721024    , 0.105043999644    ,
 0.146990775382    , 0.180182774126    , 0.207752725394    , 0.222111855124    ,
 0.224225972263    , 0.219341962621    , 0.209656286674    , 0.19662260207     ,
 0.189411392857    , 0.20281481984     , 0.242473454996    , 0.295795309471    ,
 0.339870525777    , 0.355969467863    , 0.33797854944     , 0.295437068313    ,
 0.254024946466    , 0.248168938336    , 0.301555530154    , 0.405772359051    ,
 0.518320143225    , 0.588581762959    , 0.591796733929    , 0.542029679881    ,
 0.475409895444    , 0.420425660915    , 0.382874288253    , 0.357138042926    ,
 0.343528885813    , 0.346569773528    , 0.360420092951    , 0.366875270567    ,
 0.351586787614    , 0.317753194488    , 0.280132495003    , 0.248112248697    ,
 0.219307446475    , 0.18922338052     , 0.16137108154     , 0.144724034708    ,
 0.144264503613    , 0.157306028695    , 0.178224225975    , 0.203917856271    ,
 0.233319779258    , 0.264017182423    , 0.292702514201    , 0.317478233813    ,
 0.336039856374    , 0.343044919042    , 0.334521695476    , 0.316263113533    ,
 0.303412272341    , 0.308979343291    , 0.336757471266    , 0.387554792231    ,
 0.464843535812    , 0.566892064836    , 0.67715076697     , 0.772858525269    ,
 0.849251145505    , 0.932290462534    , 1.06133021948     , 1.26145385215     ,
 1.54203414575     , 1.92379382706     , 2.46087412966     , 3.2362667098      ,
 4.33723331131     , 5.8202793401      , 7.67395608323     , 9.80383933991     ,
 12.0583203172     , 14.2745786144     , 16.3209045531     , 18.1422614993     ,
 19.7906743458     , 21.384793234      , 23.0019275577     , 24.5917122165     ,
 25.9898655103     , 27.01785039       , 27.5841017564     , 27.7249949051     ,
 27.5725721419     , 27.2476496908     , 26.741748513      , 25.9241583212     ,
 24.6932943076     , 23.111002844      , 21.3935805602     , 19.7907101645     ,
 18.445748359      , 17.3188240295     , 16.2290721201     , 15.0010684225     ,
 13.5989483523     , 12.1185025803     , 10.6564286962     , 9.22725193209     ,
 7.82099152797     , 6.49129007285     , 5.34640108324     , 4.47084802276     ,
 3.86698771949     , 3.44844107337     , 3.08644960991     , 2.69060030722     ,
 2.25780362305     , 1.8422496214      , 1.4927569794      , 1.22844219173     ,
 1.0501617435      , 0.945101340381    , 0.880324899204    , 0.812316150199    ,
 0.717274430657    , 0.612536717518    , 0.541576244754    , 0.533038851136    ,
 0.573259295941    , 0.617044219415    , 0.622286931266    , 0.5757324552      ,
 0.494245882691    , 0.409054710227    , 0.344919980781    , 0.304292844986    ,
 0.26913637923     , 0.222119381191    , 0.165214288924    , 0.115055491082    ,
 0.0843641676457   , 0.0721337139825   , 0.0683042343144   , 0.0630477350957   ,
 0.0522670947776   , 0.0378717052254   , 0.0248928603166   , 0.0180429139785   ,
 0.0193813089569   , 0.0273701992752   , 0.0376661074401   , 0.0463696977922   ,
 0.0535660042623   , 0.0623178904419   , 0.073255720121    , 0.0823779026919   ,
 0.086621823244    , 0.09006780685     , 0.100138375093    , 0.115953237159    ,
 0.124622633232    , 0.113438881577    , 0.0837876714184   , 0.0494337620283   ,
 0.0232081197647   , 0.00875209657606  , 0.00286025685987  , 0.00116045775248  ,
 0.000895898232434 , 0.000883028924019 , 0.000795283073063 , 0.000706128263126 ,
 0.000840123842585 , 0.00145455454155  , 0.00297184112792  , 0.00636674226644  ,
 0.013208469655    , 0.0243874239302   , 0.037969691332    , 0.0490018870192   ,
 0.0531823560016   , 0.0514385297282   , 0.050037737414    , 0.0551212439464   ,
 0.0671518249488   , 0.0820071675399   , 0.097825910279    , 0.118284071935    ,
 0.171070112089    , 0.198300166305    , 0.225211776091    , 0.249930805055    ,
 0.270743530603    , 0.284455655152    , 0.287711527571    , 0.284475105397    ,
 0.291311024946    , 0.327266075775    , 0.393513183304    , 0.466123638417    ,
 0.511806133242    , 0.509555348682    , 0.460182501563    , 0.384751348819    ,
 0.319250989864    , 0.303786068988    , 0.362106170736    , 0.480449446799    ,
 0.607107403811    , 0.681795932819    , 0.674069061487    , 0.599583080349    ,
 0.502469861408    , 0.420184061808    , 0.363355707382    , 0.326592073441    ,
 0.307919170497    , 0.308901046477    , 0.322260561693    , 0.331431584538    ,
 0.324472157135    , 0.303086868155    , 0.276110811829    , 0.24831221175     ,
 0.21892221067     , 0.188471129667    , 0.162128637977    , 0.145901118872    ,
 0.142991528609    , 0.154616794611    , 0.181225387234    , 0.22079589165     ,
 0.267247001134    , 0.313137777237    , 0.354106929562    , 0.388071298888    ,
 0.410206837125    , 0.413310831119    , 0.396500261209    , 0.372277885697    ,
 0.360479006718    , 0.372986245505    , 0.408230658057    , 0.461590697247    ,
 0.532138145854    , 0.613356657897    , 0.685738744957    , 0.731540885976    ,
 0.761693779285    , 0.823360211232    , 0.972950060539    , 1.23979843848     ,
 1.62135293961     , 2.11599190905     , 2.75796606589     , 3.62226249974     ,
 4.79864745164     , 6.34911167788     , 8.26645471746     , 10.4635074178     ,
 12.8072523511     , 15.1590178932     , 17.381201709      , 19.344493784      ,
 20.9819445031     , 22.3446999213     , 23.56824528       , 24.7465646819     ,
 25.8245013337     , 26.6112743567     , 26.9113588823     , 26.6817222525     ,
 26.0864338414     , 25.3639175685     , 24.6119089478     , 23.7294202898     ,
 22.5784476965     , 21.1673697895     , 19.6731100404     , 18.315123588      ,
 17.2063623258     , 16.2886636076     , 15.3843258519     , 14.3243737753     ,
 13.063704573      , 11.6822209189     , 10.2735889254     , 8.86662910832     ,
 7.47393377262     , 6.16748265251     , 5.06156294913     , 4.23793219851     ,
 3.69654775005     , 3.34986914446     , 3.06265865616     , 2.73188139077     ,
 2.3437508432      , 1.95136408988     , 1.61288110591     , 1.36114060604     ,
 1.20444363396     , 1.12405970319     , 1.07330885569     , 0.999991902458    ,
 0.882669558305    , 0.74791335887     , 0.64884585482     , 0.620042192661    ,
 0.647627262809    , 0.680401240885    , 0.669264344655    , 0.599059898178    ,
 0.491047098763    , 0.382380431746    , 0.300559879809    , 0.248142186376    ,
 0.207754391693    , 0.163133300592    , 0.114569304919    , 0.0738438607498   ,
 0.0493849877248   , 0.0396778279693   , 0.0372856783537   , 0.0351218506332   ,
 0.0298239963404   , 0.0221460353488   , 0.015467043483    , 0.0135132578076   ,
 0.0182618043613   , 0.0284794556526   , 0.0398549386519   , 0.0480478189456   ,
 0.0526242392537   , 0.0567003052801   , 0.0620822737092   , 0.0672044798097   ,
 0.0719157746029   , 0.0819796515774   , 0.103760617678    , 0.132441640364    ,
 0.149963156576    , 0.14021284525     , 0.105274167952    , 0.0629127936324   ,
 0.0299569577413   , 0.0116836538148   , 0.00443691074569  , 0.00271756779741  ,
 0.00281212784777  , 0.00295102535138  , 0.0026599840216   , 0.00228713588042  ,
 0.00248898666596  , 0.00370317077858  , 0.00603805672014  , 0.00984772676517  ,
 0.0163844927918   , 0.0270840716774   , 0.0412340154514   , 0.0546627442237   ,
 0.0622838835105   , 0.0630653074318   , 0.0621968653544   , 0.0671263449622   ,
 0.0809353254365   , 0.100686418448    , 0.122455781822    , 0.145592908506    ,
 0.216976292184    , 0.244654817841    , 0.276646753332    , 0.314331704299    ,
 0.352714927061    , 0.382573403453    , 0.399535737749    , 0.413966144794    ,
 0.44995242976     , 0.525827505901    , 0.630234417358    , 0.72136118678     ,
 0.754539307745    , 0.711678930155    , 0.608729431374    , 0.484244663645    ,
 0.384339944059    , 0.349403579418    , 0.39798453747     , 0.510934997805    ,
 0.633186810112    , 0.702756143549    , 0.688609948822    , 0.607112002081    ,
 0.503949915521    , 0.417337959135    , 0.357059288411    , 0.316387559654    ,
 0.292806422381    , 0.288688938308    , 0.29957269573     , 0.313092530096    ,
 0.318992054961    , 0.314172548672    , 0.298469130995    , 0.271470607033    ,
 0.235443233624    , 0.19744928652     , 0.165587505532    , 0.144587680845    ,
 0.137124706553    , 0.147425984536    , 0.17924165182     , 0.229458281261    ,
 0.287248089234    , 0.341876440714    , 0.388901662594    , 0.426160837169    ,
 0.447568714531    , 0.447143947018    , 0.429884210365    , 0.414855691463    ,
 0.422788457156    , 0.458598877072    , 0.50992257653     , 0.563523805971    ,
 0.614696326992    , 0.658099096006    , 0.681553805779    , 0.680984390437    ,
 0.682691579529    , 0.744852461572    , 0.928669363715    , 1.26256083482     ,
 1.73623259282     , 2.33391598985     , 3.07473048608     , 4.02291632629     ,
 5.26267842861     , 6.85672856587     , 8.81048470177     , 11.0645428845     ,
 13.5196150972     , 16.0526974889     , 18.4909812545     , 20.602353171      ,
 22.1917781324     , 23.2543786627     , 24.001276458      , 24.6790811935     ,
 25.3448238096     , 25.8133148569     , 25.8209758041     , 25.2699162943     ,
 24.3419286614     , 23.3533281388     , 22.4785908558     , 21.6374425908     ,
 20.6490318803     , 19.4548605381     , 18.1845328283     , 17.0371430483     ,
 16.1143948394     , 15.3499170665     , 14.5705801984     , 13.6237370833     ,
 12.4744188563     , 11.1964173247     , 9.87251416463     , 8.5312096341      ,
 7.19484120897     , 5.94328618899     , 4.89084063473     , 4.11612441937     ,
 3.61861145911     , 3.31334630761     , 3.0685126078      , 2.78336436187     ,
 2.44336029491     , 2.0971453433      , 1.79809235438     , 1.57819437632     ,
 1.44597800756     , 1.3770744134      , 1.31625783906     , 1.21167450123     ,
 1.0537183062      , 0.881414724568    , 0.752222374775    , 0.698941067656    ,
 0.704975874785    , 0.716854590415    , 0.683685514645    , 0.590876595679    ,
 0.46353430076     , 0.342697617025    , 0.2558641215      , 0.202664885643    ,
 0.164023990543    , 0.124084906637    , 0.0826846679799   , 0.0489203608568   ,
 0.0285713096869   , 0.0198927236275   , 0.0174094574634   , 0.0162711799466   ,
 0.0140431215863   , 0.0107964685284   , 0.00838690249941  , 0.00923291620239  ,
 0.0148332235861   , 0.0242927101476   , 0.0340172875128   , 0.0401084981746   ,
 0.0418941050599   , 0.0420996570301   , 0.0431929792377   , 0.0456715630126   ,
 0.0514381917095   , 0.0664519811623   , 0.0952026958563   , 0.130426399202    ,
 0.152446992302    , 0.14467602493     , 0.109634977319    , 0.0661194006283   ,
 0.0320590367511   , 0.0134190969359   , 0.00670598540168  , 0.00613835812707  ,
 0.00735195297842  , 0.00787155216381  , 0.00705690413566  , 0.00590751180573  ,
 0.00605615809222  , 0.00834938387367  , 0.012206338129    , 0.0165598716661   ,
 0.0217213936943   , 0.0298295211751   , 0.0424021095152   , 0.0573068330645   ,
 0.0693736766568   , 0.0754322473704   , 0.0788357446828   , 0.087400025473    ,
 0.10596049366     , 0.132428321592    , 0.16155628509     , 0.189931231286    ,
 0.27556076749     , 0.313048899578    , 0.35969285138     , 0.41555320277     ,
 0.472284678318    , 0.519052946178    , 0.555218350551    , 0.598709464136    ,
 0.677854238583    , 0.804229765469    , 0.948247086092    , 1.04829315009     ,
 1.05172584356     , 0.949954066424    , 0.779430963961    , 0.596991182425    ,
 0.454829864063    , 0.387610792236    , 0.405191754549    , 0.485438885667    ,
 0.577996246291    , 0.628865324576    , 0.612183689084    , 0.543239676594    ,
 0.461058516554    , 0.395469064398    , 0.350510011391    , 0.318217220478    ,
 0.298281597734    , 0.296761679438    , 0.312958441286    , 0.336983206914    ,
 0.357590843142    , 0.365951979779    , 0.354520731653    , 0.320139683603    ,
 0.269240884905    , 0.215320540081    , 0.170132681822    , 0.139389259291    ,
 0.126631466778    , 0.137162063222    , 0.173968969283    , 0.230378121152    ,
 0.291598186391    , 0.345655415097    , 0.389380479561    , 0.422157023395    ,
 0.439654038857    , 0.439424664348    , 0.431366912847    , 0.437859404976    ,
 0.478229156797    , 0.550225394929    , 0.630377365216    , 0.694021622097    ,
 0.729124184103    , 0.732583238406    , 0.707379765964    , 0.67196609427     ,
 0.668912769578    , 0.757236559427    , 0.987919951772    , 1.37943942599     ,
 1.91830245739     , 2.5914033815      , 3.42156973989     , 4.47038328354     ,
 5.80745839925     , 7.47570911085     , 9.47495664587     , 11.7658007692     ,
 14.2800060379     , 16.9070098133     , 19.4448820122     , 21.5874748765     ,
 23.0530824711     , 23.8019562671     , 24.0992039592     , 24.2939636316     ,
 24.520562838      , 24.6176529103     , 24.3183269792     , 23.5248355939     ,
 22.4275882145     , 21.354154203      , 20.4899449708     , 19.754456004      ,
 18.9409015803     , 17.9468177324     , 16.8667055469     , 15.8860180475     ,
 15.1023348613     , 14.4442585175     , 13.7422191179     , 12.8652134332     ,
 11.8026802544     , 10.632766649      , 9.42533955657     , 8.19834706775     ,
 6.9701794153      , 5.81332494032     , 4.83102785117     , 4.09744336556     ,
 3.61826655762     , 3.32151160649     , 3.09087248402     , 2.83897229241     ,
 2.55513798097     , 2.27812722257     , 2.04379147288     , 1.87096027479     ,
 1.76294764497     , 1.6915654224      , 1.59869112092     , 1.44012230704     ,
 1.22548634967     , 1.00996706037     , 0.852414753297    , 0.777110248939    ,
 0.760806672263    , 0.749613068196    , 0.694867566006    , 0.583739984049    ,
 0.443056347511    , 0.315376892018    , 0.227538450391    , 0.176464532688    ,
 0.141162790687    , 0.105709473138    , 0.0696958006832   , 0.0405299469978   ,
 0.0222796562309   , 0.0131579784993   , 0.00919998657584  , 0.00729645802173  ,
 0.00585530849529  , 0.00457807817643  , 0.00415066635113  , 0.00574242710872  ,
 0.0101605217727   , 0.01678208721     , 0.0231870609447   , 0.0266787964549   ,
 0.0267278941513   , 0.0253113407309   , 0.024681265806    , 0.0262018593633   ,
 0.0322714274122   , 0.047544536855    , 0.0745495570087   , 0.106241493766    ,
 0.126071573195    , 0.120538852248    , 0.0920176964678   , 0.0563323626878   ,
 0.0286367769651   , 0.0142250283906   , 0.0104856708596   , 0.0124769341021   ,
 0.0156567583538   , 0.0167336370118   , 0.0148636979116   , 0.012133983832    ,
 0.011804786448    , 0.0154498797506   , 0.0215312001211   , 0.0269632162693   ,
 0.0307267699274   , 0.035777083976    , 0.0462468587882   , 0.062356206721    ,
 0.0791782085267   , 0.0919343634566   , 0.102422145976    , 0.117996266676    ,
 0.14331244466     , 0.175670543218    , 0.209538450832    , 0.24240617861     ,
 0.33111324591     , 0.385892320292    , 0.456033861647    , 0.537381155086    ,
 0.619178218006    , 0.691439645198    , 0.756657249272    , 0.835493619997    ,
 0.954880789506    , 1.11772333782     , 1.2800697285      , 1.36869886068     ,
 1.33128798926     , 1.17218537702     , 0.944580729524    , 0.715147171923    ,
 0.534442379481    , 0.428160313407    , 0.399079450262    , 0.427207318655    ,
 0.473657829885    , 0.498249693739    , 0.482556102695    , 0.438340914886    ,
 0.39237404482     , 0.360973820644    , 0.340534607611    , 0.323099459065    ,
 0.313159342668    , 0.322267230151    , 0.352527482664    , 0.392811849814    ,
 0.427616945719    , 0.442940684124    , 0.427805740902    , 0.379894224735    ,
 0.310292933531    , 0.237372586635    , 0.175797433953    , 0.133170552065    ,
 0.114556760274    , 0.12510587638     , 0.165057936172    , 0.223767231802    ,
 0.283735641651    , 0.332606989827    , 0.368431773368    , 0.393049568527    ,
 0.405927332961    , 0.408261450359    , 0.411464017168    , 0.437788045602    ,
 0.50652717147     , 0.614759947581    , 0.733966605384    , 0.827486609251    ,
 0.869187445429    , 0.852445773935    , 0.796077085308    , 0.745306836791    ,
 0.759359669579    , 0.890944066124    , 1.16987071288     , 1.5984821774      ,
 2.16641554576     , 2.88304885052     , 3.79967843671     , 4.99023305021     ,
 6.50263675519     , 8.32995870024     , 10.4256430931     , 12.7341894671     ,
 15.1975994191     , 17.7233098322     , 20.1257205733     , 22.1063831041     ,
 23.374895626      , 23.8755155564     , 23.8694672341     , 23.7164309735     ,
 23.5685162507     , 23.2991833939     , 22.7038971553     , 21.746961506      ,
 20.6288107902     , 19.6254444416     , 18.8607626995     , 18.2307979993     ,
 17.535314155      , 16.6730319588     , 15.7214836105     , 14.8452327698     ,
 14.1322005586     , 13.5156912319     , 12.8442909943     , 12.0150672775     ,
 11.0398814425     , 9.99724623311     , 8.94109982609     , 7.87426017685     ,
 6.80104596105     , 5.77233000019     , 4.86994978049     , 4.16360180791     ,
 3.67447230478     , 3.35586464169     , 3.11653596786     , 2.88677669933     ,
 2.65924706036     , 2.4588687818      , 2.29787884575     , 2.17574453218     ,
 2.0879414691      , 2.00543953134     , 1.87249597633     , 1.65535050738     ,
 1.383077488       , 1.12718862874     , 0.947876588293    , 0.859269420777    ,
 0.829578193468    , 0.804209692958    , 0.736674324461    , 0.613709360956    ,
 0.460696027119    , 0.321200920741    , 0.224655429683    , 0.169501561145    ,
 0.134753575645    , 0.103517970535    , 0.07319999934     , 0.0482244643853   ,
 0.0306721515263   , 0.0190397740193   , 0.0113182954139   , 0.00641671304836  ,
 0.00368755114085  , 0.00257764630918  , 0.00279544706378  , 0.00434880507794  ,
 0.00719709521045  , 0.0107450859572   , 0.013702316167    , 0.0148264232523   ,
 0.0140864874333   , 0.0128270319619   , 0.0126679338056   , 0.0148224996464   ,
 0.0208465593292   , 0.0330782307005   , 0.0522466126695   , 0.0733958575337   ,
 0.0860844620077   , 0.0821213395665   , 0.0635576116503   , 0.0409900689607   ,
 0.0243324340171   , 0.0170006870751   , 0.0174075813031   , 0.0221908222557   ,
 0.0272050550743   , 0.0284885005411   , 0.0249698877454   , 0.0199299600114   ,
 0.0184598527199   , 0.022994136802    , 0.0311204605266   , 0.0379049523447   ,
 0.0412349437561   , 0.0449070585035   , 0.0551874960884   , 0.0738534400435   ,
 0.0958899453869   , 0.115492739095    , 0.133608644945    , 0.156692305207    ,
 0.187624857202    , 0.221998386263    , 0.255270534793    , 0.289493367718    ,
 0.379190777451    , 0.453381907747    , 0.548723662106    , 0.658732784412    ,
 0.77284924952     , 0.880657598553    , 0.9805823235      , 1.08658346269     ,
 1.21946590102     , 1.37863878779     , 1.52024665143     , 1.576067159       ,
 1.50341522937     , 1.31621047189     , 1.07056743099     , 0.827256636528    ,
 0.626396194995    , 0.485603359836    , 0.407137416472    , 0.379707384715    ,
 0.379385085481    , 0.379954778674    , 0.368522988443    , 0.35119879748     ,
 0.341370889847    , 0.341780958332    , 0.341685646875    , 0.334048270231    ,
 0.329527962543    , 0.346438109998    , 0.389660338058    , 0.445147547092    ,
 0.491405727839    , 0.509698547789    , 0.488282496891    , 0.427939222053    ,
 0.344048402175    , 0.257592659816    , 0.184036307218    , 0.131679845097    ,
 0.106467606649    , 0.113350682486    , 0.151089806078    , 0.207709662017    ,
 0.265345325157    , 0.311326353609    , 0.343042093492    , 0.362957492299    ,
 0.373097546879    , 0.376428301253    , 0.383247382712    , 0.414688895755    ,
 0.493712631005    , 0.625430939027    , 0.785470077097    , 0.928294641854    ,
 1.00854965126     , 1.00721312851     , 0.952126243251    , 0.911933329541    ,
 0.960224507251    , 1.14039514147     , 1.45850039775     , 1.90187889086     ,
 2.47127398629     , 3.21348190289     , 4.22537313703     , 5.60352091167     ,
 7.36860156937     , 9.43949064658     , 11.6859700406     , 13.9977281985     ,
 16.3021453561     , 18.5332174755     , 20.5776665549     , 22.2347242106     ,
 23.2800445182     , 23.6480316024     , 23.5281736579     , 23.2018270778     ,
 22.7893411824     , 22.2065419754     , 21.3521175803     , 20.2892020654     ,
 19.2316420795     , 18.3689672816     , 17.7192144747     , 17.1434781402     ,
 16.480720081      , 15.6724568392     , 14.789680675      , 13.9569056124     ,
 13.2391460221     , 12.5887384369     , 11.8981168251     , 11.1018244929     ,
 10.2235809606     , 9.3290301849      , 8.45069219171     , 7.57305847542     ,
 6.67946407572     , 5.79197143566     , 4.96906024803     , 4.27943441935     ,
 3.76562692596     , 3.41115403266     , 3.15111436917     , 2.93130848142     ,
 2.74560342966     , 2.60581682958     , 2.50284164155     , 2.41753123565     ,
 2.33812962288     , 2.23922889956     , 2.0728647         , 1.81403521243     ,
 1.50270116952     , 1.22051472374     , 1.03015084386     , 0.939809116639    ,
 0.910943740696    , 0.886467018548    , 0.818283686262    , 0.688930717106    ,
 0.520697187439    , 0.360089835317    , 0.243945553834    , 0.177098237791    ,
 0.140709565084    , 0.115689281661    , 0.0942712729016   , 0.075241579929    ,
 0.0574880909223   , 0.0401386742932   , 0.0244865925353   , 0.0128587494037   ,
 0.00630101194597  , 0.00412549801579  , 0.00491671250249  , 0.0072263274022   ,
 0.00966611233044  , 0.0110836383455   , 0.0109438998324   , 0.00953238834668  ,
 0.00784524070742  , 0.0072585238985   , 0.00904378968056  , 0.0138844549528   ,
 0.0216798720361   , 0.0317465310374   , 0.0428153131092   , 0.0522559964206   ,
 0.0560920354145   , 0.0518830295876   , 0.0419957611918   , 0.0322717737977   ,
 0.0270297600303   , 0.0266908250834   , 0.0298328127661   , 0.0349265491301   ,
 0.0393254736651   , 0.0393665869124   , 0.0338930073      , 0.0267195922623   ,
 0.0238566808321   , 0.0281551782564   , 0.0368325985289   , 0.0443334446579   ,
 0.0484455999938   , 0.0536899089032   , 0.067270127915    , 0.0910873280017   ,
 0.119229726961    , 0.144871729181    , 0.168430846058    , 0.195708668625    ,
 0.228257670559    , 0.260958126146    , 0.291503336395    , 0.327219034518    ,
 0.434605669554    , 0.523459304002    , 0.633193952327    , 0.761341409427    ,
 0.902208410435    , 1.04289345337     , 1.16988063363     , 1.28254350337     ,
 1.39389483269     , 1.50779475544     , 1.59613319316     , 1.61102132951     ,
 1.52501711909     , 1.35406270338     , 1.14130597588     , 0.926454499387    ,
 0.73224487323     , 0.570936618838    , 0.451818698058    , 0.378052518445    ,
 0.341147391449    , 0.325218927533    , 0.319077478254    , 0.322518537191    ,
 0.338145891851    , 0.35821569013     , 0.366278111216    , 0.356294314725    ,
 0.34498191524     , 0.357741212878    , 0.403212415775    , 0.465655029665    ,
 0.518281254799    , 0.538030509002    , 0.513224658007    , 0.448190106238    ,
 0.361281586237    , 0.273345512842    , 0.197724056273    , 0.140927107063    ,
 0.108365904333    , 0.105582740475    , 0.133160197856    , 0.182184171406    ,
 0.237488232857    , 0.286146312457    , 0.32215873999     , 0.344627100334    ,
 0.354556211862    , 0.354796078914    , 0.354527296815    , 0.374827339677    ,
 0.444577390108    , 0.581922457791    , 0.774383891491    , 0.974483152617    ,
 1.11898231337     , 1.17035185611     , 1.15460250596     , 1.15343872066     ,
 1.24935119837     , 1.4774062816      , 1.82600475325     , 2.27554184724     ,
 2.84429679136     , 3.6186992127      , 4.73892795097     , 6.31972159361     ,
 8.35082420579     , 10.6745865773     , 13.0728521155     , 15.3711487437     ,
 17.4718230418     , 19.3362564066     , 20.9468182734     , 22.2420013344     ,
 23.0972679066     , 23.4325396051     , 23.3221390763     , 22.9244852499     ,
 22.3168922747     , 21.4732483033     , 20.4082114503     , 19.2805315803     ,
 18.3078079864     , 17.5858594698     , 17.0231588494     , 16.4501645022     ,
 15.7612264883     , 14.9580421914     , 14.1068085814     , 13.2782834977     ,
 12.5046965042     , 11.7657587326     , 11.0154615331     , 10.233225305      ,
 9.44703154882     , 8.69913625972     , 7.99531635002     , 7.29880860126     ,
 6.5706859805      , 5.8092213667      , 5.05935902546     , 4.39446681        ,
 3.87498958377     , 3.50501627972     , 3.23512117404     , 3.01871975773     ,
 2.84980127026     , 2.73424899314     , 2.65268449962     , 2.5748703755      ,
 2.48449620765     , 2.36305567411     , 2.174194353       , 1.89828400496     ,
 1.57447237183     , 1.28473336355     , 1.09403900067     , 1.01050770359     ,
 0.992686305837    , 0.979782163612    , 0.918672069936    , 0.785858049444    ,
 0.601254940462    , 0.41627863586     , 0.27723695163     , 0.197107815971    ,
 0.160091034689    , 0.144393636108    , 0.13546919438     , 0.124576501121    ,
 0.105998920159    , 0.0793074045555   , 0.0504443283977   , 0.0272098492673   ,
 0.0138179563178   , 0.00986303580404  , 0.0124594158723   , 0.0178491622776   ,
 0.0220944085433   , 0.0223993763611   , 0.0186059653356   , 0.013036988256    ,
 0.00878447202952  , 0.00834828267522  , 0.0132974006029   , 0.0237459499872   ,
 0.0372976728129   , 0.0493836394974   , 0.0559722965821   , 0.0559619480258   ,
 0.0508963675245   , 0.0438002021329   , 0.0386544470836   , 0.0385782589799   ,
 0.0429206576258   , 0.0476813880468   , 0.0499455627664   , 0.0501656607634   ,
 0.0491504673398   , 0.0455569920833   , 0.0385687285133   , 0.0311106031907   ,
 0.0280047324149   , 0.0313523380045   , 0.0386503061141   , 0.0455520852244   ,
 0.0510597215461   , 0.0601194165024   , 0.0795336557895   , 0.110192245401    ,
 0.144724343081    , 0.174862418722    , 0.2002532896      , 0.226938304553    ,
 0.257776871813    , 0.289973343892    , 0.324022562974    , 0.368953839787    ,
 0.522232025673    , 0.615487595047    , 0.717436554796    , 0.83674992269     ,
 0.978706678815    , 1.12975917024     , 1.26343378439     , 1.36334651533     ,
 1.43492845485     , 1.48916704718     , 1.51901317016     , 1.50205243865     ,
 1.42680932203     , 1.30635947645     , 1.16311135965     , 1.00877932716     ,
 0.845398909842    , 0.68127223347     , 0.537065850801    , 0.433270177984    ,
 0.374788224167    , 0.350397798817    , 0.346527703427    , 0.358098296846    ,
 0.382527584554    , 0.406629327555    , 0.410080618273    , 0.387327878134    ,
 0.359709862231    , 0.358260562919    , 0.395172999911    , 0.454466230785    ,
 0.505989770732    , 0.524029319887    , 0.498480566152    , 0.437651375522    ,
 0.361071089031    , 0.286047624013    , 0.220288218052    , 0.165696732271    ,
 0.12586756141     , 0.10823586234     , 0.118809383844    , 0.155668518255    ,
 0.208601266725    , 0.264205443045    , 0.310631929937    , 0.339987088422    ,
 0.349579367909    , 0.342331976276    , 0.328438801325    , 0.329690483721    ,
 0.379037318911    , 0.506342962627    , 0.714671233239    , 0.963702767125    ,
 1.18121787739     , 1.31181421975     , 1.36939791259     , 1.43412794773     ,
 1.5889659599      , 1.86414800778     , 2.24299164636     , 2.7113673373      ,
 3.30697304023     , 4.14191558397     , 5.37502543478     , 7.11935417599     ,
 9.33521876188     , 11.8151091991     , 14.2914646782     , 16.556470074      ,
 18.4967635118     , 20.0845981701     , 21.363621608      , 22.3795310621     ,
 23.0940210682     , 23.4135257835     , 23.3016381175     , 22.8055420088     ,
 21.9863382583     , 20.9025784167     , 19.6822786894     , 18.5458576783     ,
 17.6835586346     , 17.0979948744     , 16.6093409912     , 16.0299394792     ,
 15.3048879083     , 14.4895982557     , 13.6490326618     , 12.8079690352     ,
 11.96755984       , 11.1313029029     , 10.3123568589     , 9.53355783607     ,
 8.82270890172     , 8.19286270322     , 7.62062715906     , 7.05154083993     ,
 6.43540599994     , 5.76377887636     , 5.08262818534     , 4.47149235687     ,
 3.99551715225     , 3.65939148216     , 3.41146442896     , 3.20247380257     ,
 3.02646330279     , 2.89408634083     , 2.79162761283     , 2.68901039729     ,
 2.56782969237     , 2.41555816942     , 2.20779547445     , 1.92880317639     ,
 1.61037693247     , 1.32700496945     , 1.14263146237     , 1.06704844942     ,
 1.05919676771     , 1.05694880159     , 1.00391687013     , 0.872237261876    ,
 0.679721149358    , 0.480337755816    , 0.326244605184    , 0.236436077226    ,
 0.198625425421    , 0.190360695851    , 0.192341711322    , 0.189060780629    ,
 0.169319743374    , 0.131750253673    , 0.0867133341926   , 0.0486852670096   ,
 0.0265806889869   , 0.0211600983019   , 0.0280008867591   , 0.0399787319728   ,
 0.0488578715819   , 0.0486933209344   , 0.0394410045368   , 0.0265584478458   ,
 0.0168851789542   , 0.0153333480887   , 0.0242694850248   , 0.0430010067459   ,
 0.0661459479331   , 0.0844573120287   , 0.0904044651581   , 0.0835086794239   ,
 0.0697398071031   , 0.0572317520899   , 0.0528712238587   , 0.0590960453737   ,
 0.0709715187707   , 0.0787744477185   , 0.0765332997282   , 0.0668497864512   ,
 0.0560083866271   , 0.0471964469626   , 0.0405119301442   , 0.0364419897067   ,
 0.0361570713917   , 0.0395182864826   , 0.0447449631364   , 0.050225689953    ,
 0.0570093843854   , 0.0699266008106   , 0.0945494357174   , 0.130770708353    ,
 0.170216468836    , 0.203064318705    , 0.227827379286    , 0.25177994158     ,
 0.282095558036    , 0.32130067064     , 0.372055656631    , 0.439044242417    ,
 0.658341266739    , 0.745164173814    , 0.815409185703    , 0.893106174311    ,
 1.00047404821     , 1.13001936975     , 1.24895111603     , 1.32940610282     ,
 1.36875391676     , 1.38017482727     , 1.3712380091      , 1.33991101922     ,
 1.2881878503      , 1.22660830294     , 1.15942401588     , 1.07340648048     ,
 0.951670208221    , 0.799238694487    , 0.648581058852    , 0.536311664629    ,
 0.475498895103    , 0.451772973549    , 0.444777508501    , 0.447902774416    ,
 0.461842313769    , 0.474924758678    , 0.464969236763    , 0.425412530276    ,
 0.379524035888    , 0.361208693759    , 0.38431097203     , 0.432358741698    ,
 0.47341183355     , 0.482277453164    , 0.453976521033    , 0.402394587542    ,
 0.346672296459    , 0.297086338505    , 0.252183176834    , 0.206725419005    ,
 0.161633598801    , 0.12753720411     , 0.118492073877    , 0.141591628209    ,
 0.191948661639    , 0.25490253178     , 0.311545058635    , 0.345907334387    ,
 0.351793623435    , 0.334350170302    , 0.307038654924    , 0.291395473337    ,
 0.319330604933    , 0.426648993154    , 0.631379703816    , 0.908492820208    ,
 1.18991479897     , 1.41006972658     , 1.56498950145     , 1.71794337376     ,
 1.94095944057     , 2.26241544471     , 2.67583629003     , 3.18706451662     ,
 3.85157645199     , 4.78260834217     , 6.12007021569     , 7.94941456237     ,
 10.2106427988     , 12.692776677      , 15.1410209991     , 17.3634669583     ,
 19.2448665537     , 20.7339615253     , 21.8610200947     , 22.702190593      ,
 23.2718056257     , 23.4843143935     , 23.2432220487     , 22.5351203512     ,
 21.4444536898     , 20.1353486324     , 18.8366589455     , 17.7850690983     ,
 17.0997325473     , 16.6847264384     , 16.2968140936     , 15.7440046687     ,
 15.0080227922     , 14.1822931737     , 13.3399383977     , 12.4842706281     ,
 11.5966796301     , 10.6946853814     , 9.83473980056     , 9.07224214952     ,
 8.42684038633     , 7.87585920364     , 7.36828598825     , 6.84724639664     ,
 6.2757323054      , 5.65933434217     , 5.05106435523     , 4.52682682261     ,
 4.13866404634     , 3.87551046499     , 3.67314056448     , 3.47489435748     ,
 3.27575216966     , 3.09885492244     , 2.94785741669     , 2.80112716287     ,
 2.63851599483     , 2.44918656352     , 2.21841018317     , 1.93596996712     ,
 1.6275277955      , 1.35689307128     , 1.18101917226     , 1.10776026296     ,
 1.09854834043     , 1.09700914457     , 1.05159947401     , 0.934038281696    ,
 0.756560571839    , 0.566382219118    , 0.412069957475    , 0.314332003333    ,
 0.266448614807    , 0.251353643231    , 0.25155788316     , 0.248955490581    ,
 0.227262860486    , 0.181641937535    , 0.123793894852    , 0.0732427624784   ,
 0.0438025794892   , 0.0385016549129   , 0.0521505940837   , 0.0739356607196   ,
 0.0900355212515   , 0.090029775401    , 0.0736432446713   , 0.050396435391    ,
 0.0324199540237   , 0.0281214302625   , 0.0406528016733   , 0.0677631221217   ,
 0.100620701176    , 0.125681900699    , 0.132449863933    , 0.120611150356    ,
 0.0991229065184   , 0.0801415099086   , 0.0737665035228   , 0.0830443123331   ,
 0.0998755859226   , 0.109133254019    , 0.101507750899    , 0.0814996005641   ,
 0.0612075701824   , 0.0491671763792   , 0.0467640533648   , 0.0511779569505   ,
 0.0582701615144   , 0.0646209522864   , 0.0694522957806   , 0.0745656434405   ,
 0.0828400172069   , 0.0980942402319   , 0.124528407816    , 0.162221218231    ,
 0.203261907901    , 0.236907830531    , 0.260597538071    , 0.283434261476    ,
 0.318388819649    , 0.374413956755    , 0.454900647876    , 0.555129573274    ,
 0.83458293768     , 0.909932347381    , 0.93580138126     , 0.951676504917    ,
 1.00048597726     , 1.08814468878     , 1.1832714875      , 1.25059086232     ,
 1.27793865571     , 1.27430526067     , 1.25275021091     , 1.22298327728     ,
 1.19567671611     , 1.17977675538     , 1.1677617815      , 1.13082421966     ,
 1.04142569136     , 0.905182724798    , 0.765330931663    , 0.669414081703    ,
 0.62981584657     , 0.619172137809    , 0.605450466747    , 0.584624387511    ,
 0.570600915257    , 0.561321951688    , 0.534464436087    , 0.479353042336    ,
 0.417219335417    , 0.382137433526    , 0.388152568529    , 0.41793310493     ,
 0.4391305981      , 0.430311111692    , 0.394851586767    , 0.35323254407     ,
 0.322926232995    , 0.305122649101    , 0.287485936501    , 0.256519357387    ,
 0.210062809341    , 0.162259648958    , 0.135615199904    , 0.145745433565    ,
 0.191906704674    , 0.257821847895    , 0.318813806543    , 0.353016988959    ,
 0.352824135372    , 0.327161263098    , 0.293054912571    , 0.269649282646    ,
 0.282770787993    , 0.367814619293    , 0.554225440741    , 0.836211675104    ,
 1.16164312248     , 1.46669155033     , 1.73070804037     , 1.98852094517     ,
 2.28810172974     , 2.65456059026     , 3.10333900861     , 3.67304769354     ,
 4.43575337028     , 5.48471725892     , 6.90971107842     , 8.7494775575      ,
 10.9361370279     , 13.2983489786     , 15.6454849301     , 17.8347624147     ,
 19.7482823156     , 21.2726844058     , 22.3589356309     , 23.0512716835     ,
 23.396612626      , 23.3541596037     , 22.8353249609     , 21.8232357929     ,
 20.4490892581     , 18.9755461127     , 17.7043273239     , 16.8479673438     ,
 16.4210040151     , 16.2250798579     , 15.9750318006     , 15.4896072683     ,
 14.7783832796     , 13.9593733239     , 13.1200967703     , 12.2628670296     ,
 11.3604388072     , 10.4370730366     , 9.57710661468     , 8.85514803906     ,
 8.27279192077     , 7.76650069625     , 7.2636406007      , 6.72514068747     ,
 6.15196374829     , 5.57603256266     , 5.04952634197     , 4.62568123419     ,
 4.32861934204     , 4.12891151386     , 3.95595659115     , 3.75234648236     ,
 3.51701691721     , 3.28666606939     , 3.08335010508     , 2.89421210892     ,
 2.69521952191     , 2.47274279376     , 2.21900229106     , 1.93188012659     ,
 1.63525550406     , 1.38164615621     , 1.21503778936     , 1.1365594485      ,
 1.11245482265     , 1.10149843538     , 1.06763008407     , 0.986129289709    ,
 0.856866335909    , 0.706322332036    , 0.566813022876    , 0.456103016364    ,
 0.377306543261    , 0.328199057498    , 0.302788549139    , 0.286810389306    ,
 0.260651229177    , 0.213210389462    , 0.15205590221     , 0.0968448182042   ,
 0.0643178054817   , 0.0605227131381   , 0.0811977527178   , 0.113157857006    ,
 0.137547131739    , 0.139183789225    , 0.116692861951    , 0.0830477853262   ,
 0.0559440462108   , 0.047806349489    , 0.0621542508285   , 0.0940423259228   ,
 0.131217028951    , 0.158034551775    , 0.163587248281    , 0.148036423758    ,
 0.121234564701    , 0.0968689071241   , 0.086958138945    , 0.0955550760797   ,
 0.11350425297     , 0.123140381776    , 0.113317815223    , 0.0893591967499   ,
 0.0668719001978   , 0.0583741333043   , 0.0664619418213   , 0.0850537375588   ,
 0.104395015854    , 0.117798720845    , 0.125987893413    , 0.134142541091    ,
 0.145864696837    , 0.162895192946    , 0.188289179256    , 0.223502371923    ,
 0.262186200665    , 0.293472197049    , 0.314519795162    , 0.33690595343     ,
 0.37950430265     , 0.457159419713    , 0.572826912597    , 0.710560127727    ,
 1.01530125142     , 1.08307064789     , 1.07134416803     , 1.03146203891     ,
 1.02621645946     , 1.07723683672     , 1.15676558386     , 1.22255201543     ,
 1.2527473228      , 1.2515947452      , 1.23455667291     , 1.21665923401     ,
 1.21019570768     , 1.21907489986     , 1.22754365845     , 1.2021290208      ,
 1.11810733961     , 0.99000196272     , 0.871062382482    , 0.812148734352    ,
 0.814856034548    , 0.830032392945    , 0.810020990851    , 0.756245633836    ,
 0.703436715444    , 0.666071697375    , 0.62333724607     , 0.556860620212    ,
 0.481015304564    , 0.427592458384    , 0.411235730642    , 0.41580008059     ,
 0.41113605502     , 0.381334733682    , 0.337634018764    , 0.304949115019    ,
 0.297639802338    , 0.308399493996    , 0.315894345603    , 0.300133167367    ,
 0.256389405712    , 0.201062803256    , 0.162404213987    , 0.16142672907     ,
 0.199654967666    , 0.260375923633    , 0.317433869448    , 0.347793250902    ,
 0.344477538114    , 0.319057937589    , 0.289816867245    , 0.271514646561    ,
 0.281459976976    , 0.350465466314    , 0.51453881596     , 0.785740843112    ,
 1.13403155493     , 1.50922618975     , 1.88261806004     , 2.25814937274     ,
 2.64915014673     , 3.06919665986     , 3.55539503173     , 4.18286281661     ,
 5.04108085639     , 6.19874612313     , 7.688181347       , 9.49774170713     ,
 11.5587850171     , 13.7579119901     , 15.9863266827     , 18.1521086819     ,
 20.1180770399     , 21.6858656779     , 22.709523096      , 23.1928667553     ,
 23.2214139783     , 22.8279516987     , 21.9765112858     , 20.6783960257     ,
 19.1055608853     , 17.5822423512     , 16.443119107      , 15.8534886583     ,
 15.7191534219     , 15.7501584245     , 15.6389365988     , 15.2304536658     ,
 14.5637176614     , 13.7747991735     , 12.9635555095     , 12.1354950793     ,
 11.2566275371     , 10.3515224332     , 9.52034074939     , 8.84730123772     ,
 8.31521043073     , 7.82740743495     , 7.30070027003     , 6.7236810216      ,
 6.14040925535     , 5.60558687414     , 5.15824886136     , 4.81561485406     ,
 4.5696939775      , 4.381044411       , 4.18770208578     , 3.94405145521     ,
 3.65766661482     , 3.37568467515     , 3.13164196789     , 2.91588809398     ,
 2.69775530087     , 2.45845553411     , 2.19507582762     , 1.91419816303     ,
 1.63966682596     , 1.411482141       , 1.25697666668     , 1.16909559023     ,
 1.12245263164     , 1.09841634634     , 1.0839588612      , 1.06037794464     ,
 1.00912303487     , 0.923679812661    , 0.808812320919    , 0.675458159893    ,
 0.541408621413    , 0.428965045574    , 0.352779883543    , 0.308072627587    ,
 0.273572515951    , 0.229623750148    , 0.174294898711    , 0.121834302771    ,
 0.089044414775    , 0.0851381965147   , 0.108691764996    , 0.146933300467    ,
 0.178731349771    , 0.185149946692    , 0.161962020467    , 0.122623892045    ,
 0.0887576636909   , 0.0768590623691   , 0.0907595804431   , 0.121988653165    ,
 0.155153285481    , 0.175353419294    , 0.174809726043    , 0.155277342354    ,
 0.125641015886    , 0.098115550938    , 0.0842984348889   , 0.0888752423172   ,
 0.10411659        , 0.113991115118    , 0.107917179114    , 0.0904547433356   ,
 0.0769225013416   , 0.0811416373438   , 0.106393204335    , 0.14382405293     ,
 0.17880775831     , 0.202437612315    , 0.217739621725    , 0.232968658229    ,
 0.251540559035    , 0.272924544645    , 0.299361279118    , 0.333045040155    ,
 0.367632952168    , 0.391651102083    , 0.40345799809     , 0.418958178236    ,
 0.46343017202     , 0.556912193606    , 0.701584429971    , 0.871718743357    ,
 1.15785588642     , 1.22750232713     , 1.20188635673     , 1.13775352043     ,
 1.11075919761     , 1.15304481235     , 1.23647527445     , 1.31011664737     ,
 1.34529138176     , 1.3474589967      , 1.33806347232     , 1.33469883335     ,
 1.34380447084     , 1.35774866009     , 1.3529564728      , 1.30056890621     ,
 1.19169737497     , 1.05739370444     , 0.958717148959    , 0.9421416911      ,
 0.992547346199    , 1.03743116046     , 1.01369251029     , 0.927752315904    ,
 0.835325877699    , 0.769889132387    , 0.714790027153    , 0.643181687203    ,
 0.558628270037    , 0.48745982511     , 0.445524693644    , 0.421815565074    ,
 0.392330681322    , 0.346725268237    , 0.299564757834    , 0.27499557028     ,
 0.282797320698    , 0.310112175183    , 0.331701881378    , 0.325727726793    ,
 0.286826335032    , 0.231554973099    , 0.188853226666    , 0.180106000145    ,
 0.206962108267    , 0.254426956073    , 0.300438105261    , 0.326187827426    ,
 0.326650327841    , 0.313125620999    , 0.30170112464     , 0.301619113393    ,
 0.321766421039    , 0.386782617334    , 0.534826143763    , 0.790908146049    ,
 1.14676251355     , 1.57383942236     , 2.04864725324     , 2.55351181615     ,
 3.06488774176     , 3.57180142656     , 4.11622794984     , 4.79749218754     ,
 5.72186813469     , 6.94686563375     , 8.46688675943     , 10.2318249892     ,
 12.1706844924     , 14.2184945379     , 16.3352242016     , 18.4609858174     ,
 20.4207769667     , 21.933089922      , 22.7867177225     , 22.9858044064     ,
 22.6768785081     , 21.9685924857     , 20.8737152795     , 19.4213132897     ,
 17.7947579263     , 16.3354519819     , 15.378491033      , 15.0429720421     ,
 15.152237926      , 15.3517361457     , 15.3274820583     , 14.9591815804     ,
 14.3201589569     , 13.5658481325     , 12.8065874267     , 12.0469650794     ,
 11.2387370691     , 10.3934177162     , 9.61073148972     , 8.97769692929     ,
 8.4712362147      , 7.98616904524     , 7.44324074321     , 6.85088567714     ,
 6.27543967745     , 5.77822027031     , 5.38202209354     , 5.07505911459     ,
 4.82774263        , 4.59992025078     , 4.34524102241     , 4.03539997564     ,
 3.68922791831     , 3.36076546027     , 3.08718899645     , 2.8571233936      ,
 2.63403392501     , 2.39572996858     , 2.143156541       , 1.88891652673     ,
 1.65378606837     , 1.46231211971     , 1.32439331801     , 1.22749731955     ,
 1.15848303639     , 1.12364946015     , 1.13410619311     , 1.17781189603     ,
 1.21648725858     , 1.20617307678     , 1.11871626007     , 0.956017705851    ,
 0.753270363203    , 0.562694325843    , 0.423905828104    , 0.343287820341    ,
 0.297656813535    , 0.257322418325    , 0.208575801581    , 0.158181348667    ,
 0.121955429008    , 0.112217211961    , 0.131407808771    , 0.169783774584    ,
 0.207345389455    , 0.222912245342    , 0.20714299591     , 0.169597211857    ,
 0.132906232083    , 0.117590963864    , 0.128881733663    , 0.155204668001    ,
 0.178287303461    , 0.185355360203    , 0.173861441948    , 0.148371225799    ,
 0.116370947461    , 0.0869887157772   , 0.0695701497752   , 0.0687203468742   ,
 0.0796338356284   , 0.0908708010413   , 0.0941978486339   , 0.0922414941661   ,
 0.0970061260576   , 0.121108018142    , 0.167578139968    , 0.225169518516    ,
 0.275711505408    , 0.309618026578    , 0.332723395696    , 0.355946836681    ,
 0.383130709361    , 0.413555282203    , 0.449316056712    , 0.490170741792    ,
 0.524787766976    , 0.538557673574    , 0.532347463786    , 0.529126611247    ,
 0.562007174009    , 0.655976320986    , 0.812684768206    , 1.00032493074     ,
 1.25145544596     , 1.33000485475     , 1.31778203032     , 1.26964630546     ,
 1.2625120238      , 1.32879406976     , 1.43417684221     , 1.51883927107     ,
 1.55212229542     , 1.54750957366     , 1.53685584695     , 1.53994811526     ,
 1.55355392434     , 1.55537032697     , 1.51530093736     , 1.41481922961     ,
 1.2663917331      , 1.11731091274     , 1.02984292144     , 1.04010989665     ,
 1.1190035121      , 1.18100597315     , 1.15459980474     , 1.04698623543     ,
 0.924773940658    , 0.83591014566     , 0.771721616294    , 0.70164987033     ,
 0.618001251629    , 0.537839509791    , 0.476536823149    , 0.430774697035    ,
 0.386032764243    , 0.336612467803    , 0.294793216629    , 0.2785369671      ,
 0.292264384928    , 0.321346006499    , 0.342405079885    , 0.337242747287    ,
 0.302840376254    , 0.254428778228    , 0.216451074749    , 0.205434322687    ,
 0.221067585151    , 0.251716515191    , 0.283360711523    , 0.305048390024    ,
 0.314432995307    , 0.320383306192    , 0.334604203903    , 0.36082614845     ,
 0.400891763049    , 0.473583498234    , 0.616734330183    , 0.863247378264    ,
 1.22208084211     , 1.68777853393     , 2.25307138123     , 2.8947608561      ,
 3.56105356716     , 4.20656455442     , 4.85183219841     , 5.5943794255      ,
 6.55152377445     , 7.79049704337     , 9.30020452994     , 11.010990135      ,
 12.8428366165     , 14.7560571497     , 16.7544448463     , 18.7900814514     ,
 20.6426215201     , 21.968623836      , 22.5451964538     , 22.4334539815     ,
 21.8614515927     , 20.9896653225     , 19.8347875489     , 18.4011756688     ,
 16.848227245      , 15.5060457211     , 14.6997571467     , 14.5226503979     ,
 14.7575780704     , 15.0207201599     , 15.0033554675     , 14.616173029      ,
 13.9638201855     , 13.2244073217     , 12.5236931173     , 11.8659926525     ,
 11.1809458172     , 10.448826763      , 9.74735388832     , 9.15807860423     ,
 8.66755173246     , 8.18909278953     , 7.65909902094     , 7.0892356333      ,
 6.53866679862     , 6.05967360375     , 5.66815514139     , 5.34716066368     ,
 5.06486858254     , 4.78425201736     , 4.46746820152     , 4.09725831677     ,
 3.70131789443     , 3.33618440393     , 3.03620387169     , 2.78772759833     ,
 2.55594509246     , 2.32305280347     , 2.09460776672     , 1.88358097804     ,
 1.70060121356     , 1.55104767179     , 1.42953545663     , 1.32372408059     ,
 1.23547272162     , 1.19247269002     , 1.22453756855     , 1.32555175671     ,
 1.44215772042     , 1.4983708608      , 1.43582467713     , 1.24748331279     ,
 0.984628875825    , 0.727054198587    , 0.536123562168    , 0.426107786446    ,
 0.369812925911    , 0.327525445828    , 0.275899836902    , 0.217289867544    ,
 0.168696890433    , 0.145923804796    , 0.154825712689    , 0.189055884334    ,
 0.231199570017    , 0.258760365693    , 0.256024797969    , 0.2256040206      ,
 0.188563064102    , 0.16917146722     , 0.175726754507    , 0.195325078105    ,
 0.207309232791    , 0.200361034362    , 0.176458379933    , 0.143118632029    ,
 0.107213718863    , 0.0753345995922   , 0.0544511437921   , 0.0486663731625   ,
 0.0559735709067   , 0.0698929025521   , 0.0850650501153   , 0.102207686447    ,
 0.129038559706    , 0.175240367252    , 0.242232228065    , 0.316670673432    ,
 0.378776328391    , 0.419799066636    , 0.44767998198     , 0.474837386079    ,
 0.507383689712    , 0.548670763713    , 0.602505439195    , 0.66319112952     ,
 0.709320090045    , 0.719684116227    , 0.696542480182    , 0.669943627678    ,
 0.680910403423    , 0.759271287939    , 0.907134906848    , 1.09143097646     ,
 1.34199440195     , 1.4286855315      , 1.44545097756     , 1.44038678139     ,
 1.48007007808     , 1.58692896884     , 1.71779819698     , 1.80801737278     ,
 1.82997493053     , 1.80682947624     , 1.779734304       , 1.77040324917     ,
 1.76879198527     , 1.7431126269      , 1.66138897374     , 1.51628034634     ,
 1.3369254928      , 1.17747209294     , 1.09121945102     , 1.10043430613     ,
 1.17180535018     , 1.22579928196     , 1.19490551835     , 1.08146418004     ,
 0.946282379919    , 0.841251082683    , 0.768772863477    , 0.703536149311    ,
 0.630890857561    , 0.556268591513    , 0.490648164451    , 0.437301387521    ,
 0.392010729561    , 0.352778858893    , 0.325952150753    , 0.320044512855    ,
 0.334165655397    , 0.354911623279    , 0.364821009384    , 0.353418807052    ,
 0.32294542867     , 0.286913075667    , 0.261444040918    , 0.254265529444    ,
 0.261942443333    , 0.277193937165    , 0.29514417275     , 0.313077395007    ,
 0.331084684486    , 0.355114608675    , 0.392596939099    , 0.443243204639    ,
 0.504424469773    , 0.591211370216    , 0.741084313207    , 0.9916470961      ,
 1.36315664115     , 1.86777401608     , 2.51566540765     , 3.28971271229     ,
 4.12451747401     , 4.94204301623     , 5.72313167017     , 6.5389655622      ,
 7.50970698814     , 8.72811416932     , 10.2024631682     , 11.8555044997     ,
 13.5882257501     , 15.3630182581     , 17.2063445666     , 19.0740158385     ,
 20.711562498      , 21.7478028709     , 21.9966560353     , 21.6128990795     ,
 20.9052196797     , 20.0466117578     , 19.004093579      , 17.7149574645     ,
 16.292162079      , 15.0475130838     , 14.3026098182     , 14.1494228036     ,
 14.3702641564     , 14.5883313782     , 14.5125994259     , 14.0739917499     ,
 13.3927714543     , 12.6629383098     , 12.0281929856     , 11.4982387921     ,
 10.9816940465     , 10.4184035246     , 9.84849353995     , 9.3386287395      ,
 8.88889530754     , 8.4408925503      , 7.94844184688     , 7.41603495389     ,
 6.88359496072     , 6.39385374008     , 5.96961397645     , 5.60802561695     ,
 5.28675221414     , 4.96951027281     , 4.61682887062     , 4.21500841679     ,
 3.79603032629     , 3.41137473422     , 3.08484626832     , 2.80212264043     ,
 2.54193958702     , 2.30273868104     , 2.09729407291     , 1.93235344217     ,
 1.79985701928     , 1.6832560039      , 1.56717049739     , 1.44717325799     ,
 1.34119756645     , 1.28980603412     , 1.33103337939     , 1.46279551155     ,
 1.62575795165     , 1.7252994476      , 1.68259340804     , 1.48392498657     ,
 1.19137172458     , 0.902298944238    , 0.689677514527    , 0.568941769546    ,
 0.506734856105    , 0.455467349092    , 0.387448545364    , 0.306726356864    ,
 0.23579794003     , 0.195170454459    , 0.192611960245    , 0.222398259037    ,
 0.267599003141    , 0.304376873647    , 0.31223535603     , 0.287984107224    ,
 0.250517334595    , 0.22657146167     , 0.227522197033    , 0.240583760325    ,
 0.243672711111    , 0.225943281094    , 0.191871101509    , 0.150853390898    ,
 0.109774815701    , 0.074194692051    , 0.0499098260793   , 0.0405252401708   ,
 0.0454320601185   , 0.0614423698135   , 0.0859055209701   , 0.119082769114    ,
 0.16538340772     , 0.230577693856    , 0.3130340649      , 0.398010315399    ,
 0.466749984522    , 0.512510398791    , 0.543003008044    , 0.569144541279    ,
 0.599908987357    , 0.646728937119    , 0.719033285874    , 0.807828848898    ,
 0.882080378357    , 0.911430299118    , 0.893249843069    , 0.857607354254    ,
 0.849748836579    , 0.905014502251    , 1.02917521327     , 1.19263427284     ,
 1.51197266043     , 1.601540378       , 1.64638333137     , 1.68780908589     ,
 1.77505233148     , 1.91383098456     , 2.05405428066     , 2.13479426894     ,
 2.13658108442     , 2.08785444596     , 2.03046829234     , 1.98580559942     ,
 1.94496045234     , 1.87840342268     , 1.75841718173     , 1.58531502175     ,
 1.39468558764     , 1.23620578993     , 1.14602797761     , 1.1315185495      ,
 1.16469239354     , 1.18856891514     , 1.15103795232     , 1.04620482269     ,
 0.915066314815    , 0.802065881215    , 0.720265981155    , 0.657225096842    ,
 0.598484760212    , 0.53923669411     , 0.482837227237    , 0.435505593169    ,
 0.401666795911    , 0.382557788831    , 0.377820699963    , 0.385673727495    ,
 0.40021714125     , 0.410768124638    , 0.407576554374    , 0.389776265802    ,
 0.366395081365    , 0.348660577082    , 0.341514176237    , 0.341797753576    ,
 0.343771790968    , 0.346083081562    , 0.352460702041    , 0.366319220548    ,
 0.388751110796    , 0.422689744709    , 0.472325407845    , 0.536181399921    ,
 0.6118745621      , 0.715036881493    , 0.883888999546    , 1.15819288088     ,
 1.56375909177     , 2.12136075343     , 2.84955155227     , 3.73625480938     ,
 4.71322683933     , 5.68336898622     , 6.59161992589     , 7.47715516027     ,
 8.45953126812     , 9.66126297735     , 11.1145913494     , 12.7303161935     ,
 14.3755269123     , 15.9952258144     , 17.6254528016     , 19.2320363921     ,
 20.5580891652     , 21.2498264731     , 21.1895774277     , 20.6228107194     ,
 19.9041582479     , 19.1751806083     , 18.3223586548     , 17.2053350094     ,
 15.8931070746     , 14.6848662953     , 13.9052318643     , 13.6587232786     ,
 13.7541016479     , 13.8533491006     , 13.7000964183     , 13.2380569083     ,
 12.580350435      , 11.9132539118     , 11.3841725069     , 11.0086581907     ,
 10.6853191988     , 10.3229348682     , 9.92479959738     , 9.5375740484      ,
 9.16690079037     , 8.77199439451     , 8.31498905617     , 7.79451345495     ,
 7.24597386735     , 6.72141190609     , 6.26065717499     , 5.87211353957     ,
 5.53271102461     , 5.19854844851     , 4.82819063125     , 4.416262057       ,
 3.99915031723     , 3.61483417789     , 3.26728179462     , 2.94047502746     ,
 2.63404773408     , 2.37135196935     , 2.17563155417     , 2.04395418282     ,
 1.94454479586     , 1.83947564793     , 1.710946914       , 1.56997457232     ,
 1.44904213665     , 1.38978318566     , 1.42541560421     , 1.55504038515     ,
 1.72406744115     , 1.83656758788     , 1.80685985487     , 1.61797359115     ,
 1.33548486276     , 1.06079303667     , 0.865545084744    , 0.758947068121    ,
 0.700337967622    , 0.637458040864    , 0.543623055921    , 0.430274135303    ,
 0.329975976615    , 0.270035830921    , 0.258601259056    , 0.285771418151    ,
 0.330269379651    , 0.366358300172    , 0.373411949546    , 0.348190500508    ,
 0.309242869737    , 0.283104240314    , 0.280844840426    , 0.288858770517    ,
 0.284633388837    , 0.258472348921    , 0.216838257262    , 0.170182224676    ,
 0.125284624689    , 0.0874505024553   , 0.0621714210394   , 0.0520720408649   ,
 0.0555263042278   , 0.07005924832     , 0.0957402084574   , 0.13520057048     ,
 0.19221541614     , 0.268890605767    , 0.359837724271    , 0.450004335798    ,
 0.524095460076    , 0.577784225478    , 0.615333831957    , 0.641701054481    ,
 0.666311697606    , 0.709723168455    , 0.792028771069    , 0.909534102238    ,
 1.02908471758     , 1.11032275348     , 1.13488470988     , 1.11953563734     ,
 1.10738025125     , 1.14226493164     , 1.24028454356     , 1.37883631761     ,
 1.83175255197     , 1.9230487225      , 1.98676809544     , 2.06183918421     ,
 2.17939948228     , 2.32584156375     , 2.44809621741     , 2.49886128362     ,
 2.4722523549      , 2.39586208559     , 2.30042639834     , 2.20228135355     ,
 2.10085110286     , 1.98001739598     , 1.82095174972     , 1.62738763792     ,
 1.43378047571     , 1.28019702752     , 1.18428003047     , 1.13969380147     ,
 1.12683394971     , 1.11559375003     , 1.07305233868     , 0.985892615946    ,
 0.8716515983      , 0.760489809742    , 0.670802388292    , 0.603860718737    ,
 0.551620798845    , 0.504691711549    , 0.459429174722    , 0.421803288626    ,
 0.402027211431    , 0.404240383534    , 0.422485154198    , 0.445515315625    ,
 0.462839233242    , 0.467027220212    , 0.456534163949    , 0.440075556158    ,
 0.432428335609    , 0.440179359299    , 0.45471567808     , 0.462210087866    ,
 0.457584876955    , 0.44768147224     , 0.443969401472    , 0.453648086555    ,
 0.477295785005    , 0.513946844013    , 0.564352723076    , 0.628826754563    ,
 0.711899937375    , 0.835282739495    , 1.03752402374     , 1.35565378197     ,
 1.81570120625     , 2.44061552214     , 3.2468984434      , 4.21723011833     ,
 5.2812853218      , 6.33934432543     , 7.3233954523      , 8.25643298298     ,
 9.26038581109     , 10.4801920509     , 11.9591195569     , 13.5814376512     ,
 15.165953782      , 16.6260946183     , 17.9985353104     , 19.2700753622     ,
 20.2210979816     , 20.562995578      , 20.2609825391     , 19.6142654718     ,
 18.9636893175     , 18.382755841      , 17.6829585417     , 16.6761876886     ,
 15.4121009451     , 14.1828280442     , 13.3097229989     , 12.9077708112     ,
 12.8248100664     , 12.7844639827     , 12.5823772981     , 12.1749355159     ,
 11.6488613366     , 11.1500787587     , 10.7985381285     , 10.6049108766     ,
 10.4713188483     , 10.2972470998     , 10.0635907931     , 9.80087496134     ,
 9.51419337048     , 9.16575248648     , 8.71359941073     , 8.15614322503     ,
 7.54948191988     , 6.98061610623     , 6.51094498323     , 6.14021243838     ,
 5.81731397735     , 5.47796824281     , 5.08725295897     , 4.66426314379     ,
 4.25725317509     , 3.88754745347     , 3.53299196703     , 3.17052531423     ,
 2.81683655769     , 2.51929070828     , 2.31370179419     , 2.19034773782     ,
 2.09724187057     , 1.98106425277     , 1.82862513941     , 1.6688993463      ,
 1.54308649702     , 1.48193216542     , 1.50273471415     , 1.60311512327     ,
 1.74222718919     , 1.83892504708     , 1.81410073999     , 1.65089602722     ,
 1.411378293       , 1.18891835615     , 1.04338767625     , 0.972836588526    ,
 0.929325165829    , 0.858089682825    , 0.736153052929    , 0.585582942582    ,
 0.452456988769    , 0.373021043345    , 0.354882219137    , 0.379861889677    ,
 0.417906649246    , 0.440972888635    , 0.433416898477    , 0.398711886021    ,
 0.357693088661    , 0.333562581518    , 0.331967612768    , 0.335866964183    ,
 0.323132825223    , 0.287434505921    , 0.238863418423    , 0.189475880933    ,
 0.145835012934    , 0.112663692511    , 0.0943544108638   , 0.0903858981484   ,
 0.0945424080234   , 0.102256931125    , 0.116991059423    , 0.147801665233    ,
 0.202136061439    , 0.28042697792     , 0.373780925106    , 0.467253908699    ,
 0.549688281482    , 0.618709871381    , 0.673133921074    , 0.708993620115    ,
 0.732610747269    , 0.771200507628    , 0.857899368092    , 1.00283474849     ,
 1.17984152677     , 1.33989437825     , 1.44029123896     , 1.47272887467     ,
 1.47266032999     , 1.49669829847     , 1.57916044621     , 1.70593455156     ,
 2.32630809882     , 2.42761656743     , 2.50513561221     , 2.60043514344     ,
 2.73041788101     , 2.86347163203     , 2.94655215112     , 2.95153303241     ,
 2.88924072312     , 2.78290075389     , 2.64444975042     , 2.48022310339     ,
 2.29949093926     , 2.1047424587      , 1.88968341968     , 1.66151256996     ,
 1.45235046273     , 1.29377477222     , 1.18895869783     , 1.12081093092     ,
 1.07502369773     , 1.04040660869     , 0.998579706779    , 0.932796869836    ,
 0.843861739287    , 0.746894548074    , 0.656862912175    , 0.582033801353    ,
 0.523350628658    , 0.474895770717    , 0.431202531945    , 0.397248669955    ,
 0.385851912696    , 0.402722760676    , 0.437570155552    , 0.471592618335    ,
 0.490866182843    , 0.491887089487    , 0.48155375342     , 0.476713399395    ,
 0.494250430615    , 0.532466048569    , 0.56866246183     , 0.581392936482    ,
 0.569802344087    , 0.549770932607    , 0.538999917765    , 0.547399303934    ,
 0.574950658991    , 0.615531428019    , 0.664386250503    , 0.725088075747    ,
 0.815284687701    , 0.967467978921    , 1.21760210596     , 1.59212699686     ,
 2.11220242576     , 2.80237450081     , 3.67453788617     , 4.69783497387     ,
 5.79448960271     , 6.87301418586     , 7.87859169756     , 8.84057799303     ,
 9.88511334479     , 11.1633162123     , 12.7117367005     , 14.3805358256     ,
 15.9397758192     , 17.267075844      , 18.3898182664     , 19.3160473794     ,
 19.8888851675     , 19.9183427318     , 19.4521718421     , 18.7952337476     ,
 18.2182840948     , 17.7133043117     , 17.0548393155     , 16.0607236706     ,
 14.7907223763     , 13.5245192975     , 12.5583419892     , 12.0035353147     ,
 11.7499960171     , 11.5951450388     , 11.3965961102     , 11.1258484327     ,
 10.8339254828     , 10.6017248124     , 10.4910030581     , 10.4914880273     ,
 10.5163953484     , 10.4749876258     , 10.3420725977     , 10.1430462172     ,
 9.88869024305     , 9.54341854809     , 9.05665152612     , 8.42789334393     ,
 7.74419475133     , 7.13781402788     , 6.69045256608     , 6.37742696447     ,
 6.09948712445     , 5.76299941426     , 5.34601768645     , 4.90357014467     ,
 4.50314602161     , 4.15357086174     , 3.80803286943     , 3.43091184669     ,
 3.04441724662     , 2.71080386145     , 2.4776024514      , 2.33514293973     ,
 2.22263665967     , 2.08224666754     , 1.90916807914     , 1.74490361868     ,
 1.62980923926     , 1.57600861625     , 1.58032363027     , 1.63755496854     ,
 1.72493330464     , 1.78653342816     , 1.76012739692     , 1.63141568308     ,
 1.45264330595     , 1.30015202068     , 1.21684938764     , 1.18990116253     ,
 1.16660678717     , 1.0909470536      , 0.943508587858    , 0.757056812202    ,
 0.591600289771    , 0.492284114419    , 0.465781448093    , 0.485339839798    ,
 0.511959832546    , 0.515711317925    , 0.487640527776    , 0.44007396715     ,
 0.396537416877    , 0.374901205459    , 0.373021980494    , 0.369993038523    ,
 0.345563899992    , 0.298567603371    , 0.243949009822    , 0.196227526679    ,
 0.162188688674    , 0.14535034937     , 0.146868736806    , 0.159564697261    ,
 0.16871623899     , 0.165376255098    , 0.157592166989    , 0.165122670133    ,
 0.203848568211    , 0.275294847348    , 0.36726758836     , 0.463649264031    ,
 0.556069574384    , 0.643917176855    , 0.722072893425    , 0.77922656656     ,
 0.817205641113    , 0.86525566818     , 0.965461641711    , 1.14177768614     ,
 1.37893119218     , 1.6238735571      , 1.81143114553     , 1.90611355303     ,
 1.93267168902     , 1.96119486693     , 2.04800822316     , 2.18721548171     ,
 2.97297850881     , 3.10131294422     , 3.19965964493     , 3.31214275525     ,
 3.44685055601     , 3.5607258329      , 3.60296538854     , 3.56120499789     ,
 3.45841579218     , 3.312581984       , 3.11847989505     , 2.87178509792     ,
 2.58870539249     , 2.29066173417     , 1.98933210088     , 1.70079834133     ,
 1.45609443216     , 1.27842668155     , 1.15999437852     , 1.07667482709     ,
 1.01534267325     , 0.971870731189    , 0.934518433457    , 0.887934445649    ,
 0.827126680737    , 0.755428880579    , 0.676273796697    , 0.595102627627    ,
 0.520483158327    , 0.456840123728    , 0.403944588182    , 0.367068555935    ,
 0.358313781266    , 0.382006268555    , 0.423865356218    , 0.460034135623    ,
 0.475302550834    , 0.471126361808    , 0.46276493139     , 0.472871656003    ,
 0.516356308642    , 0.581554714346    , 0.635156604869    , 0.653353629444    ,
 0.641122457379    , 0.620589177893    , 0.612460043198    , 0.628940614806    ,
 0.670738780326    , 0.726255112873    , 0.782714722871    , 0.845878907517    ,
 0.949161070232    , 1.13854214653     , 1.44490612224     , 1.87714299762     ,
 2.44682299269     , 3.18221728077     , 4.09585434662     , 5.14416516219     ,
 6.23904331275     , 7.30162927865     , 8.30670099155     , 9.30416244713     ,
 10.4186405051     , 11.7859352485     , 13.4218966362     , 15.1503012366     ,
 16.7112087402     , 17.9546253207     , 18.8885615571     , 19.5288364827     ,
 19.7820844453     , 19.5635043757     , 18.9883482727     , 18.3278598311     ,
 17.7561779731     , 17.2034262032     , 16.4623677268     , 15.40672482       ,
 14.1214974485     , 12.8556911912     , 11.8516247449     , 11.1992980521     ,
 10.8275164394     , 10.6081574131     , 10.4587565747     , 10.3645456745     ,
 10.3412835295     , 10.4011729003     , 10.5377567302     , 10.7108808716     ,
 10.8447671376     , 10.865892732      , 10.7519314373     , 10.5320092487     ,
 10.2335470335     , 9.83577415886     , 9.28863940985     , 8.59171622516     ,
 7.84999272468     , 7.22406887198     , 6.80685721673     , 6.55152017943     ,
 6.31866901003     , 5.99143244558     , 5.55963109063     , 5.10663818259     ,
 4.71455295102     , 4.38517337232     , 4.0562439416      , 3.68091248552     ,
 3.27882188178     , 2.91717648458     , 2.6501320181      , 2.4714897153      ,
 2.32339128892     , 2.15530515674     , 1.97204798484     , 1.81852204711     ,
 1.72566870397     , 1.68567468332     , 1.67643890181     , 1.68886305299     ,
 1.71733623743     , 1.73568771005     , 1.70567508046     , 1.61662362179     ,
 1.50379992037     , 1.41872572819     , 1.38678040488     , 1.39058176309     ,
 1.37957580273     , 1.29930176328     , 1.13268214057     , 0.919512618502    ,
 0.728579058936    , 0.609518410595    , 0.568164737775    , 0.574594451655    ,
 0.58708073978     , 0.575584461647    , 0.53437279325     , 0.479169141972    ,
 0.432462361468    , 0.406685162022    , 0.395180745865    , 0.377775746703    ,
 0.339039186742    , 0.282686954366    , 0.226585593142    , 0.186806348813    ,
 0.170731771901    , 0.180436467642    , 0.212088111766    , 0.249624979372    ,
 0.268295374013    , 0.254258651637    , 0.220694123326    , 0.199717902439    ,
 0.217881860206    , 0.27925463803     , 0.367788227663    , 0.464089943836    ,
 0.561189818753    , 0.661969798117    , 0.76249861464     , 0.849529225209    ,
 0.921548113182    , 1.00474203576     , 1.14076701762     , 1.3584677211      ,
 1.65098984975     , 1.96842995303     , 2.23523162019     , 2.39602145924     ,
 2.4630676857      , 2.51429074866     , 2.62530542243     , 2.79864969636     ,
 3.72002227411     , 3.89735692957     , 4.03517663236     , 4.17254491551     ,
 4.31428522965     , 4.41839803253     , 4.43876979492     , 4.36544523938     ,
 4.21842204913     , 4.00995692987     , 3.72964733488     , 3.37112836252     ,
 2.95672558517     , 2.52604225594     , 2.11447347627     , 1.75219199591     ,
 1.46636533841     , 1.26556377382     , 1.13013837623     , 1.03271577407     ,
 0.961087878631    , 0.911415220742    , 0.873391741742    , 0.836333259196    ,
 0.797669052356    , 0.753443939715    , 0.692574418579    , 0.611014306575    ,
 0.521206525598    , 0.439933868938    , 0.376518146669    , 0.337723980518    ,
 0.332037388834    , 0.359267861798    , 0.401287034469    , 0.431927020481    ,
 0.436871658365    , 0.422526328937    , 0.410740004949    , 0.427213273822    ,
 0.483441207649    , 0.561379112194    , 0.625078524528    , 0.653969118326    ,
 0.657108036245    , 0.656332125359    , 0.66970421147     , 0.709785558021    ,
 0.77925829122     , 0.862942347706    , 0.939574681702    , 1.01410088937     ,
 1.13365698822     , 1.35898892233     , 1.7179439503      , 2.20060910771     ,
 2.80505245518     , 3.56248312015     , 4.49193874016     , 5.54501745199     ,
 6.62654676923     , 7.67106750431     , 8.68766975277     , 9.75091982462     ,
 10.9745401608     , 12.4577054506     , 14.1838536022     , 15.9632726985     ,
 17.5321186708     , 18.7290131062     , 19.5398168952     , 19.9750431        ,
 19.99057801       , 19.5877795588     , 18.9213062818     , 18.2072389039     ,
 17.5338299941     , 16.8139485876     , 15.9074186169     , 14.7677542722     ,
 13.5003618082     , 12.304230395      , 11.3481686028     , 10.6866699355     ,
 10.2759200939     , 10.0487326203     , 9.96894215869     , 10.0298188627     ,
 10.2200544318     , 10.5020608354     , 10.8186890073     , 11.1060118313     ,
 11.2971804205     , 11.3351222543     , 11.2010407335     , 10.9239250842     ,
 10.5435918949     , 10.0614887511     , 9.44581254564     , 8.70365676836     ,
 7.93991950539     , 7.3126972442      , 6.91044418184     , 6.67715293924     ,
 6.46281258534     , 6.14826362584     , 5.73074959447     , 5.2988811686      ,
 4.93029720259     , 4.61921771647     , 4.29983944542     , 3.92467888203     ,
 3.5136254305      , 3.13438389531     , 2.83966972979     , 2.62223501584     ,
 2.43145705927     , 2.23214296416     , 2.04076889484     , 1.90140856093     ,
 1.83328644946     , 1.81112498193     , 1.79514470788     , 1.76839827979     ,
 1.73834918143     , 1.7108111506      , 1.67719624426     , 1.63035617925     ,
 1.58064873698     , 1.54794150654     , 1.54259832201     , 1.55261203097     ,
 1.53932886374     , 1.45454404704     , 1.28198392193     , 1.06098926141     ,
 0.858323194214    , 0.720282924328    , 0.653274762071    , 0.634523399455    ,
 0.630624256878    , 0.614374272863    , 0.576386517287    , 0.525023301374    ,
 0.475044247677    , 0.434771228353    , 0.400424319183    , 0.360512681836    ,
 0.307778479659    , 0.248266059626    , 0.197723899523    , 0.170678158578    ,
 0.174776533213    , 0.211002017095    , 0.270935163829    , 0.331627303562    ,
 0.361850029411    , 0.344866785186    , 0.297041408869    , 0.258612776633    ,
 0.263738983856    , 0.318190546904    , 0.401953238857    , 0.492130790622    ,
 0.584038706161    , 0.68750973656     , 0.805263663777    , 0.926876430758    ,
 1.04869530271     , 1.19022526223     , 1.38463083555     , 1.65596848005     ,
 2.00079657624     , 2.37733167791     , 2.71155712034     , 2.93703896291     ,
 3.05264181879     , 3.13672792182     , 3.27945209604     , 3.49508709103     ,
 4.52299761524     , 4.77095139966     , 4.9681830196      , 5.13990173571     ,
 5.2951360707      , 5.40718857361     , 5.43415406857     , 5.34802813026     ,
 5.1449542026      , 4.83196489001     , 4.4138957861      , 3.90221962783     ,
 3.33197572016     , 2.75985295151     , 2.24406970149     , 1.82581019981     ,
 1.518877544       , 1.30610161104     , 1.15209892533     , 1.03066613756     ,
 0.936343675776    , 0.867712527733    , 0.815353437741    , 0.772998963408    ,
 0.742179616319    , 0.715379313533    , 0.67060834534     , 0.594384290246    ,
 0.499263389807    , 0.410572984228    , 0.345691524836    , 0.31209044466     ,
 0.313133588056    , 0.34350520483     , 0.383243960323    , 0.407041062604    ,
 0.402421836244    , 0.377948325982    , 0.357287788112    , 0.366021710936    ,
 0.414341895828    , 0.486338175419    , 0.553785959475    , 0.603956397169    ,
 0.646073259334    , 0.693218595263    , 0.752569048779    , 0.831795114906    ,
 0.935600728387    , 1.05007905696     , 1.14928356864     , 1.23511463091     ,
 1.363703          , 1.61100650508     , 2.00817488007     , 2.53085512411     ,
 3.16023751908     , 3.92482971891     , 4.85278875397     , 5.90204620069     ,
 6.97850199943     , 8.02838740456     , 9.09024821857     , 10.2609704373     ,
 11.6368318232     , 13.2654578697     , 15.0867626577     , 16.9031787194     ,
 18.4642082246     , 19.6124373129     , 20.3205180036     , 20.5956783688     ,
 20.4300452543     , 19.8786733466     , 19.1027781944     , 18.2617701259     ,
 17.39492771       , 16.4430460473     , 15.352717038      , 14.149223929      ,
 12.94485961       , 11.8848833857     , 11.065169444      , 10.4957632996     ,
 10.1373933796     , 9.95605478617     , 9.9416461681      , 10.0905562693     ,
 10.3789851075     , 10.7515462683     , 11.1345833755     , 11.4586754296     ,
 11.6683651056     , 11.7226219426     , 11.6023138906     , 11.3164839002     ,
 10.8872343433     , 10.3248018595     , 9.63136584284     , 8.8447139373      ,
 8.07252033464     , 7.45305358709     , 7.05537755603     , 6.81886467521     ,
 6.6037552345      , 6.30726254089     , 5.93334866959     , 5.55661275224     ,
 5.22963857402     , 4.93208383947     , 4.6020581771      , 4.20494866849     ,
 3.77160361292     , 3.37269771737     , 3.05370798523     , 2.79822429278     ,
 2.55906535018     , 2.31780944681     , 2.10618860076     , 1.9718931521      ,
 1.92739356463     , 1.93214151279     , 1.92443056213     , 1.87093503632     ,
 1.78667989194     , 1.71107267855     , 1.66966739723     , 1.65919186421     ,
 1.66110058509     , 1.66195598894     , 1.6617622379      , 1.66168286978     ,
 1.64134170164     , 1.56163676968     , 1.40451043703     , 1.19975065549     ,
 1.0003439553      , 0.842661863803    , 0.737336182876    , 0.680087468092    ,
 0.656593829841    , 0.645114405916    , 0.62579854185     , 0.589108828034    ,
 0.535956402567    , 0.472778350526    , 0.4063368091      , 0.340652098444    ,
 0.278041354417    , 0.222710238798    , 0.182366361486    , 0.16640773364     ,
 0.182339131887    , 0.231393628603    , 0.303667849995    , 0.375592184615    ,
 0.417233918954    , 0.412337000859    , 0.375449033597    , 0.34491467916     ,
 0.35459249339     , 0.409765336969    , 0.488512847162    , 0.567924749407    ,
 0.649031640366    , 0.751370458146    , 0.885741505245    , 1.04457768262     ,
 1.22176059145     , 1.4301481152      , 1.69360181383     , 2.02811938671     ,
 2.42927037989     , 2.86166274648     , 3.25550575708     , 3.53791339318     ,
 3.69670463365     , 3.80924672494     , 3.97896882987     , 4.23637871023     ,
 5.38360441114     , 5.71792508543     , 5.98265822493     , 6.19038852398     ,
 6.36475442085     , 6.50093085707     , 6.55222028353     , 6.45241913246     ,
 6.15954332301     , 5.68100312472     , 5.06055254627     , 4.35324491306     ,
 3.61934790887     , 2.92944036469     , 2.35288467614     , 1.92801400015     ,
 1.64132007081     , 1.4387210534      , 1.26574934945     , 1.1034632246      ,
 0.963964977808    , 0.856826045042    , 0.775541092066    , 0.71450129844     ,
 0.675483180962    , 0.649298106748    , 0.610012195826    , 0.539828062189    ,
 0.449710735559    , 0.367155241267    , 0.311715530126    , 0.288598425176    ,
 0.295926517898    , 0.325950927662    , 0.361625793007    , 0.382428442882    ,
 0.37750995724     , 0.352543009052    , 0.326194908848    , 0.320352786205    ,
 0.347001639361    , 0.401006493027    , 0.470624240187    , 0.554407999016    ,
 0.658717647498    , 0.78060113783     , 0.90724261389     , 1.0337844687      ,
 1.16573877824     , 1.29708802299     , 1.40523317123     , 1.49070354206     ,
 1.61487375323     , 1.86793542309     , 2.28963088921     , 2.84546546609     ,
 3.49498898998     , 4.25551783802     , 5.16687043958     , 6.20979619658     ,
 7.30519094906     , 8.4073146314      , 9.56845319044     , 10.8948020187     ,
 12.4584182706     , 14.2500691641     , 16.1629020697     , 17.9936283741     ,
 19.5105075502     , 20.5677991544     , 21.1399310237     , 21.2480670992     ,
 20.9176428444     , 20.226208969      , 19.3139548416     , 18.2957404253     ,
 17.2020960249     , 16.0248764112     , 14.784023779      , 13.5511464678     ,
 12.4389054343     , 11.5543042091     , 10.9361269361     , 10.5447280927     ,
 10.3180360082     , 10.2238570291     , 10.2601597579     , 10.4263092332     ,
 10.7018207371     , 11.0419341818     , 11.3873329906     , 11.6832993795     ,
 11.8940453507     , 11.9981295091     , 11.970358347      , 11.7718460678     ,
 11.3637769955     , 10.7376789854     , 9.93865428487     , 9.06775084275     ,
 8.26336414113     , 7.65249536076     , 7.27738808212     , 7.05979823022     ,
 6.86138065921     , 6.59521092129     , 6.27563651934     , 5.96358350807     ,
 5.68110517984     , 5.38672162217     , 5.02131046689     , 4.56903851892     ,
 4.0803988406      , 3.63542136486     , 3.27439381397     , 2.96942491665     ,
 2.67131142091     , 2.37383930422     , 2.12537841267     , 1.98489077725     ,
 1.96598293873     , 2.01407461785     , 2.03875677414     , 1.98040051498     ,
 1.85448646169     , 1.73164104476     , 1.67230374536     , 1.68003659843     ,
 1.71327968486     , 1.73288511996     , 1.73343561446     , 1.7289989221      ,
 1.71478333813     , 1.65879423296     , 1.53820518654     , 1.36708928633     ,
 1.17854435031     , 0.998266737046    , 0.846188576611    , 0.743152434553    ,
 0.698140439027    , 0.695068195926    , 0.699921274701    , 0.680279396037    ,
 0.621361275938    , 0.53086954312     , 0.431141076575    , 0.344026000575    ,
 0.279304122441    , 0.234460838602    , 0.204519911702    , 0.191576132683    ,
 0.203633561027    , 0.244917342895    , 0.308873946061    , 0.378589238428    ,
 0.432928622382    , 0.458517483936    , 0.462032886235    , 0.468728973952    ,
 0.503112827172    , 0.567813939089    , 0.643145009421    , 0.712642601064    ,
 0.787582681919    , 0.897183227234    , 1.05578655338     , 1.25312550189     ,
 1.47915242732     , 1.74459378837     , 2.07077027781     , 2.46859091737     ,
 2.92896490739     , 3.41557969234     , 3.85857005191     , 4.18184552814     ,
 4.37046006375     , 4.50677703691     , 4.70789402194     , 5.01873084142     ,
 6.35123022489     , 6.77935324521     , 7.10652260443     , 7.34639144032     ,
 7.54387687708     , 7.70621836536     , 7.765278933       , 7.60943307854     ,
 7.16469752157     , 6.45253223579     , 5.57310868564     , 4.64301198488     ,
 3.75723662011     , 2.99415065772     , 2.41702635397     , 2.04382117084     ,
 1.82160145711     , 1.65288284455     , 1.46383084148     , 1.24917114937     ,
 1.04852744336     , 0.890242128508    , 0.772196131729    , 0.685400448822    ,
 0.627624743491    , 0.588471230033    , 0.543122103129    , 0.474515966285    ,
 0.392675184984    , 0.323150454421    , 0.28205312051     , 0.268705887187    ,
 0.275980415519    , 0.297194012268    , 0.323559027172    , 0.343450935035    ,
 0.347872881673    , 0.335789285626    , 0.315537674635    , 0.301951349425    ,
 0.309192417216    , 0.345859246809    , 0.419793290099    , 0.542680160264    ,
 0.71821212006     , 0.925235061834    , 1.12604726492     , 1.29778843641     ,
 1.44503896253     , 1.57423194164     , 1.67421414731     , 1.74935479722     ,
 1.86537861339     , 2.12372656868     , 2.57253269102     , 3.1664164556      ,
 3.8356107547      , 4.57741945354     , 5.44945097478     , 6.47925657176     ,
 7.62384465439     , 8.84179096731     , 10.172300503      , 11.7013474402     ,
 13.4615779851     , 15.3893618178     , 17.3443924006     , 19.1310273275     ,
 20.5420250342     , 21.4454185352     , 21.828396177      , 21.7451242286     ,
 21.2590162587     , 20.4495901833     , 19.4165817414     , 18.2383165424     ,
 16.9554898256     , 15.6078965352     , 14.2643617415     , 13.0252665032     ,
 12.0087029816     , 11.302206977      , 10.9025685193     , 10.7202194855     ,
 10.6556793983     , 10.6620536035     , 10.7385799118     , 10.8908702216     ,
 11.1092568336     , 11.3690115863     , 11.6367388831     , 11.8837874192     ,
 12.1022708971     , 12.2940408496     , 12.4222985329     , 12.3799646386     ,
 12.0386884806     , 11.3525663315     , 10.4138029774     , 9.41029418029     ,
 8.53965785358     , 7.93635022964     , 7.61602767685     , 7.46493251354     ,
 7.32085052872     , 7.09602720048     , 6.81661880032     , 6.54447336727     ,
 6.28458153164     , 5.97691491242     , 5.55899306253     , 5.02690668107     ,
 4.44841884356     , 3.91661493306     , 3.47535877141     , 3.09343839454     ,
 2.72044808722     , 2.3569829259      , 2.06431354774     , 1.91446833364     ,
 1.92606786856     , 2.03220823007     , 2.11229818521     , 2.07592643219     ,
 1.93125382903     , 1.77054606088     , 1.68363459696     , 1.68633460647     ,
 1.72952570305     , 1.76276539656     , 1.77747954837     , 1.79127247837     ,
 1.8040989221      , 1.78599325513     , 1.70869990661     , 1.57130423361     ,
 1.39005190663     , 1.18553254484     , 0.99021985946     , 0.847001339755    ,
 0.782126580617    , 0.782354349341    , 0.801371990828    , 0.78794276896     ,
 0.715972325584    , 0.597897235597    , 0.472174074461    , 0.375188439396    ,
 0.319069300311    , 0.290533215328    , 0.269978330601    , 0.252015802239    ,
 0.24667615194     , 0.264600762353    , 0.307400753503    , 0.369760476137    ,
 0.442759037504    , 0.515908499494    , 0.583468646187    , 0.649879623501    ,
 0.723613292159    , 0.803473582241    , 0.87721151059     , 0.94238928211     ,
 1.02466415351     , 1.15998668092     , 1.35694829726     , 1.59284243363     ,
 1.85134275057     , 2.14850580145     , 2.51432576456     , 2.96060807571     ,
 3.47035069605     , 3.9983535097      , 4.47165700463     , 4.8185796937      ,
 5.03444674365     , 5.21345274888     , 5.48092265396     , 5.88245384274     ,
 7.48403486774     , 8.00723844217     , 8.39157818227     , 8.66588935106     ,
 8.88850572002     , 9.05340090802     , 9.05709971021     , 8.75862270979     ,
 8.0830440905      , 7.08555702106     , 5.92532195572     , 4.77709713528     ,
 3.7661869284      , 2.96928042661     , 2.43021764925     , 2.13735379572     ,
 1.99732334001     , 1.87321585022     , 1.67597806955     , 1.41612674007     ,
 1.16103102686     , 0.957032845252    , 0.805418724079    , 0.693297281272    ,
 0.6147457985      , 0.558924985538    , 0.502953358347    , 0.431702933985    ,
 0.355555869844    , 0.29803737591     , 0.269853770644    , 0.262224912079    ,
 0.262116224086    , 0.265272402518    , 0.273844784255    , 0.287888074847    ,
 0.302103248872    , 0.309228279483    , 0.306383442433    , 0.299238145534    ,
 0.300847524861    , 0.329284508142    , 0.408128463946    , 0.561098269929    ,
 0.79181632894     , 1.06569034375     , 1.32467462403     , 1.53036092486     ,
 1.68616057106     , 1.81017300489     , 1.90457876403     , 1.98092665418     ,
 2.10903411349     , 2.39704853528     , 2.89701553611     , 3.54851601174     ,
 4.24500174971     , 4.95748347367     , 5.76865435381     , 6.77551544916     ,
 7.99150361788     , 9.37688174076     , 10.9294938659     , 12.6786343163     ,
 14.5961181241     , 16.5694178998     , 18.4509784489     , 20.0828891765     ,
 21.3016819991     , 21.994426912      , 22.1616350265     , 21.8948874452     ,
 21.2983013306     , 20.445847065      , 19.3840342535     , 18.1437441021     ,
 16.7623159168     , 15.3104044513     , 13.8971736184     , 12.6570670734     ,
 11.7218343619     , 11.1627133666     , 10.9379719225     , 10.9172936073     ,
 10.9752326936     , 11.0592905901     , 11.1761848453     , 11.339498358      ,
 11.5440967703     , 11.7732447069     , 12.0096431016     , 12.2463946606     ,
 12.5012570091     , 12.7972922557     , 13.0862508764     , 13.1966074153     ,
 12.9162995267     , 12.1660910431     , 11.0847689577     , 9.94434007755     ,
 9.0017035232      , 8.40237689796     , 8.139175641       , 8.06291801185     ,
 7.98057511098     , 7.79026213472     , 7.5204472994      , 7.24053178775     ,
 6.95896481714     , 6.61395317777     , 6.13924637439     , 5.52873093007     ,
 4.85220412407     , 4.20961671906     , 3.65462661458     , 3.16602657855     ,
 2.70215269496     , 2.27119433065     , 1.94138245085     , 1.79034649898     ,
 1.8372312759      , 2.00455183947     , 2.14850355851     , 2.15291756565     ,
 2.01382828157     , 1.83151011573     , 1.71483646054     , 1.69642147198     ,
 1.73620774662     , 1.78582530706     , 1.83239653423     , 1.88478205929     ,
 1.93567583551     , 1.95260190027     , 1.90471715751     , 1.78404963043     ,
 1.60071826065     , 1.3780721035      , 1.15832418768     , 0.992544279377    ,
 0.910099332064    , 0.897505222655    , 0.905116955745    , 0.876127854387    ,
 0.782426771294    , 0.642712668528    , 0.506134798278    , 0.415398535178    ,
 0.379155956125    , 0.372302672161    , 0.362278346452    , 0.337558355506    ,
 0.311188484461    , 0.302573036702    , 0.324808930601    , 0.385979506647    ,
 0.488556221765    , 0.622733435439    , 0.767602988464    , 0.903210704319    ,
 1.01909036293     , 1.11158115971     , 1.18239443384     , 1.25031114885     ,
 1.35734473052     , 1.54052632889     , 1.79145955414     , 2.06420090348     ,
 2.33334981569     , 2.62822144702     , 3.00024456067     , 3.46999418194     ,
 4.01095865592     , 4.56339053915     , 5.05200106211     , 5.42026578241     ,
 5.68555053031     , 5.95434606913     , 6.34627385194     , 6.8870733568      ,
 8.82702524463     , 9.44587166106     , 9.88948632712     , 10.204261809      ,
 10.4422157313     , 10.5585402034     , 10.4134293102     , 9.86982762046     ,
 8.89429152171     , 7.5945043654      , 6.17688666417     , 4.84964210426     ,
 3.74705888607     , 2.93055098549     , 2.41930360507     , 2.17788343756     ,
 2.08883891135     , 1.99408914086     , 1.7977294988      , 1.52014808895     ,
 1.24282091772     , 1.01889473339     , 0.849514730621    , 0.720680337757    ,
 0.627329533246    , 0.56033862946     , 0.497690067753    , 0.424558008383    ,
 0.351996737111    , 0.30314762652     , 0.284415292571    , 0.27904864268     ,
 0.267666037456    , 0.247531396526    , 0.230830287773    , 0.229631101868    ,
 0.244778374047    , 0.266537418171    , 0.283625507832    , 0.292367989597    ,
 0.3007543704      , 0.329222976945    , 0.409263886267    , 0.571894519947    ,
 0.822082014119    , 1.12013709458     , 1.4008248188      , 1.62222454195     ,
 1.79049751909     , 1.93059101284     , 2.05129439857     , 2.16731897753     ,
 2.34867687044     , 2.7042327414      , 3.28502544488     , 4.01460649773     ,
 4.75109143461     , 5.44097939989     , 6.19430280916     , 7.18056973882     ,
 8.47172224029     , 10.0263584121     , 11.7880393242     , 13.7106927566     ,
 15.6938656979     , 17.5822872442     , 19.2443319304     , 20.5925928276     ,
 21.5374074256     , 21.9968095637     , 21.9742581832     , 21.5815630798     ,
 20.9575192632     , 20.1744736512     , 19.2220221645     , 18.0600255975     ,
 16.6889827444     , 15.1928452208     , 13.7312973296     , 12.4914227196     ,
 11.6202889602     , 11.1599491615     , 11.0268882463     , 11.0698640656     ,
 11.1694885984     , 11.293066432      , 11.4650165496     , 11.7028276638     ,
 11.9908562581     , 12.3000810931     , 12.6094745645     , 12.9145287328     ,
 13.2396840824     , 13.6199594494     , 14.0083660196     , 14.2032424578     ,
 13.9475369129     , 13.1488183475     , 11.9820636508     , 10.7706262817     ,
 9.79520544961     , 9.19115127427     , 8.93190885417     , 8.86069497989     ,
 8.78500671821     , 8.5946381178      , 8.29877695537     , 7.95734689069     ,
 7.5944420189      , 7.17439096505     , 6.64119280685     , 5.97693446779     ,
 5.23225866293     , 4.49657805578     , 3.82860154392     , 3.22525632019     ,
 2.66672932482     , 2.1766084583      , 1.82691800906     , 1.68945408419     ,
 1.77402416833     , 1.99341327829     , 2.19176084692     , 2.23834549478     ,
 2.11757186256     , 1.92723151223     , 1.78505111615     , 1.74083926522     ,
 1.77209549434     , 1.83864336171     , 1.92166660687     , 2.01476355368     ,
 2.09692755387     , 2.13049944201     , 2.08618040698     , 1.96044712013     ,
 1.77058527202     , 1.54727283423     , 1.33185909347     , 1.16389684309     ,
 1.06163173058     , 1.01234220835     , 0.97719851335     , 0.910835643171    ,
 0.79242630615     , 0.64435648255     , 0.516091929664    , 0.44659828229     ,
 0.437341676796    , 0.454273405608    , 0.456605218408    , 0.42883251334     ,
 0.386880459401    , 0.359362548971    , 0.372081351522    , 0.445804488424    ,
 0.590857385994    , 0.794216275053    , 1.01766811078     , 1.21651243991     ,
 1.36324730291     , 1.45715594145     , 1.52114620101     , 1.59905790466     ,
 1.74618948988     , 1.99259096851     , 2.30442554202     , 2.60709011878     ,
 2.86579830637     , 3.12892140368     , 3.47917639613     , 3.95411320297     ,
 4.5194906451      , 5.09857996497     , 5.61426842714     , 6.03048839111     ,
 6.38954187405     , 6.80370546879     , 7.37261896413     , 8.08819395428     ,
 10.4388820935     , 11.1586831793     , 11.6565792256     , 11.9914988982     ,
 12.2005952851     , 12.1969053479     , 11.8165730198     , 10.9543273085     ,
 9.64627387228     , 8.06133673099     , 6.43641347538     , 4.9823704996      ,
 3.81483951655     , 2.96548778374     , 2.42976344991     , 2.16465905912     ,
 2.05650628574     , 1.95281825874     , 1.76032326659     , 1.49762628778     ,
 1.23983229666     , 1.03207497896     , 0.870653483864    , 0.742086860933    ,
 0.645420561374    , 0.575668732535    , 0.512608882703    , 0.441551408705    ,
 0.373938846535    , 0.332903890673    , 0.321739926954    , 0.317255466064    ,
 0.294466230428    , 0.251055875862    , 0.206741175082    , 0.183849079415    ,
 0.190267866405    , 0.216982270662    , 0.247673012425    , 0.271044551809    ,
 0.289093816395    , 0.320347785048    , 0.397199705874    , 0.551236647546    ,
 0.7866135894      , 1.06451756427     , 1.32671093449     , 1.54378788197     ,
 1.73253722698     , 1.92038029693     , 2.11167234118     , 2.31367018708     ,
 2.58760731484     , 3.03469775574     , 3.70088486339     , 4.50113400354     ,
 5.2773861488      , 5.96754770493     , 6.70242549967     , 7.69495878149     ,
 9.04734161121     , 10.7097281633     , 12.5835346313     , 14.5646858638     ,
 16.4958082553     , 18.189525826      , 19.5366109989     , 20.5308506364     ,
 21.1748390211     , 21.4282039489     , 21.2836321676     , 20.8454731355     ,
 20.2735196916     , 19.6474109048     , 18.9093099094     , 17.9365581822     ,
 16.6684865138     , 15.1899129703     , 13.7168036872     , 12.4950468486     ,
 11.6806078149     , 11.2770982895     , 11.1648477699     , 11.1958786254     ,
 11.2858251063     , 11.439202712      , 11.6994829706     , 12.0793091216     ,
 12.5407404472     , 13.0305169118     , 13.5081442283     , 13.9463109508     ,
 14.3472531897     , 14.7466287035     , 15.1236477917     , 15.3018817201     ,
 15.0343736509     , 14.2371690064     , 13.0983475541     , 11.939973064      ,
 11.0106507279     , 10.3994624737     , 10.0618897423     , 9.87586725023     ,
 9.70468776858     , 9.45317545451     , 9.089449708       , 8.63263250023     ,
 8.1212646912      , 7.57312455073     , 6.96715287963     , 6.27526266467     ,
 5.51182137581     , 4.73483517497     , 3.99494392347     , 3.30533302864     ,
 2.67391507346     , 2.14582551732     , 1.79629003745     , 1.68355346517     ,
 1.80121732185     , 2.05448828367     , 2.28595464984     , 2.36099899539     ,
 2.25587069481     , 2.06180505041     , 1.89925861951     , 1.83150478428     ,
 1.85178663165     , 1.92699133156     , 2.03307617613     , 2.15063787593     ,
 2.24559114116     , 2.27401516531     , 2.21091633835     , 2.06691625727     ,
 1.87622048694     , 1.67557545478     , 1.491429789       , 1.33574787957     ,
 1.20924619126     , 1.10561503611     , 1.00919693907     , 0.897490792003    ,
 0.760746225097    , 0.619429319494    , 0.513486002562    , 0.47154862826     ,
 0.488019667652    , 0.524736916927    , 0.537647194932    , 0.50937030914     ,
 0.458621244923    , 0.423007593259    , 0.440480470667    , 0.541452860071    ,
 0.738420259628    , 1.0099740423      , 1.29953699142     , 1.54194808381     ,
 1.70070965947     , 1.78590227104     , 1.84445259463     , 1.94040526561     ,
 2.13253143553     , 2.43672196315     , 2.79511956583     , 3.11197496002     ,
 3.34867030253     , 3.57292351392     , 3.8982988318      , 4.38267004598     ,
 4.98957949668     , 5.6283905017      , 6.21835089954     , 6.73735702101     ,
 7.24374039318     , 7.84848026273     , 8.62883737132     , 9.54347655243     ,
 12.4175059883     , 13.2478778207     , 13.7651420607     , 14.0424178251     ,
 14.1240508494     , 13.9104279133     , 13.234726441      , 12.0304555943     ,
 10.400679834      , 8.56687443747     , 6.78048917566     , 5.23434436185     ,
 4.00872158303     , 3.0992676123      , 2.48186133309     , 2.11993033284     ,
 1.92592734074     , 1.77396029864     , 1.57985880954     , 1.35073688531     ,
 1.14103951817     , 0.979060410358    , 0.852551405911    , 0.745569046532    ,
 0.658619082781    , 0.591363503992    , 0.52936012399     , 0.461903970209    ,
 0.401558295994    , 0.370142856888    , 0.367322368916    , 0.364577466992    ,
 0.332677106065    , 0.269686706443    , 0.201024325253    , 0.156842200309    ,
 0.150763631989    , 0.17503060129     , 0.210343517474    , 0.240766973817    ,
 0.264887846256    , 0.299247001514    , 0.373350259458    , 0.513753956315    ,
 0.720059162377    , 0.955787044182    , 1.17750336647     , 1.37918678717     ,
 1.59518629623     , 1.85345640636     , 2.14473601181     , 2.45760818339     ,
 2.83383188589     , 3.35700851872     , 4.06485580904     , 4.88046660593     ,
 5.66663919781     , 6.38106615648     , 7.15980302661     , 8.2032433897      ,
 9.59243772895     , 11.2602967984     , 13.0976995731     , 14.9904893335     ,
 16.7675119398     , 18.2299961965     , 19.2805638571     , 19.9673337315     ,
 20.3683541961     , 20.4840016537     , 20.2933663142     , 19.8767435474     ,
 19.3975970677     , 18.9441685115     , 18.4306420534     , 17.6726849617     ,
 16.5581232575     , 15.1674320449     , 13.7532260035     , 12.5957010107     ,
 11.8491122345     , 11.4914407718     , 11.3915449303     , 11.4220016784     ,
 11.5345486059     , 11.760458867      , 12.1507269865     , 12.7084186759     ,
 13.3761489806     , 14.0800724027     , 14.7543745401     , 15.3294604961     ,
 15.7620722108     , 16.0813817551     , 16.3181028345     , 16.3747904575     ,
 16.0675158481     , 15.3383909677     , 14.3602503004     , 13.39824015       ,
 12.6138534857     , 12.0163475229     , 11.5433640577     , 11.1405895647     ,
 10.7715003955     , 10.3813640678     , 9.89231253856     , 9.26423398285     ,
 8.54310622756     , 7.81280955917     , 7.1064717563      , 6.39410468628     ,
 5.64694732828     , 4.87872894092     , 4.12167727829     , 3.39813664577     ,
 2.73810123862     , 2.2041460385      , 1.87186349173     , 1.78383532063     ,
 1.91822224141     , 2.1788668574      , 2.41638496211     , 2.49982352472     ,
 2.40003304953     , 2.20087624921     , 2.02259226581     , 1.93659470213     ,
 1.94521476875     , 2.01864458956     , 2.1298991596      , 2.2523185064      ,
 2.3425689228      , 2.35111537588     , 2.25851056683     , 2.09359951481     ,
 1.91033575127     , 1.74789302968     , 1.60993259998     , 1.47623233009     ,
 1.3315007348      , 1.179629954       , 1.03038762455     , 0.884014369047    ,
 0.739328037301    , 0.610881307422    , 0.526432111997    , 0.505123385374    ,
 0.537722243888    , 0.585422164323    , 0.602971000634    , 0.572068824562    ,
 0.51492808677     , 0.478484721997    , 0.51122348645     , 0.648283018436    ,
 0.897382028123    , 1.22404759211     , 1.55573466409     , 1.81730072584     ,
 1.97591121325     , 2.0575015471      , 2.12538573541     , 2.24803467996     ,
 2.47451231549     , 2.80616810338     , 3.17615815984     , 3.48811654959     ,
 3.70941449986     , 3.91991325884     , 4.25004747495     , 4.77234130183     ,
 5.45502255504     , 6.20298240927     , 6.93037144542     , 7.61496704438     ,
 8.31758408931     , 9.14850004652     , 10.1748231726     , 11.3291210239     ,
 14.8768477837     , 15.8196649028     , 16.2870324813     , 16.3776070961     ,
 16.1839109417     , 15.6439137023     , 14.6181239147     , 13.0749328526     ,
 11.1579218923     , 9.1132376957      , 7.18878506423     , 5.55295224201     ,
 4.25497085296     , 3.26348086378     , 2.54026796485     , 2.05651987303     ,
 1.75368529777     , 1.53754496916     , 1.33516756417     , 1.14018663784     ,
 0.984725571697    , 0.880772198782    , 0.806535776013    , 0.738207751402    ,
 0.671115696907    , 0.607622395318    , 0.5432213843      , 0.476628343066    ,
 0.423403068664    , 0.402804028106    , 0.409741389592    , 0.410707580871    ,
 0.37316655737     , 0.295921769051    , 0.209128416347    , 0.148611058292    ,
 0.131525051208    , 0.150503363996    , 0.184594070035    , 0.216529605114    ,
 0.244954205746    , 0.28555418613     , 0.363184577277    , 0.49690467856     ,
 0.680772405707    , 0.880939743475    , 1.06916893371     , 1.26312223264     ,
 1.5147133697      , 1.85053142472     , 2.24278165566     , 2.65471227493     ,
 3.10144072308     , 3.64203493602     , 4.30692021724     , 5.04988151714     ,
 5.79596849302     , 6.54890415099     , 7.42709731293     , 8.55771828572     ,
 9.95158978124     , 11.5211946979     , 13.183506462      , 14.8680247416     ,
 16.4413418082     , 17.7203304026     , 18.6014706766     , 19.1318251194     ,
 19.4128046965     , 19.4719416873     , 19.2905949008     , 18.9320260183     ,
 18.5465912466     , 18.2169225315     , 17.8474920365     , 17.2399695043     ,
 16.2752434747     , 15.0360128569     , 13.7730518417     , 12.7515309599     ,
 12.1102480261     , 11.8317155369     , 11.8092245499     , 11.9383752943     ,
 12.1756399536     , 12.5431825567     , 13.0842420956     , 13.8014636351     ,
 14.6391682132     , 15.5186047014     , 16.3495369261     , 17.0118025879     ,
 17.4089529346     , 17.5608040313     , 17.5581951007     , 17.4108116825     ,
 17.0346430672     , 16.4148038255     , 15.6902331407     , 15.0284626767     ,
 14.4669968477     , 13.9183657398     , 13.3043879901     , 12.6473059151     ,
 12.0186448427     , 11.4159251949     , 10.7337328091     , 9.88520815759     ,
 8.91981477732     , 7.97726623492     , 7.14356659974     , 6.39367137116     ,
 5.66129733401     , 4.91757849188     , 4.17525785826     , 3.46018019903     ,
 2.81346350746     , 2.30346398557     , 1.99928165431     , 1.9272492687      ,
 2.05454593338     , 2.29189253198     , 2.50748328787     , 2.58062911601     ,
 2.47831904408     , 2.27533155784     , 2.08843090271     , 1.99240592291     ,
 1.99412009239     , 2.0656273903      , 2.17844745862     , 2.30044730158     ,
 2.38050419505     , 2.36520661836     , 2.24158534503     , 2.05541302551     ,
 1.87808556349     , 1.75148341985     , 1.66169594348     , 1.56341013529     ,
 1.42730940384     , 1.2611194727      , 1.08936058931     , 0.926360584064    ,
 0.776243305841    , 0.649965619606    , 0.569273522198    , 0.550659349806    ,
 0.58556273483     , 0.635458473198    , 0.65303131568     , 0.618258860689    ,
 0.556594324484    , 0.523590803108    , 0.575542056104    , 0.747256988851    ,
 1.03666242329     , 1.39570233067     , 1.7433653076      , 2.00821455105     ,
 2.17185428454     , 2.27361550686     , 2.3766828046      , 2.53459195105     ,
 2.77822680371     , 3.10304590111     , 3.45469311753     , 3.7574372908      ,
 3.99147460858     , 4.23740084604     , 4.62326172464     , 5.2249378583      ,
 6.01922046376     , 6.91666435605     , 7.82749664153     , 8.72022659364     ,
 9.65416622823     , 10.7500724656     , 12.0788179788     , 13.5420464356     ,
 17.9180124209     , 18.94357484       , 19.2690657619     , 19.0304880102     ,
 18.3968936194     , 17.3894138121     , 15.935679261      , 14.0438482646     ,
 11.8670559732     , 9.63625742303     , 7.57315642845     , 5.8247343858      ,
 4.42991656148     , 3.35072386491     , 2.5394035305      , 1.96358651608     ,
 1.5787402573      , 1.31380670429     , 1.10646415453     , 0.941037440392    ,
 0.833311917124    , 0.784150753631    , 0.764147902543    , 0.739573346951    ,
 0.696605539357    , 0.637834855572    , 0.569259147433    , 0.500858385522    ,
 0.451958778796    , 0.439146019995    , 0.45318494436     , 0.457128982546    ,
 0.416377365836    , 0.330287106649    , 0.232028306119    , 0.160695200855    ,
 0.135188809506    , 0.148431499766    , 0.179689339696    , 0.213228342041    ,
 0.24959890641     , 0.303091839195    , 0.39219772185     , 0.52883377707     ,
 0.705187190902    , 0.893195162391    , 1.07703786337     , 1.28926622747     ,
 1.59012222206     , 1.99957375675     , 2.469776707       , 2.93885688774     ,
 3.39583796661     , 3.87676408377     , 4.41274271858     , 5.00848991104     ,
 5.67573766072     , 6.47015181835     , 7.4678445706      , 8.68575916443     ,
 10.0453917808     , 11.4481490448     , 12.8639282644     , 14.2987660974     ,
 15.690047865      , 16.8902365383     , 17.7745123815     , 18.3335399907     ,
 18.6307717309     , 18.7006413135     , 18.5511881441     , 18.2527815918     ,
 17.9344592531     , 17.6530275099     , 17.3109905011     , 16.7420084891     ,
 15.8750049463     , 14.8157416421     , 13.7831017821     , 12.9779116715     ,
 12.5044096288     , 12.3720392511     , 12.5246618909     , 12.8719596493     ,
 13.3349558731     , 13.8904798537     , 14.5673889076     , 15.3887055548     ,
 16.3287162688     , 17.3196570367     , 18.2485662307     , 18.9473309892     ,
 19.2737848633     , 19.2348364012     , 18.9641222938     , 18.5706795445     ,
 18.0853988006     , 17.5556292836     , 17.0873937573     , 16.7357646498     ,
 16.4035196455     , 15.9108674672     , 15.1707806065     , 14.2707053008     ,
 13.3655250996     , 12.5008754911     , 11.5752973959     , 10.4890505641     ,
 9.29253447419     , 8.14995971502     , 7.17777519794     , 6.36013067951     ,
 5.61128329369     , 4.8735944909      , 4.14391323787     , 3.44789727441     ,
 2.83041041369     , 2.35691196941     , 2.08343384541     , 2.01829195198     ,
 2.1201027102      , 2.31160642988     , 2.4855801299      , 2.5375900758      ,
 2.43225395328     , 2.23241591272     , 2.04698589261     , 1.95094011096     ,
 1.95574521658     , 2.03771760032     , 2.16713772881     , 2.30278387551     ,
 2.38262606482     , 2.34994920252     , 2.19879973805     , 1.98847858193     ,
 1.80488891496     , 1.69863922962     , 1.65333093887     , 1.61061116359     ,
 1.5240058233      , 1.38816428088     , 1.22417531847     , 1.05163310245     ,
 0.882477941689    , 0.733475589717    , 0.630498691704    , 0.593962449303    ,
 0.618359528052    , 0.665687926763    , 0.686135264677    , 0.656192248933    ,
 0.600762871008    , 0.579036733705    , 0.650253584778    , 0.845507657064    ,
 1.15343049951     , 1.51918097107     , 1.86524117905     , 2.13460538242     ,
 2.32480786983     , 2.47807400381     , 2.64136359169     , 2.84316039097     ,
 3.0991638004      , 3.41209359509     , 3.75399064823     , 4.07633175299     ,
 4.36927285263     , 4.70481827476     , 5.19747507368     , 5.91853828861     ,
 6.85223707033     , 7.9183489306      , 9.02652634463     , 10.1413488182     ,
 11.3339257289     , 12.7498607504     , 14.4597969719     , 16.3051311608     ,
 21.6486319304     , 22.6682760212     , 22.7361237973     , 22.0357573941     ,
 20.8138259838     , 19.1960950405     , 17.2145468549     , 14.9339791751     ,
 12.4967154256     , 10.0824336058     , 7.86550642074     , 5.97675224025     ,
 4.46631843751     , 3.308238292       , 2.44731884637     , 1.83348951503     ,
 1.41698637417     , 1.1373555711      , 0.941110570609    , 0.808094481948    ,
 0.743106592011    , 0.73959623366     , 0.764033819127    , 0.776830174921    ,
 0.757629047941    , 0.708157406658    , 0.640882414693    , 0.572901235494    ,
 0.525038691263    , 0.511528591056    , 0.52208769701     , 0.521096352568    ,
 0.475358421135    , 0.384377845204    , 0.280661540189    , 0.202719753449    ,
 0.169685016284    , 0.176018907498    , 0.203920654054    , 0.241210242138    ,
 0.290124251177    , 0.361523853945    , 0.466004520028    , 0.610266040898    ,
 0.790915969426    , 0.991908783187    , 1.20802622897     , 1.47390792809     ,
 1.84148062445     , 2.3141943809      , 2.8252774621      , 3.2964026788      ,
 3.70142265059     , 4.06459550278     , 4.42893389795     , 4.85626256645     ,
 5.43797788123     , 6.2630026665      , 7.35126536735     , 8.61555162984     ,
 9.90896440144     , 11.1386230878     , 12.3304557919     , 13.5640073755     ,
 14.8494644895     , 16.0819797522     , 17.1122802689     , 17.845754839      ,
 18.2649227649     , 18.3887078686     , 18.26453439       , 17.9938920931     ,
 17.6926513035     , 17.3854388346     , 16.9723015258     , 16.3388833182     ,
 15.4968522281     , 14.6000570014     , 13.8311514488     , 13.3012265269     ,
 13.0591519328     , 13.1370548661     , 13.5307469195     , 14.1567453931     ,
 14.886076364      , 15.6411123114     , 16.4405057105     , 17.3412298654     ,
 18.3585438654     , 19.435433231      , 20.4339293653     , 21.1511392565     ,
 21.4199571663     , 21.2312050915     , 20.7266352963     , 20.0808750651     ,
 19.4355266884     , 18.9177072153     , 18.6161408642     , 18.4806445136     ,
 18.2897040959     , 17.790442149      , 16.899297127      , 15.755058727      ,
 14.5663631505     , 13.4184261972     , 12.2406712529     , 10.9491248876     ,
 9.58594643707     , 8.29948034515     , 7.20658875049     , 6.30498098241     ,
 5.51351952286     , 4.76245479682     , 4.033629234       , 3.34809063186     ,
 2.75296978743     , 2.31033865312     , 2.06188679872     , 1.99800774948     ,
 2.06992990397     , 2.21272897276     , 2.34415784414     , 2.37740888867     ,
 2.27522765407     , 2.08688655125     , 1.91100319692     , 1.8219369267      ,
 1.83797754241     , 1.94305583013     , 2.10662122666     , 2.27479365701     ,
 2.370724866       , 2.33311219071     , 2.16243239449     , 1.92874727477     ,
 1.7304536763      , 1.63253564203     , 1.62951830772     , 1.65992860614     ,
 1.65527760017     , 1.57979705396     , 1.43503567498     , 1.24227174627     ,
 1.03008597501     , 0.833302463897    , 0.688954500751    , 0.621903205394    ,
 0.628706576105    , 0.673695206932    , 0.707518710533    , 0.702029619971    ,
 0.674406636624    , 0.677977189794    , 0.768118076986    , 0.971078486945    ,
 1.27230761617     , 1.62298033411     , 1.96261812165     , 2.25320835045     ,
 2.4994615549      , 2.73143323084     , 2.97089886924     , 3.22540916991     ,
 3.50902404553     , 3.84353233188     , 4.22775123885     , 4.62966748582     ,
 5.03728653541     , 5.50884211101     , 6.14613243926     , 7.0166390117      ,
 8.11008697716     , 9.35412489495     , 10.6638575707     , 12.0176839544     ,
 13.5196314409     , 15.3418396076     , 17.5214819226     , 19.7897782821     ,
 26.1850912351     , 27.0379123677     , 26.6912915843     , 25.3934964944     ,
 23.4557010052     , 21.1029403455     , 18.4887867909     , 15.7527244189     ,
 13.0239897534     , 10.4140353341     , 8.03648799171     , 6.00443279779     ,
 4.38502791667     , 3.16990502877     , 2.29694911507     , 1.69171653976     ,
 1.28762526674     , 1.0255237965      , 0.859037421986    , 0.766788608227    ,
 0.745061712898    , 0.780752486551    , 0.839361547437    , 0.882323022498    ,
 0.888653686063    , 0.85857081775     , 0.804366251982    , 0.743073403748    ,
 0.693178742016    , 0.666681591118    , 0.656323942387    , 0.634858956967    ,
 0.576450491868    , 0.481249381835    , 0.376452069474    , 0.294613035106    ,
 0.252810408273    , 0.248447406541    , 0.269504986292    , 0.308617372242    ,
 0.368593172762    , 0.455424003235    , 0.572050926616    , 0.722566535888    ,
 0.913388767723    , 1.14656240355     , 1.42708047362     , 1.77904872996     ,
 2.22671321656     , 2.74509082402     , 3.25298685789     , 3.67293213462     ,
 3.98427117257     , 4.2162904384      , 4.42929611414     , 4.72599167538     ,
 5.24123293562     , 6.06779848422     , 7.17897822718     , 8.43105758322     ,
 9.65524570073     , 10.7724562575     , 11.835497931      , 12.9607009579     ,
 14.2123679151     , 15.5339024392     , 16.7685223851     , 17.7421042576     ,
 18.3404837973     , 18.5433569742     , 18.4265692876     , 18.1320179708     ,
 17.7836480845     , 17.3915469427     , 16.8573374145     , 16.113654259      ,
 15.2528049605     , 14.4827465391     , 13.960495516      , 13.7140891033     ,
 13.7295920052     , 14.0399054629     , 14.6742998767     , 15.5606809292     ,
 16.5448972845     , 17.5175909625     , 18.4912647563     , 19.5435383688     ,
 20.7076850183     , 21.9132132142     , 22.9888900416     , 23.718630741      ,
 23.9442887566     , 23.6491846485     , 22.954995375      , 22.0637464589     ,
 21.208896436      , 20.6014304029     , 20.326986359      , 20.2472912949     ,
 20.0388261932     , 19.4006907305     , 18.2676465498     , 16.8254529003     ,
 15.3231778647     , 13.88298915       , 12.4769852645     , 11.0446791912     ,
 9.60524854133     , 8.25963074157     , 7.1019357254      , 6.1447634496      ,
 5.32757900327     , 4.57851087847     , 3.86192741494     , 3.18919742852     ,
 2.60992660981     , 2.18652978861     , 1.95141803103     , 1.88365694514     ,
 1.93167123828     , 2.04083438217     , 2.14707677035     , 2.17553087182     ,
 2.08524064394     , 1.91272990566     , 1.74781508958     , 1.66533376966     ,
 1.69091296222     , 1.81653372541     , 2.01214534044     , 2.21344141537     ,
 2.33031209533     , 2.2969886826      , 2.11975862871     , 1.87738624587     ,
 1.67635064806     , 1.5925099991      , 1.63324145487     , 1.7393626124      ,
 1.82179827371     , 1.80868437536     , 1.67544815993     , 1.44609132148     ,
 1.1748446067      , 0.922824133538    , 0.738066661255    , 0.64364051725     ,
 0.634568373506    , 0.680892668611    , 0.73939281049     , 0.777651452274    ,
 0.798267558685    , 0.839471548638    , 0.947134191553    , 1.1434708016      ,
 1.41815653065     , 1.74043407089     , 2.07763162562     , 2.41170291765     ,
 2.74328244052     , 3.07591782455     , 3.40158779675     , 3.71614694699     ,
 4.0475144671      , 4.44577811874     , 4.93210092076     , 5.47678484457     ,
 6.05265837425     , 6.6998033353      , 7.51071246676     , 8.55455554264     ,
 9.83015318657     , 11.2774865689     , 12.8294152246     , 14.4968521255     ,
 16.4233699334     , 18.7802772825     , 21.5130076915     , 24.191386586      ,
 31.5259772347     , 31.9969405098     , 31.0408851539     , 28.9924155897     ,
 26.2171233703     , 23.0200501923     , 19.6721592525     , 16.4015459298     ,
 13.3403016338     , 10.5354097703     , 8.03032870101     , 5.90432333267     ,
 4.2261365655      , 2.99690220037     , 2.14843666787     , 1.58490320186     ,
 1.22110614105     , 0.995087060026    , 0.867550630663    , 0.819813771949    ,
 0.842523937665    , 0.916667650055    , 1.00869855225     , 1.08557296657     ,
 1.12850539735     , 1.13311288044     , 1.10452181076     , 1.05442159094     ,
 0.997614864414    , 0.944991868303    , 0.895430690556    , 0.835644725539    ,
 0.752955926282    , 0.650076414038    , 0.545762543794    , 0.461317597687    ,
 0.408178539412    , 0.386702369713    , 0.392852671258    , 0.425427000091    ,
 0.487595789494    , 0.580825800979    , 0.702162183501    , 0.854899647899    ,
 1.05708045668     , 1.33109317235     , 1.69091323636     , 2.14040174235     ,
 2.66187408838     , 3.19565075638     , 3.6557713337      , 3.98693122838     ,
 4.19677130586     , 4.33393997038     , 4.46968239008     , 4.71184168311     ,
 5.18894161908     , 5.97494036843     , 7.02941853544     , 8.21949211039     ,
 9.40107152336     , 10.4993036273     , 11.5423962632     , 12.631581412      ,
 13.862995396      , 15.2408436694     , 16.6352348433     , 17.8251092364     ,
 18.6080120165     , 18.9041922949     , 18.7885853471     , 18.4336367396     ,
 17.9921512294     , 17.4934895129     , 16.8585707495     , 16.0529094378     ,
 15.211957805      , 14.5659413876     , 14.2485055621     , 14.2363570719     ,
 14.475204887      , 14.9877386908     , 15.8175740538     , 16.916573115      ,
 18.1476363254     , 19.400520642      , 20.6730935798     , 22.0259818931     ,
 23.4673281781     , 24.8798359162     , 26.0482245793     , 26.7629330128     ,
 26.9119378313     , 26.4976732934     , 25.620576826      , 24.4854386456     ,
 23.386470144      , 22.5981215545     , 22.2030308011     , 21.9961991686     ,
 21.5862269277     , 20.6543982585     , 19.1660726589     , 17.3508975056     ,
 15.4940234476     , 13.7548116578     , 12.1473764215     , 10.6298920094     ,
 9.19101638395     , 7.87379291154     , 6.73711479156     , 5.79981035378     ,
 5.02054323314     , 4.32681300013     , 3.66397129111     , 3.02920587546     ,
 2.47185643506     , 2.05777036607     , 1.8199068064      , 1.73885861966     ,
 1.76820207272     , 1.8610659399      , 1.9618530266      , 1.99953333711     ,
 1.92772019194     , 1.77257043792     , 1.61712927223     , 1.53599548909     ,
 1.5588314066      , 1.6828861371      , 1.88128464689     , 2.08834673453     ,
 2.21042778167     , 2.18245479165     , 2.01720915933     , 1.7983972783      ,
 1.63012837687     , 1.58459475278     , 1.6726858227      , 1.83983770129     ,
 1.98676102649     , 2.01521035807     , 1.87962228151     , 1.60966124645     ,
 1.28759144042     , 0.999678260844    , 0.797829974784    , 0.694093396572    ,
 0.677848758978    , 0.728043637961    , 0.813198648111    , 0.899009678552    ,
 0.971657766613    , 1.05113450174     , 1.172492711       , 1.35522899731     ,
 1.59608357369     , 1.88614686819     , 2.22507433089     , 2.61727872729     ,
 3.05576725043     , 3.50876444058     , 3.93129034603     , 4.30855664328     ,
 4.69091446644     , 5.16543949783     , 5.7784307358      , 6.50003135599     ,
 7.28307406144     , 8.14364092145     , 9.16097246245     , 10.4085903064     ,
 11.9054834522     , 13.621992966      , 15.5282187339     , 17.6729524559     ,
 20.2105236221     , 23.2483259361     , 26.5758319637     , 29.5786300615     ,
 37.3451260214     , 37.2050636001     , 35.4467536702     , 32.4994773654     ,
 28.7791258367     , 24.6546775086     , 20.5022820531     , 16.6470615065     ,
 13.2454037571     , 10.2908847038     , 7.7454544842      , 5.6282204637      ,
 3.98370698217     , 2.80944536561     , 2.03261818658     , 1.54308210671     ,
 1.24041242259     , 1.05966712609     , 0.97064524577     , 0.962976340669    ,
 1.02718643375     , 1.14147275404     , 1.27501015779     , 1.40092348063     ,
 1.49988232888     , 1.55616484795     , 1.56124722798     , 1.52032952464     ,
 1.44836286718     , 1.35901450774     , 1.25851342223     , 1.14808920872     ,
 1.03042124271     , 0.913439055122    , 0.807700961211    , 0.720260527854    ,
 0.65293209609     , 0.607183751255    , 0.588150352659    , 0.603265769027    ,
 0.658058762397    , 0.750640821325    , 0.872170063208    , 1.02331717814     ,
 1.23075525526     , 1.53449849697     , 1.95479280942     , 2.47208683878     ,
 3.02646061158     , 3.53093751104     , 3.90935370956     , 4.14441622566     ,
 4.28428561789     , 4.40050878677     , 4.55931725082     , 4.83285768658     ,
 5.29893586407     , 6.00373941339     , 6.93350814677     , 8.02426010703     ,
 9.18683342358     , 10.3356170952     , 11.4315162054     , 12.518733824      ,
 13.7025419642     , 15.051715748      , 16.4937429119     , 17.8052612872     ,
 18.7266826431     , 19.1147259919     , 19.0138578679     , 18.6059787475     ,
 18.0827244668     , 17.5246241948     , 16.8949031541     , 16.1759355026     ,
 15.4878984668     , 15.0213787916     , 14.873351702      , 15.011712773      ,
 15.3929343567     , 16.0475980248     , 17.0294545467     , 18.3219593747     ,
 19.8279135414     , 21.4453340999     , 23.1356508181     , 24.9054819253     ,
 26.7097405363     , 28.3718179037     , 29.6298878516     , 30.286478283      ,
 30.2931906024     , 29.6998280239     , 28.6080378529     , 27.2195743123     ,
 25.8532272764     , 24.8067363229     , 24.1479294543     , 23.6334808583     ,
 22.8550115345     , 21.5145216006     , 19.6118453263     , 17.4007772017     ,
 15.1853734176     , 13.1557136097     , 11.3643764324     , 9.78787977804     ,
 8.3922714793      , 7.16996619418     , 6.13753306493     , 5.30220361628     ,
 4.62985107142     , 4.04743489008     , 3.48356422585     , 2.91673164946     ,
 2.38955758165     , 1.97330412277     , 1.71321012913     , 1.60441035535     ,
 1.61137849734     , 1.69168901019     , 1.79136827058     , 1.84038741581     ,
 1.78957872583     , 1.65713224536     , 1.51663841514     , 1.43581398499     ,
 1.44156273437     , 1.53331640779     , 1.69203781078     , 1.86367646045     ,
 1.96612221873     , 1.94402625906     , 1.81656703012     , 1.66411149227     ,
 1.5736827566      , 1.59672919491     , 1.73574293068     , 1.94099201026     ,
 2.11605588834     , 2.15530933505     , 2.00703221307     , 1.71074274698     ,
 1.37063836112     , 1.08673113244     , 0.903400635772    , 0.81382327412     ,
 0.79903478398     , 0.848617852428    , 0.946999629519    , 1.06323752637     ,
 1.17245998755     , 1.28054887505     , 1.41367272698     , 1.58766274429     ,
 1.80175033834     , 2.06264036297     , 2.40038631883     , 2.84773319025     ,
 3.39792165051     , 3.98363129295     , 4.51303692833     , 4.95088232186     ,
 5.36922776702     , 5.89951277087     , 6.62311636305     , 7.5192061271      ,
 8.5250403152      , 9.62856405363     , 10.8880361868     , 12.3821833029     ,
 14.1662794187     , 16.2663691206     , 18.7052767499     , 21.5485827429     ,
 24.8923340069     , 28.6944298525     , 32.5467714263     , 35.6831769339     ,
 42.916181335      , 41.9423964809     , 39.2297610836     , 35.2917688179     ,
 30.5921681113     , 25.5535902265     , 20.6370778498     , 16.253044455      ,
 12.5867928849     , 9.58491865938     , 7.12100808099     , 5.13552487145     ,
 3.63058783868     , 2.59120492784     , 1.94124096589     , 1.56266703474     ,
 1.34502064844     , 1.22191600234     , 1.17278263239     , 1.19879061286     ,
 1.2966896971      , 1.44859558812     , 1.63025311875     , 1.8199878311      ,
 1.99217010935     , 2.11187585856     , 2.15193409315     , 2.11301903257     ,
 2.01764395719     , 1.88800070211     , 1.73648192862     , 1.57351607286     ,
 1.41460799716     , 1.27554616451     , 1.16269619974     , 1.06986655191     ,
 0.98675563378     , 0.912798288195    , 0.8617702446      , 0.852620253823    ,
 0.896787857978    , 0.989400051788    , 1.11168324221     , 1.25504731048     ,
 1.4478034994      , 1.74202470495     , 2.16311689968     , 2.67543257468     ,
 3.19335998022     , 3.62252143703     , 3.90989523095     , 4.07773664433     ,
 4.20849282584     , 4.38722734743     , 4.65803658766     , 5.02893888181     ,
 5.50221207521     , 6.0977973161      , 6.85624277771     , 7.81139946193     ,
 8.94164886015     , 10.1514439664     , 11.3303097274     , 12.4507328824     ,
 13.5974273485     , 14.8747393097     , 16.2676724694     , 17.5890724692     ,
 18.5709333377     , 19.0276845834     , 18.9624008837     , 18.5501063428     ,
 18.0210230294     , 17.5202473684     , 17.0609381343     , 16.6210476845     ,
 16.2508330252     , 16.0449095855     , 16.0492199305     , 16.2589677757     ,
 16.6948452077     , 17.431328758      , 18.5437990599     , 20.044762971      ,
 21.8664088167     , 23.8951620752     , 26.0302758187     , 28.207153296      ,
 30.3332998451     , 32.1975720647     , 33.5102325961     , 34.0795352858     ,
 33.904204257      , 33.084401216      , 31.743609251      , 30.0847859066     ,
 28.4219668436     , 27.0379503483     , 25.9778046907     , 24.9977375483     ,
 23.7334938391     , 21.9478768609     , 19.6675226486     , 17.130756217      ,
 14.6246283709     , 12.3537454715     , 10.4071334493     , 8.78763415089     ,
 7.45468556773     , 6.36163577926     , 5.47718156846     , 4.78111112219     ,
 4.23904310678     , 3.78351431649     , 3.33305881534     , 2.8442313867      ,
 2.34601346401     , 1.91564202238     , 1.61816102138     , 1.46895650918     ,
 1.44319552189     , 1.49975038939     , 1.58529499904     , 1.63515330143     ,
 1.60423465546     , 1.50445263043     , 1.39299735655     , 1.32017400336     ,
 1.30280735222     , 1.34116769241     , 1.42937809935     , 1.53682487035     ,
 1.60673379445     , 1.60074279135     , 1.54026191345     , 1.49077762464     ,
 1.51107386928     , 1.62388064879     , 1.81659485273     , 2.04062326685     ,
 2.2089629178      , 2.22757495458     , 2.0588939601      , 1.75849966313     ,
 1.44124362056     , 1.20337432107     , 1.07025897211     , 1.01285969766     ,
 1.0035704783      , 1.04229788947     , 1.13151578104     , 1.25120883174     ,
 1.37602456136     , 1.50524843046     , 1.6572163554      , 1.83937062605     ,
 2.04455167176     , 2.28448266767     , 2.61329811945     , 3.09651304933     ,
 3.74062860523     , 4.45240931309     , 5.09065005902     , 5.58945190077     ,
 6.03505140982     , 6.60271742965     , 7.41419241905     , 8.46635148118     ,
 9.68853278513     , 11.0434082611     , 12.5698979845     , 14.3603234274     ,
 16.5226369129     , 19.1522386961     , 22.3150666679     , 26.0407634441     ,
 30.2778780792     , 34.7610876734     , 38.8902217131     , 41.8365473259     ,
 47.3012157566     , 45.2620604679     , 41.4884127385     , 36.5679659211     ,
 31.0074025757     , 25.2597507826     , 19.8200859628     , 15.1313754398     ,
 11.383504321      , 8.48085320649     , 6.22094767535     , 4.47041360766     ,
 3.18715623125     , 2.34190747636     , 1.85812109448     , 1.61801562539     ,
 1.50932608842     , 1.46523207666     , 1.46848514017     , 1.52707880256     ,
 1.64798615184     , 1.82684447465     , 2.05251260615     , 2.3078675369      ,
 2.55629451069     , 2.73971542274     , 2.81126466526     , 2.76983815858     ,
 2.65122606699     , 2.48961416795     , 2.29949581461     , 2.0915665324      ,
 1.88901234057     , 1.7184861536      , 1.58950550605     , 1.48797519225     ,
 1.39157308922     , 1.29365170822     , 1.21272459495     , 1.17916424533     ,
 1.21272685495     , 1.3057650051      , 1.42547981864     , 1.54712721489     ,
 1.69263981634     , 1.91978426806     , 2.26128680998     , 2.68196585631     ,
 3.09688159158     , 3.42565658208     , 3.64191631149     , 3.79316093769     ,
 3.97600782023     , 4.27416494275     , 4.7006887772      , 5.19326142383     ,
 5.67740967557     , 6.15272703814     , 6.71928163724     , 7.50563967509     ,
 8.55694603753     , 9.78794148614     , 11.0519094789     , 12.2646822494     ,
 13.460444076      , 14.7226322028     , 16.0584758472     , 17.3317465844     ,
 18.3121150001     , 18.8092539847     , 18.7976976567     , 18.4447074706     ,
 18.0140805053     , 17.7053002169     , 17.5642360638     , 17.5412489532     ,
 17.5925892387     , 17.7016224912     , 17.8631650668     , 18.1122597995     ,
 18.5541948145     , 19.3310611386     , 20.5564238631     , 22.269090402      ,
 24.4087485811     , 26.8224584917     , 29.3271392193     , 31.7836119357     ,
 34.0744852978     , 36.0004032238     , 37.2838521058     , 37.7383199714     ,
 37.3767826889     , 36.3258956149     , 34.7303902996     , 32.7915631788     ,
 30.7975589361     , 28.9966115851     , 27.4208928123     , 25.8691238724     ,
 24.0723726142     , 21.8798785868     , 19.3304327536     , 16.6074584224     ,
 13.9434226113     , 11.5354320504     , 9.50207344778     , 7.87710016619     ,
 6.6240419664      , 5.66507097133     , 4.92080286109     , 4.34054743391     ,
 3.89312843978     , 3.52787956408     , 3.16412029862     , 2.73978826783     ,
 2.26725375835     , 1.82544161162     , 1.49481999756     , 1.30589711569     ,
 1.24084050805     , 1.26010728176     , 1.31495402894     , 1.35202068371     ,
 1.33575665167     , 1.27293652107     , 1.20003890307     , 1.1441446396      ,
 1.10889279401     , 1.0952252677      , 1.1121281353      , 1.15656401973     ,
 1.20241996968     , 1.22906052569     , 1.25311515592     , 1.3172861438      ,
 1.45242961707     , 1.65831380709     , 1.90670127259     , 2.14112282195     ,

 2.28006416466     , 2.25321912516     , 2.05625892413     , 1.76738012497     ,
 1.50055334912     , 1.33235061211     , 1.26332435967     , 1.24578004321     ,
 1.24571260545     , 1.26994200531     , 1.33686445369     , 1.44347428599     ,
 1.57489163525     , 1.73049800228     , 1.91917357916     , 2.13370942798     ,
 2.35425555507     , 2.59092404594     , 2.9136262758      , 3.41572274865     ,
 4.12345821631     , 4.93454706042     , 5.67329284848     , 6.2444058009      ,
 6.73627415579     , 7.35367445379     , 8.25260768718     , 9.45125668971     ,
 10.879321749      , 12.4843480192     , 14.2996631865     , 16.4471750551     ,
 19.0951616246     , 22.393169997      , 26.4035928897     , 31.0466809524     ,
 36.0502087207     , 40.9008119587     , 44.8644685144     , 47.1667086923     ,
 49.6929685865     , 46.3573605859     , 41.4725743972     , 35.7014925974     ,
 29.5778843226     , 23.5315675478     , 18.0009147556     , 13.3726851956     ,
 9.80004988968     , 7.15790608176     , 5.2025446717      , 3.7521296202      ,
 2.72944960133     , 2.09393739921     , 1.77626710804     , 1.67336526121     ,
 1.68381498455     , 1.73986974603     , 1.81448024306     , 1.9105054719      ,
 2.04523115272     , 2.23614941619     , 2.49088083662     , 2.79650298436     ,
 3.10533810327     , 3.34047553164     , 3.44005577006     , 3.4023552488      ,
 3.27560612985     , 3.10382709133     , 2.89744217658     , 2.65841248115     ,
 2.41272925787     , 2.20171863627     , 2.04741389651     , 1.93592183363     ,
 1.83491538319     , 1.72676389859     , 1.62629657964     , 1.56900707476     ,
 1.58219199085     , 1.65924112857     , 1.75812112307     , 1.83893670133     ,
 1.91117171454     , 2.02928498768     , 2.23327196434     , 2.50469154824     ,
 2.78328942921     , 3.0161358738      , 3.1960953816      , 3.37408625987     ,
 3.63976636273     , 4.06559687091     , 4.6368559626      , 5.23436256845     ,
 5.72318946222     , 6.08911816285     , 6.47917703973     , 7.09159367574     ,
 8.02415136984     , 9.22017807272     , 10.5415061592     , 11.8832413118     ,
 13.2234264313     , 14.5805298543     , 15.9374201846     , 17.1934904051     ,
 18.1747820963     , 18.7169910868     , 18.7892422432     , 18.5593025371     ,
 18.315540119      , 18.2873737971     , 18.5263720942     , 18.9457566983     ,
 19.4258820832     , 19.8701497039     , 20.2360022024     , 20.580213295      ,
 21.0625861643     , 21.8790389867     , 23.1865899582     , 25.0574396421     ,
 27.4380560001     , 30.1313366199     , 32.8665997635     , 35.4262320061     ,
 37.6764412112     , 39.4618338688     , 40.5585281079     , 40.8039212237     ,
 40.2146739808     , 38.9268651393     , 37.0930367638     , 34.8920150236     ,
 32.560183617      , 30.3035825342     , 28.163899741      , 26.0176917762     ,
 23.7144804998     , 21.1932065196     , 18.4966348051     , 15.7401673789     ,
 13.0820680626     , 10.6867464079     , 8.68063009301     , 7.11830807841     ,
 5.96863487314     , 5.13059100737     , 4.48776820314     , 3.96948531917     ,
 3.55563245131     , 3.22077284883     , 2.8977949125      , 2.51887254732     ,
 2.08273945461     , 1.65916441882     , 1.32640603173     , 1.11699419974     ,
 1.01770562414     , 0.996026568562    , 1.01348562365     , 1.02976757349     ,
 1.01848763467     , 0.982307331548    , 0.940526257835    , 0.90174460633     ,
 0.859880818263    , 0.816161027077    , 0.78963303934     , 0.79820718638     ,
 0.840585334298    , 0.908279859587    , 1.00817792942     , 1.16160394941     ,
 1.38335001407     , 1.66471359943     , 1.96517123702     , 2.21059139782     ,
 2.31559006239     , 2.23606485957     , 2.00956980483     , 1.7380509045      ,
 1.52585968619     , 1.42296573046     , 1.40967404271     , 1.43061107801     ,
 1.44966848756     , 1.47410633535     , 1.53028583091     , 1.63229053833     ,
 1.78224567217     , 1.98396021969     , 2.23466411546     , 2.50854306968     ,
 2.77381488292     , 3.04128213064     , 3.38997687497     , 3.92513056721     ,
 4.68434399069     , 5.5704343648      , 6.4003106152      , 7.06247736329     ,
 7.63469179174     , 8.32944781913     , 9.32890855434     , 10.6807746906     ,
 12.3276166774     , 14.2121440177     , 16.3720946454     , 18.9653634857     ,
 22.2084738513     , 26.2607589816     , 31.1092388272     , 36.4935745326     ,
 41.8903630966     , 46.5768816024     , 49.7842000813     , 50.9055337827     ,
 49.6720699194     , 44.9156153997     , 38.9958988009     , 32.6371818672     ,
 26.3639974025     , 20.5135625095     , 15.3725603924     , 11.1872079513     ,
 8.03946515483     , 5.79461767007     , 4.21018295536     , 3.08686966231     ,
 2.32342150747     , 1.87228123061     , 1.68230502497     , 1.68277364641     ,
 1.79652692486     , 1.95482631118     , 2.1100399461      , 2.24936967794     ,
 2.39653924884     , 2.59063975343     , 2.85662530397     , 3.18513529196     ,
 3.52378860711     , 3.78956974313     , 3.91486923168     , 3.89646385235     ,
 3.7881868174      , 3.63726371757     , 3.44373256066     , 3.19377881343     ,
 2.9121280174      , 2.65784190756     , 2.47399487212     , 2.3550456838      ,
 2.26154332635     , 2.16019115129     , 2.05101867283     , 1.96326494103     ,
 1.92894444006     , 1.95259731206     , 2.00052260265     , 2.02966844535     ,
 2.03380974881     , 2.04998950801     , 2.11593408739     , 2.23476476578     ,
 2.383246071       , 2.54052291438     , 2.70906258063     , 2.9268268958      ,
 3.26481723716     , 3.78301563654     , 4.45028317983     , 5.11410516029     ,
 5.60387272254     , 5.89818010431     , 6.17110618561     , 6.65627701656     ,
 7.47609458081     , 8.59700519418     , 9.91271986951     , 11.3391637168     ,
 12.8319554669     , 14.347763309      , 15.8183126667     , 17.1455321252     ,
 18.1978775015     , 18.8465704143     , 19.0701398615     , 19.0371941154     ,
 19.0427009008     , 19.3211016949     , 19.9161997987     , 20.71984179       ,
 21.5843762522     , 22.3871434062     , 23.0662123472     , 23.6636470436     ,
 24.3271468222     , 25.2510039247     , 26.6139604988     , 28.5316535188     ,
 30.9870607885     , 33.7730304817     , 36.5521881197     , 39.0256123634     ,
 41.0262343675     , 42.4368346507     , 43.1061651282     , 42.9292770621     ,
 41.9585630201     , 40.3588106431     , 38.2865113811     , 35.8687668113     ,
 33.2550385212     , 30.5954074006     , 27.9515477013     , 25.2875019265     ,
 22.5634918861     , 19.7988208247     , 17.0505376773     , 14.3863097282     ,
 11.8912961122     , 9.67006716357     , 7.82139333552     , 6.39914400773     ,
 5.37614963331     , 4.64254441184     , 4.06603110606     , 3.57127463776     ,
 3.15199763923     , 2.80728592715     , 2.49312358008     , 2.15301178863     ,
 1.7790944042      , 1.41954420577     , 1.12895995446     , 0.928411916599    ,
 0.809741761088    , 0.75483170421     , 0.739697718738    , 0.734584436031    ,
 0.718002004537    , 0.689731200032    , 0.660503684034    , 0.631460352471    ,
 0.593592475701    , 0.547420288648    , 0.51357281961     , 0.518207591547    ,
 0.572686958501    , 0.673119772184    , 0.816306064014    , 1.01034969579     ,
 1.26846397718     , 1.58737415784     , 1.92087964251     , 2.17612416794     ,
 2.25932410492     , 2.14665686148     , 1.90906822382     , 1.66218111751     ,
 1.4947860217      , 1.4343470143      , 1.45461235498     , 1.50727925713     ,
 1.55982483533     , 1.61431080042     , 1.69498088993     , 1.82661594612     ,
 2.02791937136     , 2.30882056975     , 2.6545671439      , 3.02056538806     ,
 3.36893009129     , 3.72033984624     , 4.16180898693     , 4.79186481853     ,
 5.63821532443     , 6.60765416406     , 7.52946764013     , 8.29200391598     ,
 8.95776304988     , 9.73488617817     , 10.8344715444     , 12.3522883794     ,
 14.260745739      , 16.5010517945     , 19.1060993776     , 22.2499245576     ,
 26.1611749713     , 30.9512199345     , 36.463203027      , 42.2110023744     ,
 47.4380359618     , 51.301950172      , 53.1209802842     , 52.5561092436     ,
 47.2542865211     , 41.2103209781     , 34.5406609559     , 27.9698552442     ,
 21.9605733706     , 16.712281682      , 12.3156274398     , 8.8390603751      ,
 6.27925566853     , 4.50739798474     , 3.31387181808     , 2.50770206998     ,
 1.97413952214     , 1.66233316083     , 1.5464538079      , 1.59841383365     ,
 1.77306552685     , 2.00450819971     , 2.22649085918     , 2.40971952466     ,
 2.57729412788     , 2.77754481839     , 3.0422390533      , 3.36445930156     ,
 3.69719849201     , 3.96671706634     , 4.11048315097     , 4.12433934794     ,
 4.0609296767      , 3.96306409945     , 3.81455853215     , 3.58061656928     ,
 3.28066817824     , 2.9913714721      , 2.78103328155     , 2.65832575416     ,
 2.58069061377     , 2.4976372618      , 2.3856699805      , 2.2567905671      ,
 2.14493979073     , 2.07785755655     , 2.05171634465     , 2.03663665265     ,
 2.01036533168     , 1.97788573433     , 1.95830747341     , 1.96775465874     ,
 2.01809110793     , 2.11882921997     , 2.27811686821     , 2.51765271754     ,
 2.88917998763     , 3.44316267141     , 4.14405980528     , 4.8316612426      ,
 5.32720036818     , 5.60882213806     , 5.85657421573     , 6.30503531497     ,
 7.06793356188     , 8.10984627349     , 9.35198551048     , 10.7602525139     ,
 12.3209151772     , 13.9714376375     , 15.5962794792     , 17.0726390724     ,
 18.286894992      , 19.1423055737     , 19.6270040024     , 19.8921130281     ,
 20.2080306922     , 20.793940113      , 21.6922333496     , 22.8076185073     ,
 24.0168549677     , 25.2201836852     , 26.3535572534     , 27.4130159008     ,
 28.4639798575     , 29.6226721768     , 31.0415871977     , 32.8773232271     ,
 35.187304047      , 37.8119174067     , 40.3950038698     , 42.5684063188     ,
 44.1056301088     , 44.8931268954     , 44.8470265935     , 43.9551346805     ,
 42.3598432272     , 40.2968247708     , 37.9392415235     , 35.349164353      ,
 32.5642601127     , 29.6545098157     , 26.6795321918     , 23.6641354914     ,
 20.6514366161     , 17.7335767206     , 15.0066255956     , 12.5254573158     ,
 10.3125586406     , 8.3905916608      , 6.79842294821     , 5.57091967323     ,
 4.68810530757     , 4.05024212248     , 3.53114904974     , 3.06142874493     ,
 2.64331787685     , 2.29105844795     , 1.98517222241     , 1.69198180741     ,
 1.40415334747     , 1.142458807       , 0.926078808098    , 0.758164237637    ,
 0.636871424376    , 0.561970899978    , 0.524551629645    , 0.502487524534    ,
 0.476189079871    , 0.4439346722      , 0.414593463238    , 0.389950080027    ,
 0.362677866867    , 0.331605248622    , 0.312542045783    , 0.329573115172    ,
 0.39638028413     , 0.508748923106    , 0.656369703133    , 0.841828319464    ,
 1.08411635504     , 1.39171813154     , 1.72192402343     , 1.97550388653     ,
 2.05685519541     , 1.95292099795     , 1.74511789692     , 1.54248556208     ,
 1.41393264177     , 1.37496015672     , 1.40809736589     , 1.4842259366      ,
 1.58085987545     , 1.69550506469     , 1.8451350066      , 2.05673719702     ,
 2.35930932637     , 2.76817473094     , 3.25931927307     , 3.77279040057     ,
 4.26938182647     , 4.78527347411     , 5.41513472372     , 6.23705644059     ,
 7.24562261788     , 8.33511808028     , 9.34948250947     , 10.1919772635     ,
 10.9233652004     , 11.7553899894     , 12.9375909003     , 14.6284939491     ,
 16.8426332002     , 19.5172575627     , 22.6558201431     , 26.4037277036     ,
 30.9467419597     , 36.295674297      , 42.114122069      , 47.6937123128     ,
 52.1088108675     , 54.5134856385     , 54.4349067156     , 51.8818233881     ,
 42.8071508569     , 35.9049549378     , 28.962835905      , 22.6053112777     ,
 17.1831117247     , 12.7601765228     , 9.256702096       , 6.58297878461     ,
 4.6563811103      , 3.35838798295     , 2.5257940822      , 1.99384804947     ,
 1.64586848822     , 1.43045645242     , 1.34482880886     , 1.39958878521     ,
 1.5807424796      , 1.83321720084     , 2.08647243473     , 2.30265499254     ,
 2.49664191869     , 2.7088002864      , 2.96491399139     , 3.25910390023     ,
 3.55632731919     , 3.80154369698     , 3.94693052636     , 3.99334834609     ,
 3.99044425437     , 3.96942047736     , 3.89202169814     , 3.69999250772     ,
 3.40512140262     , 3.09790168204     , 2.86936092681     , 2.74435083765     ,
 2.68307345877     , 2.62256530846     , 2.51464803679     , 2.34831057185     ,
 2.1556618517      , 1.99140606041     , 1.89200034519     , 1.85123555798     ,
 1.83473075852     , 1.81095530588     , 1.77021453693     , 1.72890576416     ,
 1.72168083546     , 1.78073196579     , 1.92038912633     , 2.15263247331     ,
 2.51501063566     , 3.04998594729     , 3.72608265219     , 4.39934295925     ,
 4.90928963273     , 5.23858962692     , 5.55235950887     , 6.05783247775     ,
 6.83797886109     , 7.83673609736     , 8.98759521173     , 10.3095526181     ,
 11.8501596448     , 13.5687454473     , 15.3253498525     , 16.9712950055     ,
 18.406521869      , 19.5692119219     , 20.4484521664     , 21.1424717158     ,
 21.8534772105     , 22.7656088453     , 23.9343186676     , 25.3118874292     ,
 26.8369348669     , 28.4636299408     , 30.1423479989     , 31.8117189087     ,
 33.4098880467     , 34.9140290753     , 36.4025629523     , 38.0542632114     ,
 40.012616912      , 42.2054625396     , 44.3124856563     , 45.9334868118     ,
 46.7785284195     , 46.708835881      , 45.6948746748     , 43.8377415964     ,
 41.4040387425     , 38.7246230353     , 36.0052600168     , 33.2602605698     ,
 30.4240373092     , 27.4672823265     , 24.4013292272     , 21.259651641      ,
 18.1330973077     , 15.1804285851     , 12.555008271      , 10.3228192211     ,
 8.45504776183     , 6.88829080387     , 5.59165634194     , 4.57634445352     ,
 3.83562279015     , 3.29484776603     , 2.84824667743     , 2.43548703586     ,
 2.05825430386     , 1.73348930909     , 1.45928623802     , 1.22512549643     ,
 1.02831994848     , 0.866907692438    , 0.728892189908    , 0.602334076581    ,
 0.491356917032    , 0.410306128756    , 0.361938254543    , 0.33040692392     ,
 0.298373027629    , 0.26374088943     , 0.235051827832    , 0.216041714974    ,
 0.201540392347    , 0.188333144908    , 0.185739472925    , 0.211887820503    ,
 0.278337223406    , 0.379885338178    , 0.50338065518     , 0.649629059604    ,
 0.841673854979    , 1.09752685001     , 1.386063854       , 1.62078430579     ,
 1.71820778543     , 1.66810119465     , 1.5367012174      , 1.40507360916     ,
 1.31984396044     , 1.2951176727      , 1.33209182134     , 1.42635798309     ,
 1.57167289816     , 1.76857094364     , 2.02923975275     , 2.37717150008     ,
 2.84444824136     , 3.45244534633     , 4.17795696        , 4.9561246659      ,
 5.74508873097     , 6.58011890709     , 7.54063584717     , 8.66389059127     ,
 9.89453204118     , 11.1031529887     , 12.1535654536     , 12.9921963593     ,
 13.7158492245     , 14.5624909685     , 15.817781167      , 17.6897951661     ,
 20.2281052219     , 23.3604668228     , 27.0348059968     , 31.3120576202     ,
 36.2719753885     , 41.7909364092     , 47.3708085431     , 52.1521487444     ,
 55.1498646817     , 55.6314599814     , 53.4207441024     , 48.9090365798     ,
 36.9554062888     , 29.7776642873     , 23.0920838966     , 17.3296563981     ,
 12.6974566347     , 9.15686317032     , 6.52319039597     , 4.60356000946     ,
 3.25771729401     , 2.37577083214     , 1.83965110202     , 1.52022758995     ,
 1.31083606825     , 1.16230562755     , 1.08534025473     , 1.11438841436     ,
 1.25897691773     , 1.48201324503     , 1.72409483681     , 1.94782234039     ,
 2.15609339783     , 2.37212078734     , 2.61045551989     , 2.86514267792     ,
 3.11128385265     , 3.31155028062     , 3.43840892904     , 3.50643513466     ,
 3.56362393327     , 3.62340524226     , 3.62264540666     , 3.48386294995     ,
 3.21351250952     , 2.90949023429     , 2.67579236496     , 2.55035080967     ,
 2.5025647232      , 2.46756188482     , 2.38001637827     , 2.206389694       ,
 1.97034133987     , 1.74336462014     , 1.59453276148     , 1.54144700143     ,
 1.54606467598     , 1.55162534447     , 1.52503410718     , 1.47660149078     ,
 1.44856163279     , 1.4828677073      , 1.59862874096     , 1.80522616221     ,
 2.13054569862     , 2.60842740987     , 3.21706648904     , 3.84781356491     ,
 4.37803791877     , 4.79534808668     , 5.23113420929     , 5.84816616501     ,
 6.69847552047     , 7.71211816814     , 8.82748227444     , 10.0936099857     ,
 11.603212482      , 13.3458439652     , 15.1830632544     , 16.9690103856     ,
 18.6432757843     , 20.1951331529     , 21.6034341977     , 22.8699891813     ,
 24.0784824618     , 25.3551348499     , 26.7807853498     , 28.381084592      ,
 30.1748063181     , 32.1811810866     , 34.375566189      , 36.6434130303     ,
 38.7872282761     , 40.6313936987     , 42.1656998947     , 43.5659174475     ,
 45.0275162602     , 46.553673927      , 47.8949771908     , 48.6815917169     ,
 48.6045599754     , 47.5075133394     , 45.4046777078     , 42.4996358604     ,
 39.1688744315     , 35.8219299694     , 32.7008762966     , 29.8073997636     ,
 27.0112028716     , 24.1873527749     , 21.2636729619     , 18.2355270797     ,
 15.2065243444     , 12.3824052141     , 9.96504408365     , 8.0335357993      ,
 6.52217991532     , 5.30289779788     , 4.29168597608     , 3.48187955888     ,
 2.8810031642      , 2.44353893559     , 2.08923256961     , 1.76668423799     ,
 1.47084762322     , 1.21197461018     , 0.995061612046    , 0.824505261222    ,
 0.702897777386    , 0.617105461655    , 0.539184628972    , 0.450392762807    ,
 0.358273264846    , 0.283708113872    , 0.235394533758    , 0.203115891745    ,
 0.173478568985    , 0.144633193464    , 0.123429287558    , 0.113325104265    ,
 0.109919289715    , 0.108427733636    , 0.113136211288    , 0.136713664096    ,
 0.188348738687    , 0.263663043748    , 0.35079854787     , 0.450055442199    ,
 0.583070140859    , 0.770877285578    , 0.997091383407    , 1.2019629304      ,
 1.32575875908     , 1.35688400737     , 1.3297875427      , 1.28511823479     ,
 1.24843456332     , 1.24022888471     , 1.28408941962     , 1.40066196956     ,
 1.60436808908     , 1.90764583088     , 2.3237610064      , 2.87199697168     ,
 3.58744233128     , 4.51058965162     , 5.64842976792     , 6.95689730507     ,
 8.37844403623     , 9.881445965       , 11.4413703474     , 12.9919313262     ,
 14.4143103754     , 15.5830023724     , 16.4372190899     , 17.0398416123     ,
 17.5921044524     , 18.3875975864     , 19.7236400378     , 21.8047681008     ,
 24.6745406038     , 28.2318014956     , 32.3424773299     , 36.9289966949     ,
 41.9093203791     , 47.0194510281     , 51.6726124667     , 54.9934234577     ,
 56.0821076256     , 54.4186666421     , 50.1509554564     , 44.0164689801     ,
 30.465095831      , 23.5430965942     , 17.5324895997     , 12.6251824946     ,
 8.87461827733     , 6.1717502858      , 4.29009059954     , 2.99556702416     ,
 2.12222276221     , 1.56910935245     , 1.25396068085     , 1.08379891234     ,
 0.971318923895    , 0.873278061577    , 0.803762642944    , 0.804049277849    ,
 0.896386136566    , 1.062514825       , 1.26083984299     , 1.45924954535     ,
 1.65113632824     , 1.84618405939     , 2.05193926514     , 2.26206394602     ,
 2.45485965292     , 2.60325905267     , 2.69919635496     , 2.77389989326     ,
 2.87291241711     , 2.99008771571     , 3.04409228769     , 2.9515300856      ,
 2.71922882987     , 2.44324762578     , 2.22546509532     , 2.10909917832     ,
 2.07631652517     , 2.07141873385     , 2.02426580956     , 1.88496469412     ,
 1.66249645084     , 1.42729423537     , 1.26159892251     , 1.19886729586     ,
 1.20692962259     , 1.22423835564     , 1.21107371103     , 1.17369611875     ,
 1.15037450318     , 1.1791172542      , 1.27814608824     , 1.45607154723     ,
 1.73329550597     , 2.13594551408     , 2.65687939128     , 3.23286748221     ,
 3.78596549859     , 4.3039838701      , 4.87185684282     , 5.60337983015     ,
 6.53676407968     , 7.61602244051     , 8.79025747907     , 10.1052221292     ,
 11.651591422      , 13.4291929924     , 15.3206449389     , 17.2218934054     ,
 19.1468071574     , 21.1527054281     , 23.1995329517     , 25.1576302535     ,
 26.9482480785     , 28.6159344215     , 30.2742218063     , 32.0405189792     ,
 34.019430459      , 36.2876594118     , 38.8384339411     , 41.508556142      ,
 43.9897656904     , 45.9966940928     , 47.461429992      , 48.5364937737     ,
 49.4009286108     , 50.0737412983     , 50.383663984      , 50.0662421877     ,
 48.8821230472     , 46.7036496986     , 43.5786169419     , 39.7664334124     ,
 35.6949833851     , 31.8044941611     , 28.3579718038     , 25.3677418147     ,
 22.6797415959     , 20.1031021377     , 17.4883136533     , 14.7791280434     ,
 12.0635279218     , 9.55483337905     , 7.46625278998     , 5.87623776956     ,
 4.70227303729     , 3.79119869939     , 3.03698025008     , 2.42244941571     ,
 1.96177233186     , 1.63190537264     , 1.37717164536     , 1.15614089546     ,
 0.957257256657    , 0.781253054289    , 0.631804693366    , 0.518315079106    ,
 0.446974097791    , 0.40458478409     , 0.362914729051    , 0.304210917982    ,
 0.235960047526    , 0.177510825368    , 0.138149038977    , 0.112173799835    ,
 0.0908258531004   , 0.072723250105    , 0.062087037132    , 0.0606132683969   ,
 0.064022321879    , 0.0670769834711   , 0.0711313641301   , 0.0847969934369   ,
 0.115447220101    , 0.160949686422    , 0.213330692924    , 0.273144488637    ,
 0.357039374535    , 0.483693924864    , 0.649587570581    , 0.824544941299    ,
 0.975457292437    , 1.08811583271     , 1.16194633215     , 1.19771532147     ,
 1.20561224247     , 1.21819211979     , 1.28254032292     , 1.44319038346     ,
 1.73675946502     , 2.19244348647     , 2.83044810925     , 3.67427757369     ,
 4.78224304425     , 6.25843057702     , 8.20552760488     , 10.6445017655     ,
 13.4572300026     , 16.3834903968     , 19.0797588354     , 21.2239921138     ,
 22.6193996247     , 23.2544963466     , 23.3115050704     , 23.1292674283     ,
 23.1223349116     , 23.6743177672     , 25.0524632796     , 27.3710600588     ,
 30.5846893811     , 34.5088035        , 38.8865328375     , 43.4571881988     ,
 47.9464889077     , 51.9757614528     , 54.9753830533     , 56.2168470661     ,
 55.0399994926     , 51.2137238574     , 45.1807770603     , 37.9178496866     ,
 24.0581440901     , 17.7640864844     , 12.6640199048     , 8.72265127757     ,
 5.85113543787     , 3.88963206667     , 2.61039273893     , 1.78744919434     ,
 1.26141282027     , 0.944463871332    , 0.779418995729    , 0.703796782441    ,
 0.653972172474    , 0.596155559315    , 0.541717960379    , 0.526504835972    ,
 0.57524975421     , 0.683107962566    , 0.824094733147    , 0.972559464556    ,
 1.11853954672     , 1.26732613719     , 1.42598404557     , 1.58815509429     ,
 1.73094283277     , 1.83161500303     , 1.8951425147      , 1.9622556907      ,
 2.07176362639     , 2.20369113149     , 2.27546368505     , 2.21488759976     ,
 2.03268202873     , 1.81169958901     , 1.63652191419     , 1.54629916112     ,
 1.534318627       , 1.55960420558     , 1.55875933488     , 1.47667789425     ,
 1.30839060424     , 1.10973206779     , 0.956316291303    , 0.885763526435    ,
 0.876860995916    , 0.880439595106    , 0.866039835296    , 0.840790215094    ,
 0.833562738127    , 0.869624831777    , 0.960040433545    , 1.11057905797     ,
 1.33592819726     , 1.65926419778     , 2.09257266806     , 2.61762055607     ,
 3.19554507669     , 3.80768784137     , 4.48868272714     , 5.30759910132     ,
 6.30781619901     , 7.47528242439     , 8.78246047238     , 10.2512374784     ,
 11.9318109822     , 13.8115304491     , 15.7998741743     , 17.8518864204     ,
 20.0651877332     , 22.5668973833     , 25.2992234131     , 27.996386454      ,
 30.4000100384     , 32.4544792456     , 34.301874436      , 36.1567605167     ,
 38.2058269182     , 40.5618825217     , 43.2096398779     , 45.9357504365     ,
 48.3697380393     , 50.1999035682     , 51.3613309222     , 51.9740935264     ,
 52.1336776951     , 51.8096148967     , 50.9012650077     , 49.3104526356     ,
 46.9557599482     , 43.792813993      , 39.8913021046     , 35.5049383824     ,
 31.0399647928     , 26.9093604916     , 23.3635826749     , 20.4192564402     ,
 17.9199340934     , 15.6507928365     , 13.4286608513     , 11.1676968322     ,
 8.9267705424      , 6.88431014874     , 5.22006364918     , 3.99449705104     ,
 3.12792157659     , 2.48067153322     , 1.95355420607     , 1.52395749678     ,
 1.20205886153     , 0.976323259567    , 0.811578081017    , 0.678389843573    ,
 0.56355589172     , 0.461356711921    , 0.371471310343    , 0.301892182943    ,
 0.259815433385    , 0.23741633099     , 0.214767794097    , 0.179046854388    ,
 0.135298497813    , 0.096885257078    , 0.0706441162649   , 0.0538585260004   ,
 0.0416769604605   , 0.0332078507      , 0.0304663056338   , 0.0336834809055   ,
 0.0391739930273   , 0.042479051603    , 0.0436256179613   , 0.0480944165982   ,
 0.0613990503227   , 0.0834231052979   , 0.110330731348    , 0.143344314547    ,
 0.193821557639    , 0.276241424608    , 0.395871606569    , 0.546060389269    ,
 0.715164894954    , 0.886766597855    , 1.03313225016     , 1.12663242682     ,
 1.17099177092     , 1.21423068102     , 1.32643981958     , 1.57462426542     ,
 2.01734617455     , 2.70427162484     , 3.67621020478     , 4.99392773534     ,
 6.80314931739     , 9.37344047098     , 13.0183286696     , 17.8702433979     ,
 23.6191974257     , 29.4355575709     , 34.2322706033     , 37.1467386278     ,
 37.9115378061     , 36.8972959124     , 34.8913569992     , 32.8027779664     ,
 31.4165486825     , 31.2349225971     , 32.4312882214     , 34.9148138958     ,
 38.428221098      , 42.6046842599     , 47.0003047408     , 51.1413898956     ,
 54.5700011278     , 56.849306294      , 57.5356681021     , 56.1926664957     ,
 52.5331722002     , 46.6693654358     , 39.2741913061     , 31.4094115996     ,
 18.2333495197     , 12.7980230014     , 8.68863484681     , 5.69656744244     ,
 3.6247285853      , 2.2802743146      , 1.45595925825     , 0.962536813381    ,
 0.668924166601    , 0.505081892543    , 0.431258154508    , 0.40803324903     ,
 0.394226652735    , 0.36648308469     , 0.331511649891    , 0.314691939039    ,
 0.33688651012     , 0.399782288799    , 0.487695887022    , 0.581199460237    ,
 0.67190701047     , 0.766113895711    , 0.872517983557    , 0.985201776125    ,
 1.08149126292     , 1.1423783165      , 1.17805746991     , 1.22690102352     ,
 1.31689677615     , 1.42476546198     , 1.48443834139     , 1.44601738159     ,
 1.32243435323     , 1.17427980511     , 1.06017127138     , 1.00869982977     ,
 1.0189927338      , 1.06370793568     , 1.09344696181     , 1.06065321454     ,
 0.954838170163    , 0.813903783531    , 0.694336448316    , 0.626622877652    ,
 0.598705371599    , 0.58015423258     , 0.55665129684     , 0.539001439045    ,
 0.546478641022    , 0.590161806667    , 0.67151382458     , 0.791806440086    ,
 0.962610560849    , 1.21004340753     , 1.56667777264     , 2.05137138744     ,
 2.6537084213      , 3.34543421228     , 4.11596747641     , 4.99678280835     ,
 6.04366150965     , 7.29399755604     , 8.75388676082     , 10.4268949752     ,
 12.320792849      , 14.4031153944     , 16.5984467481     , 18.9006608575     ,
 21.4631966817     , 24.4650057399     , 27.8422136708     , 31.2263699835     ,
 34.2033625142     , 36.6132010386     , 38.6040622095     , 40.4647128103     ,
 42.4438769376     , 44.6654143353     , 47.0809739237     , 49.4336701266     ,
 51.3508088067     , 52.5806136439     , 53.1178457106     , 53.0531307149     ,
 52.3713691075     , 50.9694557909     , 48.8137118137     , 45.9896110806     ,
 42.6042503731     , 38.7179796291     , 34.4107080594     , 29.8856430798     ,
 25.4709825193     , 21.5016225113     , 18.1747895894     , 15.4871102164     ,
 13.2843899644     , 11.3639317296     , 9.55767681769     , 7.78439263382     ,
 6.07778874234     , 4.55982623        , 3.35021697367     , 2.48069572601     ,
 1.88497510421     , 1.45776281833     , 1.12278048639     , 0.856085740112    ,
 0.658624680484    , 0.522269825506    , 0.42693341332     , 0.35534260395     ,
 0.297433545895    , 0.246112332263    , 0.198547659909    , 0.159324257665    ,
 0.134391830745    , 0.12104120032     , 0.108554737337    , 0.0893820902277   ,
 0.065826366345    , 0.0450095258321   , 0.030771996837    , 0.0220148826144   ,
 0.0164591161624   , 0.0136202733913   , 0.0142632438716   , 0.0180710453617   ,
 0.0225290698605   , 0.0246581467876   , 0.0241171749858   , 0.0239648703477   ,
 0.0277043941531   , 0.0360944404764   , 0.0480608426884   , 0.065284433781    ,
 0.095200173072    , 0.148692303902    , 0.235766989114    , 0.363931612348    ,
 0.534612962802    , 0.731141995893    , 0.913176895404    , 1.04241891929     ,
 1.12529844455     , 1.22398779901     , 1.4267083077      , 1.82042708953     ,
 2.48824701806     , 3.5147379851      , 5.00218994038     , 7.13401036073     ,
 10.2862757385     , 15.0847182261     , 22.2241901009     , 31.9528837668     ,
 43.4501514163     , 54.6658779014     , 63.0317644078     , 66.7086311285     ,
 65.4667816148     , 60.6151968228     , 54.2157020645     , 48.231222005      ,
 44.018368822      , 42.181229505      , 42.6695416278     , 45.0203694873     ,
 48.6026866421     , 52.7379824184     , 56.7218021366     , 59.8635262577     ,
 61.5790190747     , 61.465271872      , 59.3072916849     , 55.0625117682     ,
 48.8967370575     , 41.2768529882     , 33.0109175151     , 25.073042976      ,
 13.2259816594     , 8.78909342346     , 5.65372357925     , 3.51057941327     ,
 2.10636942211     , 1.24103575518     , 0.740654586034    , 0.462500706419    ,
 0.311121865695    , 0.236044460554    , 0.210809150538    , 0.212304682441    ,
 0.216356506818    , 0.207772263157    , 0.189012114621    , 0.175899906103    ,
 0.184042046988    , 0.217322650754    , 0.266177634786    , 0.316640168053    ,
 0.363306308859    , 0.413216240969    , 0.47457566706     , 0.542043512292    ,
 0.597081376236    , 0.626540290015    , 0.640681261785    , 0.667590369675    ,
 0.723913202422    , 0.79137804463     , 0.828188323397    , 0.806959220985    ,
 0.738797074845    , 0.660250775843    , 0.604782965628    , 0.589183281227    ,
 0.613578341679    , 0.660314292541    , 0.696175052386    , 0.689450661951    ,
 0.633137500222    , 0.550918186608    , 0.476852857208    , 0.427435176958    ,
 0.394045304459    , 0.361871642589    , 0.331108338151    , 0.316287522991    ,
 0.329865976813    , 0.372635865865    , 0.438497687944    , 0.524905359432    ,
 0.642596466622    , 0.823022956793    , 1.11562749171     , 1.56568105149     ,
 2.18316732134     , 2.93427843437     , 3.7759824754      , 4.70994826453     ,
 5.79827089955     , 7.11762188751     , 8.70857892319     , 10.5786625048     ,
 12.7209493268     , 15.091851343      , 17.6119393625     , 20.2744112158     ,
 23.2414483385     , 26.7100269156     , 30.6159586832     , 34.5379388884     ,
 37.9647073709     , 40.6523139702     , 42.7246321174     , 44.4923525871     ,
 46.2261847072     , 48.0444208956     , 49.8726141816     , 51.4449486686     ,
 52.4403141715     , 52.7101818961     , 52.3250792301     , 51.3570917334     ,
 49.7136990702     , 47.2610481144     , 44.0413936663     , 40.2860783531     ,
 36.2383228292     , 32.030839362      , 27.7407767131     , 23.5067523705     ,
 19.5539450504     , 16.1079425877     , 13.2843302842     , 11.0439922784     ,
 9.23921086698     , 7.70083654878     , 6.30232341456     , 4.98774577457     ,
 3.77756835125     , 2.74214233619     , 1.94244276706     , 1.38224418503     ,
 1.00956967457     , 0.754520797976    , 0.566177321423    , 0.42334291591     ,
 0.320079842256    , 0.249103948555    , 0.200097843066    , 0.16514417006     ,
 0.138862677254    , 0.116097915681    , 0.0938592509441   , 0.0739927209239   ,
 0.0602042247489   , 0.0523364065607   , 0.0458786028483   , 0.0371299553479   ,
 0.0266937868882   , 0.0175059752956   , 0.0112539486969   , 0.00756323376066  ,
 0.00553161490953  , 0.00494325215765  , 0.00603638039226  , 0.00851436096809  ,
 0.0110467691229   , 0.0120729665199   , 0.0113095604181   , 0.0101840159697   ,
 0.0105012597299   , 0.0129983930372   , 0.0177842551484   , 0.0264766027197   ,
 0.043945123672    , 0.0784537740729   , 0.141331544735    , 0.24576136697     ,
 0.399059436258    , 0.587834564279    , 0.775184339598    , 0.929970488071    ,
 1.06770623231     , 1.25810716604     , 1.59798870137     , 2.19209489979     ,
 3.16018964004     , 4.65986864908     , 6.94153811146     , 10.4745069939     ,
 16.1195887008     , 25.1656842388     , 38.9074036633     , 57.5981764218     ,
 79.2648265295     , 99.5328640357     , 113.237002671     , 117.035859337     ,
 111.101083399     , 98.682277455      , 84.1840655234     , 71.3091909395     ,
 62.1881580728     , 57.3934809338     , 56.382456119      , 58.0531930978     ,
 61.1951627708     , 64.6900825546     , 67.5315232825     , 68.860891424      ,
 68.0850964057     , 64.9697729488     , 59.6308217965     , 52.465900147      ,
 44.0802506396     , 35.217951546      , 26.6843609664     , 19.2061310379     ,
 9.10868934836     , 5.72344966535     , 3.48054128509     , 2.04134142279     ,
 1.15064569912     , 0.62952334527     , 0.344815445573    , 0.198150560289    ,
 0.126678545715    , 0.0978196396465   , 0.0956506324763   , 0.107518781929    ,
 0.119300667545    , 0.120279754419    , 0.110100823885    , 0.0987555420205   ,
 0.0982918125319   , 0.113254598519    , 0.137830996508    , 0.16239260517     ,
 0.183661550517    , 0.207192336343    , 0.238201211741    , 0.271746115145    ,
 0.29542404873     , 0.302793946789    , 0.302463397026    , 0.311407319681    ,
 0.337683333449    , 0.37031587823     , 0.388149224736    , 0.379258641343    ,
 0.350654247637    , 0.320222982461    , 0.303556319392    , 0.30849380212     ,
 0.334274022357    , 0.36976385151     , 0.395993201457    , 0.3974026067      ,
 0.373561417912    , 0.338886377597    , 0.308836471486    , 0.285784247971    ,
 0.260195777503    , 0.226388303355    , 0.193555320918    , 0.178365213771    ,
 0.189595165433    , 0.223077220618    , 0.269262481242    , 0.323923189766    ,
 0.397782856437    , 0.525320942405    , 0.764751948475    , 1.17689955137     ,
 1.78808793507     , 2.568826881       , 3.46241996086     , 4.45221846681     ,
 5.59781328567     , 6.99268788408     , 8.69950685594     , 10.7424243525     ,
 13.1254989015     , 15.8089082654     , 18.7034163563     , 21.7781398103     ,
 25.1652625563     , 29.0353311772     , 33.3043810819     , 37.5319480972     ,
 41.1789586873     , 43.9642665029     , 45.972982559      , 47.4823292671     ,
 48.7408469579     , 49.8638295951     , 50.7993949354     , 51.3347060528     ,
 51.228368653      , 50.4089343515     , 48.9805462212     , 47.0054175115     ,
 44.3922411332     , 41.064369381      , 37.1553738673     , 32.9671245473     ,
 28.7718319939     , 24.7041725254     , 20.8212784157     , 17.2050130285     ,
 13.9829006893     , 11.2690776699     , 9.09593732836     , 7.39397696275     ,
 6.03245127503     , 4.88408434401     , 3.8657634428      , 2.94721267851     ,
 2.14319909607     , 1.48939758544     , 1.00679347072     , 0.681362634389    ,
 0.47304269677     , 0.338331759978    , 0.246393114161    , 0.181564573595    ,
 0.136396081817    , 0.105118536302    , 0.0829953887472   , 0.0673908349066   ,
 0.056357668503    , 0.0472555567618   , 0.0381227107635   , 0.0294028386913   ,
 0.0228468295971   , 0.0188729547884   , 0.0159819404864   , 0.0126643073269   ,
 0.00890615677233  , 0.00563087169517  , 0.00341926224215  , 0.00216437551563  ,
 0.00156887182859  , 0.00155514206787  , 0.00218604156671  , 0.00331354484823  ,
 0.00439166911961  , 0.00478083506578  , 0.00433902373749  , 0.00361090137963  ,
 0.0033438127587   , 0.0039758732732   , 0.00585808159249  , 0.0101850000654   ,
 0.0200642798538   , 0.0415583076738   , 0.0847830642306   , 0.1630288217      ,
 0.285493242065    , 0.445665224436    , 0.621651626476    , 0.800960650021    ,
 1.01044739611     , 1.32001958743     , 1.82708531298     , 2.65700126313     ,
 3.99139069059     , 6.12558556302     , 9.59230715268     , 15.3900525962     ,
 25.2330606311     , 41.4883850909     , 66.2720533418     , 99.5247831856     ,
 137.05482648      , 170.584125169     , 190.977701513     , 193.002670345     ,
 178.049694068     , 152.816264477     , 125.432722765     , 102.082808522     ,
 85.7456482844     , 76.6359864245     , 73.2811602292     , 73.575180084      ,
 75.5062779574     , 77.4407507134     , 78.1169021159     , 76.6425733873     ,
 72.5898078825     , 66.0474281425     , 57.5406592014     , 47.8753058263     ,
 37.9603274608     , 28.6286297354     , 20.5102273727     , 13.9757754012     ,
 5.89650548675     , 3.50555158543     , 2.01670151792     , 1.11844407491     ,
 0.592739111954    , 0.30019409892     , 0.14893032629     , 0.077082257054    ,
 0.0471685185148   , 0.0407445970173   , 0.049525156422    , 0.0663257931046   ,
 0.0811281725727   , 0.0847959065127   , 0.0759791499268   , 0.0626279087713   ,
 0.0553317265449   , 0.0588634240703   , 0.0697276829333   , 0.0814047229261   ,
 0.0916289194355   , 0.103386059767    , 0.118380278774    , 0.131980452345    ,
 0.137107666231    , 0.132433560762    , 0.124884222804    , 0.123627688571    ,
 0.131777471983    , 0.143775189608    , 0.150750269006    , 0.148495566314    ,
 0.140339839307    , 0.133327729223    , 0.133365785212    , 0.143310819981    ,
 0.161901348245    , 0.182718595753    , 0.196852010706    , 0.199566965321    ,
 0.194611346319    , 0.190518076732    , 0.191096387568    , 0.18972204684     ,
 0.175607071032    , 0.147172228583    , 0.116883322144    , 0.100996660692    ,
 0.106282621346    , 0.127597404205    , 0.155671221698    , 0.186741346312    ,
 0.231258014895    , 0.322434241185    , 0.518213671974    , 0.884818186239    ,
 1.46173554644     , 2.23437201539     , 3.15380159842     , 4.20300935948     ,
 5.43898904227     , 6.9534297792      , 8.80739110091     , 11.026314698      ,
 13.6228678803     , 16.5706517277     , 19.7875797514     , 23.2286089376     ,
 26.978749467      , 31.1365246615     , 35.5582860903     , 39.7923783535     ,
 43.328223666      , 45.9042372118     , 47.579328779      , 48.5706672937     ,
 49.0837079668     , 49.2553444931     , 49.1245650822     , 48.5935153297     ,
 47.496057441      , 45.7609632565     , 43.4457499363     , 40.5989189071     ,
 37.2072902664     , 33.3316620349     , 29.2024528279     , 25.1163548559     ,
 21.2735715681     , 17.7419559514     , 14.5394485647     , 11.7054320322     ,
 9.29612535142     , 7.34110265711     , 5.812898113       , 4.62922214914     ,
 3.68555160787     , 2.89524715693     , 2.20894502004     , 1.61222461382     ,
 1.11475013137     , 0.732062479954    , 0.465298466949    , 0.295065974463    ,
 0.192004725623    , 0.12989152415     , 0.0913077118406   , 0.0665688141032   ,
 0.0502130047401   , 0.0386815733018   , 0.0300501799127   , 0.0237886533039   ,
 0.019511426258    , 0.0162198285546   , 0.0129771770884   , 0.00977119518972  ,
 0.00722407327269  , 0.00561437623192  , 0.00454664773659  , 0.00351347072032  ,
 0.00242072011071  , 0.0014830048446   , 0.000855373000478 , 0.000512003257557 ,
 0.000372357141094 , 0.000414087362522 , 0.000651550698947 , 0.00103344091496  ,
 0.00138549930312  , 0.00150330551243  , 0.00133817636523  , 0.00106568169701  ,
 0.000956816570854 , 0.00125049450758  , 0.00224893073194  , 0.00466301020742  ,
 0.0102429426588   , 0.0229446068314   , 0.0504267950568   , 0.103836806412    ,
 0.193054026907    , 0.319997291942    , 0.481074755473    , 0.684492567303    ,
 0.967553383689    , 1.39795728354     , 2.07405226227     , 3.15241796159     ,
 4.91025064408     , 7.85882215492     , 12.9713391465     , 22.059268356      ,
 38.1080667626     , 64.9871685357     , 105.742378497     , 159.408935083     ,
 218.176071181     , 268.122475186     , 294.976412443     , 291.743289813     ,
 262.383699476     , 218.794335969     , 174.095691443     , 137.366200346     ,
 112.181147591     , 97.8700413227     , 91.5333911557     , 89.7352973664     ,
 89.5354258569     , 88.8321419387     , 86.2779589677     , 81.1619484654     ,
 73.4036691181     , 63.513127547      , 52.4103910353     , 41.1697316967     ,
 30.7671073089     , 21.8796723465     , 14.8111498048     , 9.5543324492      ,
 3.56078828097     , 2.00314996831     , 1.09081732292     , 0.573519004597    ,
 0.287203687618    , 0.135366279456    , 0.0609607212707   , 0.0289130938048   ,
 0.0195100364616   , 0.0242051053002   , 0.0394184440045   , 0.0597504793168   ,
 0.075528022077    , 0.0777896831566   , 0.0658324941488   , 0.0481505139839   ,
 0.0351378339632   , 0.0314097863078   , 0.0346297904451   , 0.0402071695373   ,
 0.046245644813    , 0.0535756574459   , 0.061570259516    , 0.0662150771267   ,
 0.0638454948604   , 0.0556079900791   , 0.0467946348963   , 0.042222050532    ,
 0.0428021291733   , 0.0458722923657   , 0.0480828033378   , 0.0481084703551   ,
 0.0471358339238   , 0.0473900291188   , 0.0506952502747   , 0.0578410129637   ,
 0.0678351912408   , 0.077572087094    , 0.0838235351904   , 0.0866951336819   ,
 0.0905750415897   , 0.100117376738    , 0.113900012789    , 0.122658038977    ,
 0.116560614382    , 0.0956291201521   , 0.0713239811645   , 0.0568832820647   ,
 0.0573012004405   , 0.0684482917999   , 0.0835018814675   , 0.100430253122    ,
 0.128931245546    , 0.197758378746    , 0.358196781348    , 0.673984158396    ,
 1.19380966857     , 1.92478142041     , 2.84394332228     , 3.95342101452     ,
 5.31524632622     , 7.00961966639     , 9.07144304413     , 11.494826985      ,
 14.2745404267     , 17.3955280835     , 20.8077754132     , 24.4790635038     ,
 28.4459198379     , 32.7038890633     , 37.0194545537     , 40.9305283744     ,
 43.9885737785     , 45.9942836954     , 47.0087066358     , 47.2008774354     ,
 46.746399372      , 45.8356037228     , 44.6441616451     , 43.2172910965     ,
 41.4407207569     , 39.1732934274     , 36.3596834923     , 33.0195895473     ,
 29.2447533875     , 25.2516462282     , 21.3471783155     , 17.7770740976     ,
 14.6242417751     , 11.8586422789     , 9.44741584568     , 7.39902394404     ,
 5.7309529718      , 4.42927281061     , 3.43986996236     , 2.6841860308      ,
 2.08506913294     , 1.58833013701     , 1.16701862636     , 0.813789991885    ,
 0.53237067978     , 0.327115774747    , 0.192560464893    , 0.112374495234    ,
 0.067321345268    , 0.0424229211006   , 0.0285286402575   , 0.0205888684116   ,
 0.0157026925876   , 0.0121738444136   , 0.00931894972146  , 0.00713901661791  ,
 0.00566286841016  , 0.00460844862069  , 0.0036329448522   , 0.00266909106312  ,
 0.00187966552552  , 0.00136778899315  , 0.0010500837104   , 0.00078754317125  ,
 0.000531863782256 , 0.000317116867832 , 0.000174767581513 , 9.93983985257e-05 ,
 7.32641577002e-05 , 9.1230528487e-05  , 0.000156140223336 , 0.000254778682747 ,
 0.000343952442975 , 0.000373820103249 , 0.000338302717076 , 0.000308878756743 ,
 0.000440622268044 , 0.000978962032195 , 0.00224331199217  , 0.00456935253201  ,
 0.00852611948438  , 0.0160383440801   , 0.0322882841066   , 0.0664897976468   ,
 0.129557570715    , 0.231048854413    , 0.382352318891    , 0.607649475805    ,
 0.952266764463    , 1.48421957044     , 2.31027450945     , 3.63240835737     ,
 5.85353797024     , 9.76675328437     , 16.9186986644     , 30.1649915247     ,
 54.0683399603     , 94.2180292642     , 154.414891205     , 231.984972248     ,
 314.216994743     , 380.427465145     , 411.008660614     , 398.163798687     ,
 349.986717883     , 284.828310209     , 221.192268932     , 170.674397738     ,
 136.762053087     , 117.327634121     , 107.756179861     , 103.245774019     ,
 100.053923638     , 95.8326934482     , 89.4062597945     , 80.4576041275     ,
 69.3478848423     , 56.9625255677     , 44.4561513424     , 32.9362633663     ,
 23.1925876459     , 15.5595335448     , 9.96201040111     , 6.08970893939     ,
 1.99912551995     , 1.06200814528     , 0.545621571479    , 0.271691534539    ,
 0.129180593735    , 0.0574506327177   , 0.0244163806592   , 0.0124933406801   ,
 0.0131425516538   , 0.0238665253031   , 0.0434497703164   , 0.0663904080365   ,
 0.0819748516583   , 0.0811642902984   , 0.0647280636778   , 0.0426844375307   ,
 0.0255974722705   , 0.0175681202474   , 0.0165343945056   , 0.0188442018236   ,
 0.0226725320628   , 0.0276562905452   , 0.0323973851033   , 0.0339502697466   ,
 0.0305224823362   , 0.0236779590303   , 0.0169714502189   , 0.0129207191704   ,
 0.0116938153934   , 0.0119946722569   , 0.0125347529262   , 0.0128507315373   ,
 0.0132413672632   , 0.01426789447     , 0.0163943550064   , 0.0197787379532   ,
 0.0239207594558   , 0.0276456795002   , 0.030207086515    , 0.0328320675182   ,
 0.0386606426363   , 0.0499010283792   , 0.0639946904872   , 0.0733128837378   ,
 0.0708749839644   , 0.0572507510044   , 0.040671526425    , 0.0299835211133   ,
 0.0283260668199   , 0.0331053979118   , 0.0404177733072   , 0.050074632047    ,
 0.0706278600378   , 0.125319734291    , 0.256574040135    , 0.521973552113    ,
 0.976361505132    , 1.65085397644     , 2.55763113756     , 3.72732899444     ,
 5.22839436197     , 7.12285812171     , 9.40844734923     , 12.031522301      ,
 14.9489922156     , 18.1464820276     , 21.6121655329     , 25.3365884472     ,
 29.307436426      , 33.4137139302     , 37.3389383133     , 40.626298327      ,
 42.9058746437     , 44.0596426112     , 44.1780216822     , 43.4157600297     ,
 41.9480048177     , 40.0300013885     , 37.9634729163     , 35.9138798166     ,
 33.7981414334     , 31.3939480493     , 28.5289965453     , 25.1838408292     ,
 21.5200008183     , 17.8504012801     , 14.5072644258     , 11.6724765914     ,
 9.32923674635     , 7.36733070355     , 5.70901030282     , 4.33997990454     ,
 3.26303289841     , 2.45485313432     , 1.8619765695      , 1.41988645537     ,
 1.07431722218     , 0.792678587883    , 0.560853005866    , 0.374152953864    ,
 0.231860408246    , 0.132991427231    , 0.0718300514814   , 0.037929971603    ,
 0.0204850976844   , 0.0117806229177   , 0.00746807257635  , 0.00530917713817  ,
 0.00410174728758  , 0.0032103901291   , 0.00242530801879  , 0.00179067234324  ,
 0.00135833113511  , 0.00106927734963  , 0.00082526338252  , 0.000591735789095 ,
 0.000398507803767 , 0.000271397561377 , 0.00019612143833  , 0.000141933078959 ,
 9.38809225843e-05 , 5.46618804025e-05 , 2.89504305037e-05 , 1.57265032134e-05 ,
 1.18320883244e-05 , 1.63281771595e-05 , 2.96967224648e-05 , 4.93786307455e-05 ,
 6.74073898093e-05 , 7.71081907106e-05 , 9.39631862522e-05 , 0.000200711794377 ,
 0.000632612690289 , 0.00185163899159  , 0.0043922102396   , 0.0083362036312   ,
 0.0130338551596   , 0.0183495227691   , 0.0274700582455   , 0.0488715074203   ,
 0.0954116946973   , 0.182901975162    , 0.333048168136    , 0.580092300291    ,
 0.974182083334    , 1.58548265733     , 2.53516347403     , 4.07910806652     ,
 6.75862271134     , 11.6722184272     , 20.9813114948     , 38.6304940006     ,
 70.734241372      , 124.362062581     , 203.510909597     , 303.072358498     ,
 405.043854274     , 482.472889406     , 511.84283048      , 486.23040583      ,
 418.81722783      , 334.152553138     , 254.961713929     , 194.021238777     ,
 153.817805709     , 130.480887112     , 117.889591654     , 110.314851457     ,
 103.661915564     , 95.6946033324     , 85.640804328      , 73.6594025849     ,
 60.4751469508     , 47.1432545731     , 34.7885413109     , 24.305529477      ,
 16.1351471582     , 10.2292152729     , 6.21073757993     , 3.60646101924     ,
 1.04230071882     , 0.521036626009    , 0.250467430847    , 0.117137289881    ,
 0.0529146073954   , 0.0229088189686   , 0.0107575330476   , 0.008893099297    ,
 0.0146521459746   , 0.0282740466431   , 0.0493333006567   , 0.0721916722582   ,
 0.0859695981454   , 0.0822198510556   , 0.0629481892549   , 0.038928307375    ,
 0.0203573248842   , 0.0106136951638   , 0.00756650971304  , 0.00798371237986  ,
 0.0100584291683   , 0.0130215734939   , 0.0156861004806   , 0.0163052355861   ,
 0.0140629701788   , 0.0100374085008   , 0.00620248773047  , 0.00378696734782  ,
 0.00278674883176  , 0.00258957197097  , 0.00266888375074  , 0.00282654065749  ,
 0.00310022003529  , 0.00360085333342  , 0.00442729468508  , 0.00560082464374  ,
 0.00694735725863  , 0.00814601292334  , 0.00920881019824  , 0.0110772224647   ,
 0.0154389866616   , 0.0231711701839   , 0.0323429526247   , 0.0383153060123   ,
 0.0371913616518   , 0.0295687832001   , 0.0201943372903   , 0.0138692575964   ,
 0.0121967906067   , 0.0138666840086   , 0.0172103550137   , 0.0231813998396   ,
 0.0388633929655   , 0.0824029899906   , 0.188317581083    , 0.408523144015    ,
 0.803638411221    , 1.42849761582     , 2.32908324555     , 3.55671207925     ,
 5.17063128752     , 7.20382890007     , 9.62572149092     , 12.358074378      ,
 15.3339855538     , 18.5299794953     , 21.9440614519     , 25.5591677221     ,
 29.3038143284     , 32.9857665947     , 36.2538437519     , 38.6943219138     ,
 40.028119571      , 40.2220118069     , 39.4123523374     , 37.7691945474     ,
 35.484764332      , 32.8543770244     , 30.238837537      , 27.8600263677     ,
 25.6573945884     , 23.3790718847     , 20.7976565025     , 17.8638401245     ,
 14.7429540194     , 11.7430378479     , 9.15438990799     , 7.09824889776     ,
 5.50810152886     , 4.24221099948     , 3.20167734996     , 2.35803412214     ,
 1.70989800675     , 1.2405373974      , 0.910752156696    , 0.674354942287    ,
 0.495028785903    , 0.353031914777    , 0.240495143248    , 0.153890468445    ,
 0.090812765214    , 0.0488827996756   , 0.0242327631665   , 0.0114675152952   ,
 0.00547178554076  , 0.00279866984268  , 0.00163449888994  , 0.00113062028611  ,
 0.00088166087941  , 0.00069658488279  , 0.00052011207465  , 0.000369867168204 ,
 0.000266360065897 , 0.000200727290323 , 0.000150724223598 , 0.000105490615693 ,
 6.82826297769e-05 , 4.3648983184e-05  , 2.95375422772e-05 , 2.04937370753e-05 ,
 1.32478681335e-05 , 7.54939943975e-06 , 3.86270817644e-06 , 2.01469163598e-06 ,
 1.55341645034e-06 , 2.34278232959e-06 , 4.45681707128e-06 , 7.58942280402e-06 ,
 1.13215471692e-05 , 2.03470060056e-05 , 6.84293091666e-05 , 0.000297092625701 ,
 0.0011245741221   , 0.0033880778518   , 0.00801640823862  , 0.0149118694069   ,
 0.0220738186368   , 0.0271784841149   , 0.0317768383638   , 0.0445434054851   ,
 0.0809502307006   , 0.162250213057    , 0.317817245409    , 0.588388742439    ,
 1.02569594513     , 1.69972674758     , 2.7441368019      , 4.46430764384     ,
 7.52514977145     , 13.2882581594     , 24.4219690794     , 45.709365648      ,
 84.3157697324     , 148.004953754     , 240.14760293      , 352.992213784     ,
 464.39314632      , 543.729771139     , 566.58029199      , 528.624961321     ,
 447.585615874     , 351.852751675     , 265.632840428     , 200.986509267     ,
 158.741596346     , 133.593923924     , 118.700721638     , 108.242143974     ,
 98.4082697898     , 87.4253103613     , 75.0081488298     , 61.6741134855     ,
 48.2749592528     , 35.7598690712     , 24.9811897698     , 16.4748573327     ,
 10.3213033733     , 6.19559416044     , 3.57900889746     , 1.9810804158      ,
 0.503020779934    , 0.236027383429    , 0.105101548571    , 0.0455296787638   ,
 0.0196573376031   , 0.00939569422688  , 0.00744697530449  , 0.0111523614605   ,
 0.0197965855887   , 0.0335914282707   , 0.0518720104221   , 0.0700378448318   ,
 0.0794336499257   , 0.0735758814076   , 0.0548455216746   , 0.032793388959    ,
 0.0159719362239   , 0.00687528842336  , 0.00347647599258  , 0.00300212071016  ,
 0.00382994511384  , 0.00522211599857  , 0.00646781102309  , 0.00674040699776  ,
 0.00571136206865  , 0.00390392685104  , 0.00219725569838  , 0.00110792870549  ,
 0.000618151087512 , 0.000473246708938 , 0.000466082108081 , 0.00051176751992  ,
 0.000601953068829 , 0.000752541900292 , 0.000981454266937 , 0.0012906710418   ,
 0.00163863454573  , 0.00197399240312  , 0.00240715017471  , 0.00341051094542  ,
 0.00570821040237  , 0.00958533219689  , 0.0140202087141   , 0.0168142636865   ,
 0.0162406620387   , 0.0126947807843   , 0.00837942754101  , 0.00539966284426  ,
 0.00441347184837  , 0.00489863761199  , 0.00640584285442  , 0.0101909401783   ,
 0.0216970980253   , 0.0548563898537   , 0.138205141471    , 0.320111162725    ,
 0.667837143707    , 1.25770520728     , 2.16096020784     , 3.43135719661     ,
 5.0950630597      , 7.14439157933     , 9.54105858129     , 12.2310662287     ,
 15.1649897597     , 18.3054291458     , 21.6063106464     , 24.9812463388     ,
 28.2836168437     , 31.2869733904     , 33.6797270277     , 35.1432470264     ,
 35.5039399698     , 34.8105030777     , 33.2467122006     , 31.0056303018     ,
 28.2892178921     , 25.3830077864     , 22.6184937035     , 20.1990651966     ,
 18.0829480843     , 16.0588336205     , 13.9273288306     , 11.6341050474     ,
 9.29609565869     , 7.13292702637     , 5.34107258348     , 3.98744662816     ,
 3.00082389606     , 2.25559533282     , 1.66072219757     , 1.1843796935      ,
 0.823632399567    , 0.569929088668    , 0.399750606544    , 0.284273830661    ,
 0.201064788272    , 0.138161371753    , 0.0906347458007   , 0.0558303882505   ,
 0.0316008327741   , 0.016120019887    , 0.00739885639079  , 0.00314031706463  ,
 0.0013055356816   , 0.000577053590285 , 0.00030025604636  , 0.000197573653128 ,
 0.000154085096388 , 0.000122574322443 , 9.05718175915e-05 , 6.21550513228e-05 ,
 4.23553742463e-05 , 3.02990095532e-05 , 2.19957598938e-05 , 1.50200714248e-05 ,
 9.39129529515e-06 , 5.66383783601e-06 , 3.57919643061e-06 , 2.36465185866e-06 ,
 1.48879920599e-06 , 8.31249280365e-07 , 4.1275494454e-07  , 2.07753620931e-07 ,
 1.64402178295e-07 , 2.67635728201e-07 , 5.35855154659e-07 , 1.05485698138e-06 ,
 2.92556802018e-06 , 1.5038464391e-05  , 8.72544371265e-05 , 0.000424536060569 ,
 0.00163439985896  , 0.004933645137    , 0.0116593702101   , 0.0215912910407   ,
 0.0315239264558   , 0.0372025794601   , 0.0388400221055   , 0.0454070254526   ,
 0.0745171142442   , 0.151636962517    , 0.312197780143    , 0.602066877568    ,
 1.07323036461     , 1.79253182531     , 2.89865364983     , 4.72871967352     ,
 8.02656769199     , 14.3036490608     , 26.4713568842     , 49.6162373009     ,
 91.061150733      , 158.153617784     , 252.904031656     , 365.527582938     ,
 472.35830753      , 543.180050976     , 556.221795116     , 510.686672477     ,
 426.593609787     , 332.264931102     , 249.985032831     , 189.442678727     ,
 149.806211396     , 125.231689249     , 109.23951109      , 96.8047104222     ,
 84.9411125758     , 72.5183030164     , 59.6379458098     , 46.9255127586     ,
 35.0894546555     , 24.7648348499     , 16.422274707      , 10.2447280635     ,
 6.06453362478     , 3.45036652959     , 1.8999731378      , 1.00536580538     ,
 0.222515834442    , 0.098069516221    , 0.0402365477826   , 0.0160334380238   ,
 0.00711556039513  , 0.00552596631493  , 0.00890036236987  , 0.0165308752623   ,
 0.0272224692864   , 0.0392834110481   , 0.0511826052116   , 0.0605569898138   ,
 0.0631953556864   , 0.0558494411916   , 0.0405180854568   , 0.0237288609116   ,
 0.0111906403449   , 0.00437717047591  , 0.00167504902141  , 0.00102964155604  ,
 0.00122261567543  , 0.00172119355542  , 0.00218078883581  , 0.0022866477668   ,
 0.00192666975851  , 0.00129271582358  , 0.000695198278523 , 0.000312080228677 ,
 0.00013515017709  , 7.70115389344e-05 , 6.75575301827e-05 , 7.62643344606e-05 ,
 9.62652746053e-05 , 0.000128637795013 , 0.00017615393727  , 0.000239211657182 ,
 0.000311819229084 , 0.000395834413975 , 0.000552851006713 , 0.000962658162996 ,
 0.00187767963338  , 0.00337259631687  , 0.00503592377366  , 0.00604306696297  ,
 0.00578354569924  , 0.00444477524616  , 0.00284621864447  , 0.00173087757951  ,
 0.00131691994536  , 0.00145109762101  , 0.00214783848884  , 0.00447031328248  ,
 0.0123387887981   , 0.0363577170996   , 0.100515746048    , 0.250584648497    ,
 0.558909389239    , 1.11688062414     , 2.00921414716     , 3.27828519331     ,
 4.90750438466     , 6.84957986897     , 9.07650784462     , 11.5928209197     ,
 14.3971793858     , 17.4325086796     , 20.5591378845     , 23.5691991387     ,
 26.2393495952     , 28.3654435801     , 29.7481097046     , 30.2099503018     ,
 29.6934595486     , 28.3192538305     , 26.3037762485     , 23.8479526798     ,
 21.1383284759     , 18.4022570898     , 15.8754218396     , 13.6892991442     ,
 11.8132467356     , 10.1157984502     , 8.47631291056     , 6.85746835216     ,
 5.31349269958     , 3.95016739022     , 2.85941211707     , 2.06344222881     ,
 1.50795809523     , 1.10710141132     , 0.796232754219    , 0.549980567043    ,
 0.36532377568     , 0.238631338101    , 0.157568116196    , 0.106199492473    ,
 0.0719517668177   , 0.047845343765    , 0.0306370096718   , 0.018512056707    ,
 0.0102473260912   , 0.00503905072984  , 0.00216827638397  , 0.000827669376992 ,
 0.00029494944474  , 0.000108097320228 , 4.73887589204e-05 , 2.84626726608e-05 ,
 2.18234765706e-05 , 1.73806974113e-05 , 1.2705519773e-05  , 8.43299737132e-06 ,
 5.43322995941e-06 , 3.66414818024e-06 , 2.55462964675e-06 , 1.69963485981e-06 ,
 1.03086101877e-06 , 5.90239170362e-07 , 3.48219593229e-07 , 2.17635454279e-07 ,
 1.32853505559e-07 , 7.26742689793e-08 , 3.51512088826e-08 , 1.71557905283e-08 ,
 1.39593525636e-08 , 2.49141679537e-08 , 6.31018742649e-08 , 2.7525727742e-07  ,
 2.07189990103e-06 , 1.57574109933e-05 , 9.81199999642e-05 , 0.000482238912656 ,
 0.00185923330072  , 0.00561397321413  , 0.0132691553912   , 0.024570960728    ,
 0.035823286475    , 0.0419395776277   , 0.0423982484289   , 0.0457901051188   ,
 0.0698003401774   , 0.141063004703    , 0.298101493936    , 0.590950559714    ,
 1.0739353435      , 1.81277408915     , 2.94517912622     , 4.81446942636     ,
 8.17634208115     , 14.531573577      , 26.6840427005     , 49.3699534797     ,
 89.1006186299     , 151.819458739     , 237.900316448     , 336.844303952     ,
 426.639943683     , 481.4303296       , 484.717074216     , 438.869183524     ,
 363.115411097     , 281.836259064     , 212.732105461     , 162.375241943     ,
 128.89777066      , 106.984574174     , 91.4230364676     , 78.5303135628     ,
 66.3562450695     , 54.3666627878     , 42.8475377121     , 32.3015225223     ,
 23.1337773662     , 15.6115065217     , 9.86582882572     , 5.84049954848     ,
 3.27095242917     , 1.76214548559     , 0.92341783509     , 0.466959814079    ,
 0.0886859717058   , 0.0368324865854   , 0.0139910344543   , 0.00529820299954  ,
 0.00320560285567  , 0.00527002138876  , 0.0116313912496   , 0.0221329400468   ,
 0.0342519567465   , 0.0439332466429   , 0.0486707323296   , 0.0485770935746   ,
 0.0442830963048   , 0.0359394968354   , 0.0248957563372   , 0.0142264525086   ,
 0.00658400837429  , 0.0024723310776   , 0.000809171427509 , 0.000340880868582 ,
 0.000327556217281 , 0.000459258508641 , 0.000590794483431 , 0.000623254149699 ,
 0.00052470887384  , 0.000349555098704 , 0.000184367527007 , 7.82630302452e-05 ,
 2.87969561099e-05 , 1.19140917413e-05 , 8.32952072361e-06 , 9.35393363822e-06 ,
 1.25772350029e-05 , 1.77865774235e-05 , 2.5339998311e-05  , 3.54204629404e-05 ,
 4.79301500333e-05 , 6.69331467483e-05 , 0.000114003567087 , 0.000242894475425 ,
 0.000525048037553 , 0.000976021241065 , 0.00146691946917  , 0.00175231531839  ,
 0.00165983790816  , 0.00125558339091  , 0.000782736850666 , 0.000451881318591 ,
 0.00032317853065  , 0.00037568347346  , 0.000734372773282 , 0.00218922249493  ,
 0.00756365009247  , 0.0250480336426   , 0.0748450525757   , 0.198929996567    ,
 0.468693513751    , 0.978448823959    , 1.81366477418     , 3.00427341117     ,
 4.50715488728     , 6.25601606135     , 8.24005062116     , 10.5154543435     ,
 13.1198654493     , 15.9665079648     , 18.8100013644     , 21.3222999775     ,
 23.2335081197     , 24.4089614555     , 24.7986019151     , 24.3794125702     ,
 23.2013717731     , 21.4349826498     , 19.3036079539     , 16.9912780656     ,
 14.6434240611     , 12.4031785803     , 10.3894632631     , 8.64774955527     ,
 7.14870319802     , 5.83480246858     , 4.6636455055      , 3.6213272725      ,
 2.71641343201     , 1.96877296114     , 1.39393155936     , 0.984773982934    ,
 0.705682226416    , 0.508774535754    , 0.358029504262    , 0.239135436798    ,
 0.15087289613     , 0.0920576431226   , 0.0566026378799   , 0.0363277681443   ,
 0.0246424703401   , 0.0174759593189   , 0.0124843443385   , 0.0084402840278   ,
 0.0050563642873   , 0.00255948845443  , 0.00106891266144  , 0.000367795779659 ,
 0.000107190608597 , 2.90851897959e-05 , 9.51499383132e-06 , 5.07203819281e-06 ,
 3.74008418059e-06 , 2.77837266493e-06 , 1.84005972381e-06 , 1.08527373744e-06 ,
 6.12952302456e-07 , 3.67378873096e-07 , 2.38100229825e-07 , 1.52693906317e-07 ,
 8.99337092484e-08 , 4.91856832092e-08 , 2.71436078368e-08 , 1.59577346362e-08 ,
 9.39355253958e-09 , 5.0288345998e-09  , 2.37611812303e-09 , 1.13049692525e-09 ,
 9.76694675864e-10 , 2.51506639437e-09 , 1.68027468514e-08 , 1.77542151004e-07 ,
 1.7474438633e-06  , 1.38821045725e-05 , 8.69728366479e-05 , 0.000427870824109 ,
 0.00165037504623  , 0.00498720964616  , 0.0118078519053   , 0.0219484927942   ,
 0.0322725305178   , 0.0384723456183   , 0.0401607323693   , 0.0445723222512   ,
 0.0665539499929   , 0.129576956594    , 0.270740906986    , 0.542444055451    ,
 1.00506885096     , 1.72978508452     , 2.85180423597     , 4.69495538398     ,
 7.95512988722     , 13.9632630426     , 25.0987610494     , 45.2135810753     ,
 79.3274279554     , 131.494634153     , 200.745638582     , 277.387304847     ,
 343.554901897     , 380.065142285     , 376.429834545     , 336.826197474     ,
 277.110776225     , 215.45213605      , 163.999408186     , 126.482076934     ,
 100.820384826     , 82.9591237051     , 69.3229898616     , 57.6221047609     ,
 46.8117956014     , 36.7550340645     , 27.7396315826     , 20.0450907653     ,
 13.7773278237     , 8.92106032985     , 5.39608703278     , 3.04317088256     ,
 1.61456693609     , 0.821212727253    , 0.407020349148    , 0.195637465131    ,
 0.031208870432    , 0.0122452524059   , 0.00438273426727  , 0.00180494459319  ,
 0.00213097404006  , 0.00542808596169  , 0.0128609797328   , 0.024338653087    ,
 0.036476533254    , 0.0438671872799   , 0.0435130787419   , 0.0371600479847   ,
 0.0286059850948   , 0.0202344435683   , 0.0128501321866   , 0.00701183226746  ,
 0.00316881043281  , 0.00116440732597  , 0.000354883187391 , 0.000112048590546 ,
 7.53750941772e-05 , 9.87993502314e-05 , 0.000127690882677 , 0.000135323306801 ,
 0.000114008400836 , 7.57642879765e-05 , 3.9651020042e-05  , 1.64345496857e-05 ,
 5.57239374977e-06 , 1.80585832541e-06 , 9.09862934038e-07 , 9.45557424512e-07 ,
 1.3314382476e-06  , 1.97132749639e-06 , 2.9019073777e-06  , 4.18236762624e-06 ,
 6.01415717918e-06 , 9.81494919595e-06 , 2.11015781877e-05 , 5.2588585739e-05  ,
 0.000120573000215 , 0.000227594642463 , 0.000342070298649 , 0.000406119973517 ,
 0.000380923497893 , 0.000284137146608 , 0.000173097097241 , 9.58779796458e-05 ,
 6.88978211624e-05 , 0.000111599064537 , 0.000374133087229 , 0.0015257472864   ,
 0.00586723141448  , 0.0201004471547   , 0.0610370998279   , 0.164404915369    ,
 0.392248792302    , 0.827600918631    , 1.54573732058     , 2.57165033423     ,
 3.86472164922     , 5.36707772685     , 7.08058957658     , 9.07589992721     ,
 11.3927750436     , 13.9115710623     , 16.3195983075     , 18.2311591238     ,
 19.3836421846     , 19.7291258442     , 19.3476800456     , 18.3360958754     ,
 16.8160492075     , 14.9745647167     , 13.0156298779     , 11.0887637437     ,
 9.28772204544     , 7.67432105867     , 6.2712986941      , 5.05858118491     ,
 4.00336159355     , 3.0913252044      , 2.32646816074     , 1.71120792844     ,
 1.23452388934     , 0.87673857766     , 0.618224667212    , 0.439605833274    ,
 0.317898130094    , 0.229567633761    , 0.159091450898    , 0.102224092643    ,
 0.0604765935564   , 0.0340650946073   , 0.0199846984296   , 0.0140976349122   ,
 0.0128655420824   , 0.0133449844766   , 0.0130793781006   , 0.0108842980425   ,
 0.00735264329198  , 0.00396359987092  , 0.00169596159313  , 0.00057745103536  ,
 0.000160500774026 , 4.26011239117e-05 , 1.80410338264e-05 , 1.37528532285e-05 ,
 1.09063804933e-05 , 7.14451700189e-06 , 3.71723420263e-06 , 1.53203392081e-06 ,
 5.06555361249e-07 , 1.41544979531e-07 , 3.93723861294e-08 , 1.41390542437e-08 ,
 6.60030275486e-09 , 3.29981714558e-09 , 1.69403701694e-09 , 9.31554112532e-10 ,
 5.25524657686e-10 , 2.74742029433e-10 , 1.270866796e-10   , 6.00446918908e-11 ,
 7.74547330357e-11 , 6.61030896197e-10 , 9.43118920664e-09 , 1.19097972269e-07 ,
 1.20405565593e-06 , 9.60135544205e-06 , 6.01974050761e-05 , 0.000296321209922 ,
 0.00114429912137  , 0.00346684555292  , 0.00825575826319  , 0.015547184971    ,
 0.0235397113154   , 0.0298840801793   , 0.0349543679189   , 0.0438669768058   ,
 0.066392072228    , 0.119416843362    , 0.234574257289    , 0.463728899726    ,
 0.87417452346     , 1.54667623409     , 2.61350895783     , 4.35973340382     ,
 7.36754036263     , 12.6919679176     , 22.1094214197     , 38.3434715049     ,
 64.7219519975     , 103.50548897      , 153.023940344     , 205.513455711     ,
 248.290230773     , 269.019547652     , 262.245302892     , 232.383629918     ,
 190.753813727     , 149.145714868     , 114.808822626     , 89.4962171665     ,
 71.5080698178     , 58.2139993087     , 47.5123129252     , 38.1944412239     ,
 29.8114403059     , 22.4028362361     , 16.1647864432     , 11.1835823674     ,
 7.37841530225     , 4.59339169604     , 2.66853338823     , 1.43909372145     ,
 0.724553599167    , 0.346755818389    , 0.161055645562    , 0.0727971063005   ,
 0.00953989846196  , 0.00353109888284  , 0.00123377120034  , 0.000721767060749 ,
 0.00160799458778  , 0.0047099089807   , 0.0113024574278   , 0.0212827066802   ,
 0.0314384826365   , 0.0366766023969   , 0.0342807086597   , 0.0263812799788   ,
 0.017461521937    , 0.010440383145    , 0.00577113322082  , 0.002884431813    ,
 0.00124474009174  , 0.000446206519494 , 0.000131310769913 , 3.50502302097e-05 ,
 1.55317116069e-05 , 1.71996551492e-05 , 2.19621405234e-05 , 2.33259659048e-05 ,
 1.96702321906e-05 , 1.30627782734e-05 , 6.8158863783e-06  , 2.79786792011e-06 ,
 9.15260491814e-07 , 2.57693617567e-07 , 9.221159983e-08   , 7.92224585507e-08 ,
 1.13382992623e-07 , 1.73939741133e-07 , 2.63586056897e-07 , 3.95255437193e-07 ,
 6.2942463529e-07  , 1.27764464263e-06 , 3.4146614484e-06  , 9.41742506396e-06 ,
 2.2257747267e-05  , 4.22546007618e-05 , 6.33482428028e-05 , 7.47522214759e-05 ,
 6.95111169833e-05 , 5.12377982136e-05 , 3.06838752994e-05 , 1.7209092441e-05  ,
 1.91954562483e-05 , 7.41414871174e-05 , 0.00037014282071  , 0.00162876485699  ,
 0.00608708573763  , 0.0196322724249   , 0.0558469516103   , 0.142145636668    ,
 0.325121474989    , 0.667407251597    , 1.22855770618     , 2.03536594506     ,
 3.06809678329     , 4.29041327018     , 5.70450125907     , 7.3595584358      ,
 9.27000827845     , 11.3014744536     , 13.1444333217     , 14.4414699684     ,
 14.9834891661     , 14.7896004835     , 14.0073187851     , 12.7874810144     ,
 11.2730625492     , 9.6331358777      , 8.0341411297      , 6.58753529485     ,
 5.34362349683     , 4.30765598718     , 3.4470748241      , 2.71086799555     ,
 2.06497327387     , 1.50936681178     , 1.06156469493     , 0.729598388893    ,
 0.50087824945     , 0.350393772469    , 0.253609471001    , 0.191236796639    ,
 0.147596432671    , 0.111033294018    , 0.0769554268819   , 0.0473809207904   ,
 0.0259213025294   , 0.0136511012564   , 0.00916583498984  , 0.0104660126057   ,
 0.0154008811648   , 0.0208489839739   , 0.0231685129783   , 0.0205396440781   ,
 0.0144239470739   , 0.00801516352574  , 0.00353160622846  , 0.00124693339119  ,
 0.000376284447639 , 0.00013413654778  , 9.17462727258e-05 , 8.48501861369e-05 ,
 6.94416122252e-05 , 4.54757405366e-05 , 2.34498437123e-05 , 9.48943882822e-06 ,
 3.00940482958e-06 , 7.47514905439e-07 , 1.45668406797e-07 , 2.25261702047e-08 ,
 2.93191757418e-09 , 4.1128587422e-10  , 1.01307335883e-10 , 4.42199669355e-11 ,
 2.32857048739e-11 , 1.18314632923e-11 , 5.37716604658e-12 , 3.0084532943e-12  ,
 1.69510345822e-11 , 3.10225306889e-10 , 4.99558524908e-09 , 6.41374202019e-08 ,
 6.49956904581e-07 , 5.1862406334e-06  , 3.25426666792e-05 , 0.000160466841051 ,
 0.000622016629389 , 0.00190020610961  , 0.0046079318661   , 0.00902296873046  ,
 0.0147958271947   , 0.021682035084    , 0.0308294441801   , 0.0449619434784   ,
 0.068237283449    , 0.110124762485    , 0.19502633314     , 0.370718258541    ,
 0.70657634929     , 1.2888675648      , 2.24317731336     , 3.8062421022      ,
 6.42513118873     , 10.8516348088     , 18.2504711645     , 30.2783809808     ,
 48.7944150856     , 74.7360751989     , 106.368126073     , 138.255719874     ,
 162.503614738     , 172.258238658     , 165.348780691     , 145.366011791     ,
 119.359351016     , 94.040702916      , 73.2116502909     , 57.5507081721     ,
 45.9409073681     , 36.912637033      , 29.4010869136     , 22.8647896988     ,
 17.1519899465     , 12.3278105647     , 8.48504162181     , 5.6025758758      ,
 3.53882226973     , 2.11637724677     , 1.18242712849     , 0.611467562633    ,
 0.292848715463    , 0.131657416766    , 0.0567972888304   , 0.0238047307695   ,
 0.00251663111712  , 0.000872795334386 , 0.00031909413446  , 0.000337011996581 ,
 0.00106512243916  , 0.0032383750127   , 0.00778719136033  , 0.0146259740347   ,
 0.0214704871493   , 0.0247129034787   , 0.0224574632532   , 0.01634297823     ,
 0.00978930744068  , 0.00504809326728  , 0.00236040078348  , 0.00102661698704  ,
 0.000405876732679 , 0.000138939440806 , 3.96736126918e-05 , 9.69699039555e-06 ,
 2.98331097564e-06 , 2.45447538342e-06 , 3.00508937375e-06 , 3.1871305139e-06  ,
 2.68926477769e-06 , 1.78574567979e-06 , 9.30729124471e-07 , 3.80599448196e-07 ,
 1.22675972188e-07 , 3.22685186754e-08 , 8.84081570854e-09 , 5.57818542113e-09 ,
 7.72760493355e-09 , 1.21613459988e-08 , 1.89797122154e-08 , 3.02311918898e-08 ,
 5.66138596143e-08 , 1.47759017186e-07 , 4.65669198186e-07 , 1.36056373312e-06 ,
 3.26267607108e-06 , 6.20194982534e-06 , 9.26837088768e-06 , 1.08778682933e-05 ,
 1.00423545401e-05 , 7.33732817077e-06 , 4.43766319527e-06 , 3.65396389568e-06 ,
 1.3752338358e-05  , 8.53416971316e-05 , 0.00045192789358  , 0.00194194304569  ,
 0.00686309627713  , 0.02046992265     , 0.05314594763     , 0.123580915431    ,
 0.26217156549     , 0.510935171477    , 0.914713141395    , 1.50321864934     ,
 2.27592779979     , 3.21063619278     , 4.29593844902     , 5.54510170308     ,
 6.94858439035     , 8.39222565873     , 9.63467378738     , 10.4071499541     ,
 10.5684319086     , 10.163637628      , 9.34001934265     , 8.24209462409     ,
 6.9941585806      , 5.72548737709     , 4.55749889535     , 3.56817721248     ,
 2.78122829315     , 2.17629594831     , 1.70435998858     , 1.31242102788     ,
 0.970156872901    , 0.677006606212    , 0.446223560834    , 0.284506238694    ,
 0.18413834576     , 0.128497298355    , 0.100615040412    , 0.0866274065334   ,
 0.0756494522167   , 0.0611615183722   , 0.0429975791897   , 0.0255642228489   ,
 0.0131233172468   , 0.00713940595926  , 0.00727510642903  , 0.0129553713073   ,
 0.0227695156587   , 0.0328519715695   , 0.0377394161005   , 0.0343598628295   ,
 0.0247945935807   , 0.0142045717428   , 0.00649142989622  , 0.00242386889318  ,
 0.000852309466472 , 0.000453172996213 , 0.000426880636771 , 0.000425753968648 ,
 0.000352277093875 , 0.000231027496899 , 0.000119142423107 , 4.8205343817e-05  ,
 1.52810007769e-05 , 3.79102541903e-06 , 7.35384415026e-07 , 1.11463566238e-07 ,
 1.31999674383e-08 , 1.22462369694e-09 , 9.10107773836e-11 , 6.52190616297e-12 ,
 1.02812441912e-12 , 4.08452452788e-13 , 1.85453531362e-13 , 3.19591157648e-13 ,
 6.32787392491e-12 , 1.29161742027e-10 , 2.10224999644e-09 , 2.7033222152e-08  ,
 2.74142947246e-07 , 2.19008844994e-06 , 1.37777626842e-05 , 6.83206885137e-05 ,
 0.000268080241843 , 0.000840548182085 , 0.00215048912028  , 0.0046648845504   ,
 0.00905849193552  , 0.0165054535027   , 0.0284753446158   , 0.0455800892286   ,
 0.06754183182     , 0.0980794282962   , 0.154951029833    , 0.278633485413    ,
 0.532174426054    , 0.996708013735    , 1.78390479022     , 3.08134583        ,
 5.20994234669     , 8.65644871061     , 14.088216868      , 22.3501900794     ,
 34.2713889881     , 50.0225462153     , 68.1929067457     , 85.4271370924     ,
 97.4059383232     , 100.872917911     , 95.3466996758     , 83.2556986258     ,
 68.4622497764     , 54.3441813414     , 42.6788787873     , 33.6853663364     ,
 26.7483450589     , 21.1492046269     , 16.420708589      , 12.3585330801     ,
 8.91966184835     , 6.13362667388     , 4.01914338226     , 2.52111267131     ,
 1.51596782325     , 0.867074178771    , 0.465042269866    , 0.23084802397     ,
 0.105479534859    , 0.0446316052228   , 0.0178057798295   , 0.00682864635617  ,
 0.000576411632342 , 0.000185442668128 , 8.00738343416e-05 , 0.000155715397564 ,
 0.000567410062065 , 0.00174302527525  , 0.00419237837955  , 0.00786499601898  ,
 0.0115146135463   , 0.0131762962503   , 0.0118236874438   , 0.00837776671422  ,
 0.00475526607523  , 0.00222393746688  , 0.000897966329201 , 0.00033050192605  ,
 0.000113805538004 , 3.57370501825e-05 , 9.73285344904e-06 , 2.25101070072e-06 ,
 5.36776209672e-07 , 2.94725063238e-07 , 3.27719126364e-07 , 3.44871558054e-07 ,
 2.90975873521e-07 , 1.93225512868e-07 , 1.00669815233e-07 , 4.11052399082e-08 ,
 1.31703176102e-08 , 3.36114155017e-09 , 7.79748090581e-10 , 3.38223660553e-10 ,
 4.20684538647e-10 , 6.72024161422e-10 , 1.08715308262e-09 , 1.91093084166e-09 ,
 4.49131603176e-09 , 1.48127831033e-08 , 5.18847025507e-08 , 1.56265696939e-07 ,
 3.77150612266e-07 , 7.16523730861e-07 , 1.06750293306e-06 , 1.24722364036e-06 ,
 1.1451140331e-06  , 8.3922708134e-07  , 6.30092527757e-07 , 1.86418991972e-06 ,
 1.39322899428e-05 , 9.21263830529e-05 , 0.000484786605636 , 0.00203696091242  ,
 0.0069366182796   , 0.0195932273064   , 0.0473826615668   , 0.101786819558    ,
 0.200875831063    , 0.371922576405    , 0.649307383145    , 1.06260954971     ,
 1.61852640166     , 2.29452349324     , 3.05792711132     , 3.8900794034      ,
 4.77436401483     , 5.64530792301     , 6.36036614042     , 6.75428028495     ,
 6.74055098062     , 6.35487300915     , 5.70394331719     , 4.89529234484     ,
 4.01881545772     , 3.16019699939     , 2.39732514564     , 1.77975451982     ,
 1.31799153312     , 0.989108284992    , 0.751792791589    , 0.566000292423    ,
 0.408597457279    , 0.27560355875     , 0.172444868884    , 0.102575147852    ,
 0.0627281314551   , 0.0450663339623   , 0.0409208184331   , 0.0422019614813   ,
 0.0418818552754   , 0.0360535155023   , 0.0257032427786   , 0.0149985838578   ,
 0.00757071736407  , 0.00489224129986  , 0.0074623751895   , 0.0158552392157   ,
 0.029344656586    , 0.0435840843718   , 0.0514676588617   , 0.0483032790821   ,
 0.0360643706661   , 0.0214659760371   , 0.0102720897444   , 0.00415915262468  ,
 0.00184833010416  , 0.00145212715377  , 0.00162876130777  , 0.00167688192492  ,
 0.00139378385545  , 0.000914635914974 , 0.000471725195011 , 0.000190863299954 ,
 6.05031511525e-05 , 1.50099103248e-05 , 2.91151068899e-06 , 4.41226296049e-07 ,
 5.22072531285e-08 , 4.82071813309e-09 , 3.47295986736e-10 , 1.95460712e-11    ,
 8.76156107037e-13 , 3.98616582026e-14 , 7.80390196405e-15 , 8.10613130674e-14 ,
 2.06194443794e-12 , 4.24820815051e-11 , 6.92274627176e-10 , 8.91002343133e-09 ,
 9.05154445444e-08 , 7.25912121468e-07 , 4.60534948672e-06 , 2.32542904466e-05 ,
 9.47610123438e-05 , 0.000320106936235 , 0.000934751939095 , 0.00246764271804  ,
 0.00600460078219  , 0.0132132338009   , 0.0253994169471   , 0.0418272922679   ,
 0.0599474268128   , 0.08052676918     , 0.116430913325    , 0.199127234507    ,
 0.378498112746    , 0.720505981164    , 1.31604250336     , 2.30767415314     ,
 3.914849393       , 6.42717182925     , 10.1724819949     , 15.4852503898     ,
 22.6071475674     , 31.3818773247     , 40.8389534548     , 49.1309265716     ,
 54.1769015328     , 54.6953794496     , 50.8568028201     , 44.0911229934     ,
 36.2784505965     , 28.9320763103     , 22.8065771758     , 17.9672912414     ,
 14.1199575246     , 10.9471179111     , 8.26803117074     , 6.01895715731     ,
 4.1837930412      , 2.75649362164     , 1.71881561831     , 1.01987345862     ,
 0.579353499443    , 0.314366965456    , 0.160967811922    , 0.0765914204152   ,
 0.0334818288625   , 0.0134075302852   , 0.00496211601369  , 0.00172981532671  ,
 0.000116534874168 , 3.45698674821e-05 , 2.03744136379e-05 , 6.19497874337e-05 ,
 0.000237790822945 , 0.00073273518812  , 0.00176234691288  , 0.00330450120603  ,
 0.00483230122051  , 0.00551565802488  , 0.00492204498548  , 0.00344554144561  ,
 0.00190553642399  , 0.000845096273593 , 0.000309531759242 , 9.83304933072e-05 ,
 2.86586018021e-05 , 7.85346302601e-06 , 1.96518467194e-06 , 4.29178915007e-07 ,
 8.7291667493e-08  , 3.09996290672e-08 , 2.86389757864e-08 , 2.9535785951e-08  ,
 2.48873767454e-08 , 1.6526523453e-08  , 8.60917194339e-09 , 3.51326258453e-09 ,
 1.1229794007e-09  , 2.82883815056e-10 , 6.00075403382e-11 , 1.81860590165e-11 ,
 1.83488627107e-11 , 2.9348713516e-11  , 5.00082439405e-11 , 1.0285939255e-10  ,
 3.15571077901e-10 , 1.24373831096e-09 , 4.6276485866e-09  , 1.41511647651e-08 ,
 3.42407996316e-08 , 6.49746848679e-08 , 9.65428388898e-08 , 1.12399762043e-07 ,
 1.03165840613e-07 , 8.33192660466e-08 , 1.74202246586e-07 , 1.44756523668e-06 ,
 1.20868700421e-05 , 8.01555345668e-05 , 0.00041917341029  , 0.00174131648338  ,
 0.00582120023317  , 0.0159864709141   , 0.0371895261306   , 0.0763224686346   ,
 0.144373285835    , 0.260132662719    , 0.450665089994    , 0.741725392974    ,
 1.13839597376     , 1.61155043517     , 2.11011166435     , 2.59404437792     ,
 3.05056677562     , 3.46696065745     , 3.79229416132     , 3.94727509051     ,
 3.88032129035     , 3.60407900714     , 3.17759774913     , 2.66815421538     ,
 2.13357106686     , 1.62398841404     , 1.18149074351     , 0.832073174706    ,
 0.579879453143    , 0.40976571793     , 0.29642988364     , 0.215615475997    ,
 0.151969757786    , 0.10013800841     , 0.0605432187801   , 0.0342289479471   ,
 0.0202112369263   , 0.0157187730608   , 0.0172308641871   , 0.0207755816782   ,
 0.0224209648288   , 0.0199901345927   , 0.0143580550731   , 0.00833119908438  ,
 0.00433235303697  , 0.00359994339836  , 0.00718207075471  , 0.0164944556092   ,
 0.0316066165197   , 0.048477812123    , 0.059281159625    , 0.0577862535212   ,
 0.044919075251    , 0.0279083842922   , 0.0140838229273   , 0.00638273803348  ,
 0.00381621718762  , 0.00403850936156  , 0.00494164613944  , 0.00516015853428  ,
 0.00429775513697  , 0.0028211109065   , 0.00145505160857  , 0.000588726896855 ,
 0.000186624875294 , 4.62987750731e-05 , 8.98068731684e-06 , 1.36098046635e-06 ,
 1.61034229676e-07 , 1.48690132874e-08 , 1.07093181127e-09 , 6.01473187865e-11 ,
 2.63382707457e-12 , 9.00888363037e-14 , 3.09468249386e-15 , 2.041380789e-14   ,
 5.30243534083e-13 , 1.09380824784e-11 , 1.78461928408e-10 , 2.3029270127e-09  ,
 2.35307028382e-08 , 1.91107183631e-07 , 1.24542310588e-06 , 6.64161656374e-06 ,
 2.99788084802e-05 , 0.000119581688317 , 0.000434427350112 , 0.00142829647164  ,
 0.00410163494663  , 0.00991835151589  , 0.0197845653101   , 0.032558654467    ,
 0.045528393648    , 0.0589131059076   , 0.0823840087266   , 0.138684647104    ,
 0.26269794603     , 0.501288602416    , 0.921736426286    , 1.6274240717      ,
 2.7625097158      , 4.48596412627     , 6.92698573533     , 10.1556673113     ,
 14.149803478      , 18.6820631236     , 23.1646785917     , 26.6831879732     ,
 28.3619745582     , 27.8291991877     , 25.38993392       , 21.8001949361     ,
 17.8806428336     , 14.2396109031     , 11.1776057599     , 8.7211496087      ,
 6.74225482393     , 5.10411320418     , 3.73844011589     , 2.62728321222     ,
 1.75874096557     , 1.11228731484     , 0.661158791009    , 0.370435665921    ,
 0.197379674465    , 0.100551142331    , 0.0486982692789   , 0.0221050116075   ,
 0.00925676599232  , 0.00353383141561  , 0.00122597025602  , 0.000390407901694 ,
 2.11603033398e-05 , 5.8390126214e-06  , 5.0917726797e-06  , 1.99362070056e-05 ,
 7.79824650232e-05 , 0.000240539006519 , 0.000578511197577 , 0.00108449618527  ,
 0.00158510290749  , 0.00180725950975  , 0.00160882437434  , 0.00112013958937  ,
 0.000612128834046 , 0.000264523014439 , 9.18294951267e-05 , 2.64208049409e-05 ,
 6.63363584579e-06 , 1.5391075145e-06  , 3.37108059314e-07 , 6.7580888127e-08  ,
 1.23285667442e-08 , 2.99108220536e-09 , 2.03468518953e-09 , 2.00289427526e-09 ,
 1.6808017415e-09  , 1.11580283086e-09 , 5.81219469857e-10 , 2.37141649747e-10 ,
 7.57526684093e-11 , 1.90395835353e-11 , 3.98732564357e-12 , 1.09651894852e-12 ,
 9.11173665232e-13 , 1.27091300105e-12 , 2.07576259597e-12 , 4.97069699863e-12 ,
 1.92683467913e-11 , 8.4987213791e-11  , 3.26504204418e-10 , 1.00579727248e-09 ,
 2.43545804653e-09 , 4.6155103689e-09  , 6.84317475731e-09 , 7.95745903284e-09 ,
 7.59295418416e-09 , 1.17068688292e-08 , 9.35416679744e-08 , 9.8165545197e-07  ,
 8.29490090025e-06 , 5.50383273838e-05 , 0.000287760288823 , 0.00119470066537  ,
 0.00398926225029  , 0.0109342219739   , 0.0253701354993   , 0.0519558563744   ,
 0.0983644176672   , 0.178321904209    , 0.312312320224    , 0.520076240159    ,
 0.803494847439    , 1.13102296647     , 1.44418325985     , 1.69246332668     ,
 1.86668596883     , 1.98961593298     , 2.07227068437     , 2.09271962122     ,
 2.02095649791     , 1.85148126032     , 1.60789437184     , 1.32645074381     ,
 1.04079803038     , 0.776484032491    , 0.550911050781    , 0.37351890299     ,
 0.245488669309    , 0.160410362828    , 0.106930845316    , 0.0729833966875   ,
 0.0495483057606   , 0.0319944603061   , 0.0189857917116   , 0.0104545845007   ,
 0.0061766364235   , 0.00541820494131  , 0.00700918738995  , 0.00930241949504  ,
 0.0104689204293   , 0.00948204329213  , 0.00683300230922  , 0.00397790945339  ,
 0.00222240691598  , 0.00247235399025  , 0.00594719063485  , 0.0144531997297   ,
 0.028791704363    , 0.0459304722203   , 0.0585034883147   , 0.0594285931517   ,
 0.0481191313172   , 0.0311737730629   , 0.0166780050236   , 0.00879062158433  ,
 0.00718002958134  , 0.00922390293517  , 0.0117840007381   , 0.0123875190035   ,
 0.0103270440849   , 0.00677966598949  , 0.00349680237101  , 0.0014148343568   ,
 0.000448497795917 , 0.000111265305423 , 2.15823921649e-05 , 3.27070794547e-06 ,
 3.86997347404e-07 , 3.57331884069e-08 , 2.57365642801e-09 , 1.44543435995e-10 ,
 6.32847606205e-12 , 2.15957090777e-13 , 5.86683989551e-15 , 4.20952788417e-15 ,
 1.06845615824e-13 , 2.20792843326e-12 , 3.61626276782e-11 , 4.7067514433e-10  ,
 4.9000982696e-09  , 4.13927774753e-08 , 2.91444969771e-07 , 1.78001305145e-06 ,
 9.79811369959e-06 , 4.90695772168e-05 , 0.000217479746082 , 0.000818164032661 ,
 0.00252913050073  , 0.00631595190554  , 0.0127012681158   , 0.0208182209105   ,
 0.0289952950195   , 0.038094430489    , 0.0557171895896   , 0.0976544708065   ,
 0.186362663726    , 0.351760182392    , 0.639157648547    , 1.11887924763     ,
 1.88120733689     , 3.00639554503     , 4.52558593661     , 6.40249126077     ,
 8.53299761963     , 10.7219359082     , 12.6459052837     , 13.9020034185     ,
 14.1879027872     , 13.4768289257     , 12.0166072547     , 10.1696104127     ,
 8.257009815       , 6.50094658245     , 5.02126453976     , 3.83712559118     ,
 2.89462194635     , 2.12869110998     , 1.50634779292     , 1.01877262317     ,
 0.655726287068    , 0.398563636107    , 0.226608130804    , 0.120138040901    ,
 0.0598315751479   , 0.0283295046722   , 0.0128182720011   , 0.00550121583161  ,
 0.00220232074384  , 0.000806494125155 , 0.000265929650852 , 7.86216818597e-05 ,
 3.4632994993e-06  , 9.13793439708e-07 , 1.14730353712e-06 , 5.07511473284e-06 ,
 1.99923297394e-05 , 6.16882973597e-05 , 0.000148360390366 , 0.000278093530162 ,
 0.000406372530376 , 0.000463101438444 , 0.000411809169682 , 0.000286032015804 ,
 0.000155468823463 , 6.63785435817e-05 , 2.24421354703e-05 , 6.11263433947e-06 ,
 1.38888723285e-06 , 2.79708361065e-07 , 5.39548727413e-08 , 1.06064598535e-08 ,
 2.21260997505e-09 , 5.37061030678e-10 , 1.97901546767e-10 , 1.25332884129e-10 ,
 9.27011241296e-11 , 5.98452824425e-11 , 3.10439539132e-11 , 1.28845322643e-11 ,
 4.8656599438e-12  , 3.10618537498e-12 , 4.33877860497e-12 , 6.4639481698e-12  ,
 7.88795827854e-12 , 7.63834737464e-12 , 5.87745790539e-12 , 3.72067682797e-12 ,
 2.66281969008e-12 , 5.26983952629e-12 , 1.82930875975e-11 , 5.60039767068e-11 ,
 1.35503481901e-10 , 2.56483753471e-10 , 3.79842556327e-10 , 4.48101310748e-10 ,
 5.9578281372e-10  , 3.78973724146e-09 , 4.88011599683e-08 , 5.27408353734e-07 ,
 4.47696225521e-06 , 2.98708173495e-05 , 0.000157559143254 , 0.000663278093779 ,
 0.00226189035673  , 0.0063890738277   , 0.0154151078181   , 0.0329822847095   ,
 0.0649796176444   , 0.121116258072    , 0.215271837782    , 0.360838385995    ,
 0.558341243003    , 0.780922792812    , 0.975191746863    , 1.09083041973     ,
 1.11895913132     , 1.09484069724     , 1.05762298519     , 1.01576100805     ,
 0.953560129748    , 0.858202299154    , 0.733773140967    , 0.596489159632    ,
 0.46333362664     , 0.344829634048    , 0.24492794694     , 0.164587360612    ,
 0.104128744397    , 0.0627254330774   , 0.0372194612487   , 0.0226639889069   ,
 0.0142744007796   , 0.00891730379804  , 0.00522837438068  , 0.00286234176379  ,
 0.00174731711742  , 0.00173995363758  , 0.00251715034294  , 0.00350851314726  ,
 0.00402313284157  , 0.00366791534174  , 0.00264848947045  , 0.00156073441486  ,
 0.000987698750127 , 0.00151592971724  , 0.00421288560222  , 0.010802398719    ,
 0.0224731913922   , 0.0373937749028   , 0.0495996573022   , 0.0523329671949   ,
 0.043899526216    , 0.0295207721664   , 0.0168908987587   , 0.010802745841    ,
 0.0116836809309   , 0.0168484334641   , 0.0219930398178   , 0.0231904787511   ,
 0.0193395463961   , 0.0126962032131   , 0.00654822056451  , 0.002649413496    ,
 0.000839847346238 , 0.00020835206517  , 4.04144496312e-05 , 6.12460944888e-06 ,
 7.24676880147e-07 , 6.69126274131e-08 , 4.81933182837e-09 , 2.70666546918e-10 ,
 1.18504592426e-11 , 4.04386982235e-13 , 1.07729838675e-14 , 8.66323985728e-16 ,
 1.69105196368e-14 , 3.51420354694e-13 , 5.82852086193e-12 , 7.79644129089e-11 ,
 8.5879924979e-10  , 8.06729031809e-09 , 6.74250973033e-08 , 5.14187210388e-07 ,
 3.5289493607e-06  , 2.0919179151e-05  , 0.000102875572489 , 0.000408937807099 ,
 0.00129754544271  , 0.0032764757024   , 0.0066236740577   , 0.0109612731721   ,
 0.0158040069717   , 0.0227403357023   , 0.0379393378135   , 0.0725104061991   ,
 0.14070775944     , 0.260295147309    , 0.45866069431     , 0.779134072438    ,
 1.27438114971     , 1.98195528107     , 2.8962249308      , 3.95704559008     ,
 5.05724844988     , 6.05280272965     , 6.77564581019     , 7.07662596207     ,
 6.89773647411     , 6.3105141706      , 5.47106211013     , 4.53442059479     ,
 3.61015621861     , 2.77281152566     , 2.07348195805     , 1.52736547103     ,
 1.11086014232     , 0.788014372401    , 0.53659344373     , 0.348036203854    ,
 0.214712747013    , 0.125326089555    , 0.0683533911252   , 0.0344549760538   ,
 0.0160662240741   , 0.00702723333901  , 0.00293191679397  , 0.00117385934184  ,
 0.000446035241046 , 0.000157006349169 , 4.98054867954e-05 , 1.39590709908e-05 ,
 5.02478988967e-07 , 1.31210404442e-07 , 2.16975986476e-07 , 1.01459276062e-06 ,
 4.00775934249e-06 , 1.23678965647e-05 , 2.97444047909e-05 , 5.57518114592e-05 ,
 8.14610544982e-05 , 9.28129443018e-05 , 8.24940465697e-05 , 5.72384804454e-05 ,
 3.10413002381e-05 , 1.31939795633e-05 , 4.43143445424e-06 , 1.21321318994e-06 ,
 3.06455564156e-07 , 9.81941529081e-08 , 4.65966284087e-08 , 2.40634618913e-08 ,
 1.07373322411e-08 , 3.87420166905e-09 , 1.11495796268e-09 , 2.57023009932e-10 ,
 4.92177579211e-11 , 9.22952678311e-12 , 3.51939861995e-12 , 6.70076778203e-12 ,
 1.96695550297e-11 , 4.89089562819e-11 , 9.63335064854e-11 , 1.49551718266e-10 ,
 1.83137070525e-10 , 1.7711267899e-10  , 1.35402743247e-10 , 8.18802853769e-11 ,
 3.92007515775e-11 , 1.50098416688e-11 , 5.21137784517e-12 , 3.47677650156e-12 ,
 6.08366597246e-12 , 1.11687459058e-11 , 1.6584317504e-11  , 2.26322204104e-11 ,
 9.968076528e-11   , 1.48179588538e-09 , 2.04717396396e-08 , 2.2321079617e-07  ,
 1.91359983281e-06 , 1.29694290925e-05 , 7.01084540763e-05 , 0.000306261769293 ,
 0.00110083867088  , 0.0033297604172   , 0.00868714464787  , 0.0200252453275   ,
 0.0416919423736   , 0.0799095274869   , 0.142858833252    , 0.238540937626    ,
 0.367289687498    , 0.510388752415    , 0.627534226705    , 0.677664210195    ,
 0.652036270163    , 0.582260559309    , 0.50991859867     , 0.453429044981    ,
 0.406113824527    , 0.355705730458    , 0.29861638004     , 0.240037270263    ,
 0.186784248811    , 0.141705876377    , 0.103686066294    , 0.07120261119     ,
 0.0446418882837   , 0.0253037904778   , 0.0132701515056   , 0.00686033874214  ,
 0.00375264527584  , 0.00217601579368  , 0.00124726618686  , 0.000684933631567 ,
 0.000438759488307 , 0.000485694363726 , 0.000750621972237 , 0.00107119657846  ,
 0.00123841795051  , 0.00113226770542  , 0.000819616014011 , 0.000495727307765 ,
 0.000384675938277 , 0.00082463408285  , 0.00256928542395  , 0.00693271127024  ,
 0.0150457066819   , 0.0260137948345   , 0.0357075680722   , 0.0388308357035   ,
 0.0334953030752   , 0.0233315818463   , 0.0145790488097   , 0.0117678429903   ,
 0.015871352923    , 0.0243773064237   , 0.0321113100465   , 0.0338746993069   ,
 0.0282383777396   , 0.0185329424617   , 0.00955715786024  , 0.00386654567914  ,
 0.00122562695338  , 0.000304052355053 , 5.8977140608e-05  , 8.93765881152e-06 ,
 1.05752096049e-06 , 9.76455115878e-08 , 7.03284188513e-09 , 3.94983106765e-10 ,
 1.72933479431e-11 , 5.9012031874e-13  , 1.56948540639e-14 , 4.02906997874e-16 ,
 2.11859181786e-15 , 4.48399939523e-14 , 7.73538773428e-13 , 1.12007395346e-11 ,
 1.42049449647e-10 , 1.64002534264e-09 , 1.73245370178e-08 , 1.61836098476e-07 ,
 1.27698265599e-06 , 8.22354413971e-06 , 4.24081433008e-05 , 0.000173729631898 ,
 0.000564778159997 , 0.00146413765546  , 0.00307116118447  , 0.00541282649722  ,
 0.00875778669143  , 0.0149817031183   , 0.0291827437892   , 0.0597745329784   ,
 0.116528964147    , 0.209548836763    , 0.352644885223    , 0.567970642371    ,
 0.882645451093    , 1.31368330207     , 1.84950516291     , 2.43975172214     ,
 2.99937764292     , 3.42741843251     , 3.63768226943     , 3.59282552557     ,
 3.32266730538     , 2.90753422656     , 2.43403554733     , 1.9598600195      ,
 1.51428065375     , 1.1192652194      , 0.796723873403    , 0.555672880107    ,
 0.384427922994    , 0.261703561454    , 0.171632797182    , 0.106814458666    ,
 0.0628868445483   , 0.0349751121746   , 0.0181886138423   , 0.00870875069157  ,
 0.00380936273801  , 0.00153609929309  , 0.000584479015522 , 0.000214661007295 ,
 7.63610017694e-05 , 2.57227482805e-05 , 7.90154810291e-06 , 2.13719981213e-06 ,
 6.65522514086e-08 , 1.75957148297e-08 , 3.33261282709e-08 , 1.59004497458e-07 ,
 6.28681805906e-07 , 1.94018754416e-06 , 4.66606107639e-06 , 8.74573618848e-06 ,
 1.2778306655e-05  , 1.45585425356e-05 , 1.29419635197e-05 , 8.99477090471e-06 ,
 4.93339975813e-06 , 2.24112566177e-06 , 1.03634756349e-06 , 7.13073016401e-07 ,
 6.72856405974e-07 , 6.01395583348e-07 , 4.40009729907e-07 , 2.55834943165e-07 ,
 1.17682021333e-07 , 4.28166307826e-08 , 1.23234571533e-08 , 2.80553645658e-09 ,
 5.05693799101e-10 , 7.70703205017e-11 , 3.54374205131e-11 , 1.12065658755e-10 ,
 3.5541152651e-10  , 8.90681299086e-10 , 1.7556911662e-09  , 2.72580825657e-09 ,
 3.33797549508e-09 , 3.22816777196e-09 , 2.46791525561e-09 , 1.4922732361e-09  ,
 7.13759916737e-10 , 2.69950881101e-10 , 8.06876552509e-11 , 1.91030280718e-11 ,
 3.73453613874e-12 , 8.95577139208e-13 , 6.5695483143e-13  , 1.82713729437e-12 ,
 2.75809119113e-11 , 4.84162232912e-10 , 6.7968259365e-09  , 7.51958197522e-08 ,
 6.59394374518e-07 , 4.62699430423e-06 , 2.63230506008e-05 , 0.00012337379902  ,
 0.000484479290534 , 0.00161749210521  , 0.00464169859004  , 0.0115589712848   ,
 0.0252995742007   , 0.0495759382576   , 0.0887433048475   , 0.1468524821      ,
 0.223625690879    , 0.307331065881    , 0.372243387505    , 0.39121463473     ,
 0.357960098762    , 0.294409369974    , 0.231561440868    , 0.185767608637    ,
 0.154844196489    , 0.130125743239    , 0.1068110875      , 0.085319770154    ,
 0.0674831954369   , 0.0532939209823   , 0.0409784741423   , 0.029223610579    ,
 0.0184928405618   , 0.0101433009826   , 0.00485053283651  , 0.00212753660392  ,
 0.000951724199517 , 0.000475724539007 , 0.000256587266729 , 0.000140209846751 ,
 9.3989412925e-05  , 0.000112297148123 , 0.000180110140277 , 0.00025995643683  ,
 0.000301631505095 , 0.000276177503223 , 0.000200847355992 , 0.000128108961311 ,
 0.000135948453443 , 0.00039629058285  , 0.00134603988475  , 0.00379448742324  ,
 0.0085317635451   , 0.0152031585672   , 0.0214121945664   , 0.0238244763144   ,
 0.0210777190579   , 0.0154067378126   , 0.0110640881911   , 0.0115408043908   ,
 0.0179160956725   , 0.0280775082348   , 0.0368455662432   , 0.0387092118403   ,
 0.0321930342709   , 0.0211034535698   , 0.0108764708901   , 0.00439908310107  ,
 0.00139424729728  , 0.000345861683578 , 6.70848941146e-05 , 1.01661987229e-05 ,
 1.20287600938e-06 , 1.1106641875e-07  , 7.99946008608e-09 , 4.4927063215e-10  ,
 1.96701847727e-11 , 6.71227525083e-13 , 1.78494691804e-14 , 3.75376102676e-16 ,
 2.14792786893e-16 , 4.82650753417e-15 , 9.32840121405e-14 , 1.63265633703e-12 ,
 2.65952351308e-11 , 3.9526632563e-10  , 5.1054786955e-09  , 5.48788214342e-08 ,
 4.78497144694e-07 , 3.34619979576e-06 , 1.87144516484e-05 , 8.38603654769e-05 ,
 0.000302605281589 , 0.000886987847611 , 0.00214577095265  , 0.00442367739164  ,
 0.00826744171708  , 0.0152961802401   , 0.0296169962796   , 0.0582102985084   ,
 0.108788219748    , 0.186906955973    , 0.296535091219    , 0.444186699644    ,
 0.640391562626    , 0.893340052795    , 1.19651059661     , 1.51732673979     ,
 1.79675482073     , 1.96744092976     , 1.98493251852     , 1.85187078374     ,
 1.61567435482     , 1.33974223064     , 1.07095545232     , 0.828261906858    ,
 0.614673187307    , 0.433590070714    , 0.292153532798    , 0.193140834323    ,
 0.129348333768    , 0.0878729810808   , 0.0583010373019   , 0.0361192801337   ,
 0.02038833464     , 0.0104564897356   , 0.00490484581686  , 0.00211197291012  ,
 0.000833735216703 , 0.000302825505896 , 0.000103146162211 , 3.40266337913e-05 ,
 1.11290161076e-05 , 3.56801233494e-06 , 1.07243784119e-06 , 2.87150097005e-07 ,
 4.94768898655e-08 , 1.2610887757e-08  , 6.14622873256e-09 , 1.98496163259e-08 ,
 7.72850311411e-08 , 2.3840141601e-07  , 5.73347801674e-07 , 1.0747792119e-06  ,
 1.57155456228e-06 , 1.79856557272e-06 , 1.6405956275e-06  , 1.30836543425e-06 ,
 1.24560160216e-06 , 1.84969324815e-06 , 3.16430382196e-06 , 4.68454067638e-06 ,
 5.55057574387e-06 , 5.19255875038e-06 , 3.83083453349e-06 , 2.23083419431e-06 ,
 1.02649546356e-06 , 3.73501588755e-07 , 1.07502561711e-07 , 2.44735412047e-08 ,
 4.41481084063e-09 , 7.0093922579e-10  , 4.61111250876e-10 , 1.59745158619e-09 ,
 5.07920953468e-09 , 1.27296356325e-08 , 2.50924385023e-08 , 3.89574137738e-08 ,
 4.77065450522e-08 , 4.6137166568e-08  , 3.52715918986e-08 , 2.13276553198e-08 ,
 1.02010804974e-08 , 3.85805836494e-09 , 1.15281272253e-09 , 2.7184345083e-10  ,
 5.05228506612e-11 , 7.39774387775e-12 , 8.7381854589e-13  , 3.95120911666e-13 ,
 6.98435217556e-12 , 1.26352376586e-10 , 1.81081723278e-09 , 2.0664322828e-08  ,
 1.8980079255e-07  , 1.42222181751e-06 , 8.81957385103e-06 , 4.58069236048e-05 ,
 0.000200643575925 , 0.000742890620014 , 0.00232875614318  , 0.00621725191054  ,
 0.0143235207302   , 0.0290207414301   , 0.0527055289969   , 0.0868152724233   ,
 0.129634161811    , 0.17332484945     , 0.203639941885    , 0.206768083086    ,
 0.18058983676     , 0.138255584928    , 0.0979048343482   , 0.0695527234502   ,
 0.0524453243719   , 0.0414685537547   , 0.0330733821215   , 0.0263980978579   ,
 0.0215289178096   , 0.0179505576795   , 0.014581269028    , 0.0107883085643   ,
 0.00691029937175  , 0.00373207326048  , 0.0016930371831   , 0.000663945748314 ,
 0.000247091694183 , 0.00010224482848  , 5.01911954171e-05 , 2.70528497106e-05 ,
 1.82229165359e-05 , 2.16749445286e-05 , 3.4672857723e-05  , 5.00325659477e-05 ,
 5.80460585695e-05 , 5.31627767959e-05 , 3.90187829436e-05 , 2.77233980993e-05 ,
 4.48284858199e-05 , 0.000165587459476 , 0.000597261206124 , 0.00174081108528  ,
 0.00401869355659  , 0.00732169747604  , 0.0105272950577   , 0.0120166793363   ,
 0.0111649348231   , 0.00922771085005  , 0.00856743227756  , 0.0111989989904   ,
 0.0177598476589   , 0.026664254127    , 0.0338642542834   , 0.034940842884    ,
 0.0287951172857   , 0.0187918076216   , 0.0096641557749   , 0.00390469442673  ,
 0.00123694095666  , 0.000306767055382 , 5.94952141446e-05 , 9.01555808918e-06 ,
 1.0667037927e-06  , 9.84918982373e-08 , 7.09375089799e-09 , 3.98402554139e-10 ,
 1.74430314122e-11 , 5.95227218944e-13 , 1.58282578758e-14 , 3.26607850254e-16 ,
 1.86964057642e-17 , 5.47120535811e-16 , 1.46554473681e-14 , 3.73949366288e-13 ,
 8.57085172029e-12 , 1.6632153404e-10  , 2.63912109323e-09 , 3.36902216625e-08 ,
 3.43698519029e-07 , 2.79541436491e-06 , 1.81195168341e-05 , 9.36799599193e-05 ,
 0.000387121556096 , 0.00128377606455  , 0.00344347964271  , 0.00759385823712  ,
 0.01424038362     , 0.0241423684148   , 0.04002686128     , 0.067764957171    ,
 0.114132507233    , 0.182039476421    , 0.26884819797     , 0.370842026162    ,
 0.488967215438    , 0.628252685309    , 0.788583799961    , 0.952808437814    ,
 1.08428355318     , 1.14150397884     , 1.10178631255     , 0.975910957011    ,
 0.802099840732    , 0.623659868198    , 0.467843163449    , 0.341350877101    ,
 0.240566191558    , 0.162442659207    , 0.106957675479    , 0.0730941965337   ,
 0.0552477724399   , 0.0446553824652   , 0.0345119160122   , 0.0232922955226   ,
 0.0131570715923   , 0.00615734382277  , 0.00241061242111  , 0.000809651563167 ,
 0.00024239240261  , 6.78929327492e-05 , 1.90041962533e-05 , 5.91387228585e-06 ,
 2.26062256378e-06 , 1.0012557177e-06  , 4.3324506953e-07  , 1.61937048724e-07 ,
 3.66313578719e-07 , 9.23987452538e-08 , 1.85118590612e-08 , 4.65646157536e-09 ,
 7.77482045939e-09 , 2.30105310674e-08 , 5.53613886165e-08 , 1.04778573174e-07 ,
 1.61682857111e-07 , 2.40829094067e-07 , 5.05405938897e-07 , 1.52211613693e-06 ,
 4.50851985877e-06 , 1.09778361707e-05 , 2.11340191118e-05 , 3.197712965e-05   ,
 3.80326114254e-05 , 3.56026963505e-05 , 2.62690249601e-05 , 1.52977144986e-05 ,
 7.03911273727e-06 , 2.56126009646e-06 , 7.37191679087e-07 , 1.67831374219e-07 ,
 3.03236932241e-08 , 5.13506570166e-09 , 4.86851579283e-09 , 1.78993870594e-08 ,
 5.69963594985e-08 , 1.42850228395e-07 , 2.81584107474e-07 , 4.37175078192e-07 ,
 5.35356703076e-07 , 5.1774534109e-07  , 3.95813263139e-07 , 2.39336203717e-07 ,
 1.14475213757e-07 , 4.32946339806e-08 , 1.29367090146e-08 , 3.0505681159e-09  ,
 5.66901734334e-10 , 8.29017032004e-11 , 9.52813298059e-12 , 9.20287018287e-13 ,
 1.49680715528e-12 , 2.67804947978e-11 , 4.00120182268e-10 , 4.84927121628e-09 ,
 4.83106156975e-08 , 4.00292851456e-07 , 2.77754566741e-06 , 1.61566713526e-05 ,
 7.86169328395e-05 , 0.000319766163276 , 0.00109199554855  , 0.00316348207099  ,
 0.00787852428463  , 0.017057389094    , 0.0322830095471   , 0.0534538783273   ,
 0.0773805508317   , 0.0978320304017   , 0.107677564821    , 0.102527665378    ,
 0.0840453867492   , 0.0597631637147   , 0.0382419853348   , 0.0238044744513   ,
 0.0157630426618   , 0.0114149552986   , 0.00874994308125  , 0.00700510994637  ,
 0.00595353430562  , 0.0052646047538   , 0.00449056007401  , 0.00341535879304  ,
 0.00220601986058  , 0.00118525923203  , 0.000533438112302 , 0.000215443200941 ,
 9.56846216915e-05 , 5.68946443904e-05 , 3.90515172299e-05 , 2.47296641317e-05 ,
 1.40653783613e-05 , 9.06654157183e-06 , 8.85533647376e-06 , 1.05540913955e-05 ,
 1.13202665418e-05 , 9.90106746509e-06 , 7.1267264578e-06  , 5.80913545401e-06 ,
 1.38372086869e-05 , 5.87145262443e-05 , 0.000219997388948 , 0.000656644396093 ,
 0.00154688151274  , 0.00288114964036  , 0.00429231869068  , 0.00530066201399  ,
 0.0059240276789   , 0.00691029060112  , 0.00915928626921  , 0.0130142962174   ,
 0.0181068532915   , 0.023315626826    , 0.0265954903311   , 0.0257857180668   ,
 0.0205635827702   , 0.0131999451598   , 0.00673361701235  , 0.00271000080241  ,
 0.000856868878464 , 0.00021231652618  , 4.11596037103e-05 , 6.23581725233e-06 ,
 7.37738832807e-07 , 6.81144755494e-08 , 4.90575005156e-09 , 2.75516196396e-10 ,
 1.20627091236e-11 , 4.1162694466e-13  , 1.09459555943e-14 , 2.25491925315e-16 ,
 1.57351028804e-18 , 1.89390948239e-16 , 8.39834297596e-15 , 3.00159799165e-13 ,
 8.56201088288e-12 , 1.92937667041e-10 , 3.42171618684e-09 , 4.77090144142e-08 ,
 5.23082301444e-07 , 4.51401359854e-06 , 3.07084937685e-05 , 0.000165050785435 ,
 0.000702996071133 , 0.00238294607409  , 0.00647065404519  , 0.0142366377625   ,
 0.0259411797506   , 0.0408252306308   , 0.0594231572712   , 0.0860079406771   ,
 0.126605518516    , 0.182789377878    , 0.248515417309    , 0.315097952459    ,
 0.379450694327    , 0.446166280727    , 0.519804044075    , 0.593759627932    ,
 0.647598535663    , 0.657764429544    , 0.612747122085    , 0.520656043418    ,
 0.405244277813    , 0.2934320316      , 0.202439097065    , 0.135895198371    ,
 0.0896890835801   , 0.0593660275588   , 0.0426750696202   , 0.0374819063496   ,
 0.0388974688935   , 0.0397570963758   , 0.0349903030485   , 0.0250846730744   ,
 0.0143859848668   , 0.00657174304716  , 0.00239508701076  , 0.000701351952234 ,
 0.000169161619543 , 3.82158654496e-05 , 1.33476470277e-05 , 9.52093098971e-06 ,
 7.67055073964e-06 , 5.15442265111e-06 , 2.73302518346e-06 , 1.13282592132e-06 ,
 2.43568463249e-06 , 6.1427075492e-07  , 1.20743387133e-07 , 1.86258436236e-08 ,
 2.77056487024e-09 , 1.98742663744e-09 , 4.8100156568e-09  , 1.44877216287e-08 ,
 6.75830689661e-08 , 3.82784511711e-07 , 1.91338495891e-06 , 7.65209561346e-06 ,
 2.40334391122e-05 , 5.91345925355e-05 , 0.000114049363717 , 0.000172617651852 ,
 0.000205317032766 , 0.000192201013794 , 0.000141813447093 , 8.25848014157e-05 ,
 3.80006932158e-05 , 1.38269787701e-05 , 3.97973855128e-06 , 9.06089998076e-07 ,
 1.64138283951e-07 , 3.0614455564e-08  , 4.13128239246e-08 , 1.57798830617e-07 ,
 5.02925719928e-07 , 1.26050968929e-06 , 2.48469779744e-06 , 3.85763236842e-06 ,
 4.72398693679e-06 , 4.56858434361e-06 , 3.49265587613e-06 , 2.11190250788e-06 ,
 1.01012926437e-06 , 3.82031875519e-07 , 1.14153544885e-07 , 2.69182253202e-08 ,
 5.00234444429e-09 , 7.31523569668e-10 , 8.40561016601e-11 , 7.58847946929e-12 ,
 7.79616539348e-13 , 4.84220436569e-12 , 7.76138560647e-11 , 1.03652327029e-09 ,
 1.15536416988e-08 , 1.07683105341e-07 , 8.3699032099e-07  , 5.40932486766e-06 ,
 2.90901411112e-05 , 0.000130987338042 , 0.0004987623249   , 0.0016200821887   ,
 0.00450044553083  , 0.0106391206897   , 0.0212189127706   , 0.0354614749676   ,
 0.0496108945816   , 0.0584295375165   , 0.058510851508    , 0.0503067393514   ,
 0.0373748367693   , 0.02415327738     , 0.0138713895718   , 0.0075125791168   ,
 0.00424758945061  , 0.0027152276653   , 0.00196061247357  , 0.00157282173341  ,
 0.00139964343826  , 0.00130830883622  , 0.00116016929181  , 0.000900968770415 ,
 0.000593828802749 , 0.000345379964938 , 0.000215031429202 , 0.000187998810793 ,
 0.000205015601276 , 0.000207961852095 , 0.000173446490527 , 0.000116507826965 ,
 6.57155409595e-05 , 3.66905052262e-05 , 2.65095756697e-05 , 2.41861631304e-05 ,
 2.13494841968e-05 , 1.58148119232e-05 , 9.50587195885e-06 , 5.05971965082e-06 ,
 5.20397734494e-06 , 1.76330497981e-05 , 6.6228165953e-05  , 0.000201662900819 ,
 0.000489581072308 , 0.000970054374323 , 0.00166909372249  , 0.00277752522458  ,
 0.0048491962602   , 0.00852304061307  , 0.0136527887307   , 0.0188104467481   ,
 0.0221477713954   , 0.0227790491065   , 0.0209608565416   , 0.0172832991065   ,
 0.0124450233798   , 0.0075460965738   , 0.00373742414926  , 0.00148222100883  ,
 0.000465321316331 , 0.000114902373436 , 2.22383583851e-05 , 3.36655049554e-06 ,
 3.98137408265e-07 , 3.67530337154e-08 , 2.64681088574e-09 , 1.48644022701e-10 ,
 6.50784171368e-12 , 2.22069383004e-13 , 5.90525333476e-15 , 1.21633625578e-16 ,
 1.42935784455e-19 , 2.27899346229e-16 , 1.12364936768e-14 , 4.23585289285e-13 ,
 1.24797369477e-11 , 2.87483104634e-10 , 5.18103620535e-09 , 7.31168263408e-08 ,
 8.09005011026e-07 , 7.0292290282e-06  , 4.80567935964e-05 , 0.000259165986763 ,
 0.00110597883213  , 0.00375017173743  , 0.010162836203    , 0.0222142712699   ,
 0.0398110503888   , 0.0603163909925   , 0.081482770939    , 0.105317769109    ,
 0.136804370467    , 0.177175272983    , 0.22005901061     , 0.256388143965    ,
 0.282904836282    , 0.304661977591    , 0.328469003411    , 0.353637827245    ,
 0.369784924683    , 0.364119846854    , 0.330423833943    , 0.272658633156    ,
 0.203256969153    , 0.137525996852    , 0.0862538301035   , 0.0519940413246   ,
 0.0317535857309   , 0.0219603171993   , 0.0206878009954   , 0.0261812970115   ,
 0.03429699802     , 0.0388081864713   , 0.0355622755926   , 0.0259068697592   ,
 0.0149348056634   , 0.00681003282724  , 0.00245991843528  , 0.000710779565725 ,
 0.000178735445705 , 6.42605269692e-05 , 5.50546352903e-05 , 5.75196883336e-05 ,
 4.99404953237e-05 , 3.40611032132e-05 , 1.81324099356e-05 , 7.52703061816e-06 ,
 1.2699137761e-05  , 3.20266900781e-06 , 6.29390713908e-07 , 9.6379110808e-08  ,
 1.15399663317e-08 , 1.36037264632e-09 , 2.9431913796e-09  , 2.87817898917e-08 ,
 2.39605448746e-07 , 1.57447573771e-06 , 8.09509769497e-06 , 3.2535029087e-05  ,
 0.000102272528527 , 0.000251680072873 , 0.000485412679159 , 0.000734692057248 ,
 0.000873867208191 , 0.000818043113183 , 0.000603584309844 , 0.000351496219668 ,
 0.000161737992952 , 5.88501864912e-05 , 1.69385375393e-05 , 3.85684269587e-06 ,
 7.01624665876e-07 , 1.50365850709e-07 , 2.80087986078e-07 , 1.09590509215e-06 ,
 3.49471720762e-06 , 8.75910203356e-06 , 1.72658152153e-05 , 2.68061448006e-05 ,
 3.28263216556e-05 , 3.17464522103e-05 , 2.42699778975e-05 , 1.46753174567e-05 ,
 7.01924963234e-06 , 2.65468808094e-06 , 7.93238131141e-07 , 1.87051450658e-07 ,
 3.47607431703e-08 , 5.08329284482e-09 , 5.84099260149e-10 , 5.2664272232e-11  ,
 3.75711481087e-12 , 9.89936155554e-13 , 1.41431281352e-11 , 2.12843489204e-10 ,
 2.67222402362e-09 , 2.78702929917e-08 , 2.41229757195e-07 , 1.73956718602e-06 ,
 1.05345078593e-05 , 5.39975197249e-05 , 0.000234908093401 , 0.000862972259077 ,
 0.00264809722569  , 0.0067043702273   , 0.0138665424742   , 0.0233012002701   ,
 0.0318013189573   , 0.0354348769531   , 0.0325875332313   , 0.0251235895636   ,
 0.0165267140208   , 0.00943455536643  , 0.00476821336917  , 0.00222429550592  ,
 0.00104898012354  , 0.000565422946548 , 0.000371261973095 , 0.000295477198483 ,
 0.00027492811446  , 0.000270093470251 , 0.000249350640099 , 0.000208792901126 ,
 0.000182770969354 , 0.000226867423168 , 0.000378799026478 , 0.000611601223134 ,
 0.000817837335685 , 0.000871844681299 , 0.000737164584451 , 0.000501567402839 ,
 0.000293741326816 , 0.000180784934107 , 0.000146995812588 , 0.000140831645546 ,
 0.000124411738611 , 9.09296031002e-05 , 5.34007830944e-05 , 2.51139220392e-05 ,
 1.01129834034e-05 , 6.83745031577e-06 , 1.6898000072e-05  , 5.23604615691e-05 ,
 0.000142800928255 , 0.000364428143124 , 0.000951298665099 , 0.00250757098345  ,
 0.00605626337739  , 0.0123628912126   , 0.0205441510642   , 0.0274909105014   ,
 0.0297267166257   , 0.026362801495    , 0.0196903883604   , 0.0128162540074   ,
 0.00745927395603  , 0.00387510663557  , 0.00174562436049  , 0.000657275460062 ,
 0.00020093311576  , 4.89708834485e-05 , 9.41800974189e-06 , 1.42142273591e-06 ,
 1.6785840851e-07  , 1.54847792713e-08 , 1.1147906081e-09  , 6.25966147762e-11 ,
 2.74036515546e-12 , 9.35043725289e-14 , 2.48646164495e-15 , 5.12143221172e-17 ,
 1.34370865018e-20 , 2.81979938315e-16 , 1.3994610534e-14  , 5.29640025062e-13 ,
 1.56452475789e-11 , 3.61052410262e-10 , 6.51476788909e-09 , 9.20065754324e-08 ,
 1.0183466493e-06  , 8.84779105502e-06 , 6.04661142047e-05 , 0.000325846140269 ,
 0.00138897360381  , 0.0047022372462   , 0.0127127216475   , 0.0276762706848   ,
 0.0492000857096   , 0.0732161904155   , 0.0951799208059   , 0.114782282911    ,
 0.135515412799    , 0.158604864572    , 0.179423229615    , 0.191582652257    ,
 0.193695073381    , 0.190963544916    , 0.190045569456    , 0.192467218413    ,
 0.193193301926    , 0.185261987525    , 0.164948715102    , 0.133510376838    ,
 0.0965763496745   , 0.0619177918732   , 0.0355594992704   , 0.0191129836203   ,
 0.0108671556524   , 0.0087640692703   , 0.0118519013704   , 0.0191178344727   ,
 0.0274721622686   , 0.0320516360177   , 0.0296789522114   , 0.0217032438314   ,
 0.0125286741876   , 0.00571620609106  , 0.00207364120616  , 0.000630219998231 ,
 0.000233271509097 , 0.000208571244261 , 0.000268637804636 , 0.000297691581905 ,
 0.000260147689495 , 0.000177562758532 , 9.4535526621e-05  , 3.92439989093e-05 ,
 5.19014342996e-05 , 1.30893226901e-05 , 2.5723162354e-06  , 3.93867391723e-07 ,
 4.70207904732e-08 , 5.00480201675e-09 , 9.12124460557e-09 , 9.51659247012e-08 ,
 8.02823120431e-07 , 5.28770404542e-06 , 2.71974317255e-05 , 0.000109316868596 ,
 0.000343637210234 , 0.000845650518132 , 0.00163099773717  , 0.00246858231615  ,
 0.00293621407495  , 0.00274864382665  , 0.00202805727581  , 0.00118103544798  ,
 0.000543443407134 , 0.000197738003977 , 5.69140578683e-05 , 1.29610272072e-05 ,
 2.37400742054e-06 , 6.15011964684e-07 , 1.51148721794e-06 , 6.00359443261e-06 ,
 1.91512302618e-05 , 4.8000682798e-05  , 9.46182698383e-05 , 0.000146900170687 ,
 0.000179891319432 , 0.000173973565296 , 0.000133001819969 , 8.04221994204e-05 ,
 3.84662226524e-05 , 1.45479921975e-05 , 4.34704711404e-06 , 1.02507086281e-06 ,
 1.90495758501e-07 , 2.78578234031e-08 , 3.20109359133e-09 , 2.88624296434e-10 ,
 2.03989935398e-11 , 1.251266598e-12   , 2.56111134153e-12 , 4.25786786461e-11 ,
 5.98615073925e-10 , 6.99862692554e-09 , 6.84688457562e-08 , 5.64311621705e-07 ,
 3.92813379158e-06 , 2.29908382396e-05 , 0.000111983996972 , 0.000448337680428 ,
 0.001459035494    , 0.00382773134865  , 0.00805292602727  , 0.0135518676766   ,
 0.0182420655652   , 0.0196973478315   , 0.0171725787878   , 0.0122267571886   ,
 0.00723194300364  , 0.00363352739593  , 0.00159255847996  , 0.000632114016963 ,
 0.000244604554855 , 0.000106024883961 , 5.98544478845e-05 , 4.6118207098e-05  ,
 4.47608786684e-05 , 4.76000926508e-05 , 5.50899374368e-05 , 9.02225582488e-05 ,
 0.000219664063158 , 0.000555449791684 , 0.00118572984581  , 0.00202680735372  ,
 0.00274338913321  , 0.00293538631907  , 0.00249448911135  , 0.00172567831828  ,
 0.00106775990349  , 0.000742862292388 , 0.000679996413752 , 0.000680530822351 ,
 0.000604231779452 , 0.000439822381705 , 0.000256951328184 , 0.000119767535136 ,
 4.45449874368e-05 , 1.38790634228e-05 , 6.64332608165e-06 , 1.49759827198e-05 ,
 5.78584034821e-05 , 0.000234359145321 , 0.000883869672829 , 0.00284386804387  ,
 0.00745555066709  , 0.0156357781008   , 0.0260682699445   , 0.0345008739126   ,
 0.0362880870509   , 0.0304572006698   , 0.0205877211054   , 0.011409050068    ,
 0.00533529380537  , 0.00218051444878  , 0.00079732642195  , 0.000259206924068 ,
 7.25699864131e-05 , 1.6868619835e-05  , 3.16730446012e-06 , 4.72447972107e-07 ,
 5.54775879247e-08 , 5.10395319101e-09 , 3.66975843317e-10 , 2.05935232743e-11 ,
 9.01284956027e-13 , 3.07449744275e-14 , 8.1756817963e-16  , 1.68396538679e-17 ,
 1.14269796949e-21 , 2.81930759287e-16 , 1.39898325038e-14 , 5.29528251459e-13 ,
 1.56419979412e-11 , 3.60932328176e-10 , 6.51094759424e-09 , 9.19165587762e-08 ,
 1.01679537755e-06 , 8.82797715893e-06 , 6.02759597835e-05 , 0.000324460527295 ,
 0.00138124723397  , 0.00466903551585  , 0.0126016131329   , 0.0273794436352   ,
 0.0485261933916   , 0.0717525294791   , 0.0918136678493   , 0.10689945238     ,
 0.118709861343    , 0.128027261237    , 0.132380000903    , 0.129029680638    ,
 0.11891023057     , 0.10672176779     , 0.097358636004    , 0.0922118254155   ,
 0.0886815466195   , 0.0829292360075   , 0.0726731437011   , 0.0580099200521   ,
 0.0411265951022   , 0.025408935851    , 0.0136568654477   , 0.00667134928974  ,
 0.00367328721084  , 0.00378593425167  , 0.00674384526734  , 0.0120961402519   ,
 0.0179275419969   , 0.0211084718546   , 0.0196032709696   , 0.0143500686051   ,
 0.00828921867106  , 0.00379392647978  , 0.00142062827629  , 0.000563811552996 ,
 0.000499289094666 , 0.000771313063993 , 0.00108645181178  , 0.00121538055348  ,
 0.00106310976496  , 0.000725691422925 , 0.00038636660079  , 0.000160390373573 ,
 0.0001664939236   , 4.19890649298e-05 , 8.2516989241e-06  , 1.26347987278e-06 ,
 1.50812706011e-07 , 1.56892201252e-08 , 2.43644655781e-08 , 2.5265439199e-07  ,
 2.13171787849e-06 , 1.40407721893e-05 , 7.22194513605e-05 , 0.000290277847104 ,
 0.00091248759261  , 0.00224552407227  , 0.00433091994889  , 0.00655502589852  ,
 0.00779676625801  , 0.00729869583634  , 0.00538526419879  , 0.0031360987639   ,
 0.00144304915138  , 0.000525069739842 , 0.000151129265794 , 3.44248732595e-05 ,
 6.3753412105e-06  , 2.10752465878e-06 , 6.47861197208e-06 , 2.59739315396e-05 ,
 8.28729148079e-05 , 0.000207713792848 , 0.000409442602493 , 0.000635682767543 ,
 0.000778446084132 , 0.000752838692496 , 0.00057554175735  , 0.000348013601956 ,
 0.000166456810738 , 6.29546916449e-05 , 1.8811547736e-05  , 4.43601278871e-06 ,
 8.24401783662e-07 , 1.20566181432e-07 , 1.38553674667e-08 , 1.24945691918e-09 ,
 8.83096614292e-11 , 4.90582690889e-12 , 6.49171535805e-13 , 8.35329922803e-12 ,
 1.32956411061e-10 , 1.77900994977e-09 , 2.003045172e-08   , 1.88920694467e-07 ,
 1.47783965944e-06 , 9.47394907233e-06 , 4.92351265091e-05 , 0.000205725546901 ,
 0.000687345566592 , 0.00183003190794  , 0.00387517130984  , 0.00652015610809  ,
 0.00871619382142  , 0.00926738323168  , 0.00785965206987  , 0.00534857533267  ,
 0.00295181950956  , 0.00134420376436  , 0.000518149397113 , 0.000175393657232 ,
 5.5477617982e-05  , 1.86725655893e-05 , 8.4055100064e-06  , 6.04880748931e-06 ,
 6.73695301829e-06 , 1.23819746228e-05 , 4.0460181502e-05  , 0.000156643528587 ,
 0.000530386880979 , 0.00144854446889  , 0.00314025741618  , 0.00538523297658  ,
 0.00729922149333  , 0.00782993838516  , 0.00670710857516  , 0.00476482568624  ,
 0.00318522849202  , 0.00253848836249  , 0.00256189135181  , 0.00263210875919  ,
 0.00233378696729  , 0.00168766128761  , 0.000979818105682 , 0.000454327284764 ,
 0.000167786824895 , 4.9379169979e-05  , 1.24980568932e-05 , 8.79620349521e-06 ,
 4.00964133247e-05 , 0.000203554676719 , 0.000850934468139 , 0.00284695431041  ,
 0.00756475225813  , 0.0159259521976   , 0.0265452170112   , 0.0350175166961   ,
 0.0365529924593   , 0.0302013551596   , 0.0197830117914   , 0.0103200089399   ,
 0.00433103900427  , 0.00149099812598  , 0.00043422693952  , 0.000110850025734 ,
 2.53228111361e-05 , 5.12149567985e-06 , 8.86302698494e-07 , 1.26601407382e-07 ,
 1.4546621689e-08  , 1.32419275405e-09 , 9.4726999309e-11  , 5.30291731632e-12 ,
 2.31815926287e-13 , 7.89969035636e-15 , 2.10068005719e-16 , 4.32682220193e-18 ,
 8.02151664612e-23 , 2.23357248364e-16 , 1.10762743353e-14 , 4.19173230857e-13 ,
 1.23794026596e-11 , 2.85564936223e-10 , 5.1494052774e-09  , 7.26598736443e-08 ,
 8.03281490616e-07 , 6.96891436651e-06 , 4.75387380229e-05 , 0.00025562033072  ,
 0.00108688167474  , 0.00366954252443  , 0.00989432727604  , 0.0214901766347   ,
 0.0381180883028   , 0.0564620181561   , 0.0722561233226   , 0.083360314721    ,
 0.0898735015899   , 0.0916546925786   , 0.0876401278553   , 0.077892989485    ,
 0.064922210464    , 0.0524774863677   , 0.0433353350703   , 0.0379410075432   ,
 0.034711618143    , 0.0315588694007   , 0.0271948420885   , 0.0214307336923   ,
 0.0149694402289   , 0.00902776329116  , 0.00464836703589  , 0.00213561321954  ,
 0.00120977316178  , 0.00160225398555  , 0.0033147174226   , 0.00618945848128  ,
 0.0092682108091   , 0.0109445621901   , 0.0101735011114   , 0.00745073778373  ,
 0.00431199862327  , 0.0020109917868   , 0.000895082942767 , 0.000764551650534 ,
 0.00136617995847  , 0.00243228243419  , 0.00347929327644  , 0.00389814405861  ,
 0.00341027783867  , 0.00232793189127  , 0.00123942008208  , 0.000514514146045 ,
 0.000419808452099 , 0.000105873920063 , 2.08063625873e-05 , 3.18581736718e-06 ,
 3.80228806094e-07 , 3.88498609847e-08 , 5.15911552056e-08 , 5.30589919684e-07 ,
 4.47654942038e-06 , 2.94852451336e-05 , 0.000151658923156 , 0.000609575751024 ,
 0.00191619965633  , 0.00471554078339  , 0.00909481661862  , 0.013765379915    ,
 0.0163730016192   , 0.0153270669906   , 0.0113089114806   , 0.0065857239327   ,
 0.00303036481963  , 0.00110263266796  , 0.000317370079391 , 7.23200647253e-05 ,
 1.36322281812e-05 , 6.04718245397e-06 , 2.20294900845e-05 , 8.88305470359e-05 ,
 0.000283460321934 , 0.000710470986206 , 0.00140047169327  , 0.00217431376055  ,
 0.00266263191645  , 0.0025750517231   , 0.00196862661956  , 0.00119038391974  ,
 0.000569376914782 , 0.000215347172429 , 6.43513131545e-05 , 1.51761869572e-05 ,
 2.82079299502e-06 , 4.12631727567e-07 , 4.74384492284e-08 , 4.2808099464e-09  ,
 3.0289717421e-10  , 1.67954169106e-11 , 8.0527698736e-13  , 1.68732461108e-12 ,
 3.04891391078e-11 , 4.66972780815e-10 , 5.91393807298e-09 , 6.11950120536e-08 ,
 5.11846090535e-07 , 3.43269948031e-06 , 1.83611565245e-05 , 7.80868625694e-05 ,
 0.000263599659135 , 0.00070571538024  , 0.00149769111451  , 0.00251867231928  ,
 0.00335562566624  , 0.00354203786122  , 0.00296455762925  , 0.00197200832524  ,
 0.00104793492784  , 0.000449292903746 , 0.00015813376807  , 4.70226712842e-05 ,
 1.24138103166e-05 , 3.23340337096e-06 , 1.08925554329e-06 , 8.49043778835e-07 ,
 2.49228719848e-06 , 1.38077484665e-05 , 7.35482349204e-05 , 0.000320224449951 ,
 0.00110912204801  , 0.00304221565856  , 0.00660190487882  , 0.0113302499905   ,
 0.0153831427055   , 0.0165805497511   , 0.0144088504954   , 0.0106871278587   ,
 0.00792938673941  , 0.00724678068805  , 0.00784827876458  , 0.00814595847973  ,
 0.00716713013912  , 0.00513331218192  , 0.00295618077031  , 0.00136203863152  ,
 0.000500493607851 , 0.000146323814321 , 3.44510234492e-05 , 1.06711786456e-05 ,
 3.07608081948e-05 , 0.000160284371448 , 0.000681458535957 , 0.00229373267499  ,
 0.00610686163677  , 0.0128628687753   , 0.0214347598897   , 0.0282509891285   ,
 0.0294320494181   , 0.0242187051673   , 0.0157313378986   , 0.00806692362343  ,
 0.00327142935242  , 0.00105456628422  , 0.00027330004164  , 5.81670555851e-05 ,
 1.05041566083e-05 , 1.66771230913e-06 , 2.36899139119e-07 , 2.96660147993e-08 ,
 3.16004059571e-09 , 2.76453760645e-10 , 1.93883988198e-11 , 1.07499794939e-12 ,
 4.67758558196e-14 , 1.58743532034e-15 , 4.22129674592e-17 , 8.69470829e-19    ,
 4.46522314871e-24 , 1.39912022339e-16 , 6.9337635471e-15  , 2.62352018473e-13 ,
 7.74621732985e-12 , 1.78634767462e-10 , 3.2199923437e-09  , 4.54137107221e-08 ,
 5.0176976748e-07  , 4.34999631726e-06 , 2.96482007921e-05 , 0.000159265587327 ,
 0.000676502746383 , 0.0022821128149   , 0.00615214821133  , 0.0133799714328   ,
 0.0238334895838   , 0.0356087949205   , 0.0461440947969   , 0.0537916259641   ,
 0.0577576525538   , 0.0571479173269   , 0.0514682965627   , 0.0419851195716   ,
 0.0315017022457   , 0.0226469871907   , 0.0166354869489   , 0.013225325468    ,
 0.0113663337843   , 0.00997759961109  , 0.00842158630949  , 0.00653984453405  ,
 0.0045072989431   , 0.00267294592001  , 0.00134095774196  , 0.000598521972331 ,
 0.000367457798007 , 0.000594513051955 , 0.00132156392902  , 0.00250554296229  ,
 0.00376526296235  , 0.00445068803857  , 0.00413877017251  , 0.00303452996971  ,
 0.00177562565912  , 0.000922161520002 , 0.00076154501297  , 0.00150146608171  ,
 0.00334862954114  , 0.00611576687738  , 0.00877049692496  , 0.00982876156995  ,
 0.00859886959619  , 0.00586979507822  , 0.00312515316089  , 0.00129732894751  ,
 0.000833267189549 , 0.000210146469    , 4.12980234313e-05 , 6.3234456817e-06  ,
 7.54642294349e-07 , 7.59677862267e-08 , 8.65280974003e-08 , 8.8143513173e-07  ,
 7.43621414373e-06 , 4.89793627968e-05 , 0.000251927951842 , 0.00101259568036  ,
 0.0031830916691   , 0.00783321222996  , 0.0151078385362   , 0.0228663364933   ,
 0.027197982674    , 0.025460530216    , 0.0187857782992   , 0.0109398636611   ,
 0.00503388518781  , 0.00183163681906  , 0.000527205896151 , 0.000120212096419 ,
 2.33055587674e-05 , 1.44305676101e-05 , 5.93791846395e-05 , 0.000240289961419 ,
 0.000766831002322 , 0.00192200768992  , 0.00378864804075  , 0.00588212330637  ,
 0.0072032171273   , 0.00696638339495  , 0.00532592799395  , 0.00322060333195  ,
 0.00154057033864  , 0.00058274006578  , 0.000174174774809 , 4.10910017275e-05 ,
 7.64220501563e-06 , 1.11905646332e-06 , 1.28871767742e-07 , 1.16621814186e-08 ,
 8.29044009497e-10 , 4.63166657243e-11 , 2.05023649301e-12 , 4.1289881931e-13  ,
 7.06130985126e-12 , 1.18682624821e-10 , 1.60849971392e-09 , 1.7430296881e-08  ,
 1.50214134594e-07 , 1.02640523341e-06 , 5.55282563046e-06 , 2.37745398823e-05 ,
 8.0564165969e-05  , 0.00021611559926  , 0.000458962814829 , 0.000771523095149 ,
 0.00102621270866  , 0.00107955297724  , 0.000897959369861 , 0.000590821624096 ,
 0.000308071185855 , 0.000127886566147 , 4.26621924389e-05 , 1.1640623146e-05  ,
 2.6853860015e-06  , 5.64844745494e-07 , 1.63323509245e-07 , 4.07434011319e-07 ,
 3.16335201904e-06 , 2.19110275357e-05 , 0.000121296475821 , 0.000531683320141 ,
 0.00184389849896  , 0.00505985659179  , 0.0109868290359   , 0.0188819115692   ,
 0.0257284791042   , 0.0280017664652   , 0.0249953921496   , 0.0198715626107   ,
 0.0168071236709   , 0.0173483762264   , 0.0195678338815   , 0.0202114950479   ,
 0.0175274817296   , 0.0123869444324   , 0.00705812090241  , 0.00322563231804  ,
 0.00117796931492  , 0.00034267574033  , 7.94678726011e-05 , 1.72301639784e-05 ,
 2.0932600012e-05  , 0.000102055503506 , 0.000434298078835 , 0.00146305524601  ,
 0.00389634425694  , 0.00820724994697  , 0.0136754908961   , 0.018020157038    ,
 0.0187642593403   , 0.0154246803491   , 0.00999784946471  , 0.00510427156738  ,
 0.00205120433065  , 0.000649020324936 , 0.000162049594978 , 3.21190296153e-05 ,
 5.1180668014e-06  , 6.70986455828e-07 , 7.48938482436e-08 , 7.37092410141e-09 ,
 6.48718966061e-10 , 5.01181057212e-11 , 3.27597917309e-12 , 1.75129853833e-13 ,
 7.53360489895e-15 , 3.74480521198e-16 , 2.40088467107e-16 , 3.40487432788e-16 ,
 3.86665906168e-16 , 4.11583952428e-16 , 3.66472746869e-15 , 1.29824537368e-13 ,
 3.82867553196e-12 , 8.82671817922e-11 , 1.5905116175e-09  , 2.24222719113e-08 ,
 2.47606977689e-07 , 2.14517950163e-06 , 1.46097338602e-05 , 7.84164714382e-05 ,
 0.000332833064995 , 0.00112236872883  , 0.00302787290358  , 0.00660589142122  ,
 0.0118588373295   , 0.017985725884    , 0.0238426059065   , 0.028486141677    ,
 0.0310100479749   , 0.0303857801793   , 0.0263009797948   , 0.0199869236717   ,
 0.0135639078905   , 0.00860603670263  , 0.00551631593372  , 0.00388758353539  ,
 0.00308090404746  , 0.00258422829017  , 0.00212416001803  , 0.00161992528299  ,
 0.00110063180305  , 0.000643843129025 , 0.000317845732424 , 0.000141078447113 ,
 9.67982952515e-05 , 0.000181289925529 , 0.00041749211141  , 0.000796386362968 ,
 0.00119835700639  , 0.0014170717012   , 0.00131868790925  , 0.000973114356067 ,
 0.000607880330721 , 0.000500336794181 , 0.00103214057144  , 0.00284353929721  ,
 0.00661578585962  , 0.0121335341812   , 0.0174075631553   , 0.0195087743513   ,
 0.0170676714456   , 0.0116508074204   , 0.00620303751912  , 0.00257503544781  ,
 0.00130386919413  , 0.000328830311987 , 6.46217975619e-05 , 9.89472005265e-06 ,
 1.18075858241e-06 , 1.17398675609e-07 , 1.14947871016e-07 , 1.1580310449e-06  ,
 9.76910773075e-06 , 6.43451772144e-05 , 0.00033096283318  , 0.0013302673752   ,
 0.00418169174705  , 0.0102906489477   , 0.0198474722974   , 0.0300399675973   ,
 0.0357305385792   , 0.0334480122308   , 0.0246792559695   , 0.0143719196146   ,
 0.00661311659534  , 0.00240625934284  , 0.000692616328922 , 0.000158091491835 ,
 3.20307042702e-05 , 2.83452785294e-05 , 0.000126783149688 , 0.000514179423787 ,
 0.00164097147982  , 0.00411300935856  , 0.00810762476738  , 0.0125878587398   ,
 0.015415543289    , 0.014909571713    , 0.0113998050582   , 0.00689471404826  ,
 0.00329908260458  , 0.00124857312063  , 0.000373518317927 , 8.82529962319e-05 ,
 1.64552659764e-05 , 2.41981277343e-06 , 2.80636705321e-07 , 2.56914814335e-08 ,
 1.86096608247e-09 , 1.07125464448e-10 , 4.9370967897e-12  , 2.51850044345e-13 ,
 1.51197893039e-12 , 2.65344749185e-11 , 3.70725862646e-10 , 4.09514648749e-09 ,
 3.57114593085e-08 , 2.45765312047e-07 , 1.33525568716e-06 , 5.73113791811e-06 ,
 1.9447967214e-05  , 5.2205692274e-05  , 0.000110889599105 , 0.000186358152724 ,
 0.000247679414488 , 0.000260138241948 , 0.000215751433609 , 0.000141222308396 ,
 7.29652837167e-05 , 2.98036208056e-05 , 9.66474901269e-06 , 2.51095426524e-06 ,
 5.32595354316e-07 , 9.88538012418e-08 , 5.73770382728e-08 , 4.63722469191e-07 ,
 4.09323517769e-06 , 2.87400272201e-05 , 0.000159433488728 , 0.000699155869248 ,
 0.00242536433375  , 0.00665899488307  , 0.0144776601742   , 0.024960123996    ,
 0.0342822332526   , 0.0380730326635   , 0.0357318787977   , 0.03160603355     ,
 0.0309519908686   , 0.0349652830008   , 0.0398607254285   , 0.0403717644566   ,
 0.0342384371119   , 0.0237574523162   , 0.0133485733214   , 0.00603631713203  ,
 0.00218694795322  , 0.000632354437754 , 0.000145567410611 , 2.78863115992e-05 ,
 1.32844317602e-05 , 5.16359109748e-05 , 0.00021850969215  , 0.000736112289249 ,
 0.00196045078893  , 0.00412949306385  , 0.00688068527808  , 0.00906613693313  ,
 0.00943934941867  , 0.00775740517057  , 0.00502548183746  , 0.00256287908558  ,
 0.00102756772419  , 0.000323589088654 , 8.00023293069e-05 , 1.55398048693e-05 ,
 2.37823852213e-06 , 2.88743234259e-07 , 2.82035805214e-08 , 2.27206704487e-09 ,
 1.56415365609e-10 , 9.52106441385e-12 , 5.18021072884e-13 , 2.54333089936e-14 ,
 3.50299390695e-15 , 6.07958992678e-15 , 1.13192703994e-14 , 1.65015255886e-14 ,
 1.87470502041e-14 , 1.66260637763e-14 , 1.27940611614e-14 , 5.67481765598e-14 ,
 1.49547810705e-12 , 3.44102432554e-11 , 6.1983970819e-10  , 8.7348030725e-09  ,
 9.64116085652e-08 , 8.34802369409e-07 , 5.68178908999e-06 , 3.04771296731e-05 ,
 0.00012930130106  , 0.000436116836971 , 0.00117866627581  , 0.00258497945471  ,
 0.00469464531552  , 0.0072727270967   , 0.00994564699969  , 0.0122946515126   ,
 0.0137136608982   , 0.0134876151155   , 0.0114153751673   , 0.00823641179483  ,
 0.00513432671218  , 0.00288744462365  , 0.00159327400577  , 0.00096746897456  ,
 0.000688760512712 , 0.00054410145814  , 0.000432411951369 , 0.000322486954336 ,
 0.000215541679063 , 0.000124448448032 , 6.07615475596e-05 , 2.7231015418e-05  ,
 2.11742490192e-05 , 4.41341691661e-05 , 0.000103595460119 , 0.000198154293376 ,
 0.000298333187004 , 0.000352951539188 , 0.000329700630337 , 0.000253052059888 ,
 0.0002179336062   , 0.000448516604687 , 0.0014945225976   , 0.00441511271082  ,
 0.0103444151537   , 0.0189847746259   , 0.0272385896103   , 0.0305266691146   ,
 0.0267069310469   , 0.018230801507    , 0.00970630982129  , 0.00402933108287  ,
 0.00161056926416  , 0.000406178854236 , 7.98224247739e-05 , 1.22222559711e-05 ,
 1.45846012388e-06 , 1.43516022695e-07 , 1.20916875339e-07 , 1.20241521969e-06 ,
 1.01427700366e-05 , 6.68063110241e-05 , 0.000343621804271 , 0.00138114866618  ,
 0.00434163694193  , 0.0106842551604   , 0.020606616686    , 0.0311889639276   ,
 0.0370971931062   , 0.034727362589    , 0.0256232108674   , 0.0149216300288   ,
 0.00686606127004  , 0.00249829802627  , 0.000719134080546 , 0.000164420217287 ,
 3.56503156954e-05 , 4.53295988652e-05 , 0.000214246850396 , 0.00087007529897  ,
 0.00277691514621  , 0.00696038327519  , 0.0137210479066   , 0.0213049580998   ,
 0.0260945063702   , 0.0252442569784   , 0.0193099594513   , 0.0116875476009   ,
 0.00559960211761  , 0.0021238839408   , 0.000637743852913 , 0.00015163007215  ,
 2.85687308137e-05 , 4.27373087763e-06 , 5.09524001503e-07 , 4.8713903476e-08  ,
 3.76810402164e-09 , 2.38365191677e-10 , 1.24587240003e-11 , 5.5325614816e-13  ,
 2.91885992906e-13 , 4.89210331583e-12 , 6.91716283647e-11 , 7.69739293229e-10 ,
 6.74237010362e-09 , 4.6524191811e-08  , 2.53164771833e-07 , 1.08761004484e-06 ,
 3.69252304244e-06 , 9.91445029796e-06 , 2.10599762769e-05 , 3.53875216576e-05 ,
 4.7013556897e-05  , 4.93412636466e-05 , 4.08662896572e-05 , 2.66840116004e-05 ,
 1.37265834091e-05 , 5.56293180758e-06 , 1.77862491796e-06 , 4.5046530653e-07  ,
 9.13591749133e-08 , 1.79996203992e-08 , 4.43090000345e-08 , 4.77272389467e-07 ,
 4.24986218307e-06 , 2.986221927e-05   , 0.00016569008525  , 0.00072675413469  ,
 0.00252237713785  , 0.00693386803239  , 0.0151205013177   , 0.0262592167381   ,
 0.0367097262068   , 0.0425078106134   , 0.0436342318922   , 0.0446996129609   ,
 0.0502385068583   , 0.0596026900078   , 0.0668125335996   , 0.0653740816671   ,
 0.053704597421    , 0.0363430476589   , 0.0200393168445   , 0.00893603414743  ,
 0.00320401957377  , 0.000919269271135 , 0.000210227812785 , 3.86920380943e-05 ,
 9.22757633873e-06 , 2.09032321353e-05 , 8.66013701955e-05 , 0.000291614591502 ,
 0.000776638815255 , 0.00163590942681  , 0.00272578410078  , 0.00359149951454  ,
 0.00373923325189  , 0.00307276881226  , 0.00199037471687  , 0.00101477107749  ,
 0.000406636072698 , 0.00012790227262  , 3.15441152999e-05 , 6.09578905454e-06 ,
 9.23008318079e-07 , 1.09637847722e-07 , 1.0251751407e-08  , 7.60480170392e-10 ,
 4.54458534181e-11 , 2.24804177503e-12 , 1.03034914025e-13 , 3.42874218658e-14 ,
 9.47897244697e-14 , 2.27383023143e-13 , 4.25471125204e-13 , 6.20306945842e-13 ,
 7.04718921078e-13 , 6.23981843266e-13 , 4.31080329042e-13 , 2.47311967831e-13 ,
 5.55884618569e-13 , 1.05997540586e-11 , 1.90322951768e-10 , 2.68102459903e-09 ,
 2.95801582851e-08 , 2.56006583222e-07 , 1.74155735571e-06 , 9.33788629124e-06 ,
 3.96143840723e-05 , 0.000133734793927 , 0.000362563888746 , 0.000801268266998 ,
 0.00147833399405  , 0.0023534167681   , 0.00334207839857  , 0.00429771763221  ,
 0.00493513301598  , 0.00490677416155  , 0.0041103957764   , 0.00286629919188  ,
 0.00167643179373  , 0.00085073665827  , 0.000404660182734 , 0.000206368330316 ,
 0.000127431539508 , 9.28416234239e-05 , 7.069519397e-05   , 5.13208308837e-05 ,
 3.36507620769e-05 , 1.91609099271e-05 , 9.27284158477e-06 , 4.23868290084e-06 ,
 3.75142424166e-06 , 8.47355994651e-06 , 2.01199471702e-05 , 3.85386463611e-05 ,
 5.80470513584e-05 , 6.88316667098e-05 , 6.58341008069e-05 , 6.25451711835e-05 ,
 0.00012479595071  , 0.000488165600662 , 0.0018223311856   , 0.00544688125281  ,
 0.0127761330971   , 0.0234501576296   , 0.0336456933424   , 0.037707238776    ,
 0.0329890144501   , 0.0225191048583   , 0.0119894569177   , 0.00497712237789  ,
 0.00157213667654  , 0.000396487781302 , 7.79193700607e-05 , 1.19319781482e-05 ,
 1.42443804065e-06 , 1.39250704143e-07 , 1.0080633019e-07  , 9.85725831394e-07 ,
 8.31380337185e-06 , 5.47595515613e-05 , 0.00028165864662  , 0.00113209481713  ,
 0.00355873686883  , 0.00875763065033  , 0.0168907551513   , 0.0255648542967   ,
 0.0304076896808   , 0.0284651957904   , 0.0210027384676   , 0.0122309063755   ,
 0.0056279477806   , 0.00204779815409  , 0.000589491867984 , 0.000135148798522 ,
 3.24278427722e-05 , 5.84460115439e-05 , 0.000286239729611 , 0.00116345277566  ,
 0.00371356123463  , 0.00930915358893  , 0.0183547856841   , 0.0285095839829   ,
 0.0349395895938   , 0.0338362244285   , 0.0259288613317   , 0.0157426478883   ,
 0.00758279495471  , 0.00290224164695  , 0.000884753489825 , 0.000215649025931 ,
 4.22758417183e-05 , 6.72289072472e-06 , 8.76455257755e-07 , 9.46581613303e-08 ,
 8.52640726632e-09 , 6.40412273017e-10 , 3.98064988319e-11 , 2.02462849898e-12 ,
 1.22800940768e-13 , 7.23515451277e-13 , 1.02395082095e-11 , 1.14257077095e-10 ,
 1.00245597465e-09 , 6.92397317316e-09 , 3.76989076182e-08 , 1.62009914e-07    ,
 5.50134307945e-07 , 1.47722843774e-06 , 3.13788019502e-06 , 5.27221805642e-06 ,
 7.00300831153e-06 , 7.34711188482e-06 , 6.08122074341e-06 , 3.96618853571e-06 ,
 2.03601172231e-06 , 8.22025111875e-07 , 2.6102373136e-07  , 6.52815144301e-08 ,
 1.30384145992e-08 , 4.43895157442e-09 , 3.48294618115e-08 , 3.91232768408e-07 ,
 3.48621269847e-06 , 2.44991928961e-05 , 0.000135960656194 , 0.000596643611422 ,
 0.00207326648198  , 0.00571587364858  , 0.012552242308    , 0.0221663110131   ,
 0.0322039493519   , 0.0404580511774   , 0.047849170044    , 0.0578811808472   ,
 0.0720279733547   , 0.0862829877088   , 0.093034693854    , 0.0866895009443   ,
 0.0681995872308   , 0.0446049540616   , 0.0239724023912   , 0.0104895273372   ,
 0.00370910118619  , 0.00105334180863  , 0.000239020791614 , 4.33063291063e-05 ,
 7.33705113969e-06 , 7.01360917739e-06 , 2.70155410677e-05 , 9.08225414238e-05 ,
 0.000241873921794 , 0.000509481803211 , 0.000848907099902 , 0.0011185180408   ,
 0.00116451891972  , 0.000956945624094 , 0.000619838392482 , 0.00031599708243  ,
 0.000126607989075 , 3.98114855025e-05 , 9.81265001825e-06 , 1.89386012892e-06 ,
 2.86002627054e-07 , 3.37839945562e-08 , 3.12269503227e-09 , 2.26222230722e-10 ,
 1.29036920269e-11 , 6.28337242165e-13 , 2.48543260789e-13 , 9.00018282161e-13 ,
 2.77293044004e-12 , 6.66004518839e-12 , 1.24622031165e-11 , 1.81690180859e-11 ,
 2.06414758725e-11 , 1.82764159661e-11 , 1.26145638311e-11 , 6.79241180514e-12 ,
 2.96035216611e-12 , 3.48649171314e-12 , 4.62082926043e-11 , 6.4745473581e-10  ,
 7.14059262947e-09 , 6.17770336328e-08 , 4.2011525597e-07  , 2.25223330924e-06 ,
 9.55847008866e-06 , 3.23244231813e-05 , 8.8043800361e-05  , 0.000196628149504 ,
 0.000370223014558 , 0.00060912921868  , 0.000902526666262 , 0.00120965508373  ,
 0.00143096538564  , 0.00144219874453  , 0.00120462023002  , 0.000822949738016 ,
 0.000460941814092 , 0.000216511243147 , 9.05456364973e-05 , 3.84038196807e-05 ,
 1.97504800471e-05 , 1.28587642241e-05 , 9.26287246566e-06 , 6.51131673934e-06 ,
 4.1758503421e-06  , 2.34127283842e-06 , 1.12379366373e-06 , 5.27767961022e-07 ,
 5.31089771007e-07 , 1.27621625131e-06 , 3.05342254317e-06 , 5.85402525506e-06 ,
 8.83020976286e-06 , 1.06217612098e-05 , 1.16581186553e-05 , 2.25284608393e-05 ,
 9.95688952521e-05 , 0.000466369767796 , 0.00177518627269  , 0.00531585603088  ,
 0.0124710126747   , 0.022890509148    , 0.0328427781087   , 0.0368074054736   ,
 0.0322017758845   , 0.0219817168209   , 0.0117033450921   , 0.00485835097883  ,
 0.00121362664803  , 0.000306094403454 , 6.01761966848e-05 , 9.23145961411e-06 ,
 1.11216186203e-06 , 1.12776406572e-07 , 6.87077427119e-08 , 6.37820932634e-07 ,
 5.37310443455e-06 , 3.53892921766e-05 , 0.000182026535006 , 0.000731634885678 ,
 0.00229989220066  , 0.0056597627672   , 0.0109159281697   , 0.0165217073287   ,
 0.019651469303    , 0.0183961006953   , 0.0135733649815   , 0.00790442430534  ,
 0.00363715391396  , 0.00132342585368  , 0.000381005505653 , 8.77411702182e-05 ,
 2.43468090546e-05 , 6.02844115975e-05 , 0.00030198896678  , 0.00122828869986  ,
 0.0039216273923   , 0.0098354080369   , 0.019408408873    , 0.0301894656269   ,
 0.0370909859415   , 0.0360759187479   , 0.0278528452072   , 0.0171281051274   ,
 0.00842877937786  , 0.00334116079633  , 0.00107654564037  , 0.000285130026837 ,
 6.27940533312e-05 , 1.15919446829e-05 , 1.79524574117e-06 , 2.31540816729e-07 ,
 2.45517575813e-08 , 2.11029856441e-09 , 1.45228854374e-10 , 7.92791565161e-12 ,
 3.4565777961e-13  , 9.53020436428e-14 , 1.19266042666e-12 , 1.33184267511e-11 ,
 1.16922157642e-10 , 8.07871169162e-10 , 4.3995307897e-09  , 1.89091025198e-08 ,
 6.42133417206e-08 , 1.72430741256e-07 , 3.66268951768e-07 , 6.1537348624e-07  ,
 8.17317131142e-07 , 8.57331736079e-07 , 7.09398165788e-07 , 4.62417435095e-07 ,
 2.37143666065e-07 , 9.55730908713e-08 , 3.0248087548e-08  , 7.52165783374e-09 ,
 1.554267395e-09   , 1.78033410972e-09 , 2.23851012469e-08 , 2.5301895292e-07  ,
 2.25486512197e-06 , 1.58487495754e-05 , 8.79946263922e-05 , 0.000386595785098 ,
 0.00134717803253  , 0.0037396373214   , 0.00834723921382  , 0.0152999946393   ,
 0.0240399633781   , 0.0346885630124   , 0.0490688585208   , 0.0685690162986   ,
 0.0902133919895   , 0.106207647315    , 0.108691285943    , 0.0953283804081   ,
 0.0709401288462   , 0.0443274707001   , 0.0230007702425   , 0.00980518600668  ,
 0.00340171427504  , 0.00095276960767  , 0.000214016463915 , 3.83824638354e-05 ,
 5.73914388651e-06 , 2.15792930195e-06 , 6.64413917068e-06 , 2.22073788781e-05 ,
 5.91344067452e-05 , 0.000124560036344 , 0.000207543920617 , 0.00027345915577  ,
 0.000284705099231 , 0.000233956083961 , 0.000151538226898 , 7.72537937726e-05 ,
 3.0951611631e-05  , 9.73195318911e-06 , 2.39835750183e-06 , 4.62744274457e-07 ,
 6.98361789121e-08 , 8.2380957186e-09  , 7.59270933234e-10 , 5.46928060164e-11 ,
 3.23458951488e-12 , 1.15648452252e-12 , 5.19136419731e-12 , 2.05290428131e-11 ,
 6.32940563459e-11 , 1.52021049303e-10 , 2.84460120639e-10 , 4.1472290499e-10  ,
 4.71158804328e-10 , 4.1717430521e-10  , 2.87935632041e-10 , 1.5495741229e-10  ,
 6.50640066915e-11 , 2.17874156112e-11 , 1.4169185704e-11  , 1.23901143723e-10 ,
 1.35439691817e-09 , 1.17132322884e-08 , 7.96430713492e-08 , 4.27025938197e-07 ,
 1.81396259563e-06 , 6.1510602525e-06  , 1.68635948653e-05 , 3.81826314661e-05 ,
 7.37244587918e-05 , 0.000126012823907 , 0.000195338157089 , 0.000272683585393 ,
 0.000331708178339 , 0.000338955423987 , 0.000283468571376 , 0.000191547644902 ,
 0.000104518031249 , 4.66938657185e-05 , 1.77954026984e-05 , 6.41764605016e-06 ,
 2.66789244281e-06 , 1.47526311555e-06 , 9.78533528661e-07 , 6.59220763873e-07 ,
 4.11612680279e-07 , 2.26705462383e-07 , 1.07896492835e-07 , 5.23510444507e-08 ,
 5.96256749713e-08 , 1.50393794212e-07 , 3.61781448326e-07 , 6.94535205784e-07 ,
 1.05693647658e-06 , 1.38788544809e-06 , 2.66499179744e-06 , 1.27518449012e-05 ,
 7.41826865298e-05 , 0.000358790494839 , 0.00136990755444  , 0.00410342831121  ,
 0.00962692019986  , 0.0176702322334   , 0.0253528509525   , 0.028413330045    ,
 0.0248580333755   , 0.0169687014588   , 0.00903435764566  , 0.00375039870724  ,
 0.000741338965317 , 0.000187229922762 , 3.70569571529e-05 , 5.87790720772e-06 ,
 8.26512280777e-07 , 1.3977937846e-07  , 6.32498940298e-08 , 3.32880433056e-07 ,
 2.73581857063e-06 , 1.80064574203e-05 , 9.26152313701e-05 , 0.000372256140637 ,
 0.00117018610944  , 0.00287968965148  , 0.00555402879573  , 0.00840625156484  ,
 0.00999867575994  , 0.00935994368986  , 0.00690613375174  , 0.0040217743816   ,
 0.00185058554814  , 0.000673361820957 , 0.000193886348069 , 4.4975425805e-05  ,
 1.52146145435e-05 , 4.94570395234e-05 , 0.00025136158024  , 0.00102338127162  ,
 0.00327122750746  , 0.00822068767915  , 0.0162784864173   , 0.0254735661519   ,
 0.0316227945832   , 0.0313054750507   , 0.0248952322531   , 0.0160627266232   ,
 0.00851599874513  , 0.00376144924521  , 0.00139954756994  , 0.000440259463443 ,
 0.000116384871123 , 2.55119998982e-05 , 4.56448397874e-06 , 6.57159424945e-07 ,
 7.5309267071e-08  , 6.81738938128e-09 , 4.85054351419e-10 , 2.70368303617e-11 ,
 1.17861217318e-12 , 4.77249271485e-14 , 1.09874941779e-13 , 1.21589664143e-12 ,
 1.06765007185e-11 , 7.37787026584e-11 , 4.01817081145e-10 , 1.72707668746e-09 ,
 5.86510061201e-09 , 1.57495408506e-08 , 3.3454199161e-08  , 5.62056563231e-08 ,
 7.46470848014e-08 , 7.8295375122e-08  , 6.47760184801e-08 , 4.22129153239e-08 ,
 2.16380802512e-08 , 8.71307601153e-09 , 2.75335201966e-09 , 6.84435390501e-10 ,
 1.77904522757e-10 , 8.23621646769e-10 , 1.14430843104e-08 , 1.29039485341e-07 ,
 1.14890431525e-06 , 8.07588948451e-06 , 4.48826447816e-05 , 0.000197720404508 ,
 0.000693622178755 , 0.00195651140099  , 0.00453048027187  , 0.00897137797513  ,
 0.016175515431    , 0.0280725566382   , 0.0469544857977   , 0.0721111050808   ,
 0.0968064232836   , 0.110742142822    , 0.107242169808    , 0.0880300088012   ,
 0.0613199924008   , 0.0361377312324   , 0.017880972985    , 0.00735101604713  ,
 0.0024832000534   , 0.000682266331227 , 0.000151151564577 , 2.68186611195e-05 ,
 3.84072598089e-06 , 7.1970420498e-07  , 1.3004938979e-06  , 4.25837550897e-06 ,
 1.13344208765e-05 , 2.38744815726e-05 , 3.97800310718e-05 , 5.24140208113e-05 ,
 5.45695111749e-05 , 4.48423915733e-05 , 2.90452959029e-05 , 1.48071580817e-05 ,
 5.93241603747e-06 , 1.86526647413e-06 , 4.59662577157e-07 , 8.86815779025e-08 ,
 1.33814655002e-08 , 1.57799280168e-09 , 1.45364659495e-10 , 1.07820942219e-11 ,
 3.37010710239e-12 , 1.81854734106e-11 , 9.22774614397e-11 , 3.65233357192e-10 ,
 1.12607512965e-09 , 2.70463200476e-09 , 5.06087775313e-09 , 7.37840481422e-09 ,
 8.38246537216e-09 , 7.42201808028e-09 , 5.12271082716e-09 , 2.75686075289e-09 ,
 1.15719357274e-09 , 3.79075063113e-10 , 9.82024963716e-11 , 3.76309164851e-11 ,
 2.0452087979e-10  , 1.74297733068e-09 , 1.1849122346e-08  , 6.35619306899e-08 ,
 2.70419810563e-07 , 9.20557899095e-07 , 2.5458820497e-06  , 5.86593634747e-06 ,
 1.16733328993e-05 , 2.0818377128e-05  , 3.37998085578e-05 , 4.90574990367e-05 ,
 6.1308331214e-05  , 6.37621187039e-05 , 5.41093774616e-05 , 3.73374749489e-05 ,
 2.12595953917e-05 , 1.03653907275e-05 , 4.58184096935e-06 , 1.93661062537e-06 ,
 7.99972189618e-07 , 3.2706160734e-07  , 1.39640664834e-07 , 6.66335918181e-08 ,
 3.4728498952e-08  , 1.7758351019e-08  , 8.24252280214e-09 , 4.13225564414e-09 ,
 5.28451173183e-09 , 1.384798451e-08   , 3.3460242808e-08  , 6.46121617319e-08 ,
 1.03981523533e-07 , 2.07168393431e-07 , 1.03186128155e-06 , 7.35062782292e-06 ,
 4.50466280667e-05 , 0.000218974871017 , 0.000836470923436 , 0.00250568162499  ,
 0.00587852350612  , 0.0107900467014   , 0.0154813168065   , 0.0173501519012   ,
 0.0151791740595   , 0.0103617011262   , 0.00551676971567  , 0.00229028549248  ,
 0.000360388822557 , 9.33565300397e-05 , 2.07695145715e-05 , 5.06187349183e-06 ,
 1.75980279113e-06 , 7.25873594762e-07 , 2.79936852766e-07 , 2.0993261682e-07  ,
 1.11253933272e-06 , 7.20560884032e-06 , 3.70445524611e-05 , 0.000148894298035 ,
 0.000468048620542 , 0.00115181230005  , 0.00222148892901  , 0.00336231508197  ,
 0.0039992496118   , 0.00374377088196  , 0.00276230106766  , 0.001608620987    ,
 0.000740193453584 , 0.000269331307039 , 7.75703449209e-05 , 1.82077925791e-05 ,
 7.94555433039e-06 , 3.21679374284e-05 , 0.000165204335045 , 0.000674660873941 ,
 0.0021671392745   , 0.00549194815274  , 0.0110318716888   , 0.0176859510794   ,
 0.0228518606595   , 0.024115376046    , 0.0211187150737   , 0.0155833916623   ,
 0.0097759985436   , 0.00520447507312  , 0.00232337722629  , 0.000855153982021 ,
 0.000255279962159 , 6.10036542372e-05 , 1.15617156401e-05 , 1.72708947784e-06 ,
 2.02524612993e-07 , 1.85942580054e-08 , 1.33439414746e-09 , 7.47674426283e-11 ,
 3.26850405469e-12 , 1.11965410849e-13 , 1.07272027061e-14 , 8.68655546756e-14 ,
 7.62286244945e-13 , 5.26794144429e-12 , 2.86913106949e-11 , 1.23321935044e-10 ,
 4.18800727769e-10 , 1.12460643858e-09 , 2.38881014425e-09 , 4.01334408287e-09 ,
 5.33003560453e-09 , 5.59032056853e-09 , 4.62471494725e-09 , 3.01343950963e-09 ,
 1.54432865032e-09 , 6.21643198417e-10 , 1.96737906072e-10 , 5.34413924245e-11 ,
 5.74868174656e-11 , 4.99576293067e-10 , 5.40224851875e-09 , 5.46815311505e-08 ,
 4.68863811112e-07 , 3.25743357293e-06 , 1.80754918008e-05 , 8.00391474741e-05 ,
 0.000285115356017 , 0.000833913980276 , 0.00208551711039  , 0.0047403630783   ,
 0.0103117340845   , 0.0213913146444   , 0.0401681406697   , 0.0647796597964   ,
 0.0871484869956   , 0.0969276263879   , 0.0893601228994   , 0.0688305435717   ,
 0.0446737614312   , 0.0245587716765   , 0.0114269994686   , 0.00446979362226  ,
 0.00145411846788  , 0.00038875315704  , 8.44673748112e-05 , 1.47786554908e-05 ,
 2.07451407881e-06 , 2.74027015803e-07 , 2.09754118096e-07 , 6.40143588237e-07 ,
 1.70122766426e-06 , 3.58330126273e-06 , 5.97054810136e-06 , 7.86677143578e-06 ,
 8.19028608846e-06 , 6.73035044836e-06 , 4.35937787693e-06 , 2.22238862065e-06 ,
 8.90387423868e-07 , 2.79953866782e-07 , 6.89891658046e-08 , 1.3309664003e-08  ,
 2.00826377374e-09 , 2.36833029449e-10 , 2.22344400121e-11 , 6.176880967e-12   ,
 3.86970564139e-11 , 2.51881287731e-10 , 1.27988323418e-09 , 5.06581372446e-09 ,
 1.56187464729e-08 , 3.75134487003e-08 , 7.01947539143e-08 , 1.0233902805e-07  ,
 1.16265423315e-07 , 1.02943947394e-07 , 7.10523833572e-08 , 3.82378639876e-08 ,
 1.60503186066e-08 , 5.25680749911e-09 , 1.34422005557e-09 , 2.70571804359e-10 ,
 6.54035729382e-11 , 2.08289384048e-10 , 1.38230014156e-09 , 7.41882954956e-09 ,
 3.16345701964e-08 , 1.08264849956e-07 , 3.02853126367e-07 , 7.13372708046e-07 ,
 1.47309600975e-06 , 2.76681090222e-06 , 4.78472763759e-06 , 7.5190276104e-06  ,
 1.06155101772e-05 , 1.36526303724e-05 , 1.64907127007e-05 , 1.88553465857e-05 ,
 1.96789173433e-05 , 1.77500815379e-05 , 1.32602769789e-05 , 8.00742312431e-06 ,
 3.86197359409e-06 , 1.47978144212e-06 , 4.50101771904e-07 , 1.09402662e-07    ,
 2.18919153908e-08 , 3.98994885631e-09 , 8.32707190731e-10 , 2.89308529858e-10 ,
 3.7071539189e-10  , 9.95828203247e-10 , 2.42145447897e-09 , 4.8483699399e-09  ,
 1.05225463853e-08 , 5.31036483397e-08 , 4.54661535827e-07 , 3.51787660495e-06 ,
 2.17359584952e-05 , 0.000105741380086 , 0.000403954884658 , 0.00121007101352  ,
 0.00283892238198  , 0.00521085098927  , 0.00747641552825  , 0.00837895288288  ,
 0.00733059084312  , 0.00500429041883  , 0.00266498164778  , 0.00110756407634  ,
 0.000154875910469 , 5.70729211e-05    , 2.89019958019e-05 , 1.81599611095e-05 ,
 1.06034387091e-05 , 5.08387221539e-06 , 1.94452494793e-06 , 6.2642715334e-07  ,
 4.82721402282e-07 , 2.28740794195e-06 , 1.16349094616e-05 , 4.67501769043e-05 ,
 0.000146957692166 , 0.000361645407925 , 0.00069750189679  , 0.00105569787729  ,
 0.00125568223768  , 0.00117546716378  , 0.000867305800518 , 0.000505073952335 ,
 0.000232405583293 , 8.45652435783e-05 , 2.43658971394e-05 , 5.83045848055e-06 ,
 3.46639760367e-06 , 1.66292662898e-05 , 8.64775608389e-05 , 0.000357432150481 ,
 0.00117133342368  , 0.0030683888432   , 0.00650260414122  , 0.0113255412802   ,
 0.0164990003036   , 0.0203952603111   , 0.0215011376993   , 0.0191984899519   ,
 0.0142982837403   , 0.00872749876281  , 0.00430005092178  , 0.00169083988665  ,
 0.000526474904991 , 0.000129133103738 , 2.48649362099e-05 , 3.74997999521e-06 ,
 4.42266165953e-07 , 4.07455680493e-08 , 2.93012459986e-09 , 1.64387005467e-10 ,
 7.19260307701e-12 , 2.45491693666e-13 , 6.97655267302e-15 , 4.97808819837e-15 ,
 4.25190870757e-14 , 2.93841332252e-13 , 1.60039372083e-12 , 6.87890414285e-12 ,
 2.3360787824e-11  , 6.27307847692e-11 , 1.33248050021e-10 , 2.23863533993e-10 ,
 2.97305339192e-10 , 3.11818152689e-10 , 2.57950015612e-10 , 1.68070373928e-10 ,
 8.61498939736e-11 , 3.50674742945e-11 , 1.58203051584e-11 , 4.88815916265e-11 ,
 3.48613543982e-10 , 2.12057107965e-09 , 1.08511573814e-08 , 5.08647009818e-08 ,
 2.4518635754e-07  , 1.25040299192e-06 , 6.13731378811e-06 , 2.63628013264e-05 ,
 9.58955070484e-05 , 0.000301490108676 , 0.000865054523603 , 0.0023774649044   ,
 0.00621419963831  , 0.0146116727453   , 0.0292381989204   , 0.048202129072    ,
 0.064622363801    , 0.0703282861755   , 0.0624178821545   , 0.045569571432    ,
 0.0276696455047   , 0.0141264488365   , 0.00610896986261  , 0.00223947779662  ,
 0.000691447431782 , 0.000177754131597 , 3.75535184394e-05 , 6.44206515345e-06 ,
 8.8939132031e-07  , 1.02975280606e-07 , 3.07908671085e-08 , 7.55827910708e-08 ,
 1.99762442062e-07 , 4.20712815333e-07 , 7.00996140367e-07 , 9.23629790257e-07 ,
 9.61613296609e-07 , 7.90203669973e-07 , 5.11830108884e-07 , 2.6092831835e-07  ,
 1.04539402046e-07 , 3.28690394219e-08 , 8.09991548999e-09 , 1.56266152347e-09 ,
 2.35802639275e-10 , 2.8137384287e-11  , 7.19624394199e-12 , 5.00421391619e-11 ,
 4.1761491289e-10  , 2.72435841888e-09 , 1.38434775956e-08 , 5.4792877982e-08  ,
 1.68935558463e-07 , 4.0575313903e-07  , 7.59240825594e-07 , 1.10691987476e-06 ,
 1.25755061789e-06 , 1.11346280913e-06 , 7.68517125423e-07 , 4.13588566629e-07 ,
 1.73603529405e-07 , 5.68586166519e-08 , 1.45377358547e-08 , 2.90370375428e-09 ,
 4.55457722988e-10 , 7.39177955175e-11 , 1.31476677617e-10 , 6.78757329683e-10 ,
 2.90253085479e-09 , 1.00171702533e-08 , 2.86186180309e-08 , 7.12433497521e-08 ,
 1.69839117437e-07 , 4.39706916077e-07 , 1.30415580169e-06 , 4.04416434439e-06 ,
 1.1497999583e-05  , 2.75832940019e-05 , 5.37221700276e-05 , 8.36034295185e-05 ,
 0.000103319711995 , 0.000101174526954 , 7.84411615484e-05 , 4.81277879425e-05 ,
 2.33539978915e-05 , 8.9547050979e-06  , 2.70994981379e-06 , 6.46429254017e-07 ,
 1.21396061471e-07 , 1.79408876367e-08 , 2.0939654777e-09  , 2.00632935659e-10 ,
 3.35162003495e-11 , 5.67170994599e-11 , 1.39714512887e-10 , 3.45035792519e-10 ,
 1.74876221295e-09 , 1.75870083747e-08 , 1.71042581824e-07 , 1.34088669517e-06 ,
 8.29518718425e-06 , 4.03591874838e-05 , 0.000154182470469 , 0.000461863321125 ,
 0.00108356845905  , 0.00198889712207  , 0.00285365146618  , 0.00319826985043  ,
 0.00279864577728  , 0.00191225242115  , 0.00102273492615  , 0.000433787125159 ,
 0.000146691199062 , 0.00014100047332  , 0.000129822093344 , 9.91764294233e-05 ,
 6.05436592868e-05 , 2.92880599595e-05 , 1.12016455245e-05 , 3.3916428898e-06  ,
 8.89370251691e-07 , 7.07404958579e-07 , 2.88514726681e-06 , 1.15098282487e-05 ,
 3.61732763863e-05 , 8.90176002525e-05 , 0.000171687329532 , 0.000259855850257 ,
 0.000309081208267 , 0.000289336585607 , 0.000213483886884 , 0.000124321953194 ,
 5.72057306031e-05 , 2.0815704712e-05  , 6.00186298163e-06 , 1.48266647574e-06 ,
 1.26882015076e-06 , 6.98701523112e-06 , 3.75099082499e-05 , 0.000162295088793 ,
 0.000571079396033 , 0.0016617832481   , 0.0040654514582   , 0.0084501959479   ,
 0.014920550106    , 0.0221476769654   , 0.0272056723147   , 0.0272256467534   ,
 0.0219163953636   , 0.0140609456129   , 0.0071436990083   , 0.00286136208391  ,
 0.000900785916397 , 0.000222387376771 , 4.29868351155e-05 , 6.49788076949e-06 ,
 7.67397611606e-07 , 7.07589600206e-08 , 5.09154814904e-09 , 2.85883393871e-10 ,
 1.25405490915e-11 , 4.32568733242e-13 , 1.20931305464e-14 , 5.12772904495e-16 ,
 1.8565060815e-15  , 1.27960336877e-14 , 6.96919060345e-14 , 2.99554624783e-13 ,
 1.01729026186e-12 , 2.73173281531e-12 , 5.80253732234e-12 , 9.74853510276e-12 ,
 1.29466270064e-11 , 1.35785073167e-11 , 1.12330710269e-11 , 7.33082192571e-12 ,
 3.98649857107e-12 , 5.07683811248e-12 , 4.30127486609e-11 , 4.01218787177e-10 ,
 2.99248547678e-09 , 1.76664636779e-08 , 8.2579148474e-08  , 3.06517751277e-07 ,
 9.13158253647e-07 , 2.25697627848e-06 , 5.03979616709e-06 , 1.18071549164e-05 ,
 3.24997519886e-05 , 0.000102616352494 , 0.000343986054614 , 0.00113112518964  ,
 0.00336092559343  , 0.00847145283229  , 0.0174887434509   , 0.0291191248423   ,
 0.0389112978873   , 0.0417471504827   , 0.0360960214204   , 0.0253209469883   ,
 0.0145514409788   , 0.0069350800763   , 0.00277607837276  , 0.000942101971542 ,
 0.000271599916772 , 6.60867255283e-05 , 1.34041680611e-05 , 2.2340804511e-06  ,
 3.02114981511e-07 , 3.32566631659e-08 , 4.87606930813e-09 , 7.07594278398e-09 ,
 1.8338895521e-08  , 3.86073395509e-08 , 6.43274343351e-08 , 8.47575634475e-08 ,
 8.82431468282e-08 , 7.2513616187e-08  , 4.69684619532e-08 , 2.39442753583e-08 ,
 9.59313244826e-09 , 3.01624996044e-09 , 7.43294134525e-10 , 1.43405408643e-10 ,
 2.17965749611e-11 , 5.38439704574e-12 , 3.93542321006e-11 , 4.2070484469e-10  ,
 3.52362160519e-09 , 2.29873045198e-08 , 1.16807056285e-07 , 4.62325651423e-07 ,
 1.42542690069e-06 , 3.42362168095e-06 , 6.4062433751e-06  , 9.33985357712e-06 ,
 1.06108300728e-05 , 9.39506097927e-06 , 6.48451413375e-06 , 3.48973477769e-06 ,
 1.46481390829e-06 , 4.79755761594e-07 , 1.22664896159e-07 , 2.44989468775e-08 ,
 3.82507791736e-09 , 4.68557563658e-10 , 5.37237009211e-11 , 5.2106067947e-11  ,
 2.13452208599e-10 , 8.09628240637e-10 , 3.27330901227e-09 , 1.80731107259e-08 ,
 1.21256149981e-07 , 7.54764394584e-07 , 3.86200849458e-06 , 1.57113210841e-05 ,
 5.04115306716e-05 , 0.000127401999642 , 0.0002537365145   , 0.000398671737037 ,
 0.00049471919031  , 0.000485298229118 , 0.00037653446275  , 0.000231095732912 ,
 0.000112153111389 , 4.30048010228e-05 , 1.30140909124e-05 , 3.10390248966e-06 ,
 5.8258435571e-07  , 8.59262495234e-08 , 9.94522249865e-09 , 9.02447443478e-10 ,
 6.49049298825e-11 , 6.04616052881e-12 , 7.35813483885e-12 , 3.70169943463e-11 ,
 4.26127823278e-10 , 5.18053549856e-09 , 5.14325089037e-08 , 4.03993063122e-07 ,
 2.49969599726e-06 , 1.21621635622e-05 , 4.64626819822e-05 , 0.000139182152388 ,
 0.000326535078299 , 0.00059937912781  , 0.0008601291227   , 0.000964761098953 ,
 0.000847324323201 , 0.00058896211388  , 0.00034028838258  , 0.000194520372591 ,
 0.000491680847713 , 0.000598949896428 , 0.000584011640435 , 0.000451545096798 ,
 0.00027631630807  , 0.000133731070368 , 5.11481086301e-05 , 1.54443596858e-05 ,
 3.69176482207e-06 , 7.95910423237e-07 , 6.53217940461e-07 , 2.22964767052e-06 ,
 6.97310608433e-06 , 1.71574513865e-05 , 3.30912647542e-05 , 5.00849873524e-05 ,
 5.95727528915e-05 , 5.57671461553e-05 , 4.11471888319e-05 , 2.39619908025e-05 ,
 1.10259196561e-05 , 4.01215043268e-06 , 1.15828825531e-06 , 3.03012149552e-07 ,
 4.07356821323e-07 , 2.61188878539e-06 , 1.54339280292e-05 , 7.60411594945e-05 ,
 0.000315458193054 , 0.00110646280293  , 0.00326345002062  , 0.00799738540818  ,
 0.0160603654644   , 0.0261097934082   , 0.0340415577887   , 0.0353517207023   ,
 0.0290987914511   , 0.0189161328832   , 0.00968465627577  , 0.00389659715461  ,
 0.00122991422216  , 0.00030411114505  , 5.88373709442e-05 , 8.89880489552e-06 ,
 1.05138403269e-06 , 9.70055754247e-08 , 6.994756283e-09   , 3.96241259282e-10 ,
 1.80613797892e-11 , 7.26493240873e-13 , 3.24623098235e-14 , 1.89750716604e-15 ,
 1.76485164298e-16 , 4.41191421802e-16 , 2.36837899156e-15 , 1.01787342254e-14 ,
 3.45670272994e-14 , 9.28228758709e-14 , 1.97166959894e-13 , 3.31248989888e-13 ,
 4.39919038952e-13 , 4.6149681559e-13  , 3.85172314281e-13 , 3.33627568338e-13 ,
 1.75057389022e-12 , 2.45347153994e-11 , 2.91901448058e-10 , 2.75209480028e-09 ,
 2.05262432593e-08 , 1.21069100915e-07 , 5.64330494487e-07 , 2.07675968554e-06 ,
 6.02790809331e-06 , 1.37957859298e-05 , 2.49605383824e-05 , 3.62263429277e-05 ,
 4.5190659547e-05  , 6.33858094654e-05 , 0.000149820625867 , 0.000493537329993 ,
 0.00154478299616  , 0.004020643296    , 0.00842754583826  , 0.0141079167534   ,
 0.0188253467304   , 0.0200350883083   , 0.017044916196    , 0.0116408445337   ,
 0.00642592170466  , 0.00289639113118  , 0.00108026444422  , 0.000338233494283 ,
 8.99016042269e-05 , 2.03481372206e-05 , 3.8956704027e-06  , 6.22361734563e-07 ,
 8.1694246642e-08  , 8.72232945093e-09 , 8.87117211342e-10 , 5.43473066673e-10 ,
 1.31632946475e-09 , 2.76714877914e-09 , 4.61048119254e-09 , 6.07474758175e-09 ,
 6.32456637326e-09 , 5.19719879772e-09 , 3.36632545439e-09 , 1.71613501646e-09 ,
 6.87559330563e-10 , 2.16180799636e-10 , 5.32749557036e-11 , 1.03238805557e-11 ,
 2.60312227736e-12 , 1.88397260546e-11 , 2.57622241136e-10 , 2.77028196003e-09 ,
 2.3203465312e-08  , 1.51374161396e-07 , 7.69188500615e-07 , 3.04446998238e-06 ,
 9.38660753375e-06 , 2.25449606387e-05 , 4.21858838417e-05 , 6.15040612131e-05 ,
 6.98735961479e-05 , 6.18676118639e-05 , 4.27013109332e-05 , 2.29803274748e-05 ,
 9.64597831267e-06 , 3.15925058226e-06 , 8.07763522916e-07 , 1.61328545726e-07 ,
 2.51876272103e-08 , 3.07686964416e-09 , 2.94905149562e-10 , 2.55824469948e-11 ,
 3.08785155048e-11 , 3.6034036792e-10  , 4.57504482896e-09 , 4.88765552861e-08 ,
 4.14716628706e-07 , 2.76281914046e-06 , 1.44284375103e-05 , 5.91036605572e-05 ,
 0.000190132170708 , 0.000481009462563 , 0.000958404272461 , 0.00150612552971  ,
 0.00186912602668  , 0.00183359347928  , 0.00142267344345  , 0.000873162330114 ,
 0.000423755589284 , 0.000162488051209 , 4.91720500184e-05 , 1.17276785418e-05 ,
 2.2012073548e-06  , 3.24654277163e-07 , 3.75734548657e-08 , 3.4078896952e-09  ,
 2.41986848501e-10 , 1.35296873603e-11 , 1.087108898e-12   , 6.49623034506e-12 ,
 9.77622904695e-11 , 1.22682843346e-09 , 1.22171427254e-08 , 9.59908044324e-08 ,
 5.93956434125e-07 , 2.88988101277e-06 , 1.10401895632e-05 , 3.30727205797e-05 ,
 7.7603570116e-05  , 0.000142546696963 , 0.000205223402606 , 0.0002336555965   ,
 0.000219404734775 , 0.000197984494429 , 0.000227417072405 , 0.000337614409278 ,
 0.00174140969464  , 0.00215366841512  , 0.00210652752685  , 0.00162975007958  ,
 0.000997426485662 , 0.000482744486467 , 0.000184635506871 , 5.57449313387e-05 ,
 1.32703276926e-05 , 2.50201360315e-06 , 4.49272805343e-07 , 3.76712006391e-07 ,
 1.05501480197e-06 , 2.587104234e-06   , 4.98921277229e-06 , 7.55135704282e-06 ,
 8.98183497074e-06 , 8.40806036758e-06 , 6.20379689083e-06 , 3.61276993574e-06 ,
 1.66238891552e-06 , 6.04946193529e-07 , 1.75133036725e-07 , 5.23210611007e-08 ,
 1.35444383261e-07 , 1.0842065204e-06  , 7.6749451519e-06  , 4.5508793379e-05  ,
 0.000223740540301 , 0.0009014529902   , 0.00294459681641  , 0.00773319416475  ,
 0.0162304760898   , 0.0271075007717   , 0.0359134189268   , 0.0376468160251   ,
 0.0311567259412   , 0.0203175787909   , 0.0104210448884   , 0.00419729159372  ,
 0.0013256401271   , 0.000327903667254 , 6.34590918734e-05 , 9.60250475546e-06 ,
 1.13645808521e-06 , 1.05622171468e-07 , 7.8617090537e-09  , 5.06883635112e-10 ,
 3.50457344067e-11 , 3.16055311178e-12 , 3.17993263076e-13 , 2.82950991653e-14 ,
 2.0224677418e-15  , 1.25357596605e-16 , 6.77582574726e-17 , 2.69941403636e-16 ,
 9.16147641253e-16 , 2.46012015338e-15 , 5.22559108979e-15 , 8.77949405955e-15 ,
 1.16749993277e-14 , 1.28439967599e-14 , 2.90630036193e-14 , 4.65642743905e-13 ,
 8.77316690021e-12 , 1.3228287499e-10  , 1.57702460661e-09 , 1.48692059617e-08 ,
 1.10899825974e-07 , 6.54099104559e-07 , 3.04866214185e-06 , 1.12164580416e-05 ,
 3.25316334173e-05 , 7.42742701066e-05 , 0.000133312593014 , 0.000187974183536 ,
 0.000208840811844 , 0.000187960680254 , 0.000163850593665 , 0.000237899229225 ,
 0.000602553867355 , 0.00153859024181  , 0.00323861543004  , 0.00544040243827  ,
 0.0072615246578   , 0.00769933332779  , 0.00649115320796  , 0.00436090087552  ,
 0.002344121011    , 0.00101514410265  , 0.00035795244621  , 0.000104257539084 ,
 2.54881433837e-05 , 5.29784251732e-06 , 9.39987487002e-07 , 1.41369316115e-07 ,
 1.77587396441e-08 , 1.83429145203e-09 , 1.61247178989e-10 , 3.78304634776e-11 ,
 7.40357551961e-11 , 1.54825997778e-10 , 2.57936254771e-10 , 3.39854854248e-10 ,
 3.53831079646e-10 , 2.9075992734e-10  , 1.88330787657e-10 , 9.60100450281e-11 ,
 3.84658601422e-11 , 1.20945587839e-11 , 2.98853965545e-12 , 8.12717659156e-13 ,
 5.49815804698e-12 , 9.59456070455e-11 , 1.32463169367e-09 , 1.42450393435e-08 ,
 1.19314360993e-07 , 7.783799278e-07   , 3.95523843369e-06 , 1.56549467069e-05 ,
 4.82668071437e-05 , 0.000115928285053 , 0.000216923751716 , 0.000316259646421 ,
 0.000359296615573 , 0.000318129133281 , 0.000219574235238 , 0.000118167077656 ,
 4.96005758909e-05 , 1.62451876484e-05 , 4.15360516599e-06 , 8.29569254403e-07 ,
 1.29517726207e-07 , 1.58212870044e-08 , 1.51382168892e-09 , 1.15999888307e-10 ,
 6.01512897308e-11 , 9.48909815234e-10 , 1.32226319153e-08 , 1.44147692473e-07 ,
 1.22873672604e-06 , 8.1955095967e-06  , 4.28152275291e-05 , 0.000175407133442 ,
 0.000564298851931 , 0.00142762981766  , 0.00284455460221  , 0.00447021295916  ,
 0.00554761447921  , 0.00544215639981  , 0.00422253544348  , 0.00259157104263  ,
 0.00125771889937  , 0.000482269264924 , 0.00014594407612  , 3.48080911034e-05 ,
 6.53324724918e-06 , 9.63583187119e-07 , 1.11519031592e-07 , 1.01146695737e-08 ,
 7.18137431316e-10 , 3.98788625068e-11 , 1.7918751466e-12  , 1.20783975392e-12 ,
 1.81971735496e-11 , 2.2940856177e-10  , 2.28552671326e-09 , 1.79582769929e-08 ,
 1.11120440163e-07 , 5.40669669917e-07 , 2.06579447736e-06 , 6.1923094758e-06  ,
 1.45722046845e-05 , 2.71267643198e-05 , 4.14499425422e-05 , 5.96604390171e-05 ,
 0.000106292087977 , 0.0002466003574   , 0.000571720752165 , 0.00111527642899  ,
 0.00495944886459  , 0.00613841231065  , 0.0060050259766   , 0.00464604044724  ,
 0.00284345066283  , 0.00137620355138  , 0.000526357265963 , 0.000158916390343 ,
 3.78242285247e-05 , 7.08851436809e-06 , 1.05341123293e-06 , 1.60031831703e-07 ,
 1.34799105701e-07 , 3.05604431389e-07 , 5.87963939864e-07 , 8.89844455663e-07 ,
 1.05840856625e-06 , 9.90795711967e-07 , 7.31048080618e-07 , 4.25724662183e-07 ,
 1.95894539723e-07 , 7.12969625102e-08 , 2.08441040076e-08 , 9.45755423689e-09 ,
 5.89129066089e-08 , 5.81724650493e-07 , 4.75729699662e-06 , 3.14632889861e-05 ,
 0.000166969592086 , 0.000707329044505 , 0.00238428334914  , 0.00638225074248  ,
 0.0135475252074   , 0.022776645542    , 0.0302913795248   , 0.0318234466437   ,
 0.0263706159699   , 0.0172090316802   , 0.00883037344707  , 0.00355753080552  ,
 0.00112381664357  , 0.00027808770193  , 5.38926869812e-05 , 8.20371677834e-06 ,
 9.96556133391e-07 , 1.03173155578e-07 , 1.10508480563e-08 , 1.5312185909e-09  ,
 2.45480312335e-10 , 3.56345137e-11    , 4.19303975195e-12 , 3.88022947898e-13 ,
 2.80329282958e-14 , 1.57936025245e-15 , 7.05778293894e-17 , 7.85968907258e-18 ,
 1.8708971751e-17  , 5.00711106081e-17 , 1.06354290813e-16 , 1.79860579068e-16 ,
 3.0432641266e-16  , 2.87218901903e-15 , 8.09238542972e-14 , 1.95572819061e-12 ,
 3.73599699932e-11 , 5.63528262958e-10 , 6.71822985596e-09 , 6.33438196909e-08 ,
 4.72440627791e-07 , 2.78650364533e-06 , 1.29874650655e-05 , 4.77823856128e-05 ,
 0.000138582523727 , 0.00031638037604  , 0.000567711357436 , 0.000799577200888 ,
 0.000882988672577 , 0.000765184881574 , 0.000527852059505 , 0.0003236499663   ,
 0.000285012233203 , 0.00049900031896  , 0.0009937883114   , 0.0016628265166   ,
 0.00222079195068  , 0.00235200561393  , 0.00197406905825  , 0.00131393801368  ,
 0.000694914739989 , 0.000293201067538 , 9.93868900868e-05 , 2.73671609499e-05 ,
 6.21604102088e-06 , 1.18513129046e-06 , 1.9240242473e-07  , 2.67241817212e-08 ,
 3.15235527788e-09 , 3.10923249128e-10 , 2.55289076248e-11 , 2.85318930849e-12 ,
 3.29422304595e-12 , 6.76060609061e-12 , 1.12587648072e-11 , 1.48343538811e-11 ,
 1.54444011296e-11 , 1.26914033188e-11 , 8.22046561015e-12 , 4.19075013279e-12 ,
 1.67901727808e-12 , 5.28777764592e-13 , 1.62773393196e-13 , 9.80285527181e-13 ,
 2.17465874771e-11 , 3.85465128994e-10 , 5.32231596235e-09 , 5.72360275637e-08 ,
 4.79400601395e-07 , 3.12750139107e-06 , 1.58920012218e-05 , 6.29010018599e-05 ,
 0.00019393428981  , 0.000465795756957 , 0.000871592198956 , 0.00127072084954  ,
 0.00144364263016  , 0.00127823375013  , 0.000882243729764 , 0.000474792881337 ,
 0.000199294413009 , 6.52730835792e-05 , 1.66892196425e-05 , 3.33323188738e-06 ,
 5.20409369503e-07 , 6.35714396854e-08 , 6.08255363091e-09 , 4.61738284223e-10 ,
 1.50169046965e-10 , 2.20559510641e-09 , 3.07728884386e-08 , 3.35578563289e-07 ,
 2.86073143346e-06 , 1.90810712764e-05 , 9.96845238629e-05 , 0.000408392446971 ,
 0.00131383248788  , 0.00332388964769  , 0.00662285623476  , 0.0104078085466   ,
 0.0129162774862   , 0.0126707440258   , 0.00983115186015  , 0.00603384598451  ,
 0.00292829407813  , 0.00112284727035  , 0.000339795461647 , 8.10422163039e-05 ,
 1.52110851188e-05 , 2.24347025374e-06 , 2.59645075192e-07 , 2.35495593795e-08 ,
 1.67200730199e-09 , 9.28383538918e-11 , 4.03643446295e-12 , 3.04192943046e-13 ,
 2.67786674564e-12 , 3.37394036119e-11 , 3.36157414908e-10 , 2.64140208946e-09 ,
 1.63461595708e-08 , 7.95786575317e-08 , 3.04848371454e-07 , 9.2485586518e-07  ,
 2.29680279365e-06 , 5.29749037531e-06 , 1.48105739386e-05 , 5.4248418852e-05  ,
 0.000201679222393 , 0.000633830887161 , 0.0015930269316   , 0.00316413179687  
};
  // type   : nogpivprep
  // tiling : [180, 180]
  // range  : [[-180.0, 178.0], [-180.0, 178.0]]
  ftype32 rama2_nogpivprep_data[] = {
 2.10946168407e-07 , 6.05719409038e-07 , 4.07073370192e-06 , 2.23269705886e-05 ,
 9.67648768984e-05 , 0.00033151999003  , 0.000898349121162 , 0.00192559880895  ,
 0.00326367539721  , 0.00437035570017  , 0.00461844500775  , 0.00384633471102  ,
 0.00252074027418  , 0.00129806257684  , 0.000524493228084 , 0.000166075888348 ,
 4.11631171069e-05 , 7.97863049856e-06 , 1.20849784319e-06 , 1.43178461153e-07 ,
 1.3779960766e-08  , 1.99451587146e-09 , 1.55355732557e-09 , 1.83737336052e-09 ,
 2.25625542231e-09 , 3.75250796147e-09 , 8.51625702922e-09 , 1.96343938969e-08 ,
 3.99426327937e-08 , 8.23046407032e-08 , 2.81498915309e-07 , 1.60115422537e-06 ,
 9.28418669844e-06 , 4.61555869813e-05 , 0.000192218369104 , 0.000669228979314 ,
 0.00194044382226  , 0.00465511931489  , 0.00918511021795  , 0.0148955727784   ,
 0.0200908225019   , 0.0234362666654   , 0.0258982274947   , 0.0312555889342   ,
 0.0446318282352   , 0.0692530827265   , 0.101537390966    , 0.12860334942     ,
 0.135097366548    , 0.116188903235    , 0.0820587091963   , 0.048267909301    ,
 0.0241657187787   , 0.0105685762954   , 0.00421959272021  , 0.00186059463897  ,
 0.00160101450382  , 0.00290342403835  , 0.00635346364573  , 0.013048629457    ,
 0.02291263667     , 0.0328303516107   , 0.0375363288876   , 0.0339295214607   ,
 0.0242301685327   , 0.0139919322401   , 0.00779741571662  , 0.00764850059169  ,
 0.0139440786987   , 0.0256469905124   , 0.039254488216    , 0.0495748955911   ,
 0.0529093695651   , 0.0489706623396   , 0.0397432528574   , 0.02795293892     ,
 0.0165935394032   , 0.00809077065254  , 0.00317537602837  , 0.000990646255448 ,
 0.000244102411602 , 4.74618815809e-05 , 7.33788476068e-06 , 9.32096904624e-07 ,
 1.1934315602e-07  , 5.9407891043e-08  , 1.27196406874e-07 , 2.72068391371e-07 ,
 4.6868157514e-07  , 6.38493379691e-07 , 6.85427226378e-07 , 5.78751661721e-07 ,
 3.83784651398e-07 , 1.995956344e-07   , 8.13113106992e-08 , 2.59194130884e-08 ,
 6.45923086579e-09 , 1.25744839802e-09 , 1.91110202143e-10 , 2.26643384666e-11 ,
 2.09648381851e-12 , 1.51212768904e-13 , 8.50201762107e-15 , 3.72566373323e-16 ,
 1.27230936952e-17 , 3.4813821388e-19  , 9.22559948106e-20 , 5.94017193822e-19 ,
 3.26945714417e-18 , 1.42911915127e-17 , 3.02861191385e-16 , 1.24206362351e-14 ,
 4.61647093923e-13 , 1.35122049988e-11 , 3.08565583046e-10 , 5.49504375655e-09 ,
 7.63262806905e-08 , 8.27170615323e-07 , 6.99716077334e-06 , 4.62268339372e-05 ,
 0.000238676529753 , 0.000963896554181 , 0.00304780472165  , 0.00755406993957  ,
 0.0146953177616   , 0.0224699542256   , 0.0270468403607   , 0.0256756502926   ,
 0.019307388996    , 0.011796295765    , 0.00691843278268  , 0.00671830739537  ,
 0.011665006747    , 0.0204216904086   , 0.0290845150957   , 0.0326035313054   ,
 0.0287906991471   , 0.0205270024912   , 0.0130602354497   , 0.00952052499623  ,
 0.00930189186656  , 0.00978935147799  , 0.00894662385831  , 0.00659975099057  ,
 0.00386449872391  , 0.00179094904487  , 0.000657588478981 , 0.000197876030395 ,
 8.97973825956e-05 , 0.000243962085578 , 0.000986700513528 , 0.00332995117358  ,
 0.00905550651641  , 0.0197561655247   , 0.0345024376565   , 0.0481637536009   ,
 0.0536872103043   , 0.047750420804    , 0.0338676502155   , 0.019145495937    ,
 0.00862154672757  , 0.00309096840874  , 0.000882018928863 , 0.000200659850865 ,
 3.68180261121e-05 , 5.94133637088e-06 , 2.14870460267e-06 , 5.34839092076e-06 ,
 1.64843083989e-05 , 4.09552163491e-05 , 8.00921227321e-05 , 0.000123243519141 ,
 0.000149419416822 , 0.000142929012293 , 0.00010800004882  , 6.45206523947e-05 ,
 3.04890950143e-05 , 1.13961193505e-05 , 3.36804054369e-06 , 7.91959790966e-07 ,
 8.1261503408e-07  , 1.56250616667e-06 , 1.02146999619e-05 , 5.59061042757e-05 ,
 0.000241854290474 , 0.000827011857583 , 0.00223662517173  , 0.00478482617368  ,
 0.00809452424305  , 0.0108202838142   , 0.0114162799529   , 0.00949427300518  ,
 0.00621456137143  , 0.00319687484355  , 0.00129060017549  , 0.00040836324343  ,
 0.000101156663006 , 1.95982194833e-05 , 2.96851261469e-06 , 3.54836573139e-07 ,
 4.13609740508e-08 , 1.83201160156e-08 , 2.31924200849e-08 , 2.82337212764e-08 ,
 3.36646046225e-08 , 5.10614620006e-08 , 1.06059899725e-07 , 2.33447516819e-07 ,
 4.52545273473e-07 , 7.70259643338e-07 , 1.54128138356e-06 , 5.74462909633e-06 ,
 2.95381600796e-05 , 0.000141149230808 , 0.000571420632336 , 0.00193747384795  ,
 0.00548105243775  , 0.0128578107195   , 0.0248388171287   , 0.0393567507802   ,
 0.0513711644961   , 0.0565373859966   , 0.0559462113667   , 0.0566443633569   ,
 0.0672817283515   , 0.0923452124017   , 0.126787489286    , 0.154444644461    ,
 0.157004465716    , 0.129736753652    , 0.0863877556825   , 0.046444281677    ,
 0.0203837827942   , 0.00746027773442  , 0.00237599256529  , 0.000795153649236 ,
 0.000648745748446 , 0.00153577388773  , 0.00411581656659  , 0.00942911167405  ,
 0.0174549499177   , 0.025623980565    , 0.0296200847366   , 0.0269100935217   ,
 0.0192774573184   , 0.0112216660752   , 0.00654927928588  , 0.00714464397271  ,
 0.0137145217761   , 0.0256856755409   , 0.0400880816079   , 0.0521271868498   ,
 0.0579008378345   , 0.0561008333026   , 0.0475032247912   , 0.0344988769923   ,
 0.0209061376742   , 0.0103181173988   , 0.00408005406835  , 0.00128141524648  ,
 0.00031922725896  , 6.36544189582e-05 , 1.04591668194e-05 , 1.52975419142e-06 ,
 3.17928676888e-07 , 4.16991546982e-07 , 1.0792747442e-06  , 2.35370902838e-06 ,
 4.06649873286e-06 , 5.54269208862e-06 , 5.95066863331e-06 , 5.02462827486e-06 ,
 3.33196632356e-06 , 1.73286318587e-06 , 7.05934230523e-07 , 2.2502897927e-07  ,
 5.60782039344e-08 , 1.0917003774e-08  , 1.65919396893e-09 , 1.96768844744e-10 ,
 1.82014003895e-11 , 1.31280963226e-12 , 7.38134135621e-14 , 3.23457535412e-15 ,
 1.10495456036e-16 , 3.41836379861e-18 , 4.30365196043e-18 , 2.95928924728e-17 ,
 1.63099537524e-16 , 7.12769098518e-16 , 2.64559494587e-15 , 1.47771919773e-14 ,
 3.04013922116e-13 , 8.35260428143e-12 , 1.88514642483e-10 , 3.33944043943e-09 ,
 4.62409126674e-08 , 5.00156808012e-07 , 4.22567316637e-06 , 2.78945235831e-05 ,
 0.000143947289349 , 0.000581124040756 , 0.00183704317384  , 0.00455239069407  ,
 0.00885494549293  , 0.0135386388626   , 0.016296246318    , 0.0154766973925   ,
 0.0116824438543   , 0.00735231848378  , 0.00509990271569  , 0.00682004040709  ,
 0.0134936848164   , 0.0241104658118   , 0.0343840424448   , 0.0384463319006   ,
 0.0336639855463   , 0.0232422009327   , 0.0130839350424   , 0.00681525764761  ,
 0.00429926333482  , 0.00357056247243  , 0.00302483469741  , 0.0021739635833   ,
 0.00125366097331  , 0.000573416249656 , 0.00020964406546  , 7.27334457758e-05 ,
 7.70303928239e-05 , 0.000256913713345 , 0.000863312837709 , 0.0024758465751   ,
 0.00597348769127  , 0.0120102100853   , 0.019918973075    , 0.0269942316634   ,
 0.0296604476739   , 0.0262672298906   , 0.0186690465863   , 0.0106169970486   ,
 0.00482218379822  , 0.00174942295813  , 0.000510503054206 , 0.000124077880082 ,
 2.86299379354e-05 , 8.99752700057e-06 , 8.51891526867e-06 , 2.41354970769e-05 ,
 7.37093019097e-05 , 0.000182841888824 , 0.000357505284104 , 0.000550109777418 ,
 0.00066694740276  , 0.00063797677949  , 0.000482068136539 , 0.00028799385969  ,
 0.000136090877134 , 5.08675842321e-05 , 1.5032759365e-05  , 3.52352163112e-06 ,
 2.61932992981e-06 , 3.30477308417e-06 , 2.06355792176e-05 , 0.000112473367263 ,
 0.000484772939313 , 0.00165119177222  , 0.0044476364648   , 0.00947665155949  ,
 0.0159693860141   , 0.0212689330966   , 0.0223655286849   , 0.018544836118    ,
 0.0121072748282   , 0.00621443575568  , 0.00250416527544  , 0.000791139041067 ,
 0.000195730871887 , 3.78867332106e-05 , 5.74792997137e-06 , 7.25752374158e-07 ,
 1.70975640686e-07 , 1.98142533842e-07 , 2.81053998753e-07 , 3.45202240614e-07 ,
 4.04176289533e-07 , 5.67464641066e-07 , 1.07321874178e-06 , 2.23784625794e-06 ,
 4.20009103421e-06 , 6.65399677458e-06 , 9.80491864633e-06 , 2.07014248964e-05 ,
 7.96611111451e-05 , 0.000351173099367 , 0.00136890581815  , 0.00450243458542  ,
 0.0123965903928   , 0.0283956361846   , 0.0537107105505   , 0.0833948405674   ,
 0.106264029631    , 0.112576266514    , 0.103453577389    , 0.0910703689606   ,
 0.089209011617    , 0.104012374366    , 0.129918630773    , 0.150741043727    ,
 0.149026403914    , 0.1204986234      , 0.0782628407386   , 0.0405635688516   ,
 0.0167886022564   , 0.00559202865323  , 0.00153413712027  , 0.000404992622094 ,
 0.000300120243569 , 0.000832023661776 , 0.00242652856735  , 0.00576699716382  ,
 0.010848519725    , 0.0160386898977   , 0.0185992306116   , 0.0169252687531   ,
 0.012147770157    , 0.00713785026266  , 0.004399240356    , 0.00534682573796  ,
 0.0107597863631   , 0.0205510920968   , 0.032830661156    , 0.0441475311394   ,
 0.051179354699    , 0.0518671991419   , 0.0456327991987   , 0.0340553309323   ,
 0.0210015919226   , 0.010493187582    , 0.0042058252976   , 0.00135569289338  ,
 0.000359320509338 , 8.27211480138e-05 , 1.80147532288e-05 , 4.05880950924e-06 ,
 1.55841857868e-06 , 2.79406025567e-06 , 7.35519699989e-06 , 1.60488951056e-05 ,
 2.77285008209e-05 , 3.77944584976e-05 , 4.05763902531e-05 , 3.42619145117e-05 ,
 2.27199986397e-05 , 1.18160406021e-05 , 4.81362152736e-06 , 1.53442671028e-06 ,
 3.82385834315e-07 , 7.44408219857e-08 , 1.13137052471e-08 , 1.34172661722e-09 ,
 1.24111636703e-10 , 8.95178110789e-12 , 5.03318616374e-13 , 2.20560021005e-14 ,
 7.54770278437e-16 , 3.82007438717e-17 , 1.6112357745e-16  , 1.12125072938e-15 ,
 6.18207164465e-15 , 2.70165069306e-14 , 9.41701278704e-14 , 2.70019742259e-13 ,
 8.24796626659e-13 , 6.66869638038e-12 , 1.13114881297e-10 , 1.83010652389e-09 ,
 2.41317536415e-08 , 2.53218053405e-07 , 2.09805601625e-06 , 1.36739078314e-05 ,
 6.99653822075e-05 , 0.000280834216592 , 0.000884268632146 , 0.00218528158458  ,
 0.00424235813527  , 0.00647731016844  , 0.0077896011573   , 0.00739921451473  ,
 0.00562419837124  , 0.0037392398703   , 0.00330948740299  , 0.00586267732699  ,
 0.0125257657202   , 0.0226278254627   , 0.032307086174    , 0.0361069570444   ,
 0.0315454071509   , 0.0215780084316   , 0.0116715469182   , 0.00522012149486  ,
 0.00225846091513  , 0.00124196309332  , 0.000867470043368 , 0.000587750075462 ,
 0.000332018909954 , 0.000151122301955 , 6.21008157179e-05 , 5.85592919761e-05 ,
 0.000183151426021 , 0.000608080089244 , 0.00167956234751  , 0.00381737933454  ,
 0.00718865065304  , 0.0113290087166   , 0.0150930276854   , 0.0171018915695   ,
 0.0164600975299   , 0.0133404308146   , 0.00899100645094  , 0.00498163565177  ,
 0.00226021382484  , 0.000856758192637 , 0.000298209265796 , 0.000119071493905 ,
 6.2331131265e-05  , 3.81117342473e-05 , 3.67340354047e-05 , 8.81566645563e-05 ,
 0.000261189020292 , 0.000645808165458 , 0.00126232360789  , 0.00194233387527  ,
 0.00235485824846  , 0.00225256812395  , 0.0017020859675   , 0.00101684865502  ,
 0.000480509687873 , 0.000179603225195 , 5.30761483046e-05 , 1.24186637197e-05 ,
 6.93989032644e-06 , 5.91822441065e-06 , 3.45046281445e-05 , 0.00018665834906  ,
 0.000798926646161 , 0.00270099892113  , 0.00721902310509  , 0.0152612714908   ,
 0.025519961314    , 0.033741117299    , 0.0352418474183   , 0.0290445565096   ,
 0.0188613731299   , 0.00963695088712  , 0.00386832374737  , 0.00121820082243  ,
 0.000300603353181 , 5.80996793734e-05 , 8.93215712492e-06 , 1.49841653161e-06 ,
 1.13201923937e-06 , 1.8632899306e-06  , 2.70917125093e-06 , 3.3537635294e-06  ,
 3.89406253159e-06 , 5.14842642105e-06 , 8.8754869727e-06  , 1.73723592201e-05 ,
 3.15390408182e-05 , 4.83291839314e-05 , 6.30059858949e-05 , 8.65575378882e-05 ,
 0.000203125653743 , 0.000740852088502 , 0.00269908146074  , 0.00850625268058  ,
 0.0226218926894   , 0.0503401725415   , 0.0929461326788   , 0.141280223153    ,
 0.176118109458    , 0.181066415017    , 0.157636503263    , 0.124683550121    ,
 0.102442827202    , 0.0991290476183   , 0.10926621075     , 0.118750293062    ,
 0.113580553276    , 0.0901298423494   , 0.0577171546972   , 0.0294518046701   ,
 0.0119157641984   , 0.00382523828998  , 0.000991164730776 , 0.000249049855369 ,
 0.000183246612993 , 0.000459005690679 , 0.00125448899079  , 0.00290538211203  ,
 0.00541679753762  , 0.00798757190689  , 0.00926206519691  , 0.00844167162977  ,
 0.00608668645209  , 0.00363730162703  , 0.00239930490302  , 0.00322545863501  ,
 0.00673990457893  , 0.0131344185171   , 0.0215570429144   , 0.030094511267    ,
 0.0364671774347   , 0.038575047018    , 0.0351232836037   , 0.0268692917767   ,
 0.0169106910956   , 0.00868145628822  , 0.00368053682767  , 0.00134861644897  ,
 0.000462595420498 , 0.000157915393593 , 5.22450819469e-05 , 1.61438921265e-05 ,
 7.74298811575e-06 , 1.49223236416e-05 , 3.94422063029e-05 , 8.60755973069e-05 ,
 0.000148718278514 , 0.000202705832197 , 0.000217626378458 , 0.000183759480319 ,
 0.000121855862496 , 6.3373851457e-05  , 2.58172551973e-05 , 8.22970516807e-06 ,
 2.05087845237e-06 , 3.99254010184e-07 , 6.06796387985e-08 , 7.19618239303e-09 ,
 6.65657193759e-10 , 4.80117549854e-11 , 2.6994864076e-12  , 1.18297329719e-13 ,
 4.08718890669e-15 , 6.44353956902e-16 , 4.75427210909e-15 , 3.31677545198e-14 ,
 1.82967335521e-13 , 8.00016846401e-13 , 2.78486909006e-12 , 7.7991905022e-12  ,
 1.83927335023e-11 , 4.69765824079e-11 , 2.4654485412e-10  , 2.34246573638e-09 ,
 2.26825668883e-08 , 1.89438005576e-07 , 1.31787291528e-06 , 7.52425674488e-06 ,
 3.48803821767e-05 , 0.000130175102756 , 0.000388577156855 , 0.000923463405968 ,
 0.00174202298827  , 0.00260409382737  , 0.00308351457805  , 0.00289981541202  ,
 0.00221529077199  , 0.00160811913729  , 0.00190768599466  , 0.00414836228179  ,
 0.00923895368208  , 0.0167839496569   , 0.02397933187     , 0.0267978434449   ,
 0.0233981004977   , 0.0159619798384   , 0.00853038703367  , 0.00362094796952  ,
 0.00129586038157  , 0.000473595248619 , 0.000228907360124 , 0.000134331765029 ,
 7.43104167156e-05 , 3.84999042622e-05 , 4.05590377108e-05 , 0.000138849274175 ,
 0.000533122286803 , 0.00170091710635  , 0.00439499324124  , 0.00916847675172  ,
 0.0154250157963   , 0.0209412638595   , 0.0230264030985   , 0.0206792031167   ,
 0.0153850420375   , 0.00966922623818  , 0.00525144735393  , 0.00254149718178  ,
 0.00118171324093  , 0.000633126687299 , 0.000452341246403 , 0.000369269756156 ,
 0.000277708404247 , 0.000182111789888 , 0.000141479784308 , 0.000261580126583 ,
 0.000734038784353 , 0.00180424459109  , 0.00352457857537  , 0.00542294643526  ,
 0.00657466727684  , 0.00628907479895  , 0.00475215275463  , 0.00283900001064  ,
 0.00134156444048  , 0.000501445773243 , 0.000148184769032 , 3.4639555142e-05  ,
 1.48878922469e-05 , 9.29723580848e-06 , 4.97841550488e-05 , 0.000266149647039 ,
 0.00112612681067  , 0.0037596679816   , 0.0099151870922   , 0.0206739105761   ,
 0.0340969088258   , 0.0444809000643   , 0.0458764220685   , 0.0373744136182   ,
 0.0240216284897   , 0.0121636071956   , 0.00484515969915  , 0.00151601947116  ,
 0.000372163788734 , 7.18991509483e-05 , 1.20124146342e-05 , 4.76721806785e-06 ,
 7.95275074592e-06 , 1.40954393296e-05 , 2.06998369832e-05 , 2.586943734e-05   ,
 3.00251088033e-05 , 3.80310788343e-05 , 6.02269374701e-05 , 0.00010990510221  ,
 0.000191889118906 , 0.000286689973391 , 0.000356067674911 , 0.000398277383051 ,
 0.00057155969679  , 0.00145503280403  , 0.0046129808326   , 0.0135064247034   ,
 0.0340317702296   , 0.0726004629384   , 0.129708385355    , 0.1920515062      ,
 0.233887026308    , 0.234170240078    , 0.195561745343    , 0.142737493647    ,
 0.101191516131    , 0.0807458429599   , 0.076161528108    , 0.0757738706259   ,
 0.0693526181779   , 0.053821109044    , 0.0340329258064   , 0.0172064958788   ,
 0.00689722386605  , 0.00219928218146  , 0.000605021019153 , 0.000255561403054 ,
 0.000311190176635 , 0.000516467050799 , 0.000867184657421 , 0.0014686032322   ,
 0.00235800313168  , 0.00328641478328  , 0.00376628610639  , 0.00348382150999  ,
 0.00262348322376  , 0.00171226830089  , 0.00126840335167  , 0.00171394050482  ,
 0.00345637294385  , 0.00675002208738  , 0.0113729841547   , 0.0165182293001   ,
 0.0209248220812   , 0.0230580325701   , 0.0217287023092   , 0.0172060076441   ,
 0.0114358998233   , 0.00658658505534  , 0.00353122741478  , 0.0018859065037   ,
 0.000988031945971 , 0.000466528713303 , 0.000184664729399 , 6.21004506524e-05 ,
 3.16866921277e-05 , 6.28805593923e-05 , 0.00016661598033  , 0.000363657490969 ,
 0.000628318507555 , 0.000856410348954 , 0.000919448070737 , 0.000776364065004 ,
 0.000514827929382 , 0.000267747714836 , 0.000109075129939 , 3.47696203066e-05 ,
 8.66474115752e-06 , 1.68680530547e-06 , 2.56364955764e-07 , 3.04030976023e-08 ,
 2.81233013956e-09 , 2.02844509089e-10 , 1.14050496258e-11 , 4.99875701774e-13 ,
 1.82173015911e-14 , 1.29540150875e-14 , 1.09971540956e-13 , 7.66926945731e-13 ,
 4.23243834107e-12 , 1.85204630711e-11 , 6.45102457705e-11 , 1.80206986584e-10 ,
 4.12457139104e-10 , 8.47326747438e-10 , 2.23302977257e-09 , 1.15303400273e-08 ,
 8.16966867635e-08 , 5.42365424097e-07 , 3.03632824286e-06 , 1.3955025895e-05  ,
 5.21549793171e-05 , 0.00015787620398  , 0.000386457841563 , 0.000764549910934 ,
 0.00122214912748  , 0.00157818399713  , 0.00164619996477  , 0.00139112909748  ,
 0.00098149287392  , 0.000717973006928 , 0.00100125844833  , 0.0023864630038   ,
 0.00540388835839  , 0.00983861447832  , 0.0140600455635   , 0.0157124084114   ,
 0.0137166101972   , 0.00934994478507  , 0.00497893062913  , 0.00207978209338  ,
 0.000695825579482 , 0.000204729673387 , 7.13514705772e-05 , 4.05223889985e-05 ,
 3.25061399497e-05 , 3.6875130613e-05  , 9.13564962066e-05 , 0.000359782999117 ,
 0.00133709815762  , 0.00410731099701  , 0.0102220888998   , 0.0205258835435   ,
 0.0331580812432   , 0.0429610400399   , 0.0445225383648   , 0.0368561423236   ,
 0.0244158127555   , 0.0130816449786   , 0.00590576438262  , 0.00261182670723  ,
 0.00159459425651  , 0.00149855093544  , 0.0015620891002   , 0.00145072865097  ,
 0.00112045544382  , 0.000719312989867 , 0.000469783765671 , 0.000639074190478 ,
 0.00163853885937  , 0.00398484171983  , 0.00777607213941  , 0.0119630813303   ,
 0.0145036487334   , 0.0138736321302   , 0.0104832128968   , 0.00626282909575  ,
 0.00295950295437  , 0.00110620304318  , 0.000326901978914 , 7.63815143271e-05 ,
 2.55904270962e-05 , 1.30835415917e-05 , 6.47300333951e-05 , 0.000340954481328 ,
 0.00142074852383  , 0.00466251030057  , 0.012066660538    , 0.0246590101597   ,
 0.0398309605143   , 0.0508849719649   , 0.0514220917709   , 0.0410924331662   ,
 0.0259475073579   , 0.0129320527079   , 0.00508031561422  , 0.00157089229175  ,
 0.000382173067412 , 7.48918687122e-05 , 1.83086284567e-05 , 2.21588387145e-05 ,
 4.69679509103e-05 , 8.45911352658e-05 , 0.000125257370127 , 0.00015832759381  ,
 0.000184860673053 , 0.000227883812131 , 0.000335845054686 , 0.000570112118304 ,
 0.000951311725037 , 0.00138389535566  , 0.00167287496421  , 0.00172078578883  ,
 0.00183068337658  , 0.00303076456182  , 0.00753417433877  , 0.019370158269    ,
 0.0444539148766   , 0.0882173331926   , 0.149241639996    , 0.212226194027    ,
 0.25052602497     , 0.243823147181    , 0.196535667566    , 0.134934015476    ,
 0.0850987055866   , 0.0566125404209   , 0.0445577784529   , 0.0394595063295   ,
 0.0340183123441   , 0.0256352994817   , 0.0159694070675   , 0.00800881662301  ,
 0.00320800876121  , 0.00108220271662  , 0.000488527612111 , 0.000610633194752 ,
 0.00104036239983  , 0.00150449462478  , 0.00177112208507  , 0.00177724360051  ,
 0.00167707725265  , 0.00165692870866  , 0.00174588786358  , 0.00184404558945  ,
 0.00185146208848  , 0.00172697719412  , 0.0015234948008   , 0.00144863540954  ,
 0.00183724984251  , 0.00297210955705  , 0.00489094835254  , 0.00732206632412  ,
 0.00969052250405  , 0.0111907539384   , 0.0111949779482   , 0.00986874708723  ,
 0.00812538611957  , 0.00669791713891  , 0.00551443131166  , 0.00417479255089  ,
 0.00267461955386  , 0.00138390064939  , 0.00056840024326  , 0.000194584750104 ,
 0.000102749040476 , 0.000209027051565 , 0.00055521629248  , 0.00121198849964  ,
 0.00209405987856  , 0.00285424550929  , 0.00306433777521  , 0.00258746721007  ,
 0.00171581922223  , 0.000892349947635 , 0.000363525741197 , 0.000115880237779 ,
 2.88778610974e-05 , 5.62178701293e-06 , 8.54413472742e-07 , 1.01327484983e-07 ,
 9.37293772794e-09 , 6.76040552242e-10 , 3.80111906784e-11 , 1.66823433917e-12 ,
 7.96789298548e-14 , 2.31265599438e-13 , 1.99349677304e-12 , 1.38750821381e-11 ,
 7.65958587105e-11 , 3.35497735716e-10 , 1.17002009481e-09 , 3.26964251698e-09 ,
 7.42737938908e-09 , 1.43449868838e-08 , 2.78708437216e-08 , 8.17105793293e-08 ,
 4.04219182105e-07 , 2.27977685853e-06 , 1.16287747931e-05 , 4.99194176493e-05 ,
 0.000175490456678 , 0.000498459609527 , 0.00113566436611  , 0.00206750120725  ,
 0.00300211253993  , 0.00347524644875  , 0.00320948850179  , 0.00237190085093  ,
 0.00142372893194  , 0.000770196306934 , 0.000629051464924 , 0.001162613219    ,
 0.00252438325075  , 0.00456749068868  , 0.00651958174027  , 0.00728370984702  ,
 0.00635777544557  , 0.004332835838    , 0.00230553986592  , 0.000961304141985 ,
 0.000323874111622 , 0.000110341282027 , 7.58779697103e-05 , 9.72877148125e-05 ,

 0.000125190275998 , 0.000153613004997 , 0.000266408266022 , 0.000814490240263 ,
 0.00278943576328  , 0.00821250139792  , 0.0197112340486   , 0.0382452338442   ,
 0.0598201233696   , 0.0752023140118   , 0.0757238536214   , 0.0608852440317   ,
 0.0390816609455   , 0.0202962231375   , 0.00920654019887  , 0.00483684075543  ,
 0.00415277052734  , 0.00469497918031  , 0.00507562394318  , 0.00469691075925  ,
 0.00359375009223  , 0.00226202241887  , 0.00131580709971  , 0.00130790902786  ,
 0.00291326661264  , 0.00695247836286  , 0.0135411714167   , 0.0208284890339   ,
 0.0252513867451   , 0.024154588911    , 0.018251895895    , 0.0109041468781   ,
 0.00515292124481  , 0.00192616650368  , 0.000569269670212 , 0.000133004640439 ,
 3.51022040328e-05 , 1.63915437803e-05 , 7.71756138044e-05 , 0.000400872714111 ,
 0.00164503744131  , 0.00530339769874  , 0.0134501582863   , 0.0268745108898   ,
 0.0423647137504   , 0.0527524647508   , 0.0519328917937   , 0.0404398765102   ,
 0.0249084428442   , 0.0121297079785   , 0.00466598329029  , 0.00141649783698  ,
 0.000340871644554 , 7.36494962633e-05 , 4.44653481105e-05 , 9.96133965512e-05 ,
 0.000221547012008 , 0.000401677247816 , 0.000600059413312 , 0.000768691008966 ,
 0.000907761804312 , 0.00110405247812  , 0.00153844376055  , 0.00243717316347  ,
 0.00386938383584  , 0.00546086586098  , 0.00645183094383  , 0.00637279044589  ,
 0.00587068484533  , 0.0070055040622   , 0.013013481253    , 0.0278724477104   ,
 0.0554597335362   , 0.0974752157956   , 0.149537990307    , 0.197602128803    ,
 0.221177479992    , 0.206712318076    , 0.160418955466    , 0.104645528155    ,
 0.060231066862    , 0.0341906018402   , 0.0221644007771   , 0.0169373576297   ,
 0.0134689164564   , 0.0097555033794   , 0.00596156247553  , 0.0029710784774   ,
 0.00123715937215  , 0.000617928742087 , 0.000836805319545 , 0.00175506320578  ,
 0.00317253271185  , 0.0045324073261   , 0.00508960562776  , 0.00453963486158  ,
 0.00336989058355  , 0.00245589197159  , 0.00237976165502  , 0.00311195902859  ,
 0.00410663593316  , 0.00464274569699  , 0.00430721207387  , 0.00330611947232  ,
 0.00227331657462  , 0.00176643660384  , 0.00196123421663  , 0.00271050804353  ,
 0.00372931180774  , 0.00476212422557  , 0.00580713977321  , 0.00720930657081  ,
 0.00917520980351  , 0.0110272283629   , 0.0114039540006   , 0.0096030865538   ,
 0.00642285113355  , 0.00337790825301  , 0.00139605796489  , 0.000481016301856 ,
 0.000262724760544 , 0.000548714381896 , 0.00146127475521  , 0.00319031056447  ,
 0.00551222701193  , 0.00751327898565  , 0.00806630861691  , 0.00681103409906  ,
 0.00451658022397  , 0.00234894799764  , 0.00095691501315  , 0.000305033527729 ,
 7.60156866492e-05 , 1.47983259059e-05 , 2.2490871673e-06  , 2.66726068291e-07 ,
 2.46725447547e-08 , 1.77955695535e-09 , 1.00073018809e-10 , 4.45176886291e-12 ,
 5.47042608841e-13 , 3.40155210797e-12 , 2.84510467488e-11 , 1.96803661784e-10 ,
 1.0860085489e-09  , 4.76176891962e-09 , 1.66330040413e-08 , 4.65549701388e-08 ,
 1.05625414529e-07 , 1.99895404873e-07 , 3.44518242924e-07 , 6.91365399852e-07 ,
 2.16534837463e-06 , 9.30754495982e-06 , 4.11577292173e-05 , 0.000163182312599 ,
 0.000548413852285 , 0.00151783275422  , 0.00340325454254  , 0.00612496496253  ,
 0.0088043932371   , 0.0100856679077   , 0.00920616112539  , 0.00671516240291  ,
 0.00395277925098  , 0.00194405898399  , 0.000929982702988 , 0.000704085818733 ,
 0.00103644942462  , 0.0017178582274   , 0.00240538562057  , 0.00267481391243  ,
 0.00233205785781  , 0.00158952047744  , 0.000849520694073 , 0.000369368856196 ,
 0.000172177839704 , 0.000175005460569 , 0.000299432749886 , 0.000476271581104 ,
 0.0006236193951   , 0.000693387135272 , 0.000826351279197 , 0.00166385228848  ,
 0.00487870108887  , 0.0135881070988   , 0.031381512914    , 0.0587480872089   ,
 0.0888154718772   , 0.108201757288    , 0.105941014393    , 0.0831741578794   ,
 0.0525226611535   , 0.0275239566556   , 0.0138986093278   , 0.00973891295052  ,
 0.0104842392378   , 0.0123917005906   , 0.0132245129189   , 0.0120248523177   ,
 0.00907866153099  , 0.00562699881545  , 0.00304269318835  , 0.00227835367251  ,
 0.00414723334915  , 0.00957666097674  , 0.0185882457531   , 0.0285822894635   ,
 0.0346511967926   , 0.0331471509347   , 0.0250484985053   , 0.0149663177747   ,
 0.00707401939005  , 0.00264525288396  , 0.000782308950506 , 0.000182980834221 ,
 3.91180318618e-05 , 1.79892097036e-05 , 8.25345808455e-05 , 0.000424281770834 ,
 0.00172112100638  , 0.00547273063022  , 0.0136561064962   , 0.0267788743633   ,
 0.041328061296    , 0.0502719269816   , 0.0482641005067   , 0.0366125197291   ,
 0.0219623631711   , 0.0104213411503   , 0.00391147544851  , 0.00116213962307  ,
 0.000280763546722 , 8.79372792604e-05 , 0.0001384706373   , 0.0003684059802   ,
 0.000827453331077 , 0.001508563198    , 0.00227662092703  , 0.00296316519814  ,
 0.00355768006582  , 0.00431988212559  , 0.00578650433094  , 0.00862297198882  ,
 0.0130067804143   , 0.0177486880846   , 0.0204848795806   , 0.0196946210212   ,
 0.0168649300892   , 0.016491609033    , 0.0239250808749   , 0.0427164688391   ,
 0.0726655835146   , 0.109249486349    , 0.144417949931    , 0.167954636492    ,
 0.170221712207    , 0.147847422328    , 0.108419556846    , 0.0669449238897   ,
 0.0356667834361   , 0.0177239693661   , 0.0094807206089   , 0.00606677445864  ,
 0.00433224047355  , 0.00297451202394  , 0.00177562499722  , 0.000900766241546 ,
 0.000502236110778 , 0.000715160325102 , 0.00183187413371  , 0.0042065852036   ,
 0.00766151423477  , 0.0109377607466   , 0.0122376874263   , 0.0108132466229   ,
 0.00786773967236  , 0.00562118830667  , 0.00563238963306  , 0.00789724132229  ,
 0.0109495204276   , 0.0127215962716   , 0.0119204027164   , 0.0089524703179   ,
 0.00542317420742  , 0.00275893750684  , 0.00140633296022  , 0.0010855935718   ,
 0.00143351096687  , 0.00245336508459  , 0.00466689801169  , 0.00875735744666  ,
 0.0144775488843   , 0.0197117848206   , 0.0214397945337   , 0.0183949096214   ,
 0.0123833575999   , 0.00652605849635  , 0.00269926546685  , 0.000934727866411 ,
 0.000530053249644 , 0.00113859321692  , 0.00304039048168  , 0.00663893000938  ,
 0.0114708584627   , 0.0156350235826   , 0.0167858705582   , 0.014173662617    ,
 0.00939893756958  , 0.00488812652256  , 0.0019913261853   , 0.000634770322145 ,
 0.000158187535192 , 3.07951003695e-05 , 4.68031759173e-06 , 5.55053062134e-07 ,
 5.13432317661e-08 , 3.70335596315e-09 , 2.0872664584e-10  , 1.08450029764e-11 ,
 7.06618927784e-12 , 4.23108465458e-11 , 3.23347116385e-10 , 2.19659453619e-09 ,
 1.20887882513e-08 , 5.30444170091e-08 , 1.85633160612e-07 , 5.20790329038e-07 ,
 1.18320728692e-06 , 2.22465908266e-06 , 3.65729857507e-06 , 6.06963925445e-06 ,
 1.3021131985e-05  , 3.92340049252e-05 , 0.000137175567875 , 0.000469373303598 ,
 0.00144349038873  , 0.00379969588656  , 0.00829565532457  , 0.014733408614    ,
 0.0210557177507   , 0.0240873446134   , 0.0220421750505   , 0.0162165128051   ,
 0.00974998480854  , 0.00498915059706  , 0.00236253965933  , 0.00118718607356  ,
 0.00076007834181  , 0.000696150009372 , 0.0007702294401   , 0.000797497884788 ,
 0.000682142290575 , 0.000465914285538 , 0.000265451050287 , 0.000179661826171 ,
 0.000273455440408 , 0.000605750248775 , 0.00119693149163  , 0.00192553251579  ,
 0.00249939539023  , 0.00265788426121  , 0.00257084981605  , 0.00330272880173  ,
 0.00732386159935  , 0.0186773737627   , 0.0413157643875   , 0.07455367345     ,
 0.108759772837    , 0.128061501767    , 0.121551218024    , 0.0930107469756   ,
 0.0580458188884   , 0.0316421269632   , 0.0193324615922   , 0.0181255003782   ,
 0.0220756493941   , 0.0261642204379   , 0.0272965153335   , 0.0243036667803   ,
 0.0180738821698   , 0.0110535035106   , 0.00571056012097  , 0.00340487659797  ,
 0.00477035634547  , 0.0104132765931   , 0.0200885623945   , 0.0308724533657   ,
 0.0374299936709   , 0.0358132015901   , 0.0270743326956   , 0.0161889228949   ,
 0.0076623553491   , 0.00287233217739  , 0.000853253069706 , 0.000201183048115 ,
 4.0576820335e-05  , 1.81872377895e-05 , 7.6195148755e-05  , 0.000387528379727 ,
 0.00156089500912  , 0.00492145407548  , 0.0121558932015   , 0.023549667817    ,
 0.0358329031116   , 0.0428859312595   , 0.0404325234772   , 0.0300709921623   ,
 0.0176647923077   , 0.00820460731912  , 0.0030165448116   , 0.000884406174652 ,
 0.000232240958337 , 0.000153587253383 , 0.000397734373282 , 0.00108864294399  ,
 0.00244751402751  , 0.00448765889134  , 0.00685596828819  , 0.00910009324589  ,
 0.0111739772839   , 0.0136912289088   , 0.0179088004178   , 0.0253805423134   ,
 0.036435532115    , 0.0479776844348   , 0.0540389474675   , 0.0508316480324   ,
 0.0416967242445   , 0.036122414949    , 0.0435131915359   , 0.0668864980408   ,
 0.100265296657    , 0.131370613666    , 0.148505987329    , 0.146465731576    ,
 0.127194475696    , 0.0970649027534   , 0.0643248879245   , 0.0365864792143   ,
 0.0179318371812   , 0.00791566064684  , 0.00352980349631  , 0.00184358032912  ,
 0.00114252007829  , 0.000730201074965 , 0.000429410208094 , 0.000265309550891 ,
 0.000383240550919 , 0.00117400024182  , 0.00341511633712  , 0.0079330729495   ,
 0.0144620748954   , 0.0206469408404   , 0.0231011295265   , 0.0204296044003   ,
 0.0149613569951   , 0.0110123160328   , 0.0116851749185   , 0.0170165852335   ,
 0.0239772795163   , 0.0281192902688   , 0.0265385242882   , 0.0200169970158   ,
 0.0120452897571   , 0.00579759699239  , 0.00229571947971  , 0.000934981710779 ,
 0.000921684050826 , 0.00221389924163  , 0.00568071152473  , 0.0123393038586   ,
 0.0216001702706   , 0.0299820095647   , 0.0327774712708   , 0.0281295800481   ,
 0.0189141130235   , 0.00995349893571  , 0.00411287944857  , 0.00143093850158  ,
 0.000845155832175 , 0.001868713391    , 0.0050036009414   , 0.0109274633914   ,
 0.0188808228802   , 0.0257349742922   , 0.0276292488878   , 0.0233296004069   ,
 0.0154704866123   , 0.00804577063808  , 0.00327768802191  , 0.00104482083192  ,
 0.00026037391219  , 5.06881958182e-05 , 7.7037207938e-06  , 9.13607733452e-07 ,
 8.45107355203e-08 , 6.09882470536e-09 , 3.55443384278e-10 , 5.45290907542e-11 ,
 1.17821649004e-10 , 4.82678770058e-10 , 3.00713614745e-09 , 1.94439361642e-08 ,
 1.06015531641e-07 , 4.64919218823e-07 , 1.63002673409e-06 , 4.58599849056e-06 ,
 1.04481853321e-05 , 1.96275494303e-05 , 3.16373466782e-05 , 4.8000696311e-05  ,
 8.14822209186e-05 , 0.000177980734241 , 0.000468297926437 , 0.00128661657833  ,
 0.00337971981646  , 0.00803492415895  , 0.0165334904787   , 0.0284539797146   ,
 0.0400596764106   , 0.0456097189617   , 0.0418989944826   , 0.0313447661344   ,
 0.0196708479579   , 0.0110279559015   , 0.00601395271519  , 0.00332025500323  ,
 0.0017808843922   , 0.000895726107852 , 0.000454122712566 , 0.000266992365375 ,
 0.000178682868664 , 0.000123641755232 , 0.000123190541086 , 0.000276635007986 ,
 0.000784590580233 , 0.0019220445294   , 0.00382171830408  , 0.00612044039028  ,
 0.00788578408993  , 0.00821695778199  , 0.00722341379008  , 0.0066405087196   ,
 0.00987876694528  , 0.021499875308    , 0.0449998794729   , 0.0782202867306   ,
 0.110105131864    , 0.125149574206    , 0.11490363437     , 0.085596994051    ,
 0.0532382692039   , 0.031588019517    , 0.0248906349214   , 0.0292124322922   ,
 0.0375700940211   , 0.0439065340908   , 0.0446220342205   , 0.0388246162176   ,
 0.0283947199245   , 0.0171442565466   , 0.00860138840665  , 0.00434616798264  ,
 0.00449753111615  , 0.00894845467979  , 0.0170771257113   , 0.026226971959    ,
 0.0318200440864   , 0.0304905778936   , 0.0231134911467   , 0.0138896455123   ,
 0.00663385039246  , 0.00252766037128  , 0.000773039392835 , 0.000191852903736 ,
 6.27364840913e-05 , 2.33709364145e-05 , 6.02013697784e-05 , 0.000294259034911 ,
 0.00117928531378  , 0.00370153066699  , 0.00909299426659  , 0.0175001274897   ,
 0.0264194325133   , 0.0313295193598   , 0.0292263921806   , 0.021481058167    ,
 0.0124595315515   , 0.00571599427325  , 0.00208810538118  , 0.000635311792267 ,
 0.000239408120932 , 0.000339818389553 , 0.000966968719601 , 0.00258592785218  ,
 0.00577277224694  , 0.0106409970713   , 0.0165100719086   , 0.0224748115118   ,
 0.0284337989348   , 0.0355142186894   , 0.0459987905913   , 0.0627276948404   ,
 0.086051429194    , 0.109314458898    , 0.120172944054    , 0.111092529259    ,
 0.0888667204815   , 0.0713702314172   , 0.07434968299     , 0.100176847783    ,
 0.13591915994     , 0.161426992342    , 0.162556175108    , 0.139439334035    ,
 0.103322695957    , 0.0669868743075   , 0.0381995162071   , 0.01909867541     ,
 0.0083437743149   , 0.00323975258972  , 0.00120280468229  , 0.000495853499443 ,
 0.000252622379247 , 0.000146692399424 , 9.45728841835e-05 , 0.000130924513211 ,
 0.00046354169968  , 0.00169977554173  , 0.00502850019855  , 0.0116970416195   ,
 0.0213261266177   , 0.0304483511762   , 0.0340801147588   , 0.0302009655197   ,
 0.0223510250558   , 0.0171112986442   , 0.0193293481849   , 0.0291280248656   ,
 0.041568190543    , 0.0491119831021   , 0.0466519187828   , 0.0354022617934   ,
 0.0214087393799   , 0.0103027220865   , 0.0039715623592   , 0.00137923133339  ,
 0.00104890875346  , 0.00263735951261  , 0.00711042586172  , 0.0156100248664   ,
 0.0272050518989   , 0.0374417456262   , 0.0405780271386   , 0.034557593091    ,
 0.0230879827426   , 0.0120872273044   , 0.00497563331781  , 0.00173598946763  ,
 0.00106748056523  , 0.00242642982159  , 0.00651355301663  , 0.014227192509    ,
 0.0245824031516   , 0.033506367791    , 0.0359726723109   , 0.0303746249147   ,
 0.0201422321827   , 0.0104754158252   , 0.00426747747597  , 0.00136033366717  ,
 0.000339001088032 , 6.5994912476e-05  , 1.0030074832e-05  , 1.18949955303e-06 ,
 1.10045117136e-07 , 8.0050556781e-09  , 7.00710509137e-10 , 7.80061145675e-10 ,
 1.95944200202e-09 , 5.53984913287e-09 , 2.42898491714e-08 , 1.38984439151e-07 ,
 7.37378912004e-07 , 3.21862238427e-06 , 1.12960750778e-05 , 3.18763185888e-05 ,
 7.2887535858e-05  , 0.000137188024578 , 0.000219370889351 , 0.000318349480981 ,
 0.000473349032987 , 0.000821454030181 , 0.00167413381883  , 0.00362278357767  ,
 0.00769662614659  , 0.0154424172436   , 0.0282698200478   , 0.045357263966    ,
 0.0615418248284   , 0.0690412043971   , 0.0636636705014   , 0.0490345986823   ,
 0.0331355079715   , 0.0213098294612   , 0.0138194551176   , 0.00874369272702  ,
 0.00495522785786  , 0.00235909176777  , 0.000922487197235 , 0.000304516168875 ,
 9.93482118646e-05 , 6.7491980601e-05  , 0.000182456423823 , 0.000651479973196 ,
 0.00197654690022  , 0.00485343538588  , 0.00959930729972  , 0.0152760236535   ,
 0.0195430993889   , 0.0201245262872   , 0.0169533956947   , 0.0129156385159   ,
 0.0127227206391   , 0.0211268250004   , 0.0405588930735   , 0.0677152400898   ,
 0.0920922908799   , 0.10112257859     , 0.0897969744501   , 0.0652383044749   ,
 0.0411342825066   , 0.0281567208254   , 0.028917778826    , 0.0390268993664   ,
 0.0510436011201   , 0.0584412267736   , 0.0577961644483   , 0.0490826957177   ,
 0.0352550145313   , 0.0210115444189   , 0.0103321475094   , 0.0046726624058   ,
 0.00354406157996  , 0.00610288029292  , 0.0114369594608   , 0.0175805612618   ,
 0.0214395670998   , 0.0207453067149   , 0.0160081777169   , 0.00993105323865  ,
 0.00501431403131  , 0.00209734897126  , 0.000743286443176 , 0.000228419143498 ,
 0.000174912075759 , 5.50613209319e-05 , 4.68841762528e-05 , 0.000182653660832 ,
 0.000723253075717 , 0.00226430596689  , 0.00554750950987  , 0.0106419849125   ,
 0.016003269847    , 0.0188902486703   , 0.0175299730527   , 0.0128146475462   ,
 0.00740662613366  , 0.00342418049909  , 0.00133281058158  , 0.000554192146443 ,
 0.000455266330452 , 0.000837638532068 , 0.00207211727677  , 0.00511108265396  ,
 0.0111159722455   , 0.0205292441406   , 0.032488172853    , 0.0457249162419   ,
 0.0601315948392   , 0.0772405021632   , 0.100112800137    , 0.132656538408    ,
 0.174681959007    , 0.214285012272    , 0.230395150878    , 0.210784024587    ,
 0.167306310144    , 0.128936475835    , 0.119378896897    , 0.140497922306    ,
 0.172634392458    , 0.189466125563    , 0.176521069169    , 0.138915842956    ,
 0.0932983155246   , 0.0542732569237   , 0.0276976508823   , 0.01246527283     ,
 0.00492958347659  , 0.00170643843391  , 0.000526946876774 , 0.000158318732508 ,
 5.55089277618e-05 , 2.69674996142e-05 , 2.98911091095e-05 , 0.000113582020798 ,
 0.000520500610814 , 0.00195697632575  , 0.00580051947398  , 0.0134932471359   ,
 0.0245987693059   , 0.0351207506553   , 0.0393263340092   , 0.034939684468    ,
 0.0261955948938   , 0.0209921095295   , 0.0253067518525   , 0.0393790529807   ,
 0.0568401164944   , 0.0676004153348   , 0.0645912210728   , 0.049299775273    ,
 0.0299852277327   , 0.0145113923939   , 0.00561854356519  , 0.00193414479232  ,
 0.00136748038207  , 0.00323118796817  , 0.00837640302242  , 0.0177387452893   ,
 0.0299173480659   , 0.0400059561826   , 0.04230234786     , 0.0352892642523   ,
 0.0231774754033   , 0.0119660919746   , 0.00487181086091  , 0.00169299229233  ,
 0.00107261062599  , 0.00249229346167  , 0.00670437620232  , 0.0146458445522   ,
 0.0253059510791   , 0.034492593581    , 0.0370314920602   , 0.0312686717554   ,
 0.0207350987329   , 0.0107837492606   , 0.00439308642695  , 0.00140037373469  ,
 0.000348979248127 , 6.7937408326e-05  , 1.03253066738e-05 , 1.22455308428e-06 ,
 1.13516691384e-07 , 9.29145199473e-09 , 4.53206292461e-09 , 1.19185074055e-08 ,
 2.87242881961e-08 , 6.45635944779e-08 , 1.87523561535e-07 , 8.35701266865e-07 ,
 4.12587292218e-06 , 1.77222124783e-05 , 6.20755801051e-05 , 0.000175581135938 ,
 0.000403058870437 , 0.000761220174174 , 0.00121439795784  , 0.00172172725889  ,
 0.00237184985624  , 0.00353643216094  , 0.0059308821562   , 0.0104940351913   ,
 0.0181476598579   , 0.029651963737    , 0.0453187224804   , 0.0636605033718   ,
 0.0796000681728   , 0.0859117595828   , 0.0791993595746   , 0.0639532926195   ,
 0.0483768077116   , 0.0367631169612   , 0.0278580371657   , 0.0194042028243   ,
 0.0114955422013   , 0.00554771966291  , 0.00214044481287  , 0.000657857880644 ,
 0.000173156284028 , 0.00010562818977  , 0.000350905698522 , 0.00130471995264  ,
 0.00395719876462  , 0.0096601414456   , 0.0189735855442   , 0.0299725205329   ,
 0.0380523013308   , 0.0388199311402   , 0.0320100203713   , 0.0222671896149   ,
 0.0161088774058   , 0.01841415815     , 0.0303815092357   , 0.0481979790434   ,
 0.0634053989976   , 0.0674232477929   , 0.0580367721705   , 0.0413625074447   ,
 0.0271765716085   , 0.0225979635379   , 0.028953887279    , 0.0420982556396   ,
 0.0550204987893   , 0.061626948752    , 0.0593355317041   , 0.0491665561648   ,
 0.0346555940989   , 0.0203846073778   , 0.00987905366958  , 0.00416744142245  ,
 0.00238940730599  , 0.00335337082721  , 0.00613229267912  , 0.00957066750224  ,
 0.0120675698717   , 0.0123860788318   , 0.0105489974628   , 0.00763196970832  ,
 0.00478706535037  , 0.00262500779544  , 0.00124988236564  , 0.000508783243028 ,
 0.000534631776676 , 0.000165034434016 , 5.75961489716e-05 , 9.66648866778e-05 ,
 0.000355693705695 , 0.0011089597933   , 0.00271320964361  , 0.00519701794028  ,
 0.00780154818796  , 0.00919246114113  , 0.00852362591091  , 0.00626018146013  ,
 0.00372622115488  , 0.00196055125086  , 0.00117443861456  , 0.00107678424524  ,
 0.00141305042557  , 0.00228637878576  , 0.00438647643308  , 0.00920525265429  ,
 0.0187294169383   , 0.0342432837009   , 0.0554143129212   , 0.081227988436    ,
 0.11164663007     , 0.147868523937    , 0.192384071532    , 0.248731440274    ,
 0.315019360776    , 0.373384095186    , 0.393958008442    , 0.360213992742    ,
 0.289176711935    , 0.220498379521    , 0.185919413658    , 0.188551938492    ,
 0.20543362722     , 0.207806820026    , 0.182641886781    , 0.138026310614    ,
 0.0910144219857   , 0.0535226067055   , 0.0284484060546   , 0.0135808928614   ,
 0.00568589895174  , 0.00202891462779  , 0.000604178079642 , 0.000149700570981 ,
 3.2335760364e-05  , 9.03889754818e-06 , 1.81410633709e-05 , 9.92204687022e-05 ,
 0.000472139797165 , 0.00177864460927  , 0.00526776099309  , 0.0122434552159   ,
 0.0223046766653   , 0.0318302080799   , 0.0356462428432   , 0.0317583702545   ,
 0.0241728072761   , 0.0203780710657   , 0.0262080330379   , 0.0419895130428   ,
 0.0612289087126   , 0.0732713825774   , 0.0704223203998   , 0.0540993041558   ,
 0.0331601743175   , 0.016219322383    , 0.00640911015945  , 0.00235987748857  ,
 0.00186603559001  , 0.00418154165001  , 0.0100349430511   , 0.0198993924869   ,
 0.0316476848831   , 0.0401157261499   , 0.0404134713187   , 0.0322908562154   ,
 0.0204243914087   , 0.0102098334282   , 0.0040450295696   , 0.00137480807668  ,
 0.000866176756658 , 0.00202481361433  , 0.00545194214859  , 0.0119107216696   ,
 0.0205801395164   , 0.0280512114181   , 0.0301159791537   , 0.0254293471636   ,
 0.0168628852659   , 0.00876991852962  , 0.0035726915746   , 0.00113885842408  ,
 0.000283808504601 , 5.52503429959e-05 , 8.39719238984e-06 , 9.96453155689e-07 ,
 9.54205884104e-08 , 2.12650561358e-08 , 5.25377645849e-08 , 1.49742770382e-07 ,
 3.49936167375e-07 , 7.03792554826e-07 , 1.48532658496e-06 , 4.56998038626e-06 ,
 1.91618992352e-05 , 7.86849094419e-05 , 0.000272740848623 , 0.000771166095374 ,
 0.00177593476422  , 0.00336705988152  , 0.00537434496979  , 0.00752406953044  ,
 0.00989802309562  , 0.0133514154404   , 0.0194138598948   , 0.0294507945761   ,
 0.0434556487411   , 0.0595865701801   , 0.0751671769527   , 0.0878061090416   ,
 0.0950022253094   , 0.0941261145647   , 0.0852641628887   , 0.0732308164175   ,
 0.0635349516253   , 0.0564316650924   , 0.0477185600313   , 0.035143396574    ,
 0.02132982432     , 0.0103968248069   , 0.00402500638918  , 0.00123389129349  ,
 0.00031704478715  , 0.000174200614962 , 0.000560366647417 , 0.00207496629427  ,
 0.00625642163867  , 0.0151649974187   , 0.0295520201591   , 0.0462946564493   ,
 0.0582711806347   , 0.0589036522297   , 0.0479066133137   , 0.0319028386502   ,
 0.0192699848886   , 0.0149834861977   , 0.0192023781547   , 0.0281325358707   ,
 0.0357373020172   , 0.036916225247    , 0.0309350231009   , 0.02185467783     ,
 0.0155057294107   , 0.0160238701159   , 0.023999064817    , 0.0361647617742   ,
 0.0469064807225   , 0.051459869528    , 0.048332569765    , 0.0391308780507   ,
 0.0271013474884   , 0.0157704632442   , 0.00758499097725  , 0.00308610300353  ,
 0.00143249472581  , 0.00158626168728  , 0.00291145287315  , 0.00500400604923  ,
 0.00738703310646  , 0.00945355806801  , 0.0105512201683   , 0.0101700341626   ,
 0.00830494151108  , 0.00564109448856  , 0.00314849071783  , 0.00143579761195  ,
 0.00140151741893  , 0.000443564407633 , 0.000120489624778 , 5.81846613738e-05 ,
 0.00014180527682  , 0.000431509839011 , 0.00105409439379  , 0.00201803381596  ,
 0.00302973496022  , 0.00358091939651  , 0.00337473227936  , 0.00265853202703  ,
 0.00203564767867  , 0.00196028236875  , 0.00247013457001  , 0.00337280230027  ,
 0.00462170340403  , 0.00657337402696  , 0.0102423321883   , 0.0177530609709   ,
 0.0323493899951   , 0.057129537608    , 0.0935501961575   , 0.141604378444    ,
 0.200785592518    , 0.270069244894    , 0.348737350432    , 0.43729919592     ,
 0.530632101043    , 0.606044909783    , 0.62828578013     , 0.578493364282    ,
 0.476198398653    , 0.366835159409    , 0.288933839371    , 0.251665536456    ,
 0.236311810966    , 0.216867558402    , 0.181805479873    , 0.137797461902    ,
 0.0965838471659   , 0.0637162507736   , 0.0389489784855   , 0.0211451344085   ,
 0.00975893539309  , 0.00371189786628  , 0.00114246342363  , 0.000281873749805 ,
 5.57658982691e-05 , 1.04655042891e-05 , 1.35213105952e-05 , 7.4404011826e-05  ,
 0.000352736921698 , 0.00132006726682  , 0.00388636228749  , 0.00898742136768  ,
 0.0163050997131   , 0.0231917680711   , 0.0259164590881   , 0.0231145656525   ,
 0.0178449417885   , 0.0157932781516   , 0.0215038358815   , 0.0353102336465   ,
 0.0519853257373   , 0.0626728857029   , 0.0607787118676   , 0.047282774612    ,
 0.0295462947816   , 0.0149398358818   , 0.00635526221889  , 0.00289269718663  ,
 0.00290346231259  , 0.005976100275    , 0.0128415860829   , 0.0234692557411   ,
 0.0348462710205   , 0.0414138316943   , 0.0391799220018   , 0.029445118423    ,
 0.0175641246395   , 0.00831256432154  , 0.00313145121688  , 0.00100724554881  ,
 0.00057811348468  , 0.00130237119066  , 0.00349890342166  , 0.00764331252202  ,
 0.013206584321    , 0.0180008811997   , 0.0193258733956   , 0.0163183916954   ,
 0.0108211652501   , 0.00562778774528  , 0.00229264970839  , 0.000730822734691 ,
 0.000182124531101 , 3.54555296405e-05 , 5.39005145003e-06 , 6.46126000229e-07 ,
 9.47101770752e-08 , 1.57388105955e-07 , 5.36069188363e-07 , 1.51238379081e-06 ,
 3.46220716465e-06 , 6.61304929924e-06 , 1.16838629415e-05 , 2.49577309625e-05 ,
 7.86581226076e-05 , 0.000289954095845 , 0.000973393356741 , 0.00273002929094  ,
 0.0062880297613   , 0.0119566288341   , 0.0191141620863   , 0.0265728275657   ,
 0.0339456085284   , 0.0427818407532   , 0.0559993740304   , 0.075424073985    ,
 0.0989808577352   , 0.120239573209    , 0.131923997466    , 0.130897615466    ,
 0.119666834884    , 0.103661739383    , 0.0886189932312   , 0.0793257202105   ,
 0.07672342194     , 0.0754083504251   , 0.0676108154766   , 0.0511428748666   ,
 0.0313978247329   , 0.0153842745663   , 0.00597254770203  , 0.001834212457    ,
 0.000468686610116 , 0.000234920670175 , 0.00071150668055  , 0.00261017252518  ,
 0.00781615779412  , 0.0187998599985   , 0.0363202724647   , 0.0563708646913   ,
 0.0702728188296   , 0.0703363005937   , 0.0565480592866   , 0.0367735242329   ,
 0.0202516689172   , 0.0116947991903   , 0.0105834047603   , 0.0134959844768   ,
 0.0163976953561   , 0.0164917805294   , 0.01352919441     , 0.0096147969706   ,
 0.00764370949057  , 0.00970849240355  , 0.0160583586445   , 0.0245883922323   ,
 0.0316153893175   , 0.0341159350834   , 0.0314652986187   , 0.0251229710536   ,
 0.0173298247951   , 0.0101796016218   , 0.0050115183198   , 0.00208505694133  ,
 0.000891426947803 , 0.000852970885209 , 0.00180203875809  , 0.00401623445203  ,
 0.00783496355459  , 0.0129052444677   , 0.0175908842841   , 0.0195735092242   ,
 0.0176454034655   , 0.0128533057674   , 0.00756976845451  , 0.00361301201476  ,
 0.00300690958145  , 0.000980164782209 , 0.000261143390599 , 6.60260865093e-05 ,
 5.19331413539e-05 , 0.000133813577099 , 0.000324350691142 , 0.000622204800715 ,
 0.000943261641283 , 0.00116027388528  , 0.00127272225251  , 0.00155605967615  ,
 0.00247375465681  , 0.00433050862962  , 0.00698757657499  , 0.0100738990619   ,
 0.0136147631996   , 0.0184660648905   , 0.0265364786891   , 0.0414436796367   ,
 0.0689784768244   , 0.115610133575    , 0.185484253539    , 0.278600815412    ,
 0.390784933993    , 0.514594729544    , 0.642323350659    , 0.768581257866    ,
 0.884097905677    , 0.964587642655    , 0.976009984057    , 0.900966823485    ,
 0.757861222563    , 0.591204382563    , 0.445127318183    , 0.341434316071    ,
 0.274311588783    , 0.224758306277    , 0.180831549591    , 0.142440031692    ,
 0.111101810698    , 0.0837521204865   , 0.0574056124459   , 0.0337111773111   ,
 0.0163213226591   , 0.00638147377286  , 0.00199398151014  , 0.000495308036705 ,
 9.76979557249e-05 , 1.65563410979e-05 , 1.16638054516e-05 , 5.6988486492e-05  ,
 0.000260961553263 , 0.000947316441799 , 0.00271465693783  , 0.00613252458704  ,
 0.0109063833016   , 0.0152566364956   , 0.0168175242882   , 0.0148418993466   ,
 0.0114053853811   , 0.0101946691358   , 0.014148571464    , 0.023541996764    ,
 0.0350683505198   , 0.0429687150654   , 0.0427498044629   , 0.0346627182284   ,
 0.0231705806505   , 0.0131324667714   , 0.00694153177658  , 0.00462611551699  ,
 0.00548227866977  , 0.00942997030189  , 0.0170983957981   , 0.0281168183088   ,
 0.038967816453    , 0.0438768019653   , 0.039482997468    , 0.0282145019325   ,
 0.0159840099871   , 0.0071825442524   , 0.00256980947503  , 0.000768576261235 ,
 0.000346899813442 , 0.000667857625579 , 0.00177054305908  , 0.00386503792283  ,
 0.00667800372361  , 0.00910225559459  , 0.00977224491336  , 0.00825149378964  ,
 0.0054717885938   , 0.00284572694644  , 0.00115929574834  , 0.000369550139522 ,
 9.20991973814e-05 , 1.79376067565e-05 , 2.74377953739e-06 , 3.91907338357e-07 ,
 3.42776060457e-07 , 1.296615092e-06   , 4.42793877671e-06 , 1.22794155344e-05 ,
 2.76362006066e-05 , 5.13549635862e-05 , 8.34464322521e-05 , 0.000139720046261 ,
 0.00031286430601  , 0.00093897208274  , 0.00291328896667  , 0.00795165093087  ,
 0.0181658326199   , 0.0345138762089   , 0.0552072140742   , 0.0764080366574   ,
 0.0956866482141   , 0.114943567636    , 0.139014906212    , 0.170274297312    ,
 0.203722390933    , 0.227464176672    , 0.229724026743    , 0.207614993197    ,
 0.169843381144    , 0.130734660431    , 0.101916933797    , 0.088119995648    ,
 0.0862125744437   , 0.0863787589657   , 0.0783027745006   , 0.0595188576998   ,
 0.036627040122    , 0.0179774124563   , 0.00699446387959  , 0.00215960937842  ,
 0.000560079718219 , 0.000265002220691 , 0.000725373296255 , 0.0026034284415   ,
 0.00772458335734  , 0.0184235222427   , 0.0352653261312   , 0.0541838011268   ,
 0.0668313804085   , 0.0661666325919   , 0.0525886411175   , 0.033646692389    ,
 0.0176769543869   , 0.00850538601361  , 0.00532810130083  , 0.00539020342098  ,
 0.00610418703096  , 0.00597137154204  , 0.00482459177273  , 0.00351231005532  ,
 0.00322501754139  , 0.00487428244646  , 0.00857038133765  , 0.0132412697134   ,
 0.0169954662104   , 0.0183617547455   , 0.0171903089484   , 0.0142949898662   ,
 0.0106298755867   , 0.0069811888481   , 0.00396951899018  , 0.00194000346362  ,
 0.000913204592396 , 0.000831751787154 , 0.00198619799854  , 0.00526311062919  ,
 0.011691113234    , 0.021020942753    , 0.0304088941495   , 0.0353490228929   ,
 0.0330508518819   , 0.0249104429513   , 0.0151778265915   , 0.00749640162375  ,
 0.00522783128729  , 0.00175061030827  , 0.000474962514705 , 0.000106757667318 ,
 2.91863162928e-05 , 3.60161485974e-05 , 8.29208508461e-05 , 0.000164417086177 ,
 0.000277140100219 , 0.000462477126379 , 0.000946251678132 , 0.00230139023627  ,
 0.00537293954429  , 0.0107321168325   , 0.0180698581437   , 0.026578717199    ,
 0.0364891611274   , 0.0503382448489   , 0.0732724573356   , 0.11350485613     ,
 0.182479038828    , 0.291705203851    , 0.446092431182    , 0.638808061431    ,
 0.851928870168    , 1.06250502089     , 1.25091239551     , 1.40500895389     ,
 1.51375681567     , 1.55763177795     , 1.513304864       , 1.372410385       ,
 1.15373249577     , 0.898761796397    , 0.656768331046    , 0.464471475006    ,
 0.331052649696    , 0.24399837665     , 0.188183166073    , 0.153820451509    ,
 0.130718268352    , 0.107124864953    , 0.0777175855011   , 0.0471497592298   ,
 0.0232271993039   , 0.00916220421308  , 0.00287454788291  , 0.000714913021047 ,
 0.000140893831648 , 2.36292956178e-05 , 1.47517961127e-05 , 6.64750654533e-05 ,
 0.000287201257352 , 0.000984664797522 , 0.00267037287033  , 0.00572854794483  ,
 0.00971764602589  , 0.0130294378473   , 0.0138209272334   , 0.0117161017477   ,
 0.0084211277757   , 0.00654120917552  , 0.00793881290135  , 0.0128297465852   ,
 0.0195937511831   , 0.0253658682125   , 0.0275884972329   , 0.0255270650036   ,
 0.0204523560584   , 0.0147019501547   , 0.0105936239463   , 0.00953015434448  ,
 0.0116156894769   , 0.0163417277126   , 0.0235884045569   , 0.0329384173526   ,
 0.0415685201981   , 0.0445311403119   , 0.0389688392348   , 0.0273668853949   ,
 0.0153338979293   , 0.00685720406524  , 0.00245847203812  , 0.000724225716228 ,
 0.000237665254561 , 0.000285191567879 , 0.000707544929604 , 0.00153813157923  ,
 0.00265691509252  , 0.00362137413184  , 0.00388792995155  , 0.00328289635164  ,
 0.00217698787925  , 0.00113221418362  , 0.00046128238493  , 0.000147102314833 ,
 3.67399082852e-05 , 7.26411784097e-06 , 1.29901513415e-06 , 7.12332915472e-07 ,
 2.2923001997e-06  , 8.8994073193e-06  , 2.95693614057e-05 , 8.04021648455e-05 ,
 0.000178020844102 , 0.000324777131193 , 0.000507271650592 , 0.000750237625521 ,
 0.00128141881338  , 0.0029167437958   , 0.00776458478393  , 0.0198259769588   ,
 0.0440663067325   , 0.0828565310565   , 0.132039256186    , 0.181885610807    ,
 0.224404544579    , 0.260067401295    , 0.295745442973    , 0.335046192286    ,
 0.370834293416    , 0.387538303181    , 0.371660209014    , 0.322363173907    ,
 0.253742776644    , 0.186379398653    , 0.135622416426    , 0.106206013374    ,
 0.0934184487091   , 0.0865774492584   , 0.0751518896459   , 0.0559426107075   ,
 0.0341156283675   , 0.0167040471408   , 0.0065332679656   , 0.00208076446696  ,
 0.000614440828509 , 0.000322763702056 , 0.000653359912545 , 0.00209650287087  ,
 0.00605961382933  , 0.0142880532072   , 0.0270761244339   , 0.0411577112003   ,
 0.0501860471998   , 0.049098902052    , 0.0385499033529   , 0.0243213451689   ,
 0.0124361396921   , 0.00542304286424  , 0.00252538382871  , 0.00184614110689  ,
 0.00184698704876  , 0.00174293369159  , 0.00139440568687  , 0.00106162765618  ,
 0.00114756006763  , 0.00199149286601  , 0.00365989779248  , 0.00578354998675  ,
 0.00773796710271  , 0.00915098709909  , 0.0100745290627   , 0.0105066899249   ,
 0.0100497698665   , 0.00837435861779  , 0.00584112143668  , 0.0033505807993   ,
 0.00167680159865  , 0.00123629438404  , 0.00258932707972  , 0.00701979718456  ,
 0.0161173473633   , 0.0298059889319   , 0.0442558050578   , 0.0528317789866   ,
 0.0508181548183   , 0.0394789660974   , 0.0248232382582   , 0.0126508548612   ,
 0.00733974124746  , 0.00252297769308  , 0.00070525964173  , 0.000163693162758 ,
 3.64695689508e-05 , 1.97297706565e-05 , 4.01252021679e-05 , 9.88312376076e-05 ,
 0.000241351781804 , 0.000636543423684 , 0.00181538625175  , 0.00500264159119  ,
 0.0120852489671   , 0.0246684229067   , 0.0428557077045   , 0.0659101323306   ,
 0.0956501612264   , 0.139882035167    , 0.213079739277    , 0.334954872478    ,
 0.527153603364    , 0.804827398719    , 1.16326859549     , 1.56928984586     ,
 1.96798937065     , 2.30331793357     , 2.53832464457     , 2.66019746574     ,
 2.66860369837     , 2.5634826746      , 2.34747473664     , 2.03608570551     ,
 1.66084725527     , 1.26656362694     , 0.904963494541    , 0.617386094038    ,
 0.416177311346    , 0.28774959134     , 0.212022871109    , 0.171696327919    ,
 0.148338946585    , 0.123961403783    , 0.0910608530996   , 0.0555705525895   ,
 0.0274242264759   , 0.0108117653336   , 0.00338551727076  , 0.000839595515486 ,
 0.000164985754118 , 2.85140083834e-05 , 2.35495720257e-05 , 0.000109656495237 ,
 0.000461095850786 , 0.00153319722688  , 0.00402598840297  , 0.0083564844261   ,
 0.0137188413065   , 0.0178181001261   , 0.01831428022     , 0.0149416714305   ,
 0.00987744894658  , 0.00593140622196  , 0.00473725291266  , 0.00649562329969  ,
 0.0106142901064   , 0.0161116739473   , 0.0215336008174   , 0.024932168291    ,
 0.0247931663687   , 0.021736662456    , 0.0188699278371   , 0.0193778510948   ,
 0.0236155477899   , 0.0292905634603   , 0.0344744733212   , 0.0390823683547   ,
 0.0427049693549   , 0.0427950025389   , 0.0370157885707   , 0.0265823936647   ,
 0.0155877282162   , 0.0074343989343   , 0.00288852391977  , 0.000920480421883 ,
 0.000259556158971 , 0.000129278471257 , 0.000228173354373 , 0.000481760995799 ,
 0.000830591118626 , 0.00113195996713  , 0.00121528497539  , 0.00102621144665  ,
 0.000680635145701 , 0.00035424736075  , 0.000144779537249 , 4.68395013125e-05 ,
 1.2594101654e-05  , 3.68610524511e-06 , 2.4651333704e-06  , 4.49938251136e-06 ,
 1.41452539193e-05 , 5.03762088113e-05 , 0.00016074330956  , 0.000426782487123 ,
 0.00092882617855  , 0.00166956597785  , 0.00255460636453  , 0.00357488161258  ,
 0.00524193273441  , 0.00933123638298  , 0.0200933350931   , 0.0452915715161   ,
 0.0944872088457   , 0.172338724328    , 0.270759649686    , 0.369664594222    ,
 0.449842852261    , 0.506345348687    , 0.547439219761    , 0.580307722321    ,
 0.599898211763    , 0.592191199383    , 0.546662595409    , 0.466162742407    ,
 0.367422595951    , 0.271999993478    , 0.194966164891    , 0.140794039527    ,
 0.106158958994    , 0.0833962663716   , 0.0642353922067   , 0.0446521144526   ,
 0.026334402952    , 0.0127940389539   , 0.00518472377486  , 0.00197618051714  ,
 0.000968761130959 , 0.000728584088978 , 0.000812319446625 , 0.00155337344401  ,
 0.0038670361341   , 0.00880695883866  , 0.0164568257923   , 0.0247265510127   ,
 0.0297879303061   , 0.0287738100264   , 0.0222971267113   , 0.0138737836623   ,
 0.00695914918941  , 0.00287944161471  , 0.00110757163718  , 0.000566740525433 ,
 0.000459622552035 , 0.000409009444128 , 0.000325083152459 , 0.000264850699558 ,
 0.000341083123719 , 0.00066871847888  , 0.00132334587126  , 0.00235424046013  ,
 0.00393114711306  , 0.00643428127566  , 0.0100248617389   , 0.0138331481202   ,
 0.0159560212671   , 0.0149220173523   , 0.0111665422751   , 0.00667056706656  ,
 0.00329438968464  , 0.00189383356093  , 0.0029847702676   , 0.00781701665807  ,
 0.0182136902242   , 0.0343968222822   , 0.0523140721507   , 0.0641486542069   ,
 0.0635217744548   , 0.050863375922    , 0.0329604454303   , 0.0172892740322   ,
 0.00835898210639  , 0.00299173167822  , 0.000901947179309 , 0.000247780647686 ,
 7.94399352944e-05 , 6.07587989783e-05 , 0.000126709423315 , 0.000325848298075 ,
 0.000806545316117 , 0.00196612789643  , 0.00490736799146  , 0.0121609969591   ,
 0.0279444076081   , 0.0569422780566   , 0.102435768553    , 0.167456115162    ,
 0.261189766347    , 0.406141834323    , 0.638395983369    , 0.998840833502    ,
 1.51861442474     , 2.20044619966     , 2.99875019293     , 3.81257858968     ,
 4.50924627791     , 4.97412432539     , 5.15325109886     , 5.05752932257     ,
 4.73336665128     , 4.23443613367     , 3.61653885466     , 2.94196311901     ,
 2.27443766344     , 1.66992521732     , 1.17067358015     , 0.796166772555    ,
 0.536852540668    , 0.365880841664    , 0.258595328984    , 0.196602010984    ,
 0.159964093922    , 0.12834299427     , 0.092021045121    , 0.0553061230239   ,
 0.0269945851438   , 0.010546745111    , 0.00327610210172  , 0.000806384936253 ,
 0.000157524104528 , 2.89318254382e-05 , 3.53553616506e-05 , 0.000172919328052 ,
 0.000723404764762 , 0.00238871099102  , 0.00622469159582  , 0.0128154515555   ,
 0.0208625982623   , 0.0268658748635   , 0.0273690438088   , 0.0220647527827   ,
 0.0141443763887   , 0.00747624167702  , 0.00406546502842  , 0.00412397488281  ,
 0.00748733090222  , 0.0140798026892   , 0.0227968397654   , 0.0304948751277   ,
 0.0336212007186   , 0.032026731622    , 0.030265489399    , 0.0333657558581   ,
 0.0412278114287   , 0.0485652989391   , 0.0508247021428   , 0.0486610728512   ,
 0.045448933722    , 0.0421047847502   , 0.0366293902554   , 0.0279418712405   ,
 0.0179030673001   , 0.00944142159865  , 0.0040597749966   , 0.00141607266388  ,
 0.000403154660715 , 0.00010908635597  , 6.99904632984e-05 , 0.000120167988042 ,
 0.000203942751451 , 0.000277694507762 , 0.000298268392467 , 0.000252318170938 ,
 0.000168497300872 , 9.00863989315e-05 , 4.09325624664e-05 , 1.92608322991e-05 ,
 1.30781734182e-05 , 1.35105487704e-05 , 1.79146999349e-05 , 3.09087485433e-05 ,
 7.71882016956e-05 , 0.00023985743913  , 0.000720005484068 , 0.00185207283343  ,
 0.00395184644025  , 0.00700813778953  , 0.0106011504115   , 0.0145140566495   ,
 0.0198896056345   , 0.0304364572047   , 0.0538380863277   , 0.102920933969    ,
 0.192898423435    , 0.330872752263    , 0.502952027156    , 0.673941465174    ,
 0.806460152131    , 0.883951017878    , 0.914645070509    , 0.914312231145    ,
 0.888818178313    , 0.833675454992    , 0.745495674039    , 0.630725705885    ,
 0.505075251676    , 0.385581819323    , 0.282725748092    , 0.199788258797    ,
 0.136664868659    , 0.0911846683945   , 0.059033749459    , 0.0359144030146   ,
 0.0196814713551   , 0.00963354732924  , 0.0047058170142   , 0.00303078058571  ,
 0.00269437283655  , 0.00246969845184  , 0.00203506497766  , 0.00177207022486  ,
 0.00238229006745  , 0.00446019018208  , 0.00796287593747  , 0.0117633718958   ,
 0.0139859439059   , 0.0133301672999   , 0.0101867436119   , 0.00624758986401  ,
 0.00308219876031  , 0.00123610257252  , 0.000426896296876 , 0.000161501686762 ,
 9.6666204772e-05  , 7.7351349131e-05  , 6.101309685e-05   , 5.48768389384e-05 ,
 8.74909264333e-05 , 0.000208472481294 , 0.000530324276027 , 0.00136095644244  ,
 0.00339414585281  , 0.00758707860806  , 0.0142059930295   , 0.0215060005329   ,
 0.0259433606408   , 0.0248124642629   , 0.0187899827425   , 0.011281565708    ,
 0.00547351380245  , 0.00262530844979  , 0.00290582570182  , 0.0070375749523   ,
 0.0165898981581   , 0.0320621797558   , 0.0500801868775   , 0.063204625803    ,
 0.0644810282766   , 0.0531825405528   , 0.0354593069664   , 0.0191196081163   ,
 0.00801673166456  , 0.00321944435451  , 0.00122654904199  , 0.00050424316318  ,
 0.000271494674662 , 0.000278452335642 , 0.000556287019275 , 0.00134747292183  ,
 0.00315920347129  , 0.00705901328663  , 0.015577520672    , 0.0342714006377   ,
 0.0728794494643   , 0.144519089489    , 0.263980659765    , 0.450439371091    ,
 0.738006924296    , 1.18585716187     , 1.87101859251     , 2.85750256608     ,
 4.15668811741     , 5.69877837508     , 7.32248863881     , 8.78960567793     ,
 9.84096719341     , 10.2883158509     , 10.0878527149     , 9.33776986845     ,
 8.2083278299      , 6.87185581544     , 5.47867305252     , 4.1600862318      ,
 3.02061635072     , 2.11895017054     , 1.45991174624     , 1.00458509289     ,
 0.693870205533    , 0.476905604438    , 0.326050233561    , 0.227795450229    ,
 0.166237562343    , 0.121725471189    , 0.0821150013995   , 0.0474671909176   ,
 0.0225580093718   , 0.00863704169352  , 0.00263879923337  , 0.000640295474298 ,
 0.000123759572327 , 2.49117099143e-05 , 4.42819997278e-05 , 0.000223836353564 ,
 0.000936034008486 , 0.00308711322832  , 0.00803388440873  , 0.0165164682799   ,
 0.0268472252958   , 0.0345195803641   , 0.0351096965499   , 0.0282442421037   ,
 0.0179991116052   , 0.00924498393847  , 0.0044171000513   , 0.00370913900997  ,
 0.00701751767073  , 0.0145556936406   , 0.0252618241218   , 0.0353147845389   ,
 0.0402029288515   , 0.0397345462308   , 0.0397459521976   , 0.0464293791636   ,
 0.0587178841908   , 0.0682556793182   , 0.068082401496    , 0.0598452815318   ,
 0.050738871323    , 0.0448374813257   , 0.0400082556265   , 0.0326426317826   ,
 0.0225975720655   , 0.0128043504303   , 0.00584875066398  , 0.00213854186367  ,
 0.00062407969146  , 0.000147919478631 , 3.68085824574e-05 , 2.65812634029e-05 ,
 3.98739917662e-05 , 5.41971177663e-05 , 5.94211435338e-05 , 5.37768302178e-05 ,
 4.44591880119e-05 , 4.11046571469e-05 , 4.73761231654e-05 , 5.97281964886e-05 ,
 7.41254260306e-05 , 9.26011926253e-05 , 0.000123887259288 , 0.000190835084587 ,
 0.000382168272876 , 0.00099082938097  , 0.00271071299874  , 0.00666158935541  ,
 0.0138618378813   , 0.0242461794017   , 0.0364576828959   , 0.0496902773702   ,
 0.0665921079931   , 0.0948217309601   , 0.147300635386    , 0.242374443515    ,
 0.399989186876    , 0.627846336799    , 0.903415579522    , 1.17166317869     ,
 1.36979990936     , 1.46228326246     , 1.45561263478     , 1.38189373521     ,
 1.2709331403      , 1.13735762704     , 0.987117281635    , 0.828051753456    ,
 0.671848342437    , 0.528031115373    , 0.399784372834    , 0.287548876426    ,
 0.193826946696    , 0.121838215782    , 0.0716095777161   , 0.0395331202957   ,
 0.0207884607355   , 0.011249514424    , 0.00774774534694  , 0.00753749798661  ,
 0.00809714446991  , 0.00768771253345  , 0.00599216734857  , 0.00388987178455  ,
 0.00248165605102  , 0.00231121561573  , 0.0032072406134   , 0.00446481770762  ,
 0.00520182862258  , 0.00488559991302  , 0.00367939151364  , 0.00222272199977  ,
 0.0010789735068   , 0.000423137231665 , 0.000137703551761 , 4.246816258e-05   ,
 1.79338110413e-05 , 1.19253168176e-05 , 9.28620639754e-06 , 1.00939912612e-05 ,
 2.43423235351e-05 , 9.07724195412e-05 , 0.000358212903219 , 0.00128987747952  ,
 0.00390868317902  , 0.00957224216031  , 0.0186348258005   , 0.0286776537625   ,
 0.0348448473365   , 0.0334392903844   , 0.0253654490378   , 0.0152301833602   ,
 0.00731120649692  , 0.00313889712996  , 0.00242568579268  , 0.00512927965348  ,
 0.012190693835    , 0.024181978242    , 0.0388885885152   , 0.0505741285778   ,
 0.0531488269131   , 0.0451214056959   , 0.0309844156196   , 0.0173130946214   ,
 0.00756120908501  , 0.00413833622489  , 0.00238365114031  , 0.00146322340708  ,
 0.00106895395838  , 0.00122537107162  , 0.00229552110207  , 0.00520049927648  ,
 0.0116890598762   , 0.0250013755937   , 0.0517779189348   , 0.105410845901    ,
 0.209198640942    , 0.397394110423    , 0.716262223346    , 1.23173005546     ,
 2.04420200976     , 3.29140654061     , 5.10885299117     , 7.54545814938     ,
 10.4845426126     , 13.6302086892     , 16.5624053824     , 18.8209117154     ,
 20.0061192135     , 19.9026843175     , 18.5725423958     , 16.3283699699     ,
 13.5901108329     , 10.739242831      , 8.06213365552     , 5.75922847967     ,
 3.9490910186      , 2.65211329997     , 1.79245509731     , 1.2395083032      ,
 0.867398508002    , 0.59635216106     , 0.395424969409    , 0.256069471255    ,
 0.166622625371    , 0.108469210208    , 0.0667496209284   , 0.0361853283648   ,
 0.0164304817766   , 0.00607695286082  , 0.00180528989847  , 0.000427798042042 ,
 8.1271055601e-05  , 1.84219743888e-05 , 4.47432605714e-05 , 0.00023056325823  ,
 0.000964341856967 , 0.00317984072615  , 0.00827333771754  , 0.0170046906633   ,
 0.0276341566301   , 0.0355237944979   , 0.0361280083853   , 0.0290760758359   ,
 0.0185742496319   , 0.00962729843439  , 0.00468803427922  , 0.0038460838525   ,
 0.0068735932427   , 0.0139593695406   , 0.0241698527149   , 0.0339355799426   ,
 0.0390564500823   , 0.0396610240227   , 0.0418198791377   , 0.051569067103    ,
 0.0668887354838   , 0.077866260168    , 0.0765904726624   , 0.0655435388075   ,
 0.0540891221081   , 0.0478363543085   , 0.0441557983832   , 0.0376772576577   ,
 0.0271569318844   , 0.015887749434    , 0.00743352466963  , 0.00276565023123  ,
 0.000816062577652 , 0.000191195716239 , 3.71376518835e-05 , 9.61153521348e-06 ,
 9.15166246299e-06 , 1.45919470973e-05 , 2.41320345507e-05 , 4.30875628653e-05 ,
 8.17825090964e-05 , 0.000148567717409 , 0.00023840922577  , 0.000332935411722 ,
 0.000422935419281 , 0.000531047760488 , 0.000704806279001 , 0.00102051329444  ,
 0.00173107209338  , 0.00367774889025  , 0.00883166155959  , 0.0202867599076   ,
 0.040773062398    , 0.0701670549439   , 0.105212252144    , 0.144209132119    ,
 0.193286029819    , 0.267442450293    , 0.386670255082    , 0.573287423922    ,
 0.847959027969    , 1.21427500717     , 1.6361480011      , 2.03271688594     ,
 2.30816103184     , 2.40096432507     , 2.31514467484     , 2.10839427757     ,
 1.84938837976     , 1.58304394103     , 1.32769474235     , 1.09122362251     ,
 0.880400771309    , 0.6974626131      , 0.53778805638     , 0.396484959449    ,
 0.274673615092    , 0.177291175953    , 0.107011586876    , 0.0614528409182   ,
 0.0349279421399   , 0.0217490793519   , 0.0176289514979   , 0.0186250976871   ,
 0.0203235605485   , 0.0192492022936   , 0.0148397401311   , 0.00917300533022  ,
 0.0046410980609   , 0.00219428396629  , 0.0014162515851   , 0.00143498102042  ,
 0.00154807167798  , 0.00141914292335  , 0.00105155800509  , 0.000625338482834 ,
 0.000298654889625 , 0.00011494171466  , 3.61177495196e-05 , 9.89945035839e-06 ,
 3.06945908568e-06 , 1.54915827108e-06 , 1.22630750265e-06 , 2.33172261561e-06 ,
 1.15979190941e-05 , 6.5969404661e-05  , 0.000323702639038 , 0.0012866818701   ,
 0.00406013824317  , 0.0101026259023   , 0.0197906133249   , 0.030533286944    ,
 0.0371394779299   , 0.0356589316568   , 0.0270549042683   , 0.0162392648909   ,
 0.0077523926603   , 0.00312792690343  , 0.0017711520268   , 0.00305393905312  ,
 0.00725652821131  , 0.0148028445944   , 0.0245444929165   , 0.0329047987566   ,
 0.0356456642606   , 0.0312946194917   , 0.0225259063744   , 0.0137207010529   ,
 0.00952362937559  , 0.00767895312334  , 0.00593852683796  , 0.00451449255089  ,
 0.00396426218585  , 0.00496892307258  , 0.0089265671364   , 0.0189248778516   ,
 0.0405897722004   , 0.0836244678934   , 0.165924375133    , 0.320578239551    ,
 0.602796560167    , 1.09495682646     , 1.91529609847     , 3.23654089644     ,
 5.29967569147     , 8.37671621543     , 12.6417078141     , 17.9860857164     ,
 23.9096383861     , 29.6039115682     , 34.1882223446     , 36.9362520367     ,
 37.4090917538     , 35.5464725682     , 31.722783051      , 26.6602153891     ,
 21.1789230821     , 15.9504895107     , 11.4059028285     , 7.76796397208     ,
 5.0945264422      , 3.29569504379     , 2.16825911473     , 1.47194947518     ,
 1.01217688831     , 0.679478858541    , 0.433895311784    , 0.263826300073    ,
 0.156030374414    , 0.0906898186183   , 0.0502931428451   , 0.0251260969591   ,
 0.0107273342325   , 0.00378266106372  , 0.00108155077517  , 0.000248564976954 ,
 4.63216804477e-05 , 1.19481376497e-05 , 3.61118772894e-05 , 0.000187894812558 ,
 0.000785898492647 , 0.00259113365247  , 0.0067409607966   , 0.0138540182001   ,
 0.022513271229    , 0.028944443922    , 0.0294597086597   , 0.0237954834008   ,
 0.015443473138    , 0.00853280497321  , 0.0050025521532   , 0.00468450535678  ,
 0.00707067778801  , 0.0121722097444   , 0.0194492878409   , 0.0264971174651   ,
 0.030416228172    , 0.0316336825567   , 0.0351453565973   , 0.0455797841883   ,
 0.0605306586067   , 0.0708853437787   , 0.0696938009688   , 0.0596765484919   ,
 0.0498270140039   , 0.0453238688709   , 0.0432079015      , 0.037804508147    ,
 0.0277231119681   , 0.0164115849089   , 0.00774170794911  , 0.00289709545961  ,
 0.00085910874995  , 0.000203366521793 , 4.1930359841e-05  , 1.49163571102e-05 ,
 2.08613647294e-05 , 4.40842073416e-05 , 9.43756973437e-05 , 0.0001978067305   ,
 0.000394749304767 , 0.00071411306697  , 0.00112843065606  , 0.00155739302979  ,
 0.0019680672803   , 0.00247271350387  , 0.00327950533281  , 0.00461458988567  ,
 0.00704863283933  , 0.0125454912114   , 0.0257570332708   , 0.0538479637722   ,
 0.10302140878     , 0.173431296115    , 0.259379990757    , 0.359198383438    ,
 0.486095152786    , 0.666015166065    , 0.925330362369    , 1.28464108003     ,
 1.75803619852     , 2.33843156985     , 2.96893588665     , 3.53340083754     ,
 3.89345928867     , 3.95647647074     , 3.72624716915     , 3.29570348111     ,
 2.7864318885      , 2.28730254437     , 1.83860593038     , 1.45318071551     ,
 1.1349470342      , 0.879746936348    , 0.674388667376    , 0.504554239623    ,
 0.362880620146    , 0.248857366226    , 0.163356020326    , 0.104159740025    ,
 0.0662047290795   , 0.0449001051384   , 0.0370646722281   , 0.0381115856072   ,
 0.0406500931284   , 0.0380703028997   , 0.0291584862502   , 0.0178553572928   ,
 0.00870660397515  , 0.00343818966841  , 0.00121868785566  , 0.000547719115142 ,
 0.000399118243311 , 0.000331521681241 , 0.000239017021798 , 0.00014018652204  ,
 6.64550752119e-05 , 2.56655475179e-05 , 8.24509948649e-06 , 2.32896851308e-06 ,
 6.79255989664e-07 , 2.88554436924e-07 , 2.93624867685e-07 , 1.17093281341e-06 ,
 8.1321684878e-06  , 5.16402023616e-05 , 0.000264534649532 , 0.0010693488623   ,
 0.0033961753779   , 0.00847134359468  , 0.0166107950519   , 0.025637132137    ,
 0.0311889555941   , 0.0299477493568   , 0.0227222032251   , 0.0136360099127   ,
 0.00649210779887  , 0.00253570926349  , 0.00114028447331  , 0.00151065643626  ,
 0.00352413940347  , 0.00738590061911  , 0.0126326980636   , 0.0175045677662   ,
 0.0197585251782   , 0.0185491611001   , 0.0152325791537   , 0.0119141771337   ,
 0.016324317343    , 0.0161510943007   , 0.0144109034541   , 0.0127893324387   ,
 0.0133732903817   , 0.0185107943467   , 0.0327432099497   , 0.0654908755796   ,
 0.133159733819    , 0.26233669858     , 0.498058635324    , 0.917618328575    ,
 1.6440049464      , 2.8572447275      , 4.81573470273     , 7.88940820878     ,
 12.5513301534     , 19.2323700688     , 28.0135597885     , 38.3080773898     ,
 48.801934459      , 57.7988091225     , 63.791748949      , 65.8866110385     ,
 63.8972858843     , 58.2721548923     , 50.0064347821     , 40.4469247807     ,
 30.9260626959     , 22.4232901831     , 15.458516519      , 10.1768962622     ,
 6.46782288808     , 4.05259493043     , 2.56832282043     , 1.66557065758     ,
 1.0877162027      , 0.692592907288    , 0.419254581685    , 0.239994463591    ,
 0.13147648021     , 0.069671779196    , 0.0351887854514   , 0.0162384534487   ,
 0.00653120123595  , 0.00221428507718  , 0.000622779809692 , 0.000145078515127 ,
 2.86021832885e-05 , 8.04651128303e-06 , 2.35450280019e-05 , 0.000121487252233 ,
 0.000507250301031 , 0.00167061579935  , 0.0043427344276   , 0.00892018302713  ,
 0.0144918576935   , 0.0186410567225   , 0.019038205383    , 0.015622477993    ,
 0.010827666104    , 0.0074712875101   , 0.0066733366787   , 0.00773132223113  ,
 0.00954818243622  , 0.0118433440253   , 0.0147808449931   , 0.0177140190208   ,
 0.01943470779     , 0.0204097299259   , 0.0237466864909   , 0.0321367686808   ,
 0.0434853264474   , 0.0512268831833   , 0.05058238407     , 0.0438197982356   ,
 0.0376074379815   , 0.0354986031909   , 0.034803800661    , 0.0309200512947   ,
 0.0228543497471   , 0.0135900732739   , 0.00643007858107  , 0.002415150762    ,
 0.000726877127969 , 0.000189999736936 , 6.83011351188e-05 , 6.78561796262e-05 ,
 0.000119482338593 , 0.000237077564734 , 0.000470173991604 , 0.000909354838053 ,
 0.00168742095997  , 0.00289349759783  , 0.00442157972501  , 0.00599399441326  ,
 0.00752311367323  , 0.00945333615989  , 0.0125507075966   , 0.0174344238986   ,
 0.0250889351552   , 0.0391864755156   , 0.0689168397282   , 0.128466184847    ,
 0.230105114654    , 0.375515428585    , 0.557889707768    , 0.779291885383    ,
 1.0649363837      , 1.45246145188     , 1.96739057545     , 2.61703256568     ,
 3.40028982219     , 4.29452286399     , 5.21372023968     , 5.99120224081     ,
 6.43178268223     , 6.40873798437     , 5.93404986278     , 5.14816334402     ,
 4.23855184146     , 3.35413435007     , 2.57522801575     , 1.93285141911     ,
 1.43212152766     , 1.05992188569     , 0.789564900254    , 0.591114064252    ,
 0.440974954705    , 0.3249799364      , 0.235589400042    , 0.167390138701    ,
 0.116302911561    , 0.0818152447484   , 0.0651801781891   , 0.0629134071243   ,
 0.0645393048758   , 0.0594391448926   , 0.0451806582918   , 0.0275267673809   ,
 0.0133214722634   , 0.00511559177993  , 0.0015787704178   , 0.000423998824212 ,
 0.000135122043185 , 7.24444895174e-05 , 4.99709128109e-05 , 3.35630518819e-05 ,
 2.13365523087e-05 , 1.30814991555e-05 , 7.5798692851e-06  , 4.02709214234e-06 ,
 2.04428538185e-06 , 1.23860955672e-06 , 1.22817350501e-06 , 2.1105416242e-06  ,
 7.00322029517e-06 , 3.56721459119e-05 , 0.000175649941936 , 0.000706067855486 ,
 0.00224135087007  , 0.00559137042084  , 0.0109646972505   , 0.0169237200909   ,
 0.0205890678455   , 0.0197699705209   , 0.0150004335679   , 0.00900287887031  ,
 0.00428602206714  , 0.00165959484607  , 0.000665944444964 , 0.000677552388747 ,
 0.00146360544464  , 0.00307700822024  , 0.005402890639    , 0.00786592398015  ,
 0.00979089984744  , 0.0111790764036   , 0.0127462010438   , 0.0147801466764   ,
 0.0283893663792   , 0.0310712706987   , 0.0314054304072   , 0.033247624636    ,
 0.041618256088    , 0.0633724495409   , 0.111922604138    , 0.213212331135    ,
 0.409983880861    , 0.767212591601    , 1.38646403609     , 2.43036787565     ,
 4.14596580512     , 6.88313373587     , 11.1271186205     , 17.5342518597     ,
 26.8524513352     , 39.5717642097     , 55.3578018687     , 72.6427238929     ,
 88.802396179      , 100.976509509     , 107.078734196     , 106.372570563     ,
 99.3888190328     , 87.5259220869     , 72.7039149916     , 57.0298450581     ,
 42.3511440821     , 29.8777061947     , 20.1006846254     , 12.9609410902     ,
 8.07763533819     , 4.93178484633     , 2.99600786709     , 1.82469071422     ,
 1.10383111013     , 0.6494673018      , 0.36528533203     , 0.195776794319    ,
 0.100950595177    , 0.0505331608159   , 0.0243456359252   , 0.0109835608587   ,
 0.0045127935689   , 0.00166731949539  , 0.000553772387247 , 0.000164826101604 ,
 4.35732805139e-05 , 1.19239940688e-05 , 1.47269564303e-05 , 6.59713551385e-05 ,
 0.000269426255424 , 0.000876191196883 , 0.00225650717051  , 0.00460331586031  ,
 0.0074456476099   , 0.00957540385139  , 0.00990802688688  , 0.00866428788023  ,
 0.00750664014587  , 0.00823111351453  , 0.0111344820295   , 0.0145714885506   ,
 0.0163402475812   , 0.0157318616383   , 0.0139406596846   , 0.0124005756447   ,
 0.0115259669136   , 0.0115378476721   , 0.0135521168651   , 0.018529873236    ,
 0.0250699011308   , 0.0294913619807   , 0.0292259258872   , 0.0257156061512   ,
 0.0228065360959   , 0.0223463724765   , 0.0224284288359   , 0.0201323245833   ,
 0.0149437581953   , 0.00890665017038  , 0.00423158944169  , 0.00162495429605  ,
 0.000561761464107 , 0.000271456121639 , 0.000267442093178 , 0.000373784238761 ,
 0.000608439224092 , 0.00108893590228  , 0.00198624307633  , 0.0035499751095   ,
 0.00612099035908  , 0.00990414478688  , 0.0145648974068   , 0.0193362902135   ,
 0.0240660833014   , 0.0301673344353   , 0.0399558456215   , 0.0549902587514   ,
 0.0764349470499   , 0.109552570043    , 0.16956943528     , 0.281027524694    ,
 0.465729030066    , 0.729459211492    , 1.06786110168     , 1.492685823       ,
 2.0455099734      , 2.77142346015     , 3.68116205896     , 4.75400423096     ,
 5.96797731827     , 7.2851701221      , 8.58228978389     , 9.61970233288     ,
 10.1232542347     , 9.92912206388     , 9.07381849904     , 7.76579593749     ,
 6.27492672662     , 4.82752631771     , 3.56414057771     , 2.54866065617     ,
 1.78916812608     , 1.25549378888     , 0.897973821665    , 0.664757226562    ,
 0.511478249696    , 0.404583915104    , 0.321313142909    , 0.248240894413    ,
 0.181673963733    , 0.127778051943    , 0.0953751535731   , 0.0841704519716   ,
 0.081643096692    , 0.0734227425848   , 0.0552538645422   , 0.0334810420715   ,
 0.0161329055241   , 0.00615656760291  , 0.00186104085332  , 0.00045295967656  ,
 0.000103063300676 , 4.56300729463e-05 , 5.20870638149e-05 , 6.66774913632e-05 ,
 7.2333355698e-05  , 6.38316427338e-05 , 4.59282484735e-05 , 2.78933461375e-05 ,
 1.59244517e-05    , 1.09106288868e-05 , 1.10501292047e-05 , 1.43631086589e-05 ,
 2.02140279744e-05 , 3.64289399246e-05 , 0.000107050252091 , 0.000377540861593 ,
 0.00116838759208  , 0.00290083262144  , 0.00568324202174  , 0.00877019833954  ,
 0.0106692133388   , 0.0102451251508   , 0.0077758830714   , 0.00467629533964  ,
 0.00225498097877  , 0.000940543601171 , 0.000487264621288 , 0.000519056068982 ,
 0.000827339184038 , 0.00138522709927  , 0.00224664258157  , 0.00352322715541  ,
 0.00559574406693  , 0.00927600148497  , 0.0151773049883   , 0.0224056197282   ,
 0.0436393273013   , 0.0532927938588   , 0.0636591497118   , 0.0824641749911   ,
 0.121317504435    , 0.199051713014    , 0.351225289169    , 0.640983646955    ,
 1.16600406585     , 2.06568417547     , 3.54161023937     , 5.89427490716     ,
 9.55750972452     , 15.1202646969     , 23.3549353875     , 35.2159337788     ,
 51.6152002013     , 72.791235059      , 97.4948127234     , 122.660003976     ,
 144.070370775     , 157.793511313     , 161.55679283      , 155.28928227      ,
 140.702318422     , 120.466690081     , 97.5602234396     , 74.8118151982     ,
 54.4513163319     , 37.7672211189     , 25.0851288005     , 16.0362109269     ,
 9.91404321879     , 5.95699851955     , 3.49771918995     , 2.01264656595     ,
 1.12982563649     , 0.612649405683    , 0.319797698226    , 0.162967528301    ,
 0.0833075748753   , 0.0434830154665   , 0.022990273073    , 0.0120481284442   ,
 0.00612276667425  , 0.00292752632849  , 0.00125933884103  , 0.000466111653208 ,
 0.000145437469254 , 4.10122462678e-05 , 2.04630963172e-05 , 4.88567170706e-05 ,
 0.000168500836497 , 0.000494536052385 , 0.00117383311674  , 0.00224281487482  ,
 0.00345305598414  , 0.00432595937041  , 0.00461731713553  , 0.00490812349742  ,
 0.00666041595846  , 0.0112534428907   , 0.018314241921    , 0.0248902852588   ,
 0.0272035104597   , 0.02402369235     , 0.0178462375924   , 0.0123062513812   ,
 0.00915274316682  , 0.00810129022156  , 0.00853812259741  , 0.0102295659083   ,
 0.0125413639626   , 0.0140608123174   , 0.0137681352269   , 0.0122921052792   ,
 0.0112639415739   , 0.0113646975498   , 0.0115550133498   , 0.0104042837135   ,
 0.00772955866872  , 0.00463182632105  , 0.00228364945728  , 0.0010866655378   ,
 0.000795074463601 , 0.000987801865055 , 0.00135611331027  , 0.00182922142671  ,
 0.0026328559923   , 0.00421241948052  , 0.00707726092987  , 0.0118017638677   ,
 0.0190711193534   , 0.0291997159203   , 0.0412769185352   , 0.0535498210308   ,
 0.0659031839399   , 0.0819696513065   , 0.107473585335    , 0.145918729082    ,
 0.197773440227    , 0.268009632518    , 0.377592611324    , 0.564273198139    ,
 0.863772957215    , 1.28958020034     , 1.84302527272     , 2.54914876533     ,
 3.46660426121     , 4.64138491041     , 6.05729515054     , 7.65655941796     ,
 9.39707977078     , 11.2301021006     , 12.9876482676     , 14.3318669862     ,
 14.8817876802     , 14.4286078477     , 13.051110185      , 11.0548634276     ,
 8.81769148174     , 6.66173546064     , 4.79979340163     , 3.33191662063     ,
 2.26254142464     , 1.53301703057     , 1.06244348396     , 0.775430145845    ,
 0.608007893218    , 0.505536417568    , 0.425197796744    , 0.342039717677    ,
 0.25293905196     , 0.172492354561    , 0.117959107692    , 0.0925938801478   ,
 0.0829238417192   , 0.072018633701    , 0.0534482161389   , 0.0321699446038   ,
 0.0154346002218   , 0.00587130461306  , 0.00177328777763  , 0.0004444001802   ,
 0.00014395223034  , 0.000153619638028 , 0.000251685517052 , 0.000353136868434 ,
 0.000397140638582 , 0.000358592690845 , 0.000264994522259 , 0.000168715822911 ,
 0.000105133076835 , 8.0130617794e-05  , 8.42922641789e-05 , 0.000105504043583 ,
 0.000129833687386 , 0.0001448567263   , 0.000159804990758 , 0.000239447769357 ,
 0.000528487442047 , 0.00120918483454  , 0.00232768319639  , 0.00357734157297  ,
 0.00434744081115  , 0.00417552063927  , 0.00317957626429  , 0.00195224594272  ,
 0.00106388568381  , 0.000739804222947 , 0.000893564643276 , 0.00127847118931  ,
 0.00161893952002  , 0.00177168899887  , 0.00189410831116  , 0.00256315325842  ,
 0.00487809089524  , 0.0103103153761   , 0.0197107680277   , 0.0318481809139   ,
 0.0611859292525   , 0.0879980655457   , 0.129122705455    , 0.201443423686    ,
 0.332938970412    , 0.571494907561    , 1.00016498536     , 1.75202064066     ,
 3.01818833361     , 5.05520485453     , 8.20912418084     , 12.9596420454     ,
 19.9582780936     , 30.0414300641     , 44.2253078379     , 63.608414713      ,
 88.9385941803     , 119.715132455     , 153.294015248     , 184.906546066     ,
 208.986000815     , 221.126546004     , 219.534207443     , 205.279724316     ,
 181.468735447     , 152.042439107     , 120.880948861     , 91.2963848407     ,
 65.6673185588     , 45.1913750623     , 29.9298395181     , 19.1655855771     ,
 11.881713454      , 7.122340248       , 4.12619080083     , 2.31311466991     ,
 1.25452079195     , 0.658223189405    , 0.338851976984    , 0.178424219312    ,
 0.100880373013    , 0.0615756341426   , 0.0389697537144   , 0.0244551199075   ,
 0.0146077609242   , 0.00791225120635  , 0.0037021433007   , 0.00145215546674  ,
 0.000482957101527 , 0.000153144921438 , 7.38254380805e-05 , 0.00011119661521  ,
 0.000292585253219 , 0.000712913987689 , 0.00141406654995  , 0.00224998103654  ,
 0.00289248341558  , 0.00310180719631  , 0.00314096299997  , 0.00407010128736  ,
 0.00762651090478  , 0.0152192738697   , 0.025970701759    , 0.0355878571889   ,
 0.0387106127709   , 0.0336892688724   , 0.0243673539666   , 0.0163369964835   ,
 0.0121754856832   , 0.0107526594355   , 0.00995297306809  , 0.0089055190983   ,
 0.00787080829962  , 0.00709254877254  , 0.00643422355154  , 0.00583394876299  ,
 0.00547875716288  , 0.00539969348796  , 0.00521919652298  , 0.0045106666218   ,
 0.00330342239914  , 0.00209492687558  , 0.00144580936459  , 0.00166760194227  ,
 0.00275052402746  , 0.0043624700113   , 0.00600784953226  , 0.00754340085579  ,
 0.00968478858896  , 0.013835884231    , 0.0214196543447   , 0.0336443217122   ,
 0.051619997548    , 0.0754933026465   , 0.102965805812    , 0.130443946174    ,
 0.158058430427    , 0.193503997475    , 0.248559591661    , 0.330151629869    ,
 0.436491797526    , 0.567965182691    , 0.747771943783    , 1.02794428411     ,
 1.46303087682     , 2.0781459792      , 2.87994534993     , 3.9028345581      ,
 5.21747383303     , 6.86712370383     , 8.80893774887     , 10.9528287652     ,
 13.2429996332     , 15.6234478684     , 17.8782377113     , 19.5589241815     ,
 20.1589137421     , 19.4097683876     , 17.4352134321     , 14.6607447249     ,
 11.6016708377     , 8.69346495489     , 6.21868405951     , 4.29772483837     ,
 2.91465752301     , 1.97346133382     , 1.36296833932     , 0.991205325499    ,
 0.780727158361    , 0.657149397667    , 0.556637581463    , 0.443846566161    ,
 0.3190562763      , 0.205803169458    , 0.1268826797      , 0.0861111130435   ,
 0.0687492075665   , 0.0565524754771   , 0.0411058940291   , 0.0245416618461   ,
 0.0117454519416   , 0.00448698616144  , 0.00140133040118  , 0.000451200423573 ,
 0.000365322734514 , 0.000649018871612 , 0.00111762221845  , 0.001572817386    ,
 0.00177858045611  , 0.00162783580392  , 0.00123783192625  , 0.000835193353725 ,
 0.000574979527753 , 0.000484288016477 , 0.000522904250008 , 0.000636952605891 ,
 0.000756824158656 , 0.000799864313504 , 0.000724432025398 , 0.000581782394492 ,
 0.000496213302505 , 0.000586586503737 , 0.000879349213661 , 0.00125461478224  ,
 0.00149101313217  , 0.00143026648849  , 0.0011264502535   , 0.000827319595441 ,
 0.00083638497496  , 0.00138548515059  , 0.00249626540139  , 0.00381935755673  ,
 0.00470348475829  , 0.00468116183584  , 0.00401564851474  , 0.00381810712802  ,
 0.00580849212889  , 0.0119271562337   , 0.0235009596177   , 0.0402696924521   ,
 0.0913524673787   , 0.158846938969    , 0.278049481256    , 0.48900781615     ,
 0.858119709299    , 1.49441561173     , 2.56671101854     , 4.31346797089     ,
 7.045108861       , 11.1522172199     , 17.1349872935     , 25.6452654724     ,
 37.507263824      , 53.6971993089     , 75.2720284999     , 103.134315279     ,
 137.398903495     , 176.380623181     , 215.904091984     , 249.887166558     ,
 272.253173599     , 279.055773762     , 269.620467744     , 246.346967502     ,
 213.553678758     , 176.076740845     , 138.267944336     , 103.532299847     ,
 74.1183831607     , 50.9942138997     , 33.9367750244     , 21.9376284433     ,
 13.7611366037     , 8.34353873263     , 4.88501706009     , 2.77419454444     ,
 1.5380552249      , 0.840431133502    , 0.464295527506    , 0.271457730777    ,
 0.173108937428    , 0.11777700216     , 0.0814851725483   , 0.0550062482936   ,
 0.0347389429809   , 0.0195452014838   , 0.00940139378378  , 0.00382163044444  ,
 0.00138509882443  , 0.000535637083392 , 0.00030727330012  , 0.00038332708739  ,
 0.000844727950692 , 0.00189362255814  , 0.00351794440611  , 0.00520132366779  ,
 0.00609686926777  , 0.00577537264352  , 0.00491069119551  , 0.00529774270369  ,
 0.00926084574107  , 0.0183783166189   , 0.0313666751317   , 0.0429385086826   ,
 0.0467052444094   , 0.0409198718624   , 0.0305336442444   , 0.0224251704959   ,
 0.019277015306    , 0.0186837320571   , 0.0171176992407   , 0.0135691925814   ,
 0.00957278614383  , 0.00688818564097  , 0.00587448953371  , 0.0057086125651   ,
 0.00544356887142  , 0.00469460564697  , 0.00361741883953  , 0.00254811371485  ,
 0.00178701382662  , 0.00166071054559  , 0.00267867534374  , 0.00548838148076  ,
 0.0103556920728   , 0.0164289311139   , 0.0219297849932   , 0.025957469836    ,
 0.0303041285868   , 0.0389047180855   , 0.0555507421155   , 0.0828228789408   ,
 0.122310157539    , 0.173122827991    , 0.229618351649    , 0.284405784986    ,
 0.33766862705     , 0.403303679528    , 0.502392709576    , 0.647264375983    ,
 0.832015982228    , 1.04614993548     , 1.30797599113     , 1.68154974219     ,
 2.24413659846     , 3.03658060301     , 4.06806987572     , 5.37232633117     ,
 7.02190487842     , 9.05618793768     , 11.4168310604     , 13.9973155101     ,
 16.7365274103     , 19.5723882461     , 22.2497545179     , 24.2303609811     ,
 24.8951580263     , 23.9044873112     , 21.4043939176     , 17.9333227418     ,
 14.1537732365     , 10.6167136105     , 7.65505050317     , 5.38091067252     ,
 3.74054507331     , 2.60203218962     , 1.83757284443     , 1.35265303455     ,
 1.0638760257      , 0.880187054749    , 0.721456397842    , 0.549600996385    ,
 0.373669264976    , 0.22463384423     , 0.124390707172    , 0.0716786381436   ,
 0.0487131459189   , 0.0366561503143   , 0.0258226071145   , 0.0154019321287   ,
 0.00755029100812  , 0.00310751471947  , 0.00124671040912  , 0.000832467482419 ,
 0.0012605517619   , 0.00239051792906  , 0.00404934034848  , 0.00565900280516  ,
 0.00642640430976  , 0.00598182842232  , 0.00472237072419  , 0.00342625714382  ,
 0.00262853854731  , 0.00241779444073  , 0.00264759655567  , 0.00312628177042  ,
 0.00359507503257  , 0.00372644157827  , 0.00333233042203  , 0.00255537973863  ,
 0.00175774921339  , 0.00123046517507  , 0.00103080343631  , 0.0010259090684   ,
 0.00103302526338  , 0.000955893490638 , 0.000856901267083 , 0.000960724439826 ,
 0.00164152385402  , 0.00333371376943  , 0.00615707113056  , 0.00937955584017  ,
 0.0114893830546   , 0.0113371261039   , 0.00937170033693  , 0.00761642751316  ,
 0.0086337488868   , 0.0147951601105   , 0.0283104338608   , 0.0519668027903   ,
 0.175546787286    , 0.339211084141    , 0.63969282574     , 1.16782790106     ,
 2.06636473182     , 3.55178514143     , 5.91947908925     , 9.52483447357     ,
 14.7655623059     , 22.1025435812     , 32.1170975639     , 45.5497294007     ,
 63.2704854849     , 86.18441108       , 115.066957203     , 150.206216548     ,
 190.692216259     , 233.550215245     , 273.510502558     , 304.149563523     ,
 320.02904259      , 318.513011621     , 300.340195439     , 269.023253079     ,
 229.575350783     , 187.11138146      , 145.88055915      , 108.933899221     ,
 78.1173272359     , 54.0812609368     , 36.3840140568     , 23.8762804442     ,
 15.2579939552     , 9.46328044628     , 5.70843077451     , 3.38094579254     ,
 1.9892437586      , 1.1775957063      , 0.71647001991     , 0.459987346163    ,
 0.313580925548    , 0.221659351941    , 0.157300363677    , 0.108543453752    ,
 0.0698306964022   , 0.0399179937238   , 0.0196442340078   , 0.00846176236003  ,
 0.00356976325799  , 0.00179309555099  , 0.00120950604901  , 0.00128525163442  ,
 0.00230231676901  , 0.00472000349097  , 0.00842996626626  , 0.0121609785478   ,
 0.013945827801    , 0.012784983847    , 0.00991340735176  , 0.00832305812064  ,
 0.0112143029282   , 0.0203005077934   , 0.0338827870646   , 0.0460769632838   ,
 0.0501244770181   , 0.0444930985693   , 0.0348662535699   , 0.0286638024357   ,
 0.0280781809042   , 0.0292093088538   , 0.0272596383372   , 0.0214618040777   ,
 0.0149791426699   , 0.0111440530425   , 0.0105548211162   , 0.0112893400185   ,
 0.0110803758138   , 0.00916188860891  , 0.0064016725975   , 0.00413755818162  ,
 0.00325789524847  , 0.00440538944786  , 0.00876041183969  , 0.0180898240688   ,
 0.0330686685818   , 0.0509049356057   , 0.0658593782987   , 0.0744875000107   ,
 0.0807406566441   , 0.0943665389197   , 0.124635206843    , 0.177224133487    ,
 0.254543863266    , 0.352987171142    , 0.459397483743    , 0.557932971994    ,
 0.647025875179    , 0.749045963161    , 0.898805821229    , 1.11706458993     ,
 1.39216064555     , 1.69550084423     , 2.03079419033     , 2.46774972318     ,
 3.107001352       , 4.0096131554      , 5.18773620865     , 6.66640013984     ,
 8.50790653799     , 10.7420204489     , 13.3033374171     , 16.0852658991     ,
 19.0303796329     , 22.0746473041     , 24.9492360796     , 27.0829566136     ,
 27.798362789      , 26.6944225159     , 23.9061824252     , 20.0404708057     ,
 15.8682657462     , 12.0178904617     , 8.83465627267     , 6.39803356735     ,
 4.61553626585     , 3.33690472533     , 2.43937068971     , 1.83938792742     ,
 1.45179127625     , 1.17289678062     , 0.917322960526    , 0.657853275874    ,
 0.418738838381    , 0.2347950231      , 0.119133134275    , 0.0597368827139   ,
 0.0339820130786   , 0.0227658848589   , 0.0159122974451   , 0.0103896486952   ,
 0.00621988361895  , 0.00368443528195  , 0.00261426281126  , 0.00277891679988  ,
 0.00430511946292  , 0.00752482085869  , 0.0121742372354   , 0.0167257882045   ,
 0.0190309350376   , 0.0180876260871   , 0.0149852570791   , 0.0118570974833   ,
 0.010147901552    , 0.0100308422925   , 0.0110278828744   , 0.0125836160452   ,
 0.013964659068    , 0.0141964062999   , 0.0127024087216   , 0.00994397120832  ,
 0.00709109341002  , 0.00508291200015  , 0.00409845128949  , 0.00372899841039  ,
 0.00346202986708  , 0.00307243923272  , 0.00272680919417  , 0.00287109316512  ,
 0.00414762112695  , 0.0072874491885   , 0.0124975682676   , 0.0184640483713   ,
 0.0224271071076   , 0.0222794239873   , 0.0188496474664   , 0.0156937447272   ,
 0.0168809788843   , 0.0258517311618   , 0.0471113427208   , 0.0902902051675   ,
 0.426244872366    , 0.813902014713    , 1.50755694612     , 2.68719712592     ,
 4.61679771697     , 7.66341569143     , 12.264778788      , 18.8430273372     ,
 27.7502549299     , 39.3363327531     , 54.0915028943     , 72.7013478841     ,
 95.9305160749     , 124.400162775     , 158.311121243     , 197.039559717     ,
 238.562489175     , 279.002664584     , 312.935724786     , 334.803427249     ,
 340.778439719     , 329.926861296     , 304.21682367      , 267.738223428     ,
 225.532070564     , 182.341423628     , 141.774718374     , 106.152218988     ,
 76.7139787076     , 53.7627884029     , 36.7575545015     , 24.602435615      ,
 16.1063956975     , 10.304789325      , 6.48127810492     , 4.05929248519     ,
 2.56492036518     , 1.65159375313     , 1.09469922272     , 0.751405123355    ,
 0.530057953599    , 0.377549808464    , 0.266954385646    , 0.183316521476    ,
 0.117755690882    , 0.0678702720921   , 0.0346357828889   , 0.0166335294389   ,
 0.00879661438898  , 0.00569819259636  , 0.00429878993897  , 0.00406552961725  ,
 0.00578317665263  , 0.0102728783419   , 0.0170999147549   , 0.0237305130777   ,
 0.0265742137029   , 0.0239291432353   , 0.0179206477529   , 0.0131896210422   ,
 0.0139873665016   , 0.0220505586655   , 0.0352049803873   , 0.0471998143987   ,
 0.0512394616343   , 0.0460195998468   , 0.0375307039122   , 0.0332670793013   ,
 0.0349008650821   , 0.0374772440394   , 0.0354298909119   , 0.028407278382    ,
 0.0210325802267   , 0.0179195585666   , 0.0195903178835   , 0.0226408400844   ,
 0.0231354508806   , 0.0198968188357   , 0.0149170001229   , 0.0111850751391   ,
 0.0108158455136   , 0.0154378674006   , 0.0278576865954   , 0.052041506605    ,
 0.0890297201793   , 0.131349561277    , 0.164514196034    , 0.179457439979    ,
 0.184062999847    , 0.199161472765    , 0.244479250915    , 0.331817609168    ,
 0.465543375903    , 0.637215056893    , 0.819531389961    , 0.97988357347     ,
 1.11055621609     , 1.24467161479     , 1.43696828105     , 1.72106290413     ,
 2.07829093263     , 2.45526620893     , 2.83158740996     , 3.27370466611     ,
 3.90169910942     , 4.8002947943      , 5.99073411369     , 7.48884607534     ,
 9.33578815403     , 11.5391811015     , 14.0259437706     , 16.7011222019     ,
 19.5222025671     , 22.4344945447     , 25.189601828      , 27.2509693741     ,
 27.9560689009     , 26.8803966495     , 24.1320478753     , 20.3235279666     ,
 16.2455080715     , 12.5192873503     , 9.45272222167     , 7.0873215424      ,
 5.31610793647     , 4.00028871699     , 3.04104513766     , 2.3700982175      ,
 1.8980818766      , 1.5123688915      , 1.13688870933     , 0.771717491633    ,
 0.463224363887    , 0.246696821913    , 0.120342119332    , 0.0580499203836   ,
 0.03171021876     , 0.0220123487073   , 0.0183346971277   , 0.0157680866987   ,
 0.0129603808255   , 0.010452025051    , 0.00919240779537  , 0.00993340922843  ,
 0.0135438493555   , 0.0209055485268   , 0.0314519611387   , 0.0418471906331   ,
 0.0474591124884   , 0.0462173476317   , 0.0406226096818   , 0.0353773736367   ,
 0.0334746714079   , 0.0348945030651   , 0.0382012277926   , 0.042068102112    ,
 0.0449691497644   , 0.0447757345192   , 0.0401944474733   , 0.0324367971161   ,
 0.0245253821942   , 0.0189265187998   , 0.0160828796203   , 0.0147859209967   ,
 0.0135478080205   , 0.0117954238541   , 0.0100819997792   , 0.00942905265827  ,
 0.0107661747866   , 0.0148765331198   , 0.0219223632423   , 0.0301786213462   ,
 0.0359688392144   , 0.036538131654    , 0.0334475260672   , 0.0324735622031   ,
 0.0405959955416   , 0.0649312819387   , 0.116922162731    , 0.221188354258    ,
 1.09457667363     , 1.96976720921     , 3.44247223311     , 5.81180736062     ,
 9.48564055247     , 14.9839826004     , 22.8398783686     , 33.4085166686     ,
 46.7723478893     , 62.9145803989     , 82.0261320682     , 104.605067614     ,
 131.219882303     , 162.111781947     , 196.804975665     , 233.759566367     ,
 270.140434196     , 301.92428396      , 324.605332287     , 334.444659757     ,
 329.649121389     , 310.809356822     , 280.577636483     , 242.966785829     ,
 202.423003534     , 162.805007305     , 126.734342289     , 95.6195858504     ,
 70.0347771551     , 49.9695214766     , 34.9012030113     , 23.944447373      ,
 16.1475515011     , 10.7240730666     , 7.07282070659     , 4.69801676473     ,
 3.18346545932     , 2.21510207907     , 1.58111623762     , 1.14579289253     ,
 0.828310188735    , 0.588542476516    , 0.408092027041    , 0.27336445662     ,
 0.172697277969    , 0.100517352428    , 0.0549839105422   , 0.0314116121345   ,
 0.0212264413998   , 0.0164650078526   , 0.0133196371214   , 0.0119249043999   ,
 0.0140596388715   , 0.0207905230407   , 0.0307364952991   , 0.0396177436633   ,
 0.0423902682044   , 0.0372817877893   , 0.0277489299918   , 0.0199448317936   ,
 0.018662412865    , 0.0252960323888   , 0.0373135127002   , 0.0485432726035   ,
 0.0523928419494   , 0.0474359778002   , 0.0392597615665   , 0.035080524395    ,
 0.036607562372    , 0.0390738010136   , 0.0371363061861   , 0.0308318821723   ,
 0.025400259632    , 0.0259330299215   , 0.0325892803739   , 0.0404553903448   ,
 0.043789468918    , 0.0408817307934   , 0.0351727714342   , 0.0321702561553   ,
 0.0362351686814   , 0.0507903108459   , 0.0809141158726   , 0.133172074202    ,
 0.207989129687    , 0.289450293214    , 0.348910597227    , 0.368808963135    ,
 0.363423946306    , 0.370342944358    , 0.424803782425    , 0.548200627184    ,
 0.749061238341    , 1.01306228294     , 1.29234888212     , 1.5283323913      ,
 1.70123924004     , 1.8557418628      , 2.0713015682      , 2.39755448178     ,
 2.80793999657     , 3.22142287196     , 3.58960863856     , 3.96862334385     ,
 4.48975698155     , 5.25960190678     , 6.31453708911     , 7.66496856529     ,
 9.32460641079     , 11.2697646806     , 13.4203183056     , 15.7034209468     ,
 18.1025657008     , 20.5847587164     , 22.9478545891     , 24.7359333961     ,
 25.3596608194     , 24.4205539922     , 22.0089318819     , 18.6880687168     ,
 15.1656527922     , 11.9612679352     , 9.30556890279     , 7.2173631888      ,
 5.61180267108     , 4.38834264137     , 3.47881260508     , 2.82356190285     ,
 2.32177099757     , 1.85367734635     , 1.36397278551     , 0.893038632944    ,
 0.516021082364    , 0.26892912159     , 0.133898294178    , 0.0709075056765   ,
 0.046884272911    , 0.0417032663785   , 0.0427928566134   , 0.0423756868076   ,
 0.0382881505196   , 0.0330237207317   , 0.0300760255723   , 0.0315626738142   ,
 0.0388699737995   , 0.0531594142004   , 0.0730957482585   , 0.092639215107    ,
 0.103865383072    , 0.103769229815    , 0.097417179167    , 0.0932217801355   ,
 0.0956461027573   , 0.103093904172    , 0.111673079729    , 0.118770853107    ,
 0.122341978204    , 0.119320319565    , 0.107772476355    , 0.0902009345299   ,
 0.0725912336309   , 0.0599055273393   , 0.0529188186695   , 0.0487674097596   ,
 0.0440418795913   , 0.0377387183894   , 0.0316053964447   , 0.0279401067386   ,
 0.0276981285712   , 0.030800639066    , 0.0369544320366   , 0.0448915827607   ,
 0.0517555951843   , 0.0556077413999   , 0.0594113144685   , 0.0720521853536   ,
 0.106612983387    , 0.181205184028    , 0.326275228936    , 0.5980177637      ,
 2.63728576214     , 4.45578176206     , 7.29333190051     , 11.5543841036     ,
 17.7501555526     , 26.4762651921     , 38.232948805      , 53.1223250396     ,
 70.7386601322     , 90.5075371245     , 112.205469994     , 136.102878685     ,
 162.581629531     , 191.560103585     , 222.033323413     , 251.87128626      ,
 278.017705761     , 297.112621913     , 306.322010547     , 304.061893897     ,
 290.351049464     , 266.718236131     , 235.850889484     , 201.132660318     ,
 165.989793989     , 133.129862545     , 104.110687431     , 79.4960501522     ,
 59.3038512626     , 43.3023228097     , 31.0604165027     , 21.9650360289     ,
 15.3483643797     , 10.6335626295     , 7.36966841712     , 5.1839767767      ,
 3.7519679498      , 2.80547021653     , 2.14362662435     , 1.63486722453     ,
 1.2135781685      , 0.863471650157    , 0.587048423392    , 0.381567281953    ,
 0.236499054268    , 0.141230875599    , 0.0863466085822   , 0.0599929245618   ,
 0.0485471733519   , 0.0415855343168   , 0.0352736050018   , 0.0313503592139   ,
 0.0331183091755   , 0.0414018215887   , 0.0527467709714   , 0.0607902368919   ,
 0.060324777717    , 0.0513601953739   , 0.0392493582664   , 0.0304200872517   ,
 0.028357156172    , 0.0331897120246   , 0.0426081633578   , 0.0518609535212   ,
 0.0552836270914   , 0.0507173214305   , 0.042054585841    , 0.0356263469462   ,
 0.0339928965138   , 0.0342666499883   , 0.0325829932321   , 0.02928195657     ,
 0.0291328897281   , 0.0368009824182   , 0.0521334765621   , 0.0693141196787   ,
 0.0809907511356   , 0.0845213617346   , 0.0847404883775   , 0.0906902299098   ,
 0.110377415939    , 0.149396139459    , 0.213842024444    , 0.310451251223    ,
 0.436031368341    , 0.563202496643    , 0.647400008785    , 0.663409264421    ,
 0.634676386329    , 0.61797787746     , 0.665411907037    , 0.80971290263     ,
 1.06637646194     , 1.41726175597     , 1.79335924195     , 2.10715112741     ,
 2.32301085494     , 2.49300393658     , 2.71649148787     , 3.05484876722     ,
 3.47354960117     , 3.87041744621     , 4.17699992775     , 4.43824435355     ,
 4.78530531143     , 5.33592216832     , 6.13976876087     , 7.20417449856     ,
 8.51713499047     , 10.0295588061     , 11.6662551729     , 13.3860347622     ,
 15.2010072591     , 17.1020589758     , 18.9406781267     , 20.3569579391     ,
 20.8643064398     , 20.128089737      , 18.2343753917     , 15.6583412902     ,
 12.9529065606     , 10.482523965      , 8.39313683482     , 6.70419337247     ,
 5.37758029654     , 4.36011389696     , 3.60885659933     , 3.0634931355      ,
 2.60739202816     , 2.11460505617     , 1.55267933205     , 1.00370520054     ,
 0.573576943186    , 0.302802651178    , 0.1624623331      , 0.102889983805    ,
 0.0876910455648   , 0.0944725090172   , 0.10550572292     , 0.107871393012    ,
 0.0993965291132   , 0.0877510150164   , 0.0817807593887   , 0.0855841618237   ,
 0.100146673258    , 0.125696314457    , 0.158993424641    , 0.190569003195    ,
 0.209729271565    , 0.214463276474    , 0.214396942658    , 0.221838168147    ,
 0.240339957011    , 0.262971693605    , 0.280595614281    , 0.289118292472    ,
 0.288040387885    , 0.275913475623    , 0.251637650525    , 0.219156681092    ,
 0.18703702011     , 0.162475737041    , 0.146302960705    , 0.133409529048    ,
 0.118064850412    , 0.0995343319433   , 0.0823957460777   , 0.0712926155577   ,
 0.0665297413562   , 0.0654311053261   , 0.0665223659262   , 0.0707060589829   ,
 0.0793750450725   , 0.0943942817547   , 0.121630924577    , 0.175111319509    ,
 0.281026154447    , 0.484271731715    , 0.858510884042    , 1.51890647543     ,
 5.69345142059     , 9.08286163084     , 13.9751837068     , 20.7886231838     ,
 30.0106034125     , 42.1542603343     , 57.5166073304     , 75.8044198833     ,
 96.0581633134     , 117.172169905     , 138.586134955     , 160.417258377     ,
 182.93482802      , 205.884069949     , 228.051894127     , 247.249231944     ,
 260.852035761     , 266.705641714     , 263.798970253     , 252.346012243     ,
 233.482627512     , 208.969327644     , 181.026387451     , 152.119983615     ,
 124.523072209     , 99.8070620379     , 78.6328697675     , 60.9708903893     ,
 46.5040606518     , 34.896801182      , 25.8299107047     , 18.9337981715     ,
 13.7895833232     , 10.0120744349     , 7.30501409896     , 5.43658632077     ,
 4.1904503893      , 3.35099297536     , 2.72662987365     , 2.186159054       ,
 1.67813671497     , 1.21383512431     , 0.825142125698    , 0.530833642935    ,
 0.329350699914    , 0.206515553062    , 0.142025006367    , 0.113295324878    ,
 0.100297105176    , 0.0902543068222   , 0.0796368514442   , 0.0720667666433   ,
 0.0723989885178   , 0.080490722793    , 0.0897035901624   , 0.0917227380274   ,
 0.0834443033827   , 0.0693982019548   , 0.0573267338537   , 0.0515113546525   ,
 0.0508572026668   , 0.052789118851    , 0.0565291187818   , 0.0612935654485   ,
 0.0637080597687   , 0.0600442615636   , 0.0506813949185   , 0.0402135167854   ,
 0.0328748494559   , 0.0292975404374   , 0.0282679676185   , 0.0304812359335   ,
 0.0394862725448   , 0.0590081679535   , 0.0891650902641   , 0.124492605386    ,
 0.156487254142    , 0.180742657925    , 0.202852388371    , 0.23631165453     ,
 0.294079040766    , 0.382880000239    , 0.505107483837    , 0.660833817356    ,
 0.838039560449    , 0.998065406057    , 1.08651888819     , 1.07784116955     ,
 1.0070187318      , 0.946503617501    , 0.960520603517    , 1.09131341791     ,
 1.36305260635     , 1.7590346121      , 2.19810812259     , 2.57321186276     ,
 2.83479530557     , 3.03120556864     , 3.26204475223     , 3.58589585027     ,
 3.9626603706      , 4.28702795821     , 4.48948927049     , 4.60815132229     ,
 4.76153333202     , 5.0614470291      , 5.56131180558     , 6.26606226978     ,
 7.14866895389     , 8.15384373989     , 9.22802046017     , 10.3630962435     ,
 11.5893881019     , 12.9113975215     , 14.2269172071     , 15.2695103823     ,
 15.6658040871     , 15.1618887988     , 13.8377128079     , 12.0540270949     ,
 10.1871929101     , 8.45302075221     , 6.93585775094     , 5.67095268878     ,
 4.66639000835     , 3.90731124516     , 3.3674617315      , 2.98455639263     ,
 2.6325557011      , 2.18380095804     , 1.62167502537     , 1.05547414567     ,
 0.612589713907    , 0.340127202441    , 0.206850648189    , 0.161157767088    ,
 0.166159848815    , 0.195549275006    , 0.222971586085    , 0.228550041476    ,
 0.212171996331    , 0.191357860061    , 0.183916324998    , 0.196369101023    ,
 0.227440264827    , 0.273810595494    , 0.327860208171    , 0.37575714771     ,
 0.406326030096    , 0.4233204038      , 0.444341494771    , 0.484064380024    ,
 0.538935123925    , 0.589756726533    , 0.618521737079    , 0.6208194131      ,
 0.602679207435    , 0.570331350224    , 0.526942742229    , 0.476630471867    ,
 0.426302655999    , 0.381967114992    , 0.343992997078    , 0.306713582111    ,
 0.26447326528     , 0.219211156173    , 0.180286734549    , 0.155276150815    ,
 0.142533088516    , 0.13464629995     , 0.128337946456    , 0.129250415178    ,
 0.147970692793    , 0.194922608516    , 0.282187919507    , 0.433470588652    ,
 0.70024274751     , 1.17973403685     , 2.02524877405     , 3.44408779046     ,
 10.8588849721     , 16.4464264534     , 23.9234089169     , 33.5527731164     ,
 45.6112404118     , 60.353128684      , 77.7580584933     , 97.1546700602     ,
 117.211288357     , 136.571455708     , 154.582712604     , 171.338612042     ,
 187.066109686     , 201.489516477     , 213.531677517     , 221.452011275     ,
 223.516361824     , 218.875878981     , 207.91735284      , 191.846986826     ,
 172.093241582     , 150.098427418     , 127.39545009      , 105.54253846      ,
 85.8046566392     , 68.8577912688     , 54.7685184231     , 43.2170763476     ,
 33.7795609728     , 26.1199103755     , 20.0188112971     , 15.2799852477     ,
 11.6615963391     , 8.91895918828     , 6.87638361667     , 5.42101047759     ,
 4.43704373563     , 3.76718623993     , 3.23895942071     , 2.72467239497     ,
 2.1803010056      , 1.63424253064     , 1.14321739839     , 0.752934681732    ,
 0.481383493386    , 0.31870223939     , 0.236017870347    , 0.19951925942     ,
 0.182342170109    , 0.168997136516    , 0.155036044898    , 0.144210855564    ,
 0.141651629887    , 0.14582711409     , 0.147345238581    , 0.137545903062    ,
 0.11811082512     , 0.100194355686    , 0.0932691649164   , 0.0958493984605   ,
 0.0982865277774   , 0.0941864691346   , 0.0867564255674   , 0.0827456270693   ,
 0.0827171720909   , 0.0803815809872   , 0.0706820936835   , 0.0555704717955   ,
 0.0415095109976   , 0.0338637865963   , 0.0350762299949   , 0.0465680218475   ,
 0.0704420751461   , 0.109419466888    , 0.165034218827    , 0.2342345632      ,
 0.30832645327     , 0.379783364099    , 0.452801625029    , 0.544404009889    ,
 0.672080945265    , 0.840872526362    , 1.04265539634     , 1.26220670928     ,
 1.47399343721     , 1.63285042989     , 1.6874123983      , 1.62284707184     ,
 1.48628440118     , 1.35815462164     , 1.30687384598     , 1.37937636997     ,
 1.6066550458      , 1.9781509213      , 2.41571221224     , 2.8120114611      ,
 3.11134895352     , 3.34483304102     , 3.58624512609     , 3.87454687786     ,
 4.17045887992     , 4.38742054194     , 4.47263232693     , 4.45955698257     ,
 4.44349958273     , 4.51616392652     , 4.7255283561      , 5.07633267561     ,
 5.54176863769     , 6.07975798359     , 6.66556368037     , 7.31347440025     ,
 8.0551860125      , 8.89538380556     , 9.7657521755      , 10.4840200767     ,
 10.7901922331     , 10.5111628142     , 9.70775695987     , 8.61545429155     ,
 7.4525746669      , 6.32837348078     , 5.29619616058     , 4.40690163058     ,
 3.69653532637     , 3.17272851537     , 2.82150544389     , 2.58684100584     ,
 2.34996445867     , 1.99252285733     , 1.5048658637      , 0.999003011459    ,
 0.603302330573    , 0.367354186435    , 0.265065079524    , 0.250555427496    ,
 0.28883242403     , 0.34859198513     , 0.394206996216    , 0.400806504301    ,
 0.37451632727     , 0.346970947012    , 0.347244046475    , 0.384096351548    ,
 0.451876927414    , 0.540150417887    , 0.632797464249    , 0.709617817629    ,
 0.761920840544    , 0.805987501327    , 0.871855071252    , 0.973284297214    ,
 1.08998791184     , 1.18157366375     , 1.21848177461     , 1.19986366332     ,
 1.14618476284     , 1.07972157703     , 1.01178120431     , 0.942582480276    ,
 0.868053149986    , 0.786028968508    , 0.697196290234    , 0.602497036797    ,
 0.50422804791     , 0.411251036156    , 0.337916775131    , 0.292847290172    ,
 0.270284507605    , 0.256740788655    , 0.247756477356    , 0.257284742408    ,
 0.311161600239    , 0.435054072323    , 0.653361647213    , 1.00688242341     ,
 1.58717365211     , 2.57203732134     , 4.23111388706     , 6.88624026269     ,
 18.2582917823     , 26.3470486113     , 36.4163493518     , 48.3881419128     ,
 62.1643589934     , 77.6457629866     , 94.5317778948     , 111.99243986      ,
 128.70139774      , 143.454057328     , 155.775883987     , 165.832992092     ,
 173.835452052     , 179.580276409     , 182.348430872     , 181.118470299     ,
 175.143564176     , 164.575432713     , 150.484963873     , 134.236319972     ,
 116.946971261     , 99.5057310994     , 82.8061881207     , 67.7061649058     ,
 54.7602924344     , 44.0815368276     , 35.4472915812     , 28.4866107        ,
 22.8264895815     , 18.1962533459     , 14.4570301881     , 11.5205017985     ,
 9.25490992794     , 7.49984542735     , 6.14451558617     , 5.14267054518     ,
 4.45014319302     , 3.97184543525     , 3.57478863248     , 3.14612772025     ,
 2.6398435976      , 2.07915665522     , 1.52714671493     , 1.05278979716     ,
 0.702920201412    , 0.484678800415    , 0.369460773927    , 0.316223954108    ,
 0.29226289569     , 0.27829233589     , 0.265809051761    , 0.254511404465    ,
 0.246939037337    , 0.240530495129    , 0.226479229139    , 0.200004000218    ,
 0.170290207871    , 0.154810092349    , 0.161269941211    , 0.17737175923     ,
 0.181532037382    , 0.164313247366    , 0.136998096127    , 0.11785489076     ,
 0.112838605758    , 0.11233457901     , 0.10439442206     , 0.0871578050683   ,
 0.0687817594032   , 0.0596287219656   , 0.0666788021865   , 0.0928614516822   ,
 0.13900012963     , 0.207132397773    , 0.302221488908    , 0.427156322359    ,
 0.575118617055    , 0.733163545777    , 0.89804222898     , 1.08387066534     ,
 1.30821455459     , 1.57151902388     , 1.85224469775     , 2.11737364547     ,
 2.32937532863     , 2.44526496141     , 2.4287975511      , 2.28190832153     ,
 2.05993006132     , 1.84373287369     , 1.70085684814     , 1.67826115451     ,
 1.80785037121     , 2.08496626973     , 2.44657675733     , 2.80354518016     ,
 3.10395105763     , 3.35539844118     , 3.59161885948     , 3.82584138726     ,
 4.02804479997     , 4.14272910528     , 4.13687418314     , 4.03409529721     ,
 3.90123597902     , 3.80613627036     , 3.78844046227     , 3.85613107548     ,
 3.99468885389     , 4.18478434671     , 4.42495553687     , 4.73579357464     ,
 5.13795320221     , 5.6289861396      , 6.16337699746     , 6.62850088165     ,
 6.86592152943     , 6.77230218271     , 6.38095663522     , 5.81329634032     ,
 5.16815540717     , 4.49177556041     , 3.82562993468     , 3.22685754769     ,
 2.74019966979     , 2.38319176327     , 2.15252235535     , 2.00725370424     ,
 1.85261033842     , 1.59315863786     , 1.22244339139     , 0.834299180587    ,
 0.536950400743    , 0.374717230653    , 0.329344968705    , 0.363347682357    ,
 0.442506681926    , 0.530225290993    , 0.586538748163    , 0.589684133294    ,
 0.557540424207    , 0.536354038797    , 0.564739783352    , 0.652858694901    ,
 0.790120354125    , 0.956366501007    , 1.12241889776     , 1.25838007494     ,
 1.359091667       , 1.45797772607     , 1.60033432108     , 1.79515198744     ,
 1.99641104629     , 2.13534409665     , 2.17081838555     , 2.11218812652     ,
 2.00348890041     , 1.89005280881     , 1.791996507       , 1.69803930958     ,
 1.58125541828     , 1.4243965084      , 1.23335694539     , 1.02971927826     ,
 0.836839560164    , 0.674725494955    , 0.558662250421    , 0.492396253169    ,
 0.463350884487    , 0.453024784995    , 0.459009759304    , 0.508166762724    ,
 0.647783222038    , 0.926696250244    , 1.39044349498     , 2.10557854164     ,
 3.21338190623     , 4.98522622702     , 7.81793182752     , 12.1350672273     ,
 27.1585556275     , 37.3956099773     , 49.2804294452     , 62.2986676329     ,
 75.938541861      , 89.8035439533     , 103.503991774     , 116.377562962     ,
 127.487807302     , 136.093268301     , 142.046287617     , 145.602184901     ,
 146.938140953     , 145.936993439     , 142.265012037     , 135.579141153     ,
 125.884978698     , 113.836495114     , 100.546960722     , 87.020799513      ,
 73.8545929112     , 61.4443639035     , 50.237723067      , 40.6462287404     ,
 32.8116926085     , 26.5737717788     , 21.6353221266     , 17.7003539312     ,
 14.5148515424     , 11.9004613461     , 9.78322231538     , 8.13924978928     ,
 6.90252495579     , 5.95848189021     , 5.21535223697     , 4.64025306247     ,
 4.22266660249     , 3.92370795479     , 3.66527741349     , 3.36147979808     ,
 2.95885283297     , 2.45603412968     , 1.90186431297     , 1.37757152331     ,
 0.960056367255    , 0.682454511293    , 0.526763112637    , 0.451969867226    ,
 0.422406474418    , 0.414233338977    , 0.411558581566    , 0.405364737855    ,
 0.392060675956    , 0.368423593394    , 0.330927423407    , 0.284603404271    ,
 0.24896941802     , 0.245373729197    , 0.273522380335    , 0.304436200279    ,
 0.303219434442    , 0.26114855766     , 0.202937239744    , 0.161563291943    ,
 0.149112974816    , 0.152634137003    , 0.152763165959    , 0.141892621853    ,
 0.127173363267    , 0.122512187049    , 0.139872968545    , 0.184727330866    ,
 0.257264199432    , 0.360072396718    , 0.505003550356    , 0.706022141559    ,
 0.961113739813    , 1.24802728481     , 1.54466281314     , 1.84844438213     ,
 2.16829953768     , 2.50036271636     , 2.81719934018     , 3.07867195397     ,
 3.24665407411     , 3.29036954181     , 3.19243482899     , 2.96545282276     ,
 2.66200299912     , 2.35686242504     , 2.11601742307     , 1.98470858367     ,
 1.98999817068     , 2.12932514834     , 2.35830332662     , 2.61415715936     ,
 2.85613949384     , 3.07422485489     , 3.26881795615     , 3.43503830422     ,
 3.55664502525     , 3.60564124995     , 3.55847501334     , 3.42156168883     ,
 3.23501521729     , 3.04749284357     , 2.89127996281     , 2.77841714154     ,
 2.71035797861     , 2.68995984516     , 2.72915529552     , 2.84375996245     ,
 3.04016809262     , 3.30887718321     , 3.61969534268     , 3.91128466528     ,
 4.10260908415     , 4.1409624746      , 4.03337545156     , 3.81613525181     ,
 3.51076644566     , 3.13073477251     , 2.71295949609     , 2.31339033082     ,
 1.97543189842     , 1.71936994626     , 1.54872663702     , 1.43812741024     ,
 1.32276037956     , 1.13775576826     , 0.881206645603    , 0.621297187667    ,
 0.436699020894    , 0.361963723633    , 0.385282608387    , 0.473953206285    ,
 0.589677715765    , 0.691495091485    , 0.744981404883    , 0.743423207613    ,
 0.720329646546    , 0.730984752204    , 0.816803353022    , 0.988242979331    ,
 1.23248403526     , 1.52084994071     , 1.80916376334     , 2.05437231542     ,
 2.25113300455     , 2.44647050515     , 2.69811367105     , 3.00843331073     ,
 3.30436071552     , 3.48809391194     , 3.50891465339     , 3.39236613548     ,
 3.21291836882     , 3.04110832972     , 2.90105631496     , 2.76110076508     ,
 2.56412621327     , 2.27776510769     , 1.92303715768     , 1.55791283436     ,
 1.23866304115     , 0.997203270848    , 0.841720068799    , 0.763182192557    ,
 0.740860162417    , 0.755785919908    , 0.813423238548    , 0.957695292186    ,
 1.26096806262     , 1.8014421505      , 2.65496065941     , 3.92069233558     ,
 5.78541328094     , 8.59205989029     , 12.8221925133     , 18.9351477208     ,
 35.9883660995     , 47.2701165416     , 59.46975754       , 71.7187631982     ,
 83.2351956764     , 93.5182914803     , 102.32234509      , 109.395333906     ,
 114.378206185     , 117.069399443     , 117.628818966     , 116.357418694     ,
 113.371019035     , 108.587815943     , 101.925685697     , 93.4667071362     ,
 83.5923958541     , 73.022276279      , 62.5657000087     , 52.7513318751     ,
 43.7636599914     , 35.7095469796     , 28.7902143298     , 23.1689557935     ,
 18.7880983049     , 15.3995704989     , 12.7355711477     , 10.6031722796     ,
 8.86696977087     , 7.43789080688     , 6.29390132061     , 5.44917111628     ,
 4.87807584453     , 4.49560960232     , 4.21139881469     , 3.97783674422     ,
 3.78742335953     , 3.63833235218     , 3.50307102266     , 3.32621405877     ,
 3.05047264841     , 2.64899234075     , 2.14863572928     , 1.62981381564     ,
 1.18722507696     , 0.875136300032    , 0.689952942895    , 0.598359419319    ,
 0.5676785775      , 0.571985828489    , 0.58796292888     , 0.59618592033     ,
 0.58419213805     , 0.545925456839    , 0.483665109899    , 0.41561964789     ,
 0.374763403776    , 0.385540120375    , 0.43500909203     , 0.473600151015    ,
 0.454371104772    , 0.374636245427    , 0.276755298576    , 0.209103686523    ,
 0.189577554765    , 0.202890815115    , 0.222786788014    , 0.233172164455    ,
 0.235251853956    , 0.242950390072    , 0.272497186023    , 0.3327021117      ,
 0.424707063877    , 0.554676865576    , 0.745862163251    , 1.02780034078     ,
 1.40495419563     , 1.84107680419     , 2.28278143089     , 2.69541401217     ,
 3.07058746695     , 3.40491487204     , 3.68152205684     , 3.87348596217     ,
 3.95856099542     , 3.92544303388     , 3.77092430085     , 3.50427510377     ,
 3.16028620783     , 2.79861082471     , 2.48098695235     , 2.25118551221     ,
 2.13236497459     , 2.12460425791     , 2.20092087365     , 2.32241011274     ,
 2.46103616116     , 2.60030030424     , 2.72462131278     , 2.82213233078     ,
 2.88710435452     , 2.90672216545     , 2.85784752748     , 2.730706791       ,
 2.5460363443      , 2.33832047096     , 2.13141674747     , 1.93764926988     ,
 1.77049360113     , 1.64920222066     , 1.59245046259     , 1.60906278621     ,
 1.69478127375     , 1.83689516482     , 2.01693824343     , 2.20769167766     ,
 2.37659564266     , 2.49836634428     , 2.55822579722     , 2.54008936687     ,
 2.42523244375     , 2.21451007269     , 1.94400660956     , 1.66685525971     ,
 1.42314721271     , 1.23200467047     , 1.09709225851     , 1.00092113782     ,
 0.902434712174    , 0.76475821351     , 0.592361763667    , 0.432243334614    ,
 0.33765416626     , 0.334818659096    , 0.415882891737    , 0.547531783607    ,
 0.683555457608    , 0.781661262904    , 0.82287457225     , 0.824453641166    ,
 0.834748964577    , 0.908160662235    , 1.07948705098     , 1.35826802232     ,
 1.73509236837     , 2.1793080565      , 2.63529946613     , 3.04521588014     ,
 3.39445762713     , 3.729375759       , 4.11022155403     , 4.53547727173     ,
 4.91646249543     , 5.13474270368     , 5.1310240234      , 4.94610756244     ,
 4.68477676822     , 4.43951767098     , 4.23150166301     , 4.00504284592     ,
 3.6780273891      , 3.21410929121     , 2.65981098971     , 2.11520669947     ,
 1.669534736       , 1.36147416161     , 1.18516891809     , 1.11570363847     ,
 1.12794163164     , 1.21024983526     , 1.3816309431      , 1.70279611578     ,
 2.26730214865     , 3.1813012345      , 4.55464166433     , 6.5203040877      ,
 9.29089467243     , 13.2222921608     , 18.7836218765     , 26.3587492204     ,
 42.8544480155     , 53.6272797868     , 64.3764720967     , 74.1268042678     ,
 82.1070400357     , 87.9470476099     , 91.6785035014     , 93.4777576234     ,
 93.4783747467     , 91.8733252559     , 89.0017063972     , 85.1564834592     ,
 80.3820176945     , 74.56981078       , 67.7096759108     , 60.0233000029     ,
 51.9517126465     , 44.0458906717     , 36.7596539537     , 30.2821120043     ,
 24.604599917      , 19.7325732716     , 15.7544557252     , 12.7071736784     ,
 10.4589162443     , 8.7659124016      , 7.41585248484     , 6.29386696904     ,
 5.34847449212     , 4.55869925782     , 3.94011490213     , 3.52693081072     ,
 3.31726051829     , 3.25054775929     , 3.24240859452     , 3.23185387359     ,
 3.20218103023     , 3.16507645951     , 3.12175753247     , 3.04019002012     ,
 2.86985810019     , 2.5762417686      , 2.17253872744     , 1.72765584925     ,
 1.33077073182     , 1.0372210411      , 0.851618688832    , 0.754208515796    ,
 0.724894951756    , 0.743354392183    , 0.784127918332    , 0.82061276533     ,
 0.830545516143    , 0.798322897532    , 0.723095628309    , 0.631906998408    ,
 0.573962791961    , 0.582434178593    , 0.635491964918    , 0.665234926014    ,
 0.615670470261    , 0.492545533213    , 0.354941974278    , 0.263705707715    ,
 0.241679125835    , 0.273353828426    , 0.327037503285    , 0.375633270344    ,
 0.408963162521    , 0.436032484172    , 0.474679202791    , 0.536938791725    ,
 0.627724639227    , 0.761465936746    , 0.975938535854    , 1.31580947905     ,
 1.7898814697      , 2.34595088326     , 2.89630858237     , 3.36960695454     ,
 3.73806752998     , 4.00441841725     , 4.17574820825     , 4.25354293214     ,
 4.2410345658      , 4.1470237778      , 3.9765767032      , 3.72754779531     ,
 3.40738104362     , 3.04812313798     , 2.69586973199     , 2.39115776094     ,
 2.16246397264     , 2.02282614073     , 1.96395945478     , 1.96385212762     ,
 2.00204747923     , 2.06052078662     , 2.119088409       , 2.16391214942     ,
 2.19238712848     , 2.19725430635     , 2.15721458728     , 2.05765490164     ,
 1.90946517233     , 1.73425639672     , 1.54317640301     , 1.34270795763     ,
 1.15121468206     , 0.997561563143    , 0.904498242969    , 0.87700693457     ,
 0.90585850041     , 0.979128204907    , 1.08866594179     , 1.22864928146     ,
 1.39066673925     , 1.55683607147     , 1.69432775267     , 1.76096841061     ,
 1.72595393496     , 1.59216230435     , 1.39791852915     , 1.19356920037     ,
 1.01564855722     , 0.87956969671     , 0.783233899788    , 0.70811306304     ,
 0.626029258656    , 0.519640554736    , 0.399766408893    , 0.300686496337    ,
 0.259638769905    , 0.297966631029    , 0.409807441539    , 0.55935791403     ,
 0.694479112055    , 0.776515939568    , 0.806247739856    , 0.824986685028    ,
 0.890405824025    , 1.04704122735     , 1.31561677579     , 1.70344935152     ,
 2.21027135077     , 2.8129716672      , 3.45269912369     , 4.05804226995     ,
 4.5947605193      , 5.08960548355     , 5.59251211007     , 6.10475942954     ,
 6.54280021322     , 6.78251131435     , 6.75416777369     , 6.50235524049     ,
 6.15209461303     , 5.81182053761     , 5.49824596973     , 5.13977995176     ,
 4.648346862       , 4.00194185596     , 3.27560512334     , 2.59818453668     ,
 2.07428119639     , 1.73907005382     , 1.57312988623     , 1.5441869129      ,
 1.6344259568      , 1.84894243219     , 2.22189589394     , 2.82219810889     ,
 3.74918191701     , 5.12170771463     , 7.07293883474     , 9.75907004059     ,
 13.3908125358     , 18.2694876452     , 24.7423286741     , 33.0047976709     ,
 46.2184969368     , 55.0569280485     , 62.9932823995     , 69.2326533552     ,
 73.2882634388     , 75.0769350644     , 74.8813548252     , 73.1212331632     ,
 70.1642989214     , 66.3609330655     , 62.0875976477     , 57.5989148184     ,
 52.8880631154     , 47.7985745566     , 42.2765898274     , 36.4965361815     ,
 30.7909200168     , 25.4938576819     , 20.8057583066     , 16.759839852      ,
 13.3179136034     , 10.4859670559     , 8.30924805764     , 6.76943232587     ,
 5.72662607367     , 4.9757473016      , 4.35220136047     , 3.78343833486     ,
 3.26277898335     , 2.81063245257     , 2.46424025675     , 2.26336165728     ,
 2.21559525498     , 2.27976217756     , 2.3875375795      , 2.48101816833     ,
 2.53884297538     , 2.57032602145     , 2.58149698676     , 2.55252633951     ,
 2.44958826731     , 2.25153922131     , 1.97130343547     , 1.65956025517     ,
 1.37706779624     , 1.15702036609     , 1.00175665327     , 0.90846897775     ,
 0.879409611029    , 0.909123493182    , 0.977623249039    , 1.05768495481     ,
 1.11892347604     , 1.12760928903     , 1.06333612125     , 0.949072544847    ,
 0.850343486796    , 0.820767360199    , 0.844415157695    , 0.845690427875    ,
 0.762670610917    , 0.604870359307    , 0.439506148105    , 0.333843094469    ,
 0.315470097413    , 0.371986893242    , 0.468866969549    , 0.567680632463    ,
 0.643635416902    , 0.695604445259    , 0.737929935631    , 0.784361352746    ,
 0.847282187805    , 0.954128785524    , 1.1559779118      , 1.50468070012     ,
 2.00731377011     , 2.60028000056     , 3.17551073763     , 3.63906373378     ,
 3.95084166229     , 4.12009863854     , 4.17589613493     , 4.14549443075     ,
 4.05277713078     , 3.92076588791     , 3.76202809887     , 3.56933456391     ,
 3.32632518326     , 3.02774963135     , 2.68752838797     , 2.33710248961     ,
 2.0206830681      , 1.77851220843     , 1.62549814443     , 1.55028216986     ,
 1.53127981393     , 1.54510318587     , 1.56818354951     , 1.584917408       ,
 1.59132054336     , 1.58241219572     , 1.54461903606     , 1.47050510775     ,
 1.36921593974     , 1.25035251301     , 1.10970158222     , 0.943681080593    ,
 0.769366296104    , 0.619453291465    , 0.519439300484    , 0.473829156147    ,
 0.472603817449    , 0.506614107005    , 0.576068013616    , 0.687481557813    ,
 0.841500004009    , 1.01765988811     , 1.17104252727     , 1.2516059071      ,
 1.23324774781     , 1.1280301559      , 0.976380900459    , 0.824063247259    ,
 0.70282294963     , 0.622737372011    , 0.572731064605    , 0.52755458559     ,
 0.463907474593    , 0.377486170378    , 0.285962490862    , 0.218136161981    ,
 0.201876560676    , 0.254241670579    , 0.36917245196     , 0.510359872567    ,
 0.626678253334    , 0.688168602242    , 0.712639533254    , 0.756996124823    ,
 0.880580569059    , 1.11425544871     , 1.46301406048     , 1.93157240177     ,
 2.53171274163     , 3.25468125958     , 4.04593389561     , 4.82400325119     ,
 5.53070459037     , 6.16215880968     , 6.74970880428     , 7.30287533766     ,
 7.76094947787     , 8.00879127616     , 7.96418910461     , 7.65878160539     ,
 7.22087014799     , 6.7692144245      , 6.32358946565     , 5.81475171753     ,
 5.17191841597     , 4.40202895721     , 3.60079922873     , 2.89787676678     ,
 2.38422709715     , 2.07986605836     , 1.9606654843      , 2.00615791005     ,
 2.22305173827     , 2.641428211       , 3.30741896798     , 4.28333236577     ,
 5.65023597678     , 7.51022307865     , 9.98841358773     , 13.2347332227     ,
 17.4298386454     , 22.78194524       , 29.4588321339     , 37.4159681548     ,
 45.3745382148     , 51.4940015043     , 56.1522730394     , 58.9066037128     ,
 59.6699792562     , 58.6513060832     , 56.248683473      , 52.8867945084     ,
 48.9151470799     , 44.6541192841     , 40.4282916315     , 36.4483342105     ,
 32.6912028446     , 28.9791501322     , 25.1951755312     , 21.4045574815     ,
 17.7899955377     , 14.5138805577     , 11.643231262      , 9.17308884436     ,
 7.09911022724     , 5.45515642612     , 4.27542165366     , 3.52910815952     ,
 3.09953650332     , 2.82732734685     , 2.58300034622     , 2.31240250663     ,
 2.02604325872     , 1.76275242958     , 1.56651438882     , 1.47126085041     ,
 1.48239502063     , 1.5709290789      , 1.68956448554     , 1.79809790619     ,
 1.88070641607     , 1.93994842618     , 1.97368383338     , 1.96640161805     ,
 1.90398175821     , 1.78760581603     , 1.63587626122     , 1.47838178951     ,
 1.33748761808     , 1.21426638941     , 1.10418073414     , 1.02216198022     ,
 0.995718616685    , 1.03689463942     , 1.13458421837     , 1.26669784757     ,
 1.39948922848     , 1.4780081661      , 1.44939633978     , 1.31757525295     ,
 1.15896020868     , 1.05690693858     , 1.01990416763     , 0.980514009908    ,
 0.87405026377     , 0.703755865041    , 0.531208874386    , 0.422669481694    ,
 0.411097950329    , 0.49129497695     , 0.63015772123     , 0.781476576985    ,
 0.906392678087    , 0.988745359057    , 1.03209115391     , 1.04934397768     ,
 1.06434574674     , 1.12067624171     , 1.27687234549     , 1.57926528793     ,
 2.02639048786     , 2.5539043322      , 3.05943556345     , 3.45246458908     ,
 3.69110789664     , 3.78344145234     , 3.76359078412     , 3.66808440091     ,
 3.52884251381     , 3.37610951279     , 3.23285997699     , 3.09991797965     ,
 2.95022491877     , 2.74268809242     , 2.45047779321     , 2.08933397271     ,
 1.72080993057     , 1.41710506795     , 1.21721852024     , 1.116359962       ,
 1.08593299377     , 1.09292320733     , 1.10948693404     , 1.11957074225     ,
 1.11819299661     , 1.10148206221     , 1.06379337571     , 1.00794241003     ,
 0.945713210646    , 0.879127276283    , 0.792283554481    , 0.672332758951    ,
 0.531885858938    , 0.402885377936    , 0.311356410911    , 0.262223742499    ,
 0.246270113718    , 0.256860783733    , 0.299000349407    , 0.384545913889    ,
 0.51655711344     , 0.672825536524    , 0.806690625295    , 0.872306717668    ,
 0.853041442698    , 0.767313856334    , 0.653381574724    , 0.55083730624     ,
 0.486866326107    , 0.465593692972    , 0.464330020548    , 0.447101684059    ,
 0.392012811384    , 0.307503875626    , 0.222237300681    , 0.165329022814    ,
 0.157539771322    , 0.208723003222    , 0.309337363976    , 0.424824249823    ,
 0.511847791214    , 0.552267810905    , 0.57448032151     , 0.639160184663    ,
 0.799878876087    , 1.07478824963     , 1.45760220357     , 1.95244991642     ,
 2.58255436416     , 3.35340962639     , 4.21689107659     , 5.08608867223     ,
 5.88530167503     , 6.58518615356     , 7.19923811807     , 7.743814057       ,
 8.18416396859     , 8.42267642072     , 8.36847709265     , 8.03070709963     ,
 7.52551036219     , 6.97653386898     , 6.41647584645     , 5.79561653608     ,
 5.07422266834     , 4.29024701992     , 3.54572418551     , 2.94417526714     ,
 2.53788283156     , 2.32361728229     , 2.28362162675     , 2.42783449862     ,
 2.80080497619     , 3.46160508279     , 4.46452082884     , 5.8536182561      ,
 7.67011727154     , 9.96554398207     , 12.8116756675     , 16.3064237445     ,
 20.5743721923     , 25.7347899623     , 31.8027284526     , 38.5415728917     ,
 40.6509998216     , 44.0694320073     , 45.9088094487     , 46.0696109884     ,
 44.7808812624     , 42.4185072233     , 39.349471565      , 35.852781623      ,
 32.1356247823     , 28.4165460771     , 24.9455550991     , 21.8944608695     ,
 19.2469151156     , 16.842494625      , 14.537196798      , 12.3069528335     ,
 10.2123007483     , 8.30813397106     , 6.60688394166     , 5.1087844061      ,
 3.84142329323     , 2.85683656414     , 2.18930068621     , 1.81702760654     ,
 1.657173257       , 1.59384849536     , 1.52637073934     , 1.40979996981     ,
 1.25715526166     , 1.10962512018     , 1.00706972873     , 0.971576316105    ,
 1.00048693742     , 1.07100367001     , 1.15509298521     , 1.23430470106     ,
 1.30403594352     , 1.36288079506     , 1.40013328759     , 1.402303324       ,
 1.37066531358     , 1.32300113264     , 1.27940008072     , 1.24895378082     ,
 1.22201013888     , 1.17658776471     , 1.10676293113     , 1.04310618384     ,
 1.03075268885     , 1.0913574231      , 1.21854830764     , 1.39652032001     ,
 1.59415181121     , 1.7428172426      , 1.760015416       , 1.62437540506     ,
 1.41242823555     , 1.23315474863     , 1.12778890206     , 1.05030993092     ,
 0.938206212026    , 0.780864942477    , 0.622308812346    , 0.520961203692    ,
 0.514921032229    , 0.609470419869    , 0.778515175803    , 0.974994564593    ,
 1.14933871153     , 1.26608703235     , 1.31072962021     , 1.29353173723     ,
 1.25359489512     , 1.25158054225     , 1.34623707854     , 1.56773804145     ,
 1.90274451412     , 2.29761036798     , 2.67851694495     , 2.97848055842     ,
 3.15751649875     , 3.20936217516     , 3.15504538023     , 3.02806347005     ,
 2.86323245277     , 2.6958777531      , 2.55893090276     , 2.46562790965     ,
 2.38936824864     , 2.26728965812     , 2.04079542039     , 1.70835328275     ,
 1.33857377213     , 1.02354237455     , 0.818382066125    , 0.722542207819    ,
 0.702001485047    , 0.717247740801    , 0.739596533782    , 0.755834358625    ,
 0.761504732393    , 0.75120385143     , 0.720906970773    , 0.678389890342    ,
 0.638709458189    , 0.603299314015    , 0.553459482677    , 0.472398510577    ,
 0.367889351284    , 0.267266285015    , 0.193610712258    , 0.151133088375    ,
 0.131545080094    , 0.129642193768    , 0.151417430302    , 0.208916771427    ,
 0.305793068484    , 0.423867362423    , 0.525645329481    , 0.576322022144    ,
 0.565493549082    , 0.509206870698    , 0.438419729866    , 0.387855589789    ,
 0.38329770331     , 0.422924220357    , 0.46868767786     , 0.469594298722    ,
 0.404213094944    , 0.297643809596    , 0.196066602907    , 0.133799966185    ,
 0.124849276918    , 0.168479753176    , 0.248453138893    , 0.332303401988    ,
 0.387378725269    , 0.407619457977    , 0.425726222005    , 0.496121533396    ,
 0.660619292611    , 0.927215670531    , 1.28544509334     , 1.74240619767     ,
 2.32955281506     , 3.06089123969     , 3.89271254292     , 4.73830567117     ,
 5.51851769107     , 6.19538645241     , 6.77196603572     , 7.26368429677     ,
 7.65086082697     , 7.85551827519     , 7.79045785212     , 7.44759935219     ,
 6.92312988998     , 6.33694470018     , 5.73575465824     , 5.09494879056     ,
 4.40488646806     , 3.7246528588      , 3.14887677558     , 2.74214338828     ,
 2.50994637309     , 2.4257183026      , 2.48418243199     , 2.73060864208     ,
 3.24671974384     , 4.1178565858      , 5.40606841975     , 7.13647921016     ,
 9.30195487555     , 11.8808794452     , 14.8544790503     , 18.2283754257     ,
 22.0536018967     , 26.3911398198     , 31.1865729151     , 36.132435322      ,
 33.3152111068     , 34.6452497211     , 34.6469509381     , 33.4340497965     ,
 31.3637614717     , 28.8175774788     , 26.044504495      , 23.1538619442     ,
 20.2179274746     , 17.3728594728     , 14.8110935656     , 12.6693399348     ,
 10.9383175533     , 9.49326535454     , 8.2024137337      , 6.99934357848     ,
 5.87255610349     , 4.82158511955     , 3.84140370912     , 2.94108179401     ,
 2.15927891952     , 1.5488661686      , 1.14308769277     , 0.933349357242    ,
 0.86884600525     , 0.872448687881    , 0.870905738908    , 0.8275963736      ,
 0.751723955551    , 0.677374963908    , 0.635034010829    , 0.635513745712    ,
 0.669269473001    , 0.717003428876    , 0.763790637176    , 0.806962091104    ,
 0.851571894095    , 0.896698793614    , 0.92957082359     , 0.939918954311    ,
 0.936715327282    , 0.942052693446    , 0.969610406161    , 1.01161586017     ,
 1.04167777324     , 1.03319870535     , 0.988374276825    , 0.948570506856    ,
 0.963305310599    , 1.05164075555     , 1.20406761379     , 1.40691750949     ,
 1.63481512721     , 1.82044917226     , 1.8719813579      , 1.75139136539     ,
 1.52377808032     , 1.30368033556     , 1.15478304002     , 1.05614208615     ,
 0.95455335656     , 0.826996817801    , 0.69622280152     , 0.608483957378    ,
 0.604585327274    , 0.700930084276    , 0.883169113118    , 1.11033293278     ,
 1.32586388075     , 1.4730458017      , 1.5164216964      , 1.46464855691     ,
 1.37433786272     , 1.32143663404     , 1.35990858251     , 1.50084928621     ,
 1.72113799486     , 1.98396363111     , 2.25063964317     , 2.47913412554     ,
 2.6241329918      , 2.65360435346     , 2.56959296992     , 2.40688229443     ,
 2.21199193372     , 2.02818905377     , 1.89076147914     , 1.81521142933     ,
 1.77738487415     , 1.71173596207     , 1.55003370788     , 1.27892299772     ,
 0.958849567714    , 0.679714379927    , 0.498912775581    , 0.418957704789    ,
 0.40762491151     , 0.427823854932    , 0.45584106299     , 0.483167593871    ,
 0.505221649359    , 0.512016858785    , 0.495243538396    , 0.461641773958    ,
 0.42839169043     , 0.401689377931    , 0.368301341539    , 0.313389141075    ,
 0.240715616945    , 0.170105972183    , 0.118531342745    , 0.0882802236024   ,
 0.0721644470609   , 0.0658922424432   , 0.0741190946106   , 0.106242555281    ,
 0.166131272447    , 0.243447712282    , 0.315434266328    , 0.360174815432    ,
 0.369160471988    , 0.349879021785    , 0.323940349938    , 0.32360995267     ,
 0.375693610198    , 0.472128067223    , 0.557769294303    , 0.565703227958    ,
 0.475740257407    , 0.331690828238    , 0.199722130506    , 0.121262829213    ,
 0.104246417846    , 0.137010217479    , 0.196091090334    , 0.250788442364    ,
 0.278335956458    , 0.282271251531    , 0.294796450436    , 0.358271420103    ,
 0.49952237509     , 0.718605746711    , 1.00618530392     , 1.37405256768     ,
 1.85699428871     , 2.47120775458     , 3.17673797729     , 3.8941318674      ,
 4.5542552696      , 5.12623786688     , 5.61064988371     , 6.01493975458     ,
 6.32157251594     , 6.47131612975     , 6.39512232788     , 6.08142216811     ,
 5.60491811508     , 5.06920723774     , 4.52479145359     , 3.96645712226     ,
 3.40519292149     , 2.9070258507      , 2.55007381405     , 2.36276740084     ,
 2.31469734006     , 2.36533606431     , 2.52131750861     , 2.85111175335     ,
 3.45730252504     , 4.44162069182     , 5.87481377081     , 7.77006393674     ,
 10.0767822195     , 12.6984319047     , 15.518509482      , 18.443748736      ,
 21.4576232356     , 24.6003266223     , 27.8306674281     , 30.8886299191     ,
 25.0999438508     , 25.1695034517     , 24.32270849       , 22.7459996693     ,
 20.7665564124     , 18.6661232167     , 16.563571438      , 14.4538066441     ,
 12.3409545212     , 10.3240088119     , 8.55708770654     , 7.14056151203     ,
 6.06177109186     , 5.229542814       , 4.5438049624      , 3.93486334575     ,
 3.36366186559     , 2.80843035002     , 2.26033586106     , 1.73091285853     ,
 1.2547588666      , 0.874264429732    , 0.616529697259    , 0.481164171081    ,
 0.441297886119    , 0.451391954465    , 0.463700034263    , 0.450883711364    ,
 0.416873721785    , 0.385023129159    , 0.375992275214    , 0.39400565151     ,
 0.427815226829    , 0.461452829109    , 0.486034722425    , 0.504810076109    ,
 0.527084768816    , 0.555339566925    , 0.581293176792    , 0.599347893522    ,
 0.619477561223    , 0.658659155998    , 0.720216754957    , 0.785551316922    ,
 0.825162658467    , 0.820844649118    , 0.786907880026    , 0.769121050866    ,
 0.811501364418    , 0.923865925277    , 1.08884540961     , 1.28877435294     ,
 1.50247904971     , 1.67769486365     , 1.73940985763     , 1.6511074717      ,
 1.45947475762     , 1.25864137726     , 1.11149444095     , 1.01529271713     ,
 0.932386342558    , 0.836641629584    , 0.735032834651    , 0.661517237462    ,
 0.65601947393     , 0.743333081512    , 0.921669747497    , 1.15923956251     ,
 1.39557042646     , 1.55633889913     , 1.59037447915     , 1.50825326307     ,
 1.38168231824     , 1.29606496504     , 1.29900663831     , 1.38775572227     ,
 1.53490282201     , 1.71830277615     , 1.92375021193     , 2.12096268422     ,
 2.25032561454     , 2.25321219091     , 2.12050265674     , 1.90143811959     ,
 1.6657152911      , 1.46637730237     , 1.33059712462     , 1.26139744437     ,
 1.23313975689     , 1.19175240113     , 1.08041168507     , 0.882687711637    ,
 0.640945015553    , 0.42515807221     , 0.283235350684    , 0.219896608841    ,
 0.211235076881    , 0.229937962208    , 0.26051761135     , 0.298050843956    ,
 0.335727474414    , 0.358122574272    , 0.352037961648    , 0.321754728733    ,
 0.285535200228    , 0.255351358853    , 0.226303262845    , 0.188257241186    ,
 0.141821935997    , 0.0984164098502   , 0.067849904927    , 0.0503313030553   ,
 0.040169124482    , 0.034115351651    , 0.0351006211879   , 0.0493650405149   ,
 0.0806181335177   , 0.125688430022    , 0.175037185903    , 0.217640827658    ,
 0.24583314509     , 0.259527680512    , 0.272769766521    , 0.314988271711    ,
 0.411121101041    , 0.546026610278    , 0.652887249855    , 0.657348376729    ,
 0.543778445044    , 0.369712589288    , 0.213502095714    , 0.119844024106    ,
 0.0920850778318   , 0.111688768237    , 0.151564558469    , 0.183823280751    ,
 0.19328382026     , 0.188808389131    , 0.198430915648    , 0.250851279376    ,
 0.358441259574    , 0.515411465669    , 0.715185751809    , 0.972290118291    ,
 1.31941255647     , 1.7714528906      , 2.29513270509     , 2.82535408802     ,
 3.30997005393     , 3.73127672101     , 4.09180993817     , 4.39076426313     ,
 4.6083090402      , 4.70230914614     , 4.62815806032     , 4.37960762654     ,
 4.01002320383     , 3.59596363567     , 3.17923123799     , 2.76512805049     ,
 2.37544377172     , 2.07146430048     , 1.91106193476     , 1.89863441993     ,
 1.9896815487      , 2.14474351242     , 2.37810112705     , 2.76046690482     ,
 3.39179927132     , 4.37591570863     , 5.78931201327     , 7.63856290439     ,
 9.84030993366     , 12.2392641345     , 14.6461952332     , 16.9027355795     ,
 18.9608165998     , 20.8766642455     , 22.6682787568     , 24.1769181028     ,
 17.5276312366     , 17.0531572141     , 16.0364716027     , 14.652390465      ,
 13.1339880491     , 11.6433362253     , 10.2063148543     , 8.77258217013     ,
 7.33488485374     , 5.97958154981     , 4.82642109093     , 3.93775054523     ,
 3.29244342916     , 2.8258219012      , 2.47137913362     , 2.17468923985     ,
 1.89565781939     , 1.61035049881     , 1.3117436326      , 1.01035796149     ,
 0.731236187856    , 0.502350447873    , 0.341172938726    , 0.24962829715     ,
 0.215787712525    , 0.216599363029    , 0.224777693977    , 0.2220153888      ,
 0.208277103539    , 0.196969521284    , 0.200908219994    , 0.222206155004    ,
 0.25233833705     , 0.279179041649    , 0.295270559701    , 0.302712414522    ,
 0.310361079345    , 0.324282481871    , 0.342926442221    , 0.364996309014    ,
 0.397969989063    , 0.451185633667    , 0.520106061861    , 0.582474970246    ,
 0.612518167459    , 0.601695902027    , 0.571653591672    , 0.566259568089    ,
 0.621555298246    , 0.740209051062    , 0.898478371357    , 1.07146216546     ,
 1.2389441177      , 1.36982964284     , 1.42248015522     , 1.37684919082     ,
 1.26068524133     , 1.13050885248     , 1.02687143442     , 0.95282884911     ,
 0.887632430404    , 0.812547848454    , 0.729563211012    , 0.664507531863    ,
 0.653549984701    , 0.724401341631    , 0.883498233572    , 1.10669261959     ,
 1.33352153272     , 1.48312938912     , 1.50079214879     , 1.40127010921     ,
 1.26171056353     , 1.16685792182     , 1.15872852424     , 1.23007073417     ,
 1.35414807205     , 1.51467611054     , 1.70382171926     , 1.89032774988     ,
 2.00312269184     , 1.97090504478     , 1.78576173018     , 1.51531976968     ,
 1.25011067339     , 1.0482991863      , 0.923160168558    , 0.859416695357    ,
 0.82777148798     , 0.790248140399    , 0.710473428913    , 0.575641122383    ,
 0.41007412994     , 0.259084630178    , 0.156505368447    , 0.107933514821    ,
 0.0992150251409   , 0.114211856229    , 0.144827360194    , 0.187400517473    ,
 0.231968928769    , 0.259771348808    , 0.256278477635    , 0.225365052914    ,
 0.185512836102    , 0.151746813033    , 0.125131328548    , 0.0996360393172   ,
 0.0737117124367   , 0.0519611949028   , 0.0382586829843   , 0.0310974663064   ,
 0.0260732966194   , 0.0210841247191   , 0.0182824662936   , 0.0219370072157   ,
 0.0353263088359   , 0.0591675175226   , 0.0916999388001   , 0.129089476411    ,
 0.166126499963    , 0.200704599494    , 0.242577596414    , 0.314610506371    ,
 0.432682963342    , 0.57432860195     , 0.673538367284    , 0.665138621106    ,
 0.543062875052    , 0.367273716037    , 0.211953403635    , 0.1165387715      ,
 0.0814622601482   , 0.0878988746804   , 0.111216439187    , 0.128753028866    ,
 0.13073755935     , 0.12684328276     , 0.138310102328    , 0.181608504827    ,
 0.258376870309    , 0.359598868026    , 0.480859386849    , 0.635809866605    ,
 0.850910110062    , 1.13868528802     , 1.47577677502     , 1.81549991792     ,
 2.12306645518     , 2.39171828905     , 2.62676829634     , 2.82441200199     ,
 2.96624847557     , 3.02470767671     , 2.97471081654     , 2.81394164668     ,
 2.5751119532      , 2.30558409391     , 2.03324615476     , 1.76763001357     ,
 1.53369899104     , 1.38112174146     , 1.34892064329     , 1.4320036449      ,
 1.59291558671     , 1.80616219985     , 2.08849916529     , 2.49410811467     ,
 3.10034986363     , 3.99930544965     , 5.2664291134      , 6.90311961234     ,
 8.80517859215     , 10.7828337001     , 12.61315821       , 14.1236105073     ,
 15.2824261513     , 16.1907172178     , 16.9332990613     , 17.4407783833     ,
 11.464091518      , 10.8959084119     , 10.0324111945     , 9.00822468849     ,
 7.97078309819     , 6.99741887887     , 6.07093413144     , 5.14104149883     ,
 4.21024798965     , 3.35102997787     , 2.64495691893     , 2.12114373114     ,
 1.75478436036     , 1.50298289808     , 1.32515970963     , 1.18335223347     ,
 1.04622744606     , 0.897178950239    , 0.735166149845    , 0.570065175221    ,
 0.416962575093    , 0.28936357806     , 0.194545602345    , 0.133946602952    ,
 0.104412297892    , 0.0970756331641   , 0.0984888107133   , 0.0975094666831   ,
 0.0921338445392   , 0.0886755803897   , 0.0944284057482   , 0.111305245923    ,
 0.134724348677    , 0.156456819108    , 0.169456573876    , 0.172965012362    ,
 0.173373590132    , 0.178255282512    , 0.190611139792    , 0.211478244109    ,
 0.245306073535    , 0.296228378113    , 0.357588235582    , 0.409760722461    ,
 0.432256003555    , 0.42048190417     , 0.394549940615    , 0.39142176766     ,
 0.441059299986    , 0.545053548492    , 0.678685380168    , 0.811762290544    ,
 0.923920755955    , 1.00333923944     , 1.04188704962     , 1.03960369133     ,
 1.00966401068     , 0.970145934944    , 0.930486624707    , 0.888154547795    ,
 0.83472694868     , 0.764782935608    , 0.685689473335    , 0.621088964305    ,
 0.601785422696    , 0.652069314616    , 0.779566927359    , 0.964534319775    ,
 1.15250765394     , 1.27113438038     , 1.27478149192     , 1.18009910045     ,
 1.05499778108     , 0.97200385832     , 0.968973025435    , 1.04286437876     ,
 1.17045393708     , 1.3318526637      , 1.5114929007      , 1.67433028911     ,
 1.75360344565     , 1.68728567616     , 1.47655641754     , 1.19566771516     ,
 0.937686749475    , 0.756081153323    , 0.652081952033    , 0.598465978906    ,
 0.564843904057    , 0.526374018511    , 0.464054571589    , 0.371068542237    ,
 0.260604397207    , 0.159255779341    , 0.0883568367907   , 0.052604297737    ,
 0.0446852442631   , 0.0564879193117   , 0.0844116584275   , 0.12472375622     ,
 0.165755940556    , 0.189165896004    , 0.182958180197    , 0.152242624456    ,
 0.114168828882    , 0.0829188394618   , 0.0615651194986   , 0.0465699358505   ,
 0.035709534374    , 0.0298152100522   , 0.0289388804484   , 0.0297847881162   ,
 0.0280211974495   , 0.022408238518    , 0.0157908235334   , 0.0124453684068   ,
 0.0154343463063   , 0.0263126726125   , 0.0458793539181   , 0.0739417741746   ,
 0.10907122754     , 0.151769038647    , 0.209835860365    , 0.296162754138    ,
 0.412312582809    , 0.530166606748    , 0.596790595016    , 0.570548831356    ,
 0.458029163042    , 0.310523705593    , 0.183214211461    , 0.102674984016    ,
 0.0676378844497   , 0.0642998691096   , 0.0753628956173   , 0.0852838168296   ,
 0.0879140639717   , 0.0902759277942   , 0.105588969987    , 0.141202806729    ,
 0.193256168798    , 0.252673456387    , 0.316654622207    , 0.395702708521    ,
 0.508459469646    , 0.664603288767    , 0.850659959729    , 1.03755841023     ,
 1.20460471948     , 1.35117231368     , 1.48417182585     , 1.60179343406     ,
 1.69175430406     , 1.73748031844     , 1.72398311248     , 1.64750559994     ,
 1.52334151798     , 1.37632879123     , 1.22309043349     , 1.07386128013     ,
 0.950879321492    , 0.889805359463    , 0.91578226131     , 1.02559211927     ,
 1.20050168417     , 1.43373194965     , 1.73995574294     , 2.14679717753     ,
 2.69822779551     , 3.46491684485     , 4.51525773885     , 5.84835427693     ,
 7.35402317279     , 8.83360484569     , 10.0648401301     , 10.8993042423     ,
 11.3505701344     , 11.5707055321     , 11.6932216901     , 11.7002686903     ,
 7.10971965183     , 6.64409922381     , 6.01624195796     , 5.31817755963     ,
 4.64176701934     , 4.02433337643     , 3.44352665894     , 2.86598439514     ,
 2.30003050711     , 1.79496907275     , 1.39562398214     , 1.10973360428     ,
 0.917038377485    , 0.792283412127    , 0.710521039898    , 0.64433296232     ,
 0.571961341001    , 0.487268005721    , 0.397191570271    , 0.311833005859    ,
 0.237400948965    , 0.174721155045    , 0.122579362456    , 0.0820213781934   ,
 0.0557920533805   , 0.0435479670186   , 0.039877614749    , 0.0381841088973   ,
 0.0357684602414   , 0.0347093855074   , 0.0386375170768   , 0.0492389006419   ,
 0.0647494718503   , 0.0802561844271   , 0.0900867895958   , 0.092166369359    ,
 0.0904065685886   , 0.0913660552778   , 0.0990645872928   , 0.11494521984     ,
 0.14139308895     , 0.18062466651     , 0.228269663209    , 0.270907000929    ,
 0.293108280359    , 0.28917459105     , 0.271269967002    , 0.266482601893    ,
 0.300276415574    , 0.377197009804    , 0.476666388821    , 0.568473728193    ,
 0.633713918588    , 0.673493540852    , 0.701843086816    , 0.73312989111     ,
 0.772473447899    , 0.811686564914    , 0.833973895602    , 0.825053486644    ,
 0.780538336364    , 0.707118677666    , 0.62269785579     , 0.553374940976    ,
 0.524518902716    , 0.552823052981    , 0.641821725864    , 0.774418378885    ,
 0.908107240009    , 0.990287299788    , 0.990885487288    , 0.923018735982    ,
 0.832996127326    , 0.772807687745    , 0.776669564343    , 0.85077622525     ,
 0.977740502058    , 1.13073117284     , 1.28213385936     , 1.3969931464      ,
 1.42814310274     , 1.33895914191     , 1.14083448961     , 0.89794258199     ,
 0.685479035377    , 0.543661082522    , 0.467701625087    , 0.429447108408    ,
 0.401724600094    , 0.367133442539    , 0.316014275504    , 0.246852011777    ,
 0.169326487032    , 0.10009892653     , 0.0518213444253   , 0.0268810920358   ,
 0.0209505884566   , 0.0299381279813   , 0.0521696459581   , 0.0839538143103   ,
 0.114614975871    , 0.129560437123    , 0.121036054925    , 0.0948295679376   ,
 0.0647177075341   , 0.0413549903413   , 0.027362144024    , 0.0208408831004   ,
 0.0204423944498   , 0.0260008655758   , 0.0354071907163   , 0.0430133747203   ,
 0.0429996949728   , 0.0345119769193   , 0.0223653181761   , 0.0126603845269   ,
 0.00883499433513  , 0.0117430147354   , 0.0217296079142   , 0.0396762389236   ,
 0.0673265230343   , 0.108694293529    , 0.170481868876    , 0.25603343868     ,
 0.353992701517    , 0.434188638462    , 0.461464475388    , 0.420314188035    ,
 0.328144665192    , 0.222626455759    , 0.13553977501     , 0.0789831550154   ,
 0.0506758358382   , 0.0433499287091   , 0.0481908636355   , 0.0566205111129   ,
 0.0643749972309   , 0.0738073757897   , 0.0903219412124   , 0.115857200093    ,
 0.146265424489    , 0.175563898421    , 0.202764699245    , 0.234883194421    ,
 0.283261922857    , 0.354263237431    , 0.441272872862    , 0.528443964968    ,
 0.604838064827    , 0.672140954508    , 0.737108948562    , 0.801141470477    ,
 0.858898851855    , 0.901121881405    , 0.916663694276    , 0.898418262993    ,
 0.850349066528    , 0.784340814824    , 0.710707577099    , 0.638347060793    ,
 0.583367312757    , 0.568580238912    , 0.610519631186    , 0.712256006942    ,
 0.873714321805    , 1.10365279237     , 1.41288322949     , 1.80341622293     ,
 2.28519402646     , 2.90228013748     , 3.71149379544     , 4.7147813244      ,
 5.81384872066     , 6.82695042993     , 7.55763871347     , 7.89598406829     ,
 7.89571362401     , 7.7354579022      , 7.5658341506      , 7.39130896639     ,
 4.2443976267      , 3.92050999226     , 3.50367776098     , 3.04626812255     ,
 2.60557765984     , 2.20795079896     , 1.84497835223     , 1.50107444662     ,
 1.18157337652     , 0.909761723166    , 0.702751624545    , 0.559208024487    ,
 0.467697607612    , 0.41540975761     , 0.385419181007    , 0.356401422087    ,
 0.31434868186     , 0.261727048599    , 0.211276781144    , 0.172651123224    ,
 0.145163802714    , 0.12065046715     , 0.0926035752533   , 0.0626852726296   ,
 0.0379276513857   , 0.0228989949817   , 0.016228717386    , 0.0136191527424   ,
 0.0121667617347   , 0.011758662321    , 0.0137809417078   , 0.019310666226    ,
 0.027879697443    , 0.0369559769533   , 0.0429663529988   , 0.0441575669421   ,
 0.0426342089305   , 0.0426462182639   , 0.0471001318127   , 0.056992564609    ,
 0.0737264151568   , 0.0993482955824   , 0.132949291637    , 0.167731465197    ,
 0.192995067393    , 0.200848526784    , 0.194366598463    , 0.190216102895    ,
 0.208947105594    , 0.257891522583    , 0.322879850523    , 0.378840600757    ,
 0.410895333237    , 0.426493340074    , 0.448400244168    , 0.496917047295    ,
 0.575078343359    , 0.664471449409    , 0.734265645253    , 0.758129556013    ,
 0.727096125988    , 0.652648468533    , 0.561770704738    , 0.485381879396    ,
 0.445736850191    , 0.452163337739    , 0.502965463214    , 0.583684334001    ,
 0.665998978463    , 0.719068875541    , 0.727114290103    , 0.695848853368    ,
 0.646530444339    , 0.608609858261    , 0.611422459941    , 0.670488113728    ,
 0.776919930467    , 0.901581427501    , 1.00936401329     , 1.06897082767     ,
 1.05595803641     , 0.960717090022    , 0.801617085095    , 0.623922588155    ,
 0.475714337426    , 0.381031415107    , 0.333904355094    , 0.312591817146    ,
 0.295881552948    , 0.269714147949    , 0.227663452019    , 0.171954802895    ,
 0.113047604714    , 0.0635912189865   , 0.0307762810543   , 0.0143138817309   ,
 0.0104477553566   , 0.0164921257758   , 0.0313470020611   , 0.0520294356072   ,
 0.0708475778029   , 0.078348645087    , 0.0705501268922   , 0.052341076962    ,
 0.0329161244067   , 0.0188119823437   , 0.0116983140918   , 0.0111386750451   ,
 0.0174586054746   , 0.0309596863647   , 0.0483409455678   , 0.0614629615853   ,
 0.0623151960961   , 0.0500900299026   , 0.031930232659    , 0.0164279812241   ,
 0.0077817709859   , 0.00588496154841  , 0.00970150978543  , 0.0197307582206   ,
 0.0389994397883   , 0.0732332773332   , 0.128088245424    , 0.201279633227    ,
 0.275288742785    , 0.322129348868    , 0.321266422642    , 0.274870918121    ,
 0.205207381497    , 0.13760443317     , 0.0860406952405   , 0.0523270519146   ,
 0.033723699558    , 0.0278976217143   , 0.0325161061197   , 0.04406735217     ,
 0.0585482523623   , 0.072971279566    , 0.086162386797    , 0.0979897196762   ,
 0.107893722453    , 0.115109997962    , 0.120676550639    , 0.128569804516    ,
 0.144260027287    , 0.170794166987    , 0.205042890445    , 0.239282627211    ,
 0.268357478145    , 0.294056687534    , 0.321512116375    , 0.353696403181    ,
 0.389897372307    , 0.425459638145    , 0.451704041938    , 0.460393370025    ,
 0.450312621819    , 0.42723935967     , 0.398322226101    , 0.370450588106    ,
 0.353667073887    , 0.361204361396    , 0.403968632701    , 0.488970557142    ,
 0.627030893097    , 0.835951587663    , 1.12518223884     , 1.48175541097     ,
 1.88993714053     , 2.36566506011     , 2.94801360698     , 3.64294843705     ,
 4.37883579699     , 5.01447212989     , 5.39768639583     , 5.45429240613     ,
 5.24942366502     , 4.94736165677     , 4.68448348483     , 4.47594882361     ,
 2.48179774588     , 2.2756896848      , 2.01931130465     , 1.72984829052     ,
 1.4389612035      , 1.17232659617     , 0.939253272795    , 0.738230689828    ,
 0.568955078518    , 0.434522220945    , 0.335501565196    , 0.26847922548     ,
 0.229505660324    , 0.213128885942    , 0.207363058642    , 0.196167056739    ,
 0.171307823108    , 0.139162388894    , 0.113315608366    , 0.101422684567    ,
 0.0988967508501   , 0.0937517962305   , 0.0778579018036   , 0.0538110377866   ,
 0.0307534469778   , 0.0152880799859   , 0.00769353879045  , 0.00475831242331  ,
 0.00367816988432  , 0.00345280154202  , 0.00430900818228  , 0.00671515183587  ,
 0.0105928157396   , 0.0148406242944   , 0.0177144519832   , 0.0182727154528   ,
 0.0174961539898   , 0.0175057945223   , 0.0197872841075   , 0.0248821503714   ,
 0.0338063516222   , 0.0486960847652   , 0.0710891895461   , 0.0991794947191   ,
 0.126532222673    , 0.144702695972    , 0.150396827001    , 0.151331914986    ,
 0.161751163713    , 0.188921508323    , 0.224589487509    , 0.251930885553    ,
 0.262231553728    , 0.264928540509    , 0.281918388548    , 0.332766829634    ,
 0.421780470463    , 0.532378312829    , 0.631672068019    , 0.685004019814    ,
 0.673487607877    , 0.604843113071    , 0.509937291329    , 0.425016307706    ,
 0.373042562715    , 0.359403548051    , 0.378745140129    , 0.419244724372    ,
 0.464338697765    , 0.499330700419    , 0.517382103189    , 0.517194886926    ,
 0.500690769317    , 0.478751632116    , 0.473641181787    , 0.505941584451    ,
 0.57613894543     , 0.660481638932    , 0.724913901602    , 0.743347417174    ,
 0.706862091903    , 0.623235253461    , 0.513125494541    , 0.404001280129    ,
 0.319467842308    , 0.268841125378    , 0.246043833169    , 0.23737588809     ,
 0.228776683517    , 0.208975859334    , 0.172895265213    , 0.125134169928    ,
 0.0774695032814   , 0.0405782546503   , 0.0180928756167   , 0.00759065015571  ,
 0.00515701324228  , 0.00847515796359  , 0.0165974452202   , 0.0275931615627   ,
 0.0370632978147   , 0.040044227266    , 0.0349166376565   , 0.0247852202784   ,
 0.0146436221517   , 0.00782644611941  , 0.00540583349581  , 0.00810891841823  ,
 0.0176529088992   , 0.0350046524668   , 0.0564184116136   , 0.0723743961346   ,
 0.0735538152402   , 0.0591287551413   , 0.0375742083575   , 0.0189389987442   ,
 0.00787452954971  , 0.00365962587143  , 0.00421781266254  , 0.00923160140538  ,
 0.0213433013632   , 0.0458287067104   , 0.0871478390971   , 0.141677894323    ,
 0.192865818335    , 0.218264363797    , 0.206189728556    , 0.165246540177    ,
 0.116067818312    , 0.0751444180597   , 0.047215511769    , 0.0296705402513   ,
 0.0199707078901   , 0.0183667185537   , 0.0261042584694   , 0.0424687688297   ,
 0.0628049899833   , 0.0795617655639   , 0.0869515736108   , 0.0848945998212   ,
 0.0777245180142   , 0.0699665827701   , 0.0642705537192   , 0.0621314558329   ,
 0.0648282491371   , 0.0728602044978   , 0.0845754642145   , 0.0965788185404   ,
 0.106589124035    , 0.115409359297    , 0.125749367625    , 0.140221003937    ,
 0.160239101549    , 0.184369976888    , 0.207118314642    , 0.221723519619    ,
 0.225303902183    , 0.220379512323    , 0.212082618264    , 0.205982581289    ,
 0.20852900933     , 0.226997201329    , 0.267438255941    , 0.335630214619    ,
 0.444112945395    , 0.613814807513    , 0.857541409203    , 1.16186147576     ,
 1.4990673682      , 1.85992568042     , 2.25941517926     , 2.70242005995     ,
 3.14885063402     , 3.51146383798     , 3.69147176503     , 3.64063707655     ,
 3.40668515015     , 3.10824371718     , 2.84969128346     , 2.65559559182     ,
 1.44420708416     , 1.31932728253     , 1.17428563371     , 1.00023462138     ,
 0.808655398077    , 0.62384476472     , 0.467106261891    , 0.346357888969    ,
 0.258352989101    , 0.195549655074    , 0.150969047063    , 0.121088622594    ,
 0.105586864467    , 0.102644946125    , 0.104606510095    , 0.101083095284    ,
 0.0878282285802   , 0.0708787832211   , 0.0605866254492   , 0.0617535981636   ,
 0.0690104508295   , 0.0712930832068   , 0.0616887163852   , 0.0431041984741   ,
 0.024141596754    , 0.0110194189915   , 0.00439908300818  , 0.00184995339271  ,
 0.00104454002477  , 0.000887631583099 , 0.00118273579346  , 0.0020445436319   ,
 0.00346195557564  , 0.00503880951157  , 0.00611219304262  , 0.00631804307474  ,
 0.00603844418127  , 0.00610074025045  , 0.00709186917717  , 0.00931082788647  ,
 0.0135677270364   , 0.0218292003533   , 0.0366462220935   , 0.0591003292361   ,
 0.0862379588842   , 0.111026145076    , 0.127433416649    , 0.136588595954    ,
 0.145563179521    , 0.158690306304    , 0.171985402577    , 0.177810961616    ,
 0.174717354701    , 0.17213245103     , 0.186136257032    , 0.231366786369    ,
 0.313611319476    , 0.42326834682     , 0.532753889312    , 0.604552792956    ,
 0.61046661778     , 0.550540075469    , 0.454789009414    , 0.363108551371    ,
 0.301047634073    , 0.272991423532    , 0.27161939016     , 0.286969084241    ,
 0.309747120193    , 0.333936970905    , 0.356696411581    , 0.373131986752    ,
 0.375605424996    , 0.363596017076    , 0.351118190739    , 0.357811438545    ,
 0.390750338891    , 0.435877519139    , 0.467258120457    , 0.465208195618    ,
 0.42793943941     , 0.369283536196    , 0.30822651495     , 0.259754233196    ,
 0.230058094096    , 0.216064001781    , 0.210048463313    , 0.205154205812    ,
 0.195530985773    , 0.17467707039     , 0.139528291833    , 0.0958738839294   ,
 0.055375463485    , 0.0266437131266   , 0.0107524623576   , 0.0039743577472   ,
 0.0023454850106   , 0.00373458377772  , 0.00731073601639  , 0.0120446950812   ,
 0.0159268974108   , 0.016854816884    , 0.0143162783804   , 0.00982460954539  ,
 0.00557123360746  , 0.00300538570333  , 0.00289516020579  , 0.00648096997808  ,
 0.0159398498199   , 0.0324680281375   , 0.0526573875313   , 0.0676433225323   ,
 0.0687533195135   , 0.0552529233395   , 0.0350793504669   , 0.0175957744671   ,
 0.00705375940724  , 0.00257950358606  , 0.00188450997988  , 0.00412225982378  ,
 0.0108937688488   , 0.0258906600757   , 0.0522638679108   , 0.0873774429519   ,
 0.119495404779    , 0.133204860011    , 0.121601041583    , 0.0924359655031   ,
 0.0607841024324   , 0.0370097668929   , 0.0225410918749   , 0.0143809071865   ,
 0.0107432978054   , 0.0128393592308   , 0.023223688392    , 0.0423176095833   ,
 0.0650201705313   , 0.0814689256136   , 0.0837991068853   , 0.0726341112188   ,
 0.0556676123958   , 0.0406097689311   , 0.0307687659954   , 0.0259382610094   ,
 0.0250225218883   , 0.0272212724872   , 0.0317035560804   , 0.037278562741    ,
 0.0427814546052   , 0.0475285863144   , 0.0516010502828   , 0.056370115274    ,
 0.0643012642667   , 0.0767843716463   , 0.0918201824972   , 0.104769748611    ,
 0.11186651342     , 0.113049056946    , 0.111999778265    , 0.114259821729    ,
 0.125337261695    , 0.14926193516     , 0.187308931082    , 0.239994827887    ,
 0.315160007042    , 0.432719731938    , 0.611731319467    , 0.848808798195    ,
 1.11717369978     , 1.39053911204     , 1.65988950004     , 1.92376917684     ,
 2.16818147213     , 2.35634960048     , 2.43777877269     , 2.379566272       ,
 2.19961258219     , 1.9642506534      , 1.74507098705     , 1.57551483797     ,
 0.848021439895    , 0.77198680866     , 0.694527604234    , 0.594401302587    ,
 0.470663551346    , 0.34295997435     , 0.23526989731     , 0.159276905511    ,
 0.111777298817    , 0.0826637412775   , 0.0633127685788   , 0.0503294275286   ,
 0.0440589364007   , 0.0440977927948   , 0.0464340981395   , 0.0456072779392   ,
 0.0397736250849   , 0.0327826791459   , 0.0306265453914   , 0.035638599329    ,
 0.0436796638983   , 0.0471124751221   , 0.0414385753458   , 0.0290374561908   ,
 0.0161288176341   , 0.00713679876743  , 0.00257999369388  , 0.000833959224358 ,
 0.000311030284302 , 0.000205538566946 , 0.000282760339922 , 0.000532323991924 ,
 0.000946750169823 , 0.00140981612788  , 0.00172425937008  , 0.00178401079678  ,
 0.00171009186504  , 0.00175903013828  , 0.00212999151521  , 0.00302524979431  ,
 0.00509846429148  , 0.00999118662172  , 0.0203337824459   , 0.0384525047358   ,
 0.0638461522747   , 0.0918362047698   , 0.116251070526    , 0.133976831041    ,
 0.145416011942    , 0.15076828687     , 0.148739535979    , 0.139946287497    ,
 0.129822257155    , 0.127102419023    , 0.140515407894    , 0.177723843496    ,
 0.244296688361    , 0.337394128824    , 0.437354348559    , 0.5094462434      ,
 0.522101295159    , 0.469864908652    , 0.379222080893    , 0.289372291187    ,
 0.226194414566    , 0.193544158553    , 0.183258330007    , 0.186552971268    ,
 0.197673452925    , 0.213878450171    , 0.2336014146      , 0.252073988499    ,
 0.260623255767    , 0.254415056991    , 0.240083579314    , 0.231837781141    ,
 0.238507408669    , 0.254803600324    , 0.265356009106    , 0.257744443646    ,
 0.232879265979    , 0.204005362391    , 0.186526368037    , 0.187557639943    ,
 0.201603804135    , 0.215000542776    , 0.216932759067    , 0.20629078627     ,
 0.186465648714    , 0.157676180347    , 0.11951187413     , 0.0776565376054   ,
 0.0419925161335   , 0.0186404063566   , 0.00680332077491  , 0.00216940176775  ,
 0.000985655780108 , 0.00136206030838  , 0.00261086896075  , 0.0042492394757   ,
 0.00553650919666  , 0.00575638751112  , 0.00478718099322  , 0.00320375844871  ,
 0.00178472520664  , 0.0010872838499   , 0.001644728816    , 0.00457630792941  ,
 0.0116799326114   , 0.0239344521422   , 0.0388537750344   , 0.0499059134861   ,
 0.0507067695809   , 0.0407328789684   , 0.025847109815    , 0.0129453752117   ,
 0.00513419252747  , 0.00171101413367  , 0.000867860695566 , 0.00173096266432  ,
 0.00501254200743  , 0.0127760767777   , 0.0269273909849   , 0.0461560985319   ,
 0.0638520735048   , 0.0711139685386   , 0.0639527967688   , 0.0470300106284   ,
 0.0292431618392   , 0.0165090434778   , 0.00939733942652  , 0.00600385302461  ,
 0.00542620440302  , 0.00899605587625  , 0.0192141904137   , 0.0367329988582   ,
 0.0569503458033   , 0.0705665021233   , 0.0701875158646   , 0.0568318962692   ,
 0.0385692539997   , 0.0232693190875   , 0.0139097410145   , 0.00955807705773  ,
 0.00843148051894  , 0.00960452764909  , 0.0130249062353   , 0.0187093522522   ,
 0.0257121051947   , 0.0316861270028   , 0.0342330369224   , 0.0335079984362   ,
 0.0330108638059   , 0.0368310965057   , 0.0458985421733   , 0.0569511026142   ,
 0.0651498235174   , 0.0683251492003   , 0.0693885835642   , 0.0747261304814   ,
 0.0902698380719   , 0.118258419837    , 0.15559738214     , 0.196188386818    ,
 0.240632359074    , 0.305494344938    , 0.415310536014    , 0.579072410471    ,
 0.777937292294    , 0.979281124026    , 1.15905389819     , 1.30991456905     ,
 1.43370080174     , 1.52716010327     , 1.57185504453     , 1.54231667671     ,
 1.43127444774     , 1.26552287103     , 1.09230798124     , 0.949685479408    ,
 0.50987593625     , 0.459747059926    , 0.415313189152    , 0.355856055191    ,
 0.276908331814    , 0.192200328582    , 0.120879477979    , 0.073031829751    ,
 0.0463292136638   , 0.0324245809556   , 0.024216006264    , 0.0187917325789   ,
 0.0161319830931   , 0.016190257247    , 0.0172985833576   , 0.0171768703965   ,
 0.0151771766162   , 0.0131405605316   , 0.0137761017012   , 0.0179463569763   ,
 0.0232581070455   , 0.0255887198862   , 0.0226243491898   , 0.0158376543928   ,
 0.00875060121081  , 0.00382229092368  , 0.00133147083832  , 0.000382545892201 ,
 0.000104124274818 , 4.54885826381e-05 , 5.81049459415e-05 , 0.000115514329103 ,
 0.000211779827308 , 0.000319220108835 , 0.000391717606666 , 0.000405627534305 ,
 0.000392626869257 , 0.000422616904508 , 0.000582276087533 , 0.00106957634176  ,
 0.00248190124209  , 0.00620613623854  , 0.0145344388738   , 0.0298797401041   ,
 0.0529358542985   , 0.0811914432727   , 0.109727997337    , 0.13346141912     ,
 0.148012576983    , 0.149901980317    , 0.139117960803    , 0.121985623824    ,
 0.10889240708     , 0.107725292603    , 0.120761831803    , 0.148830679395    ,
 0.195588491606    , 0.262496960096    , 0.337681385128    , 0.393695672286    ,
 0.402793584072    , 0.358528047329    , 0.282297873374    , 0.207138706483    ,
 0.154836451243    , 0.127887119723    , 0.118475598569    , 0.119157466699    ,
 0.125594500518    , 0.135384652277    , 0.147186055871    , 0.158716370619    ,
 0.165088317453    , 0.161812230585    , 0.150202265085    , 0.137689727467    ,
 0.131337207593    , 0.131269466285    , 0.130991935496    , 0.124637215533    ,
 0.114443802636    , 0.111277176061    , 0.126976433463    , 0.163578026385    ,
 0.207621064566    , 0.237173304215    , 0.238716775273    , 0.216376637283    ,
 0.18254679275     , 0.144277164034    , 0.103325336351    , 0.063879670026    ,
 0.0328290696377   , 0.0137329044942   , 0.00464497396699  , 0.00130528823783  ,
 0.000419617390459 , 0.000413327911779 , 0.000748525344879 , 0.00120097563651  ,
 0.00154411464752  , 0.00158138478274  , 0.00129262545278  , 0.000849802743084 ,
 0.000479234222371 , 0.000378454051807 , 0.000859699535475 , 0.00263394810811  ,
 0.00679951174339  , 0.0139498535534   , 0.0226409876485   , 0.029068650505    ,
 0.0295209254648   , 0.0237029636672   , 0.0150336016041   , 0.0075240594408   ,
 0.00297328231447  , 0.000956237540268 , 0.000383822820255 , 0.00065680945135  ,
 0.00200293140678  , 0.00535611086244  , 0.011666258015    , 0.0204499985078   ,
 0.0286963232222   , 0.0321656584457   , 0.0288412222073   , 0.0208594929612   ,
 0.0124739871871   , 0.00655739082369  , 0.00342060315872  , 0.00219991514349  ,
 0.0026145949451   , 0.00570985625113  , 0.0132938188988   , 0.0258738771717   ,
 0.0401535913339   , 0.0494085810278   , 0.0483375379676   , 0.0378585521597   ,
 0.0240759376478   , 0.0128405916183   , 0.00622911816969  , 0.00335933438662  ,
 0.0028527242579   , 0.00431672245972  , 0.00843459038875  , 0.0159260460366   ,
 0.0257358927389   , 0.034099996078    , 0.0366930411368   , 0.0328242846159   ,
 0.0269707040561   , 0.0253115980763   , 0.0306682922405   , 0.0404452130833   ,
 0.0490824708294   , 0.0533040654818   , 0.0557998597826   , 0.0636341804673   ,
 0.0830509908911   , 0.115050492131    , 0.153243868277    , 0.186122788485    ,
 0.207898665986    , 0.231101010226    , 0.282391381218    , 0.378997142295    ,
 0.510671352981    , 0.647417746998    , 0.762358798925    , 0.846889929173    ,
 0.909255111413    , 0.960276726144    , 0.996145452761    , 0.995284042822    ,
 0.937773771919    , 0.828871406364    , 0.70017890869     , 0.587821574871    ,
 0.316062642799    , 0.279792519225    , 0.248190962649    , 0.207979911115    ,
 0.157038545565    , 0.104161447116    , 0.0608618656735   , 0.0328615173791   ,
 0.0182600224691   , 0.0115728276642   , 0.00820493704274  , 0.00611976380548  ,
 0.00503835862052  , 0.00493392766418  , 0.00525640269502  , 0.0052542020715   ,
 0.00475099191208  , 0.0044352568061   , 0.00527957424521  , 0.00751927941282  ,
 0.0100772672253   , 0.0111865438279   , 0.00989622149546  , 0.0069093974838   ,
 0.00380002894753  , 0.00164749947795  , 0.000564955159868 , 0.000155078855633 ,
 3.60709409772e-05 , 1.03269919813e-05 , 1.01789657374e-05 , 2.04613673788e-05 ,
 3.81364067443e-05 , 5.78129719541e-05 , 7.10413401909e-05 , 7.41613196392e-05 ,
 7.68606217409e-05 , 0.000111696972375 , 0.000277472367866 , 0.000877342374441 ,
 0.00265962376486  , 0.00698788797754  , 0.0156214516424   , 0.0300016181719   ,
 0.0504338020358   , 0.0756915039201   , 0.102995060224    , 0.127765700479    ,
 0.14355562792     , 0.144433798893    , 0.130273810359    , 0.10971215539     ,
 0.0952552197257   , 0.0939945321989   , 0.104275928083    , 0.122253251994    ,
 0.149148185936    , 0.188155554733    , 0.233714469015    , 0.267664468178    ,
 0.270339630359    , 0.237093764227    , 0.183262761419    , 0.132230559568    ,
 0.0988263418394   , 0.0837679254099   , 0.0807182383608   , 0.0841243904484   ,
 0.090207763478    , 0.0957232409296   , 0.0993082524464   , 0.101880201171    ,
 0.103460850364    , 0.101373279288    , 0.0933772620719   , 0.0813050810716   ,
 0.0698464114815   , 0.0619891533664   , 0.0569210059366   , 0.0531119359033   ,
 0.0534008071555   , 0.0664379656362   , 0.101160003532    , 0.156273680301    ,
 0.21379584184     , 0.247585820804    , 0.243554545284    , 0.210011290966    ,
 0.165716255898    , 0.12250188218     , 0.0831166169984   , 0.0493162647188   ,
 0.0244703503728   , 0.00987176412465  , 0.00319399656318  , 0.000832566740396 ,
 0.000201506576998 , 0.0001110520153   , 0.000172260221911 , 0.000270669733879 ,
 0.000343787670586 , 0.000347526088567 , 0.000280045259086 , 0.000182205438735 ,
 0.000108949812925 , 0.00012584077467  , 0.000378956359569 , 0.00120914733289  ,
 0.00313279370386  , 0.00642700594217  , 0.010426401225    , 0.0133793474279   ,
 0.0135803044194   , 0.0108983403254   , 0.00690892863309  , 0.00345596847054  ,
 0.00136358790021  , 0.000431912389645 , 0.000150234316053 , 0.000216043596792 ,
 0.000674795471572 , 0.001867843091    , 0.00417555895858  , 0.00746183516812  ,
 0.0106158440011   , 0.0120010033051   , 0.0107865337985   , 0.00774853950314  ,
 0.00452402628652  , 0.00224978056581  , 0.00108039267786  , 0.000723889466619 ,
 0.00116953313767  , 0.0030508211259   , 0.00738987222506  , 0.0144736822772   ,
 0.0224410112575   , 0.0274987924858   , 0.0266826592568   , 0.0205740759058   ,
 0.012687834624    , 0.00635278668015  , 0.00271285144105  , 0.0012484119826   ,
 0.00129303108762  , 0.00303209986454  , 0.00759236054152  , 0.0160001725238   ,
 0.0271346873658   , 0.0366267925657   , 0.0393289691229   , 0.0341453004556   ,
 0.0258429368235   , 0.0212930327719   , 0.0240074559441   , 0.0319174636137   ,
 0.0397983445419   , 0.0444827864998   , 0.0485259667113   , 0.0586258010988   ,
 0.0804062848992   , 0.113904785107    , 0.151242991857    , 0.178589035428    ,
 0.186822698517    , 0.184803574261    , 0.197185504332    , 0.243143953927    ,
 0.318540763059    , 0.400953513527    , 0.469211075736    , 0.517030392769    ,
 0.552569946428    , 0.587190387804    , 0.620520116397    , 0.63492209529     ,
 0.609431605166    , 0.541563873343    , 0.452876021418    , 0.372418291309    ,
 0.19834275638     , 0.171332525555    , 0.145752236955    , 0.115843147183    ,
 0.0827627585122   , 0.0518969373788   , 0.0283650271781   , 0.0138889294585   ,
 0.00670440021854  , 0.00368958719337  , 0.00239665875875  , 0.00169068019726  ,
 0.00131315270422  , 0.00122611351713  , 0.00128263237298  , 0.00128723883231  ,
 0.00120541319452  , 0.0012430458155   , 0.00168065574813  , 0.00256233372959  ,
 0.00350572409196  , 0.00390639345976  , 0.00345108982889  , 0.00240162428778  ,
 0.0013149903832   , 0.000566793331897 , 0.000192631373238 , 5.18613726036e-05 ,
 1.13029636562e-05 , 2.42493620892e-06 , 1.53387718226e-06 , 2.91849847672e-06 ,
 5.47216551973e-06 , 8.32234682837e-06 , 1.03526501554e-05 , 1.21245588388e-05 ,
 2.26470904718e-05 , 8.77680882078e-05 , 0.000390179205943 , 0.00148114452056  ,
 0.00454562676591  , 0.0112359499737   , 0.0226386738022   , 0.0381212471056   ,
 0.0558120038437   , 0.0746020243286   , 0.0945513667301   , 0.114053738131    ,
 0.127414266872    , 0.127699224032    , 0.113654599895    , 0.0931915871601   ,
 0.0781363616804   , 0.0747128341553   , 0.0801259005234   , 0.0888991003639   ,
 0.100452770668    , 0.117876891993    , 0.13972500849     , 0.15619112746     ,
 0.155789426664    , 0.135888289466    , 0.105872792564    , 0.0797004989346   ,
 0.0655790099293   , 0.0628069200234   , 0.0668452687922   , 0.0741409880812   ,
 0.0814177312868   , 0.0847309624444   , 0.082900844212    , 0.0794799177728   ,
 0.0779724599936   , 0.0766260333018   , 0.0706198714169   , 0.0584256860888   ,
 0.0437571249199   , 0.0315468564146   , 0.0240179178519   , 0.0215378016331   ,
 0.0265713286836   , 0.0455958860353   , 0.0849447562668   , 0.14140589538     ,
 0.196439057341    , 0.224993650751    , 0.215066470975    , 0.176960046533    ,
 0.13110580882     , 0.0906551255454   , 0.0582214562663   , 0.0332469307754   ,
 0.0160607438363   , 0.0063370505973   , 0.00200318966987  , 0.000504072199741 ,
 0.000105512385359 , 3.07393399909e-05 , 3.2359305588e-05  , 4.85385887816e-05 ,
 6.08906813119e-05 , 6.08561992655e-05 , 4.84719111916e-05 , 3.15277397281e-05 ,
 2.15156289923e-05 , 3.82497889808e-05 , 0.000135636824893 , 0.000440258898615 ,
 0.00114190577868  , 0.00234177885164  , 0.0037969951255   , 0.0048696498802   ,
 0.00494005383096  , 0.00396234236646  , 0.0025106539707   , 0.0012552678916   ,
 0.00049484317301  , 0.000155545051263 , 4.9382724659e-05  , 5.97335226238e-05 ,
 0.000187684602687 , 0.000533090406817 , 0.00121651955677  , 0.00220841008587  ,
 0.00317871870561  , 0.00362215214169  , 0.00326833008427  , 0.0023430642784   ,
 0.00134944722794  , 0.000646124310097 , 0.00029235628969  , 0.000216152108462 ,
 0.000460068183414 , 0.00132264503182  , 0.00325917391998  , 0.00639471392873  ,
 0.00990111242449  , 0.0120986431551   , 0.0116859564115   , 0.00894080503104  ,
 0.00543532861865  , 0.0026447852572   , 0.00107062764245  , 0.00050760975783  ,
 0.000796172031913 , 0.00238933444526  , 0.00642300606384  , 0.0138668233643   ,
 0.0237448125916   , 0.0321620511515   , 0.0344934291023   , 0.0296568846575   ,
 0.0217086083324   , 0.016565764231    , 0.0173513965666   , 0.0226394589217   ,
 0.0285302385007   , 0.0327724256519   , 0.0375169073854   , 0.0479821683076   ,
 0.0683367133081   , 0.0980621708032   , 0.129899042442    , 0.151341468948    ,
 0.153495576873    , 0.142175966117    , 0.136489642957    , 0.152346621189    ,
 0.188990165617    , 0.232932310309    , 0.271636124281    , 0.301704632181    ,
 0.327669919114    , 0.35541260314     , 0.383615981902    , 0.399773029908    ,
 0.388503333008    , 0.346833652801    , 0.289344002359    , 0.236403773556    ,
 0.122118097795    , 0.101766817416    , 0.0817691188671   , 0.0603736383438   ,
 0.0398477651865   , 0.0231637572784   , 0.0117645020844   , 0.00527556876418  ,
 0.00223286512151  , 0.00103913357035  , 0.000593313922621 , 0.000387945872932 ,
 0.000281089615148 , 0.000245933610328 , 0.000249319600878 , 0.000251030532345 ,
 0.000247163181358 , 0.000287625402989 , 0.000437985947922 , 0.000702525168187 ,
 0.000973685347177 , 0.0010862911261   , 0.000957594923903 , 0.000664080588053 ,
 0.000362035768988 , 0.000155223473298 , 5.2396409626e-05  , 1.39554772015e-05 ,
 2.95806868267e-06 , 5.45261487235e-07 , 2.05698449052e-07 , 3.33148756538e-07 ,
 6.22818132317e-07 , 9.66482831192e-07 , 1.44151462394e-06 , 4.00788920795e-06 ,
 2.30463111881e-05 , 0.000135589734429 , 0.000652064937564 , 0.00248583930695  ,
 0.00748636760185  , 0.0178491208061   , 0.0339319006308   , 0.052276882194    ,
 0.0675060781341   , 0.0775739794184   , 0.0855582593773   , 0.0944058468594   ,
 0.101347979111    , 0.0999485519114   , 0.0876752965942   , 0.0699455926666   ,
 0.0558982073259   , 0.0504936982891   , 0.0515208756632   , 0.0542411793433   ,
 0.0573627703212   , 0.0630604704728   , 0.0718907624328   , 0.0797205865471   ,
 0.0807102100559   , 0.0730600790385   , 0.0613765127706   , 0.0530624111476   ,
 0.0522426704988   , 0.0576604287557   , 0.06614853781     , 0.075618554719    ,
 0.0834782769959   , 0.0858975992951   , 0.0822118147866   , 0.0773230231857   ,
 0.0758096178744   , 0.0753592005715   , 0.0693864866207   , 0.0552433254275   ,
 0.0372108526025   , 0.0218055481286   , 0.0125868791127   , 0.0102111413105   ,
 0.0160665757033   , 0.0342859016256   , 0.068515856227    , 0.114553600963    ,
 0.156519673115    , 0.174828871015    , 0.161605576661    , 0.126904565868    ,
 0.0882879829469   , 0.0568470597403   , 0.0342993792632   , 0.0187570454918   ,
 0.00882259849256  , 0.00342163515795  , 0.00106687010251  , 0.000264177087828 ,
 5.23368223331e-05 , 1.00720282063e-05 , 5.29565063101e-06 , 6.94047107957e-06 ,
 8.55711589721e-06 , 8.46566690751e-06 , 6.68366650648e-06 , 4.42040172019e-06 ,
 3.81514747144e-06 , 1.0059565636e-05  , 3.8824541581e-05  , 0.000126936097768 ,
 0.000329285942836 , 0.000674969331327 , 0.00109380454666  , 0.00140201356587  ,
 0.00142148974273  , 0.00113954581944  , 0.000721689188525 , 0.000360659670968 ,
 0.000142086158352 , 4.44625561806e-05 , 1.32672373243e-05 , 1.36035683452e-05 ,
 4.24443419876e-05 , 0.000122924289597 , 0.000285048880282 , 0.00052385396369  ,
 0.000760963244427 , 0.000872749579404 , 0.00079045247968  , 0.000566654261178 ,
 0.000323922032758 , 0.000151508484734 , 6.66819327629e-05 , 5.77799741314e-05 ,
 0.000151731175962 , 0.000458039663525 , 0.00113655266349  , 0.00222980276349  ,
 0.00344708688881  , 0.00420262119313  , 0.00404667208978  , 0.0030821031485   ,
 0.00186019172637  , 0.000894260774454 , 0.000360666579792 , 0.00021243302221  ,
 0.000492049988019 , 0.00161263512903  , 0.00440378254039  , 0.00955190953593  ,
 0.0163857035508   , 0.0222061926361   , 0.0237967749088   , 0.0203661997956   ,
 0.0146361876753   , 0.0105935974335   , 0.0103727362909   , 0.0131821229649   ,
 0.0167328600703   , 0.0198259218207   , 0.0239634044573   , 0.0324352343279   ,
 0.0477433186739   , 0.0692919677449   , 0.0919976775448   , 0.10728998579     ,
 0.109009888343    , 0.100482468256    , 0.0932421999519   , 0.0968064836176   ,
 0.111531905735    , 0.131957652792    , 0.153820500787    , 0.176132984597    ,
 0.199189134888    , 0.222690724588    , 0.243756634638    , 0.255122287851    ,
 0.24822640638     , 0.221361535098    , 0.183691586231    , 0.148446775724    ,
 0.0738616770834   , 0.0571555474335   , 0.0425023398407   , 0.0288471841101   ,
 0.0173730672881   , 0.00920409455884  , 0.00428019108963  , 0.00175434991629  ,
 0.000658822371467 , 0.000257533956313 , 0.000124011683324 , 7.30480018116e-05 ,
 4.88851594784e-05 , 3.95879965155e-05 , 3.84607335797e-05 , 3.89123674166e-05 ,
 4.10645539471e-05 , 5.47921870504e-05 , 9.25853230242e-05 , 0.000154080284495 ,
 0.000215273279434 , 0.000240136513508 , 0.000211162616628 , 0.000145933056597 ,
 7.92246922007e-05 , 3.37983268112e-05 , 1.13400358241e-05 , 2.99650519629e-06 ,
 6.25981154775e-07 , 1.07404547592e-07 , 2.57576587102e-08 , 3.05804127556e-08 ,
 5.774927031e-08   , 1.17396640344e-07 , 5.12159177467e-07 , 4.10874434767e-06 ,
 3.10449645902e-05 , 0.000188896906368 , 0.000908176221267 , 0.00343976055588  ,
 0.0102553308814   , 0.0240795299763   , 0.0446565319397   , 0.0659600815483   ,
 0.0792241414656   , 0.0810634041881   , 0.0768036739182   , 0.0736278782721   ,
 0.0723727214902   , 0.0682740076525   , 0.0581908925195   , 0.0447834132      ,
 0.033768653936    , 0.0284477141558   , 0.0275439159136   , 0.0279164359778   ,
 0.0283514084715   , 0.0301824804476   , 0.034739220542    , 0.0409521028924   ,
 0.0456919918705   , 0.0466165656003   , 0.0448899512432   , 0.0445440524739   ,
 0.04851774283     , 0.0561804549359   , 0.0653793793715   , 0.0747271821746   ,
 0.0821856527798   , 0.0845561640824   , 0.0816907907262   , 0.0784487946483   ,
 0.0786152917978   , 0.0788072790671   , 0.0719610559665   , 0.0559175087214   ,
 0.0359103893469   , 0.0191734861551   , 0.00954860442568  , 0.00761099942624  ,
 0.0140338650037   , 0.031016907091    , 0.0592935220803   , 0.0931051377655   ,
 0.119480621735    , 0.125745469885    , 0.109553323313    , 0.0805735621372   ,
 0.0518186583603   , 0.0305214332704   , 0.0169578079551   , 0.00873850810604  ,
 0.00396726837175  , 0.00150872484449  , 0.0004649592446   , 0.000114076550217 ,
 2.21636402048e-05 , 3.5996194612e-06  , 8.88841113709e-07 , 8.04133253896e-07 ,
 9.52809898832e-07 , 9.33155888573e-07 , 7.33007734344e-07 , 5.08347728185e-07 ,
 6.18759679715e-07 , 2.19540835535e-06 , 8.8299272642e-06  , 2.89560423147e-05 ,
 7.50999834131e-05 , 0.000153864114043 , 0.000249206427156 , 0.000319251174856 ,
 0.000323509798364 , 0.000259208158881 , 0.000164080025379 , 8.19612283202e-05 ,
 3.22725994196e-05 , 1.00692040265e-05 , 2.87357143635e-06 , 2.51799848001e-06 ,
 7.71617191783e-06 , 2.26709281172e-05 , 5.32184211128e-05 , 9.87157007037e-05 ,
 0.000144391152143 , 0.000166422943596 , 0.00015119455569  , 0.000108458580248 ,
 6.17550043756e-05 , 2.85163569412e-05 , 1.26263871023e-05 , 1.34158772114e-05 ,
 4.07413951959e-05 , 0.000125940362989 , 0.000313251408084 , 0.000614008530225 ,
 0.000947611150948 , 0.00115287549527  , 0.00110723967396  , 0.000840583081256 ,
 0.000505154238023 , 0.000241841055374 , 0.000101101874    , 8.42390801639e-05 ,
 0.000255833007975 , 0.000865631845874 , 0.00237272394878  , 0.00515121725384  ,
 0.00883949900923  , 0.0119796277395   , 0.0128301360803   , 0.0109480371359   ,
 0.00776800903486  , 0.00539655584687  , 0.00497524794782  , 0.00617107813962  ,
 0.00795959861119  , 0.00991288157414  , 0.0129104889493   , 0.0185878209135   ,
 0.0280567907931   , 0.040900558971    , 0.0547065215598   , 0.0657234222992   ,
 0.0715437081988   , 0.0735780575486   , 0.0753414302739   , 0.0783338719784   ,
 0.0817791154382   , 0.0863351325478   , 0.095214371087    , 0.110503757908    ,
 0.130142852608    , 0.149615836422    , 0.164964532117    , 0.172618553867    ,
 0.16839646767     , 0.150428456562    , 0.123240793631    , 0.0957308401891   ,
 0.0465427003911   , 0.0311869036686   , 0.0204048800079   , 0.0124540230008   ,
 0.00679408096426  , 0.0032544282034   , 0.00136790083346  , 0.000507391002349 ,
 0.000169859295727 , 5.61501441884e-05 , 2.20736642e-05    , 1.12613889039e-05 ,
 6.86387782809e-06 , 5.09852768739e-06 , 4.70300416463e-06 , 4.80359604319e-06 ,
 5.55910244981e-06 , 8.56616112095e-06 , 1.57676537743e-05 , 2.69310697822e-05 ,
 3.78084654087e-05 , 4.21388606575e-05 , 3.69610330884e-05 , 2.54590642751e-05 ,
 1.37663928025e-05 , 5.84522989167e-06 , 1.95019118025e-06 , 5.11795072417e-07 ,
 1.05867738759e-07 , 1.75470069219e-08 , 3.08224672492e-09 , 2.39045644706e-09 ,
 6.34941158998e-09 , 4.37189053068e-08 , 4.72349083318e-07 , 4.53383266823e-06 ,
 3.48173169757e-05 , 0.000211343720559 , 0.00101164577748  , 0.00381351541133  ,
 0.0113095687198   , 0.026378351066    , 0.0484448915094   , 0.0703888321456   ,
 0.0819850959377   , 0.0790665142319   , 0.067551215143    , 0.0564136732598   ,
 0.0488693509541   , 0.0422307098364   , 0.0338558422501   , 0.0246466669005   ,
 0.0175029411574   , 0.0141428272096   , 0.0138213907014   , 0.0145746346408   ,
 0.0153224221033   , 0.0168743662587   , 0.0210096048117   , 0.0282563389136   ,
 0.0363630978611   , 0.0416883941938   , 0.0429161036102   , 0.0426920601194   ,
 0.0446111526099   , 0.0496748838422   , 0.0568142513309   , 0.0648279122965   ,
 0.0717554597556   , 0.0748023408923   , 0.0738368681545   , 0.0727189111718   ,
 0.073982016621    , 0.0740636493981   , 0.0669152834727   , 0.0513656674694   ,
 0.0326463826416   , 0.0174075472258   , 0.00939868032775  , 0.0100284790814   ,
 0.0209715739166   , 0.0438256222905   , 0.0757463748438   , 0.10616178157     ,
 0.121017459918    , 0.112956503851    , 0.0871532601105   , 0.056452408568    ,
 0.0315608892411   , 0.0159258476189   , 0.00761288952501  , 0.0034933197976   ,
 0.00147739098515  , 0.000541305851047 , 0.000163743936281 , 3.97730958912e-05 ,
 7.65555605788e-06 , 1.17789971239e-06 , 1.80349378731e-07 , 8.03676519534e-08 ,
 8.42439525046e-08 , 8.13439166646e-08 , 6.39487814224e-08 , 4.90869490725e-08 ,
 9.04729491268e-08 , 3.87796216014e-07 , 1.59036343711e-06 , 5.22127711606e-06 ,
 1.35373971825e-05 , 2.77221035634e-05 , 4.48773027514e-05 , 5.74610747729e-05 ,
 5.81975537791e-05 , 4.66069869269e-05 , 2.94888405709e-05 , 1.47240377739e-05 ,
 5.79500608226e-06 , 1.80426919531e-06 , 4.97954508326e-07 , 3.7544537083e-07  ,
 1.11804982175e-06 , 3.31873898234e-06 , 7.86231104235e-06 , 1.46849053134e-05 ,
 2.15893196183e-05 , 2.49747485785e-05 , 2.27433227581e-05 , 1.63280211025e-05 ,
 9.27896262956e-06 , 4.2624251776e-06  , 1.96403236468e-06 , 2.62344807012e-06 ,
 8.77438679868e-06 , 2.74350765447e-05 , 6.82631589968e-05 , 0.000133630012768 ,
 0.000205868014249 , 0.000249937047119 , 0.000239463639221 , 0.000181287646894 ,
 0.000108612860675 , 5.20550463137e-05 , 2.36163677318e-05 , 2.96432235329e-05 ,
 0.00010620293528  , 0.000364153450844 , 0.000999246648807 , 0.00216979821872  ,
 0.00372357021994  , 0.00504600207286  , 0.00540186888713  , 0.00459971122576  ,
 0.00323370299832  , 0.0021800703092   , 0.00192994478804  , 0.00241701987893  ,
 0.0033820175212   , 0.00488142009021  , 0.00743028497863  , 0.01155551306     ,
 0.0172739121139   , 0.0242183466631   , 0.0323172797594   , 0.0423805834014   ,
 0.0559015271478   , 0.0730744689105   , 0.0898391723922   , 0.0986318807847   ,
 0.0951534249687   , 0.0842244522137   , 0.0765148186839   , 0.0791355504826   ,
 0.0906324199913   , 0.104763767624    , 0.116834504136    , 0.124632637878    ,
 0.12504584374     , 0.114289323784    , 0.093013658238    , 0.0679828794076   ,
 0.0320941964973   , 0.0178671513407   , 0.00956948218601  , 0.00495421572561  ,
 0.00238256075582  , 0.0010230273089   , 0.000386041424201 , 0.000128344439    ,
 3.8196913702e-05  , 1.07864325062e-05 , 3.40503841904e-06 , 1.43344702969e-06 ,
 7.76760912377e-07 , 5.24688716791e-07 , 4.56122753581e-07 , 4.74423665935e-07 ,
 6.16895719724e-07 , 1.09370659415e-06 , 2.15124178779e-06 , 3.74010537128e-06 ,
 5.26492807874e-06 , 5.86077395431e-06 , 5.12815722459e-06 , 3.52145894221e-06 ,
 1.89712703173e-06 , 8.01984748739e-07 , 2.66173035834e-07 , 6.94154253536e-08 ,
 1.42444059167e-08 , 2.31707539169e-09 , 3.44613497612e-10 , 2.55050103768e-10 ,
 2.43266824302e-09 , 3.46134231931e-08 , 4.20173287291e-07 , 4.0651842735e-06  ,
 3.11130673998e-05 , 0.000188065736971 , 0.000896691396877 , 0.00336834724208  ,
 0.00995888595396  , 0.0231687990826   , 0.042468252744    , 0.061632864139    ,
 0.0717310835723   , 0.0689360834699   , 0.0578826505839   , 0.0459147383694   ,
 0.0362248711468   , 0.0278888979857   , 0.0199258985627   , 0.0131464235619   ,
 0.00905076875489  , 0.00832857113773  , 0.0102634223722   , 0.0130607500146   ,
 0.0151183580896   , 0.0166824130532   , 0.0200343552527   , 0.0269885547801   ,
 0.0358583075736   , 0.0420226023463   , 0.0425157181328   , 0.039247824795    ,
 0.0366902999545   , 0.0375748575471   , 0.0420272180816   , 0.048950953334    ,
 0.0560741227654   , 0.0603654342184   , 0.0609937878883   , 0.0605665589195   ,
 0.0611812322476   , 0.0606384734215   , 0.0547943742201   , 0.0427890467473   ,
 0.0283112967565   , 0.016521183788    , 0.0116174407472   , 0.0177122085785   ,
 0.0400479238713   , 0.0813858839816   , 0.133823262425    , 0.176140542039    ,
 0.186031484906    , 0.158451387391    , 0.109595018824    , 0.0621771443469   ,
 0.02941190623     , 0.0119422683651   , 0.00436937171943  , 0.00152726471386  ,
 0.000523050222827 , 0.000168769259292 , 4.78381752551e-05 , 1.12641152455e-05 ,
 2.13431362413e-06 , 3.21570106861e-07 , 4.07500676044e-08 , 8.18072763742e-09 ,
 6.00704020307e-09 , 5.60331831947e-09 , 4.45216425502e-09 , 4.11566429144e-09 ,
 1.14776914579e-08 , 5.46981479975e-08 , 2.26347218853e-07 , 7.43366236804e-07 ,
 1.92666610248e-06 , 3.9437200877e-06  , 6.38121367809e-06 , 8.16662003353e-06 ,
 8.26736934951e-06 , 6.61783219178e-06 , 4.18540799704e-06 , 2.08899942586e-06 ,
 8.21847470771e-07 , 2.55477930892e-07 , 6.87031084601e-08 , 4.48269673326e-08 ,
 1.28309444922e-07 , 3.83457330336e-07 , 9.14640455672e-07 , 1.71703396163e-06 ,
 2.53375682112e-06 , 2.93893190241e-06 , 2.68110573309e-06 , 1.92630467063e-06 ,
 1.09385418181e-06 , 5.02875932008e-07 , 2.4975439339e-07  , 4.22250387007e-07 ,
 1.50507361522e-06 , 4.7317215149e-06  , 1.17666530075e-05 , 2.30001195805e-05 ,
 3.53687770592e-05 , 4.28492890864e-05 , 4.09559924206e-05 , 3.09247319795e-05 ,
 1.84832493627e-05 , 8.92079347341e-06 , 4.67460902997e-06 , 8.82206214889e-06 ,
 3.47131413167e-05 , 0.000119760647211 , 0.000328758245377 , 0.000713910011737 ,
 0.00122514029994  , 0.00166019349197  , 0.0017770115678   , 0.00151249639605  ,
 0.00106364069921  , 0.000728628964528 , 0.000708450139213 , 0.00109996077982  ,
 0.00208888667236  , 0.0041153559816   , 0.00764853383519  , 0.0125291509923   ,
 0.0177156951766   , 0.0224525478962   , 0.028346533734    , 0.0401541757643   ,
 0.0631678758838   , 0.0971727743763   , 0.131504557876    , 0.149107514627    ,
 0.14015172784     , 0.111879527014    , 0.0825956965889   , 0.0663463719216   ,
 0.0647180667836   , 0.0714440249635   , 0.080958119259    , 0.0904534622308   ,
 0.0959328809355   , 0.0915464356127   , 0.0753211989317   , 0.0527337933825   ,
 0.0229925883963   , 0.0111328421428   , 0.00482137848321  , 0.00197693697098  ,
 0.000782186156553 , 0.000289936972644 , 9.68614554966e-05 , 2.86531200476e-05 ,
 7.54464275343e-06 , 1.8335477296e-06  , 4.64988249601e-07 , 1.53781225517e-07 ,
 7.11475034219e-08 , 4.31562391141e-08 , 3.51546380416e-08 , 3.77443067863e-08 ,
 5.63353858689e-08 , 1.1329827145e-07  , 2.3398622057e-07  , 4.11608003689e-07 ,
 5.80188974174e-07 , 6.44972745716e-07 , 5.63083899513e-07 , 3.85587523017e-07 ,
 2.07034183342e-07 , 8.71701984168e-08 , 2.87922584318e-08 , 7.46559283741e-09 ,
 1.52121878382e-09 , 2.44567717633e-10 , 3.61184764895e-11 , 9.01040051562e-11 ,
 1.61108545393e-09 , 2.46868347158e-08 , 3.00670200796e-07 , 2.89799701419e-06 ,
 2.20860663044e-05 , 0.000132980441354 , 0.000631932662749 , 0.00236787356583  ,
 0.00699281425055  , 0.016289267541    , 0.030038673676    , 0.044272184637    ,
 0.053254432224    , 0.0543614732821   , 0.0497519791307   , 0.0426767427988   ,
 0.0342820859039   , 0.0248295570212   , 0.0157590485417   , 0.00923053225547  ,
 0.00671007908939  , 0.00850086813006  , 0.0135894911485   , 0.0194080935374   ,
 0.0229484939485   , 0.0234975476073   , 0.0238508489862   , 0.0273543084662   ,
 0.033541330748    , 0.0379513355956   , 0.036919829632    , 0.031551322108    ,
 0.0262389062555   , 0.0245569182162   , 0.0276181835637   , 0.0346405335086   ,
 0.0430114194535   , 0.048940219922    , 0.0504028309589   , 0.049092701148    ,
 0.0478959756746   , 0.0470601278338   , 0.0441939503543   , 0.0374772568667   ,
 0.0279100718157   , 0.019172949731    , 0.017084070592    , 0.030303917631    ,
 0.069715477198    , 0.14050055941     , 0.228146539789    , 0.295491128581    ,
 0.305629642211    , 0.253303075815    , 0.168998463535    , 0.0913245317416   ,
 0.0403066207261   , 0.0147024609948   , 0.0045134668143   , 0.00120101975887  ,
 0.00028949610304  , 6.61307791838e-05 , 1.44682656805e-05 , 2.91164803047e-06 ,
 5.0732829843e-07  , 7.30379748513e-08 , 8.58511151858e-09 , 1.02477310842e-09 ,
 3.67681187887e-10 , 3.0597081147e-10  , 2.49544491032e-10 , 3.0889839725e-10  ,
 1.21486543705e-09 , 6.11544030675e-09 , 2.54100039184e-08 , 8.34508949873e-08 ,
 2.16215157873e-07 , 4.42398812232e-07 , 7.15532289927e-07 , 9.15339453416e-07 ,
 9.26238079295e-07 , 7.4112866236e-07  , 4.68543587732e-07 , 2.33775656887e-07 ,
 9.19391655606e-08 , 2.85451861882e-08 , 7.52049799295e-09 , 4.26940410399e-09 ,
 1.16099170341e-08 , 3.4831352438e-08  , 8.34990074245e-08 , 1.57337795636e-07 ,
 2.3280970357e-07  , 2.70566342048e-07 , 2.47155699439e-07 , 1.77691984357e-07 ,
 1.0090219225e-07  , 4.66879122003e-08 , 2.59626769078e-08 , 5.51171748901e-08 ,
 2.04915865776e-07 , 6.45853631592e-07 , 1.60453804636e-06 , 3.13156745064e-06 ,
 4.80678264785e-06 , 5.81116738269e-06 , 5.54132533853e-06 , 4.1735138579e-06  ,
 2.49010823099e-06 , 1.22163399314e-06 , 7.9971916422e-07  , 2.14891380264e-06 ,
 8.89823882319e-06 , 3.07917974761e-05 , 8.45423453146e-05 , 0.000183591463922 ,
 0.000315085823857 , 0.00042718040246  , 0.000458627534026 , 0.000397713745121 ,
 0.000310509149626 , 0.000314817431454 , 0.000556061125284 , 0.00126523410364  ,
 0.0029204832925   , 0.00632363270642  , 0.0121294259243   , 0.0197744446795   ,
 0.0271457283363   , 0.0326608455226   , 0.0388066519527   , 0.0532945770331   ,
 0.0846470782167   , 0.132991469238    , 0.182963071732    , 0.209346458378    ,
 0.196196488352    , 0.151489207073    , 0.100174306586    , 0.0635608727518   ,
 0.0472236546817   , 0.0454811399553   , 0.0515665991445   , 0.0611640396557   ,
 0.0692642152983   , 0.0693169750818   , 0.0582812569646   , 0.0402986819907   ,
 0.0157760138963   , 0.00717886488217  , 0.00272062645475  , 0.000899061631247 ,
 0.000274677417153 , 8.05529439532e-05 , 2.24565581911e-05 , 5.75209832997e-06 ,
 1.32597376872e-06 , 2.78098942558e-07 , 5.73455366185e-08 , 1.43768350853e-08 ,
 5.3451407198e-09  , 2.84386902611e-09 , 2.1599697625e-09  , 2.43855216243e-09 ,
 4.23289701127e-09 , 9.45346461187e-09 , 2.02036175985e-08 , 3.58083894164e-08 ,
 5.04980966867e-08 , 5.60606132103e-08 , 4.88445884376e-08 , 3.3365209119e-08  ,
 1.78616755114e-08 , 7.49362261309e-09 , 2.46445160584e-09 , 6.35687980185e-10 ,
 1.287162609e-10   , 2.05609962528e-11 , 4.55577880067e-12 , 4.77322873489e-11 ,
 9.1857594284e-10  , 1.40865568714e-08 , 1.70912005147e-07 , 1.64049504307e-06 ,
 1.24535455786e-05 , 7.47280441477e-05 , 0.000354222160802 , 0.00132606970367  ,
 0.0039245503782   , 0.00921793170336  , 0.0173536778395   , 0.0267414290548   ,
 0.0350052749586   , 0.040859085434    , 0.0439923646283   , 0.0433249359704   ,
 0.0374561409253   , 0.027310071745    , 0.0166017058719   , 0.00923884722407  ,
 0.00730356092956  , 0.0111233341979   , 0.0193267603809   , 0.0282114791736   ,
 0.0330040428937   , 0.0317900995297   , 0.0277132966236   , 0.025680572058    ,
 0.0269978132254   , 0.0284338216643   , 0.026496107454    , 0.0213670119501   ,
 0.0163216888551   , 0.0146672825633   , 0.0180629434333   , 0.026237153921    ,
 0.0364705175488   , 0.0441626486003   , 0.046153051084    , 0.0437800305624   ,
 0.0413584581866   , 0.0414941542811   , 0.0426196981986   , 0.0409831899007   ,
 0.0347233216144   , 0.0267191639613   , 0.025263160218    , 0.0439362650094   ,
 0.0991104763521   , 0.198248409174    , 0.320589908252    , 0.413663918145    ,
 0.42601872809     , 0.351225916241    , 0.232819132055    , 0.124825853815    ,
 0.0545547008317   , 0.0196229563388   , 0.0058712616073   , 0.00147692326574  ,
 0.000315561660515 , 5.79136684434e-05 , 9.26423681734e-06 , 1.31418685394e-06 ,
 1.67191300081e-07 , 1.89585314226e-08 , 1.87472711249e-09 , 1.65784094921e-10 ,
 2.38274324979e-11 , 1.35074299974e-11 , 1.14710076437e-11 , 2.08743476294e-11 ,
 1.04345592644e-10 , 5.39629339315e-10 , 2.24622969163e-09 , 7.37600780103e-09 ,
 1.91048043715e-08 , 3.90769005182e-08 , 6.31795402991e-08 , 8.07916920091e-08 ,
 8.1723263531e-08  , 6.53674172634e-08 , 4.13116527148e-08 , 2.06057961974e-08 ,
 8.10140375612e-09 , 2.51290341294e-09 , 6.51270197284e-10 , 3.2360468079e-10  ,
 8.25665008712e-10 , 2.48041253988e-09 , 5.96800287177e-09 , 1.12765741142e-08 ,
 1.67190534073e-08 , 1.94583126963e-08 , 1.77920687146e-08 , 1.27986677481e-08 ,
 7.27202999754e-09 , 3.40880552538e-09 , 2.21207171019e-09 , 5.78058922865e-09 ,
 2.21008029806e-08 , 6.97298019429e-08 , 1.73043531728e-07 , 3.37218215665e-07 ,
 5.16686977673e-07 , 6.23370643808e-07 , 5.9306443782e-07  , 4.45599276541e-07 ,
 2.65673300078e-07 , 1.34617153603e-07 , 1.19330324719e-07 , 4.19983578615e-07 ,
 1.78708713679e-06 , 6.19358657373e-06 , 1.70072269346e-05 , 3.69414043537e-05 ,
 6.3491065133e-05  , 8.68421534488e-05 , 9.82392763426e-05 , 0.000110782445439 ,
 0.000187221287406 , 0.000466784919157 , 0.00117922583408  , 0.00266660275157  ,
 0.0055070128211   , 0.010659273889    , 0.0190130049685   , 0.0300083376503   ,
 0.0409518590325   , 0.0494397511257   , 0.0578261775461   , 0.0748101733964   ,
 0.11042821444     , 0.165562903658    , 0.223342415984    , 0.254396724606    ,
 0.238415613631    , 0.182606637628    , 0.115623938968    , 0.063874363395    ,
 0.0361446140222   , 0.0273163603989   , 0.0294969851188   , 0.037047018298    ,
 0.0447532818014   , 0.0468475077014   , 0.040414670822    , 0.0281518565674   ,
 0.01090164523     , 0.00494344564423  , 0.00180059183497  , 0.000534977813224 ,
 0.000133538299706 , 2.93642423453e-05 , 6.00663789813e-06 , 1.17956792389e-06 ,
 2.20903360988e-07 , 3.87717252577e-08 , 6.5274721154e-09  , 1.22414109287e-09 ,
 3.38909648947e-10 , 1.51127083918e-10 , 1.06257844511e-10 , 1.28916452731e-10 ,
 2.60475278093e-10 , 6.30872306026e-10 , 1.37983908372e-09 , 2.45695892476e-09 ,
 3.46476078144e-09 , 3.84153831217e-09 , 3.34118946798e-09 , 2.27744931972e-09 ,
 1.21606015995e-09 , 5.08585870415e-10 , 1.66624412964e-10 , 4.27812522483e-11 ,
 8.61461665009e-12 , 1.3902328744e-12  , 1.05262184119e-12 , 2.1618518225e-11  ,
 4.17612310602e-10 , 6.38144243792e-09 , 7.71249694576e-08 , 7.37479672371e-07 ,
 5.57946997622e-06 , 3.33944707974e-05 , 0.000158156510935 , 0.000593566150542 ,
 0.00177337382312  , 0.0042645037323   , 0.00844336770444  , 0.0143004920254   ,
 0.0216951812805   , 0.0302674671765   , 0.0382215897803   , 0.0418479553686   ,
 0.0381626083836   , 0.0283170854263   , 0.0171597576351   , 0.00953699606705  ,
 0.00797000180685  , 0.0129279920899   , 0.0228926290873   , 0.0334822518847   ,
 0.0388148153532   , 0.0361149204265   , 0.0285150017176   , 0.0217864082267   ,
 0.0186890582875   , 0.0175198628328   , 0.015471078927    , 0.0119925779131   ,
 0.00891366225512  , 0.00866830377141  , 0.0130177252981   , 0.0221789331543   ,
 0.0336663569266   , 0.0426528123115   , 0.0455575772457   , 0.0437748644185   ,
 0.0425410763073   , 0.0454890258925   , 0.0507507832733   , 0.0526223233453   ,
 0.0472609993622   , 0.0375299136742   , 0.0339027623502   , 0.0529323091491   ,
 0.11333785391     , 0.223127716982    , 0.358836548338    , 0.462038202295    ,
 0.475692343061    , 0.392801109914    , 0.261604550104    , 0.141717333142    ,
 0.0631898956371   , 0.0235322777142   , 0.00742632448417  , 0.00200477455474  ,
 0.000462991605377 , 9.06522564674e-05 , 1.48491380263e-05 , 2.01122350161e-06 ,
 2.23942301844e-07 , 2.05520211362e-08 , 1.57360292651e-09 , 1.02837822198e-10 ,
 6.23678350105e-12 , 7.22644192988e-13 , 4.55289434414e-13 , 1.2388288366e-12  ,
 7.15315597723e-12 , 3.74755724611e-11 , 1.56110374839e-10 , 5.12534431681e-10 ,
 1.32717415828e-09 , 2.71379322017e-09 , 4.38628746176e-09 , 5.60722528467e-09 ,
 5.67007302763e-09 , 4.53389086696e-09 , 2.86455898255e-09 , 1.42843656634e-09 ,
 5.61463222263e-10 , 1.74022784104e-10 , 4.45101651359e-11 , 1.94936346519e-11 ,
 4.60533403944e-11 , 1.38210669069e-10 , 3.33428804734e-10 , 6.31301786867e-10 ,
 9.37369040677e-10 , 1.09209723331e-09 , 9.99306409775e-10 , 7.19188809842e-10 ,
 4.09130760836e-10 , 1.95998176043e-10 , 1.54884658382e-10 , 4.84074123964e-10 ,
 1.88530042422e-09 , 5.9498945728e-09  , 1.47490145419e-08 , 2.87009442443e-08 ,
 4.39014612452e-08 , 5.28633902449e-08 , 5.01843667392e-08 , 3.76233290721e-08 ,
 2.24556648556e-08 , 1.20702357232e-08 , 1.53925547454e-08 , 6.51502560465e-08 ,
 2.81262676304e-07 , 9.7564480679e-07  , 2.68080953818e-06 , 5.8455094889e-06  ,
 1.02884253444e-05 , 1.60943327543e-05 , 3.12935052501e-05 , 9.83675940593e-05 ,
 0.000353667913006 , 0.00109696020241  , 0.00276546184254  , 0.00575276201681  ,
 0.010348988225    , 0.0171162916557   , 0.0270275178338   , 0.0402610986963   ,
 0.0548370905323   , 0.0681407199986   , 0.0810868428345   , 0.10027013017     ,
 0.134362246303    , 0.185029862411    , 0.237962537387    , 0.265708189665    ,
 0.247492075578    , 0.188803392107    , 0.117550195944    , 0.0608744432665   ,
 0.0286948386822   , 0.0164212637279   , 0.0158960715523   , 0.0211065148374   ,
 0.0273449071545   , 0.0300815393531   , 0.0268606585593   , 0.0191761438269   ,
 0.00982978993552  , 0.00460651438061  , 0.00171457036988  , 0.000508043898205 ,
 0.000120455531693 , 2.31024808735e-05 , 3.66276101634e-06 , 4.98725636873e-07 ,
 6.1578973243e-08  , 7.28316091137e-09 , 8.59216744047e-10 , 1.09556571953e-10 ,
 1.96849205297e-11 , 6.60721126483e-12 , 4.21035574681e-12 , 5.6038341235e-12  ,
 1.30246881981e-11 , 3.34653425503e-11 , 7.43124557625e-11 , 1.32685829738e-10 ,
 1.87054185043e-10 , 2.0716007055e-10  , 1.7990771537e-10  , 1.22406971546e-10 ,
 6.52161428825e-11 , 2.72018114627e-11 , 8.88269684682e-12 , 2.2715067167e-12  ,
 4.55383606306e-13 , 8.18437072661e-14 , 3.28981778659e-13 , 7.81798514092e-12 ,
 1.50646456603e-10 , 2.29401605654e-09 , 2.76282117776e-08 , 2.63330784584e-07 ,
 1.98729255824e-06 , 1.18847085857e-05 , 5.64420114697e-05 , 0.000214022039052 ,
 0.000656048161519 , 0.00166622031351  , 0.00364861133906  , 0.00719914459798  ,
 0.013051578671    , 0.0212600471087   , 0.0297661303651   , 0.0344741199411   ,
 0.0322771186701   , 0.0242008900709   , 0.014719774308    , 0.00827515345317  ,
 0.00722151708405  , 0.0120902213346   , 0.0215533701693   , 0.0315160664966   ,
 0.0363523515527   , 0.0332217891581   , 0.0247915538558   , 0.0164626463796   ,
 0.0114007558934   , 0.0090238573834   , 0.00735671015043  , 0.00555201749526  ,
 0.00434678717792  , 0.00527100666319  , 0.00984976471266  , 0.0185771928584   ,
 0.0295612346773   , 0.0387627847676   , 0.043275010268    , 0.0446587010606   ,
 0.047675232493    , 0.055018601192    , 0.0637003779989   , 0.0670307559208   ,
 0.060796445535    , 0.0484443268606   , 0.0413024857643   , 0.0554139779852   ,
 0.107064175986    , 0.202345674183    , 0.320418616555    , 0.410794436       ,
 0.424273924843    , 0.354450432852    , 0.241983174977    , 0.137243437862    ,
 0.0660672098349   , 0.0275498315684   , 0.0100443721695   , 0.00317651276783  ,
 0.000853590075956 , 0.000190515132903 , 3.47193589032e-05 , 5.12391258455e-06 ,
 6.13530792748e-07 , 6.04122876987e-08 , 5.01803437736e-09 , 3.62783396727e-10 ,
 2.33042718556e-11 , 1.3312571864e-12  , 7.90456319293e-14 , 6.46419133932e-14 ,
 3.87854116294e-13 , 2.04405342211e-12 , 8.51713895831e-12 , 2.79582477064e-11 ,
 7.23796122184e-11 , 1.47964282676e-10 , 2.39090799028e-10 , 3.05560043211e-10 ,
 3.08902019392e-10 , 2.46939721426e-10 , 1.55981363094e-10 , 7.77642755777e-11 ,
 3.05596312696e-11 , 9.46606859922e-12 , 2.39557633611e-12 , 9.32505693496e-13 ,
 2.01191514647e-12 , 6.01792664346e-12 , 1.45456344557e-11 , 2.75819959181e-11 ,
 4.09990612368e-11 , 4.7803944685e-11  , 4.37661477828e-11 , 3.15113801044e-11 ,
 1.79626337613e-11 , 8.90540899147e-12 , 8.91412894076e-12 , 3.22188837237e-11 ,
 1.27010010716e-10 , 4.00786832028e-10 , 9.92453979435e-10 , 1.9287304231e-09  ,
 2.94564367355e-09 , 3.54062557827e-09 , 3.35449120204e-09 , 2.5101871549e-09  ,
 1.50459678129e-09 , 8.94753292351e-10 , 1.67937588054e-09 , 7.98022010701e-09 ,
 3.47259546664e-08 , 1.20700257004e-07 , 3.35074871486e-07 , 7.77684682601e-07 ,
 1.87207893721e-06 , 7.03657792074e-06 , 3.68985239232e-05 , 0.000180747432333 ,
 0.000715906361456 , 0.00223575710755  , 0.00551890825543  , 0.0109351735601   ,
 0.0179907445466   , 0.0261219819295   , 0.0361538061443   , 0.0498991827354   ,
 0.067687174478    , 0.0874419240716   , 0.107177400994    , 0.12808454782     ,
 0.154570764429    , 0.189109012905    , 0.223836622999    , 0.239292487186    ,
 0.218667598021    , 0.165341380387    , 0.101904836666    , 0.0512778946553   ,
 0.0221311324931   , 0.0106555803723   , 0.00982340504343  , 0.0144129634691   ,
 0.0204045223221   , 0.0238701976011   , 0.0223576172977   , 0.0166431842923   ,
 0.0124416383076   , 0.00600089674826  , 0.00229857177426  , 0.000700977174604 ,
 0.000171059707405 , 3.37218363776e-05 , 5.4573905289e-06  , 7.42152085922e-07 ,
 8.70432605718e-08 , 8.96276366198e-09 , 8.1073559349e-10  , 6.39008278214e-11 ,
 4.56093105651e-12 , 4.24148209986e-13 , 1.42755078248e-13 , 2.00583041556e-13 ,
 5.24494805536e-13 , 1.40400127067e-12 , 3.1479764692e-12  , 5.62945615669e-12 ,
 7.93276074076e-12 , 8.77677874622e-12 , 7.6125656037e-12  , 5.17159895047e-12 ,
 2.75023705977e-12 , 1.14453605612e-12 , 3.72706324721e-13 , 9.49841877292e-14 ,
 1.90266486099e-14 , 5.94175837891e-15 , 9.24581599556e-14 , 2.24278214148e-12 ,
 4.30935038319e-11 , 6.54212425031e-10 , 7.85607580105e-09 , 7.47063086154e-08 ,
 5.63402904785e-07 , 3.3793807753e-06  , 1.62250208422e-05 , 6.32217706944e-05 ,
 0.000205332748967 , 0.000579349518937 , 0.00148173897281  , 0.00348200285199  ,
 0.00731095292789  , 0.0131046062693   , 0.019328276103    , 0.022959556466    ,
 0.02174388973     , 0.016384464684    , 0.010002615121    , 0.0057091224542   ,
 0.00520576267066  , 0.00895058864859  , 0.0160337893252   , 0.0234442293231   ,
 0.0269737589783   , 0.0244288710462   , 0.0176910407981   , 0.0107665191819   ,
 0.0062201765266   , 0.00399896104304  , 0.00288727162625  , 0.00214155120251  ,
 0.00194948541077  , 0.00316804876072  , 0.00689673338952  , 0.0136696783912   ,
 0.0224171050789   , 0.0307153361795   , 0.0371681700511   , 0.0433944700401   ,
 0.052361873307    , 0.0643334896831   , 0.0750017192585   , 0.078067532099    ,
 0.0705956537913   , 0.0569981346882   , 0.0479969983097   , 0.0560056880936   ,
 0.0910153190006   , 0.155370365895    , 0.234953252652    , 0.297541876354    ,
 0.31155360999     , 0.271672023507    , 0.201294905954    , 0.1300250038      ,
 0.0744938580752   , 0.0377034113233   , 0.0164652816182   , 0.00602531537748  ,
 0.00180510879978  , 0.00043684648095  , 8.51040910545e-05 , 1.34341580161e-05 ,
 1.74878777988e-06 , 1.92997391013e-07 , 1.85916617189e-08 , 1.5847880252e-09  ,
 1.18052843525e-10 , 7.45784829503e-12 , 3.87894211023e-13 , 1.87197091781e-14 ,
 1.70633106097e-14 , 8.74354157331e-14 , 3.6429780215e-13  , 1.19565504069e-12 ,
 3.09478368867e-12 , 6.32530287744e-12 , 1.02186270453e-11 , 1.30565698032e-11 ,
 1.31964374397e-11 , 1.05471183777e-11 , 6.6608318216e-12  , 3.32013993947e-12 ,
 1.30451216277e-12 , 4.0388724932e-13  , 1.01343625338e-13 , 3.54023513796e-14 ,
 6.87867479296e-14 , 2.04569758761e-13 , 4.95100040288e-13 , 9.39893362716e-13 ,
 1.39824005234e-12 , 1.63126644659e-12 , 1.49409909137e-12 , 1.07619176459e-12 ,
 6.15466966472e-13 , 3.21589719258e-13 , 4.20281661636e-13 , 1.69817022958e-12 ,
 6.74685665676e-12 , 2.12833900043e-11 , 5.26530522858e-11 , 1.02205280255e-10 ,
 1.55875794185e-10 , 1.87060512552e-10 , 1.7691127154e-10  , 1.32203709275e-10 ,
 8.00275983668e-11 , 5.58997847675e-11 , 1.51374950814e-10 , 7.70751645614e-10 ,
 3.38180807338e-09 , 1.20764174143e-08 , 3.91666813233e-08 , 1.67815450807e-07 ,
 1.17685423162e-06 , 9.03457137232e-06 , 5.82028783887e-05 , 0.000296088453117 ,
 0.0011779800058   , 0.00366566315899  , 0.00895746247719  , 0.017360224399    ,
 0.0273193501076   , 0.0367522024219   , 0.0462641833852   , 0.059890624007    ,
 0.0811721246037   , 0.108804383645    , 0.136735512869    , 0.158630092007    ,
 0.173007177823    , 0.183393096389    , 0.190880536314    , 0.187837576835    ,
 0.164384188091    , 0.121705533743    , 0.0740598367516   , 0.0367219577112   ,
 0.0155197510367   , 0.00778648222527  , 0.00878301418469  , 0.0148856631773   ,
 0.0225686651626   , 0.0275358485723   , 0.0266639559921   , 0.020458980155    ,
 0.0164252518591   , 0.00809195979981  , 0.00319734598498  , 0.00102305095332  ,
 0.000269113935316 , 5.94024004899e-05 , 1.124066887e-05   , 1.84739901981e-06 ,
 2.62889789304e-07 , 3.18305657678e-08 , 3.20580266805e-09 , 2.63293643263e-10 ,
 1.73907212786e-11 , 9.18768107601e-13 , 4.14082377783e-14 , 7.08948728592e-15 ,
 1.68883012434e-14 , 4.63989544817e-14 , 1.04672381105e-13 , 1.87339104175e-13 ,
 2.63870097231e-13 , 2.91701792367e-13 , 2.52744446934e-13 , 1.7148579344e-13  ,
 9.10559216694e-14 , 3.78225353078e-14 , 1.22879194231e-14 , 3.12283284601e-15 ,
 6.38136187129e-16 , 7.76897024226e-16 , 2.09916857959e-14 , 5.09721357578e-13 ,
 9.76920770728e-12 , 1.47940001171e-10 , 1.7730242291e-09  , 1.68523074402e-08 ,
 1.2749298637e-07  , 7.73365874375e-07 , 3.81914559554e-06 , 1.58003988936e-05 ,
 5.71781608221e-05 , 0.000188658746147 , 0.000572516309535 , 0.00154655305181  ,
 0.00354857110387  , 0.00667195570105  , 0.0100726112036   , 0.0120943253056   ,
 0.0115091661858   , 0.0086927800183   , 0.00532531318651  , 0.00309554576732  ,
 0.00296429085612  , 0.00523651455847  , 0.0094248985224   , 0.0137844934539   ,
 0.0158404737923   , 0.0142816337375   , 0.0101852471647   , 0.00590452713633  ,
 0.0030100642245   , 0.0015830992508   , 0.000985594526073 , 0.000753305328847 ,
 0.000902988636023 , 0.00187139385111  , 0.00431029528919  , 0.00863173143385  ,
 0.0145128152804   , 0.0212348190463   , 0.0289984993647   , 0.0393299635794   ,
 0.0530633832722   , 0.0679180186629   , 0.0787867858867   , 0.0808141562817   ,
 0.0732502148205   , 0.0615311124889   , 0.054864410678    , 0.0605875240486   ,
 0.0810667696865   , 0.114490284573    , 0.154599496562    , 0.189741703228    ,
 0.207765455655    , 0.203889871653    , 0.181076841097    , 0.14464521184     ,
 0.101155994058    , 0.0598395990437   , 0.0291148712954   , 0.0114523696221   ,
 0.00361557216698  , 0.000917512394342 , 0.000189145045537 , 3.23331992813e-05 ,
 4.7140877618e-06  , 6.01166503693e-07 , 6.75085536427e-08 , 6.56238808741e-09 ,
 5.36133983415e-10 , 3.58116587355e-11 , 1.91815181618e-12 , 8.14865164565e-14 ,
 3.2582016815e-15  , 2.99888636593e-15 , 1.22026552498e-14 , 4.00404583624e-14 ,
 1.0362305503e-13  , 2.11755211412e-13 , 3.42032831936e-13 , 4.36943022316e-13 ,
 4.41543324103e-13 , 3.52837041411e-13 , 2.22790887964e-13 , 1.11035071366e-13 ,
 4.36203964447e-14 , 1.34999946233e-14 , 3.36415401673e-15 , 1.06507274538e-15 ,
 1.83709409022e-15 , 5.41888959067e-15 , 1.31289367891e-14 , 2.49497418039e-14 ,
 3.71446605676e-14 , 4.33584189687e-14 , 3.97277976642e-14 , 2.86293651788e-14 ,
 1.6456316535e-14  , 9.29825539301e-15 , 1.61204008934e-14 , 7.06609338142e-14 ,
 2.82146436608e-13 , 8.89710706244e-13 , 2.19921664934e-12 , 4.26453400237e-12 ,
 6.49605236603e-12 , 7.78472431673e-12 , 7.35106478684e-12 , 5.49008147334e-12 ,
 3.3895209894e-12  , 2.9943296688e-12  , 1.10865479172e-11 , 5.93349834931e-11 ,
 2.79330802253e-10 , 1.4137744227e-09  , 1.17417115418e-08 , 1.33838461912e-07 ,
 1.39338102672e-06 , 1.16293426251e-05 , 7.59962047929e-05 , 0.000387482003092 ,
 0.0015415047726   , 0.00479090405955  , 0.0116685856743   , 0.0224425067376   ,
 0.0347500184617   , 0.0453955895133   , 0.0550346512138   , 0.0698526529986   ,
 0.0962768948427   , 0.133386984798    , 0.170672495844    , 0.193888018051    ,
 0.19542693579     , 0.179960746346    , 0.158014503551    , 0.134543831136    ,
 0.107330052312    , 0.0755968729873   , 0.0448261031536   , 0.0219598369615   ,
 0.00960284015643  , 0.00627311888179  , 0.00975242053706  , 0.0181375864994   ,
 0.0282075059753   , 0.0348982030098   , 0.0342051160157   , 0.0265878601342   ,
 0.0189706709724   , 0.00977960639041  , 0.00416150232175  , 0.0014912482641   ,
 0.000458615523702 , 0.000122188363133 , 2.80460520087e-05 , 5.45063807628e-06 ,
 8.78588302558e-07 , 1.15409200919e-07 , 1.21991368693e-08 , 1.02899027142e-09 ,
 6.88794136578e-11 , 3.64520460965e-12 , 1.5212577733e-13  , 5.1074346513e-15  ,
 5.42390172778e-16 , 1.19600679435e-15 , 2.72100469978e-15 , 4.87919609628e-15 ,
 6.87166652859e-15 , 7.59154614323e-15 , 6.57191649499e-15 , 4.45421960419e-15 ,
 2.36200638091e-15 , 9.7953557349e-16  , 3.17596175898e-16 , 8.05591926077e-17 ,
 1.90926136562e-17 , 1.25298243036e-16 , 3.78095888009e-15 , 9.16796995504e-14 ,
 1.75361764682e-12 , 2.65141232712e-11 , 3.17698704061e-10 , 3.02955138706e-09 ,
 2.3179722556e-08  , 1.44658141091e-07 , 7.59130008511e-07 , 3.50445737847e-06 ,
 1.48348301923e-05 , 5.78917950397e-05 , 0.000200770970125 , 0.000589488773487 ,
 0.00141390940969  , 0.00271629930412  , 0.00414189750103  , 0.00499566766792  ,
 0.00476363208976  , 0.00360248799354  , 0.00221520756451  , 0.00131672009648  ,
 0.00133320759159  , 0.0024228130706   , 0.00438147038732  , 0.00641074669379  ,
 0.00736271286268  , 0.0066243473493   , 0.00469251213006  , 0.00266612598227  ,
 0.00129756997131  , 0.000657155396412 , 0.000469305552398 , 0.000521896433291 ,
 0.000833593124566 , 0.0016318476991   , 0.00321126694298  , 0.00572913830098  ,
 0.00919969123861  , 0.0139904702909   , 0.0213583691512   , 0.0327089810239   ,
 0.0474744527367   , 0.0620228198304   , 0.0714251721597   , 0.0726224250184   ,
 0.0668735243897   , 0.0601862594937   , 0.0598646017172   , 0.0684211324867   ,
 0.081739856998    , 0.094812821821    , 0.107933409568    , 0.125816843906    ,
 0.151373584299    , 0.179480274704    , 0.19552712456     , 0.184154075733    ,
 0.144001195671    , 0.0913784790804   , 0.0465540105146   , 0.0189998796168   ,
 0.00624504646742  , 0.00167580050182  , 0.000375412483899 , 7.21302766623e-05 ,
 1.21262885104e-05 , 1.78402082073e-06 , 2.25105109853e-07 , 2.36856603448e-08 ,
 2.02815253204e-09 , 1.38971568629e-10 , 7.54188383959e-12 , 3.22195732923e-13 ,
 1.0789480532e-14  , 3.59678117783e-16 , 3.25237122792e-16 , 1.0489324419e-15  ,
 2.71425279803e-15 , 5.54585635902e-15 , 8.95652397394e-15 , 1.14401587687e-14 ,
 1.15588984628e-14 , 9.23539448232e-15 , 5.83070123238e-15 , 2.90556525732e-15 ,
 1.14132407931e-15 , 3.53107724267e-16 , 8.74651443132e-17 , 2.5220097125e-17  ,
 3.78784706942e-17 , 1.10794330904e-16 , 2.69311941942e-16 , 5.1314467401e-16  ,
 7.65395830898e-16 , 8.94630538585e-16 , 8.20517728004e-16 , 5.9195674614e-16  ,
 3.43241936082e-16 , 2.1747138761e-16  , 4.99277469012e-16 , 2.31565881829e-15 ,
 9.27455382639e-15 , 2.92341606262e-14 , 7.2209881632e-14  , 1.39900272496e-13 ,
 2.12884934417e-13 , 2.54810121269e-13 , 2.40312225023e-13 , 1.79586292232e-13 ,
 1.15039777968e-13 , 1.38949111699e-13 , 6.71445153455e-13 , 4.33852069101e-12 ,
 3.93960087036e-11 , 5.9836706618e-10  , 9.80560682717e-09 , 1.33828449339e-07 ,
 1.43906432856e-06 , 1.20819783198e-05 , 7.91003685663e-05 , 0.000403888653337 ,
 0.00160942077583  , 0.00501195846325  , 0.012236370654    , 0.0236046345071   ,
 0.0367057185596   , 0.0483531662166   , 0.0597671377639   , 0.0786087273551   ,
 0.112951475302    , 0.161599802428    , 0.209942297195    , 0.236662551363    ,
 0.228518054299    , 0.190960827887    , 0.142716159079    , 0.0997840121511   ,
 0.0668117881004   , 0.0417753490788   , 0.0231456900972   , 0.0110505119105   ,
 0.0053050075494   , 0.00513482950275  , 0.01010638041     , 0.0195780232873   ,
 0.03072034056     , 0.0382623871629   , 0.0378621771754   , 0.0298967986701   ,
 0.0196132050188   , 0.0113565223804   , 0.00566414591565  , 0.00244891868789  ,
 0.00090962343045  , 0.000284801845372 , 7.36583785518e-05 , 1.54848792683e-05 ,
 2.61727064918e-06 , 3.53208056516e-07 , 3.78902836006e-08 , 3.2211593045e-09  ,
 2.16499042702e-10 , 1.1480987859e-11  , 4.79492828197e-13 , 1.57441668068e-14 ,
 4.13785027598e-16 , 3.0397734152e-17  , 5.22671653593e-17 , 9.35074294452e-17 ,
 1.31360717741e-16 , 1.44710704596e-16 , 1.24861034532e-16 , 8.42924494073e-17 ,
 4.44835322524e-17 , 1.83373522631e-17 , 5.9011455862e-18  , 1.48970926761e-18 ,
 7.3820094305e-19  , 1.75580203428e-17 , 5.38203572081e-16 , 1.30345996585e-14 ,
 2.49034810195e-13 , 3.76559341278e-12 , 4.5270289998e-11  , 4.36489796645e-10 ,
 3.43420382623e-09 , 2.27645266487e-08 , 1.33292228604e-07 , 7.19542887502e-07 ,
 3.59450785692e-06 , 1.59673928095e-05 , 5.99638218608e-05 , 0.00018358987384  ,
 0.000449343303125 , 0.000871360807293 , 0.00133431574158  , 0.00161241398948  ,
 0.00153891140319  , 0.00116491417004  , 0.000719847679411 , 0.000440718853277 ,
 0.000476875517254 , 0.000892361302716 , 0.00161950324143  , 0.00236825147309  ,
 0.0027180197754   , 0.00244742068665  , 0.00175163969338  , 0.00106263886595  ,
 0.000698761682452 , 0.000717639931813 , 0.00101336607869  , 0.00149862639208  ,
 0.00225030755983  , 0.00347579915461  , 0.00522753439331  , 0.00718927949801  ,
 0.00906758568516  , 0.0114733839856   , 0.0161704541929   , 0.0247007098269   ,
 0.0362817729581   , 0.0474412409818   , 0.054256530438    , 0.0551653978081   ,
 0.0524688662996   , 0.0518488640756   , 0.058571800443    , 0.0716989356433   ,
 0.0833810319722   , 0.0872163440024   , 0.0875693222972   , 0.0984520015309   ,
 0.131132820108    , 0.179976984381    , 0.219723368294    , 0.222373853872    ,
 0.181779341038    , 0.119079085893    , 0.06257421501     , 0.0265923802149   ,
 0.00928557797907  , 0.00272609364591  , 0.000689470750639 , 0.000152319005947 ,
 2.92267156153e-05 , 4.76602058907e-06 , 6.43637001773e-07 , 7.04691619098e-08 ,
 6.16521642746e-09 , 4.27154900979e-10 , 2.3310368671e-11  , 9.98578264174e-13 ,
 3.34801948723e-14 , 8.80711769494e-16 , 2.35319325363e-17 , 2.04465893138e-17 ,
 5.28829252723e-17 , 1.07995856685e-16 , 1.74316321169e-16 , 2.22527790009e-16 ,
 2.24710519511e-16 , 1.79442651224e-16 , 1.13232006709e-16 , 5.63996683372e-17 ,
 2.21443988055e-17 , 6.8437332454e-18  , 1.66233367222e-18 , 3.16899698132e-19 ,
 4.73520734598e-20 , 5.5394962563e-21  , 5.06860534173e-22 , 3.63585447217e-23 ,
 5.41052393003e-24 , 7.74277985131e-23 , 1.37679417372e-21 , 1.91108473463e-20 ,
 2.06908123285e-19 , 1.7479788594e-18  , 1.15285224689e-17 , 5.93961253055e-17 ,
 2.39230132899e-16 , 7.53942492788e-16 , 1.8611680887e-15  , 3.60319061974e-15 ,
 5.47814885199e-15 , 6.55040337499e-15 , 6.17184482276e-15 , 4.62580794177e-15 ,
 3.2020985837e-15  , 6.72764106617e-15 , 6.36643856509e-14 , 1.05414585697e-12 ,
 2.2798804037e-11  , 4.73075464583e-10 , 8.15845317772e-09 , 1.11909218205e-07 ,
 1.20505841447e-06 , 1.01457861809e-05 , 6.67197588279e-05 , 0.000342766979482 ,
 0.00137706664842  , 0.00433557079143  , 0.0107459065705   , 0.0211874628045   ,
 0.0340746583915   , 0.0473347713802   , 0.06303204446     , 0.089261430959    ,
 0.134183313716    , 0.195568823091    , 0.25539198322     , 0.28695210536     ,
 0.272775577257    , 0.218846555379    , 0.149849810237    , 0.0898856537969   ,
 0.0489439437135   , 0.0248099100278   , 0.0116577072893   , 0.00509485656677  ,
 0.00277199652729  , 0.0038777972488   , 0.00864955036353  , 0.0170757461035   ,
 0.0270369686823   , 0.0341566317269   , 0.0346801264721   , 0.0286554520527   ,
 0.0210933849165   , 0.0147964138024   , 0.00891727866391  , 0.00451729753807  ,
 0.00188282162987  , 0.00063556074467  , 0.000172028605288 , 3.7123794236e-05  ,
 6.36663950688e-06 , 8.66001350001e-07 , 9.32908436886e-08 , 7.94836509845e-09 ,
 5.34827797641e-10 , 2.83783987345e-11 , 1.18554770316e-12 , 3.89329458776e-14 ,
 1.00369840336e-15 , 1.83591053174e-17 , 1.73349331766e-26 , 4.26690932459e-28 ,
 6.43318425015e-30 , 0, 0, 0, 0, 0, 0, 8.97271778986e-22 , 5.04342751089e-20 ,
 1.9692834843e-18  , 6.04309696703e-17 , 1.46323299553e-15 , 2.79653025969e-14 ,
 4.24248263044e-13 , 5.15433112588e-12 , 5.1043444366e-11  , 4.25826909859e-10 ,
 3.14439367706e-09 , 2.15093025848e-08 , 1.36883021826e-07 , 7.76910869597e-07 ,
 3.7293721847e-06  , 1.45819925808e-05 , 4.55177365351e-05 , 0.000112404751656 ,
 0.000218855590199 , 0.000335742382611 , 0.00040606531713  , 0.000387840517264 ,
 0.000294428683438 , 0.000185310157648 , 0.000124180801653 , 0.000154819971926 ,
 0.000297276230349 , 0.000528085332628 , 0.00075517856956  , 0.000855492943456 ,
 0.000785589187086 , 0.000661832659746 , 0.000725330720936 , 0.00122154505045  ,
 0.00225225956506  , 0.00368326412447  , 0.00529419517352  , 0.0071568326003   ,
 0.00967006879436  , 0.0128157722707   , 0.0154975270688   , 0.0163520889564   ,
 0.015570754968    , 0.0153804974237   , 0.018106061512    , 0.0237741099412   ,
 0.0299326791164   , 0.0338124769876   , 0.0346429866695   , 0.0346352243634   ,
 0.0382458406119   , 0.0488012110508   , 0.0637625514504   , 0.074751096125    ,
 0.075853803055    , 0.0728053490144   , 0.0817895835699   , 0.116118427129    ,
 0.170473126631    , 0.217688472703    , 0.227003063235    , 0.190387279091    ,
 0.128594439107    , 0.0706520903013   , 0.0321300883663   , 0.0123701886608   ,
 0.00411458326142  , 0.00119104833503  , 0.000296899776811 , 6.23414874695e-05 ,
 1.07734895601e-05 , 1.50467150835e-06 , 1.677614896e-07   , 1.48158649682e-08 ,
 1.03138875355e-09 , 5.64163770989e-11 , 2.41958423715e-12 , 8.12091300831e-14 ,
 2.13263098156e-15 , 4.19581817222e-17 , 1.45410121085e-28 , 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 1.17217932524e-30 , 5.68495862769e-29 ,
 2.13721721448e-27 , 6.26069486285e-26 , 1.42926172686e-24 , 2.54329149507e-23 ,
 3.52839079668e-22 , 3.81751515092e-21 , 3.22231661669e-20 , 2.12294231323e-19 ,
 1.09228745769e-18 , 4.39203372959e-18 , 1.38129960571e-17 , 3.40122225537e-17 ,
 6.56459811572e-17 , 9.9443082611e-17  , 1.18413348372e-16 , 1.11458453852e-16 ,
 9.8018183989e-17  , 4.88636993629e-16 , 1.00667202942e-14 , 1.84373320789e-13 ,
 2.83327374776e-12 , 3.9138856939e-11  , 5.27459035749e-10 , 7.02152661462e-09 ,
 8.58500444673e-08 , 8.8964049958e-07  , 7.46105029989e-06 , 4.96641836894e-05 ,
 0.000260718624987 , 0.00107883187066  , 0.00352876967385  , 0.00918465617478  ,
 0.0192855811837   , 0.0336116540628   , 0.0513668224143   , 0.0747604339676   ,
 0.110906142624    , 0.166611849242    , 0.237981370324    , 0.304599348025    ,
 0.337277707042    , 0.31745367971     , 0.252241414064    , 0.169347977923    ,
 0.0967760720424   , 0.0476593095442   , 0.0205315058509   , 0.00787565038603  ,
 0.00287388460595  , 0.00158467352474  , 0.00259837817398  , 0.00599765628855  ,
 0.0119700422893   , 0.019389816144    , 0.0256085623696   , 0.0280799051702   ,
 0.0261561901622   , 0.0262645864592   , 0.0215999445755   , 0.0145785169798   ,
 0.00794138429708  , 0.00345698838075  , 0.00119637484357  , 0.000328364187906 ,
 7.14044844533e-05 , 1.22964514432e-05 , 1.67628780471e-06 , 1.80790748039e-07 ,
 1.54127245482e-08 , 1.03741307197e-09 , 5.5054758653e-11  , 2.30017860218e-12 ,
 7.5542784334e-14  , 1.94750666263e-15 , 3.56227320802e-17 , 1.10463126515e-28 ,
 2.25896112421e-30 , 0, 0, 0, 0, 0, 0, 0, 7.98565953576e-23 ,
 4.46929376138e-21 , 1.74333875453e-19 , 5.34337884928e-18 , 1.2959905338e-16  ,
 2.48478539379e-15 , 3.80656807394e-14 , 4.74152633164e-13 , 4.96418935e-12    ,
 4.59865916635e-11 , 3.96079863294e-10 , 3.19454547521e-09 , 2.31023983835e-08 ,
 1.41634935405e-07 , 7.0746813951e-07  , 2.81904788967e-06 , 8.87628797142e-06 ,
 2.20057030424e-05 , 4.29219394377e-05 , 6.59085189568e-05 , 7.98362547171e-05 ,
 7.68870514562e-05 , 6.1537225109e-05  , 5.11838201468e-05 , 7.02990026817e-05 ,
 0.000141630814417 , 0.000268861227877 , 0.000415402260635 , 0.00051236321056  ,
 0.000518811996496 , 0.000503978237184 , 0.000709878238608 , 0.00157614577038  ,
 0.00363164909464  , 0.00710103620685  , 0.0114561299903   , 0.0156915461007   ,
 0.0194940886364   , 0.023731234146    , 0.0288222006111   , 0.0328362564819   ,
 0.0326798405083   , 0.0276690015401   , 0.0208314415266   , 0.0161107021258   ,
 0.0149832881598   , 0.0160707642215   , 0.0172640984686   , 0.0177966814557   ,
 0.0190053760918   , 0.0236842205349   , 0.0335960452093   , 0.046203341573    ,
 0.0549597855268   , 0.0556237354029   , 0.0531748256311   , 0.0608623502488   ,
 0.0897318478292   , 0.135915580497    , 0.1777211287      , 0.189918058694    ,
 0.164709877852    , 0.117063493671    , 0.0694211885949   , 0.0350747940226   ,
 0.0153276515572   , 0.00579759668651  , 0.00187118053236  , 0.000504369606575 ,
 0.000111259604524 , 1.97808956076e-05 , 2.80549554821e-06 , 3.15310624277e-07 ,
 2.79601308872e-08 , 1.95036326269e-09 , 1.06790430973e-10 , 4.58227753654e-12 ,
 1.53865611783e-13 , 4.04066107505e-15 , 7.94974814089e-17 , 5.48235444299e-27 ,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.63922358711e-30 ,
 1.7697143374e-28  , 6.65811070879e-27 , 1.95227944071e-25 , 4.46234657322e-24 ,
 7.95289467024e-23 , 1.10552006631e-21 , 1.1991163397e-20  , 1.01537331589e-19 ,
 6.71627000153e-19 , 3.54256548555e-18 , 1.74105310342e-17 , 1.70587966344e-16 ,
 3.79568586404e-15 , 8.42903207288e-14 , 1.49704669594e-12 , 2.08815907385e-11 ,
 2.30745152856e-10 , 2.07504623887e-09 , 1.61332040769e-08 , 1.19365974581e-07 ,
 8.97283817492e-07 , 6.57782911171e-06 , 4.28362808196e-05 , 0.000232131847162 ,
 0.00101718236161  , 0.00357398779914  , 0.0100863419503   , 0.023083473686    ,
 0.043736844527    , 0.0712811835668   , 0.105837778662    , 0.151551553714    ,
 0.213052287885    , 0.28527026399     , 0.347577914082    , 0.372393401427    ,
 0.344251139179    , 0.27233274472     , 0.183954354374    , 0.106072748313    ,
 0.0521540856754   , 0.021841919807    , 0.00789916458768  , 0.0027492534092   ,
 0.00146710509411  , 0.00191729222651  , 0.0037505982921   , 0.00724193448829  ,
 0.0123357149015   , 0.0182515086699   , 0.0236449479232   , 0.0268392482218   ,
 0.0339026881034   , 0.0299509441205   , 0.021083132708    , 0.0117609942363   ,
 0.00518763705683  , 0.00180833423717  , 0.000498285005264 , 0.000108585938151 ,
 1.87208484821e-05 , 2.55363784719e-06 , 2.75503136269e-07 , 2.34910526699e-08 ,
 1.58129243207e-09 , 8.39217171239e-11 , 3.50631414036e-12 , 1.15157272749e-13 ,
 2.96877534897e-15 , 5.43032231336e-17 , 0, 0, 0, 0, 0, 0, 0, 0, 0,
 5.58157049002e-24 , 3.1126843587e-22  , 1.21314492385e-20 , 3.71463595782e-19 ,
 9.05933327317e-18 , 1.75244669546e-16 , 2.74632190299e-15 , 3.60226917419e-14 ,
 4.16812548922e-13 , 4.4923752387e-12  , 4.56717239195e-11 , 4.19537788592e-10 ,
 3.28139928153e-09 , 2.09409336581e-08 , 1.06597063213e-07 , 4.28426740172e-07 ,
 1.35421221762e-06 , 3.36340032813e-06 , 6.56956766739e-06 , 1.01368875997e-05 ,
 1.26619688446e-05 , 1.46737675558e-05 , 2.42035018389e-05 , 6.64180533107e-05 ,
 0.000191645249041 , 0.000456978711956 , 0.000857896392001 , 0.00125971759766  ,
 0.0014536841622   , 0.00136479440661  , 0.00125382246987  , 0.00180489451457  ,
 0.00413182827929  , 0.0094877675656   , 0.0182499570966   , 0.0287323935154   ,
 0.037793687201    , 0.0438148371763   , 0.0485069647031   , 0.0539720764028   ,
 0.0582959083989   , 0.0565512001873   , 0.0467245498745   , 0.0325886648478   ,
 0.0200694892343   , 0.012357348047    , 0.0089438249023   , 0.00782672918059  ,
 0.00769722851937  , 0.00874297484496  , 0.0122133241682   , 0.018831841442    ,
 0.0268654001263   , 0.0323604798602   , 0.0329095396848   , 0.0317697482954   ,
 0.03732013615     , 0.0567384000715   , 0.0881298903978   , 0.118405065676    ,
 0.131520683319    , 0.120984105813    , 0.0936775473575   , 0.0621426286502   ,
 0.0356344626775   , 0.0175670038423   , 0.00732033448074  , 0.00252687412045  ,
 0.000710096089319 , 0.000160428635427 , 2.88956821363e-05 , 4.12627991157e-06 ,
 4.65377395565e-07 , 4.1339941275e-08  , 2.88619525132e-09 , 1.58099016101e-10 ,
 6.78531338171e-12 , 2.27884245265e-13 , 5.98446266697e-15 , 1.17740564908e-16 ,
 1.6118901829e-25  , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 1.76120890735e-28 , 8.56456488561e-27 , 3.22220484831e-25 , 9.44809204029e-24 ,
 2.15956078112e-22 , 3.84881791327e-21 , 5.35018395196e-20 , 5.80314227266e-19 ,
 4.9139056067e-18  , 3.25031494521e-17 , 1.68543411331e-16 , 7.02942498859e-16 ,
 3.0172217949e-15  , 3.05716797592e-14 , 5.84861997808e-13 , 1.02105258207e-11 ,
 1.41069851505e-10 , 1.52389587001e-09 , 1.29131422387e-08 , 8.69151519531e-08 ,
 4.80742422037e-07 , 2.36261833228e-06 , 1.16004996284e-05 , 6.00925574868e-05 ,
 0.00030373028918  , 0.00134540461109  , 0.00491990612534  , 0.0145428242757   ,
 0.034698137854    , 0.0675867458772   , 0.110280852564    , 0.157465158271    ,
 0.207934111047    , 0.264346853435    , 0.323078810456    , 0.367243145229    ,
 0.375045148498    , 0.336925012815    , 0.263873623295    , 0.179520454175    ,
 0.105617219675    , 0.0533352306754   , 0.0231026595747   , 0.00907092433532  ,
 0.00413318161613  , 0.00302996102028  , 0.00308166046056  , 0.00361755869119  ,
 0.00514840541206  , 0.00864821105415  , 0.0148469950182   , 0.0231978336237   ,
 0.0309206320333   , 0.0386685660865   , 0.0349514342923   , 0.0249141233904   ,
 0.0139932525709   , 0.00619512899606  , 0.00216386121187  , 0.000596896684097 ,
 0.000130151375331 , 2.24458892495e-05 , 3.06226658262e-06 , 3.30406332085e-07 ,
 2.81737166874e-08 , 1.8965490034e-09  , 1.00654090455e-10 , 4.20543142475e-12 ,
 1.38119052996e-13 , 3.56073420261e-15 , 6.51310123518e-17 , 0, 0, 0, 0, 0, 0,
 0, 0, 0, 3.05962653344e-25 , 1.70129324469e-23 , 6.62607989716e-22 ,
 2.0272432644e-20  , 5.01064731448e-19 , 9.89141195005e-18 , 1.6246109582e-16  ,
 2.34055545459e-15 , 3.13900640174e-14 , 3.99997827444e-13 , 4.65077481927e-12 ,
 4.6341930935e-11  , 3.77794914566e-10 , 2.45809173906e-09 , 1.26222503226e-08 ,
 5.09300962217e-08 , 1.6131770843e-07  , 4.01942082629e-07 , 7.98815676183e-07 ,
 1.37700020913e-06 , 2.91975771143e-06 , 1.09471278215e-05 , 4.96316422937e-05 ,
 0.000193045802885 , 0.000594179499568 , 0.00142870731443  , 0.00267923708614  ,
 0.00392112686691  , 0.00449956322907  , 0.00416002615504  , 0.00358779544704  ,
 0.00446341391937  , 0.00921923256393  , 0.0202697365334   , 0.037935961792    ,
 0.0581585780248   , 0.0738192564484   , 0.0807934392458   , 0.0821545128008   ,
 0.0836440814741   , 0.0853684730999   , 0.081384610966    , 0.067778954961    ,
 0.0478937136767   , 0.0288462283675   , 0.0154215753696   , 0.00808144040607  ,
 0.00485626160386  , 0.00375429353171  , 0.00391679047019  , 0.00549276091214  ,
 0.0086556117638   , 0.0125105537505   , 0.0151626367771   , 0.015503837663    ,
 0.0151813481313   , 0.0183955952938   , 0.0289728502115   , 0.0466166514526   ,
 0.0656146087692   , 0.0780378882867   , 0.0789614197876   , 0.0687811611682   ,
 0.0516814579644   , 0.033129241464    , 0.0177845121806   , 0.00784781337424  ,
 0.00280543107068  , 0.000804310879617 , 0.000183712612954 , 3.32817505656e-05 ,
 4.76688303636e-06 , 5.38447965437e-07 , 4.78674990778e-08 , 3.34319324443e-09 ,
 1.83166472678e-10 , 7.86188258202e-12 , 2.64063001906e-13 , 6.93455360876e-15 ,
 1.36433055787e-16 , 3.6970259081e-24  , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 6.6171292518e-27  , 3.21783705482e-25 , 1.21063128105e-23 ,
 3.54979162055e-22 , 8.11379771937e-21 , 1.4460593228e-19  , 2.01014533718e-18 ,
 2.18032865462e-17 , 1.8462289372e-16  , 1.22119266466e-15 , 6.31710447643e-15 ,
 2.56711467307e-14 , 8.56030166297e-14 , 3.37016108564e-13 , 3.48611862193e-12 ,
 5.54850981629e-11 , 7.59334849675e-10 , 8.17366626223e-09 , 6.87087671641e-08 ,
 4.52157850373e-07 , 2.3511848952e-06  , 9.92333698237e-06 , 3.64028086472e-05 ,
 0.00013135781751  , 0.000510876668484 , 0.00201743310488  , 0.00715039988467  ,
 0.0211103341453   , 0.0505889626434   , 0.098360672646    , 0.157637445854    ,
 0.215127588738    , 0.262527159774    , 0.301352766325    , 0.333042840231    ,
 0.348988012034    , 0.336067651552    , 0.290627856287    , 0.223426137389    ,
 0.151959152587    , 0.0907579087175   , 0.0472626138581   , 0.022094304298    ,
 0.0111254022656   , 0.00839217338113  , 0.00865510286892  , 0.00873553530495  ,
 0.00781875853449  , 0.00704202966697  , 0.00855375170471  , 0.0142107243589   ,
 0.0238437814101   , 0.0338776995281   , 0.0360745317551   , 0.0327906445554   ,
 0.0234516005813   , 0.0131960669557   , 0.00584805186359  , 0.00204374186225  ,
 0.000563927562568 , 0.000122982030059 , 2.12112645907e-05 , 2.89395875834e-06 ,
 3.12254008832e-07 , 2.66261991341e-08 , 1.79238732704e-09 , 9.5126305402e-11  ,
 3.97448147963e-12 , 1.30534162572e-13 , 3.36519435369e-15 , 6.15543038443e-17 ,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.31375862726e-26 , 7.28783047663e-25 ,
 2.83681890246e-23 , 8.67345503398e-22 , 2.2079426405e-20  , 4.54538952699e-19 ,
 8.13900819465e-18 , 1.35180320927e-16 , 2.14676914673e-15 , 3.14674294979e-14 ,
 3.98739965511e-13 , 4.15095855929e-12 , 3.45331700007e-11 , 2.26732974171e-10 ,
 1.16912895834e-09 , 4.73180493595e-09 , 1.51382542565e-08 , 4.0180627029e-08  ,
 1.13438421136e-07 , 5.48832646918e-07 , 3.79051751513e-06 , 2.39495935079e-05 ,
 0.000121071506092 , 0.000478861083878 , 0.00147697969731  , 0.00355118168755  ,
 0.006657197303    , 0.00973911195127  , 0.0111654939251   , 0.0102623336668   ,
 0.00851893528076  , 0.00939209122577  , 0.0172809079396   , 0.0358402381717   ,
 0.0646444903551   , 0.0959818868713   , 0.117543653779    , 0.122290277938    ,
 0.115365892281    , 0.107842392603    , 0.103952462596    , 0.0980841094133   ,
 0.0839147459329   , 0.0623648579528   , 0.039976758839    , 0.0226813145189   ,
 0.0122992244328   , 0.00722161071151  , 0.00489469736693  , 0.0037110205946   ,
 0.00332145494618  , 0.00381786220627  , 0.00488056457631  , 0.00571513137265  ,
 0.00581508345434  , 0.00577766080334  , 0.00728219468521  , 0.0120762159581   ,
 0.020635376362    , 0.0314720187831   , 0.0415826444261   , 0.0475397638176   ,
 0.046732120503    , 0.0388739170183   , 0.0268387423308   , 0.0151226323849   ,
 0.0068708954094   , 0.00249747171174  , 0.000722606244926 , 0.000165860621859 ,
 3.01247850259e-05 , 4.32041521271e-06 , 4.88343822635e-07 , 4.34278943255e-08 ,
 3.03362809637e-09 , 1.6622001685e-10  , 7.13491096131e-12 , 2.39772499193e-13 ,
 6.4031336023e-15  , 2.01870445458e-16 , 4.36392975715e-17 , 1.91886427643e-17 ,
 6.64529526776e-18 , 1.81513720676e-18 , 3.9154075224e-19  , 6.67631572145e-20 ,
 9.00402789463e-21 , 9.6055754226e-22  , 8.10282191847e-23 , 5.40042045144e-24 ,
 2.84053728484e-25 , 1.17749699042e-26 , 3.84116910516e-28 , 9.84617902538e-30 ,
 1.75838924224e-31 , 0, 0, 0, 0, 0, 1.93690126243e-25 , 9.41893745246e-24 ,
 3.54364130935e-22 , 1.03906023436e-20 , 2.37499139698e-19 , 4.23276321392e-18 ,
 5.88390054521e-17 , 6.38204448324e-16 , 5.40410051415e-15 , 3.57455555701e-14 ,
 1.84843901592e-13 , 7.48323622157e-13 , 2.38942904219e-12 , 6.46561681704e-12 ,
 2.46258365941e-11 , 2.50629872367e-10 , 3.24121220604e-09 , 3.46904411571e-08 ,
 2.90983767706e-07 , 1.90520465253e-06 , 9.76016754208e-06 , 3.94486626459e-05 ,
 0.000128935559197 , 0.000363871308945 , 0.00100619284773  , 0.00303024859604  ,
 0.00942964615507  , 0.0266183071307   , 0.0629348460649   , 0.12146056989     ,
 0.191923346107    , 0.253755791491    , 0.291919539867    , 0.307130063107    ,
 0.307279631034    , 0.294127436702    , 0.263913117526    , 0.217176754162    ,
 0.162093546409    , 0.109104564512    , 0.0657936140685   , 0.0360069626851   ,
 0.0203376975142   , 0.0162998031292   , 0.0190195722665   , 0.0228204845066   ,
 0.0234216793325   , 0.0198664247261   , 0.0146597133541   , 0.011820237954    ,
 0.014331673224    , 0.0221499928718   , 0.0313733779432   , 0.0269010340921   ,
 0.0244219245385   , 0.0174722974255   , 0.00983529118581  , 0.00435973644095  ,
 0.00152382829186  , 0.000420500962759 , 9.17072430419e-05 , 1.58175198442e-05 ,
 2.15808928218e-06 , 2.32856226507e-07 , 1.98559397706e-08 , 1.3366382216e-09  ,
 7.09386659446e-11 , 2.96389666552e-12 , 9.73434979726e-14 , 2.50953300876e-15 ,
 4.59030121572e-17 , 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.41403381111e-28 ,
 2.44394359084e-26 , 9.50884088407e-25 , 2.90572804271e-23 , 7.86645440377e-22 ,
 1.75150641478e-20 , 3.58974789023e-19 , 7.06496107194e-18 , 1.29970923044e-16 ,
 2.08966925028e-15 , 2.77598948698e-14 , 2.9533334139e-13  , 2.48091366583e-12 ,
 1.63688325051e-11 , 8.4993403813e-11  , 3.56763820582e-10 , 1.4219265142e-09  ,
 8.63871473154e-09 , 8.67002739507e-08 , 8.78541455322e-07 , 7.26707184609e-06 ,
 4.71947489853e-05 , 0.000239214122267 , 0.000945433600401 , 0.0029131242657   ,
 0.00699821304444  , 0.0131105438341   , 0.0191718182502   , 0.0219752331367   ,
 0.0201671934062   , 0.016456013383    , 0.0168000187004   , 0.0278353683503   ,
 0.0538182462453   , 0.0923909275594   , 0.131570326134    , 0.154624620957    ,
 0.153094490374    , 0.135002962091    , 0.116758720066    , 0.107057638232    ,
 0.101398068827    , 0.0909743931556   , 0.0728912614741   , 0.0516100317285   ,
 0.0336517924237   , 0.0222783255656   , 0.016251352324    , 0.0124323488325   ,
 0.008892141934    , 0.00566460601464  , 0.00345142574116  , 0.0023970021763   ,
 0.0020208258999   , 0.00182619281208  , 0.00178028599484  , 0.00235211235963  ,
 0.00423470658479  , 0.00798832340988  , 0.0136923778929   , 0.0205090811327   ,
 0.0263276649718   , 0.0283700368933   , 0.0251613179463   , 0.0180927993769   ,
 0.0104443912468   , 0.00481122770174  , 0.00176218195654  , 0.000511963074866 ,
 0.000117768386997 , 2.14144281481e-05 , 3.0730314853e-06  , 3.47458830245e-07 ,
 3.09044440077e-08 , 2.15903632446e-09 , 1.18311312534e-10 , 5.08391535078e-12 ,
 1.76792072717e-13 , 1.01038710005e-14 , 4.09210943821e-15 , 2.2387242