from __future__ import absolute_import, division, print_function
from libtbx import test_utils
import sys
from iotbx.pdb import secondary_structure as ss
import iotbx
from scitbx.array_family import flex
from mmtbx.secondary_structure import sec_str_master_phil

pdb_1ywf_cutted = """\
HELIX    1   1 ALA A   16  THR A   18  5                                   3
CRYST1  113.068  113.068   53.292  90.00  90.00  90.00 I 41          8
ATOM    104  N  BALA A  16      18.311  43.243  12.339  1.00 24.05           N
ATOM    105  CA BALA A  16      18.235  41.899  12.944  1.00 25.81           C
ATOM    106  C  BALA A  16      16.917  41.185  12.596  1.00 27.13           C
ATOM    107  O  BALA A  16      16.831  39.985  12.735  1.00 27.81           O
ATOM    108  CB BALA A  16      18.382  42.023  14.447  1.00 26.22           C
ATOM    109  N  BASP A  17      15.907  41.918  12.128  1.00 27.98           N
ATOM    110  CA BASP A  17      14.682  41.273  11.658  1.00 28.73           C
ATOM    111  C  BASP A  17      15.004  40.350  10.493  1.00 29.07           C
ATOM    112  O  BASP A  17      14.352  39.344  10.313  1.00 30.53           O
ATOM    113  CB BASP A  17      13.612  42.270  11.216  1.00 29.29           C
ATOM    114  CG BASP A  17      13.134  43.191  12.318  1.00 33.79           C
ATOM    115  OD1BASP A  17      13.364  42.935  13.534  1.00 36.75           O
ATOM    116  OD2BASP A  17      12.543  44.276  12.027  1.00 39.54           O
ATOM    117  N  BTHR A  18      16.026  40.674   9.718  1.00 28.45           N
ATOM    118  CA BTHR A  18      16.424  39.884   8.579  1.00 27.82           C
ATOM    119  C  BTHR A  18      17.641  39.035   8.906  1.00 28.55           C
ATOM    120  O  BTHR A  18      17.622  37.801   8.712  1.00 28.77           O
ATOM    121  CB BTHR A  18      16.662  40.804   7.377  1.00 27.83           C
ATOM    122  OG1BTHR A  18      15.427  41.485   7.071  1.00 26.22           O
ATOM    123  CG2BTHR A  18      16.991  40.012   6.126  1.00 28.79           C
"""

pdb_1ywf_sample_strings = """\
HELIX    1   1 ALA A   16  THR A   18  5                                   3
HELIX    2   2 ASP A   37  GLY A   48  1                                  12
HELIX    3   3 SER A   57  GLY A   65  1                                   9
HELIX    4   4 ASN A  119  PHE A  133  1                                  15
HELIX    5   5 PRO A  134  ARG A  136  5                                   3
HELIX    6   6 GLY A  138  ALA A  152  1                                  15
HELIX    7   7 ASP A  165  VAL A  178  1                                  14
HELIX    8   8 ASP A  181  ARG A  191  1                                  11
HELIX    9   9 SER A  192  ASP A  194  5                                   3
HELIX   10  10 SER A  195  GLN A  209  1                                  15
HELIX   11  11 ALA A  216  ALA A  225  1                                  10
HELIX   12  12 SER A  228  GLY A  233  1                                   6
HELIX   13  13 ARG A  235  GLY A  251  1                                  17
HELIX   14  14 SER A  252  ALA A  260  1                                   9
HELIX   15  15 SER A  263  LEU A  275  1                                  13
SHEET    1   A 5 ARG A  13  ASP A  14  0
SHEET    2   A 5 LEU A  27  SER A  30 -1  O  ARG A  29   N  ARG A  13
SHEET    3   A 5 VAL A 156  HIS A 159  1  O  VAL A 156   N  PHE A  28
SHEET    4   A 5 ASP A  51  ASP A  54  1  N  ALA A  51   O  LEU A 157
SHEET    5   A 5 ASP A  74  LEU A  77  1  O  HIS A  74   N  VAL A  52
CRYST1  113.068  113.068   53.292  90.00  90.00  90.00 I 41          8
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.008844  0.000000  0.000000        0.00000
SCALE2      0.000000  0.008844  0.000000        0.00000
SCALE3      0.000000  0.000000  0.018765        0.00000
ATOM      1  N   ARG A   4       7.511  46.981  14.258  1.00 46.91           N
ATOM      2  CA  ARG A   4       7.057  47.032  12.837  1.00 47.14           C
ATOM      3  C   ARG A   4       7.149  48.454  12.261  1.00 44.77           C
ATOM      4  O   ARG A   4       7.798  48.643  11.247  1.00 45.20           O
ATOM      5  CB  ARG A   4       5.613  46.509  12.682  1.00 47.77           C
ATOM      6  CG  ARG A   4       5.282  45.235  13.472  1.00 52.79           C
ATOM      7  CD  ARG A   4       4.921  43.958  12.663  1.00 58.16           C
ATOM      8  NE  ARG A   4       4.877  44.193  11.216  1.00 63.64           N
ATOM      9  CZ  ARG A   4       5.947  44.408  10.439  1.00 67.41           C
ATOM     10  NH1 ARG A   4       7.176  44.420  10.954  1.00 68.79           N
ATOM     11  NH2 ARG A   4       5.785  44.627   9.133  1.00 68.95           N
ATOM     12  N   GLU A   5       6.489  49.425  12.914  1.00 42.64           N
ATOM     13  CA  GLU A   5       6.285  50.786  12.396  1.00 40.70           C
ATOM     14  C   GLU A   5       7.010  51.885  13.188  1.00 37.71           C
ATOM     15  O   GLU A   5       7.249  51.776  14.392  1.00 37.47           O
ATOM     16  CB  GLU A   5       4.775  51.134  12.383  1.00 41.69           C
ATOM     17  CG  GLU A   5       3.932  50.296  11.422  1.00 44.73           C
ATOM     18  CD  GLU A   5       4.140  50.666   9.954  1.00 49.40           C
ATOM     19  OE1 GLU A   5       4.507  51.827   9.648  1.00 50.99           O
ATOM     20  OE2 GLU A   5       3.938  49.789   9.079  1.00 54.37           O
ATOM     21  N   LEU A   6       7.297  52.974  12.490  1.00 34.71           N
ATOM     22  CA  LEU A   6       7.928  54.158  13.057  1.00 32.83           C
ATOM     23  C   LEU A   6       7.124  55.354  12.548  1.00 32.42           C
ATOM     24  O   LEU A   6       7.421  55.925  11.503  1.00 31.01           O
ATOM     25  CB  LEU A   6       9.391  54.265  12.608  1.00 32.60           C
ATOM     26  CG  LEU A   6      10.179  55.463  13.111  1.00 30.47           C
ATOM     27  CD1 LEU A   6      10.149  55.453  14.651  1.00 33.03           C
ATOM     28  CD2 LEU A   6      11.634  55.474  12.576  1.00 30.34           C
ATOM     29  N   PRO A   7       6.021  55.686  13.228  1.00 31.97           N
ATOM     30  CA  PRO A   7       5.071  56.656  12.662  1.00 31.54           C
ATOM     31  C   PRO A   7       5.654  58.019  12.286  1.00 29.40           C
ATOM     32  O   PRO A   7       6.359  58.672  13.062  1.00 31.00           O
ATOM     33  CB  PRO A   7       3.963  56.730  13.741  1.00 31.52           C
ATOM     34  CG  PRO A   7       4.012  55.430  14.379  1.00 32.79           C
ATOM     35  CD  PRO A   7       5.514  55.095  14.483  1.00 32.60           C
ATOM     36  N   GLY A   8       5.386  58.417  11.036  1.00 28.81           N
ATOM     37  CA  GLY A   8       5.916  59.617  10.412  1.00 28.14           C
ATOM     38  C   GLY A   8       7.143  59.366   9.540  1.00 26.94           C
ATOM     39  O   GLY A   8       7.557  60.229   8.751  1.00 26.16           O
ATOM     40  N   ALA A   9       7.683  58.159   9.650  1.00 26.13           N
ATOM     41  CA  ALA A   9       8.750  57.696   8.757  1.00 25.16           C
ATOM     42  C   ALA A   9       8.313  56.419   8.034  1.00 25.14           C
ATOM     43  O   ALA A   9       7.221  55.876   8.276  1.00 25.57           O
ATOM     44  CB  ALA A   9      10.038  57.470   9.546  1.00 25.41           C
ATOM     45  N   TRP A  10       9.132  55.968   7.091  1.00 24.79           N
ATOM     46  CA  TRP A  10       8.801  54.772   6.341  1.00 23.84           C
ATOM     47  C   TRP A  10      10.106  53.977   6.084  1.00 23.68           C
ATOM     48  O   TRP A  10      11.196  54.413   6.461  1.00 21.87           O
ATOM     49  CB  TRP A  10       8.093  55.130   5.023  1.00 23.84           C
ATOM     50  CG  TRP A  10       8.914  55.811   3.994  1.00 21.18           C
ATOM     51  CD1 TRP A  10       9.502  55.245   2.912  1.00 23.12           C
ATOM     52  CD2 TRP A  10       9.276  57.199   3.966  1.00 23.18           C
ATOM     53  NE1 TRP A  10      10.195  56.191   2.193  1.00 23.94           N
ATOM     54  CE2 TRP A  10      10.049  57.406   2.829  1.00 24.73           C
ATOM     55  CE3 TRP A  10       8.976  58.314   4.790  1.00 25.02           C
ATOM     56  CZ2 TRP A  10      10.585  58.649   2.506  1.00 24.98           C
ATOM     57  CZ3 TRP A  10       9.511  59.554   4.437  1.00 24.23           C
ATOM     58  CH2 TRP A  10      10.275  59.704   3.315  1.00 23.25           C
ATOM     59  N   ASN A  11       9.963  52.795   5.522  1.00 22.49           N
ATOM     60  CA  ASN A  11      11.136  51.943   5.206  1.00 21.75           C
ATOM     61  C   ASN A  11      11.981  51.670   6.455  1.00 20.98           C
ATOM     62  O   ASN A  11      13.206  51.602   6.401  1.00 21.93           O
ATOM     63  CB  ASN A  11      11.972  52.553   4.061  1.00 21.22           C
ATOM     64  CG  ASN A  11      12.899  51.561   3.394  1.00 20.64           C
ATOM     65  OD1 ASN A  11      12.644  50.355   3.401  1.00 19.60           O
ATOM     66  ND2 ASN A  11      13.963  52.067   2.780  1.00 21.26           N
ATOM     67  N   PHE A  12      11.309  51.467   7.570  1.00 21.68           N
ATOM     68  CA  PHE A  12      11.948  51.243   8.862  1.00 21.29           C
ATOM     69  C   PHE A  12      12.048  49.773   9.242  1.00 20.70           C
ATOM     70  O   PHE A  12      11.089  49.016   9.167  1.00 22.11           O
ATOM     71  CB  PHE A  12      11.184  52.004   9.960  1.00 22.35           C
ATOM     72  CG  PHE A  12      11.502  51.541  11.339  1.00 22.18           C
ATOM     73  CD1 PHE A  12      12.682  51.926  11.981  1.00 23.77           C
ATOM     74  CD2 PHE A  12      10.635  50.684  11.993  1.00 26.59           C
ATOM     75  CE1 PHE A  12      12.979  51.476  13.266  1.00 27.16           C
ATOM     76  CE2 PHE A  12      10.943  50.211  13.279  1.00 28.73           C
ATOM     77  CZ  PHE A  12      12.117  50.615  13.900  1.00 27.68           C
ATOM     78  N   ARG A  13      13.212  49.360   9.695  1.00 20.61           N
ATOM     79  CA  ARG A  13      13.382  48.025  10.237  1.00 21.15           C
ATOM     80  C   ARG A  13      14.617  47.938  11.086  1.00 21.28           C
ATOM     81  O   ARG A  13      15.544  48.703  10.936  1.00 21.58           O
ATOM     82  CB  ARG A  13      13.493  46.957   9.140  1.00 21.46           C
ATOM     83  CG  ARG A  13      14.538  47.243   8.071  1.00 21.12           C
ATOM     84  CD  ARG A  13      14.365  46.347   6.849  1.00 20.85           C
ATOM     85  NE  ARG A  13      15.257  46.627   5.739  1.00 20.56           N
ATOM     86  CZ  ARG A  13      15.050  47.554   4.796  1.00 18.84           C
ATOM     87  NH1 ARG A  13      15.935  47.721   3.856  1.00 20.00           N
ATOM     88  NH2 ARG A  13      14.005  48.326   4.841  1.00 21.30           N
ATOM     89  N   ASP A  14      14.584  46.992  12.022  1.00 22.41           N
ATOM     90  CA  ASP A  14      15.779  46.502  12.667  1.00 22.53           C
ATOM     91  C   ASP A  14      16.467  45.565  11.655  1.00 22.55           C
ATOM     92  O   ASP A  14      15.847  44.680  11.057  1.00 22.99           O
ATOM     93  CB  ASP A  14      15.347  45.751  13.910  1.00 24.13           C
ATOM     94  CG  ASP A  14      16.488  45.299  14.788  1.00 28.19           C
ATOM     95  OD1 ASP A  14      17.648  45.153  14.351  1.00 23.57           O
ATOM     96  OD2 ASP A  14      16.231  45.009  15.975  1.00 31.43           O
ATOM     97  N   VAL A  15      17.761  45.694  11.515  1.00 22.86           N
ATOM     98  CA  VAL A  15      18.479  44.862  10.563  1.00 24.05           C
ATOM     99  C   VAL A  15      18.433  43.426  11.022  1.00 24.50           C
ATOM    100  O   VAL A  15      18.482  42.511  10.224  1.00 22.99           O
ATOM    101  CB  VAL A  15      19.905  45.408  10.297  1.00 24.79           C
ATOM    102  CG1 VAL A  15      20.638  44.504   9.380  1.00 27.38           C
ATOM    103  CG2 VAL A  15      19.790  46.809   9.678  1.00 24.62           C
ATOM    104  N   ALA A  16      18.311  43.243  12.339  1.00 24.05           N
ATOM    105  CA  ALA A  16      18.235  41.899  12.944  1.00 25.81           C
ATOM    106  C   ALA A  16      16.917  41.185  12.596  1.00 27.13           C
ATOM    107  O   ALA A  16      16.831  39.985  12.735  1.00 27.81           O
ATOM    108  CB  ALA A  16      18.382  42.023  14.447  1.00 26.22           C
ATOM    109  N   ASP A  17      15.907  41.918  12.128  1.00 27.98           N
ATOM    110  CA  ASP A  17      14.682  41.273  11.658  1.00 28.73           C
ATOM    111  C   ASP A  17      15.004  40.350  10.493  1.00 29.07           C
ATOM    112  O   ASP A  17      14.352  39.344  10.313  1.00 30.53           O
ATOM    113  CB  ASP A  17      13.612  42.270  11.216  1.00 29.29           C
ATOM    114  CG  ASP A  17      13.134  43.191  12.318  1.00 33.79           C
ATOM    115  OD1 ASP A  17      13.364  42.935  13.534  1.00 36.75           O
ATOM    116  OD2 ASP A  17      12.543  44.276  12.027  1.00 39.54           O
ATOM    117  N   THR A  18      16.026  40.674   9.718  1.00 28.45           N
ATOM    118  CA  THR A  18      16.424  39.884   8.579  1.00 27.82           C
ATOM    119  C   THR A  18      17.641  39.035   8.906  1.00 28.55           C
ATOM    120  O   THR A  18      17.622  37.801   8.712  1.00 28.77           O
ATOM    121  CB  THR A  18      16.662  40.804   7.377  1.00 27.83           C
ATOM    122  OG1 THR A  18      15.427  41.485   7.071  1.00 26.22           O
ATOM    123  CG2 THR A  18      16.991  40.012   6.126  1.00 28.79           C
ATOM    124  N   ALA A  19      18.691  39.684   9.412  1.00 27.94           N
ATOM    125  CA  ALA A  19      19.966  39.033   9.715  1.00 28.40           C
ATOM    126  C   ALA A  19      19.838  38.519  11.116  1.00 29.58           C
ATOM    127  O   ALA A  19      20.212  39.211  12.059  1.00 29.94           O
ATOM    128  CB  ALA A  19      21.085  40.016   9.634  1.00 28.29           C
ATOM    129  N   THR A  20      19.337  37.305  11.238  1.00 30.82           N
ATOM    130  CA  THR A  20      18.941  36.786  12.519  1.00 33.20           C
ATOM    131  C   THR A  20      20.125  36.388  13.417  1.00 33.18           C
ATOM    132  O   THR A  20      19.927  36.094  14.588  1.00 34.30           O
ATOM    133  CB  THR A  20      17.950  35.631  12.357  1.00 33.49           C
ATOM    134  OG1 THR A  20      18.379  34.756  11.312  1.00 38.10           O
ATOM    135  CG2 THR A  20      16.602  36.169  11.911  1.00 35.29           C
ATOM    136  N   ALA A  21      21.338  36.419  12.894  1.00 33.33           N
ATOM    137  CA  ALA A  21      22.533  36.242  13.735  1.00 33.67           C
ATOM    138  C   ALA A  21      22.880  37.499  14.531  1.00 34.19           C
ATOM    139  O   ALA A  21      23.684  37.437  15.478  1.00 34.52           O
ATOM    140  CB  ALA A  21      23.713  35.807  12.896  1.00 33.55           C
ATOM    141  N   LEU A  22      22.312  38.647  14.151  1.00 32.65           N
ATOM    142  CA  LEU A  22      22.477  39.866  14.928  1.00 32.39           C
ATOM    143  C   LEU A  22      21.610  39.869  16.173  1.00 31.74           C
ATOM    144  O   LEU A  22      20.489  39.369  16.165  1.00 31.53           O
ATOM    145  CB  LEU A  22      22.101  41.111  14.119  1.00 31.77           C
ATOM    146  CG  LEU A  22      22.845  41.462  12.825  1.00 34.56           C
ATOM    147  CD1 LEU A  22      22.334  42.821  12.335  1.00 34.55           C
ATOM    148  CD2 LEU A  22      24.312  41.481  13.028  1.00 35.86           C
ATOM    149  N   ARG A  23      22.124  40.462  17.231  1.00 31.58           N
ATOM    150  CA  ARG A  23      21.329  40.846  18.373  1.00 32.81           C
ATOM    151  C   ARG A  23      20.327  41.908  17.930  1.00 32.72           C
ATOM    152  O   ARG A  23      20.713  42.871  17.284  1.00 31.45           O
ATOM    153  CB  ARG A  23      22.189  41.476  19.452  1.00 33.29           C
ATOM    154  CG  ARG A  23      23.022  40.485  20.263  1.00 38.29           C
ATOM    155  CD  ARG A  23      23.997  41.198  21.224  1.00 43.01           C
ATOM    156  NE  ARG A  23      23.270  42.014  22.197  1.00 48.08           N
ATOM    157  CZ  ARG A  23      23.703  43.150  22.759  1.00 51.77           C
ATOM    158  NH1 ARG A  23      24.897  43.684  22.460  1.00 51.92           N
ATOM    159  NH2 ARG A  23      22.923  43.771  23.640  1.00 53.88           N
ATOM    160  N   PRO A  24      19.065  41.741  18.302  1.00 33.30           N
ATOM    161  CA  PRO A  24      18.061  42.776  18.079  1.00 33.43           C
ATOM    162  C   PRO A  24      18.325  44.038  18.886  1.00 33.05           C
ATOM    163  O   PRO A  24      18.981  44.006  19.927  1.00 33.47           O
ATOM    164  CB  PRO A  24      16.753  42.107  18.507  1.00 33.79           C
ATOM    165  CG  PRO A  24      17.043  40.692  18.647  1.00 35.21           C
ATOM    166  CD  PRO A  24      18.499  40.540  18.945  1.00 33.65           C
ATOM    167  N   GLY A  25      17.848  45.165  18.370  1.00 32.33           N
ATOM    168  CA  GLY A  25      17.919  46.446  19.045  1.00 31.89           C
ATOM    169  C   GLY A  25      19.214  47.228  18.951  1.00 32.08           C
ATOM    170  O   GLY A  25      19.419  48.201  19.699  1.00 32.75           O
ATOM    171  N   ARG A  26      20.116  46.808  18.070  1.00 30.09           N
ATOM    172  CA  ARG A  26      21.431  47.446  17.922  1.00 30.48           C
ATOM    173  C   ARG A  26      21.540  48.359  16.680  1.00 28.67           C
ATOM    174  O   ARG A  26      22.088  49.468  16.758  1.00 29.16           O
ATOM    175  CB  ARG A  26      22.547  46.403  17.864  1.00 30.59           C
ATOM    176  CG  ARG A  26      22.543  45.313  18.945  1.00 35.33           C
ATOM    177  CD  ARG A  26      22.180  45.784  20.308  1.00 40.30           C
ATOM    178  NE  ARG A  26      23.179  46.725  20.737  1.00 44.93           N
ATOM    179  CZ  ARG A  26      23.130  47.423  21.855  1.00 47.75           C
ATOM    180  NH1 ARG A  26      22.100  47.310  22.694  1.00 45.88           N
ATOM    181  NH2 ARG A  26      24.125  48.256  22.122  1.00 48.65           N
ATOM    182  N   LEU A  27      21.047  47.872  15.539  1.00 26.64           N
ATOM    183  CA  LEU A  27      21.173  48.606  14.299  1.00 24.67           C
ATOM    184  C   LEU A  27      19.851  48.646  13.555  1.00 22.50           C
ATOM    185  O   LEU A  27      19.363  47.637  13.098  1.00 20.72           O
ATOM    186  CB  LEU A  27      22.205  47.944  13.390  1.00 24.59           C
ATOM    187  CG  LEU A  27      22.447  48.705  12.070  1.00 26.18           C
ATOM    188  CD1 LEU A  27      22.821  50.177  12.205  1.00 28.23           C
ATOM    189  CD2 LEU A  27      23.476  47.957  11.324  1.00 28.36           C
ATOM    190  N   PHE A  28      19.321  49.837  13.459  1.00 21.65           N
ATOM    191  CA  PHE A  28      18.080  50.106  12.807  1.00 21.14           C
ATOM    192  C   PHE A  28      18.390  50.998  11.603  1.00 19.54           C
ATOM    193  O   PHE A  28      19.449  51.628  11.522  1.00 21.04           O
ATOM    194  CB  PHE A  28      17.115  50.849  13.715  1.00 22.33           C
ATOM    195  CG  PHE A  28      16.729  50.090  14.988  1.00 24.51           C
ATOM    196  CD1 PHE A  28      15.580  49.350  15.037  1.00 25.75           C
ATOM    197  CD2 PHE A  28      17.516  50.181  16.131  1.00 27.07           C
ATOM    198  CE1 PHE A  28      15.203  48.693  16.204  1.00 27.03           C
ATOM    199  CE2 PHE A  28      17.118  49.532  17.321  1.00 28.58           C
ATOM    200  CZ  PHE A  28      15.980  48.781  17.324  1.00 26.62           C
ATOM    201  N   ARG A  29      17.401  51.061  10.730  1.00 20.38           N
ATOM    202  CA  ARG A  29      17.458  51.839   9.509  1.00 18.92           C
ATOM    203  C   ARG A  29      16.072  52.311   9.112  1.00 19.50           C
ATOM    204  O   ARG A  29      15.081  51.630   9.381  1.00 18.98           O
ATOM    205  CB  ARG A  29      18.053  50.976   8.382  1.00 18.31           C
ATOM    206  CG  ARG A  29      17.360  49.609   8.130  1.00 18.67           C
ATOM    207  CD  ARG A  29      17.993  48.792   7.009  1.00 18.80           C
ATOM    208  NE  ARG A  29      17.919  49.545   5.751  1.00 19.69           N
ATOM    209  CZ  ARG A  29      18.593  49.238   4.659  1.00 18.68           C
ATOM    210  NH1 ARG A  29      19.319  48.157   4.587  1.00 18.27           N
ATOM    211  NH2 ARG A  29      18.509  50.025   3.602  1.00 19.30           N
ATOM    212  N   SER A  30      16.040  53.447   8.419  1.00 18.99           N
ATOM    213  CA  SER A  30      14.786  54.030   7.992  1.00 18.63           C
ATOM    214  C   SER A  30      14.986  55.127   6.973  1.00 18.35           C
ATOM    215  O   SER A  30      16.097  55.505   6.601  1.00 18.52           O
ATOM    216  CB  SER A  30      14.005  54.576   9.188  1.00 18.02           C
ATOM    217  OG  SER A  30      14.595  55.788   9.620  1.00 21.28           O
ATOM    218  N   SER A  31      13.850  55.649   6.527  1.00 20.12           N
ATOM    219  CA  SER A  31      13.777  56.923   5.846  1.00 20.18           C
ATOM    220  C   SER A  31      14.173  58.059   6.785  1.00 20.70           C
ATOM    221  O   SER A  31      14.397  57.854   7.962  1.00 21.17           O
ATOM    222  CB  SER A  31      12.359  57.191   5.404  1.00 19.82           C
ATOM    223  OG  SER A  31      11.567  57.454   6.525  1.00 23.02           O
ATOM    224  N   GLU A  32      14.189  59.256   6.248  1.00 22.11           N
ATOM    225  CA  GLU A  32      14.327  60.411   7.092  1.00 23.25           C
ATOM    226  C   GLU A  32      13.234  60.477   8.172  1.00 23.89           C
ATOM    227  O   GLU A  32      12.142  59.891   8.077  1.00 23.70           O
ATOM    228  CB  GLU A  32      14.393  61.687   6.242  1.00 22.80           C
ATOM    229  CG  GLU A  32      13.055  62.081   5.646  1.00 23.93           C
ATOM    230  CD  GLU A  32      13.040  63.456   4.986  1.00 26.07           C
ATOM    231  OE1 GLU A  32      14.090  64.034   4.724  1.00 25.53           O
ATOM    232  OE2 GLU A  32      11.917  63.948   4.713  1.00 26.61           O
ATOM    233  N   LEU A  33      13.577  61.255   9.187  1.00 24.71           N
ATOM    234  CA  LEU A  33      12.824  61.371  10.405  1.00 25.72           C
ATOM    235  C   LEU A  33      12.233  62.784  10.547  1.00 27.12           C
ATOM    236  O   LEU A  33      11.744  63.118  11.610  1.00 28.65           O
ATOM    237  CB  LEU A  33      13.743  61.092  11.574  1.00 25.40           C
ATOM    238  CG  LEU A  33      14.424  59.708  11.631  1.00 26.74           C
ATOM    239  CD1 LEU A  33      15.233  59.603  12.933  1.00 26.02           C
ATOM    240  CD2 LEU A  33      13.437  58.617  11.584  1.00 24.98           C
ATOM    241  N   SER A  34      12.238  63.550   9.461  1.00 28.04           N
ATOM    242  CA  SER A  34      11.816  64.963   9.494  1.00 28.62           C
ATOM    243  C   SER A  34      10.312  65.161   9.737  1.00 29.69           C
ATOM    244  O   SER A  34       9.883  66.307   9.960  1.00 30.38           O
ATOM    245  CB  SER A  34      12.220  65.667   8.209  1.00 27.82           C
ATOM    246  OG  SER A  34      13.644  65.671   8.138  1.00 30.07           O
ATOM    247  N   ARG A  35       9.530  64.077   9.711  1.00 29.16           N
ATOM    248  CA  ARG A  35       8.089  64.157   9.959  1.00 29.52           C
ATOM    249  C   ARG A  35       7.657  63.114  10.970  1.00 30.36           C
ATOM    250  O   ARG A  35       6.482  62.735  11.053  1.00 29.10           O
ATOM    251  CB  ARG A  35       7.314  64.072   8.658  1.00 29.70           C
ATOM    252  CG  ARG A  35       7.575  65.241   7.715  1.00 28.95           C
ATOM    253  CD  ARG A  35       7.045  66.636   8.178  1.00 32.14           C
ATOM    254  NE  ARG A  35       7.247  67.693   7.177  1.00 32.59           N
ATOM    255  CZ  ARG A  35       8.401  68.327   6.980  1.00 31.73           C
ATOM    256  NH1 ARG A  35       9.466  68.046   7.736  1.00 32.13           N
ATOM    257  NH2 ARG A  35       8.499  69.290   6.075  1.00 33.77           N
ATOM    258  N   LEU A  36       8.623  62.655  11.750  1.00 30.18           N
ATOM    259  CA  LEU A  36       8.314  61.788  12.854  1.00 32.34           C
ATOM    260  C   LEU A  36       7.243  62.506  13.664  1.00 33.27           C
ATOM    261  O   LEU A  36       7.333  63.729  13.859  1.00 32.39           O
ATOM    262  CB  LEU A  36       9.554  61.594  13.717  1.00 32.54           C
ATOM    263  CG  LEU A  36       9.679  60.254  14.430  1.00 35.29           C
ATOM    264  CD1 LEU A  36       9.649  59.058  13.444  1.00 33.08           C
ATOM    265  CD2 LEU A  36      10.910  60.175  15.369  1.00 35.73           C
ATOM    266  N   ASP A  37       6.265  61.752  14.145  1.00 35.17           N
ATOM    267  CA  ASP A  37       5.251  62.335  15.056  1.00 37.08           C
ATOM    268  C   ASP A  37       5.433  61.900  16.511  1.00 37.79           C
ATOM    269  O   ASP A  37       6.443  61.316  16.858  1.00 37.54           O
ATOM    270  CB  ASP A  37       3.827  62.120  14.521  1.00 37.53           C
ATOM    271  CG  ASP A  37       3.427  60.683  14.400  1.00 38.76           C
ATOM    272  OD1 ASP A  37       4.001  59.819  15.070  1.00 38.84           O
ATOM    273  OD2 ASP A  37       2.506  60.327  13.624  1.00 41.78           O
ATOM    274  N   ASP A  38       4.467  62.205  17.382  1.00 38.31           N
ATOM    275  CA  ASP A  38       4.609  61.829  18.786  1.00 38.69           C
ATOM    276  C   ASP A  38       4.781  60.335  18.955  1.00 37.78           C
ATOM    277  O   ASP A  38       5.598  59.886  19.760  1.00 38.31           O
ATOM    278  CB  ASP A  38       3.376  62.258  19.608  1.00 39.51           C
ATOM    279  CG  ASP A  38       3.378  63.724  19.972  1.00 42.76           C
ATOM    280  OD1 ASP A  38       4.462  64.343  20.161  1.00 48.07           O
ATOM    281  OD2 ASP A  38       2.295  64.337  20.144  1.00 47.65           O
ATOM    282  N   ALA A  39       4.003  59.561  18.209  1.00 36.68           N
ATOM    283  CA  ALA A  39       4.065  58.107  18.287  1.00 36.58           C
ATOM    284  C   ALA A  39       5.433  57.607  17.773  1.00 35.91           C
ATOM    285  O   ALA A  39       6.014  56.661  18.319  1.00 35.28           O
ATOM    286  CB  ALA A  39       2.947  57.491  17.483  1.00 36.33           C
ATOM    287  N   GLY A  40       5.948  58.257  16.745  1.00 35.33           N
ATOM    288  CA  GLY A  40       7.296  57.938  16.267  1.00 35.20           C
ATOM    289  C   GLY A  40       8.386  58.218  17.295  1.00 34.81           C
ATOM    290  O   GLY A  40       9.320  57.432  17.456  1.00 34.92           O
ATOM    291  N   ARG A  41       8.297  59.351  17.981  1.00 35.65           N
ATOM    292  CA  ARG A  41       9.300  59.698  18.970  1.00 35.75           C
ATOM    293  C   ARG A  41       9.257  58.681  20.093  1.00 37.10           C
ATOM    294  O   ARG A  41      10.295  58.291  20.642  1.00 37.65           O
ATOM    295  CB  ARG A  41       9.090  61.118  19.494  1.00 36.15           C
ATOM    296  CG  ARG A  41       9.575  62.196  18.563  1.00 35.51           C
ATOM    297  CD  ARG A  41       9.383  63.592  19.134  1.00 38.98           C
ATOM    298  NE  ARG A  41       7.999  64.012  18.913  1.00 40.46           N
ATOM    299  CZ  ARG A  41       7.537  64.446  17.753  1.00 41.44           C
ATOM    300  NH1 ARG A  41       8.326  64.534  16.682  1.00 42.62           N
ATOM    301  NH2 ARG A  41       6.261  64.776  17.649  1.00 43.05           N
ATOM    302  N   ALA A  42       8.053  58.238  20.441  1.00 38.18           N
ATOM    303  CA  ALA A  42       7.878  57.270  21.524  1.00 38.42           C
ATOM    304  C   ALA A  42       8.398  55.909  21.116  1.00 38.32           C
ATOM    305  O   ALA A  42       8.952  55.181  21.927  1.00 37.15           O
ATOM    306  CB  ALA A  42       6.387  57.158  21.948  1.00 38.91           C
ATOM    307  N   THR A  43       8.209  55.567  19.842  1.00 37.57           N
ATOM    308  CA  THR A  43       8.756  54.324  19.328  1.00 37.21           C
ATOM    309  C   THR A  43      10.284  54.321  19.472  1.00 36.33           C
ATOM    310  O   THR A  43      10.842  53.315  19.824  1.00 36.44           O
ATOM    311  CB  THR A  43       8.316  54.130  17.873  1.00 37.54           C
ATOM    312  OG1 THR A  43       6.890  53.948  17.829  1.00 38.41           O
ATOM    313  CG2 THR A  43       8.897  52.837  17.280  1.00 36.05           C
ATOM    314  N   LEU A  44      10.948  55.436  19.192  1.00 36.74           N
ATOM    315  CA  LEU A  44      12.410  55.504  19.283  1.00 36.66           C
ATOM    316  C   LEU A  44      12.877  55.316  20.729  1.00 37.24           C
ATOM    317  O   LEU A  44      13.840  54.613  20.978  1.00 36.26           O
ATOM    318  CB  LEU A  44      12.957  56.819  18.725  1.00 36.22           C
ATOM    319  CG  LEU A  44      12.786  57.061  17.209  1.00 34.97           C
ATOM    320  CD1 LEU A  44      13.386  58.400  16.795  1.00 33.89           C
ATOM    321  CD2 LEU A  44      13.399  55.928  16.404  1.00 33.15           C
ATOM    322  N   ARG A  45      12.147  55.914  21.675  1.00 38.31           N
ATOM    323  CA  ARG A  45      12.485  55.801  23.095  1.00 39.49           C
ATOM    324  C   ARG A  45      12.296  54.381  23.589  1.00 39.97           C
ATOM    325  O   ARG A  45      13.113  53.864  24.338  1.00 40.63           O
ATOM    326  CB  ARG A  45      11.614  56.757  23.935  1.00 39.94           C
ATOM    327  N   ARG A  46      11.186  53.775  23.179  1.00 41.00           N
ATOM    328  CA  ARG A  46      10.849  52.397  23.503  1.00 41.33           C
ATOM    329  C   ARG A  46      11.912  51.412  23.025  1.00 40.34           C
ATOM    330  O   ARG A  46      12.278  50.485  23.731  1.00 39.81           O
ATOM    331  CB  ARG A  46       9.524  52.063  22.835  1.00 41.72           C
ATOM    332  CG  ARG A  46       8.773  50.911  23.395  1.00 46.36           C
ATOM    333  CD  ARG A  46       7.352  50.836  22.851  1.00 51.59           C
ATOM    334  NE  ARG A  46       7.345  50.162  21.548  1.00 57.79           N
ATOM    335  CZ  ARG A  46       6.851  50.659  20.399  1.00 61.01           C
ATOM    336  NH1 ARG A  46       6.282  51.872  20.344  1.00 62.67           N
ATOM    337  NH2 ARG A  46       6.918  49.916  19.290  1.00 61.73           N
ATOM    338  N   LEU A  47      12.402  51.620  21.809  1.00 39.47           N
ATOM    339  CA  LEU A  47      13.439  50.765  21.223  1.00 38.25           C
ATOM    340  C   LEU A  47      14.826  51.006  21.800  1.00 37.39           C
ATOM    341  O   LEU A  47      15.742  50.247  21.530  1.00 38.19           O
ATOM    342  CB  LEU A  47      13.502  51.010  19.712  1.00 38.57           C
ATOM    343  CG  LEU A  47      12.264  50.556  18.951  1.00 38.58           C
ATOM    344  CD1 LEU A  47      12.346  51.046  17.517  1.00 38.92           C
ATOM    345  CD2 LEU A  47      12.101  49.038  19.050  1.00 38.51           C
ATOM    346  N   GLY A  48      14.997  52.083  22.557  1.00 36.96           N
ATOM    347  CA  GLY A  48      16.262  52.383  23.191  1.00 35.72           C
ATOM    348  C   GLY A  48      17.323  52.969  22.286  1.00 34.43           C
ATOM    349  O   GLY A  48      18.512  52.912  22.607  1.00 34.93           O
ATOM    350  N   ILE A  49      16.910  53.540  21.149  1.00 33.30           N
ATOM    351  CA  ILE A  49      17.849  54.176  20.252  1.00 31.75           C
ATOM    352  C   ILE A  49      18.393  55.461  20.882  1.00 31.44           C
ATOM    353  O   ILE A  49      17.614  56.332  21.269  1.00 31.61           O
ATOM    354  CB  ILE A  49      17.158  54.429  18.875  1.00 30.66           C
ATOM    355  CG1 ILE A  49      16.852  53.073  18.242  1.00 28.65           C
ATOM    356  CG2 ILE A  49      17.997  55.327  18.021  1.00 31.50           C
ATOM    357  CD1 ILE A  49      15.809  53.159  17.127  1.00 31.05           C
ATOM    358  N   THR A  50      19.713  55.583  20.950  1.00 31.26           N
ATOM    359  CA  THR A  50      20.380  56.742  21.535  1.00 31.21           C
ATOM    360  C   THR A  50      21.064  57.625  20.530  1.00 30.07           C
ATOM    361  O   THR A  50      21.440  58.769  20.840  1.00 30.33           O
ATOM    362  CB  THR A  50      21.414  56.290  22.600  1.00 31.56           C
ATOM    363  OG1 THR A  50      22.370  55.375  22.056  1.00 33.21           O
ATOM    364  CG2 THR A  50      20.716  55.533  23.751  1.00 34.53           C
ATOM    365  N   ASP A  51      21.266  57.099  19.322  1.00 28.35           N
ATOM    366  CA  ASP A  51      22.043  57.794  18.328  1.00 27.13           C
ATOM    367  C   ASP A  51      21.424  57.580  16.963  1.00 26.83           C
ATOM    368  O   ASP A  51      20.989  56.478  16.652  1.00 25.91           O
ATOM    369  CB  ASP A  51      23.477  57.294  18.331  1.00 27.73           C
ATOM    370  CG  ASP A  51      24.229  57.680  19.619  1.00 29.45           C
ATOM    371  OD1 ASP A  51      24.895  58.735  19.636  1.00 31.44           O
ATOM    372  OD2 ASP A  51      24.213  56.951  20.620  1.00 31.01           O
ATOM    373  N   VAL A  52      21.439  58.642  16.185  1.00 26.08           N
ATOM    374  CA  VAL A  52      20.957  58.631  14.813  1.00 25.97           C
ATOM    375  C   VAL A  52      22.071  59.134  13.909  1.00 25.23           C
ATOM    376  O   VAL A  52      22.754  60.157  14.173  1.00 25.88           O
ATOM    377  CB  VAL A  52      19.684  59.496  14.689  1.00 25.77           C
ATOM    378  CG1 VAL A  52      19.354  59.767  13.264  1.00 27.59           C
ATOM    379  CG2 VAL A  52      18.542  58.819  15.379  1.00 26.26           C
ATOM    380  N   ALA A  53      22.289  58.408  12.829  1.00 22.70           N
ATOM    381  CA  ALA A  53      23.212  58.809  11.824  1.00 22.61           C
ATOM    382  C   ALA A  53      22.408  59.327  10.642  1.00 23.54           C
ATOM    383  O   ALA A  53      21.761  58.525   9.925  1.00 22.31           O
ATOM    384  CB  ALA A  53      24.079  57.584  11.404  1.00 22.73           C
ATOM    385  N   ASP A  54      22.443  60.650  10.458  1.00 23.06           N
ATOM    386  CA  ASP A  54      21.694  61.362   9.404  1.00 23.07           C
ATOM    387  C   ASP A  54      22.618  61.648   8.212  1.00 22.64           C
ATOM    388  O   ASP A  54      23.448  62.564   8.223  1.00 22.25           O
ATOM    389  CB  ASP A  54      21.065  62.629  10.037  1.00 23.28           C
ATOM    390  CG  ASP A  54      20.191  63.401   9.090  1.00 25.43           C
ATOM    391  OD1 ASP A  54      20.219  63.079   7.889  1.00 21.64           O
ATOM    392  OD2 ASP A  54      19.459  64.367   9.484  1.00 25.19           O
ATOM    393  N   LEU A  55      22.488  60.806   7.190  1.00 20.56           N
ATOM    394  CA  LEU A  55      23.355  60.782   6.019  1.00 21.67           C
ATOM    395  C   LEU A  55      22.882  61.732   4.943  1.00 22.28           C
ATOM    396  O   LEU A  55      23.489  61.808   3.893  1.00 21.45           O
ATOM    397  CB  LEU A  55      23.383  59.371   5.387  1.00 21.25           C
ATOM    398  CG  LEU A  55      23.710  58.220   6.318  1.00 24.21           C
ATOM    399  CD1 LEU A  55      23.708  56.878   5.593  1.00 25.39           C
ATOM    400  CD2 LEU A  55      25.013  58.443   7.022  1.00 26.84           C
ATOM    401  N   ARG A  56      21.810  62.474   5.195  1.00 24.20           N
ATOM    402  CA  ARG A  56      21.311  63.404   4.188  1.00 23.52           C
ATOM    403  C   ARG A  56      22.318  64.514   3.869  1.00 25.73           C
ATOM    404  O   ARG A  56      23.088  64.949   4.725  1.00 26.08           O
ATOM    405  CB  ARG A  56      20.018  64.033   4.682  1.00 23.60           C
ATOM    406  CG  ARG A  56      18.883  63.017   4.851  1.00 23.34           C
ATOM    407  CD  ARG A  56      17.618  63.608   5.243  1.00 23.86           C
ATOM    408  NE  ARG A  56      17.753  64.162   6.572  1.00 25.03           N
ATOM    409  CZ  ARG A  56      16.948  65.079   7.082  1.00 29.81           C
ATOM    410  NH1 ARG A  56      15.895  65.511   6.391  1.00 29.64           N
ATOM    411  NH2 ARG A  56      17.195  65.549   8.292  1.00 27.24           N
ATOM    412  N   SER A  57      22.300  64.977   2.619  1.00 27.35           N
ATOM    413  CA  SER A  57      23.086  66.141   2.234  1.00 29.60           C
ATOM    414  C   SER A  57      22.610  67.383   2.972  1.00 30.93           C
ATOM    415  O   SER A  57      21.479  67.449   3.408  1.00 30.77           O
ATOM    416  CB  SER A  57      22.971  66.361   0.755  1.00 29.70           C
ATOM    417  OG  SER A  57      21.683  66.895   0.499  1.00 31.63           O
ATOM    418  N   SER A  58      23.460  68.400   3.136  1.00 31.90           N
ATOM    419  CA  SER A  58      22.973  69.538   3.892  1.00 33.34           C
ATOM    420  C   SER A  58      21.817  70.256   3.124  1.00 32.27           C
ATOM    421  O   SER A  58      20.982  70.832   3.761  1.00 33.41           O
ATOM    422  CB  SER A  58      24.081  70.510   4.256  1.00 33.62           C
ATOM    423  OG  SER A  58      24.494  71.159   3.091  1.00 36.70           O
ATOM    424  N   ARG A  59      21.763  70.201   1.796  1.00 33.11           N
ATOM    425  CA  ARG A  59      20.587  70.731   1.094  1.00 34.26           C
ATOM    426  C   ARG A  59      19.321  70.013   1.571  1.00 32.54           C
ATOM    427  O   ARG A  59      18.289  70.622   1.849  1.00 32.73           O
ATOM    428  CB  ARG A  59      20.606  70.454  -0.399  1.00 35.42           C
ATOM    429  CG  ARG A  59      21.645  71.025  -1.330  1.00 42.29           C
ATOM    430  CD  ARG A  59      21.079  71.165  -2.797  1.00 47.14           C
ATOM    431  NE  ARG A  59      21.416  70.140  -3.834  1.00 51.70           N
ATOM    432  CZ  ARG A  59      21.598  68.800  -3.690  1.00 52.67           C
ATOM    433  NH1 ARG A  59      21.537  68.174  -2.507  1.00 54.62           N
ATOM    434  NH2 ARG A  59      21.849  68.065  -4.783  1.00 51.94           N
ATOM    435  N   GLU A  60      19.384  68.685   1.628  1.00 30.35           N
ATOM    436  CA  GLU A  60      18.227  67.904   2.033  1.00 28.04           C
ATOM    437  C   GLU A  60      17.812  68.278   3.447  1.00 27.13           C
ATOM    438  O   GLU A  60      16.642  68.465   3.755  1.00 26.84           O
ATOM    439  CB  GLU A  60      18.531  66.387   1.959  1.00 27.27           C
ATOM    440  CG  GLU A  60      18.505  65.766   0.573  1.00 27.74           C
ATOM    441  CD  GLU A  60      18.993  64.319   0.584  1.00 28.97           C
ATOM    442  OE1 GLU A  60      19.974  64.016   1.316  1.00 25.72           O
ATOM    443  OE2 GLU A  60      18.443  63.501  -0.174  1.00 26.36           O
ATOM    444  N   VAL A  61      18.780  68.408   4.351  1.00 26.83           N
ATOM    445  CA  VAL A  61      18.455  68.761   5.700  1.00 27.38           C
ATOM    446  C   VAL A  61      17.865  70.179   5.774  1.00 28.68           C
ATOM    447  O   VAL A  61      16.957  70.443   6.574  1.00 28.48           O
ATOM    448  CB  VAL A  61      19.686  68.692   6.621  1.00 28.57           C
ATOM    449  CG1 VAL A  61      19.285  69.060   8.002  1.00 29.35           C
ATOM    450  CG2 VAL A  61      20.248  67.253   6.610  1.00 29.06           C
ATOM    451  N   ALA A  62      18.376  71.068   4.940  1.00 30.28           N
ATOM    452  CA  ALA A  62      17.906  72.461   4.939  1.00 30.97           C
ATOM    453  C   ALA A  62      16.415  72.490   4.581  1.00 32.05           C
ATOM    454  O   ALA A  62      15.619  73.221   5.204  1.00 32.43           O
ATOM    455  CB  ALA A  62      18.717  73.293   3.918  1.00 31.85           C
ATOM    456  N   ARG A  63      16.048  71.715   3.554  1.00 31.45           N
ATOM    457  CA  ARG A  63      14.685  71.759   3.007  1.00 31.11           C
ATOM    458  C   ARG A  63      13.693  70.961   3.824  1.00 31.22           C
ATOM    459  O   ARG A  63      12.585  71.432   4.155  1.00 30.37           O
ATOM    460  CB  ARG A  63      14.692  71.290   1.578  1.00 30.47           C
ATOM    461  CG  ARG A  63      15.474  72.185   0.703  1.00 32.19           C
ATOM    462  CD  ARG A  63      15.650  71.618  -0.651  1.00 33.87           C
ATOM    463  NE  ARG A  63      16.480  72.456  -1.487  1.00 37.25           N
ATOM    464  CZ  ARG A  63      16.708  72.211  -2.758  1.00 40.73           C
ATOM    465  NH1 ARG A  63      16.156  71.170  -3.341  1.00 43.11           N
ATOM    466  NH2 ARG A  63      17.498  73.018  -3.459  1.00 45.03           N
ATOM    467  N   ARG A  64      14.068  69.725   4.126  1.00 29.23           N
ATOM    468  CA  ARG A  64      13.191  68.830   4.823  1.00 28.77           C
ATOM    469  C   ARG A  64      13.172  69.063   6.310  1.00 28.36           C
ATOM    470  O   ARG A  64      12.246  68.629   6.978  1.00 30.43           O
ATOM    471  CB  ARG A  64      13.556  67.355   4.524  1.00 26.76           C
ATOM    472  CG  ARG A  64      13.441  66.977   3.061  1.00 27.46           C
ATOM    473  CD  ARG A  64      11.993  67.041   2.528  1.00 27.24           C
ATOM    474  NE  ARG A  64      11.118  66.279   3.404  1.00 25.24           N
ATOM    475  CZ  ARG A  64       9.807  66.511   3.584  1.00 30.26           C
ATOM    476  NH1 ARG A  64       9.182  67.438   2.902  1.00 28.05           N
ATOM    477  NH2 ARG A  64       9.115  65.775   4.421  1.00 27.17           N
ATOM    478  N   GLY A  65      14.194  69.748   6.831  1.00 29.71           N
ATOM    479  CA  GLY A  65      14.331  69.971   8.258  1.00 30.00           C
ATOM    480  C   GLY A  65      15.073  68.867   9.026  1.00 31.51           C
ATOM    481  O   GLY A  65      15.293  67.746   8.482  1.00 29.23           O
ATOM    482  N   PRO A  66      15.450  69.162  10.280  1.00 31.54           N
ATOM    483  CA  PRO A  66      16.044  68.162  11.164  1.00 31.77           C
ATOM    484  C   PRO A  66      15.097  67.021  11.537  1.00 31.59           C
ATOM    485  O   PRO A  66      13.868  67.144  11.543  1.00 30.57           O
ATOM    486  CB  PRO A  66      16.394  68.968  12.434  1.00 32.48           C
ATOM    487  CG  PRO A  66      15.421  70.075  12.417  1.00 33.52           C
ATOM    488  CD  PRO A  66      15.359  70.484  10.957  1.00 31.75           C
ATOM    489  N   GLY A  67      15.692  65.887  11.850  1.00 30.75           N
ATOM    490  CA  GLY A  67      14.948  64.798  12.405  1.00 31.34           C
ATOM    491  C   GLY A  67      14.259  65.240  13.680  1.00 32.44           C
ATOM    492  O   GLY A  67      14.873  65.861  14.561  1.00 31.76           O
ATOM    493  N   ARG A  68      12.968  64.933  13.761  1.00 33.49           N
ATOM    494  CA  ARG A  68      12.141  65.338  14.890  1.00 34.30           C
ATOM    495  C   ARG A  68      12.184  64.297  15.983  1.00 34.79           C
ATOM    496  O   ARG A  68      11.191  63.669  16.315  1.00 35.43           O
ATOM    497  CB  ARG A  68      10.706  65.637  14.418  1.00 34.46           C
ATOM    498  CG  ARG A  68      10.657  66.795  13.508  1.00 33.19           C
ATOM    499  CD  ARG A  68       9.252  67.196  13.096  1.00 35.48           C
ATOM    500  NE  ARG A  68       9.324  68.297  12.163  1.00 35.32           N
ATOM    501  CZ  ARG A  68       8.300  68.768  11.451  1.00 38.25           C
ATOM    502  NH1 ARG A  68       7.100  68.221  11.516  1.00 38.65           N
ATOM    503  NH2 ARG A  68       8.499  69.782  10.632  1.00 36.55           N
ATOM    504  N   VAL A  69      13.374  64.137  16.566  1.00 36.11           N
ATOM    505  CA  VAL A  69      13.622  63.072  17.500  1.00 37.51           C
ATOM    506  C   VAL A  69      13.284  63.517  18.902  1.00 39.55           C
ATOM    507  O   VAL A  69      13.246  64.706  19.187  1.00 39.65           O
ATOM    508  CB  VAL A  69      15.111  62.588  17.454  1.00 37.42           C
ATOM    509  CG1 VAL A  69      15.419  62.007  16.108  1.00 35.59           C
ATOM    510  CG2 VAL A  69      16.098  63.713  17.784  1.00 36.80           C
ATOM    511  N   PRO A  70      13.021  62.571  19.777  1.00 41.59           N
ATOM    512  CA  PRO A  70      12.866  62.927  21.186  1.00 43.09           C
ATOM    513  C   PRO A  70      14.193  63.344  21.788  1.00 44.69           C
ATOM    514  O   PRO A  70      15.257  63.214  21.172  1.00 44.85           O
ATOM    515  CB  PRO A  70      12.357  61.641  21.824  1.00 43.26           C
ATOM    516  CG  PRO A  70      12.871  60.552  20.950  1.00 42.20           C
ATOM    517  CD  PRO A  70      12.835  61.131  19.540  1.00 41.72           C
ATOM    518  N   ASP A  71      14.111  63.900  22.987  1.00 46.09           N
ATOM    519  CA  ASP A  71      15.298  64.287  23.736  1.00 46.78           C
ATOM    520  C   ASP A  71      15.946  63.026  24.271  1.00 45.56           C
ATOM    521  O   ASP A  71      15.275  61.987  24.481  1.00 46.31           O
ATOM    522  CB  ASP A  71      14.938  65.283  24.858  1.00 47.87           C
ATOM    523  CG  ASP A  71      14.675  66.691  24.314  1.00 51.05           C
ATOM    524  OD1 ASP A  71      15.615  67.517  24.305  1.00 55.46           O
ATOM    525  OD2 ASP A  71      13.571  67.057  23.830  1.00 57.36           O
ATOM    526  N   GLY A  72      17.258  63.103  24.457  1.00 43.96           N
ATOM    527  CA  GLY A  72      18.040  61.934  24.804  1.00 43.03           C
ATOM    528  C   GLY A  72      18.622  61.203  23.588  1.00 41.89           C
ATOM    529  O   GLY A  72      19.355  60.241  23.777  1.00 42.12           O
ATOM    530  N   ILE A  73      18.302  61.649  22.362  1.00 39.77           N
ATOM    531  CA  ILE A  73      18.890  61.058  21.141  1.00 37.81           C
ATOM    532  C   ILE A  73      19.804  62.039  20.446  1.00 36.48           C
ATOM    533  O   ILE A  73      19.399  63.127  20.047  1.00 37.06           O
ATOM    534  CB  ILE A  73      17.773  60.556  20.178  1.00 38.11           C
ATOM    535  CG1 ILE A  73      16.905  59.524  20.890  1.00 38.15           C
ATOM    536  CG2 ILE A  73      18.386  59.962  18.861  1.00 38.19           C
ATOM    537  CD1 ILE A  73      15.837  58.890  20.011  1.00 39.45           C
ATOM    538  N   ASP A  74      21.054  61.641  20.287  1.00 34.98           N
ATOM    539  CA  ASP A  74      22.059  62.426  19.617  1.00 34.09           C
ATOM    540  C   ASP A  74      21.979  62.123  18.126  1.00 33.29           C
ATOM    541  O   ASP A  74      22.184  60.969  17.735  1.00 31.14           O
ATOM    542  CB  ASP A  74      23.398  61.987  20.170  1.00 35.28           C
ATOM    543  CG  ASP A  74      24.569  62.768  19.623  1.00 37.31           C
ATOM    544  OD1 ASP A  74      24.441  63.609  18.688  1.00 40.91           O
ATOM    545  OD2 ASP A  74      25.719  62.557  20.078  1.00 41.65           O
ATOM    546  N   VAL A  75      21.698  63.157  17.337  1.00 31.65           N
ATOM    547  CA  VAL A  75      21.634  63.097  15.877  1.00 31.26           C
ATOM    548  C   VAL A  75      22.967  63.583  15.333  1.00 30.44           C
ATOM    549  O   VAL A  75      23.370  64.749  15.543  1.00 30.85           O
ATOM    550  CB  VAL A  75      20.465  63.952  15.290  1.00 30.97           C
ATOM    551  CG1 VAL A  75      20.408  63.840  13.721  1.00 31.81           C
ATOM    552  CG2 VAL A  75      19.160  63.547  15.900  1.00 29.57           C
ATOM    553  N   HIS A  76      23.672  62.678  14.655  1.00 28.49           N
ATOM    554  CA  HIS A  76      24.951  62.955  14.078  1.00 27.56           C
ATOM    555  C   HIS A  76      24.741  63.262  12.597  1.00 27.84           C
ATOM    556  O   HIS A  76      24.275  62.397  11.850  1.00 25.96           O
ATOM    557  CB  HIS A  76      25.848  61.722  14.219  1.00 27.60           C
ATOM    558  CG  HIS A  76      26.065  61.290  15.626  1.00 29.96           C
ATOM    559  ND1 HIS A  76      25.190  60.468  16.299  1.00 30.81           N
ATOM    560  CD2 HIS A  76      27.070  61.566  16.493  1.00 28.56           C
ATOM    561  CE1 HIS A  76      25.654  60.251  17.519  1.00 31.66           C
ATOM    562  NE2 HIS A  76      26.786  60.905  17.661  1.00 33.31           N
ATOM    563  N   LEU A  77      25.057  64.490  12.198  1.00 26.30           N
ATOM    564  CA  LEU A  77      24.989  64.916  10.803  1.00 26.53           C
ATOM    565  C   LEU A  77      26.202  64.431  10.046  1.00 26.12           C
ATOM    566  O   LEU A  77      27.356  64.854  10.300  1.00 26.72           O
ATOM    567  CB  LEU A  77      24.894  66.440  10.704  1.00 27.27           C
ATOM    568  CG  LEU A  77      23.647  67.078  11.333  1.00 27.63           C
ATOM    569  CD1 LEU A  77      23.771  68.587  11.265  1.00 29.33           C
ATOM    570  CD2 LEU A  77      22.382  66.600  10.662  1.00 27.52           C
ATOM    571  N   LEU A  78      25.960  63.511   9.122  1.00 24.49           N
ATOM    572  CA  LEU A  78      26.987  62.852   8.348  1.00 24.77           C
ATOM    573  C   LEU A  78      26.666  62.914   6.879  1.00 24.03           C
ATOM    574  O   LEU A  78      26.346  61.895   6.266  1.00 24.35           O
ATOM    575  CB  LEU A  78      27.113  61.379   8.768  1.00 24.09           C
ATOM    576  CG  LEU A  78      27.469  61.197  10.244  1.00 23.88           C
ATOM    577  CD1 LEU A  78      27.058  59.858  10.756  1.00 24.00           C
ATOM    578  CD2 LEU A  78      29.003  61.457  10.420  1.00 25.23           C
ATOM    579  N   PRO A  79      26.738  64.107   6.279  1.00 24.69           N
ATOM    580  CA  PRO A  79      26.223  64.311   4.917  1.00 24.43           C
ATOM    581  C   PRO A  79      26.899  63.418   3.913  1.00 24.65           C
ATOM    582  O   PRO A  79      28.126  63.250   3.902  1.00 23.73           O
ATOM    583  CB  PRO A  79      26.530  65.794   4.624  1.00 26.19           C
ATOM    584  CG  PRO A  79      26.978  66.379   5.863  1.00 26.60           C
ATOM    585  CD  PRO A  79      27.267  65.352   6.866  1.00 25.14           C
ATOM    586  N   PHE A  80      26.080  62.822   3.052  1.00 23.14           N
ATOM    587  CA  PHE A  80      26.536  61.906   2.041  1.00 24.09           C
ATOM    588  C   PHE A  80      25.801  62.412   0.819  1.00 24.02           C
ATOM    589  O   PHE A  80      24.565  62.441   0.842  1.00 24.85           O
ATOM    590  CB  PHE A  80      26.075  60.507   2.453  1.00 23.96           C
ATOM    591  CG  PHE A  80      26.656  59.364   1.677  1.00 23.84           C
ATOM    592  CD1 PHE A  80      27.102  58.235   2.375  1.00 26.16           C
ATOM    593  CD2 PHE A  80      26.704  59.344   0.264  1.00 24.76           C
ATOM    594  CE1 PHE A  80      27.580  57.112   1.714  1.00 26.73           C
ATOM    595  CE2 PHE A  80      27.197  58.220  -0.402  1.00 25.14           C
ATOM    596  CZ  PHE A  80      27.633  57.104   0.314  1.00 25.56           C
ATOM    597  N   PRO A  81      26.521  62.824  -0.223  1.00 26.58           N
ATOM    598  CA  PRO A  81      25.874  63.386  -1.427  1.00 27.67           C
ATOM    599  C   PRO A  81      24.690  62.556  -1.967  1.00 27.54           C
ATOM    600  O   PRO A  81      24.768  61.326  -2.162  1.00 25.92           O
ATOM    601  CB  PRO A  81      27.009  63.431  -2.457  1.00 28.50           C
ATOM    602  CG  PRO A  81      28.270  63.567  -1.645  1.00 28.57           C
ATOM    603  CD  PRO A  81      27.990  62.845  -0.320  1.00 26.59           C
ATOM    604  N   ASP A  82      23.585  63.244  -2.236  1.00 28.63           N
ATOM    605  CA  ASP A  82      22.382  62.548  -2.676  1.00 29.47           C
ATOM    606  C   ASP A  82      22.447  62.073  -4.125  1.00 30.86           C
ATOM    607  O   ASP A  82      23.451  62.310  -4.823  1.00 31.66           O
ATOM    608  CB  ASP A  82      21.112  63.370  -2.384  1.00 29.67           C
ATOM    609  CG  ASP A  82      20.986  64.621  -3.223  1.00 32.38           C
ATOM    610  OD1 ASP A  82      21.467  64.662  -4.362  1.00 30.99           O
ATOM    611  OD2 ASP A  82      20.391  65.608  -2.778  1.00 36.73           O
ATOM    612  N   LEU A  83      21.392  61.394  -4.573  1.00 31.97           N
ATOM    613  CA  LEU A  83      21.396  60.723  -5.876  1.00 33.57           C
ATOM    614  C   LEU A  83      20.813  61.574  -7.010  1.00 36.10           C
ATOM    615  O   LEU A  83      20.536  61.046  -8.104  1.00 37.42           O
ATOM    616  CB  LEU A  83      20.669  59.379  -5.794  1.00 32.77           C
ATOM    617  CG  LEU A  83      21.517  58.265  -5.149  1.00 32.27           C
ATOM    618  CD1 LEU A  83      21.599  58.458  -3.633  1.00 31.38           C
ATOM    619  CD2 LEU A  83      21.002  56.881  -5.546  1.00 32.38           C
ATOM    620  N   ALA A  84      20.676  62.870  -6.765  1.00 38.59           N
ATOM    621  CA  ALA A  84      20.171  63.834  -7.750  1.00 41.04           C
ATOM    622  C   ALA A  84      21.276  64.347  -8.683  1.00 43.58           C
ATOM    623  O   ALA A  84      22.457  64.187  -8.384  1.00 42.80           O
ATOM    624  CB  ALA A  84      19.549  65.005  -7.025  1.00 40.53           C
ATOM    625  N   ASP A  85      20.869  64.980  -9.793  1.00 47.15           N
ATOM    626  CA  ASP A  85      21.798  65.588 -10.784  1.00 49.80           C
ATOM    627  C   ASP A  85      22.599  66.781 -10.228  1.00 50.83           C
ATOM    628  O   ASP A  85      22.062  67.650  -9.506  1.00 52.35           O
ATOM    629  CB  ASP A  85      21.038  66.086 -12.029  1.00 50.74           C
ATOM    630  CG  ASP A  85      20.127  65.032 -12.631  1.00 53.67           C
ATOM    631  OD1 ASP A  85      20.619  63.912 -12.925  1.00 57.65           O
ATOM    632  OD2 ASP A  85      18.902  65.229 -12.843  1.00 57.57           O
ATOM    633  N   SER A 117       9.400  50.819 -23.510  1.00 76.20           N
ATOM    634  CA  SER A 117       9.750  51.633 -22.348  1.00 76.13           C
ATOM    635  C   SER A 117      11.150  51.285 -21.839  1.00 75.92           C
ATOM    636  O   SER A 117      11.379  50.190 -21.303  1.00 75.98           O
ATOM    637  CB  SER A 117       8.708  51.468 -21.228  1.00 76.05           C
ATOM    638  OG  SER A 117       8.803  50.204 -20.588  1.00 76.00           O
ATOM    639  N   ILE A 118      12.083  52.218 -22.022  1.00 75.53           N
ATOM    640  CA  ILE A 118      13.423  52.075 -21.465  1.00 75.16           C
ATOM    641  C   ILE A 118      13.535  52.851 -20.157  1.00 74.23           C
ATOM    642  O   ILE A 118      13.931  54.024 -20.140  1.00 74.24           O
ATOM    643  CB  ILE A 118      14.517  52.545 -22.463  1.00 75.49           C
ATOM    644  CG1 ILE A 118      14.399  51.790 -23.791  1.00 76.18           C
ATOM    645  CG2 ILE A 118      15.924  52.332 -21.869  1.00 75.87           C
ATOM    646  CD1 ILE A 118      15.397  52.249 -24.860  1.00 76.94           C
ATOM    647  N   ASN A 119      13.164  52.180 -19.063  1.00 73.16           N
ATOM    648  CA  ASN A 119      13.697  52.501 -17.734  1.00 71.77           C
ATOM    649  C   ASN A 119      14.773  51.454 -17.425  1.00 70.24           C
ATOM    650  O   ASN A 119      14.870  50.916 -16.324  1.00 70.37           O
ATOM    651  CB  ASN A 119      12.620  52.556 -16.642  1.00 72.14           C
ATOM    652  CG  ASN A 119      11.379  51.753 -16.987  1.00 73.21           C
ATOM    653  OD1 ASN A 119      10.506  52.225 -17.727  1.00 75.10           O
ATOM    654  ND2 ASN A 119      11.287  50.536 -16.448  1.00 73.35           N
ATOM    655  N   ASP A 120      15.552  51.148 -18.459  1.00 68.12           N
ATOM    656  CA  ASP A 120      16.877  50.574 -18.323  1.00 66.29           C
ATOM    657  C   ASP A 120      17.792  51.779 -18.132  1.00 63.79           C
ATOM    658  O   ASP A 120      18.947  51.644 -17.728  1.00 63.67           O
ATOM    659  CB  ASP A 120      17.280  49.799 -19.589  1.00 66.81           C
ATOM    660  CG  ASP A 120      16.191  48.836 -20.081  1.00 68.11           C
ATOM    661  OD1 ASP A 120      16.559  47.770 -20.630  1.00 70.86           O
ATOM    662  OD2 ASP A 120      14.958  49.053 -19.989  1.00 69.91           O
ATOM    663  N   ALA A 121      17.253  52.956 -18.459  1.00 60.78           N
ATOM    664  CA  ALA A 121      17.908  54.235 -18.240  1.00 58.62           C
ATOM    665  C   ALA A 121      18.000  54.564 -16.750  1.00 56.57           C
ATOM    666  O   ALA A 121      18.981  55.150 -16.299  1.00 55.77           O
ATOM    667  CB  ALA A 121      17.140  55.326 -18.957  1.00 58.49           C
ATOM    668  N   ALA A 122      16.956  54.211 -16.009  1.00 54.31           N
ATOM    669  CA  ALA A 122      16.948  54.374 -14.558  1.00 53.07           C
ATOM    670  C   ALA A 122      17.962  53.416 -13.935  1.00 51.24           C
ATOM    671  O   ALA A 122      18.735  53.810 -13.065  1.00 50.77           O
ATOM    672  CB  ALA A 122      15.544  54.127 -13.991  1.00 52.77           C
ATOM    673  N   THR A 123      17.963  52.180 -14.415  1.00 49.38           N
ATOM    674  CA  THR A 123      18.898  51.169 -13.965  1.00 49.14           C
ATOM    675  C   THR A 123      20.361  51.566 -14.157  1.00 48.33           C
ATOM    676  O   THR A 123      21.188  51.372 -13.260  1.00 47.35           O
ATOM    677  CB  THR A 123      18.606  49.849 -14.675  1.00 49.28           C
ATOM    678  OG1 THR A 123      17.278  49.424 -14.360  1.00 50.46           O
ATOM    679  CG2 THR A 123      19.458  48.737 -14.122  1.00 50.71           C
ATOM    680  N   ARG A 124      20.674  52.112 -15.332  1.00 47.22           N
ATOM    681  CA  ARG A 124      22.012  52.607 -15.653  1.00 46.58           C
ATOM    682  C   ARG A 124      22.393  53.750 -14.726  1.00 44.47           C
ATOM    683  O   ARG A 124      23.509  53.812 -14.214  1.00 44.47           O
ATOM    684  CB  ARG A 124      22.064  53.156 -17.106  1.00 47.55           C
ATOM    685  CG  ARG A 124      22.278  52.109 -18.201  1.00 51.30           C
ATOM    686  CD  ARG A 124      22.579  52.710 -19.618  1.00 55.62           C
ATOM    687  NE  ARG A 124      21.451  53.484 -20.156  1.00 59.60           N
ATOM    688  CZ  ARG A 124      20.352  52.962 -20.725  1.00 61.82           C
ATOM    689  NH1 ARG A 124      20.201  51.643 -20.851  1.00 63.49           N
ATOM    690  NH2 ARG A 124      19.388  53.766 -21.171  1.00 62.80           N
ATOM    691  N   TYR A 125      21.473  54.690 -14.571  1.00 41.51           N
ATOM    692  CA  TYR A 125      21.719  55.876 -13.783  1.00 40.24           C
ATOM    693  C   TYR A 125      22.017  55.496 -12.319  1.00 38.85           C
ATOM    694  O   TYR A 125      22.994  55.953 -11.725  1.00 38.24           O
ATOM    695  CB  TYR A 125      20.502  56.770 -13.792  1.00 40.60           C
ATOM    696  CG  TYR A 125      20.693  57.980 -12.935  1.00 39.11           C
ATOM    697  CD1 TYR A 125      21.379  59.068 -13.413  1.00 40.49           C
ATOM    698  CD2 TYR A 125      20.204  58.025 -11.633  1.00 40.98           C
ATOM    699  CE1 TYR A 125      21.573  60.194 -12.640  1.00 41.45           C
ATOM    700  CE2 TYR A 125      20.394  59.139 -10.839  1.00 39.16           C
ATOM    701  CZ  TYR A 125      21.078  60.228 -11.344  1.00 40.55           C
ATOM    702  OH  TYR A 125      21.284  61.367 -10.598  1.00 38.51           O
ATOM    703  N   MET A 126      21.155  54.657 -11.770  1.00 37.53           N
ATOM    704  CA  MET A 126      21.268  54.224 -10.381  1.00 36.97           C
ATOM    705  C   MET A 126      22.529  53.424 -10.157  1.00 36.51           C
ATOM    706  O   MET A 126      23.234  53.637  -9.163  1.00 35.98           O
ATOM    707  CB  MET A 126      20.042  53.424  -9.965  1.00 36.49           C
ATOM    708  CG  MET A 126      18.779  54.258  -9.871  1.00 35.55           C
ATOM    709  SD  MET A 126      18.759  55.555  -8.591  1.00 35.63           S
ATOM    710  CE  MET A 126      18.351  54.482  -7.174  1.00 34.86           C
ATOM    711  N   THR A 127      22.856  52.544 -11.098  1.00 36.70           N
ATOM    712  CA  THR A 127      24.054  51.732 -10.978  1.00 36.96           C
ATOM    713  C   THR A 127      25.275  52.660 -10.904  1.00 37.31           C
ATOM    714  O   THR A 127      26.178  52.470 -10.071  1.00 36.83           O
ATOM    715  CB  THR A 127      24.167  50.689 -12.150  1.00 37.09           C
ATOM    716  OG1 THR A 127      23.098  49.732 -12.077  1.00 36.35           O
ATOM    717  CG2 THR A 127      25.412  49.836 -12.006  1.00 37.76           C
ATOM    718  N   ASP A 128      25.278  53.691 -11.747  1.00 37.74           N
ATOM    719  CA  ASP A 128      26.390  54.628 -11.816  1.00 38.33           C
ATOM    720  C   ASP A 128      26.526  55.490 -10.562  1.00 37.17           C
ATOM    721  O   ASP A 128      27.636  55.770 -10.124  1.00 36.50           O
ATOM    722  CB  ASP A 128      26.323  55.456 -13.092  1.00 39.43           C
ATOM    723  CG  ASP A 128      26.979  54.726 -14.252  1.00 43.72           C
ATOM    724  OD1 ASP A 128      26.247  54.090 -15.040  1.00 49.92           O
ATOM    725  OD2 ASP A 128      28.229  54.641 -14.379  1.00 51.10           O
ATOM    726  N   GLU A 129      25.389  55.811  -9.940  1.00 36.16           N
ATOM    727  CA  GLU A 129      25.366  56.521  -8.684  1.00 35.61           C
ATOM    728  C   GLU A 129      26.072  55.656  -7.596  1.00 34.61           C
ATOM    729  O   GLU A 129      26.926  56.154  -6.880  1.00 33.43           O
ATOM    730  CB  GLU A 129      23.913  56.834  -8.261  1.00 35.86           C
ATOM    731  CG  GLU A 129      23.233  57.983  -8.974  1.00 39.43           C
ATOM    732  CD  GLU A 129      23.935  59.305  -8.787  1.00 43.81           C
ATOM    733  OE1 GLU A 129      24.217  59.689  -7.634  1.00 45.30           O
ATOM    734  OE2 GLU A 129      24.206  59.965  -9.809  1.00 49.24           O
ATOM    735  N   TYR A 130      25.694  54.380  -7.499  1.00 33.12           N
ATOM    736  CA  TYR A 130      26.256  53.448  -6.522  1.00 33.25           C
ATOM    737  C   TYR A 130      27.742  53.234  -6.762  1.00 34.03           C
ATOM    738  O   TYR A 130      28.552  53.166  -5.844  1.00 32.52           O
ATOM    739  CB  TYR A 130      25.552  52.097  -6.596  1.00 32.41           C
ATOM    740  CG  TYR A 130      24.307  51.948  -5.757  1.00 30.35           C
ATOM    741  CD1 TYR A 130      23.129  52.593  -6.098  1.00 28.78           C
ATOM    742  CD2 TYR A 130      24.303  51.123  -4.625  1.00 28.77           C
ATOM    743  CE1 TYR A 130      21.969  52.450  -5.322  1.00 26.70           C
ATOM    744  CE2 TYR A 130      23.161  50.966  -3.857  1.00 24.63           C
ATOM    745  CZ  TYR A 130      22.002  51.638  -4.191  1.00 24.99           C
ATOM    746  OH  TYR A 130      20.843  51.447  -3.486  1.00 25.90           O
ATOM    747  N   ARG A 131      28.082  53.124  -8.031  1.00 35.58           N
ATOM    748  CA  ARG A 131      29.469  52.993  -8.435  1.00 37.35           C
ATOM    749  C   ARG A 131      30.356  54.088  -7.814  1.00 36.50           C
ATOM    750  O   ARG A 131      31.486  53.814  -7.439  1.00 37.59           O
ATOM    751  CB  ARG A 131      29.557  53.000  -9.967  1.00 38.03           C
ATOM    752  CG  ARG A 131      30.741  52.270 -10.508  1.00 42.83           C
ATOM    753  CD  ARG A 131      30.619  51.931 -11.992  1.00 46.53           C
ATOM    754  NE  ARG A 131      30.191  50.542 -12.195  1.00 49.32           N
ATOM    755  CZ  ARG A 131      29.199  50.150 -12.992  1.00 51.58           C
ATOM    756  NH1 ARG A 131      28.496  51.028 -13.718  1.00 52.97           N
ATOM    757  NH2 ARG A 131      28.923  48.855 -13.084  1.00 51.92           N
ATOM    758  N   GLN A 132      29.838  55.305  -7.695  1.00 35.62           N
ATOM    759  CA  GLN A 132      30.560  56.432  -7.131  1.00 35.54           C
ATOM    760  C   GLN A 132      30.490  56.580  -5.604  1.00 33.09           C
ATOM    761  O   GLN A 132      31.205  57.394  -5.043  1.00 33.22           O
ATOM    762  CB  GLN A 132      30.054  57.719  -7.767  1.00 36.89           C
ATOM    763  CG  GLN A 132      30.229  57.724  -9.291  1.00 41.46           C
ATOM    764  CD  GLN A 132      29.609  58.934  -9.924  1.00 46.77           C
ATOM    765  OE1 GLN A 132      30.165  60.030  -9.839  1.00 51.08           O
ATOM    766  NE2 GLN A 132      28.447  58.748 -10.574  1.00 49.69           N
ATOM    767  N   PHE A 133      29.624  55.800  -4.947  1.00 30.95           N
ATOM    768  CA  PHE A 133      29.417  55.909  -3.495  1.00 29.70           C
ATOM    769  C   PHE A 133      30.714  55.868  -2.689  1.00 28.82           C
ATOM    770  O   PHE A 133      30.919  56.705  -1.821  1.00 29.56           O
ATOM    771  CB  PHE A 133      28.469  54.788  -3.000  1.00 29.49           C
ATOM    772  CG  PHE A 133      26.987  55.092  -3.140  1.00 26.40           C
ATOM    773  CD1 PHE A 133      26.502  56.318  -3.585  1.00 26.22           C
ATOM    774  CD2 PHE A 133      26.076  54.109  -2.806  1.00 25.85           C
ATOM    775  CE1 PHE A 133      25.149  56.558  -3.652  1.00 26.95           C
ATOM    776  CE2 PHE A 133      24.720  54.330  -2.906  1.00 25.75           C
ATOM    777  CZ  PHE A 133      24.248  55.550  -3.313  1.00 25.41           C
ATOM    778  N   PRO A 134      31.579  54.886  -2.923  1.00 30.47           N
ATOM    779  CA  PRO A 134      32.740  54.706  -2.038  1.00 29.90           C
ATOM    780  C   PRO A 134      33.663  55.930  -1.973  1.00 31.35           C
ATOM    781  O   PRO A 134      34.207  56.223  -0.900  1.00 29.21           O
ATOM    782  CB  PRO A 134      33.428  53.460  -2.606  1.00 29.90           C
ATOM    783  CG  PRO A 134      32.337  52.766  -3.374  1.00 30.31           C
ATOM    784  CD  PRO A 134      31.517  53.841  -3.955  1.00 28.79           C
ATOM    785  N   THR A 135      33.794  56.649  -3.090  1.00 31.74           N
ATOM    786  CA  THR A 135      34.677  57.824  -3.152  1.00 32.60           C
ATOM    787  C   THR A 135      33.965  59.150  -2.933  1.00 32.97           C
ATOM    788  O   THR A 135      34.618  60.191  -2.886  1.00 33.07           O
ATOM    789  CB  THR A 135      35.474  57.836  -4.491  1.00 33.00           C
ATOM    790  OG1 THR A 135      34.583  57.746  -5.609  1.00 34.79           O
ATOM    791  CG2 THR A 135      36.310  56.601  -4.592  1.00 32.79           C
ATOM    792  N   ARG A 136      32.642  59.152  -2.743  1.00 32.05           N
ATOM    793  CA  ARG A 136      31.958  60.405  -2.479  1.00 32.64           C
ATOM    794  C   ARG A 136      32.512  61.061  -1.239  1.00 32.38           C
ATOM    795  O   ARG A 136      32.822  60.390  -0.271  1.00 32.81           O
ATOM    796  CB  ARG A 136      30.455  60.218  -2.249  1.00 33.14           C
ATOM    797  CG  ARG A 136      29.685  59.854  -3.474  1.00 36.71           C
ATOM    798  CD  ARG A 136      29.752  60.905  -4.595  1.00 40.98           C
ATOM    799  NE  ARG A 136      28.737  60.624  -5.600  1.00 45.16           N
ATOM    800  CZ  ARG A 136      28.728  61.118  -6.841  1.00 48.15           C
ATOM    801  NH1 ARG A 136      29.674  61.960  -7.238  1.00 49.55           N
ATOM    802  NH2 ARG A 136      27.763  60.765  -7.695  1.00 48.26           N
ATOM    803  N   ASN A 137      32.590  62.382  -1.262  1.00 32.93           N
ATOM    804  CA  ASN A 137      32.967  63.139  -0.086  1.00 32.94           C
ATOM    805  C   ASN A 137      31.947  62.948   1.025  1.00 31.57           C
ATOM    806  O   ASN A 137      30.798  63.295   0.867  1.00 30.50           O
ATOM    807  CB  ASN A 137      33.058  64.633  -0.394  1.00 34.60           C
ATOM    808  CG  ASN A 137      33.619  65.417   0.773  1.00 39.29           C
ATOM    809  OD1 ASN A 137      34.009  64.834   1.795  1.00 47.10           O
ATOM    810  ND2 ASN A 137      33.673  66.736   0.640  1.00 47.36           N
ATOM    811  N   GLY A 138      32.391  62.416   2.164  1.00 29.86           N
ATOM    812  CA  GLY A 138      31.518  62.104   3.270  1.00 28.47           C
ATOM    813  C   GLY A 138      31.160  60.627   3.461  1.00 26.96           C
ATOM    814  O   GLY A 138      30.646  60.267   4.503  1.00 27.45           O
ATOM    815  N   ALA A 139      31.367  59.782   2.466  1.00 26.64           N
ATOM    816  CA  ALA A 139      31.012  58.354   2.578  1.00 25.58           C
ATOM    817  C   ALA A 139      31.850  57.638   3.649  1.00 25.65           C
ATOM    818  O   ALA A 139      31.313  56.973   4.530  1.00 23.96           O
ATOM    819  CB  ALA A 139      31.185  57.660   1.244  1.00 25.98           C
ATOM    820  N   GLN A 140      33.163  57.812   3.575  1.00 26.10           N
ATOM    821  CA  GLN A 140      34.042  57.256   4.609  1.00 25.22           C
ATOM    822  C   GLN A 140      33.744  57.848   5.965  1.00 24.52           C
ATOM    823  O   GLN A 140      33.681  57.116   6.934  1.00 24.39           O
ATOM    824  CB  GLN A 140      35.514  57.480   4.289  1.00 25.87           C
ATOM    825  CG  GLN A 140      35.977  56.619   3.139  1.00 28.08           C
ATOM    826  CD  GLN A 140      37.448  56.792   2.855  1.00 30.50           C
ATOM    827  OE1 GLN A 140      37.937  57.908   2.888  1.00 29.98           O
ATOM    828  NE2 GLN A 140      38.155  55.688   2.566  1.00 28.95           N
ATOM    829  N   ARG A 141      33.554  59.158   6.047  1.00 24.45           N
ATOM    830  CA  ARG A 141      33.175  59.773   7.333  1.00 24.15           C
ATOM    831  C   ARG A 141      31.905  59.166   7.928  1.00 24.28           C
ATOM    832  O   ARG A 141      31.804  58.927   9.139  1.00 23.03           O
ATOM    833  CB  ARG A 141      33.028  61.291   7.196  1.00 26.42           C
ATOM    834  CG  ARG A 141      32.749  62.045   8.462  1.00 30.15           C
ATOM    835  CD  ARG A 141      32.394  63.544   8.267  1.00 37.68           C
ATOM    836  NE  ARG A 141      31.810  63.810   6.940  1.00 43.68           N
ATOM    837  CZ  ARG A 141      31.296  64.977   6.531  1.00 44.80           C
ATOM    838  NH1 ARG A 141      31.239  66.047   7.339  1.00 46.83           N
ATOM    839  NH2 ARG A 141      30.840  65.065   5.290  1.00 43.26           N
ATOM    840  N   ALA A 142      30.883  58.967   7.102  1.00 24.18           N
ATOM    841  CA  ALA A 142      29.645  58.375   7.620  1.00 24.08           C
ATOM    842  C   ALA A 142      29.865  56.944   8.131  1.00 22.84           C
ATOM    843  O   ALA A 142      29.375  56.557   9.177  1.00 22.72           O
ATOM    844  CB  ALA A 142      28.583  58.373   6.507  1.00 25.17           C
ATOM    845  N   LEU A 143      30.550  56.121   7.344  1.00 23.08           N
ATOM    846  CA  LEU A 143      30.845  54.754   7.741  1.00 22.86           C
ATOM    847  C   LEU A 143      31.674  54.714   9.024  1.00 23.20           C
ATOM    848  O   LEU A 143      31.347  53.974   9.927  1.00 23.73           O
ATOM    849  CB  LEU A 143      31.540  54.003   6.615  1.00 23.46           C
ATOM    850  CG  LEU A 143      31.964  52.555   6.900  1.00 23.01           C
ATOM    851  CD1 LEU A 143      30.700  51.714   7.084  1.00 27.60           C
ATOM    852  CD2 LEU A 143      32.867  51.996   5.762  1.00 27.22           C
ATOM    853  N   HIS A 144      32.683  55.572   9.121  1.00 23.77           N
ATOM    854  CA  HIS A 144      33.509  55.662  10.304  1.00 23.92           C
ATOM    855  C   HIS A 144      32.664  55.948  11.521  1.00 22.90           C
ATOM    856  O   HIS A 144      32.781  55.242  12.502  1.00 24.28           O
ATOM    857  CB  HIS A 144      34.587  56.736  10.130  1.00 23.74           C
ATOM    858  CG  HIS A 144      35.401  56.967  11.359  1.00 25.54           C
ATOM    859  ND1 HIS A 144      34.973  57.778  12.386  1.00 28.04           N
ATOM    860  CD2 HIS A 144      36.624  56.510  11.721  1.00 28.01           C
ATOM    861  CE1 HIS A 144      35.880  57.782  13.349  1.00 32.04           C
ATOM    862  NE2 HIS A 144      36.885  57.017  12.979  1.00 29.55           N
ATOM    863  N   ARG A 145      31.744  56.920  11.451  1.00 23.23           N
ATOM    864  CA  ARG A 145      30.988  57.276  12.624  1.00 23.60           C
ATOM    865  C   ARG A 145      30.003  56.187  12.983  1.00 23.71           C
ATOM    866  O   ARG A 145      29.820  55.882  14.162  1.00 23.27           O
ATOM    867  CB  ARG A 145      30.258  58.633  12.480  1.00 24.09           C
ATOM    868  CG  ARG A 145      29.493  59.053  13.739  1.00 28.00           C
ATOM    869  CD  ARG A 145      30.418  59.495  14.926  1.00 33.56           C
ATOM    870  NE  ARG A 145      31.299  60.586  14.479  1.00 38.59           N
ATOM    871  CZ  ARG A 145      30.910  61.901  14.259  1.00 46.80           C
ATOM    872  NH1 ARG A 145      29.669  62.345  14.504  1.00 47.77           N
ATOM    873  NH2 ARG A 145      31.788  62.791  13.777  1.00 49.47           N
ATOM    874  N   VAL A 146      29.323  55.579  11.986  1.00 22.50           N
ATOM    875  CA  VAL A 146      28.366  54.529  12.301  1.00 23.10           C
ATOM    876  C   VAL A 146      29.057  53.353  13.035  1.00 22.32           C
ATOM    877  O   VAL A 146      28.565  52.844  14.042  1.00 23.14           O
ATOM    878  CB  VAL A 146      27.602  54.071  11.043  1.00 22.40           C
ATOM    879  CG1 VAL A 146      26.794  52.791  11.333  1.00 22.57           C
ATOM    880  CG2 VAL A 146      26.696  55.205  10.533  1.00 23.60           C
ATOM    881  N   VAL A 147      30.204  52.958  12.542  1.00 22.29           N
ATOM    882  CA  VAL A 147      30.949  51.816  13.080  1.00 23.57           C
ATOM    883  C   VAL A 147      31.445  52.160  14.468  1.00 24.34           C
ATOM    884  O   VAL A 147      31.324  51.360  15.395  1.00 24.98           O
ATOM    885  CB  VAL A 147      32.102  51.415  12.133  1.00 23.44           C
ATOM    886  CG1 VAL A 147      33.095  50.473  12.786  1.00 23.96           C
ATOM    887  CG2 VAL A 147      31.528  50.759  10.891  1.00 23.29           C
ATOM    888  N   THR A 148      31.990  53.348  14.617  1.00 25.47           N
ATOM    889  CA  THR A 148      32.479  53.784  15.921  1.00 26.52           C
ATOM    890  C   THR A 148      31.373  53.757  16.989  1.00 27.00           C
ATOM    891  O   THR A 148      31.572  53.193  18.069  1.00 26.86           O
ATOM    892  CB  THR A 148      33.133  55.160  15.820  1.00 26.72           C
ATOM    893  OG1 THR A 148      34.217  55.114  14.904  1.00 26.27           O
ATOM    894  CG2 THR A 148      33.776  55.598  17.193  1.00 30.09           C
ATOM    895  N   LEU A 149      30.180  54.256  16.648  1.00 26.62           N
ATOM    896  CA  LEU A 149      29.033  54.230  17.555  1.00 26.82           C
ATOM    897  C   LEU A 149      28.599  52.825  17.888  1.00 27.03           C
ATOM    898  O   LEU A 149      28.373  52.479  19.062  1.00 27.24           O
ATOM    899  CB  LEU A 149      27.851  55.033  16.956  1.00 26.66           C
ATOM    900  CG  LEU A 149      28.022  56.559  16.890  1.00 27.61           C
ATOM    901  CD1 LEU A 149      26.991  57.195  15.932  1.00 29.26           C
ATOM    902  CD2 LEU A 149      27.939  57.167  18.294  1.00 30.43           C
ATOM    903  N   LEU A 150      28.492  51.963  16.882  1.00 26.12           N
ATOM    904  CA  LEU A 150      28.094  50.592  17.157  1.00 26.34           C
ATOM    905  C   LEU A 150      29.076  49.849  18.055  1.00 27.48           C
ATOM    906  O   LEU A 150      28.680  49.095  18.915  1.00 27.71           O
ATOM    907  CB  LEU A 150      27.959  49.816  15.844  1.00 26.27           C
ATOM    908  CG  LEU A 150      26.757  50.307  15.047  1.00 24.99           C
ATOM    909  CD1 LEU A 150      26.796  49.733  13.608  1.00 23.88           C
ATOM    910  CD2 LEU A 150      25.416  49.993  15.777  1.00 26.40           C
ATOM    911  N   ALA A 151      30.349  50.009  17.776  1.00 27.79           N
ATOM    912  CA  ALA A 151      31.418  49.383  18.540  1.00 29.31           C
ATOM    913  C   ALA A 151      31.427  49.828  20.013  1.00 31.13           C
ATOM    914  O   ALA A 151      31.827  49.042  20.909  1.00 31.74           O
ATOM    915  CB  ALA A 151      32.731  49.691  17.871  1.00 30.13           C
ATOM    916  N   ALA A 152      30.965  51.048  20.255  1.00 31.52           N
ATOM    917  CA  ALA A 152      30.779  51.588  21.610  1.00 32.79           C
ATOM    918  C   ALA A 152      29.514  51.096  22.303  1.00 33.50           C
ATOM    919  O   ALA A 152      29.242  51.470  23.449  1.00 34.50           O
ATOM    920  CB  ALA A 152      30.805  53.109  21.580  1.00 32.48           C
ATOM    921  N   GLY A 153      28.718  50.282  21.638  1.00 33.23           N
ATOM    922  CA  GLY A 153      27.554  49.686  22.267  1.00 33.49           C
ATOM    923  C   GLY A 153      26.330  50.575  22.233  1.00 34.00           C
ATOM    924  O   GLY A 153      25.374  50.337  22.970  1.00 33.78           O
ATOM    925  N   ARG A 154      26.349  51.583  21.364  1.00 33.21           N
ATOM    926  CA  ARG A 154      25.219  52.485  21.175  1.00 34.17           C
ATOM    927  C   ARG A 154      24.256  51.890  20.143  1.00 32.80           C
ATOM    928  O   ARG A 154      24.708  51.535  19.065  1.00 32.71           O
ATOM    929  CB  ARG A 154      25.715  53.836  20.698  1.00 35.30           C
ATOM    930  CG  ARG A 154      26.754  54.417  21.636  1.00 40.43           C
ATOM    931  CD  ARG A 154      26.419  55.725  22.302  1.00 47.09           C
ATOM    932  NE  ARG A 154      27.575  56.617  22.158  1.00 53.94           N
ATOM    933  CZ  ARG A 154      28.737  56.464  22.813  1.00 59.07           C
ATOM    934  NH1 ARG A 154      28.907  55.473  23.703  1.00 60.40           N
ATOM    935  NH2 ARG A 154      29.741  57.318  22.589  1.00 60.69           N
ATOM    936  N   PRO A 155      22.975  51.742  20.487  1.00 31.87           N
ATOM    937  CA  PRO A 155      21.931  51.455  19.500  1.00 30.70           C
ATOM    938  C   PRO A 155      21.775  52.659  18.588  1.00 28.97           C
ATOM    939  O   PRO A 155      21.550  53.798  19.018  1.00 28.29           O
ATOM    940  CB  PRO A 155      20.686  51.221  20.365  1.00 31.46           C
ATOM    941  CG  PRO A 155      21.230  50.906  21.694  1.00 31.58           C
ATOM    942  CD  PRO A 155      22.371  51.839  21.828  1.00 33.07           C
ATOM    943  N   VAL A 156      21.917  52.393  17.291  1.00 27.77           N
ATOM    944  CA  VAL A 156      21.977  53.407  16.279  1.00 26.10           C
ATOM    945  C   VAL A 156      20.897  53.179  15.214  1.00 25.12           C
ATOM    946  O   VAL A 156      20.675  52.046  14.770  1.00 25.04           O
ATOM    947  CB  VAL A 156      23.353  53.365  15.568  1.00 27.08           C
ATOM    948  CG1 VAL A 156      23.389  54.345  14.414  1.00 26.63           C
ATOM    949  CG2 VAL A 156      24.491  53.695  16.550  1.00 27.96           C
ATOM    950  N   LEU A 157      20.249  54.256  14.812  1.00 24.18           N
ATOM    951  CA  LEU A 157      19.391  54.253  13.630  1.00 22.48           C
ATOM    952  C   LEU A 157      20.107  55.064  12.563  1.00 21.78           C
ATOM    953  O   LEU A 157      20.437  56.238  12.737  1.00 21.18           O
ATOM    954  CB  LEU A 157      18.009  54.828  13.942  1.00 23.63           C
ATOM    955  CG  LEU A 157      17.055  54.842  12.728  1.00 23.91           C
ATOM    956  CD1 LEU A 157      15.599  54.792  13.208  1.00 31.01           C
ATOM    957  CD2 LEU A 157      17.265  56.073  11.948  1.00 26.10           C
ATOM    958  N   THR A 158      20.356  54.421  11.430  1.00 19.83           N
ATOM    959  CA  THR A 158      20.927  55.089  10.272  1.00 20.06           C
ATOM    960  C   THR A 158      19.845  55.384   9.223  1.00 20.06           C
ATOM    961  O   THR A 158      19.038  54.539   8.924  1.00 18.43           O
ATOM    962  CB  THR A 158      21.978  54.145   9.636  1.00 21.29           C
ATOM    963  OG1 THR A 158      23.021  53.835  10.587  1.00 22.59           O
ATOM    964  CG2 THR A 158      22.691  54.801   8.471  1.00 21.01           C
ATOM    965  N   HIS A 159      19.883  56.575   8.644  1.00 20.74           N
ATOM    966  CA  HIS A 159      18.895  56.964   7.621  1.00 21.29           C
ATOM    967  C   HIS A 159      19.506  57.949   6.700  1.00 20.85           C
ATOM    968  O   HIS A 159      20.487  58.618   7.044  1.00 21.26           O
ATOM    969  CB  HIS A 159      17.576  57.531   8.265  1.00 19.74           C
ATOM    970  CG  HIS A 159      17.710  58.937   8.808  1.00 21.39           C
ATOM    971  ND1 HIS A 159      17.788  60.034   7.986  1.00 22.11           N
ATOM    972  CD2 HIS A 159      17.764  59.412  10.078  1.00 21.52           C
ATOM    973  CE1 HIS A 159      17.916  61.133   8.729  1.00 22.43           C
ATOM    974  NE2 HIS A 159      17.902  60.777  10.005  1.00 21.99           N
ATOM    975  N   CYS A 160      18.892  58.077   5.528  1.00 21.32           N
ATOM    976  CA  CYS A 160      19.183  59.143   4.607  1.00 21.47           C
ATOM    977  C   CYS A 160      17.825  59.796   4.271  1.00 21.15           C
ATOM    978  O   CYS A 160      17.101  60.195   5.166  1.00 20.59           O
ATOM    979  CB  CYS A 160      19.956  58.596   3.380  1.00 21.06           C
ATOM    980  SG  CYS A 160      19.296  57.117   2.525  1.00 19.94           S
ATOM    981  N   PHE A 161      17.487  59.921   2.996  1.00 20.32           N
ATOM    982  CA  PHE A 161      16.160  60.410   2.612  1.00 20.04           C
ATOM    983  C   PHE A 161      15.192  59.243   2.456  1.00 20.09           C
ATOM    984  O   PHE A 161      14.319  59.081   3.266  1.00 21.10           O
ATOM    985  CB  PHE A 161      16.251  61.233   1.337  1.00 20.58           C
ATOM    986  CG  PHE A 161      14.906  61.733   0.842  1.00 24.10           C
ATOM    987  CD1 PHE A 161      14.168  62.615   1.595  1.00 26.06           C
ATOM    988  CD2 PHE A 161      14.413  61.315  -0.373  1.00 25.88           C
ATOM    989  CE1 PHE A 161      12.930  63.094   1.159  1.00 28.92           C
ATOM    990  CE2 PHE A 161      13.193  61.773  -0.820  1.00 26.83           C
ATOM    991  CZ  PHE A 161      12.458  62.676  -0.058  1.00 30.72           C
ATOM    992  N   ALA A 162      15.358  58.408   1.438  1.00 20.62           N
ATOM    993  CA  ALA A 162      14.486  57.229   1.280  1.00 21.07           C
ATOM    994  C   ALA A 162      14.897  55.992   2.104  1.00 20.92           C
ATOM    995  O   ALA A 162      14.103  55.037   2.277  1.00 21.45           O
ATOM    996  CB  ALA A 162      14.346  56.905  -0.202  1.00 21.78           C
ATOM    997  N   GLY A 163      16.102  56.042   2.684  1.00 19.41           N
ATOM    998  CA  GLY A 163      16.582  54.948   3.525  1.00 19.80           C
ATOM    999  C   GLY A 163      16.971  53.678   2.770  1.00 19.21           C
ATOM   1000  O   GLY A 163      17.034  52.616   3.326  1.00 19.21           O
ATOM   1001  N   LYS A 164      17.186  53.800   1.464  1.00 20.20           N
ATOM   1002  CA  LYS A 164      17.389  52.635   0.608  1.00 19.61           C
ATOM   1003  C   LYS A 164      18.768  52.575  -0.077  1.00 19.93           C
ATOM   1004  O   LYS A 164      19.327  51.481  -0.193  1.00 20.80           O
ATOM   1005  CB  LYS A 164      16.211  52.520  -0.421  1.00 19.94           C
ATOM   1006  CG  LYS A 164      16.375  53.419  -1.669  1.00 19.08           C
ATOM   1007  CD  LYS A 164      15.172  53.490  -2.623  1.00 22.40           C
ATOM   1008  CE  LYS A 164      15.687  54.017  -4.158  1.00 20.50           C
ATOM   1009  NZ  LYS A 164      14.837  55.029  -3.672  1.00 27.38           N
ATOM   1010  N   ASP A 165      19.316  53.704  -0.523  1.00 20.62           N
ATOM   1011  CA  ASP A 165      20.550  53.715  -1.281  1.00 20.97           C
ATOM   1012  C   ASP A 165      21.777  54.036  -0.453  1.00 19.71           C
ATOM   1013  O   ASP A 165      22.557  53.148  -0.141  1.00 21.13           O
ATOM   1014  CB  ASP A 165      20.410  54.661  -2.500  1.00 21.41           C
ATOM   1015  CG  ASP A 165      19.224  54.296  -3.377  1.00 22.71           C
ATOM   1016  OD1 ASP A 165      18.360  55.187  -3.639  1.00 24.55           O
ATOM   1017  OD2 ASP A 165      19.061  53.112  -3.808  1.00 24.22           O
ATOM   1018  N   ARG A 166      21.925  55.287  -0.048  1.00 20.23           N
ATOM   1019  CA  ARG A 166      23.030  55.644   0.856  1.00 20.32           C
ATOM   1020  C   ARG A 166      22.970  54.775   2.110  1.00 19.66           C
ATOM   1021  O   ARG A 166      23.971  54.210   2.510  1.00 20.63           O
ATOM   1022  CB  ARG A 166      23.003  57.123   1.188  1.00 20.35           C
ATOM   1023  CG  ARG A 166      23.371  57.963  -0.018  1.00 21.90           C
ATOM   1024  CD  ARG A 166      23.059  59.400   0.102  1.00 23.63           C
ATOM   1025  NE  ARG A 166      21.621  59.625   0.015  1.00 22.65           N
ATOM   1026  CZ  ARG A 166      21.013  60.747   0.307  1.00 21.72           C
ATOM   1027  NH1 ARG A 166      21.701  61.790   0.672  1.00 22.30           N
ATOM   1028  NH2 ARG A 166      19.680  60.835   0.209  1.00 22.09           N
ATOM   1029  N   THR A 167      21.823  54.720   2.761  1.00 20.08           N
ATOM   1030  CA  THR A 167      21.667  53.882   3.930  1.00 18.66           C
ATOM   1031  C   THR A 167      21.951  52.425   3.626  1.00 19.76           C
ATOM   1032  O   THR A 167      22.564  51.714   4.434  1.00 19.27           O
ATOM   1033  CB  THR A 167      20.231  54.062   4.523  1.00 19.49           C
ATOM   1034  OG1 THR A 167      20.111  55.378   5.096  1.00 19.51           O
ATOM   1035  CG2 THR A 167      19.958  53.064   5.647  1.00 18.90           C
ATOM   1036  N   GLY A 168      21.477  51.947   2.479  1.00 19.26           N
ATOM   1037  CA  GLY A 168      21.682  50.552   2.117  1.00 19.98           C
ATOM   1038  C   GLY A 168      23.178  50.247   1.946  1.00 19.09           C
ATOM   1039  O   GLY A 168      23.656  49.178   2.293  1.00 20.35           O
ATOM   1040  N   PHE A 169      23.922  51.170   1.351  1.00 19.04           N
ATOM   1041  CA  PHE A 169      25.390  51.050   1.235  1.00 20.47           C
ATOM   1042  C   PHE A 169      26.101  50.947   2.581  1.00 21.40           C
ATOM   1043  O   PHE A 169      26.854  49.990   2.843  1.00 19.95           O
ATOM   1044  CB  PHE A 169      25.927  52.234   0.443  1.00 21.12           C
ATOM   1045  CG  PHE A 169      27.431  52.287   0.308  1.00 19.87           C
ATOM   1046  CD1 PHE A 169      28.128  51.339  -0.418  1.00 23.16           C
ATOM   1047  CD2 PHE A 169      28.132  53.329   0.866  1.00 22.52           C
ATOM   1048  CE1 PHE A 169      29.523  51.436  -0.567  1.00 23.67           C
ATOM   1049  CE2 PHE A 169      29.522  53.399   0.763  1.00 25.14           C
ATOM   1050  CZ  PHE A 169      30.201  52.453   0.028  1.00 25.19           C
ATOM   1051  N   VAL A 170      25.838  51.915   3.452  1.00 21.07           N
ATOM   1052  CA  VAL A 170      26.484  51.919   4.759  1.00 21.42           C
ATOM   1053  C   VAL A 170      26.148  50.679   5.527  1.00 20.44           C
ATOM   1054  O   VAL A 170      27.051  50.018   6.032  1.00 20.47           O
ATOM   1055  CB  VAL A 170      26.123  53.190   5.520  1.00 21.34           C
ATOM   1056  CG1 VAL A 170      26.587  53.150   6.935  1.00 22.33           C
ATOM   1057  CG2 VAL A 170      26.683  54.420   4.767  1.00 22.61           C
ATOM   1058  N   VAL A 171      24.862  50.318   5.612  1.00 20.21           N
ATOM   1059  CA  VAL A 171      24.452  49.106   6.344  1.00 19.98           C
ATOM   1060  C   VAL A 171      25.121  47.836   5.827  1.00 20.94           C
ATOM   1061  O   VAL A 171      25.591  46.970   6.587  1.00 19.79           O
ATOM   1062  CB  VAL A 171      22.897  48.939   6.403  1.00 19.02           C
ATOM   1063  CG1 VAL A 171      22.524  47.586   7.001  1.00 20.90           C
ATOM   1064  CG2 VAL A 171      22.259  50.080   7.183  1.00 18.79           C
ATOM   1065  N   ALA A 172      25.187  47.719   4.510  1.00 19.86           N
ATOM   1066  CA  ALA A 172      25.770  46.558   3.886  1.00 20.93           C
ATOM   1067  C   ALA A 172      27.244  46.397   4.243  1.00 21.02           C
ATOM   1068  O   ALA A 172      27.689  45.295   4.442  1.00 22.23           O
ATOM   1069  CB  ALA A 172      25.659  46.651   2.348  1.00 19.79           C
ATOM   1070  N   LEU A 173      27.977  47.501   4.321  1.00 21.74           N
ATOM   1071  CA  LEU A 173      29.394  47.427   4.699  1.00 21.40           C
ATOM   1072  C   LEU A 173      29.557  47.081   6.158  1.00 22.00           C
ATOM   1073  O   LEU A 173      30.468  46.338   6.511  1.00 22.04           O
ATOM   1074  CB  LEU A 173      30.115  48.720   4.400  1.00 22.01           C
ATOM   1075  CG  LEU A 173      30.114  49.105   2.901  1.00 22.81           C
ATOM   1076  CD1 LEU A 173      31.030  50.307   2.702  1.00 23.89           C
ATOM   1077  CD2 LEU A 173      30.553  47.990   2.010  1.00 26.01           C
ATOM   1078  N   VAL A 174      28.698  47.645   7.011  1.00 21.80           N
ATOM   1079  CA  VAL A 174      28.685  47.256   8.435  1.00 21.64           C
ATOM   1080  C   VAL A 174      28.495  45.753   8.591  1.00 22.62           C
ATOM   1081  O   VAL A 174      29.245  45.091   9.341  1.00 21.56           O
ATOM   1082  CB  VAL A 174      27.622  48.026   9.241  1.00 21.69           C
ATOM   1083  CG1 VAL A 174      27.397  47.397  10.658  1.00 22.40           C
ATOM   1084  CG2 VAL A 174      28.006  49.463   9.341  1.00 21.86           C
ATOM   1085  N   LEU A 175      27.478  45.209   7.915  1.00 21.64           N
ATOM   1086  CA  LEU A 175      27.180  43.780   8.013  1.00 22.96           C
ATOM   1087  C   LEU A 175      28.322  42.929   7.485  1.00 22.89           C
ATOM   1088  O   LEU A 175      28.677  41.931   8.090  1.00 24.56           O
ATOM   1089  CB  LEU A 175      25.887  43.454   7.241  1.00 22.92           C
ATOM   1090  CG  LEU A 175      24.617  44.120   7.785  1.00 24.38           C
ATOM   1091  CD1 LEU A 175      23.376  43.682   7.047  1.00 25.67           C
ATOM   1092  CD2 LEU A 175      24.501  43.920   9.297  1.00 26.27           C
ATOM   1093  N   GLU A 176      28.914  43.325   6.357  1.00 22.98           N
ATOM   1094  CA  GLU A 176      30.033  42.568   5.826  1.00 23.90           C
ATOM   1095  C   GLU A 176      31.221  42.612   6.801  1.00 24.50           C
ATOM   1096  O   GLU A 176      31.881  41.591   7.010  1.00 24.24           O
ATOM   1097  CB  GLU A 176      30.418  43.028   4.433  1.00 24.82           C
ATOM   1098  CG  GLU A 176      31.451  42.096   3.812  1.00 27.79           C
ATOM   1099  CD  GLU A 176      31.777  42.405   2.380  1.00 28.19           C
ATOM   1100  OE1 GLU A 176      31.050  43.165   1.750  1.00 29.79           O
ATOM   1101  OE2 GLU A 176      32.804  41.883   1.862  1.00 30.74           O
ATOM   1102  N   ALA A 177      31.465  43.775   7.405  1.00 24.47           N
ATOM   1103  CA  ALA A 177      32.560  43.942   8.366  1.00 25.21           C
ATOM   1104  C   ALA A 177      32.451  43.015   9.579  1.00 26.25           C
ATOM   1105  O   ALA A 177      33.488  42.652  10.155  1.00 26.54           O
ATOM   1106  CB  ALA A 177      32.643  45.374   8.819  1.00 23.55           C
ATOM   1107  N   VAL A 178      31.235  42.647   9.985  1.00 26.92           N
ATOM   1108  CA  VAL A 178      31.073  41.717  11.105  1.00 28.54           C
ATOM   1109  C   VAL A 178      30.921  40.272  10.648  1.00 28.78           C
ATOM   1110  O   VAL A 178      30.642  39.398  11.452  1.00 29.94           O
ATOM   1111  CB  VAL A 178      29.956  42.112  12.103  1.00 28.67           C
ATOM   1112  CG1 VAL A 178      30.253  43.492  12.711  1.00 30.76           C
ATOM   1113  CG2 VAL A 178      28.555  42.048  11.505  1.00 28.24           C
ATOM   1114  N   GLY A 179      31.119  40.026   9.353  1.00 29.04           N
ATOM   1115  CA  GLY A 179      31.241  38.675   8.838  1.00 30.11           C
ATOM   1116  C   GLY A 179      30.011  38.005   8.254  1.00 31.18           C
ATOM   1117  O   GLY A 179      30.042  36.819   7.991  1.00 30.80           O
ATOM   1118  N   LEU A 180      28.930  38.751   8.050  1.00 30.52           N
ATOM   1119  CA  LEU A 180      27.728  38.211   7.419  1.00 31.43           C
ATOM   1120  C   LEU A 180      27.886  37.903   5.932  1.00 31.37           C
ATOM   1121  O   LEU A 180      28.577  38.613   5.200  1.00 30.73           O
ATOM   1122  CB  LEU A 180      26.562  39.180   7.627  1.00 31.90           C
ATOM   1123  CG  LEU A 180      25.665  38.861   8.818  1.00 36.35           C
ATOM   1124  CD1 LEU A 180      26.418  38.277  10.007  1.00 37.81           C
ATOM   1125  CD2 LEU A 180      24.795  40.024   9.214  1.00 36.50           C
ATOM   1126  N   ASP A 181      27.197  36.852   5.496  1.00 33.48           N
ATOM   1127  CA  ASP A 181      27.251  36.418   4.117  1.00 34.90           C
ATOM   1128  C   ASP A 181      26.472  37.390   3.236  1.00 34.37           C
ATOM   1129  O   ASP A 181      25.509  38.039   3.694  1.00 33.69           O
ATOM   1130  CB  ASP A 181      26.657  34.998   3.964  1.00 36.77           C
ATOM   1131  CG  ASP A 181      27.645  33.882   4.329  1.00 41.63           C
ATOM   1132  OD1 ASP A 181      28.869  34.118   4.521  1.00 48.47           O
ATOM   1133  OD2 ASP A 181      27.257  32.704   4.453  1.00 50.71           O
ATOM   1134  N   ARG A 182      26.880  37.461   1.974  1.00 33.47           N
ATOM   1135  CA  ARG A 182      26.256  38.318   1.002  1.00 33.32           C
ATOM   1136  C   ARG A 182      24.744  38.107   0.932  1.00 31.55           C
ATOM   1137  O   ARG A 182      23.984  39.056   0.794  1.00 29.58           O
ATOM   1138  CB  ARG A 182      26.877  38.089  -0.369  1.00 34.00           C
ATOM   1139  CG  ARG A 182      26.192  38.851  -1.483  1.00 39.17           C
ATOM   1140  CD  ARG A 182      26.815  38.664  -2.832  1.00 46.83           C
ATOM   1141  NE  ARG A 182      26.148  37.603  -3.573  1.00 53.34           N
ATOM   1142  CZ  ARG A 182      26.765  36.780  -4.417  1.00 57.94           C
ATOM   1143  NH1 ARG A 182      28.076  36.897  -4.646  1.00 59.97           N
ATOM   1144  NH2 ARG A 182      26.065  35.836  -5.046  1.00 59.59           N
ATOM   1145  N   ASP A 183      24.289  36.868   1.010  1.00 31.07           N
ATOM   1146  CA  ASP A 183      22.878  36.632   0.774  1.00 31.07           C
ATOM   1147  C   ASP A 183      22.032  37.273   1.878  1.00 29.65           C
ATOM   1148  O   ASP A 183      20.955  37.773   1.618  1.00 27.98           O
ATOM   1149  CB  ASP A 183      22.592  35.148   0.636  1.00 32.71           C
ATOM   1150  CG  ASP A 183      23.120  34.571  -0.660  1.00 37.08           C
ATOM   1151  OD1 ASP A 183      23.410  35.333  -1.623  1.00 41.15           O
ATOM   1152  OD2 ASP A 183      23.290  33.338  -0.792  1.00 45.51           O
ATOM   1153  N   VAL A 184      22.537  37.250   3.102  1.00 28.40           N
ATOM   1154  CA  VAL A 184      21.844  37.855   4.221  1.00 28.15           C
ATOM   1155  C   VAL A 184      21.822  39.403   4.109  1.00 26.40           C
ATOM   1156  O   VAL A 184      20.785  40.046   4.308  1.00 25.30           O
ATOM   1157  CB  VAL A 184      22.533  37.460   5.501  1.00 28.88           C
ATOM   1158  CG1 VAL A 184      21.850  38.150   6.698  1.00 31.60           C
ATOM   1159  CG2 VAL A 184      22.511  35.905   5.636  1.00 31.24           C
ATOM   1160  N   ILE A 185      22.961  39.970   3.749  1.00 25.19           N
ATOM   1161  CA  ILE A 185      23.099  41.414   3.509  1.00 23.33           C
ATOM   1162  C   ILE A 185      22.123  41.852   2.412  1.00 23.71           C
ATOM   1163  O   ILE A 185      21.376  42.811   2.561  1.00 22.57           O
ATOM   1164  CB  ILE A 185      24.556  41.728   3.091  1.00 23.73           C
ATOM   1165  CG1 ILE A 185      25.496  41.333   4.253  1.00 22.65           C
ATOM   1166  CG2 ILE A 185      24.674  43.190   2.707  1.00 24.29           C
ATOM   1167  CD1 ILE A 185      26.968  41.457   3.947  1.00 24.90           C
ATOM   1168  N   VAL A 186      22.112  41.120   1.311  1.00 23.54           N
ATOM   1169  CA  VAL A 186      21.221  41.455   0.194  1.00 24.20           C
ATOM   1170  C   VAL A 186      19.738  41.300   0.563  1.00 23.20           C
ATOM   1171  O   VAL A 186      18.906  42.075   0.105  1.00 24.19           O
ATOM   1172  CB  VAL A 186      21.584  40.632  -1.092  1.00 24.98           C
ATOM   1173  CG1 VAL A 186      20.536  40.798  -2.126  1.00 25.74           C
ATOM   1174  CG2 VAL A 186      22.926  41.056  -1.632  1.00 26.57           C
ATOM   1175  N   ALA A 187      19.403  40.316   1.385  1.00 23.05           N
ATOM   1176  CA  ALA A 187      18.035  40.114   1.854  1.00 23.26           C
ATOM   1177  C   ALA A 187      17.523  41.382   2.547  1.00 22.44           C
ATOM   1178  O   ALA A 187      16.427  41.902   2.256  1.00 21.80           O
ATOM   1179  CB  ALA A 187      17.988  38.991   2.765  1.00 23.85           C
ATOM   1180  N   ASP A 188      18.365  41.932   3.397  1.00 21.03           N
ATOM   1181  CA  ASP A 188      17.956  43.118   4.149  1.00 21.44           C
ATOM   1182  C   ASP A 188      17.939  44.349   3.264  1.00 20.78           C
ATOM   1183  O   ASP A 188      17.042  45.182   3.399  1.00 22.01           O
ATOM   1184  CB  ASP A 188      18.867  43.342   5.384  1.00 21.37           C
ATOM   1185  CG  ASP A 188      18.655  44.730   6.018  1.00 20.13           C
ATOM   1186  OD1 ASP A 188      17.537  44.992   6.568  1.00 20.31           O
ATOM   1187  OD2 ASP A 188      19.531  45.625   5.871  1.00 20.46           O
ATOM   1188  N   TYR A 189      18.896  44.462   2.354  1.00 20.83           N
ATOM   1189  CA  TYR A 189      18.982  45.542   1.424  1.00 20.65           C
ATOM   1190  C   TYR A 189      17.722  45.582   0.535  1.00 21.46           C
ATOM   1191  O   TYR A 189      17.134  46.647   0.250  1.00 20.62           O
ATOM   1192  CB  TYR A 189      20.232  45.356   0.573  1.00 21.85           C
ATOM   1193  CG  TYR A 189      20.320  46.223  -0.605  1.00 20.57           C
ATOM   1194  CD1 TYR A 189      20.557  47.579  -0.481  1.00 21.58           C
ATOM   1195  CD2 TYR A 189      20.101  45.709  -1.895  1.00 22.49           C
ATOM   1196  CE1 TYR A 189      20.625  48.419  -1.568  1.00 21.66           C
ATOM   1197  CE2 TYR A 189      20.224  46.525  -2.974  1.00 21.83           C
ATOM   1198  CZ  TYR A 189      20.464  47.881  -2.821  1.00 24.21           C
ATOM   1199  OH  TYR A 189      20.532  48.727  -3.900  1.00 22.99           O
ATOM   1200  N   LEU A 190      17.306  44.409   0.093  1.00 22.68           N
ATOM   1201  CA  LEU A 190      16.176  44.366  -0.846  1.00 22.91           C
ATOM   1202  C   LEU A 190      14.848  44.614  -0.155  1.00 22.51           C
ATOM   1203  O   LEU A 190      13.859  44.905  -0.830  1.00 22.82           O
ATOM   1204  CB  LEU A 190      16.116  43.032  -1.594  1.00 22.51           C
ATOM   1205  CG  LEU A 190      17.243  42.740  -2.571  1.00 23.83           C
ATOM   1206  CD1 LEU A 190      17.090  41.334  -3.170  1.00 26.24           C
ATOM   1207  CD2 LEU A 190      17.260  43.763  -3.680  1.00 25.45           C
ATOM   1208  N   ARG A 191      14.793  44.581   1.175  1.00 22.46           N
ATOM   1209  CA  ARG A 191      13.551  44.901   1.906  1.00 23.66           C
ATOM   1210  C   ARG A 191      13.025  46.291   1.588  1.00 22.52           C
ATOM   1211  O   ARG A 191      11.824  46.554   1.794  1.00 21.76           O
ATOM   1212  CB  ARG A 191      13.735  44.792   3.436  1.00 24.11           C
ATOM   1213  CG  ARG A 191      13.442  43.454   4.094  1.00 28.95           C
ATOM   1214  CD  ARG A 191      11.992  43.184   4.307  1.00 32.01           C
ATOM   1215  NE  ARG A 191      11.316  44.092   5.243  1.00 32.10           N
ATOM   1216  CZ  ARG A 191      11.282  43.974   6.557  1.00 30.81           C
ATOM   1217  NH1 ARG A 191      11.897  42.983   7.200  1.00 30.74           N
ATOM   1218  NH2 ARG A 191      10.596  44.882   7.250  1.00 31.03           N
ATOM   1219  N   SER A 192      13.878  47.175   1.057  1.00 22.09           N
ATOM   1220  CA  SER A 192      13.454  48.520   0.682  1.00 21.85           C
ATOM   1221  C   SER A 192      12.449  48.512  -0.485  1.00 22.55           C
ATOM   1222  O   SER A 192      11.624  49.409  -0.607  1.00 22.52           O
ATOM   1223  CB  SER A 192      14.639  49.422   0.322  1.00 22.37           C
ATOM   1224  OG  SER A 192      15.440  49.674   1.478  1.00 19.57           O
ATOM   1225  N   ASN A 193      12.467  47.441  -1.269  1.00 22.93           N
ATOM   1226  CA  ASN A 193      11.435  47.276  -2.282  1.00 23.18           C
ATOM   1227  C   ASN A 193      10.046  47.185  -1.736  1.00 22.19           C
ATOM   1228  O   ASN A 193       9.094  47.629  -2.388  1.00 23.39           O
ATOM   1229  CB  ASN A 193      11.770  46.077  -3.193  1.00 24.30           C
ATOM   1230  CG  ASN A 193      12.901  46.382  -4.159  1.00 22.95           C
ATOM   1231  OD1 ASN A 193      13.046  47.516  -4.647  1.00 25.27           O
ATOM   1232  ND2 ASN A 193      13.716  45.370  -4.460  1.00 26.01           N
ATOM   1233  N   ASP A 194       9.878  46.683  -0.515  1.00 23.18           N
ATOM   1234  CA  ASP A 194       8.554  46.586   0.069  1.00 23.55           C
ATOM   1235  C   ASP A 194       7.939  47.961   0.370  1.00 24.28           C
ATOM   1236  O   ASP A 194       6.720  48.105   0.555  1.00 23.59           O
ATOM   1237  CB  ASP A 194       8.605  45.788   1.353  1.00 22.75           C
ATOM   1238  CG  ASP A 194       8.940  44.326   1.144  1.00 25.22           C
ATOM   1239  OD1 ASP A 194       8.949  43.843   0.006  1.00 25.19           O
ATOM   1240  OD2 ASP A 194       9.121  43.559   2.099  1.00 23.66           O
ATOM   1241  N   SER A 195       8.809  48.958   0.499  1.00 23.92           N
ATOM   1242  CA  SER A 195       8.409  50.341   0.846  1.00 24.19           C
ATOM   1243  C   SER A 195       8.150  51.237  -0.368  1.00 23.29           C
ATOM   1244  O   SER A 195       7.884  52.429  -0.240  1.00 23.19           O
ATOM   1245  CB  SER A 195       9.521  50.937   1.693  1.00 24.32           C
ATOM   1246  OG  SER A 195       9.614  50.250   2.916  1.00 28.65           O
ATOM   1247  N   VAL A 196       8.253  50.699  -1.568  1.00 23.63           N
ATOM   1248  CA  VAL A 196       8.152  51.513  -2.768  1.00 23.74           C
ATOM   1249  C   VAL A 196       6.773  52.193  -2.856  1.00 23.84           C
ATOM   1250  O   VAL A 196       6.718  53.397  -3.105  1.00 23.11           O
ATOM   1251  CB  VAL A 196       8.465  50.710  -4.027  1.00 24.47           C
ATOM   1252  CG1 VAL A 196       7.937  51.442  -5.305  1.00 25.54           C
ATOM   1253  CG2 VAL A 196       9.940  50.487  -4.154  1.00 24.64           C
ATOM   1254  N   PRO A 197       5.665  51.486  -2.598  1.00 24.39           N
ATOM   1255  CA  PRO A 197       4.365  52.177  -2.602  1.00 26.12           C
ATOM   1256  C   PRO A 197       4.278  53.337  -1.596  1.00 26.03           C
ATOM   1257  O   PRO A 197       3.742  54.399  -1.930  1.00 25.76           O
ATOM   1258  CB  PRO A 197       3.363  51.049  -2.246  1.00 26.62           C
ATOM   1259  CG  PRO A 197       4.042  49.824  -2.748  1.00 27.02           C
ATOM   1260  CD  PRO A 197       5.499  50.035  -2.334  1.00 24.67           C
ATOM   1261  N   GLN A 198       4.859  53.168  -0.408  1.00 25.67           N
ATOM   1262  CA  GLN A 198       4.860  54.206   0.603  1.00 26.81           C
ATOM   1263  C   GLN A 198       5.732  55.384   0.158  1.00 25.59           C
ATOM   1264  O   GLN A 198       5.341  56.545   0.339  1.00 25.72           O
ATOM   1265  CB  GLN A 198       5.290  53.638   1.967  1.00 27.38           C
ATOM   1266  CG  GLN A 198       4.303  52.591   2.567  1.00 32.15           C
ATOM   1267  CD  GLN A 198       4.129  51.228   1.742  1.00 36.37           C
ATOM   1268  OE1 GLN A 198       5.110  50.619   1.251  1.00 34.40           O
ATOM   1269  NE2 GLN A 198       2.854  50.774   1.608  1.00 38.42           N
ATOM   1270  N   LEU A 199       6.903  55.119  -0.416  1.00 25.48           N
ATOM   1271  CA  LEU A 199       7.726  56.192  -0.941  1.00 25.93           C
ATOM   1272  C   LEU A 199       6.996  56.972  -2.047  1.00 26.39           C
ATOM   1273  O   LEU A 199       7.020  58.180  -2.064  1.00 25.38           O
ATOM   1274  CB  LEU A 199       9.033  55.633  -1.490  1.00 25.66           C
ATOM   1275  CG  LEU A 199      10.009  56.625  -2.138  1.00 26.27           C
ATOM   1276  CD1 LEU A 199      10.369  57.706  -1.156  1.00 25.41           C
ATOM   1277  CD2 LEU A 199      11.238  55.923  -2.576  1.00 26.27           C
ATOM   1278  N   ARG A 200       6.361  56.258  -2.980  1.00 27.31           N
ATOM   1279  CA  ARG A 200       5.576  56.913  -3.993  1.00 28.53           C
ATOM   1280  C   ARG A 200       4.520  57.823  -3.397  1.00 27.54           C
ATOM   1281  O   ARG A 200       4.397  58.949  -3.851  1.00 27.50           O
ATOM   1282  CB  ARG A 200       4.933  55.879  -4.899  1.00 30.38           C
ATOM   1283  CG  ARG A 200       4.254  56.458  -6.055  1.00 35.16           C
ATOM   1284  CD  ARG A 200       3.786  55.386  -6.996  1.00 40.12           C
ATOM   1285  NE  ARG A 200       4.925  54.766  -7.678  1.00 42.95           N
ATOM   1286  CZ  ARG A 200       5.301  53.498  -7.537  1.00 42.61           C
ATOM   1287  NH1 ARG A 200       4.663  52.690  -6.702  1.00 43.48           N
ATOM   1288  NH2 ARG A 200       6.337  53.050  -8.228  1.00 44.51           N
ATOM   1289  N   ALA A 201       3.790  57.365  -2.357  1.00 26.90           N
ATOM   1290  CA  ALA A 201       2.764  58.200  -1.713  1.00 26.49           C
ATOM   1291  C   ALA A 201       3.406  59.407  -1.045  1.00 26.59           C
ATOM   1292  O   ALA A 201       2.866  60.516  -1.082  1.00 26.58           O
ATOM   1293  CB  ALA A 201       1.959  57.412  -0.715  1.00 25.11           C
ATOM   1294  N   ARG A 202       4.566  59.205  -0.419  1.00 25.66           N
ATOM   1295  CA  ARG A 202       5.245  60.296   0.240  1.00 26.93           C
ATOM   1296  C   ARG A 202       5.676  61.346  -0.767  1.00 26.93           C
ATOM   1297  O   ARG A 202       5.555  62.541  -0.489  1.00 25.79           O
ATOM   1298  CB  ARG A 202       6.493  59.779   0.996  1.00 28.25           C
ATOM   1299  CG  ARG A 202       6.179  58.965   2.213  1.00 33.01           C
ATOM   1300  CD  ARG A 202       5.563  59.663   3.399  1.00 37.73           C
ATOM   1301  NE  ARG A 202       6.165  60.971   3.687  1.00 42.55           N
ATOM   1302  CZ  ARG A 202       6.459  61.434   4.912  1.00 43.16           C
ATOM   1303  NH1 ARG A 202       6.216  60.682   6.005  1.00 42.56           N
ATOM   1304  NH2 ARG A 202       7.024  62.652   5.035  1.00 33.86           N
ATOM   1305  N   ILE A 203       6.154  60.912  -1.931  1.00 26.99           N
ATOM   1306  CA  ILE A 203       6.611  61.848  -2.965  1.00 27.49           C
ATOM   1307  C   ILE A 203       5.430  62.674  -3.480  1.00 28.29           C
ATOM   1308  O   ILE A 203       5.548  63.905  -3.624  1.00 27.82           O
ATOM   1309  CB  ILE A 203       7.322  61.125  -4.075  1.00 28.09           C
ATOM   1310  CG1 ILE A 203       8.719  60.741  -3.570  1.00 29.45           C
ATOM   1311  CG2 ILE A 203       7.408  61.983  -5.413  1.00 27.99           C
ATOM   1312  CD1 ILE A 203       9.368  59.619  -4.318  1.00 33.03           C
ATOM   1313  N   SER A 204       4.288  62.025  -3.678  1.00 27.96           N
ATOM   1314  CA  SER A 204       3.119  62.736  -4.184  1.00 28.04           C
ATOM   1315  C   SER A 204       2.683  63.793  -3.199  1.00 28.16           C
ATOM   1316  O   SER A 204       2.311  64.910  -3.605  1.00 28.25           O
ATOM   1317  CB  SER A 204       1.962  61.780  -4.504  1.00 27.64           C
ATOM   1318  OG  SER A 204       2.374  60.850  -5.476  1.00 30.18           O
ATOM   1319  N   GLU A 205       2.756  63.477  -1.904  1.00 27.27           N
ATOM   1320  CA  GLU A 205       2.419  64.414  -0.849  1.00 28.81           C
ATOM   1321  C   GLU A 205       3.430  65.594  -0.782  1.00 28.51           C
ATOM   1322  O   GLU A 205       3.035  66.755  -0.615  1.00 29.81           O
ATOM   1323  CB  GLU A 205       2.370  63.667   0.461  1.00 29.74           C
ATOM   1324  CG  GLU A 205       2.211  64.477   1.712  1.00 36.02           C
ATOM   1325  CD  GLU A 205       2.371  63.593   2.967  1.00 43.05           C
ATOM   1326  OE1 GLU A 205       2.477  62.333   2.835  1.00 43.65           O
ATOM   1327  OE2 GLU A 205       2.406  64.166   4.089  1.00 50.00           O
ATOM   1328  N   MET A 206       4.709  65.295  -0.984  1.00 28.00           N
ATOM   1329  CA  MET A 206       5.726  66.347  -1.029  1.00 27.28           C
ATOM   1330  C   MET A 206       5.494  67.315  -2.173  1.00 27.94           C
ATOM   1331  O   MET A 206       5.672  68.524  -2.010  1.00 27.36           O
ATOM   1332  CB  MET A 206       7.152  65.714  -1.123  1.00 27.25           C
ATOM   1333  CG  MET A 206       7.505  65.006   0.147  1.00 27.05           C
ATOM   1334  SD  MET A 206       8.940  63.923  -0.029  1.00 27.23           S
ATOM   1335  CE  MET A 206       8.998  63.310   1.731  1.00 28.09           C
ATOM   1336  N   ILE A 207       5.092  66.772  -3.319  1.00 29.22           N
ATOM   1337  CA  ILE A 207       4.824  67.562  -4.510  1.00 29.58           C
ATOM   1338  C   ILE A 207       3.606  68.471  -4.277  1.00 30.18           C
ATOM   1339  O   ILE A 207       3.601  69.645  -4.680  1.00 28.59           O
ATOM   1340  CB  ILE A 207       4.648  66.646  -5.716  1.00 30.41           C
ATOM   1341  CG1 ILE A 207       6.009  66.141  -6.204  1.00 32.30           C
ATOM   1342  CG2 ILE A 207       3.943  67.367  -6.864  1.00 31.08           C
ATOM   1343  CD1 ILE A 207       5.930  65.029  -7.167  1.00 33.10           C
ATOM   1344  N   GLN A 208       2.586  67.940  -3.614  1.00 29.64           N
ATOM   1345  CA  GLN A 208       1.415  68.721  -3.231  1.00 30.71           C
ATOM   1346  C   GLN A 208       1.799  69.877  -2.302  1.00 29.77           C
ATOM   1347  O   GLN A 208       1.213  70.964  -2.365  1.00 30.52           O
ATOM   1348  CB  GLN A 208       0.345  67.845  -2.558  1.00 30.05           C
ATOM   1349  CG  GLN A 208      -0.360  68.557  -1.316  1.00 36.27           C
ATOM   1350  CD  GLN A 208      -1.568  69.276  -1.697  1.00 42.37           C
ATOM   1351  OE1 GLN A 208      -2.081  69.022  -2.792  1.00 53.37           O
ATOM   1352  NE2 GLN A 208      -2.071  70.195  -0.832  1.00 38.28           N
ATOM   1353  N   GLN A 209       2.776  69.641  -1.418  1.00 29.19           N
ATOM   1354  CA  GLN A 209       3.254  70.616  -0.496  1.00 28.05           C
ATOM   1355  C   GLN A 209       4.454  71.438  -1.005  1.00 26.36           C
ATOM   1356  O   GLN A 209       5.077  72.111  -0.213  1.00 26.13           O
ATOM   1357  CB  GLN A 209       3.663  69.913   0.841  1.00 28.70           C
ATOM   1358  CG  GLN A 209       2.486  69.178   1.532  1.00 31.80           C
ATOM   1359  CD  GLN A 209       2.926  68.111   2.513  1.00 39.26           C
ATOM   1360  OE1 GLN A 209       4.117  68.009   2.839  1.00 44.02           O
ATOM   1361  NE2 GLN A 209       1.976  67.266   2.950  1.00 43.68           N
ATOM   1362  N   ARG A 210       4.719  71.435  -2.303  1.00 26.63           N
ATOM   1363  CA  ARG A 210       5.975  72.001  -2.823  1.00 27.68           C
ATOM   1364  C   ARG A 210       6.081  73.522  -2.641  1.00 28.32           C
ATOM   1365  O   ARG A 210       7.167  74.068  -2.709  1.00 28.23           O
ATOM   1366  CB  ARG A 210       6.178  71.657  -4.275  1.00 27.92           C
ATOM   1367  CG  ARG A 210       5.221  72.288  -5.292  1.00 28.71           C
ATOM   1368  CD  ARG A 210       5.316  71.658  -6.638  1.00 30.87           C
ATOM   1369  NE  ARG A 210       4.412  72.272  -7.602  1.00 32.86           N
ATOM   1370  CZ  ARG A 210       3.098  72.063  -7.667  1.00 33.11           C
ATOM   1371  NH1 ARG A 210       2.495  71.208  -6.838  1.00 30.56           N
ATOM   1372  NH2 ARG A 210       2.376  72.713  -8.582  1.00 32.86           N
ATOM   1373  N   PHE A 211       4.960  74.195  -2.414  1.00 28.98           N
ATOM   1374  CA  PHE A 211       5.015  75.638  -2.116  1.00 29.76           C
ATOM   1375  C   PHE A 211       5.162  75.948  -0.642  1.00 30.33           C
ATOM   1376  O   PHE A 211       5.391  77.097  -0.279  1.00 32.16           O
ATOM   1377  CB  PHE A 211       3.796  76.350  -2.685  1.00 29.34           C
ATOM   1378  CG  PHE A 211       3.678  76.200  -4.166  1.00 28.38           C
ATOM   1379  CD1 PHE A 211       4.674  76.626  -4.986  1.00 30.46           C
ATOM   1380  CD2 PHE A 211       2.613  75.578  -4.721  1.00 30.92           C
ATOM   1381  CE1 PHE A 211       4.561  76.456  -6.358  1.00 28.14           C
ATOM   1382  CE2 PHE A 211       2.531  75.387  -6.068  1.00 31.71           C
ATOM   1383  CZ  PHE A 211       3.480  75.848  -6.875  1.00 30.55           C
ATOM   1384  N   ASP A 212       5.010  74.936   0.202  1.00 31.09           N
ATOM   1385  CA  ASP A 212       5.147  75.072   1.648  1.00 31.23           C
ATOM   1386  C   ASP A 212       6.575  74.666   2.099  1.00 31.69           C
ATOM   1387  O   ASP A 212       7.127  75.218   3.097  1.00 31.01           O
ATOM   1388  CB  ASP A 212       4.134  74.154   2.369  1.00 32.37           C
ATOM   1389  CG  ASP A 212       2.681  74.403   1.941  1.00 36.13           C
ATOM   1390  OD1 ASP A 212       2.200  75.529   2.143  1.00 37.75           O
ATOM   1391  OD2 ASP A 212       1.959  73.530   1.408  1.00 40.69           O
ATOM   1392  N   THR A 213       7.120  73.690   1.370  1.00 30.39           N
ATOM   1393  CA  THR A 213       8.411  73.008   1.662  1.00 30.60           C
ATOM   1394  C   THR A 213       9.067  72.651   0.355  1.00 30.13           C
ATOM   1395  O   THR A 213       8.477  71.953  -0.469  1.00 30.25           O
ATOM   1396  CB  THR A 213       8.188  71.708   2.454  1.00 30.13           C
ATOM   1397  OG1 THR A 213       7.463  71.989   3.650  1.00 32.15           O
ATOM   1398  CG2 THR A 213       9.522  71.143   2.957  1.00 30.30           C
ATOM   1399  N   GLU A 214      10.300  73.125   0.153  1.00 30.29           N
ATOM   1400  CA  GLU A 214      11.033  72.834  -1.064  1.00 31.06           C
ATOM   1401  C   GLU A 214      11.306  71.367  -1.175  1.00 30.89           C
ATOM   1402  O   GLU A 214      11.520  70.698  -0.168  1.00 31.30           O
ATOM   1403  CB  GLU A 214      12.391  73.508  -1.073  1.00 32.41           C
ATOM   1404  CG  GLU A 214      12.392  75.004  -1.186  1.00 37.52           C
ATOM   1405  CD  GLU A 214      13.820  75.510  -1.210  1.00 42.88           C
ATOM   1406  OE1 GLU A 214      14.617  75.117  -2.123  1.00 43.33           O
ATOM   1407  OE2 GLU A 214      14.154  76.240  -0.265  1.00 48.35           O
ATOM   1408  N   LEU A 215      11.317  70.901  -2.408  1.00 31.06           N
ATOM   1409  CA  LEU A 215      11.446  69.489  -2.697  1.00 31.09           C
ATOM   1410  C   LEU A 215      12.879  69.071  -2.506  1.00 32.13           C
ATOM   1411  O   LEU A 215      13.797  69.802  -2.888  1.00 31.61           O
ATOM   1412  CB  LEU A 215      11.054  69.223  -4.122  1.00 30.71           C
ATOM   1413  CG  LEU A 215       9.566  69.401  -4.434  1.00 32.06           C
ATOM   1414  CD1 LEU A 215       9.328  69.110  -5.884  1.00 32.82           C
ATOM   1415  CD2 LEU A 215       8.719  68.501  -3.542  1.00 33.27           C
ATOM   1416  N   ALA A 216      13.075  67.881  -1.947  1.00 31.41           N
ATOM   1417  CA  ALA A 216      14.421  67.341  -1.864  1.00 31.30           C
ATOM   1418  C   ALA A 216      14.875  67.065  -3.296  1.00 30.55           C
ATOM   1419  O   ALA A 216      14.100  66.656  -4.143  1.00 30.67           O
ATOM   1420  CB  ALA A 216      14.459  66.087  -1.003  1.00 31.54           C
ATOM   1421  N   PRO A 217      16.143  67.290  -3.604  1.00 31.14           N
ATOM   1422  CA  PRO A 217      16.612  67.096  -4.981  1.00 31.17           C
ATOM   1423  C   PRO A 217      16.367  65.719  -5.573  1.00 31.81           C
ATOM   1424  O   PRO A 217      16.140  65.590  -6.796  1.00 28.90           O
ATOM   1425  CB  PRO A 217      18.117  67.402  -4.854  1.00 31.83           C
ATOM   1426  CG  PRO A 217      18.137  68.342  -3.825  1.00 31.27           C
ATOM   1427  CD  PRO A 217      17.219  67.794  -2.750  1.00 31.55           C
ATOM   1428  N   GLU A 218      16.351  64.675  -4.742  1.00 30.48           N
ATOM   1429  CA  GLU A 218      16.076  63.350  -5.279  1.00 31.33           C
ATOM   1430  C   GLU A 218      14.675  63.220  -5.825  1.00 30.98           C
ATOM   1431  O   GLU A 218      14.459  62.402  -6.697  1.00 30.89           O
ATOM   1432  CB  GLU A 218      16.267  62.237  -4.224  1.00 30.75           C
ATOM   1433  CG  GLU A 218      17.719  61.943  -4.005  1.00 30.53           C
ATOM   1434  CD  GLU A 218      17.956  60.886  -2.946  1.00 25.36           C
ATOM   1435  OE1 GLU A 218      16.988  60.327  -2.345  1.00 26.00           O
ATOM   1436  OE2 GLU A 218      19.144  60.631  -2.728  1.00 25.08           O
ATOM   1437  N   VAL A 219      13.721  63.917  -5.213  1.00 32.19           N
ATOM   1438  CA  VAL A 219      12.334  63.902  -5.694  1.00 34.04           C
ATOM   1439  C   VAL A 219      12.288  64.363  -7.147  1.00 35.39           C
ATOM   1440  O   VAL A 219      11.640  63.736  -7.982  1.00 34.31           O
ATOM   1441  CB  VAL A 219      11.423  64.775  -4.860  1.00 34.43           C
ATOM   1442  CG1 VAL A 219      10.068  64.900  -5.526  1.00 34.76           C
ATOM   1443  CG2 VAL A 219      11.298  64.209  -3.458  1.00 34.54           C
ATOM   1444  N   VAL A 220      13.019  65.433  -7.445  1.00 36.18           N
ATOM   1445  CA  VAL A 220      13.052  65.963  -8.814  1.00 38.37           C
ATOM   1446  C   VAL A 220      13.620  64.934  -9.784  1.00 39.16           C
ATOM   1447  O   VAL A 220      13.033  64.652 -10.815  1.00 39.66           O
ATOM   1448  CB  VAL A 220      13.859  67.281  -8.886  1.00 38.68           C
ATOM   1449  CG1 VAL A 220      13.838  67.860 -10.313  1.00 41.52           C
ATOM   1450  CG2 VAL A 220      13.355  68.285  -7.848  1.00 37.74           C
ATOM   1451  N   THR A 221      14.741  64.325  -9.430  1.00 39.88           N
ATOM   1452  CA  THR A 221      15.342  63.323 -10.285  1.00 40.62           C
ATOM   1453  C   THR A 221      14.463  62.089 -10.409  1.00 41.03           C
ATOM   1454  O   THR A 221      14.280  61.589 -11.511  1.00 42.61           O
ATOM   1455  CB  THR A 221      16.756  62.976  -9.767  1.00 40.69           C
ATOM   1456  OG1 THR A 221      17.506  64.187  -9.603  1.00 40.80           O
ATOM   1457  CG2 THR A 221      17.530  62.239 -10.804  1.00 41.46           C
ATOM   1458  N   PHE A 222      13.852  61.632  -9.314  1.00 41.42           N
ATOM   1459  CA  PHE A 222      13.008  60.452  -9.387  1.00 41.48           C
ATOM   1460  C   PHE A 222      11.760  60.715 -10.240  1.00 42.86           C
ATOM   1461  O   PHE A 222      11.324  59.828 -10.978  1.00 42.94           O
ATOM   1462  CB  PHE A 222      12.581  59.975  -8.014  1.00 41.32           C
ATOM   1463  CG  PHE A 222      13.723  59.446  -7.161  1.00 38.91           C
ATOM   1464  CD1 PHE A 222      14.981  59.183  -7.696  1.00 38.78           C
ATOM   1465  CD2 PHE A 222      13.519  59.229  -5.820  1.00 38.98           C
ATOM   1466  CE1 PHE A 222      16.024  58.701  -6.874  1.00 40.36           C
ATOM   1467  CE2 PHE A 222      14.548  58.740  -5.006  1.00 37.41           C
ATOM   1468  CZ  PHE A 222      15.789  58.486  -5.532  1.00 37.73           C
ATOM   1469  N   THR A 223      11.216  61.918 -10.120  1.00 43.59           N
ATOM   1470  CA  THR A 223      10.093  62.364 -10.948  1.00 45.18           C
ATOM   1471  C   THR A 223      10.442  62.378 -12.429  1.00 46.65           C
ATOM   1472  O   THR A 223       9.661  61.871 -13.234  1.00 47.13           O
ATOM   1473  CB  THR A 223       9.628  63.745 -10.507  1.00 44.96           C
ATOM   1474  OG1 THR A 223       8.992  63.647  -9.233  1.00 43.46           O
ATOM   1475  CG2 THR A 223       8.527  64.284 -11.449  1.00 45.93           C
ATOM   1476  N   LYS A 224      11.611  62.912 -12.787  1.00 48.42           N
ATOM   1477  CA  LYS A 224      12.080  62.864 -14.181  1.00 49.96           C
ATOM   1478  C   LYS A 224      12.159  61.431 -14.673  1.00 50.79           C
ATOM   1479  O   LYS A 224      11.785  61.134 -15.810  1.00 50.74           O
ATOM   1480  CB  LYS A 224      13.445  63.517 -14.360  1.00 50.20           C
ATOM   1481  CG  LYS A 224      13.481  64.962 -13.934  1.00 52.29           C
ATOM   1482  CD  LYS A 224      14.577  65.740 -14.646  1.00 54.50           C
ATOM   1483  CE  LYS A 224      15.962  65.467 -14.084  1.00 55.81           C
ATOM   1484  NZ  LYS A 224      16.585  66.727 -13.581  1.00 57.33           N
ATOM   1485  N   ALA A 225      12.611  60.527 -13.808  1.00 51.10           N
ATOM   1486  CA  ALA A 225      12.783  59.129 -14.198  1.00 51.75           C
ATOM   1487  C   ALA A 225      11.436  58.424 -14.283  1.00 51.65           C
ATOM   1488  O   ALA A 225      11.396  57.208 -14.453  1.00 52.49           O
ATOM   1489  CB  ALA A 225      13.716  58.398 -13.220  1.00 51.83           C
ATOM   1490  N   ARG A 226      10.356  59.200 -14.156  1.00 51.60           N
ATOM   1491  CA  ARG A 226       8.981  58.742 -14.324  1.00 51.88           C
ATOM   1492  C   ARG A 226       8.627  57.776 -13.216  1.00 51.93           C
ATOM   1493  O   ARG A 226       8.047  56.709 -13.471  1.00 52.36           O
ATOM   1494  CB  ARG A 226       8.767  58.105 -15.707  1.00 52.34           C
ATOM   1495  N   LEU A 227       8.998  58.189 -11.992  1.00 51.29           N
ATOM   1496  CA  LEU A 227       8.872  57.426 -10.752  1.00 50.26           C
ATOM   1497  C   LEU A 227       8.909  55.917 -10.947  1.00 49.70           C
ATOM   1498  O   LEU A 227       8.119  55.191 -10.368  1.00 50.20           O
ATOM   1499  CB  LEU A 227       7.643  57.880  -9.968  1.00 50.38           C
ATOM   1500  CG  LEU A 227       7.609  59.378  -9.604  1.00 50.39           C
ATOM   1501  CD1 LEU A 227       6.234  59.771  -9.148  1.00 50.04           C
ATOM   1502  CD2 LEU A 227       8.622  59.776  -8.512  1.00 50.73           C
ATOM   1503  N   SER A 228       9.867  55.493 -11.772  1.00 49.60           N
ATOM   1504  CA  SER A 228      10.256  54.106 -12.032  1.00 49.43           C
ATOM   1505  C   SER A 228      10.401  53.272 -10.741  1.00 49.45           C
ATOM   1506  O   SER A 228      10.736  53.817  -9.684  1.00 48.77           O
ATOM   1507  CB  SER A 228      11.614  54.142 -12.752  1.00 49.82           C
ATOM   1508  OG  SER A 228      11.806  53.063 -13.635  1.00 50.92           O
ATOM   1509  N   ASP A 229      10.145  51.968 -10.818  1.00 48.31           N
ATOM   1510  CA  ASP A 229      10.499  51.062  -9.716  1.00 47.87           C
ATOM   1511  C   ASP A 229      12.030  50.967  -9.637  1.00 46.68           C
ATOM   1512  O   ASP A 229      12.582  50.685  -8.570  1.00 47.40           O
ATOM   1513  CB  ASP A 229       9.860  49.662  -9.866  1.00 48.14           C
ATOM   1514  CG  ASP A 229       8.452  49.558  -9.241  1.00 49.70           C
ATOM   1515  OD1 ASP A 229       7.894  50.553  -8.733  1.00 52.96           O
ATOM   1516  OD2 ASP A 229       7.797  48.496  -9.208  1.00 53.43           O
ATOM   1517  N   GLY A 230      12.714  51.219 -10.753  1.00 44.58           N
ATOM   1518  CA  GLY A 230      14.162  51.252 -10.799  1.00 42.82           C
ATOM   1519  C   GLY A 230      14.811  52.397 -10.046  1.00 40.71           C
ATOM   1520  O   GLY A 230      15.952  52.246  -9.624  1.00 40.85           O
ATOM   1521  N   VAL A 231      14.129  53.542  -9.918  1.00 38.56           N
ATOM   1522  CA  VAL A 231      14.622  54.645  -9.070  1.00 36.72           C
ATOM   1523  C   VAL A 231      14.001  54.656  -7.674  1.00 34.29           C
ATOM   1524  O   VAL A 231      14.638  55.133  -6.735  1.00 33.70           O
ATOM   1525  CB  VAL A 231      14.445  56.086  -9.636  1.00 36.69           C
ATOM   1526  CG1 VAL A 231      15.280  56.293 -10.930  1.00 37.73           C
ATOM   1527  CG2 VAL A 231      12.986  56.457  -9.800  1.00 36.85           C
ATOM   1528  N   LEU A 232      12.772  54.166  -7.535  1.00 31.75           N
ATOM   1529  CA  LEU A 232      12.119  54.151  -6.228  1.00 29.71           C
ATOM   1530  C   LEU A 232      12.484  52.935  -5.388  1.00 28.14           C
ATOM   1531  O   LEU A 232      12.328  52.979  -4.170  1.00 26.34           O
ATOM   1532  CB  LEU A 232      10.592  54.264  -6.349  1.00 30.44           C
ATOM   1533  CG  LEU A 232      10.043  55.545  -6.967  1.00 32.14           C
ATOM   1534  CD1 LEU A 232       8.518  55.646  -6.702  1.00 34.87           C
ATOM   1535  CD2 LEU A 232      10.744  56.785  -6.466  1.00 31.93           C
ATOM   1536  N   GLY A 233      12.924  51.863  -6.053  1.00 26.85           N
ATOM   1537  CA  GLY A 233      13.321  50.624  -5.420  1.00 27.38           C
ATOM   1538  C   GLY A 233      14.845  50.452  -5.424  1.00 26.33           C
ATOM   1539  O   GLY A 233      15.581  51.412  -5.615  1.00 26.22           O
ATOM   1540  N   VAL A 234      15.273  49.210  -5.275  1.00 25.84           N
ATOM   1541  CA  VAL A 234      16.670  48.842  -5.263  1.00 26.42           C
ATOM   1542  C   VAL A 234      16.804  47.489  -5.947  1.00 27.93           C
ATOM   1543  O   VAL A 234      15.834  46.707  -6.036  1.00 28.04           O
ATOM   1544  CB  VAL A 234      17.194  48.707  -3.808  1.00 26.17           C
ATOM   1545  CG1 VAL A 234      17.265  50.083  -3.140  1.00 24.73           C
ATOM   1546  CG2 VAL A 234      16.337  47.750  -2.997  1.00 25.97           C
ATOM   1547  N   ARG A 235      18.020  47.203  -6.349  1.00 30.10           N
ATOM   1548  CA  ARG A 235      18.348  45.942  -7.013  1.00 31.47           C
ATOM   1549  C   ARG A 235      19.734  45.494  -6.578  1.00 30.80           C
ATOM   1550  O   ARG A 235      20.605  46.331  -6.349  1.00 30.53           O
ATOM   1551  CB  ARG A 235      18.386  46.164  -8.526  1.00 33.52           C
ATOM   1552  CG  ARG A 235      17.150  46.832  -9.147  1.00 40.16           C
ATOM   1553  CD  ARG A 235      17.258  47.167 -10.651  1.00 47.62           C
ATOM   1554  NE  ARG A 235      18.516  46.713 -11.258  1.00 54.54           N
ATOM   1555  CZ  ARG A 235      18.650  45.697 -12.130  1.00 59.66           C
ATOM   1556  NH1 ARG A 235      17.589  44.987 -12.538  1.00 60.58           N
ATOM   1557  NH2 ARG A 235      19.869  45.396 -12.609  1.00 61.54           N
ATOM   1558  N   ALA A 236      19.971  44.192  -6.517  1.00 30.97           N
ATOM   1559  CA  ALA A 236      21.275  43.677  -6.022  1.00 30.70           C
ATOM   1560  C   ALA A 236      22.453  44.218  -6.876  1.00 31.42           C
ATOM   1561  O   ALA A 236      23.549  44.416  -6.358  1.00 29.99           O
ATOM   1562  CB  ALA A 236      21.277  42.146  -5.963  1.00 31.17           C
ATOM   1563  N   GLU A 237      22.190  44.505  -8.159  1.00 32.23           N
ATOM   1564  CA  GLU A 237      23.212  45.016  -9.089  1.00 33.46           C
ATOM   1565  C   GLU A 237      23.761  46.387  -8.668  1.00 32.66           C
ATOM   1566  O   GLU A 237      24.953  46.692  -8.888  1.00 31.90           O
ATOM   1567  CB  GLU A 237      22.642  45.135 -10.521  1.00 34.67           C
ATOM   1568  CG  GLU A 237      22.395  43.785 -11.184  1.00 38.54           C
ATOM   1569  CD  GLU A 237      21.055  43.107 -10.828  1.00 43.51           C
ATOM   1570  OE1 GLU A 237      20.308  43.524  -9.893  1.00 41.01           O
ATOM   1571  OE2 GLU A 237      20.745  42.095 -11.495  1.00 46.55           O
ATOM   1572  N   TYR A 238      22.898  47.209  -8.069  1.00 31.29           N
ATOM   1573  CA  TYR A 238      23.321  48.517  -7.567  1.00 31.27           C
ATOM   1574  C   TYR A 238      24.375  48.354  -6.474  1.00 30.40           C
ATOM   1575  O   TYR A 238      25.476  48.891  -6.561  1.00 31.34           O
ATOM   1576  CB  TYR A 238      22.139  49.284  -6.991  1.00 31.05           C
ATOM   1577  CG  TYR A 238      20.989  49.621  -7.941  1.00 32.57           C
ATOM   1578  CD1 TYR A 238      21.095  49.457  -9.337  1.00 35.68           C
ATOM   1579  CD2 TYR A 238      19.801  50.130  -7.439  1.00 32.38           C
ATOM   1580  CE1 TYR A 238      20.043  49.780 -10.167  1.00 35.81           C
ATOM   1581  CE2 TYR A 238      18.752  50.458  -8.267  1.00 33.39           C
ATOM   1582  CZ  TYR A 238      18.880  50.290  -9.646  1.00 34.82           C
ATOM   1583  OH  TYR A 238      17.808  50.638 -10.460  1.00 35.61           O
ATOM   1584  N   LEU A 239      24.024  47.591  -5.451  1.00 29.67           N
ATOM   1585  CA  LEU A 239      24.918  47.383  -4.291  1.00 30.28           C
ATOM   1586  C   LEU A 239      26.217  46.705  -4.743  1.00 31.13           C
ATOM   1587  O   LEU A 239      27.292  47.071  -4.310  1.00 30.90           O
ATOM   1588  CB  LEU A 239      24.182  46.568  -3.237  1.00 30.16           C
ATOM   1589  CG  LEU A 239      24.938  46.430  -1.914  1.00 28.98           C
ATOM   1590  CD1 LEU A 239      25.129  47.780  -1.276  1.00 29.81           C
ATOM   1591  CD2 LEU A 239      24.158  45.487  -1.013  1.00 27.17           C
ATOM   1592  N   ALA A 240      26.101  45.771  -5.695  1.00 31.73           N
ATOM   1593  CA  ALA A 240      27.271  45.052  -6.229  1.00 32.22           C
ATOM   1594  C   ALA A 240      28.225  45.964  -6.996  1.00 32.14           C
ATOM   1595  O   ALA A 240      29.441  45.754  -6.944  1.00 33.88           O
ATOM   1596  CB  ALA A 240      26.815  43.880  -7.068  1.00 32.30           C
ATOM   1597  N   ALA A 241      27.698  46.994  -7.654  1.00 31.53           N
ATOM   1598  CA  ALA A 241      28.521  48.001  -8.322  1.00 32.27           C
ATOM   1599  C   ALA A 241      29.360  48.786  -7.330  1.00 32.14           C
ATOM   1600  O   ALA A 241      30.548  48.993  -7.542  1.00 32.00           O
ATOM   1601  CB  ALA A 241      27.682  48.946  -9.135  1.00 32.11           C
ATOM   1602  N   ALA A 242      28.750  49.224  -6.232  1.00 31.37           N
ATOM   1603  CA  ALA A 242      29.490  49.944  -5.194  1.00 30.38           C
ATOM   1604  C   ALA A 242      30.582  49.072  -4.594  1.00 30.52           C
ATOM   1605  O   ALA A 242      31.700  49.535  -4.302  1.00 30.22           O
ATOM   1606  CB  ALA A 242      28.513  50.407  -4.082  1.00 31.09           C
ATOM   1607  N   ARG A 243      30.258  47.811  -4.394  1.00 31.08           N
ATOM   1608  CA  ARG A 243      31.134  46.896  -3.712  1.00 32.26           C
ATOM   1609  C   ARG A 243      32.336  46.570  -4.595  1.00 33.36           C
ATOM   1610  O   ARG A 243      33.455  46.435  -4.122  1.00 32.89           O
ATOM   1611  CB  ARG A 243      30.359  45.642  -3.390  1.00 32.83           C
ATOM   1612  CG  ARG A 243      31.032  44.714  -2.457  1.00 34.28           C
ATOM   1613  CD  ARG A 243      31.453  45.326  -1.108  1.00 33.84           C
ATOM   1614  NE  ARG A 243      32.282  44.353  -0.427  1.00 32.53           N
ATOM   1615  CZ  ARG A 243      33.557  44.116  -0.720  1.00 33.23           C
ATOM   1616  NH1 ARG A 243      34.177  44.818  -1.648  1.00 33.15           N
ATOM   1617  NH2 ARG A 243      34.222  43.177  -0.072  1.00 32.43           N
ATOM   1618  N   GLN A 244      32.076  46.446  -5.893  1.00 35.12           N
ATOM   1619  CA  GLN A 244      33.138  46.219  -6.873  1.00 36.56           C
ATOM   1620  C   GLN A 244      34.113  47.393  -6.887  1.00 36.07           C
ATOM   1621  O   GLN A 244      35.333  47.195  -6.911  1.00 35.99           O
ATOM   1622  CB  GLN A 244      32.489  46.051  -8.261  1.00 37.67           C
ATOM   1623  CG  GLN A 244      33.463  45.748  -9.406  1.00 42.60           C
ATOM   1624  CD  GLN A 244      32.758  45.727 -10.755  1.00 48.29           C
ATOM   1625  OE1 GLN A 244      31.596  46.182 -10.883  1.00 52.73           O
ATOM   1626  NE2 GLN A 244      33.446  45.198 -11.767  1.00 52.14           N
ATOM   1627  N   THR A 245      33.584  48.611  -6.851  1.00 35.70           N
ATOM   1628  CA  THR A 245      34.402  49.823  -6.821  1.00 35.59           C
ATOM   1629  C   THR A 245      35.313  49.894  -5.586  1.00 34.42           C
ATOM   1630  O   THR A 245      36.455  50.375  -5.669  1.00 34.91           O
ATOM   1631  CB  THR A 245      33.516  51.073  -6.879  1.00 35.58           C
ATOM   1632  OG1 THR A 245      32.847  51.148  -8.138  1.00 37.63           O
ATOM   1633  CG2 THR A 245      34.330  52.339  -6.794  1.00 36.61           C
ATOM   1634  N   ILE A 246      34.831  49.415  -4.440  1.00 33.15           N
ATOM   1635  CA  ILE A 246      35.680  49.321  -3.265  1.00 31.50           C
ATOM   1636  C   ILE A 246      36.896  48.427  -3.557  1.00 31.97           C
ATOM   1637  O   ILE A 246      38.005  48.784  -3.231  1.00 31.69           O
ATOM   1638  CB  ILE A 246      34.879  48.795  -2.059  1.00 31.82           C
ATOM   1639  CG1 ILE A 246      33.977  49.932  -1.538  1.00 29.69           C
ATOM   1640  CG2 ILE A 246      35.796  48.201  -0.981  1.00 30.81           C
ATOM   1641  CD1 ILE A 246      32.837  49.459  -0.656  1.00 30.51           C
ATOM   1642  N   ASP A 247      36.684  47.275  -4.156  1.00 32.90           N
ATOM   1643  CA  ASP A 247      37.813  46.370  -4.449  1.00 34.78           C
ATOM   1644  C   ASP A 247      38.766  47.008  -5.472  1.00 35.46           C
ATOM   1645  O   ASP A 247      39.988  46.933  -5.330  1.00 35.38           O
ATOM   1646  CB  ASP A 247      37.301  45.027  -4.990  1.00 34.92           C
ATOM   1647  CG  ASP A 247      36.675  44.151  -3.924  1.00 36.92           C
ATOM   1648  OD1 ASP A 247      36.819  44.436  -2.710  1.00 37.67           O
ATOM   1649  OD2 ASP A 247      36.038  43.112  -4.213  1.00 42.31           O
ATOM   1650  N   GLU A 248      38.203  47.666  -6.464  1.00 37.21           N
ATOM   1651  CA  GLU A 248      39.006  48.248  -7.545  1.00 38.94           C
ATOM   1652  C   GLU A 248      39.809  49.418  -7.057  1.00 39.12           C
ATOM   1653  O   GLU A 248      40.948  49.598  -7.479  1.00 39.59           O
ATOM   1654  CB  GLU A 248      38.135  48.663  -8.738  1.00 39.55           C
ATOM   1655  CG  GLU A 248      37.483  47.483  -9.431  1.00 42.56           C
ATOM   1656  CD  GLU A 248      36.530  47.876 -10.547  1.00 46.32           C
ATOM   1657  OE1 GLU A 248      36.287  49.095 -10.755  1.00 49.65           O
ATOM   1658  OE2 GLU A 248      36.019  46.946 -11.217  1.00 48.78           O
ATOM   1659  N   THR A 249      39.258  50.193  -6.126  1.00 39.11           N
ATOM   1660  CA  THR A 249      39.907  51.412  -5.674  1.00 38.71           C
ATOM   1661  C   THR A 249      40.781  51.241  -4.436  1.00 38.04           C
ATOM   1662  O   THR A 249      41.827  51.876  -4.342  1.00 38.32           O
ATOM   1663  CB  THR A 249      38.846  52.500  -5.448  1.00 39.01           C
ATOM   1664  OG1 THR A 249      38.186  52.762  -6.685  1.00 39.34           O
ATOM   1665  CG2 THR A 249      39.454  53.822  -5.090  1.00 38.52           C
ATOM   1666  N   TYR A 250      40.360  50.398  -3.499  1.00 36.79           N
ATOM   1667  CA  TYR A 250      41.019  50.247  -2.198  1.00 35.79           C
ATOM   1668  C   TYR A 250      41.621  48.872  -1.996  1.00 35.49           C
ATOM   1669  O   TYR A 250      42.228  48.605  -0.945  1.00 36.04           O
ATOM   1670  CB  TYR A 250      40.019  50.540  -1.067  1.00 35.15           C
ATOM   1671  CG  TYR A 250      39.458  51.934  -1.158  1.00 33.25           C
ATOM   1672  CD1 TYR A 250      40.076  52.989  -0.547  1.00 31.09           C
ATOM   1673  CD2 TYR A 250      38.335  52.194  -1.925  1.00 30.86           C
ATOM   1674  CE1 TYR A 250      39.584  54.291  -0.671  1.00 32.66           C
ATOM   1675  CE2 TYR A 250      37.844  53.465  -2.059  1.00 32.09           C
ATOM   1676  CZ  TYR A 250      38.456  54.506  -1.439  1.00 32.57           C
ATOM   1677  OH  TYR A 250      37.899  55.743  -1.567  1.00 34.18           O
ATOM   1678  N   GLY A 251      41.436  48.003  -2.989  1.00 35.44           N
ATOM   1679  CA  GLY A 251      41.905  46.636  -2.952  1.00 35.53           C
ATOM   1680  C   GLY A 251      40.986  45.615  -2.338  1.00 34.99           C
ATOM   1681  O   GLY A 251      40.870  44.489  -2.830  1.00 35.60           O
ATOM   1682  N   SER A 252      40.313  46.011  -1.263  1.00 33.52           N
ATOM   1683  CA  SER A 252      39.425  45.136  -0.518  1.00 32.35           C
ATOM   1684  C   SER A 252      38.586  46.008   0.419  1.00 31.81           C
ATOM   1685  O   SER A 252      38.854  47.206   0.579  1.00 30.08           O
ATOM   1686  CB  SER A 252      40.213  44.136   0.313  1.00 32.19           C
ATOM   1687  OG  SER A 252      41.046  44.803   1.232  1.00 31.74           O
ATOM   1688  N   LEU A 253      37.599  45.389   1.061  1.00 31.60           N
ATOM   1689  CA  LEU A 253      36.810  46.081   2.081  1.00 30.56           C
ATOM   1690  C   LEU A 253      37.719  46.466   3.249  1.00 29.86           C
ATOM   1691  O   LEU A 253      37.599  47.535   3.783  1.00 27.97           O
ATOM   1692  CB  LEU A 253      35.653  45.210   2.607  1.00 31.34           C
ATOM   1693  CG  LEU A 253      34.777  45.856   3.705  1.00 31.18           C
ATOM   1694  CD1 LEU A 253      34.309  47.224   3.277  1.00 30.94           C
ATOM   1695  CD2 LEU A 253      33.588  44.980   4.139  1.00 33.67           C
ATOM   1696  N   GLY A 254      38.616  45.566   3.662  1.00 29.97           N
ATOM   1697  CA  GLY A 254      39.550  45.868   4.722  1.00 28.84           C
ATOM   1698  C   GLY A 254      40.358  47.120   4.420  1.00 28.88           C
ATOM   1699  O   GLY A 254      40.625  47.927   5.289  1.00 27.13           O
ATOM   1700  N   GLY A 255      40.782  47.277   3.170  1.00 28.00           N
ATOM   1701  CA  GLY A 255      41.571  48.421   2.813  1.00 28.23           C
ATOM   1702  C   GLY A 255      40.733  49.702   2.841  1.00 27.43           C
ATOM   1703  O   GLY A 255      41.224  50.771   3.125  1.00 27.73           O
ATOM   1704  N   TYR A 256      39.462  49.582   2.483  1.00 27.48           N
ATOM   1705  CA  TYR A 256      38.518  50.693   2.581  1.00 25.58           C
ATOM   1706  C   TYR A 256      38.290  51.089   4.033  1.00 25.57           C
ATOM   1707  O   TYR A 256      38.358  52.271   4.384  1.00 25.59           O
ATOM   1708  CB  TYR A 256      37.207  50.335   1.912  1.00 26.02           C
ATOM   1709  CG  TYR A 256      36.229  51.488   1.755  1.00 25.23           C
ATOM   1710  CD1 TYR A 256      36.561  52.668   1.076  1.00 27.95           C
ATOM   1711  CD2 TYR A 256      34.965  51.411   2.290  1.00 27.30           C
ATOM   1712  CE1 TYR A 256      35.660  53.700   0.953  1.00 26.93           C
ATOM   1713  CE2 TYR A 256      34.067  52.447   2.187  1.00 27.24           C
ATOM   1714  CZ  TYR A 256      34.390  53.585   1.493  1.00 26.36           C
ATOM   1715  OH  TYR A 256      33.476  54.614   1.372  1.00 24.02           O
ATOM   1716  N   LEU A 257      38.031  50.095   4.872  1.00 23.83           N
ATOM   1717  CA  LEU A 257      37.828  50.359   6.305  1.00 25.10           C
ATOM   1718  C   LEU A 257      39.063  51.014   6.911  1.00 24.13           C
ATOM   1719  O   LEU A 257      38.970  52.010   7.637  1.00 24.83           O
ATOM   1720  CB  LEU A 257      37.511  49.056   7.021  1.00 24.40           C
ATOM   1721  CG  LEU A 257      36.231  48.351   6.626  1.00 26.59           C
ATOM   1722  CD1 LEU A 257      36.133  47.054   7.400  1.00 25.90           C
ATOM   1723  CD2 LEU A 257      35.000  49.185   6.868  1.00 28.78           C
ATOM   1724  N   ARG A 258      40.228  50.474   6.604  1.00 24.03           N
ATOM   1725  CA  ARG A 258      41.467  51.082   7.110  1.00 26.60           C
ATOM   1726  C   ARG A 258      41.611  52.526   6.665  1.00 26.69           C
ATOM   1727  O   ARG A 258      41.979  53.389   7.458  1.00 27.59           O
ATOM   1728  CB  ARG A 258      42.694  50.271   6.679  1.00 27.42           C
ATOM   1729  CG  ARG A 258      42.993  49.081   7.631  1.00 32.28           C
ATOM   1730  CD  ARG A 258      44.342  48.395   7.381  1.00 33.16           C
ATOM   1731  NE  ARG A 258      44.414  47.810   6.034  1.00 38.30           N
ATOM   1732  CZ  ARG A 258      43.870  46.637   5.685  1.00 38.19           C
ATOM   1733  NH1 ARG A 258      43.202  45.900   6.561  1.00 38.41           N
ATOM   1734  NH2 ARG A 258      43.987  46.192   4.443  1.00 40.57           N
ATOM   1735  N   ASP A 259      41.356  52.794   5.379  1.00 27.32           N
ATOM   1736  CA  ASP A 259      41.456  54.148   4.842  1.00 27.15           C
ATOM   1737  C   ASP A 259      40.426  55.070   5.515  1.00 27.45           C
ATOM   1738  O   ASP A 259      40.650  56.282   5.639  1.00 28.18           O
ATOM   1739  CB  ASP A 259      41.251  54.135   3.327  1.00 27.03           C
ATOM   1740  CG  ASP A 259      41.728  55.415   2.679  1.00 31.47           C
ATOM   1741  OD1 ASP A 259      42.930  55.779   2.844  1.00 30.71           O
ATOM   1742  OD2 ASP A 259      40.957  56.143   2.022  1.00 32.66           O
ATOM   1743  N   ALA A 260      39.316  54.491   5.979  1.00 26.27           N
ATOM   1744  CA  ALA A 260      38.268  55.244   6.657  1.00 25.00           C
ATOM   1745  C   ALA A 260      38.492  55.374   8.138  1.00 25.50           C
ATOM   1746  O   ALA A 260      37.560  55.718   8.857  1.00 25.44           O
ATOM   1747  CB  ALA A 260      36.895  54.614   6.398  1.00 24.04           C
ATOM   1748  N   GLY A 261      39.706  55.088   8.601  1.00 25.55           N
ATOM   1749  CA  GLY A 261      40.029  55.235  10.019  1.00 26.05           C
ATOM   1750  C   GLY A 261      39.428  54.200  10.947  1.00 25.05           C
ATOM   1751  O   GLY A 261      39.256  54.442  12.152  1.00 27.78           O
ATOM   1752  N   ILE A 262      39.055  53.040  10.402  1.00 23.94           N
ATOM   1753  CA  ILE A 262      38.418  51.998  11.174  1.00 23.40           C
ATOM   1754  C   ILE A 262      39.441  50.889  11.440  1.00 24.49           C
ATOM   1755  O   ILE A 262      39.871  50.209  10.536  1.00 25.36           O
ATOM   1756  CB  ILE A 262      37.189  51.461  10.466  1.00 23.00           C
ATOM   1757  CG1 ILE A 262      36.151  52.581  10.306  1.00 21.76           C
ATOM   1758  CG2 ILE A 262      36.587  50.260  11.210  1.00 23.60           C
ATOM   1759  CD1 ILE A 262      34.927  52.202   9.471  1.00 23.51           C
ATOM   1760  N   SER A 263      39.809  50.727  12.706  1.00 23.76           N
ATOM   1761  CA  SER A 263      40.813  49.698  13.055  1.00 23.55           C
ATOM   1762  C   SER A 263      40.196  48.306  13.134  1.00 22.42           C
ATOM   1763  O   SER A 263      38.977  48.144  13.250  1.00 21.77           O
ATOM   1764  CB  SER A 263      41.449  50.056  14.381  1.00 24.57           C
ATOM   1765  OG  SER A 263      40.503  49.893  15.413  1.00 22.50           O
ATOM   1766  N   GLN A 264      41.039  47.263  13.125  1.00 23.01           N
ATOM   1767  CA  GLN A 264      40.569  45.907  13.397  1.00 23.13           C
ATOM   1768  C   GLN A 264      40.062  45.776  14.832  1.00 23.58           C
ATOM   1769  O   GLN A 264      39.136  45.022  15.070  1.00 23.13           O
ATOM   1770  CB  GLN A 264      41.689  44.883  13.087  1.00 23.45           C
ATOM   1771  CG  GLN A 264      41.274  43.460  13.338  1.00 24.24           C
ATOM   1772  CD  GLN A 264      40.312  42.994  12.275  1.00 25.01           C
ATOM   1773  OE1 GLN A 264      40.556  43.226  11.089  1.00 28.98           O
ATOM   1774  NE2 GLN A 264      39.255  42.288  12.677  1.00 28.11           N
ATOM   1775  N   ALA A 265      40.664  46.505  15.783  1.00 23.20           N
ATOM   1776  CA  ALA A 265      40.181  46.534  17.173  1.00 23.47           C
ATOM   1777  C   ALA A 265      38.711  47.002  17.221  1.00 22.52           C
ATOM   1778  O   ALA A 265      37.861  46.417  17.916  1.00 22.75           O
ATOM   1779  CB  ALA A 265      41.009  47.408  18.041  1.00 24.82           C
ATOM   1780  N   THR A 266      38.431  48.041  16.457  1.00 23.45           N
ATOM   1781  CA  THR A 266      37.071  48.584  16.400  1.00 23.97           C
ATOM   1782  C   THR A 266      36.130  47.590  15.736  1.00 23.40           C
ATOM   1783  O   THR A 266      35.054  47.356  16.229  1.00 23.40           O
ATOM   1784  CB  THR A 266      37.113  49.907  15.664  1.00 24.48           C
ATOM   1785  OG1 THR A 266      37.837  50.843  16.462  1.00 24.53           O
ATOM   1786  CG2 THR A 266      35.703  50.515  15.468  1.00 23.43           C
ATOM   1787  N   VAL A 267      36.530  47.009  14.610  1.00 23.07           N
ATOM   1788  CA  VAL A 267      35.728  45.956  13.991  1.00 23.12           C
ATOM   1789  C   VAL A 267      35.420  44.808  14.950  1.00 23.83           C
ATOM   1790  O   VAL A 267      34.318  44.342  15.034  1.00 21.74           O
ATOM   1791  CB  VAL A 267      36.369  45.458  12.722  1.00 22.70           C
ATOM   1792  CG1 VAL A 267      35.718  44.152  12.152  1.00 24.04           C
ATOM   1793  CG2 VAL A 267      36.349  46.574  11.667  1.00 23.73           C
ATOM   1794  N   ASN A 268      36.434  44.355  15.684  1.00 24.53           N
ATOM   1795  CA  ASN A 268      36.270  43.277  16.628  1.00 24.66           C
ATOM   1796  C   ASN A 268      35.251  43.589  17.709  1.00 25.73           C
ATOM   1797  O   ASN A 268      34.423  42.719  18.040  1.00 25.68           O
ATOM   1798  CB  ASN A 268      37.643  42.914  17.277  1.00 25.37           C
ATOM   1799  CG  ASN A 268      38.604  42.231  16.300  1.00 25.68           C
ATOM   1800  OD1 ASN A 268      38.232  41.804  15.172  1.00 27.13           O
ATOM   1801  ND2 ASN A 268      39.896  42.154  16.705  1.00 23.15           N
ATOM   1802  N   ARG A 269      35.284  44.820  18.209  1.00 26.74           N
ATOM   1803  CA  ARG A 269      34.389  45.266  19.252  1.00 28.31           C
ATOM   1804  C   ARG A 269      32.977  45.310  18.687  1.00 27.87           C
ATOM   1805  O   ARG A 269      32.053  44.842  19.317  1.00 27.62           O
ATOM   1806  CB  ARG A 269      34.745  46.645  19.767  1.00 29.67           C
ATOM   1807  CG  ARG A 269      35.814  46.713  20.868  1.00 36.15           C
ATOM   1808  CD  ARG A 269      35.825  48.087  21.624  1.00 41.44           C
ATOM   1809  NE  ARG A 269      36.481  49.115  20.802  1.00 47.31           N
ATOM   1810  CZ  ARG A 269      37.802  49.183  20.571  1.00 49.93           C
ATOM   1811  NH1 ARG A 269      38.641  48.298  21.128  1.00 51.22           N
ATOM   1812  NH2 ARG A 269      38.296  50.141  19.783  1.00 49.82           N
ATOM   1813  N   MET A 270      32.864  45.861  17.478  1.00 27.17           N
ATOM   1814  CA  MET A 270      31.586  45.899  16.768  1.00 27.50           C
ATOM   1815  C   MET A 270      30.978  44.522  16.554  1.00 28.52           C
ATOM   1816  O   MET A 270      29.770  44.337  16.763  1.00 29.55           O
ATOM   1817  CB  MET A 270      31.719  46.645  15.424  1.00 26.34           C
ATOM   1818  CG  MET A 270      30.367  46.765  14.712  1.00 25.42           C
ATOM   1819  SD  MET A 270      30.393  47.811  13.253  1.00 26.00           S
ATOM   1820  CE  MET A 270      31.487  47.052  12.258  1.00 28.10           C
ATOM   1821  N   ARG A 271      31.792  43.546  16.167  1.00 29.17           N
ATOM   1822  CA  ARG A 271      31.352  42.155  16.020  1.00 30.05           C
ATOM   1823  C   ARG A 271      30.829  41.585  17.349  1.00 30.13           C
ATOM   1824  O   ARG A 271      29.775  40.950  17.407  1.00 28.94           O
ATOM   1825  CB  ARG A 271      32.508  41.319  15.448  1.00 29.79           C
ATOM   1826  CG  ARG A 271      32.154  39.888  15.027  1.00 35.22           C
ATOM   1827  CD  ARG A 271      33.362  39.122  14.428  1.00 40.97           C
ATOM   1828  NE  ARG A 271      33.713  39.655  13.110  1.00 46.72           N
ATOM   1829  CZ  ARG A 271      34.891  40.218  12.749  1.00 46.35           C
ATOM   1830  NH1 ARG A 271      35.977  40.295  13.590  1.00 45.75           N
ATOM   1831  NH2 ARG A 271      34.987  40.651  11.489  1.00 39.89           N
ATOM   1832  N   GLY A 272      31.545  41.835  18.428  1.00 31.22           N
ATOM   1833  CA  GLY A 272      31.084  41.422  19.744  1.00 31.68           C
ATOM   1834  C   GLY A 272      29.765  42.045  20.187  1.00 32.75           C
ATOM   1835  O   GLY A 272      28.934  41.359  20.804  1.00 32.65           O
ATOM   1836  N   VAL A 273      29.573  43.327  19.885  1.00 32.15           N
ATOM   1837  CA  VAL A 273      28.346  44.035  20.213  1.00 34.08           C
ATOM   1838  C   VAL A 273      27.171  43.553  19.363  1.00 33.73           C
ATOM   1839  O   VAL A 273      26.064  43.408  19.865  1.00 34.78           O
ATOM   1840  CB  VAL A 273      28.512  45.561  20.010  1.00 34.74           C
ATOM   1841  CG1 VAL A 273      27.177  46.294  20.151  1.00 36.52           C
ATOM   1842  CG2 VAL A 273      29.495  46.106  21.020  1.00 36.52           C
ATOM   1843  N   LEU A 274      27.405  43.336  18.082  1.00 32.81           N
ATOM   1844  CA  LEU A 274      26.309  43.024  17.154  1.00 33.64           C
ATOM   1845  C   LEU A 274      25.923  41.559  17.114  1.00 34.72           C
ATOM   1846  O   LEU A 274      24.748  41.268  16.915  1.00 33.99           O
ATOM   1847  CB  LEU A 274      26.639  43.485  15.745  1.00 32.77           C
ATOM   1848  CG  LEU A 274      26.747  45.015  15.605  1.00 33.53           C
ATOM   1849  CD1 LEU A 274      26.792  45.372  14.148  1.00 32.24           C
ATOM   1850  CD2 LEU A 274      25.650  45.747  16.248  1.00 33.50           C
ATOM   1851  N   LEU A 275      26.883  40.644  17.270  1.00 35.71           N
ATOM   1852  CA  LEU A 275      26.604  39.199  17.103  1.00 37.62           C
ATOM   1853  C   LEU A 275      26.341  38.468  18.427  1.00 38.38           C
ATOM   1854  O   LEU A 275      26.547  39.036  19.508  1.00 39.75           O
ATOM   1855  CB  LEU A 275      27.751  38.507  16.379  1.00 37.78           C
ATOM   1856  CG  LEU A 275      28.185  38.993  15.023  1.00 39.72           C
ATOM   1857  CD1 LEU A 275      29.309  38.083  14.537  1.00 41.01           C
ATOM   1858  CD2 LEU A 275      27.010  39.028  14.059  1.00 41.90           C
TER    1859      LEU A 275
"""

def exercise_single():
  two_char_chain_records = """\
HELIX    1   1 THRA1   11  ASPA1   39  1                                  29
HELIX    2   2 GLUA1   46  ARGA1   73  1                                  28
HELIX    3   3 THRA1   93  ALAA1  120  1                                  28
HELIX    4   4 PROA1  124  HISA1  133  1                                  10
HELIX    5   5 LEUA1  135  ARGA1  154  1                                  20
HELIX    6   6 THRa1   11  TYRa1   37  1                                  27
HELIX    7   7 GLUa1   46  GLNa1   72  1                                  27
HELIX    8   8 THRa1   93  ALAa1  120  1                                  28
HELIX    9   9 PROa1  124  HISa1  133  1                                  10"""
  lines = flex.std_string()
  lines.extend(flex.split_lines(two_char_chain_records))
  secstr = ss.annotation.from_records(records=lines)
  ss_out = secstr.as_pdb_str()
  assert not test_utils.show_diff(ss_out, two_char_chain_records)
  print("OK")

def tst_pdb_file():
  pdb_inp = iotbx.pdb.input(source_info=None,
    lines=pdb_1ywf_sample_strings)
  old_ss = pdb_inp.secondary_structure_section()
  structure = pdb_inp.extract_secondary_structure()
  new_ss = structure.as_pdb_str()
  old_ss = "\n".join(old_ss)
  assert not test_utils.show_diff(new_ss, old_ss)
  print("OK")

def tst_parsing_phil():
  phil_str = """\
secondary_structure.protein {
  helix {
    selection = chain A and resseq 1:18
    helix_type = alpha pi *3_10 unknown
    }
  helix {
    selection = chain A and resseq 37:48
    helix_type = *alpha pi 3_10 unknown
    hbond {
      donor = chain A and resid 37 and name O
      acceptor = chain A and resid 41 and name N
    }
    }
  helix {
    selection = chain A and resseq 57:65
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 119:133
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 134:136
    helix_type = alpha pi *3_10 unknown
    }
  helix {
    selection = chain A and resseq 138:152
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 165:178
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 181:191
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 192:194
    helix_type = alpha pi *3_10 unknown
    }
  helix {
    selection = chain A and resseq 195:209
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 216:225
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 228:233
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 235:251
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 252:260
    helix_type = *alpha pi 3_10 unknown
    }
  helix {
    selection = chain A and resseq 263:275
    helix_type = *alpha pi 3_10 unknown
    }

  sheet {
    first_strand = chain A and resseq 13:14
    sheet_id = A
    strand {
      selection = chain A and resseq 27:30
      sense = antiparallel
      bond_start_current = chain A and resseq 29 and name O
      bond_start_previous = chain A and resseq 13 and name N
    }
    strand {
      selection = chain A and resseq 156:159
      sense = parallel
      bond_start_current = chain A and resseq 156 and name O
      bond_start_previous = chain A and resseq 28 and name N
    }
    strand {
      selection = chain A and resseq 51:54
      sense = parallel
      bond_start_current = chain A and resseq 51 and name O
      bond_start_previous = chain A and resseq 157 and name N
    }
    strand {
      selection = chain A and resseq 74:77
      sense = parallel
      bond_start_current = chain A and resseq 74 and name O
      bond_start_previous = chain A and resseq 52 and name N
    }
  }
}"""

  annot, ss_from_file = get_annotation(
      phil_lines=phil_str,
      pdb_lines=pdb_1ywf_sample_strings)
  ss_from_phil = annot.as_pdb_str()
  assert ss_from_file == ss_from_phil
  print("OK")

def get_annotation(phil_lines, pdb_lines):
  pdb_inp = iotbx.pdb.input(source_info=None,
    lines=pdb_lines)
  pdb_h = pdb_inp.construct_hierarchy()
  ss_from_file = pdb_inp.secondary_structure_section()
  ss_phil = iotbx.phil.parse(phil_lines)
  working_params = sec_str_master_phil.fetch(source=ss_phil).extract()
  annot = ss.annotation.from_phil(
      phil_helices=working_params.secondary_structure.protein.helix,
      phil_sheets=working_params.secondary_structure.protein.sheet,
      pdb_hierarchy=pdb_h)
  return annot, ss_from_file

def exercise_only_b_altloc():
  pdb_inp = iotbx.pdb.input(source_info=None,
    lines=pdb_1ywf_cutted)
  old_ss = pdb_inp.secondary_structure_section()
  structure = pdb_inp.extract_secondary_structure()
  new_ss = structure.as_pdb_str()
  old_ss = "\n".join(old_ss)
  assert not test_utils.show_diff(new_ss, old_ss)
  print("OK")

def exercise_multiplication():
  from iotbx.pdb.utils import all_chain_ids
#   two_char_chain_records = """\
# HELIX    1   1 THRA1   11  ASPA1   39  1                                  29
# SHEET    1   A 5 ARG A  13  ASP A  14  0
# SHEET    2   A 5 LEU A  27  SER A  30 -1  O  ARG A  29   N  ARG A  13
# """
  one_char_chain_records = """\
HELIX    1   1 THR A   11  ASP A   39  1                                  29
SHEET    1   A 5 ARG A  13  ASP A  14  0
SHEET    2   A 5 LEU A  27  SER A  30 -1  O  ARG A  29   N  ARG A  13
"""
  all_ids = all_chain_ids()
  secstr = ss.annotation.from_records(records=one_char_chain_records.split('\n'))
  secstr.multiply_to_asu_2(chain_ids_dict={'A':all_ids})
  for sh in secstr.sheets:
    for s in sh.strands:
      assert sh.sheet_id == s.sheet_id, "%s, %s" % (sh.sheet_id, s.sheet_id)
  ss_lines = secstr.as_pdb_str().split('\n')
  # print (ss_lines[1200])
  # print (ss_lines[6999])
  # print (ss_lines[7000])
  assert ss_lines[1200] == \
      "HELIX  A5L A5L THR5V   11  ASP5V   39  1                                  29"
  assert ss_lines[6999] == "SHEET    1 AF7 2 ARGHf  13  ASPHf  14  0"
  assert ss_lines[7000] == \
      "SHEET    2 AF7 2 LEUHf  27  SERHf  30 -1  O  ARGHf  29   N  ARGHf  13"
  ss_back = ss.annotation.from_records(records=[
      ss_lines[1200], ss_lines[6999], ss_lines[7000]])
  for s in ss_back.sheets:
    for strand in s.strands:
      assert s.sheet_id == strand.sheet_id, "%s, %s" % (s.sheet_id, strand.sheet_id)
  assert ss_back.helices[0].serial == 'A5L'
  assert ss_back.sheets[0].sheet_id == 'AF7'
  print("OK")

def exercise(args):
  exercise_single()
  tst_pdb_file()
  tst_parsing_phil()
  exercise_only_b_altloc()
  exercise_multiplication()

if (__name__ == "__main__"):
  exercise(sys.argv[1:])
