/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _FORT_INTERFACE_
#define _FORT_INTERFACE_

#ifdef BL_LANG_FORT
c
c  -------------------------
c  ::: Fortran Interface :::
c  -------------------------
c
#  define   FORT_VISCBENCH        viscbench
#else
//
// ---------------------------------------
// ::: C Interface to Fortran Routines :::
// ---------------------------------------
//

#ifdef BL_FORT_USE_UNDERSCORE
#  define   FORT_VISCBENCH        viscbench_
#else
#  define   FORT_VISCBENCH        VISCBENCH
#endif

//
// Use ARLIM in the following.
//

extern "C"
{
#if (BL_SPACEDIM==3)
  void FORT_VISCBENCH(const Real *time, const Real *nu, const int *unifdir,
                      const int *lo, const int *hi, 
                      const int *ncomp,
                      const Real *state, ARLIM_P(lo), ARLIM_P(hi),
                      const Real *delta,
                      const Real *xlo, const Real *xhi);
#else
  void FORT_VISCBENCH(const Real *time, const Real *nu, 
                      const int *lo, const int *hi, 
                      const int *ncomp,
                      const Real *state, ARLIM_P(lo), ARLIM_P(hi),
                      const Real *delta,
                      const Real *xlo, const Real *xhi);
#endif

}
#endif
#endif
