//
// BAGEL - Parallel electron correlation program.
// Filename: _hrr_a0_64.cc
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <src/integral/hrrlist.h>
#include <array>
#include <algorithm>

using namespace std;
using namespace bagel;

void HRRList::perform_HRR_a0_64(const int nloop, const double* data_start, const array<double,3>& AB, double* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 230];
    auto current_out = &data_out[c * 420];
   {
     //current index a: xxxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[28];
      const auto ay_0 = current_data[29];
      const auto az_0 = current_data[36];
      const auto axx_0 = current_data[64];
      const auto axy_0 = current_data[65];
      const auto ayy_0 = current_data[66];
      const auto axz_0 = current_data[73];
      const auto ayz_0 = current_data[74];
      const auto azz_0 = current_data[81];
      const auto axxx_0 = current_data[109];
      const auto axxy_0 = current_data[110];
      const auto axyy_0 = current_data[111];
      const auto ayyy_0 = current_data[112];
      const auto axxz_0 = current_data[119];
      const auto axyz_0 = current_data[120];
      const auto ayyz_0 = current_data[121];
      const auto axzz_0 = current_data[128];
      const auto ayzz_0 = current_data[129];
      const auto azzz_0 = current_data[136];
      const auto axxxx_0 = current_data[164];
      const auto axxxy_0 = current_data[165];
      const auto axxyy_0 = current_data[166];
      const auto axyyy_0 = current_data[167];
      const auto ayyyy_0 = current_data[168];
      const auto axxxz_0 = current_data[175];
      const auto axxyz_0 = current_data[176];
      const auto axyyz_0 = current_data[177];
      const auto ayyyz_0 = current_data[178];
      const auto axxzz_0 = current_data[185];
      const auto axyzz_0 = current_data[186];
      const auto ayyzz_0 = current_data[187];
      const auto axzzz_0 = current_data[194];
      const auto ayzzz_0 = current_data[195];
      const auto azzzz_0 = current_data[202];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[0] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[1] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[2] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[3] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[4] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[5] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[6] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[7] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[8] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[9] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[10] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[11] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[12] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[13] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[14] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[29];
      const auto ay_0 = current_data[30];
      const auto az_0 = current_data[37];
      const auto axx_0 = current_data[65];
      const auto axy_0 = current_data[66];
      const auto ayy_0 = current_data[67];
      const auto axz_0 = current_data[74];
      const auto ayz_0 = current_data[75];
      const auto azz_0 = current_data[82];
      const auto axxx_0 = current_data[110];
      const auto axxy_0 = current_data[111];
      const auto axyy_0 = current_data[112];
      const auto ayyy_0 = current_data[113];
      const auto axxz_0 = current_data[120];
      const auto axyz_0 = current_data[121];
      const auto ayyz_0 = current_data[122];
      const auto axzz_0 = current_data[129];
      const auto ayzz_0 = current_data[130];
      const auto azzz_0 = current_data[137];
      const auto axxxx_0 = current_data[165];
      const auto axxxy_0 = current_data[166];
      const auto axxyy_0 = current_data[167];
      const auto axyyy_0 = current_data[168];
      const auto ayyyy_0 = current_data[169];
      const auto axxxz_0 = current_data[176];
      const auto axxyz_0 = current_data[177];
      const auto axyyz_0 = current_data[178];
      const auto ayyyz_0 = current_data[179];
      const auto axxzz_0 = current_data[186];
      const auto axyzz_0 = current_data[187];
      const auto ayyzz_0 = current_data[188];
      const auto axzzz_0 = current_data[195];
      const auto ayzzz_0 = current_data[196];
      const auto azzzz_0 = current_data[203];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[15] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[16] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[17] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[18] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[19] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[20] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[21] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[22] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[23] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[24] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[25] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[26] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[27] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[28] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[29] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[30];
      const auto ay_0 = current_data[31];
      const auto az_0 = current_data[38];
      const auto axx_0 = current_data[66];
      const auto axy_0 = current_data[67];
      const auto ayy_0 = current_data[68];
      const auto axz_0 = current_data[75];
      const auto ayz_0 = current_data[76];
      const auto azz_0 = current_data[83];
      const auto axxx_0 = current_data[111];
      const auto axxy_0 = current_data[112];
      const auto axyy_0 = current_data[113];
      const auto ayyy_0 = current_data[114];
      const auto axxz_0 = current_data[121];
      const auto axyz_0 = current_data[122];
      const auto ayyz_0 = current_data[123];
      const auto axzz_0 = current_data[130];
      const auto ayzz_0 = current_data[131];
      const auto azzz_0 = current_data[138];
      const auto axxxx_0 = current_data[166];
      const auto axxxy_0 = current_data[167];
      const auto axxyy_0 = current_data[168];
      const auto axyyy_0 = current_data[169];
      const auto ayyyy_0 = current_data[170];
      const auto axxxz_0 = current_data[177];
      const auto axxyz_0 = current_data[178];
      const auto axyyz_0 = current_data[179];
      const auto ayyyz_0 = current_data[180];
      const auto axxzz_0 = current_data[187];
      const auto axyzz_0 = current_data[188];
      const auto ayyzz_0 = current_data[189];
      const auto axzzz_0 = current_data[196];
      const auto ayzzz_0 = current_data[197];
      const auto azzzz_0 = current_data[204];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[30] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[31] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[32] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[33] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[34] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[35] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[36] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[37] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[38] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[39] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[40] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[41] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[42] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[43] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[44] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[31];
      const auto ay_0 = current_data[32];
      const auto az_0 = current_data[39];
      const auto axx_0 = current_data[67];
      const auto axy_0 = current_data[68];
      const auto ayy_0 = current_data[69];
      const auto axz_0 = current_data[76];
      const auto ayz_0 = current_data[77];
      const auto azz_0 = current_data[84];
      const auto axxx_0 = current_data[112];
      const auto axxy_0 = current_data[113];
      const auto axyy_0 = current_data[114];
      const auto ayyy_0 = current_data[115];
      const auto axxz_0 = current_data[122];
      const auto axyz_0 = current_data[123];
      const auto ayyz_0 = current_data[124];
      const auto axzz_0 = current_data[131];
      const auto ayzz_0 = current_data[132];
      const auto azzz_0 = current_data[139];
      const auto axxxx_0 = current_data[167];
      const auto axxxy_0 = current_data[168];
      const auto axxyy_0 = current_data[169];
      const auto axyyy_0 = current_data[170];
      const auto ayyyy_0 = current_data[171];
      const auto axxxz_0 = current_data[178];
      const auto axxyz_0 = current_data[179];
      const auto axyyz_0 = current_data[180];
      const auto ayyyz_0 = current_data[181];
      const auto axxzz_0 = current_data[188];
      const auto axyzz_0 = current_data[189];
      const auto ayyzz_0 = current_data[190];
      const auto axzzz_0 = current_data[197];
      const auto ayzzz_0 = current_data[198];
      const auto azzzz_0 = current_data[205];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[45] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[46] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[47] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[48] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[49] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[50] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[51] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[52] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[53] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[54] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[55] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[56] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[57] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[58] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[59] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[32];
      const auto ay_0 = current_data[33];
      const auto az_0 = current_data[40];
      const auto axx_0 = current_data[68];
      const auto axy_0 = current_data[69];
      const auto ayy_0 = current_data[70];
      const auto axz_0 = current_data[77];
      const auto ayz_0 = current_data[78];
      const auto azz_0 = current_data[85];
      const auto axxx_0 = current_data[113];
      const auto axxy_0 = current_data[114];
      const auto axyy_0 = current_data[115];
      const auto ayyy_0 = current_data[116];
      const auto axxz_0 = current_data[123];
      const auto axyz_0 = current_data[124];
      const auto ayyz_0 = current_data[125];
      const auto axzz_0 = current_data[132];
      const auto ayzz_0 = current_data[133];
      const auto azzz_0 = current_data[140];
      const auto axxxx_0 = current_data[168];
      const auto axxxy_0 = current_data[169];
      const auto axxyy_0 = current_data[170];
      const auto axyyy_0 = current_data[171];
      const auto ayyyy_0 = current_data[172];
      const auto axxxz_0 = current_data[179];
      const auto axxyz_0 = current_data[180];
      const auto axyyz_0 = current_data[181];
      const auto ayyyz_0 = current_data[182];
      const auto axxzz_0 = current_data[189];
      const auto axyzz_0 = current_data[190];
      const auto ayyzz_0 = current_data[191];
      const auto axzzz_0 = current_data[198];
      const auto ayzzz_0 = current_data[199];
      const auto azzzz_0 = current_data[206];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[60] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[61] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[62] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[63] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[64] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[65] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[66] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[67] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[68] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[69] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[70] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[71] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[72] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[73] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[74] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyyyy
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[33];
      const auto ay_0 = current_data[34];
      const auto az_0 = current_data[41];
      const auto axx_0 = current_data[69];
      const auto axy_0 = current_data[70];
      const auto ayy_0 = current_data[71];
      const auto axz_0 = current_data[78];
      const auto ayz_0 = current_data[79];
      const auto azz_0 = current_data[86];
      const auto axxx_0 = current_data[114];
      const auto axxy_0 = current_data[115];
      const auto axyy_0 = current_data[116];
      const auto ayyy_0 = current_data[117];
      const auto axxz_0 = current_data[124];
      const auto axyz_0 = current_data[125];
      const auto ayyz_0 = current_data[126];
      const auto axzz_0 = current_data[133];
      const auto ayzz_0 = current_data[134];
      const auto azzz_0 = current_data[141];
      const auto axxxx_0 = current_data[169];
      const auto axxxy_0 = current_data[170];
      const auto axxyy_0 = current_data[171];
      const auto axyyy_0 = current_data[172];
      const auto ayyyy_0 = current_data[173];
      const auto axxxz_0 = current_data[180];
      const auto axxyz_0 = current_data[181];
      const auto axyyz_0 = current_data[182];
      const auto ayyyz_0 = current_data[183];
      const auto axxzz_0 = current_data[190];
      const auto axyzz_0 = current_data[191];
      const auto ayyzz_0 = current_data[192];
      const auto axzzz_0 = current_data[199];
      const auto ayzzz_0 = current_data[200];
      const auto azzzz_0 = current_data[207];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[75] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[76] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[77] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[78] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[79] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[80] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[81] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[82] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[83] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[84] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[85] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[86] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[87] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[88] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[89] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyyyy
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[34];
      const auto ay_0 = current_data[35];
      const auto az_0 = current_data[42];
      const auto axx_0 = current_data[70];
      const auto axy_0 = current_data[71];
      const auto ayy_0 = current_data[72];
      const auto axz_0 = current_data[79];
      const auto ayz_0 = current_data[80];
      const auto azz_0 = current_data[87];
      const auto axxx_0 = current_data[115];
      const auto axxy_0 = current_data[116];
      const auto axyy_0 = current_data[117];
      const auto ayyy_0 = current_data[118];
      const auto axxz_0 = current_data[125];
      const auto axyz_0 = current_data[126];
      const auto ayyz_0 = current_data[127];
      const auto axzz_0 = current_data[134];
      const auto ayzz_0 = current_data[135];
      const auto azzz_0 = current_data[142];
      const auto axxxx_0 = current_data[170];
      const auto axxxy_0 = current_data[171];
      const auto axxyy_0 = current_data[172];
      const auto axyyy_0 = current_data[173];
      const auto ayyyy_0 = current_data[174];
      const auto axxxz_0 = current_data[181];
      const auto axxyz_0 = current_data[182];
      const auto axyyz_0 = current_data[183];
      const auto ayyyz_0 = current_data[184];
      const auto axxzz_0 = current_data[191];
      const auto axyzz_0 = current_data[192];
      const auto ayyzz_0 = current_data[193];
      const auto axzzz_0 = current_data[200];
      const auto ayzzz_0 = current_data[201];
      const auto azzzz_0 = current_data[208];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[90] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[91] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[92] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[93] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[94] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[95] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[96] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[97] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[98] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[99] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[100] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[101] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[102] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[103] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[104] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxxz
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[43];
      const auto axx_0 = current_data[73];
      const auto axy_0 = current_data[74];
      const auto ayy_0 = current_data[75];
      const auto axz_0 = current_data[81];
      const auto ayz_0 = current_data[82];
      const auto azz_0 = current_data[88];
      const auto axxx_0 = current_data[119];
      const auto axxy_0 = current_data[120];
      const auto axyy_0 = current_data[121];
      const auto ayyy_0 = current_data[122];
      const auto axxz_0 = current_data[128];
      const auto axyz_0 = current_data[129];
      const auto ayyz_0 = current_data[130];
      const auto axzz_0 = current_data[136];
      const auto ayzz_0 = current_data[137];
      const auto azzz_0 = current_data[143];
      const auto axxxx_0 = current_data[175];
      const auto axxxy_0 = current_data[176];
      const auto axxyy_0 = current_data[177];
      const auto axyyy_0 = current_data[178];
      const auto ayyyy_0 = current_data[179];
      const auto axxxz_0 = current_data[185];
      const auto axxyz_0 = current_data[186];
      const auto axyyz_0 = current_data[187];
      const auto ayyyz_0 = current_data[188];
      const auto axxzz_0 = current_data[194];
      const auto axyzz_0 = current_data[195];
      const auto ayyzz_0 = current_data[196];
      const auto axzzz_0 = current_data[202];
      const auto ayzzz_0 = current_data[203];
      const auto azzzz_0 = current_data[209];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[105] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[106] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[107] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[108] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[109] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[110] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[111] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[112] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[113] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[114] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[115] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[116] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[117] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[118] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[119] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxyz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[44];
      const auto axx_0 = current_data[74];
      const auto axy_0 = current_data[75];
      const auto ayy_0 = current_data[76];
      const auto axz_0 = current_data[82];
      const auto ayz_0 = current_data[83];
      const auto azz_0 = current_data[89];
      const auto axxx_0 = current_data[120];
      const auto axxy_0 = current_data[121];
      const auto axyy_0 = current_data[122];
      const auto ayyy_0 = current_data[123];
      const auto axxz_0 = current_data[129];
      const auto axyz_0 = current_data[130];
      const auto ayyz_0 = current_data[131];
      const auto axzz_0 = current_data[137];
      const auto ayzz_0 = current_data[138];
      const auto azzz_0 = current_data[144];
      const auto axxxx_0 = current_data[176];
      const auto axxxy_0 = current_data[177];
      const auto axxyy_0 = current_data[178];
      const auto axyyy_0 = current_data[179];
      const auto ayyyy_0 = current_data[180];
      const auto axxxz_0 = current_data[186];
      const auto axxyz_0 = current_data[187];
      const auto axyyz_0 = current_data[188];
      const auto ayyyz_0 = current_data[189];
      const auto axxzz_0 = current_data[195];
      const auto axyzz_0 = current_data[196];
      const auto ayyzz_0 = current_data[197];
      const auto axzzz_0 = current_data[203];
      const auto ayzzz_0 = current_data[204];
      const auto azzzz_0 = current_data[210];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[120] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[121] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[122] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[123] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[124] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[125] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[126] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[127] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[128] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[129] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[130] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[131] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[132] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[133] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[134] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxyyz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[38];
      const auto ay_0 = current_data[39];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[75];
      const auto axy_0 = current_data[76];
      const auto ayy_0 = current_data[77];
      const auto axz_0 = current_data[83];
      const auto ayz_0 = current_data[84];
      const auto azz_0 = current_data[90];
      const auto axxx_0 = current_data[121];
      const auto axxy_0 = current_data[122];
      const auto axyy_0 = current_data[123];
      const auto ayyy_0 = current_data[124];
      const auto axxz_0 = current_data[130];
      const auto axyz_0 = current_data[131];
      const auto ayyz_0 = current_data[132];
      const auto axzz_0 = current_data[138];
      const auto ayzz_0 = current_data[139];
      const auto azzz_0 = current_data[145];
      const auto axxxx_0 = current_data[177];
      const auto axxxy_0 = current_data[178];
      const auto axxyy_0 = current_data[179];
      const auto axyyy_0 = current_data[180];
      const auto ayyyy_0 = current_data[181];
      const auto axxxz_0 = current_data[187];
      const auto axxyz_0 = current_data[188];
      const auto axyyz_0 = current_data[189];
      const auto ayyyz_0 = current_data[190];
      const auto axxzz_0 = current_data[196];
      const auto axyzz_0 = current_data[197];
      const auto ayyzz_0 = current_data[198];
      const auto axzzz_0 = current_data[204];
      const auto ayzzz_0 = current_data[205];
      const auto azzzz_0 = current_data[211];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[135] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[136] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[137] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[138] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[139] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[140] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[141] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[142] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[143] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[144] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[145] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[146] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[147] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[148] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[149] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyyyz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[76];
      const auto axy_0 = current_data[77];
      const auto ayy_0 = current_data[78];
      const auto axz_0 = current_data[84];
      const auto ayz_0 = current_data[85];
      const auto azz_0 = current_data[91];
      const auto axxx_0 = current_data[122];
      const auto axxy_0 = current_data[123];
      const auto axyy_0 = current_data[124];
      const auto ayyy_0 = current_data[125];
      const auto axxz_0 = current_data[131];
      const auto axyz_0 = current_data[132];
      const auto ayyz_0 = current_data[133];
      const auto axzz_0 = current_data[139];
      const auto ayzz_0 = current_data[140];
      const auto azzz_0 = current_data[146];
      const auto axxxx_0 = current_data[178];
      const auto axxxy_0 = current_data[179];
      const auto axxyy_0 = current_data[180];
      const auto axyyy_0 = current_data[181];
      const auto ayyyy_0 = current_data[182];
      const auto axxxz_0 = current_data[188];
      const auto axxyz_0 = current_data[189];
      const auto axyyz_0 = current_data[190];
      const auto ayyyz_0 = current_data[191];
      const auto axxzz_0 = current_data[197];
      const auto axyzz_0 = current_data[198];
      const auto ayyzz_0 = current_data[199];
      const auto axzzz_0 = current_data[205];
      const auto ayzzz_0 = current_data[206];
      const auto azzzz_0 = current_data[212];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[150] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[151] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[152] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[153] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[154] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[155] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[156] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[157] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[158] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[159] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[160] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[161] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[162] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[163] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[164] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyyyz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[77];
      const auto axy_0 = current_data[78];
      const auto ayy_0 = current_data[79];
      const auto axz_0 = current_data[85];
      const auto ayz_0 = current_data[86];
      const auto azz_0 = current_data[92];
      const auto axxx_0 = current_data[123];
      const auto axxy_0 = current_data[124];
      const auto axyy_0 = current_data[125];
      const auto ayyy_0 = current_data[126];
      const auto axxz_0 = current_data[132];
      const auto axyz_0 = current_data[133];
      const auto ayyz_0 = current_data[134];
      const auto axzz_0 = current_data[140];
      const auto ayzz_0 = current_data[141];
      const auto azzz_0 = current_data[147];
      const auto axxxx_0 = current_data[179];
      const auto axxxy_0 = current_data[180];
      const auto axxyy_0 = current_data[181];
      const auto axyyy_0 = current_data[182];
      const auto ayyyy_0 = current_data[183];
      const auto axxxz_0 = current_data[189];
      const auto axxyz_0 = current_data[190];
      const auto axyyz_0 = current_data[191];
      const auto ayyyz_0 = current_data[192];
      const auto axxzz_0 = current_data[198];
      const auto axyzz_0 = current_data[199];
      const auto ayyzz_0 = current_data[200];
      const auto axzzz_0 = current_data[206];
      const auto ayzzz_0 = current_data[207];
      const auto azzzz_0 = current_data[213];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[165] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[166] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[167] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[168] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[169] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[170] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[171] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[172] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[173] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[174] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[175] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[176] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[177] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[178] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[179] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyyyz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[41];
      const auto ay_0 = current_data[42];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[78];
      const auto axy_0 = current_data[79];
      const auto ayy_0 = current_data[80];
      const auto axz_0 = current_data[86];
      const auto ayz_0 = current_data[87];
      const auto azz_0 = current_data[93];
      const auto axxx_0 = current_data[124];
      const auto axxy_0 = current_data[125];
      const auto axyy_0 = current_data[126];
      const auto ayyy_0 = current_data[127];
      const auto axxz_0 = current_data[133];
      const auto axyz_0 = current_data[134];
      const auto ayyz_0 = current_data[135];
      const auto axzz_0 = current_data[141];
      const auto ayzz_0 = current_data[142];
      const auto azzz_0 = current_data[148];
      const auto axxxx_0 = current_data[180];
      const auto axxxy_0 = current_data[181];
      const auto axxyy_0 = current_data[182];
      const auto axyyy_0 = current_data[183];
      const auto ayyyy_0 = current_data[184];
      const auto axxxz_0 = current_data[190];
      const auto axxyz_0 = current_data[191];
      const auto axyyz_0 = current_data[192];
      const auto ayyyz_0 = current_data[193];
      const auto axxzz_0 = current_data[199];
      const auto axyzz_0 = current_data[200];
      const auto ayyzz_0 = current_data[201];
      const auto axzzz_0 = current_data[207];
      const auto ayzzz_0 = current_data[208];
      const auto azzzz_0 = current_data[214];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[180] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[181] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[182] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[183] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[184] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[185] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[186] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[187] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[188] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[189] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[190] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[191] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[192] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[193] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[194] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxzz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[43];
      const auto ay_0 = current_data[44];
      const auto az_0 = current_data[49];
      const auto axx_0 = current_data[81];
      const auto axy_0 = current_data[82];
      const auto ayy_0 = current_data[83];
      const auto axz_0 = current_data[88];
      const auto ayz_0 = current_data[89];
      const auto azz_0 = current_data[94];
      const auto axxx_0 = current_data[128];
      const auto axxy_0 = current_data[129];
      const auto axyy_0 = current_data[130];
      const auto ayyy_0 = current_data[131];
      const auto axxz_0 = current_data[136];
      const auto axyz_0 = current_data[137];
      const auto ayyz_0 = current_data[138];
      const auto axzz_0 = current_data[143];
      const auto ayzz_0 = current_data[144];
      const auto azzz_0 = current_data[149];
      const auto axxxx_0 = current_data[185];
      const auto axxxy_0 = current_data[186];
      const auto axxyy_0 = current_data[187];
      const auto axyyy_0 = current_data[188];
      const auto ayyyy_0 = current_data[189];
      const auto axxxz_0 = current_data[194];
      const auto axxyz_0 = current_data[195];
      const auto axyyz_0 = current_data[196];
      const auto ayyyz_0 = current_data[197];
      const auto axxzz_0 = current_data[202];
      const auto axyzz_0 = current_data[203];
      const auto ayyzz_0 = current_data[204];
      const auto axzzz_0 = current_data[209];
      const auto ayzzz_0 = current_data[210];
      const auto azzzz_0 = current_data[215];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[195] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[196] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[197] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[198] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[199] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[200] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[201] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[202] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[203] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[204] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[205] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[206] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[207] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[208] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[209] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxyzz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[44];
      const auto ay_0 = current_data[45];
      const auto az_0 = current_data[50];
      const auto axx_0 = current_data[82];
      const auto axy_0 = current_data[83];
      const auto ayy_0 = current_data[84];
      const auto axz_0 = current_data[89];
      const auto ayz_0 = current_data[90];
      const auto azz_0 = current_data[95];
      const auto axxx_0 = current_data[129];
      const auto axxy_0 = current_data[130];
      const auto axyy_0 = current_data[131];
      const auto ayyy_0 = current_data[132];
      const auto axxz_0 = current_data[137];
      const auto axyz_0 = current_data[138];
      const auto ayyz_0 = current_data[139];
      const auto axzz_0 = current_data[144];
      const auto ayzz_0 = current_data[145];
      const auto azzz_0 = current_data[150];
      const auto axxxx_0 = current_data[186];
      const auto axxxy_0 = current_data[187];
      const auto axxyy_0 = current_data[188];
      const auto axyyy_0 = current_data[189];
      const auto ayyyy_0 = current_data[190];
      const auto axxxz_0 = current_data[195];
      const auto axxyz_0 = current_data[196];
      const auto axyyz_0 = current_data[197];
      const auto ayyyz_0 = current_data[198];
      const auto axxzz_0 = current_data[203];
      const auto axyzz_0 = current_data[204];
      const auto ayyzz_0 = current_data[205];
      const auto axzzz_0 = current_data[210];
      const auto ayzzz_0 = current_data[211];
      const auto azzzz_0 = current_data[216];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[210] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[211] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[212] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[213] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[214] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[215] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[216] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[217] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[218] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[219] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[220] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[221] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[222] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[223] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[224] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyyzz
      const auto a0_0 = current_data[15];
      const auto ax_0 = current_data[45];
      const auto ay_0 = current_data[46];
      const auto az_0 = current_data[51];
      const auto axx_0 = current_data[83];
      const auto axy_0 = current_data[84];
      const auto ayy_0 = current_data[85];
      const auto axz_0 = current_data[90];
      const auto ayz_0 = current_data[91];
      const auto azz_0 = current_data[96];
      const auto axxx_0 = current_data[130];
      const auto axxy_0 = current_data[131];
      const auto axyy_0 = current_data[132];
      const auto ayyy_0 = current_data[133];
      const auto axxz_0 = current_data[138];
      const auto axyz_0 = current_data[139];
      const auto ayyz_0 = current_data[140];
      const auto axzz_0 = current_data[145];
      const auto ayzz_0 = current_data[146];
      const auto azzz_0 = current_data[151];
      const auto axxxx_0 = current_data[187];
      const auto axxxy_0 = current_data[188];
      const auto axxyy_0 = current_data[189];
      const auto axyyy_0 = current_data[190];
      const auto ayyyy_0 = current_data[191];
      const auto axxxz_0 = current_data[196];
      const auto axxyz_0 = current_data[197];
      const auto axyyz_0 = current_data[198];
      const auto ayyyz_0 = current_data[199];
      const auto axxzz_0 = current_data[204];
      const auto axyzz_0 = current_data[205];
      const auto ayyzz_0 = current_data[206];
      const auto axzzz_0 = current_data[211];
      const auto ayzzz_0 = current_data[212];
      const auto azzzz_0 = current_data[217];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[225] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[226] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[227] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[228] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[229] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[230] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[231] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[232] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[233] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[234] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[235] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[236] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[237] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[238] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[239] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyyzz
      const auto a0_0 = current_data[16];
      const auto ax_0 = current_data[46];
      const auto ay_0 = current_data[47];
      const auto az_0 = current_data[52];
      const auto axx_0 = current_data[84];
      const auto axy_0 = current_data[85];
      const auto ayy_0 = current_data[86];
      const auto axz_0 = current_data[91];
      const auto ayz_0 = current_data[92];
      const auto azz_0 = current_data[97];
      const auto axxx_0 = current_data[131];
      const auto axxy_0 = current_data[132];
      const auto axyy_0 = current_data[133];
      const auto ayyy_0 = current_data[134];
      const auto axxz_0 = current_data[139];
      const auto axyz_0 = current_data[140];
      const auto ayyz_0 = current_data[141];
      const auto axzz_0 = current_data[146];
      const auto ayzz_0 = current_data[147];
      const auto azzz_0 = current_data[152];
      const auto axxxx_0 = current_data[188];
      const auto axxxy_0 = current_data[189];
      const auto axxyy_0 = current_data[190];
      const auto axyyy_0 = current_data[191];
      const auto ayyyy_0 = current_data[192];
      const auto axxxz_0 = current_data[197];
      const auto axxyz_0 = current_data[198];
      const auto axyyz_0 = current_data[199];
      const auto ayyyz_0 = current_data[200];
      const auto axxzz_0 = current_data[205];
      const auto axyzz_0 = current_data[206];
      const auto ayyzz_0 = current_data[207];
      const auto axzzz_0 = current_data[212];
      const auto ayzzz_0 = current_data[213];
      const auto azzzz_0 = current_data[218];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[240] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[241] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[242] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[243] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[244] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[245] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[246] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[247] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[248] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[249] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[250] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[251] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[252] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[253] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[254] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyyzz
      const auto a0_0 = current_data[17];
      const auto ax_0 = current_data[47];
      const auto ay_0 = current_data[48];
      const auto az_0 = current_data[53];
      const auto axx_0 = current_data[85];
      const auto axy_0 = current_data[86];
      const auto ayy_0 = current_data[87];
      const auto axz_0 = current_data[92];
      const auto ayz_0 = current_data[93];
      const auto azz_0 = current_data[98];
      const auto axxx_0 = current_data[132];
      const auto axxy_0 = current_data[133];
      const auto axyy_0 = current_data[134];
      const auto ayyy_0 = current_data[135];
      const auto axxz_0 = current_data[140];
      const auto axyz_0 = current_data[141];
      const auto ayyz_0 = current_data[142];
      const auto axzz_0 = current_data[147];
      const auto ayzz_0 = current_data[148];
      const auto azzz_0 = current_data[153];
      const auto axxxx_0 = current_data[189];
      const auto axxxy_0 = current_data[190];
      const auto axxyy_0 = current_data[191];
      const auto axyyy_0 = current_data[192];
      const auto ayyyy_0 = current_data[193];
      const auto axxxz_0 = current_data[198];
      const auto axxyz_0 = current_data[199];
      const auto axyyz_0 = current_data[200];
      const auto ayyyz_0 = current_data[201];
      const auto axxzz_0 = current_data[206];
      const auto axyzz_0 = current_data[207];
      const auto ayyzz_0 = current_data[208];
      const auto axzzz_0 = current_data[213];
      const auto ayzzz_0 = current_data[214];
      const auto azzzz_0 = current_data[219];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[255] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[256] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[257] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[258] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[259] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[260] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[261] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[262] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[263] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[264] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[265] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[266] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[267] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[268] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[269] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxzzz
      const auto a0_0 = current_data[18];
      const auto ax_0 = current_data[49];
      const auto ay_0 = current_data[50];
      const auto az_0 = current_data[54];
      const auto axx_0 = current_data[88];
      const auto axy_0 = current_data[89];
      const auto ayy_0 = current_data[90];
      const auto axz_0 = current_data[94];
      const auto ayz_0 = current_data[95];
      const auto azz_0 = current_data[99];
      const auto axxx_0 = current_data[136];
      const auto axxy_0 = current_data[137];
      const auto axyy_0 = current_data[138];
      const auto ayyy_0 = current_data[139];
      const auto axxz_0 = current_data[143];
      const auto axyz_0 = current_data[144];
      const auto ayyz_0 = current_data[145];
      const auto axzz_0 = current_data[149];
      const auto ayzz_0 = current_data[150];
      const auto azzz_0 = current_data[154];
      const auto axxxx_0 = current_data[194];
      const auto axxxy_0 = current_data[195];
      const auto axxyy_0 = current_data[196];
      const auto axyyy_0 = current_data[197];
      const auto ayyyy_0 = current_data[198];
      const auto axxxz_0 = current_data[202];
      const auto axxyz_0 = current_data[203];
      const auto axyyz_0 = current_data[204];
      const auto ayyyz_0 = current_data[205];
      const auto axxzz_0 = current_data[209];
      const auto axyzz_0 = current_data[210];
      const auto ayyzz_0 = current_data[211];
      const auto axzzz_0 = current_data[215];
      const auto ayzzz_0 = current_data[216];
      const auto azzzz_0 = current_data[220];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[270] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[271] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[272] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[273] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[274] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[275] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[276] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[277] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[278] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[279] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[280] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[281] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[282] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[283] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[284] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyzzz
      const auto a0_0 = current_data[19];
      const auto ax_0 = current_data[50];
      const auto ay_0 = current_data[51];
      const auto az_0 = current_data[55];
      const auto axx_0 = current_data[89];
      const auto axy_0 = current_data[90];
      const auto ayy_0 = current_data[91];
      const auto axz_0 = current_data[95];
      const auto ayz_0 = current_data[96];
      const auto azz_0 = current_data[100];
      const auto axxx_0 = current_data[137];
      const auto axxy_0 = current_data[138];
      const auto axyy_0 = current_data[139];
      const auto ayyy_0 = current_data[140];
      const auto axxz_0 = current_data[144];
      const auto axyz_0 = current_data[145];
      const auto ayyz_0 = current_data[146];
      const auto axzz_0 = current_data[150];
      const auto ayzz_0 = current_data[151];
      const auto azzz_0 = current_data[155];
      const auto axxxx_0 = current_data[195];
      const auto axxxy_0 = current_data[196];
      const auto axxyy_0 = current_data[197];
      const auto axyyy_0 = current_data[198];
      const auto ayyyy_0 = current_data[199];
      const auto axxxz_0 = current_data[203];
      const auto axxyz_0 = current_data[204];
      const auto axyyz_0 = current_data[205];
      const auto ayyyz_0 = current_data[206];
      const auto axxzz_0 = current_data[210];
      const auto axyzz_0 = current_data[211];
      const auto ayyzz_0 = current_data[212];
      const auto axzzz_0 = current_data[216];
      const auto ayzzz_0 = current_data[217];
      const auto azzzz_0 = current_data[221];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[285] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[286] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[287] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[288] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[289] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[290] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[291] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[292] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[293] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[294] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[295] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[296] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[297] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[298] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[299] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyzzz
      const auto a0_0 = current_data[20];
      const auto ax_0 = current_data[51];
      const auto ay_0 = current_data[52];
      const auto az_0 = current_data[56];
      const auto axx_0 = current_data[90];
      const auto axy_0 = current_data[91];
      const auto ayy_0 = current_data[92];
      const auto axz_0 = current_data[96];
      const auto ayz_0 = current_data[97];
      const auto azz_0 = current_data[101];
      const auto axxx_0 = current_data[138];
      const auto axxy_0 = current_data[139];
      const auto axyy_0 = current_data[140];
      const auto ayyy_0 = current_data[141];
      const auto axxz_0 = current_data[145];
      const auto axyz_0 = current_data[146];
      const auto ayyz_0 = current_data[147];
      const auto axzz_0 = current_data[151];
      const auto ayzz_0 = current_data[152];
      const auto azzz_0 = current_data[156];
      const auto axxxx_0 = current_data[196];
      const auto axxxy_0 = current_data[197];
      const auto axxyy_0 = current_data[198];
      const auto axyyy_0 = current_data[199];
      const auto ayyyy_0 = current_data[200];
      const auto axxxz_0 = current_data[204];
      const auto axxyz_0 = current_data[205];
      const auto axyyz_0 = current_data[206];
      const auto ayyyz_0 = current_data[207];
      const auto axxzz_0 = current_data[211];
      const auto axyzz_0 = current_data[212];
      const auto ayyzz_0 = current_data[213];
      const auto axzzz_0 = current_data[217];
      const auto ayzzz_0 = current_data[218];
      const auto azzzz_0 = current_data[222];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[300] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[301] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[302] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[303] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[304] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[305] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[306] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[307] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[308] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[309] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[310] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[311] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[312] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[313] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[314] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyzzz
      const auto a0_0 = current_data[21];
      const auto ax_0 = current_data[52];
      const auto ay_0 = current_data[53];
      const auto az_0 = current_data[57];
      const auto axx_0 = current_data[91];
      const auto axy_0 = current_data[92];
      const auto ayy_0 = current_data[93];
      const auto axz_0 = current_data[97];
      const auto ayz_0 = current_data[98];
      const auto azz_0 = current_data[102];
      const auto axxx_0 = current_data[139];
      const auto axxy_0 = current_data[140];
      const auto axyy_0 = current_data[141];
      const auto ayyy_0 = current_data[142];
      const auto axxz_0 = current_data[146];
      const auto axyz_0 = current_data[147];
      const auto ayyz_0 = current_data[148];
      const auto axzz_0 = current_data[152];
      const auto ayzz_0 = current_data[153];
      const auto azzz_0 = current_data[157];
      const auto axxxx_0 = current_data[197];
      const auto axxxy_0 = current_data[198];
      const auto axxyy_0 = current_data[199];
      const auto axyyy_0 = current_data[200];
      const auto ayyyy_0 = current_data[201];
      const auto axxxz_0 = current_data[205];
      const auto axxyz_0 = current_data[206];
      const auto axyyz_0 = current_data[207];
      const auto ayyyz_0 = current_data[208];
      const auto axxzz_0 = current_data[212];
      const auto axyzz_0 = current_data[213];
      const auto ayyzz_0 = current_data[214];
      const auto axzzz_0 = current_data[218];
      const auto ayzzz_0 = current_data[219];
      const auto azzzz_0 = current_data[223];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[315] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[316] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[317] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[318] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[319] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[320] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[321] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[322] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[323] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[324] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[325] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[326] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[327] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[328] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[329] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxzzzz
      const auto a0_0 = current_data[22];
      const auto ax_0 = current_data[54];
      const auto ay_0 = current_data[55];
      const auto az_0 = current_data[58];
      const auto axx_0 = current_data[94];
      const auto axy_0 = current_data[95];
      const auto ayy_0 = current_data[96];
      const auto axz_0 = current_data[99];
      const auto ayz_0 = current_data[100];
      const auto azz_0 = current_data[103];
      const auto axxx_0 = current_data[143];
      const auto axxy_0 = current_data[144];
      const auto axyy_0 = current_data[145];
      const auto ayyy_0 = current_data[146];
      const auto axxz_0 = current_data[149];
      const auto axyz_0 = current_data[150];
      const auto ayyz_0 = current_data[151];
      const auto axzz_0 = current_data[154];
      const auto ayzz_0 = current_data[155];
      const auto azzz_0 = current_data[158];
      const auto axxxx_0 = current_data[202];
      const auto axxxy_0 = current_data[203];
      const auto axxyy_0 = current_data[204];
      const auto axyyy_0 = current_data[205];
      const auto ayyyy_0 = current_data[206];
      const auto axxxz_0 = current_data[209];
      const auto axxyz_0 = current_data[210];
      const auto axyyz_0 = current_data[211];
      const auto ayyyz_0 = current_data[212];
      const auto axxzz_0 = current_data[215];
      const auto axyzz_0 = current_data[216];
      const auto ayyzz_0 = current_data[217];
      const auto axzzz_0 = current_data[220];
      const auto ayzzz_0 = current_data[221];
      const auto azzzz_0 = current_data[224];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[330] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[331] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[332] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[333] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[334] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[335] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[336] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[337] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[338] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[339] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[340] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[341] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[342] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[343] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[344] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyzzzz
      const auto a0_0 = current_data[23];
      const auto ax_0 = current_data[55];
      const auto ay_0 = current_data[56];
      const auto az_0 = current_data[59];
      const auto axx_0 = current_data[95];
      const auto axy_0 = current_data[96];
      const auto ayy_0 = current_data[97];
      const auto axz_0 = current_data[100];
      const auto ayz_0 = current_data[101];
      const auto azz_0 = current_data[104];
      const auto axxx_0 = current_data[144];
      const auto axxy_0 = current_data[145];
      const auto axyy_0 = current_data[146];
      const auto ayyy_0 = current_data[147];
      const auto axxz_0 = current_data[150];
      const auto axyz_0 = current_data[151];
      const auto ayyz_0 = current_data[152];
      const auto axzz_0 = current_data[155];
      const auto ayzz_0 = current_data[156];
      const auto azzz_0 = current_data[159];
      const auto axxxx_0 = current_data[203];
      const auto axxxy_0 = current_data[204];
      const auto axxyy_0 = current_data[205];
      const auto axyyy_0 = current_data[206];
      const auto ayyyy_0 = current_data[207];
      const auto axxxz_0 = current_data[210];
      const auto axxyz_0 = current_data[211];
      const auto axyyz_0 = current_data[212];
      const auto ayyyz_0 = current_data[213];
      const auto axxzz_0 = current_data[216];
      const auto axyzz_0 = current_data[217];
      const auto ayyzz_0 = current_data[218];
      const auto axzzz_0 = current_data[221];
      const auto ayzzz_0 = current_data[222];
      const auto azzzz_0 = current_data[225];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[345] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[346] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[347] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[348] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[349] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[350] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[351] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[352] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[353] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[354] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[355] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[356] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[357] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[358] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[359] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyzzzz
      const auto a0_0 = current_data[24];
      const auto ax_0 = current_data[56];
      const auto ay_0 = current_data[57];
      const auto az_0 = current_data[60];
      const auto axx_0 = current_data[96];
      const auto axy_0 = current_data[97];
      const auto ayy_0 = current_data[98];
      const auto axz_0 = current_data[101];
      const auto ayz_0 = current_data[102];
      const auto azz_0 = current_data[105];
      const auto axxx_0 = current_data[145];
      const auto axxy_0 = current_data[146];
      const auto axyy_0 = current_data[147];
      const auto ayyy_0 = current_data[148];
      const auto axxz_0 = current_data[151];
      const auto axyz_0 = current_data[152];
      const auto ayyz_0 = current_data[153];
      const auto axzz_0 = current_data[156];
      const auto ayzz_0 = current_data[157];
      const auto azzz_0 = current_data[160];
      const auto axxxx_0 = current_data[204];
      const auto axxxy_0 = current_data[205];
      const auto axxyy_0 = current_data[206];
      const auto axyyy_0 = current_data[207];
      const auto ayyyy_0 = current_data[208];
      const auto axxxz_0 = current_data[211];
      const auto axxyz_0 = current_data[212];
      const auto axyyz_0 = current_data[213];
      const auto ayyyz_0 = current_data[214];
      const auto axxzz_0 = current_data[217];
      const auto axyzz_0 = current_data[218];
      const auto ayyzz_0 = current_data[219];
      const auto axzzz_0 = current_data[222];
      const auto ayzzz_0 = current_data[223];
      const auto azzzz_0 = current_data[226];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[360] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[361] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[362] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[363] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[364] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[365] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[366] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[367] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[368] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[369] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[370] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[371] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[372] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[373] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[374] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xzzzzz
      const auto a0_0 = current_data[25];
      const auto ax_0 = current_data[58];
      const auto ay_0 = current_data[59];
      const auto az_0 = current_data[61];
      const auto axx_0 = current_data[99];
      const auto axy_0 = current_data[100];
      const auto ayy_0 = current_data[101];
      const auto axz_0 = current_data[103];
      const auto ayz_0 = current_data[104];
      const auto azz_0 = current_data[106];
      const auto axxx_0 = current_data[149];
      const auto axxy_0 = current_data[150];
      const auto axyy_0 = current_data[151];
      const auto ayyy_0 = current_data[152];
      const auto axxz_0 = current_data[154];
      const auto axyz_0 = current_data[155];
      const auto ayyz_0 = current_data[156];
      const auto axzz_0 = current_data[158];
      const auto ayzz_0 = current_data[159];
      const auto azzz_0 = current_data[161];
      const auto axxxx_0 = current_data[209];
      const auto axxxy_0 = current_data[210];
      const auto axxyy_0 = current_data[211];
      const auto axyyy_0 = current_data[212];
      const auto ayyyy_0 = current_data[213];
      const auto axxxz_0 = current_data[215];
      const auto axxyz_0 = current_data[216];
      const auto axyyz_0 = current_data[217];
      const auto ayyyz_0 = current_data[218];
      const auto axxzz_0 = current_data[220];
      const auto axyzz_0 = current_data[221];
      const auto ayyzz_0 = current_data[222];
      const auto axzzz_0 = current_data[224];
      const auto ayzzz_0 = current_data[225];
      const auto azzzz_0 = current_data[227];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[375] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[376] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[377] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[378] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[379] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[380] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[381] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[382] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[383] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[384] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[385] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[386] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[387] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[388] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[389] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yzzzzz
      const auto a0_0 = current_data[26];
      const auto ax_0 = current_data[59];
      const auto ay_0 = current_data[60];
      const auto az_0 = current_data[62];
      const auto axx_0 = current_data[100];
      const auto axy_0 = current_data[101];
      const auto ayy_0 = current_data[102];
      const auto axz_0 = current_data[104];
      const auto ayz_0 = current_data[105];
      const auto azz_0 = current_data[107];
      const auto axxx_0 = current_data[150];
      const auto axxy_0 = current_data[151];
      const auto axyy_0 = current_data[152];
      const auto ayyy_0 = current_data[153];
      const auto axxz_0 = current_data[155];
      const auto axyz_0 = current_data[156];
      const auto ayyz_0 = current_data[157];
      const auto axzz_0 = current_data[159];
      const auto ayzz_0 = current_data[160];
      const auto azzz_0 = current_data[162];
      const auto axxxx_0 = current_data[210];
      const auto axxxy_0 = current_data[211];
      const auto axxyy_0 = current_data[212];
      const auto axyyy_0 = current_data[213];
      const auto ayyyy_0 = current_data[214];
      const auto axxxz_0 = current_data[216];
      const auto axxyz_0 = current_data[217];
      const auto axyyz_0 = current_data[218];
      const auto ayyyz_0 = current_data[219];
      const auto axxzz_0 = current_data[221];
      const auto axyzz_0 = current_data[222];
      const auto ayyzz_0 = current_data[223];
      const auto axzzz_0 = current_data[225];
      const auto ayzzz_0 = current_data[226];
      const auto azzzz_0 = current_data[228];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[390] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[391] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[392] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[393] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[394] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[395] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[396] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[397] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[398] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[399] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[400] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[401] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[402] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[403] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[404] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: zzzzzz
      const auto a0_0 = current_data[27];
      const auto ax_0 = current_data[61];
      const auto ay_0 = current_data[62];
      const auto az_0 = current_data[63];
      const auto axx_0 = current_data[103];
      const auto axy_0 = current_data[104];
      const auto ayy_0 = current_data[105];
      const auto axz_0 = current_data[106];
      const auto ayz_0 = current_data[107];
      const auto azz_0 = current_data[108];
      const auto axxx_0 = current_data[154];
      const auto axxy_0 = current_data[155];
      const auto axyy_0 = current_data[156];
      const auto ayyy_0 = current_data[157];
      const auto axxz_0 = current_data[158];
      const auto axyz_0 = current_data[159];
      const auto ayyz_0 = current_data[160];
      const auto axzz_0 = current_data[161];
      const auto ayzz_0 = current_data[162];
      const auto azzz_0 = current_data[163];
      const auto axxxx_0 = current_data[215];
      const auto axxxy_0 = current_data[216];
      const auto axxyy_0 = current_data[217];
      const auto axyyy_0 = current_data[218];
      const auto ayyyy_0 = current_data[219];
      const auto axxxz_0 = current_data[220];
      const auto axxyz_0 = current_data[221];
      const auto axyyz_0 = current_data[222];
      const auto ayyyz_0 = current_data[223];
      const auto axxzz_0 = current_data[224];
      const auto axyzz_0 = current_data[225];
      const auto ayyzz_0 = current_data[226];
      const auto axzzz_0 = current_data[227];
      const auto ayzzz_0 = current_data[228];
      const auto azzzz_0 = current_data[229];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[405] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[406] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[407] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[408] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[409] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[410] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[411] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[412] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[413] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[414] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[415] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[416] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[417] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[418] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[419] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
  }
}


void CHRRList::perform_HRR_a0_64(const int nloop, const complex<double>* data_start, const array<double,3>& AB, complex<double>* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 230];
    auto current_out = &data_out[c * 420];
   {
     //current index a: xxxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[28];
      const auto ay_0 = current_data[29];
      const auto az_0 = current_data[36];
      const auto axx_0 = current_data[64];
      const auto axy_0 = current_data[65];
      const auto ayy_0 = current_data[66];
      const auto axz_0 = current_data[73];
      const auto ayz_0 = current_data[74];
      const auto azz_0 = current_data[81];
      const auto axxx_0 = current_data[109];
      const auto axxy_0 = current_data[110];
      const auto axyy_0 = current_data[111];
      const auto ayyy_0 = current_data[112];
      const auto axxz_0 = current_data[119];
      const auto axyz_0 = current_data[120];
      const auto ayyz_0 = current_data[121];
      const auto axzz_0 = current_data[128];
      const auto ayzz_0 = current_data[129];
      const auto azzz_0 = current_data[136];
      const auto axxxx_0 = current_data[164];
      const auto axxxy_0 = current_data[165];
      const auto axxyy_0 = current_data[166];
      const auto axyyy_0 = current_data[167];
      const auto ayyyy_0 = current_data[168];
      const auto axxxz_0 = current_data[175];
      const auto axxyz_0 = current_data[176];
      const auto axyyz_0 = current_data[177];
      const auto ayyyz_0 = current_data[178];
      const auto axxzz_0 = current_data[185];
      const auto axyzz_0 = current_data[186];
      const auto ayyzz_0 = current_data[187];
      const auto axzzz_0 = current_data[194];
      const auto ayzzz_0 = current_data[195];
      const auto azzzz_0 = current_data[202];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[0] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[1] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[2] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[3] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[4] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[5] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[6] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[7] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[8] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[9] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[10] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[11] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[12] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[13] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[14] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[29];
      const auto ay_0 = current_data[30];
      const auto az_0 = current_data[37];
      const auto axx_0 = current_data[65];
      const auto axy_0 = current_data[66];
      const auto ayy_0 = current_data[67];
      const auto axz_0 = current_data[74];
      const auto ayz_0 = current_data[75];
      const auto azz_0 = current_data[82];
      const auto axxx_0 = current_data[110];
      const auto axxy_0 = current_data[111];
      const auto axyy_0 = current_data[112];
      const auto ayyy_0 = current_data[113];
      const auto axxz_0 = current_data[120];
      const auto axyz_0 = current_data[121];
      const auto ayyz_0 = current_data[122];
      const auto axzz_0 = current_data[129];
      const auto ayzz_0 = current_data[130];
      const auto azzz_0 = current_data[137];
      const auto axxxx_0 = current_data[165];
      const auto axxxy_0 = current_data[166];
      const auto axxyy_0 = current_data[167];
      const auto axyyy_0 = current_data[168];
      const auto ayyyy_0 = current_data[169];
      const auto axxxz_0 = current_data[176];
      const auto axxyz_0 = current_data[177];
      const auto axyyz_0 = current_data[178];
      const auto ayyyz_0 = current_data[179];
      const auto axxzz_0 = current_data[186];
      const auto axyzz_0 = current_data[187];
      const auto ayyzz_0 = current_data[188];
      const auto axzzz_0 = current_data[195];
      const auto ayzzz_0 = current_data[196];
      const auto azzzz_0 = current_data[203];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[15] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[16] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[17] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[18] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[19] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[20] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[21] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[22] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[23] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[24] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[25] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[26] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[27] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[28] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[29] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[30];
      const auto ay_0 = current_data[31];
      const auto az_0 = current_data[38];
      const auto axx_0 = current_data[66];
      const auto axy_0 = current_data[67];
      const auto ayy_0 = current_data[68];
      const auto axz_0 = current_data[75];
      const auto ayz_0 = current_data[76];
      const auto azz_0 = current_data[83];
      const auto axxx_0 = current_data[111];
      const auto axxy_0 = current_data[112];
      const auto axyy_0 = current_data[113];
      const auto ayyy_0 = current_data[114];
      const auto axxz_0 = current_data[121];
      const auto axyz_0 = current_data[122];
      const auto ayyz_0 = current_data[123];
      const auto axzz_0 = current_data[130];
      const auto ayzz_0 = current_data[131];
      const auto azzz_0 = current_data[138];
      const auto axxxx_0 = current_data[166];
      const auto axxxy_0 = current_data[167];
      const auto axxyy_0 = current_data[168];
      const auto axyyy_0 = current_data[169];
      const auto ayyyy_0 = current_data[170];
      const auto axxxz_0 = current_data[177];
      const auto axxyz_0 = current_data[178];
      const auto axyyz_0 = current_data[179];
      const auto ayyyz_0 = current_data[180];
      const auto axxzz_0 = current_data[187];
      const auto axyzz_0 = current_data[188];
      const auto ayyzz_0 = current_data[189];
      const auto axzzz_0 = current_data[196];
      const auto ayzzz_0 = current_data[197];
      const auto azzzz_0 = current_data[204];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[30] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[31] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[32] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[33] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[34] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[35] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[36] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[37] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[38] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[39] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[40] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[41] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[42] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[43] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[44] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[31];
      const auto ay_0 = current_data[32];
      const auto az_0 = current_data[39];
      const auto axx_0 = current_data[67];
      const auto axy_0 = current_data[68];
      const auto ayy_0 = current_data[69];
      const auto axz_0 = current_data[76];
      const auto ayz_0 = current_data[77];
      const auto azz_0 = current_data[84];
      const auto axxx_0 = current_data[112];
      const auto axxy_0 = current_data[113];
      const auto axyy_0 = current_data[114];
      const auto ayyy_0 = current_data[115];
      const auto axxz_0 = current_data[122];
      const auto axyz_0 = current_data[123];
      const auto ayyz_0 = current_data[124];
      const auto axzz_0 = current_data[131];
      const auto ayzz_0 = current_data[132];
      const auto azzz_0 = current_data[139];
      const auto axxxx_0 = current_data[167];
      const auto axxxy_0 = current_data[168];
      const auto axxyy_0 = current_data[169];
      const auto axyyy_0 = current_data[170];
      const auto ayyyy_0 = current_data[171];
      const auto axxxz_0 = current_data[178];
      const auto axxyz_0 = current_data[179];
      const auto axyyz_0 = current_data[180];
      const auto ayyyz_0 = current_data[181];
      const auto axxzz_0 = current_data[188];
      const auto axyzz_0 = current_data[189];
      const auto ayyzz_0 = current_data[190];
      const auto axzzz_0 = current_data[197];
      const auto ayzzz_0 = current_data[198];
      const auto azzzz_0 = current_data[205];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[45] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[46] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[47] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[48] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[49] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[50] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[51] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[52] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[53] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[54] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[55] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[56] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[57] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[58] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[59] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[32];
      const auto ay_0 = current_data[33];
      const auto az_0 = current_data[40];
      const auto axx_0 = current_data[68];
      const auto axy_0 = current_data[69];
      const auto ayy_0 = current_data[70];
      const auto axz_0 = current_data[77];
      const auto ayz_0 = current_data[78];
      const auto azz_0 = current_data[85];
      const auto axxx_0 = current_data[113];
      const auto axxy_0 = current_data[114];
      const auto axyy_0 = current_data[115];
      const auto ayyy_0 = current_data[116];
      const auto axxz_0 = current_data[123];
      const auto axyz_0 = current_data[124];
      const auto ayyz_0 = current_data[125];
      const auto axzz_0 = current_data[132];
      const auto ayzz_0 = current_data[133];
      const auto azzz_0 = current_data[140];
      const auto axxxx_0 = current_data[168];
      const auto axxxy_0 = current_data[169];
      const auto axxyy_0 = current_data[170];
      const auto axyyy_0 = current_data[171];
      const auto ayyyy_0 = current_data[172];
      const auto axxxz_0 = current_data[179];
      const auto axxyz_0 = current_data[180];
      const auto axyyz_0 = current_data[181];
      const auto ayyyz_0 = current_data[182];
      const auto axxzz_0 = current_data[189];
      const auto axyzz_0 = current_data[190];
      const auto ayyzz_0 = current_data[191];
      const auto axzzz_0 = current_data[198];
      const auto ayzzz_0 = current_data[199];
      const auto azzzz_0 = current_data[206];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[60] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[61] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[62] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[63] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[64] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[65] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[66] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[67] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[68] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[69] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[70] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[71] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[72] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[73] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[74] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyyyy
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[33];
      const auto ay_0 = current_data[34];
      const auto az_0 = current_data[41];
      const auto axx_0 = current_data[69];
      const auto axy_0 = current_data[70];
      const auto ayy_0 = current_data[71];
      const auto axz_0 = current_data[78];
      const auto ayz_0 = current_data[79];
      const auto azz_0 = current_data[86];
      const auto axxx_0 = current_data[114];
      const auto axxy_0 = current_data[115];
      const auto axyy_0 = current_data[116];
      const auto ayyy_0 = current_data[117];
      const auto axxz_0 = current_data[124];
      const auto axyz_0 = current_data[125];
      const auto ayyz_0 = current_data[126];
      const auto axzz_0 = current_data[133];
      const auto ayzz_0 = current_data[134];
      const auto azzz_0 = current_data[141];
      const auto axxxx_0 = current_data[169];
      const auto axxxy_0 = current_data[170];
      const auto axxyy_0 = current_data[171];
      const auto axyyy_0 = current_data[172];
      const auto ayyyy_0 = current_data[173];
      const auto axxxz_0 = current_data[180];
      const auto axxyz_0 = current_data[181];
      const auto axyyz_0 = current_data[182];
      const auto ayyyz_0 = current_data[183];
      const auto axxzz_0 = current_data[190];
      const auto axyzz_0 = current_data[191];
      const auto ayyzz_0 = current_data[192];
      const auto axzzz_0 = current_data[199];
      const auto ayzzz_0 = current_data[200];
      const auto azzzz_0 = current_data[207];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[75] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[76] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[77] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[78] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[79] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[80] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[81] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[82] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[83] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[84] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[85] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[86] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[87] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[88] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[89] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyyyy
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[34];
      const auto ay_0 = current_data[35];
      const auto az_0 = current_data[42];
      const auto axx_0 = current_data[70];
      const auto axy_0 = current_data[71];
      const auto ayy_0 = current_data[72];
      const auto axz_0 = current_data[79];
      const auto ayz_0 = current_data[80];
      const auto azz_0 = current_data[87];
      const auto axxx_0 = current_data[115];
      const auto axxy_0 = current_data[116];
      const auto axyy_0 = current_data[117];
      const auto ayyy_0 = current_data[118];
      const auto axxz_0 = current_data[125];
      const auto axyz_0 = current_data[126];
      const auto ayyz_0 = current_data[127];
      const auto axzz_0 = current_data[134];
      const auto ayzz_0 = current_data[135];
      const auto azzz_0 = current_data[142];
      const auto axxxx_0 = current_data[170];
      const auto axxxy_0 = current_data[171];
      const auto axxyy_0 = current_data[172];
      const auto axyyy_0 = current_data[173];
      const auto ayyyy_0 = current_data[174];
      const auto axxxz_0 = current_data[181];
      const auto axxyz_0 = current_data[182];
      const auto axyyz_0 = current_data[183];
      const auto ayyyz_0 = current_data[184];
      const auto axxzz_0 = current_data[191];
      const auto axyzz_0 = current_data[192];
      const auto ayyzz_0 = current_data[193];
      const auto axzzz_0 = current_data[200];
      const auto ayzzz_0 = current_data[201];
      const auto azzzz_0 = current_data[208];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[90] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[91] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[92] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[93] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[94] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[95] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[96] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[97] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[98] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[99] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[100] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[101] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[102] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[103] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[104] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxxz
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[43];
      const auto axx_0 = current_data[73];
      const auto axy_0 = current_data[74];
      const auto ayy_0 = current_data[75];
      const auto axz_0 = current_data[81];
      const auto ayz_0 = current_data[82];
      const auto azz_0 = current_data[88];
      const auto axxx_0 = current_data[119];
      const auto axxy_0 = current_data[120];
      const auto axyy_0 = current_data[121];
      const auto ayyy_0 = current_data[122];
      const auto axxz_0 = current_data[128];
      const auto axyz_0 = current_data[129];
      const auto ayyz_0 = current_data[130];
      const auto axzz_0 = current_data[136];
      const auto ayzz_0 = current_data[137];
      const auto azzz_0 = current_data[143];
      const auto axxxx_0 = current_data[175];
      const auto axxxy_0 = current_data[176];
      const auto axxyy_0 = current_data[177];
      const auto axyyy_0 = current_data[178];
      const auto ayyyy_0 = current_data[179];
      const auto axxxz_0 = current_data[185];
      const auto axxyz_0 = current_data[186];
      const auto axyyz_0 = current_data[187];
      const auto ayyyz_0 = current_data[188];
      const auto axxzz_0 = current_data[194];
      const auto axyzz_0 = current_data[195];
      const auto ayyzz_0 = current_data[196];
      const auto axzzz_0 = current_data[202];
      const auto ayzzz_0 = current_data[203];
      const auto azzzz_0 = current_data[209];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[105] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[106] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[107] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[108] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[109] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[110] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[111] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[112] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[113] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[114] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[115] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[116] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[117] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[118] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[119] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxyz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[44];
      const auto axx_0 = current_data[74];
      const auto axy_0 = current_data[75];
      const auto ayy_0 = current_data[76];
      const auto axz_0 = current_data[82];
      const auto ayz_0 = current_data[83];
      const auto azz_0 = current_data[89];
      const auto axxx_0 = current_data[120];
      const auto axxy_0 = current_data[121];
      const auto axyy_0 = current_data[122];
      const auto ayyy_0 = current_data[123];
      const auto axxz_0 = current_data[129];
      const auto axyz_0 = current_data[130];
      const auto ayyz_0 = current_data[131];
      const auto axzz_0 = current_data[137];
      const auto ayzz_0 = current_data[138];
      const auto azzz_0 = current_data[144];
      const auto axxxx_0 = current_data[176];
      const auto axxxy_0 = current_data[177];
      const auto axxyy_0 = current_data[178];
      const auto axyyy_0 = current_data[179];
      const auto ayyyy_0 = current_data[180];
      const auto axxxz_0 = current_data[186];
      const auto axxyz_0 = current_data[187];
      const auto axyyz_0 = current_data[188];
      const auto ayyyz_0 = current_data[189];
      const auto axxzz_0 = current_data[195];
      const auto axyzz_0 = current_data[196];
      const auto ayyzz_0 = current_data[197];
      const auto axzzz_0 = current_data[203];
      const auto ayzzz_0 = current_data[204];
      const auto azzzz_0 = current_data[210];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[120] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[121] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[122] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[123] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[124] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[125] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[126] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[127] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[128] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[129] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[130] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[131] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[132] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[133] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[134] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxyyz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[38];
      const auto ay_0 = current_data[39];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[75];
      const auto axy_0 = current_data[76];
      const auto ayy_0 = current_data[77];
      const auto axz_0 = current_data[83];
      const auto ayz_0 = current_data[84];
      const auto azz_0 = current_data[90];
      const auto axxx_0 = current_data[121];
      const auto axxy_0 = current_data[122];
      const auto axyy_0 = current_data[123];
      const auto ayyy_0 = current_data[124];
      const auto axxz_0 = current_data[130];
      const auto axyz_0 = current_data[131];
      const auto ayyz_0 = current_data[132];
      const auto axzz_0 = current_data[138];
      const auto ayzz_0 = current_data[139];
      const auto azzz_0 = current_data[145];
      const auto axxxx_0 = current_data[177];
      const auto axxxy_0 = current_data[178];
      const auto axxyy_0 = current_data[179];
      const auto axyyy_0 = current_data[180];
      const auto ayyyy_0 = current_data[181];
      const auto axxxz_0 = current_data[187];
      const auto axxyz_0 = current_data[188];
      const auto axyyz_0 = current_data[189];
      const auto ayyyz_0 = current_data[190];
      const auto axxzz_0 = current_data[196];
      const auto axyzz_0 = current_data[197];
      const auto ayyzz_0 = current_data[198];
      const auto axzzz_0 = current_data[204];
      const auto ayzzz_0 = current_data[205];
      const auto azzzz_0 = current_data[211];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[135] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[136] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[137] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[138] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[139] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[140] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[141] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[142] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[143] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[144] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[145] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[146] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[147] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[148] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[149] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyyyz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[76];
      const auto axy_0 = current_data[77];
      const auto ayy_0 = current_data[78];
      const auto axz_0 = current_data[84];
      const auto ayz_0 = current_data[85];
      const auto azz_0 = current_data[91];
      const auto axxx_0 = current_data[122];
      const auto axxy_0 = current_data[123];
      const auto axyy_0 = current_data[124];
      const auto ayyy_0 = current_data[125];
      const auto axxz_0 = current_data[131];
      const auto axyz_0 = current_data[132];
      const auto ayyz_0 = current_data[133];
      const auto axzz_0 = current_data[139];
      const auto ayzz_0 = current_data[140];
      const auto azzz_0 = current_data[146];
      const auto axxxx_0 = current_data[178];
      const auto axxxy_0 = current_data[179];
      const auto axxyy_0 = current_data[180];
      const auto axyyy_0 = current_data[181];
      const auto ayyyy_0 = current_data[182];
      const auto axxxz_0 = current_data[188];
      const auto axxyz_0 = current_data[189];
      const auto axyyz_0 = current_data[190];
      const auto ayyyz_0 = current_data[191];
      const auto axxzz_0 = current_data[197];
      const auto axyzz_0 = current_data[198];
      const auto ayyzz_0 = current_data[199];
      const auto axzzz_0 = current_data[205];
      const auto ayzzz_0 = current_data[206];
      const auto azzzz_0 = current_data[212];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[150] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[151] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[152] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[153] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[154] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[155] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[156] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[157] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[158] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[159] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[160] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[161] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[162] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[163] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[164] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyyyz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[77];
      const auto axy_0 = current_data[78];
      const auto ayy_0 = current_data[79];
      const auto axz_0 = current_data[85];
      const auto ayz_0 = current_data[86];
      const auto azz_0 = current_data[92];
      const auto axxx_0 = current_data[123];
      const auto axxy_0 = current_data[124];
      const auto axyy_0 = current_data[125];
      const auto ayyy_0 = current_data[126];
      const auto axxz_0 = current_data[132];
      const auto axyz_0 = current_data[133];
      const auto ayyz_0 = current_data[134];
      const auto axzz_0 = current_data[140];
      const auto ayzz_0 = current_data[141];
      const auto azzz_0 = current_data[147];
      const auto axxxx_0 = current_data[179];
      const auto axxxy_0 = current_data[180];
      const auto axxyy_0 = current_data[181];
      const auto axyyy_0 = current_data[182];
      const auto ayyyy_0 = current_data[183];
      const auto axxxz_0 = current_data[189];
      const auto axxyz_0 = current_data[190];
      const auto axyyz_0 = current_data[191];
      const auto ayyyz_0 = current_data[192];
      const auto axxzz_0 = current_data[198];
      const auto axyzz_0 = current_data[199];
      const auto ayyzz_0 = current_data[200];
      const auto axzzz_0 = current_data[206];
      const auto ayzzz_0 = current_data[207];
      const auto azzzz_0 = current_data[213];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[165] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[166] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[167] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[168] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[169] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[170] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[171] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[172] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[173] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[174] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[175] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[176] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[177] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[178] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[179] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyyyz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[41];
      const auto ay_0 = current_data[42];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[78];
      const auto axy_0 = current_data[79];
      const auto ayy_0 = current_data[80];
      const auto axz_0 = current_data[86];
      const auto ayz_0 = current_data[87];
      const auto azz_0 = current_data[93];
      const auto axxx_0 = current_data[124];
      const auto axxy_0 = current_data[125];
      const auto axyy_0 = current_data[126];
      const auto ayyy_0 = current_data[127];
      const auto axxz_0 = current_data[133];
      const auto axyz_0 = current_data[134];
      const auto ayyz_0 = current_data[135];
      const auto axzz_0 = current_data[141];
      const auto ayzz_0 = current_data[142];
      const auto azzz_0 = current_data[148];
      const auto axxxx_0 = current_data[180];
      const auto axxxy_0 = current_data[181];
      const auto axxyy_0 = current_data[182];
      const auto axyyy_0 = current_data[183];
      const auto ayyyy_0 = current_data[184];
      const auto axxxz_0 = current_data[190];
      const auto axxyz_0 = current_data[191];
      const auto axyyz_0 = current_data[192];
      const auto ayyyz_0 = current_data[193];
      const auto axxzz_0 = current_data[199];
      const auto axyzz_0 = current_data[200];
      const auto ayyzz_0 = current_data[201];
      const auto axzzz_0 = current_data[207];
      const auto ayzzz_0 = current_data[208];
      const auto azzzz_0 = current_data[214];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[180] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[181] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[182] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[183] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[184] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[185] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[186] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[187] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[188] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[189] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[190] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[191] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[192] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[193] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[194] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxxzz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[43];
      const auto ay_0 = current_data[44];
      const auto az_0 = current_data[49];
      const auto axx_0 = current_data[81];
      const auto axy_0 = current_data[82];
      const auto ayy_0 = current_data[83];
      const auto axz_0 = current_data[88];
      const auto ayz_0 = current_data[89];
      const auto azz_0 = current_data[94];
      const auto axxx_0 = current_data[128];
      const auto axxy_0 = current_data[129];
      const auto axyy_0 = current_data[130];
      const auto ayyy_0 = current_data[131];
      const auto axxz_0 = current_data[136];
      const auto axyz_0 = current_data[137];
      const auto ayyz_0 = current_data[138];
      const auto axzz_0 = current_data[143];
      const auto ayzz_0 = current_data[144];
      const auto azzz_0 = current_data[149];
      const auto axxxx_0 = current_data[185];
      const auto axxxy_0 = current_data[186];
      const auto axxyy_0 = current_data[187];
      const auto axyyy_0 = current_data[188];
      const auto ayyyy_0 = current_data[189];
      const auto axxxz_0 = current_data[194];
      const auto axxyz_0 = current_data[195];
      const auto axyyz_0 = current_data[196];
      const auto ayyyz_0 = current_data[197];
      const auto axxzz_0 = current_data[202];
      const auto axyzz_0 = current_data[203];
      const auto ayyzz_0 = current_data[204];
      const auto axzzz_0 = current_data[209];
      const auto ayzzz_0 = current_data[210];
      const auto azzzz_0 = current_data[215];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[195] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[196] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[197] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[198] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[199] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[200] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[201] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[202] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[203] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[204] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[205] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[206] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[207] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[208] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[209] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxyzz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[44];
      const auto ay_0 = current_data[45];
      const auto az_0 = current_data[50];
      const auto axx_0 = current_data[82];
      const auto axy_0 = current_data[83];
      const auto ayy_0 = current_data[84];
      const auto axz_0 = current_data[89];
      const auto ayz_0 = current_data[90];
      const auto azz_0 = current_data[95];
      const auto axxx_0 = current_data[129];
      const auto axxy_0 = current_data[130];
      const auto axyy_0 = current_data[131];
      const auto ayyy_0 = current_data[132];
      const auto axxz_0 = current_data[137];
      const auto axyz_0 = current_data[138];
      const auto ayyz_0 = current_data[139];
      const auto axzz_0 = current_data[144];
      const auto ayzz_0 = current_data[145];
      const auto azzz_0 = current_data[150];
      const auto axxxx_0 = current_data[186];
      const auto axxxy_0 = current_data[187];
      const auto axxyy_0 = current_data[188];
      const auto axyyy_0 = current_data[189];
      const auto ayyyy_0 = current_data[190];
      const auto axxxz_0 = current_data[195];
      const auto axxyz_0 = current_data[196];
      const auto axyyz_0 = current_data[197];
      const auto ayyyz_0 = current_data[198];
      const auto axxzz_0 = current_data[203];
      const auto axyzz_0 = current_data[204];
      const auto ayyzz_0 = current_data[205];
      const auto axzzz_0 = current_data[210];
      const auto ayzzz_0 = current_data[211];
      const auto azzzz_0 = current_data[216];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[210] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[211] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[212] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[213] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[214] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[215] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[216] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[217] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[218] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[219] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[220] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[221] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[222] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[223] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[224] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyyzz
      const auto a0_0 = current_data[15];
      const auto ax_0 = current_data[45];
      const auto ay_0 = current_data[46];
      const auto az_0 = current_data[51];
      const auto axx_0 = current_data[83];
      const auto axy_0 = current_data[84];
      const auto ayy_0 = current_data[85];
      const auto axz_0 = current_data[90];
      const auto ayz_0 = current_data[91];
      const auto azz_0 = current_data[96];
      const auto axxx_0 = current_data[130];
      const auto axxy_0 = current_data[131];
      const auto axyy_0 = current_data[132];
      const auto ayyy_0 = current_data[133];
      const auto axxz_0 = current_data[138];
      const auto axyz_0 = current_data[139];
      const auto ayyz_0 = current_data[140];
      const auto axzz_0 = current_data[145];
      const auto ayzz_0 = current_data[146];
      const auto azzz_0 = current_data[151];
      const auto axxxx_0 = current_data[187];
      const auto axxxy_0 = current_data[188];
      const auto axxyy_0 = current_data[189];
      const auto axyyy_0 = current_data[190];
      const auto ayyyy_0 = current_data[191];
      const auto axxxz_0 = current_data[196];
      const auto axxyz_0 = current_data[197];
      const auto axyyz_0 = current_data[198];
      const auto ayyyz_0 = current_data[199];
      const auto axxzz_0 = current_data[204];
      const auto axyzz_0 = current_data[205];
      const auto ayyzz_0 = current_data[206];
      const auto axzzz_0 = current_data[211];
      const auto ayzzz_0 = current_data[212];
      const auto azzzz_0 = current_data[217];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[225] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[226] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[227] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[228] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[229] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[230] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[231] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[232] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[233] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[234] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[235] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[236] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[237] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[238] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[239] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyyzz
      const auto a0_0 = current_data[16];
      const auto ax_0 = current_data[46];
      const auto ay_0 = current_data[47];
      const auto az_0 = current_data[52];
      const auto axx_0 = current_data[84];
      const auto axy_0 = current_data[85];
      const auto ayy_0 = current_data[86];
      const auto axz_0 = current_data[91];
      const auto ayz_0 = current_data[92];
      const auto azz_0 = current_data[97];
      const auto axxx_0 = current_data[131];
      const auto axxy_0 = current_data[132];
      const auto axyy_0 = current_data[133];
      const auto ayyy_0 = current_data[134];
      const auto axxz_0 = current_data[139];
      const auto axyz_0 = current_data[140];
      const auto ayyz_0 = current_data[141];
      const auto axzz_0 = current_data[146];
      const auto ayzz_0 = current_data[147];
      const auto azzz_0 = current_data[152];
      const auto axxxx_0 = current_data[188];
      const auto axxxy_0 = current_data[189];
      const auto axxyy_0 = current_data[190];
      const auto axyyy_0 = current_data[191];
      const auto ayyyy_0 = current_data[192];
      const auto axxxz_0 = current_data[197];
      const auto axxyz_0 = current_data[198];
      const auto axyyz_0 = current_data[199];
      const auto ayyyz_0 = current_data[200];
      const auto axxzz_0 = current_data[205];
      const auto axyzz_0 = current_data[206];
      const auto ayyzz_0 = current_data[207];
      const auto axzzz_0 = current_data[212];
      const auto ayzzz_0 = current_data[213];
      const auto azzzz_0 = current_data[218];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[240] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[241] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[242] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[243] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[244] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[245] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[246] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[247] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[248] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[249] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[250] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[251] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[252] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[253] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[254] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyyzz
      const auto a0_0 = current_data[17];
      const auto ax_0 = current_data[47];
      const auto ay_0 = current_data[48];
      const auto az_0 = current_data[53];
      const auto axx_0 = current_data[85];
      const auto axy_0 = current_data[86];
      const auto ayy_0 = current_data[87];
      const auto axz_0 = current_data[92];
      const auto ayz_0 = current_data[93];
      const auto azz_0 = current_data[98];
      const auto axxx_0 = current_data[132];
      const auto axxy_0 = current_data[133];
      const auto axyy_0 = current_data[134];
      const auto ayyy_0 = current_data[135];
      const auto axxz_0 = current_data[140];
      const auto axyz_0 = current_data[141];
      const auto ayyz_0 = current_data[142];
      const auto axzz_0 = current_data[147];
      const auto ayzz_0 = current_data[148];
      const auto azzz_0 = current_data[153];
      const auto axxxx_0 = current_data[189];
      const auto axxxy_0 = current_data[190];
      const auto axxyy_0 = current_data[191];
      const auto axyyy_0 = current_data[192];
      const auto ayyyy_0 = current_data[193];
      const auto axxxz_0 = current_data[198];
      const auto axxyz_0 = current_data[199];
      const auto axyyz_0 = current_data[200];
      const auto ayyyz_0 = current_data[201];
      const auto axxzz_0 = current_data[206];
      const auto axyzz_0 = current_data[207];
      const auto ayyzz_0 = current_data[208];
      const auto axzzz_0 = current_data[213];
      const auto ayzzz_0 = current_data[214];
      const auto azzzz_0 = current_data[219];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[255] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[256] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[257] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[258] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[259] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[260] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[261] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[262] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[263] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[264] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[265] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[266] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[267] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[268] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[269] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxxzzz
      const auto a0_0 = current_data[18];
      const auto ax_0 = current_data[49];
      const auto ay_0 = current_data[50];
      const auto az_0 = current_data[54];
      const auto axx_0 = current_data[88];
      const auto axy_0 = current_data[89];
      const auto ayy_0 = current_data[90];
      const auto axz_0 = current_data[94];
      const auto ayz_0 = current_data[95];
      const auto azz_0 = current_data[99];
      const auto axxx_0 = current_data[136];
      const auto axxy_0 = current_data[137];
      const auto axyy_0 = current_data[138];
      const auto ayyy_0 = current_data[139];
      const auto axxz_0 = current_data[143];
      const auto axyz_0 = current_data[144];
      const auto ayyz_0 = current_data[145];
      const auto axzz_0 = current_data[149];
      const auto ayzz_0 = current_data[150];
      const auto azzz_0 = current_data[154];
      const auto axxxx_0 = current_data[194];
      const auto axxxy_0 = current_data[195];
      const auto axxyy_0 = current_data[196];
      const auto axyyy_0 = current_data[197];
      const auto ayyyy_0 = current_data[198];
      const auto axxxz_0 = current_data[202];
      const auto axxyz_0 = current_data[203];
      const auto axyyz_0 = current_data[204];
      const auto ayyyz_0 = current_data[205];
      const auto axxzz_0 = current_data[209];
      const auto axyzz_0 = current_data[210];
      const auto ayyzz_0 = current_data[211];
      const auto axzzz_0 = current_data[215];
      const auto ayzzz_0 = current_data[216];
      const auto azzzz_0 = current_data[220];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[270] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[271] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[272] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[273] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[274] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[275] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[276] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[277] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[278] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[279] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[280] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[281] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[282] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[283] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[284] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxyzzz
      const auto a0_0 = current_data[19];
      const auto ax_0 = current_data[50];
      const auto ay_0 = current_data[51];
      const auto az_0 = current_data[55];
      const auto axx_0 = current_data[89];
      const auto axy_0 = current_data[90];
      const auto ayy_0 = current_data[91];
      const auto axz_0 = current_data[95];
      const auto ayz_0 = current_data[96];
      const auto azz_0 = current_data[100];
      const auto axxx_0 = current_data[137];
      const auto axxy_0 = current_data[138];
      const auto axyy_0 = current_data[139];
      const auto ayyy_0 = current_data[140];
      const auto axxz_0 = current_data[144];
      const auto axyz_0 = current_data[145];
      const auto ayyz_0 = current_data[146];
      const auto axzz_0 = current_data[150];
      const auto ayzz_0 = current_data[151];
      const auto azzz_0 = current_data[155];
      const auto axxxx_0 = current_data[195];
      const auto axxxy_0 = current_data[196];
      const auto axxyy_0 = current_data[197];
      const auto axyyy_0 = current_data[198];
      const auto ayyyy_0 = current_data[199];
      const auto axxxz_0 = current_data[203];
      const auto axxyz_0 = current_data[204];
      const auto axyyz_0 = current_data[205];
      const auto ayyyz_0 = current_data[206];
      const auto axxzz_0 = current_data[210];
      const auto axyzz_0 = current_data[211];
      const auto ayyzz_0 = current_data[212];
      const auto axzzz_0 = current_data[216];
      const auto ayzzz_0 = current_data[217];
      const auto azzzz_0 = current_data[221];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[285] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[286] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[287] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[288] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[289] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[290] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[291] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[292] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[293] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[294] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[295] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[296] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[297] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[298] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[299] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyyzzz
      const auto a0_0 = current_data[20];
      const auto ax_0 = current_data[51];
      const auto ay_0 = current_data[52];
      const auto az_0 = current_data[56];
      const auto axx_0 = current_data[90];
      const auto axy_0 = current_data[91];
      const auto ayy_0 = current_data[92];
      const auto axz_0 = current_data[96];
      const auto ayz_0 = current_data[97];
      const auto azz_0 = current_data[101];
      const auto axxx_0 = current_data[138];
      const auto axxy_0 = current_data[139];
      const auto axyy_0 = current_data[140];
      const auto ayyy_0 = current_data[141];
      const auto axxz_0 = current_data[145];
      const auto axyz_0 = current_data[146];
      const auto ayyz_0 = current_data[147];
      const auto axzz_0 = current_data[151];
      const auto ayzz_0 = current_data[152];
      const auto azzz_0 = current_data[156];
      const auto axxxx_0 = current_data[196];
      const auto axxxy_0 = current_data[197];
      const auto axxyy_0 = current_data[198];
      const auto axyyy_0 = current_data[199];
      const auto ayyyy_0 = current_data[200];
      const auto axxxz_0 = current_data[204];
      const auto axxyz_0 = current_data[205];
      const auto axyyz_0 = current_data[206];
      const auto ayyyz_0 = current_data[207];
      const auto axxzz_0 = current_data[211];
      const auto axyzz_0 = current_data[212];
      const auto ayyzz_0 = current_data[213];
      const auto axzzz_0 = current_data[217];
      const auto ayzzz_0 = current_data[218];
      const auto azzzz_0 = current_data[222];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[300] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[301] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[302] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[303] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[304] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[305] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[306] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[307] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[308] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[309] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[310] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[311] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[312] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[313] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[314] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyyzzz
      const auto a0_0 = current_data[21];
      const auto ax_0 = current_data[52];
      const auto ay_0 = current_data[53];
      const auto az_0 = current_data[57];
      const auto axx_0 = current_data[91];
      const auto axy_0 = current_data[92];
      const auto ayy_0 = current_data[93];
      const auto axz_0 = current_data[97];
      const auto ayz_0 = current_data[98];
      const auto azz_0 = current_data[102];
      const auto axxx_0 = current_data[139];
      const auto axxy_0 = current_data[140];
      const auto axyy_0 = current_data[141];
      const auto ayyy_0 = current_data[142];
      const auto axxz_0 = current_data[146];
      const auto axyz_0 = current_data[147];
      const auto ayyz_0 = current_data[148];
      const auto axzz_0 = current_data[152];
      const auto ayzz_0 = current_data[153];
      const auto azzz_0 = current_data[157];
      const auto axxxx_0 = current_data[197];
      const auto axxxy_0 = current_data[198];
      const auto axxyy_0 = current_data[199];
      const auto axyyy_0 = current_data[200];
      const auto ayyyy_0 = current_data[201];
      const auto axxxz_0 = current_data[205];
      const auto axxyz_0 = current_data[206];
      const auto axyyz_0 = current_data[207];
      const auto ayyyz_0 = current_data[208];
      const auto axxzz_0 = current_data[212];
      const auto axyzz_0 = current_data[213];
      const auto ayyzz_0 = current_data[214];
      const auto axzzz_0 = current_data[218];
      const auto ayzzz_0 = current_data[219];
      const auto azzzz_0 = current_data[223];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[315] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[316] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[317] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[318] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[319] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[320] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[321] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[322] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[323] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[324] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[325] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[326] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[327] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[328] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[329] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xxzzzz
      const auto a0_0 = current_data[22];
      const auto ax_0 = current_data[54];
      const auto ay_0 = current_data[55];
      const auto az_0 = current_data[58];
      const auto axx_0 = current_data[94];
      const auto axy_0 = current_data[95];
      const auto ayy_0 = current_data[96];
      const auto axz_0 = current_data[99];
      const auto ayz_0 = current_data[100];
      const auto azz_0 = current_data[103];
      const auto axxx_0 = current_data[143];
      const auto axxy_0 = current_data[144];
      const auto axyy_0 = current_data[145];
      const auto ayyy_0 = current_data[146];
      const auto axxz_0 = current_data[149];
      const auto axyz_0 = current_data[150];
      const auto ayyz_0 = current_data[151];
      const auto axzz_0 = current_data[154];
      const auto ayzz_0 = current_data[155];
      const auto azzz_0 = current_data[158];
      const auto axxxx_0 = current_data[202];
      const auto axxxy_0 = current_data[203];
      const auto axxyy_0 = current_data[204];
      const auto axyyy_0 = current_data[205];
      const auto ayyyy_0 = current_data[206];
      const auto axxxz_0 = current_data[209];
      const auto axxyz_0 = current_data[210];
      const auto axyyz_0 = current_data[211];
      const auto ayyyz_0 = current_data[212];
      const auto axxzz_0 = current_data[215];
      const auto axyzz_0 = current_data[216];
      const auto ayyzz_0 = current_data[217];
      const auto axzzz_0 = current_data[220];
      const auto ayzzz_0 = current_data[221];
      const auto azzzz_0 = current_data[224];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[330] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[331] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[332] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[333] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[334] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[335] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[336] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[337] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[338] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[339] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[340] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[341] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[342] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[343] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[344] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xyzzzz
      const auto a0_0 = current_data[23];
      const auto ax_0 = current_data[55];
      const auto ay_0 = current_data[56];
      const auto az_0 = current_data[59];
      const auto axx_0 = current_data[95];
      const auto axy_0 = current_data[96];
      const auto ayy_0 = current_data[97];
      const auto axz_0 = current_data[100];
      const auto ayz_0 = current_data[101];
      const auto azz_0 = current_data[104];
      const auto axxx_0 = current_data[144];
      const auto axxy_0 = current_data[145];
      const auto axyy_0 = current_data[146];
      const auto ayyy_0 = current_data[147];
      const auto axxz_0 = current_data[150];
      const auto axyz_0 = current_data[151];
      const auto ayyz_0 = current_data[152];
      const auto axzz_0 = current_data[155];
      const auto ayzz_0 = current_data[156];
      const auto azzz_0 = current_data[159];
      const auto axxxx_0 = current_data[203];
      const auto axxxy_0 = current_data[204];
      const auto axxyy_0 = current_data[205];
      const auto axyyy_0 = current_data[206];
      const auto ayyyy_0 = current_data[207];
      const auto axxxz_0 = current_data[210];
      const auto axxyz_0 = current_data[211];
      const auto axyyz_0 = current_data[212];
      const auto ayyyz_0 = current_data[213];
      const auto axxzz_0 = current_data[216];
      const auto axyzz_0 = current_data[217];
      const auto ayyzz_0 = current_data[218];
      const auto axzzz_0 = current_data[221];
      const auto ayzzz_0 = current_data[222];
      const auto azzzz_0 = current_data[225];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[345] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[346] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[347] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[348] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[349] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[350] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[351] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[352] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[353] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[354] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[355] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[356] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[357] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[358] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[359] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yyzzzz
      const auto a0_0 = current_data[24];
      const auto ax_0 = current_data[56];
      const auto ay_0 = current_data[57];
      const auto az_0 = current_data[60];
      const auto axx_0 = current_data[96];
      const auto axy_0 = current_data[97];
      const auto ayy_0 = current_data[98];
      const auto axz_0 = current_data[101];
      const auto ayz_0 = current_data[102];
      const auto azz_0 = current_data[105];
      const auto axxx_0 = current_data[145];
      const auto axxy_0 = current_data[146];
      const auto axyy_0 = current_data[147];
      const auto ayyy_0 = current_data[148];
      const auto axxz_0 = current_data[151];
      const auto axyz_0 = current_data[152];
      const auto ayyz_0 = current_data[153];
      const auto axzz_0 = current_data[156];
      const auto ayzz_0 = current_data[157];
      const auto azzz_0 = current_data[160];
      const auto axxxx_0 = current_data[204];
      const auto axxxy_0 = current_data[205];
      const auto axxyy_0 = current_data[206];
      const auto axyyy_0 = current_data[207];
      const auto ayyyy_0 = current_data[208];
      const auto axxxz_0 = current_data[211];
      const auto axxyz_0 = current_data[212];
      const auto axyyz_0 = current_data[213];
      const auto ayyyz_0 = current_data[214];
      const auto axxzz_0 = current_data[217];
      const auto axyzz_0 = current_data[218];
      const auto ayyzz_0 = current_data[219];
      const auto axzzz_0 = current_data[222];
      const auto ayzzz_0 = current_data[223];
      const auto azzzz_0 = current_data[226];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[360] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[361] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[362] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[363] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[364] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[365] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[366] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[367] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[368] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[369] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[370] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[371] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[372] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[373] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[374] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: xzzzzz
      const auto a0_0 = current_data[25];
      const auto ax_0 = current_data[58];
      const auto ay_0 = current_data[59];
      const auto az_0 = current_data[61];
      const auto axx_0 = current_data[99];
      const auto axy_0 = current_data[100];
      const auto ayy_0 = current_data[101];
      const auto axz_0 = current_data[103];
      const auto ayz_0 = current_data[104];
      const auto azz_0 = current_data[106];
      const auto axxx_0 = current_data[149];
      const auto axxy_0 = current_data[150];
      const auto axyy_0 = current_data[151];
      const auto ayyy_0 = current_data[152];
      const auto axxz_0 = current_data[154];
      const auto axyz_0 = current_data[155];
      const auto ayyz_0 = current_data[156];
      const auto axzz_0 = current_data[158];
      const auto ayzz_0 = current_data[159];
      const auto azzz_0 = current_data[161];
      const auto axxxx_0 = current_data[209];
      const auto axxxy_0 = current_data[210];
      const auto axxyy_0 = current_data[211];
      const auto axyyy_0 = current_data[212];
      const auto ayyyy_0 = current_data[213];
      const auto axxxz_0 = current_data[215];
      const auto axxyz_0 = current_data[216];
      const auto axyyz_0 = current_data[217];
      const auto ayyyz_0 = current_data[218];
      const auto axxzz_0 = current_data[220];
      const auto axyzz_0 = current_data[221];
      const auto ayyzz_0 = current_data[222];
      const auto axzzz_0 = current_data[224];
      const auto ayzzz_0 = current_data[225];
      const auto azzzz_0 = current_data[227];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[375] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[376] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[377] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[378] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[379] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[380] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[381] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[382] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[383] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[384] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[385] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[386] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[387] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[388] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[389] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: yzzzzz
      const auto a0_0 = current_data[26];
      const auto ax_0 = current_data[59];
      const auto ay_0 = current_data[60];
      const auto az_0 = current_data[62];
      const auto axx_0 = current_data[100];
      const auto axy_0 = current_data[101];
      const auto ayy_0 = current_data[102];
      const auto axz_0 = current_data[104];
      const auto ayz_0 = current_data[105];
      const auto azz_0 = current_data[107];
      const auto axxx_0 = current_data[150];
      const auto axxy_0 = current_data[151];
      const auto axyy_0 = current_data[152];
      const auto ayyy_0 = current_data[153];
      const auto axxz_0 = current_data[155];
      const auto axyz_0 = current_data[156];
      const auto ayyz_0 = current_data[157];
      const auto axzz_0 = current_data[159];
      const auto ayzz_0 = current_data[160];
      const auto azzz_0 = current_data[162];
      const auto axxxx_0 = current_data[210];
      const auto axxxy_0 = current_data[211];
      const auto axxyy_0 = current_data[212];
      const auto axyyy_0 = current_data[213];
      const auto ayyyy_0 = current_data[214];
      const auto axxxz_0 = current_data[216];
      const auto axxyz_0 = current_data[217];
      const auto axyyz_0 = current_data[218];
      const auto ayyyz_0 = current_data[219];
      const auto axxzz_0 = current_data[221];
      const auto axyzz_0 = current_data[222];
      const auto ayyzz_0 = current_data[223];
      const auto axzzz_0 = current_data[225];
      const auto ayzzz_0 = current_data[226];
      const auto azzzz_0 = current_data[228];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[390] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[391] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[392] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[393] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[394] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[395] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[396] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[397] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[398] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[399] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[400] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[401] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[402] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[403] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[404] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
   {
     //current index a: zzzzzz
      const auto a0_0 = current_data[27];
      const auto ax_0 = current_data[61];
      const auto ay_0 = current_data[62];
      const auto az_0 = current_data[63];
      const auto axx_0 = current_data[103];
      const auto axy_0 = current_data[104];
      const auto ayy_0 = current_data[105];
      const auto axz_0 = current_data[106];
      const auto ayz_0 = current_data[107];
      const auto azz_0 = current_data[108];
      const auto axxx_0 = current_data[154];
      const auto axxy_0 = current_data[155];
      const auto axyy_0 = current_data[156];
      const auto ayyy_0 = current_data[157];
      const auto axxz_0 = current_data[158];
      const auto axyz_0 = current_data[159];
      const auto ayyz_0 = current_data[160];
      const auto axzz_0 = current_data[161];
      const auto ayzz_0 = current_data[162];
      const auto azzz_0 = current_data[163];
      const auto axxxx_0 = current_data[215];
      const auto axxxy_0 = current_data[216];
      const auto axxyy_0 = current_data[217];
      const auto axyyy_0 = current_data[218];
      const auto ayyyy_0 = current_data[219];
      const auto axxxz_0 = current_data[220];
      const auto axxyz_0 = current_data[221];
      const auto axyyz_0 = current_data[222];
      const auto ayyyz_0 = current_data[223];
      const auto axxzz_0 = current_data[224];
      const auto axyzz_0 = current_data[225];
      const auto ayyzz_0 = current_data[226];
      const auto axzzz_0 = current_data[227];
      const auto ayzzz_0 = current_data[228];
      const auto azzzz_0 = current_data[229];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      current_out[405] = ax_xxx + AB[0] * a0_xxx; // a0_xxxx
      current_out[406] = ax_xxy + AB[0] * a0_xxy; // a0_xxxy
      current_out[407] = ax_xyy + AB[0] * a0_xyy; // a0_xxyy
      current_out[408] = ax_yyy + AB[0] * a0_yyy; // a0_xyyy
      current_out[409] = ay_yyy + AB[1] * a0_yyy; // a0_yyyy
      current_out[410] = ax_xxz + AB[0] * a0_xxz; // a0_xxxz
      current_out[411] = ax_xyz + AB[0] * a0_xyz; // a0_xxyz
      current_out[412] = ax_yyz + AB[0] * a0_yyz; // a0_xyyz
      current_out[413] = ay_yyz + AB[1] * a0_yyz; // a0_yyyz
      current_out[414] = ax_xzz + AB[0] * a0_xzz; // a0_xxzz
      current_out[415] = ax_yzz + AB[0] * a0_yzz; // a0_xyzz
      current_out[416] = ay_yzz + AB[1] * a0_yzz; // a0_yyzz
      current_out[417] = ax_zzz + AB[0] * a0_zzz; // a0_xzzz
      current_out[418] = ay_zzz + AB[1] * a0_zzz; // a0_yzzz
      current_out[419] = az_zzz + AB[2] * a0_zzz; // a0_zzzz

    }
  }
}

