subroutine celver(celz, typver, arret, iret)
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
! person_in_charge: jacques.pellet at edf.fr
    implicit none
#include "jeveux.h"
#include "asterc/iisnan.h"
#include "asterc/isnnem.h"
#include "asterfort/assert.h"
#include "asterfort/dismoi.h"
#include "asterfort/jedema.h"
#include "asterfort/jeexin.h"
#include "asterfort/jelira.h"
#include "asterfort/jemarq.h"
#include "asterfort/jeveuo.h"
#include "asterfort/u2mesk.h"
    character(len=*) :: celz, typver, arret
    integer :: iret
! ------------------------------------------------------------------
! BUT : VERIFIER QUE LE CHAM_ELEM  CEL  A UNE CERTAINE PROPRIETE
!       SINON ERREUR '<F>' (OU BIEN CODE_RETOUR:1)
! ------------------------------------------------------------------
!
! CELZ    IN/JXIN  K19 : SD CHAM_ELEM A VERIFIER
!
! TYPVER  IN       K*  : TYPE DE VERIFICATION A EFFECTUER
!     /'NBSPT_1'    : LES ELEMENTS DU CHAM_ELEM N'ONT QU'1 SOUS-POINT
!     /'NBVARI_CST' : POUR UN CHAM_ELEM(VARI_R), ON VERIFIE QUE
!                     TOUS LES ELEMENTS ONT LE MEME NOMBRE DE CMPS
!     /'PAS_NAN'    : IL N'Y A PAS DE VALEURS "NAN" DANS LE CHAMP
!                     (VOIR CESCEL.F POUR LA DEFINITION DE "NAN")
!
! ARRET   IN   K* :  /'STOP' : ON ARRET LE CODE EN ERREUR FATALE
!                    /'COOL' : ON LAISSE PASSER MAIS ON REND IRET=1
!
! IRET   OUT   I :  /  0 : LA CONDITION EST VERIFIEE
!                   /  1 : LA CONDITION N'EST PAS VERIFIEE
!-----------------------------------------------------------------------
!
!     ------------------------------------------------------------------
    character(len=8) :: kbid, tsca, nomgd
    character(len=3) :: knan
    character(len=19) :: cel
    integer :: jceld, kk, mxspt, igr, ngrel, nel, iel, iprem, ncdyn, ncdyn1
    integer :: imolo, inan, nb1, k, ibid, jcelv
    logical :: lnan
!
!     ------------------------------------------------------------------
    call jemarq()
    cel = celz
    iret = 0
!
    call jeexin(cel//'.CELD', kk)
    if (kk .eq. 0) call u2mesk('F', 'CALCULEL_47', 1, cel)
!
    call jeveuo(cel//'.CELD', 'L', jceld)
!
!
    if (typver .eq. 'NBVARI_CST') then
!     --------------------------------
        ngrel = zi(jceld-1+2)
        iprem = 0
        do 20,igr = 1,ngrel
        imolo = zi(jceld-1+zi(jceld-1+4+igr)+2)
        if (imolo .eq. 0) goto 20
        nel = zi(jceld-1+zi(jceld-1+4+igr)+1)
        do 10,iel = 1,nel
        ncdyn = zi(jceld-1+zi(jceld-1+4+igr)+4+4* (iel-1)+2)
        iprem = iprem + 1
        if (iprem .eq. 1) then
            ncdyn1 = ncdyn
        else
            if (ncdyn .ne. ncdyn1) then
                if (arret .ne. 'COOL') then
                    call u2mesk('F', 'CALCULEL_48', 1, cel)
                else
                    iret = 1
                endif
            endif
        endif
10      continue
20      continue
!
!
    else if (typver.eq.'NBSPT_1') then
!     --------------------------------
        mxspt = zi(jceld-1+3)
        if (mxspt .gt. 1) then
            if (arret .ne. 'COOL') then
                call u2mesk('F', 'CALCULEL_49', 1, cel)
            else
                iret = 1
            endif
        endif
!
!
    else if (typver.eq.'PAS_NAN') then
!     --------------------------------
        call dismoi('F', 'NOM_GD', cel, 'CHAMP', ibid,&
                    nomgd, ibid)
        call dismoi('F', 'TYPE_SCA', nomgd, 'GRANDEUR', ibid,&
                    tsca, ibid)
        call jeveuo(cel//'.CELV', 'L', jcelv)
        call jelira(cel//'.CELV', 'LONMAX', nb1, kbid)
        lnan=.false.
        inan = isnnem()
        knan = '???'
!
        if (tsca .eq. 'R') then
            do 80,k = 1,nb1
            if (iisnan(zr(jcelv-1+k)) .eq. 1) lnan=.true.
80          continue
        else if (tsca.eq.'C') then
            do 81,k = 1,nb1
            if (iisnan(dble(zc(jcelv-1+k))) .eq. 1) lnan=.true.
81          continue
        else if (tsca.eq.'I') then
            do 82,k = 1,nb1
            if (zi(jcelv-1+k) .eq. inan) lnan=.true.
82          continue
        else if (tsca.eq.'K8') then
            do 83,k = 1,nb1
            if (zk8(jcelv-1+k) .eq. knan) lnan=.true.
83          continue
        else if (tsca.eq.'K24') then
            do 84,k = 1,nb1
            if (zk24(jcelv-1+k) .eq. knan) lnan=.true.
84          continue
        else
            call assert(.false.)
        endif
!
        if (lnan) then
            if (arret .ne. 'COOL') then
                call u2mesk('F', 'CALCULEL4_1', 1, cel)
            else
                iret = 1
            endif
        endif
!
!
    else
        call assert(.false.)
    endif
!
    call jedema()
end subroutine
