function PlayerManager() {}

PlayerManager.prototype.Schema =
	"<a:component type='system'/><empty/>";

PlayerManager.prototype.Init = function()
{
	this.playerEntities = []; // list of player entity IDs
};

PlayerManager.prototype.AddPlayer = function(ent)
{
	var id = this.playerEntities.length;
	Engine.QueryInterface(ent, IID_Player).SetPlayerID(id);
	this.playerEntities.push(ent);
	return id;
};

/**
 * Returns the player entity ID for the given player ID.
 * The player ID must be valid (else there will be an error message).
 */
PlayerManager.prototype.GetPlayerByID = function(id)
{
	if (id in this.playerEntities)
		return this.playerEntities[id];

	var stack = new Error().stack.trimRight().replace(/^/mg, '  '); // indent each line
	warn("GetPlayerByID: no player defined for id '"+id+"'\n"+stack);

	return INVALID_ENTITY;
};

PlayerManager.prototype.GetNumPlayers = function()
{
	return this.playerEntities.length;
};

PlayerManager.prototype.RemoveAllPlayers = function()
{
	// Destroy existing player entities
	for each (var id in this.playerEntities)
	{
		Engine.DestroyEntity(id);
	}
	this.playerEntities = [];
};

PlayerManager.prototype.GetAllPlayerEntities = function()
{
	return this.playerEntities;
};
Engine.RegisterComponentType(IID_PlayerManager, "PlayerManager", PlayerManager);
