#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_Rack.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_Rack provider module";
Name = "PhysicalAsset_OpenDRIM_RackModule";
Location = "cmpiPhysicalAsset_OpenDRIM_RackProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_Rack provider";
Name = "PhysicalAsset_OpenDRIM_RackProvider";
ProviderModuleName = "PhysicalAsset_OpenDRIM_RackModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_Rack provider capabilities";
ProviderModuleName = "PhysicalAsset_OpenDRIM_RackModule";
ProviderName = "PhysicalAsset_OpenDRIM_RackProvider";
ClassName = "OpenDRIM_Rack";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "InstallDate", "Name", "OperationalStatus", "StatusDescriptions", "Status", "HealthState", "PrimaryStatus", "DetailedStatus", "OperatingStatus", "CommunicationStatus", "Tag", "Description", "CreationClassName", "ElementName", "Manufacturer", "Model", "SKU", "SerialNumber", "Version", "PartNumber", "OtherIdentifyingInfo", "PoweredOn", "ManufactureDate", "VendorEquipmentType", "UserTracking", "CanBeFRUed", "RemovalConditions", "Removable", "Replaceable", "HotSwappable", "Depth", "Width", "Weight", "PackageType", "OtherPackageType", "VendorCompatibilityStrings", "CableManagementStrategy", "ServicePhilosophy", "ServiceDescriptions", "LockPresent", "AudibleAlarm", "VisibleAlarm", "SecurityBreach", "BreachDescription", "IsLocked", "Height", "TypeOfRack", "CountryDesignation"};
SupportedMethods = {"IsCompatible"};
CapabilityID = "PhysicalAsset_OpenDRIM_Rack";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_Rack.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_Rack]   
   provider: PhysicalAsset_OpenDRIM_RackProvider
   location: cmpiPhysicalAsset_OpenDRIM_RackProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_Rack.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_Rack-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_Rack.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
