/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_DNSServerAccess.h"

string systemName;
const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_DNSServer";

int DNS_OpenDRIM_DNSServer_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSServer_unload(string& errorMessage) {
	_E_;
	// Nothing
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSServer_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DNSServer>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_DNSServer instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setSystemName(systemName);
	instance.setCreationClassName(creationClassName);
	
	const string filepath("/etc/resolv.conf");
	ifstream ifs(filepath.c_str(), ifstream::in);
	
	if (!ifs.is_open())
	{
		errorMessage = "Failed to open /etc/resolv.conf";
		return FAILED;
	}
	
	string line;
	while (getline(ifs, line))
	{
		if (CF_startsWith(line, "nameserver"))
		{
			string addr = line.substr(line.find_first_of(" ")+1);
			instance.setName(addr);
			
			if (discriminant == "ei")
				CF_assert(DNS_OpenDRIM_DNSServer_populate(instance, errorMessage));
			
			result.push_back(instance);
		}
	}
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSServer_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DNSServer& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.SystemCreationClassName == systemCreationClassName &&
			instance.SystemName == systemName &&
			instance.CreationClassName == creationClassName)
	{
		const string filepath("/etc/resolv.conf");
		ifstream ifs(filepath.c_str(), ifstream::in);
		if (!ifs.is_open())
		{
			errorMessage = "Failed to open /etc/resolv.conf";
			return FAILED;
		}
		
		string line;
		while (getline(ifs, line))
		{
			if (CF_startsWith(line, "nameserver"))
			{
				string addr = line.substr(line.find_first_of(" ")+1);
				
				if (addr == instance.Name)
				{
					CF_assert(DNS_OpenDRIM_DNSServer_populate(instance, errorMessage));
					return OK;
				}
			}
		}
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	else
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSServer_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSServer& newInstance, const OpenDRIM_DNSServer& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSServer_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSServer& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSServer_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSServer& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSServer_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSServer& instance, unsigned int& returnValue, const OpenDRIM_DNSServer_RequestStateChange_In& in, OpenDRIM_DNSServer_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSServer_populate(OpenDRIM_DNSServer& instance, string& errorMessage) {
	_E_;
	instance.setAccessInfo(instance.Name);
	instance.setInfoFormat(3);
	instance.setElementName(instance.Name+" DNS server");
	instance.setAccessContext(3);
	_L_;
	return OK;
}

