/*
 * Copyright (C) 2013, 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

WI.StorageTreeElement = class StorageTreeElement extends WI.GeneralTreeElement
{
    constructor(classNames, title, representedObject)
    {
        const subtitle = null;
        super(classNames, title, subtitle, representedObject);

        this.flattened = false;
    }

    // Public

    get flattened()
    {
        return this._flattened;
    }

    set flattened(flattened)
    {
        if (this._flattened === flattened)
            return;

        this._flattened = flattened;
        if (!this._flattened) {
            this.mainTitle = this.name;
            this.subtitle = this.secondaryName;
            this._updateChildrenTitles();
            return;
        }

        this.mainTitle = this.categoryName;
        this.subtitle = this.name;
        this._updateChildrenTitles();
    }

    // Private

    _updateChildrenTitles()
    {
        for (var i = 0; i < this.children.length; ++i) {
            if (typeof this.children[i].updateTitles === "function")
                this.children[i].updateTitles();
        }
    }
};
