/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.Hashtable;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class SendToBackCommand
extends AbstractCommand {
    public SendToBackCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selectionZOrdered());
        FigureEnumeration figureEnumeration = this.getUndoActivity().getAffectedFigures();
        while (figureEnumeration.hasNextFigure()) {
            this.view().drawing().sendToBack(figureEnumeration.nextFigure());
        }
        this.view().checkDamage();
    }

    protected boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Hashtable myOriginalLayers = new Hashtable();

        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                int n = this.getOriginalLayer(figure);
                this.getDrawingView().drawing().sendToLayer(figure, n);
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                this.sendToCommand(figureEnumeration.nextFigure());
            }
            return true;
        }

        protected void sendToCommand(Figure figure) {
            this.getDrawingView().drawing().sendToBack(figure);
        }

        protected void addOriginalLayer(Figure figure, int n) {
            this.myOriginalLayers.put(figure, new Integer(n));
        }

        protected int getOriginalLayer(Figure figure) {
            return (Integer)this.myOriginalLayers.get(figure);
        }

        public void setAffectedFigures(FigureEnumeration figureEnumeration) {
            super.setAffectedFigures(figureEnumeration);
            FigureEnumeration figureEnumeration2 = this.getAffectedFigures();
            while (figureEnumeration2.hasNextFigure()) {
                Figure figure = figureEnumeration2.nextFigure();
                int n = this.getDrawingView().drawing().getLayer(figure);
                this.addOriginalLayer(figure, n);
            }
        }
    }
}

