/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#pragma once

#include <memory>
#include <svl/undo.hxx>

class ScDocShell;

class ScUndoDraw: public SfxUndoAction
{
    std::unique_ptr<SfxUndoAction>  pDrawUndo;
    ScDocShell*     pDocShell;
    ViewShellId     mnViewShellId;

    void            UpdateSubShell();

public:
                            ScUndoDraw( std::unique_ptr<SfxUndoAction> pUndo, ScDocShell* pDocSh );
    virtual                 ~ScUndoDraw() override;

    std::unique_ptr<SfxUndoAction> ReleaseDrawUndo()   { return std::move(pDrawUndo); }

    virtual void            Undo() override;
    virtual void            Redo() override;
    virtual void            Repeat(SfxRepeatTarget& rTarget) override;
    virtual bool            CanRepeat(SfxRepeatTarget& rTarget) const override;
    virtual bool            Merge( SfxUndoAction *pNextAction ) override;
    virtual OUString        GetComment() const override;
    virtual OUString        GetRepeatComment(SfxRepeatTarget&) const override;
    /// See SfxUndoAction::GetViewShellId().
    ViewShellId GetViewShellId() const override;
};

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
