/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright 2020 HabanaLabs, Ltd.
 * All Rights Reserved.
 *
 */
#ifndef GAUDI2_CORESIGHT_REGS_DRV_H_
#define GAUDI2_CORESIGHT_REGS_DRV_H_

#include "gaudi2_masks.h"
#include "../include/gaudi2/gaudi2_coresight.h"
#include "gaudi2P.h"

/* FUNNEL Offsets - same offsets for all funnels*/
#define mmFUNNEL_CTRL_REG_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_CTRL_REG -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PRIORITY_CTRL_REG_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PRIORITY_CTRL_REG -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_ITATBDATA0_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_ITATBDATA0 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_ITATBCTR2_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_ITATBCTR2 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_ITATBCTR1_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_ITATBCTR1 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_ITATBCTR0_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_ITATBCTR0 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_ITCTRL_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_ITCTRL -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_CLAIMSET_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_CLAIMSET -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_CLAIMCLR_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_CLAIMCLR -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_LOCKACCESS_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_LOCKACCESS -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_LOCKSTATUS_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_LOCKSTATUS -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_AUTHSTATUS_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_AUTHSTATUS -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_DEVID_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_DEVID -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_DEVTYPE_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_DEVTYPE -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PIDR4_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PIDR4 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PERIPHID5_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PERIPHID5 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PERIPHID6_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PERIPHID6 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PERIPHID7_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PERIPHID7 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PIDR0_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PIDR0 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PIDR1_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PIDR1 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PIDR2_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PIDR2 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_PIDR3_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_PIDR3 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_CID0_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_CID0 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_CID1_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_CID1 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_CID2_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_CID2 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

#define mmFUNNEL_CID3_OFFSET	\
			(mmDCORE0_TPC0_EML_FUNNEL_CID3 -	\
				mmDCORE0_TPC0_EML_FUNNEL_BASE)

/* ETF Offsets - same offsets for all etfs */
#define mmETF_RSZ_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_RSZ -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_STS_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_STS -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_RRD_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_RRD -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_RRP_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_RRP -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_RWP_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_RWP -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_TRG_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_TRG -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_CTL_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_CTL -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_RWD_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_RWD -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_MODE_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_MODE -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_LBUFLEVEL_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_LBUFLEVEL -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_CBUFLEVEL_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_CBUFLEVEL -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_BUFWM_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_BUFWM -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_FFSR_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_FFSR -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_FFCR_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_FFCR -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PSCR_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PSCR -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITATBMDATA0_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITATBMDATA0 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITATBMCTR2_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITATBMCTR2 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITATBMCTR1_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITATBMCTR1 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITATBMCTR0_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITATBMCTR0 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITMISCOP0_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITMISCOP0 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITTRFLIN_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITTRFLIN -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITATBDATA0_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITATBDATA0 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITATBCTR2_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITATBCTR2 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITATBCTR1_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITATBCTR1 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITATBCTR0_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITATBCTR0 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_ITCTRL_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_ITCTRL -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_CLAIMSET_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_CLAIMSET -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_CLAIMCLR_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_CLAIMCLR -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_LAR_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_LAR -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_LSR_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_LSR -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_AUTHSTATUS_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_AUTHSTATUS -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_DEVID_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_DEVID -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_DEVTYPE_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_DEVTYPE -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PERIPHID4_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PERIPHID4 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PERIPHID5_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PERIPHID5 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PERIPHID6_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PERIPHID6 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PERIPHID7_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PERIPHID7 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PERIPHID0_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PERIPHID0 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PERIPHID1_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PERIPHID1 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PERIPHID2_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PERIPHID2 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_PERIPHID3_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_PERIPHID3 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_COMPID0_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_COMPID0 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_COMPID1_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_COMPID1 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_COMPID2_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_COMPID2 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)

#define mmETF_COMPID3_OFFSET	\
			(mmDCORE0_TPC0_EML_ETF_COMPID3 -	\
				mmDCORE0_TPC0_EML_ETF_BASE)


/* STM OFFSETS - same offsets for all stms */
#define mmSTM_STMDMASTARTR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMDMASTARTR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMDMASTOPR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMDMASTOPR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMDMASTATR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMDMASTATR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMDMACTLR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMDMACTLR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMDMAIDR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMDMAIDR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMHEER_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMHEER -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMHETER_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMHETER -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMHEBSR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMHEBSR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMHEMCR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMHEMCR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMHEEXTMUXR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMHEEXTMUXR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMHEMASTR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMHEMASTR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMHEFEAT1R_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMHEFEAT1R -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMHEIDR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMHEIDR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMSPER_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMSPER -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMSPTER_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMSPTER -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMSPSCR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMSPSCR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMSPMSCR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMSPMSCR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMSPOVERRIDER_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMSPOVERRIDER -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMSPMOVERRIDER_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMSPMOVERRIDER -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMSPTRIGCSR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMSPTRIGCSR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMTCSR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMTCSR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMTSSTIMR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMTSSTIMR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMTSFREQR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMTSFREQR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMSYNCR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMSYNCR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMAUXCR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMAUXCR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMFEAT1R_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMFEAT1R -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMFEAT2R_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMFEAT2R -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMFEAT3R_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMFEAT3R -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMITTRIGGER_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMITTRIGGER -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMITATBDATA0_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMITATBDATA0 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMITATBCTR2_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMITATBCTR2 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMITATBID_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMITATBID -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMITATBCTR0_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMITATBCTR0 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMITCTRL_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMITCTRL -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMCLAIMSET_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMCLAIMSET -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMCLAIMCLR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMCLAIMCLR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMLAR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMLAR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMLSR_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMLSR -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMAUTHSTATUS_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMAUTHSTATUS -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMDEVARCH_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMDEVARCH -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMDEVID_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMDEVID -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMDEVTYPE_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMDEVTYPE -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMPIDR4_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMPIDR4 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMPIDR5_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMPIDR5 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMPIDR6_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMPIDR6 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMPIDR7_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMPIDR7 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMPIDR0_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMPIDR0 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMPIDR1_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMPIDR1 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMPIDR2_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMPIDR2 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMPIDR3_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMPIDR3 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMCIDR0_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMCIDR0 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMCIDR1_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMCIDR1 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMCIDR2_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMCIDR2 -	\
				mmDCORE0_TPC0_EML_STM_BASE)

#define mmSTM_STMCIDR3_OFFSET	\
			(mmDCORE0_TPC0_EML_STM_STMCIDR3 -	\
				mmDCORE0_TPC0_EML_STM_BASE)


/* SPMU OFFSETS - same offsets for all SPMUs */
#define mmSPMU_PMEVCNTR0_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTR0_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTR1_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTR1_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTR2_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTR2_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTR3_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTR3_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTR4_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTR4_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTR5_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTR5_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCCNTR_L_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCCNTR_L_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCCNTR_H_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCCNTR_H_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMTRC_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMTRC -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_TRC_CTRL_HOST_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_TRC_CTRL_HOST -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_TRC_STAT_HOST_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_TRC_STAT_HOST -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_TRC_EN_HOST_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_TRC_EN_HOST -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVTYPER0_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVTYPER0_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVTYPER1_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVTYPER1_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVTYPER2_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVTYPER2_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVTYPER3_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVTYPER3_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVTYPER4_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVTYPER4_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVTYPER5_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVTYPER5_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMSSR_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMSSR -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMOVSSR_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMOVSSR -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCCNTSR_L_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCCNTSR_L -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCCNTSR_H_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCCNTSR_H -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTSR0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTSR0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTSR1_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTSR1 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTSR2_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTSR2 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTSR3_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTSR3 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTSR4_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTSR4 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMEVCNTSR5_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMEVCNTSR5 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMSCR_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMSCR -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMSRR_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMSRR -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCNTENSET_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCNTENSET_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCNTENCLR_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCNTENCLR_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMINTENSET_EL1_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMINTENSET_EL1 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMINTENCLR_EL1_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMINTENCLR_EL1 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMOVSCLR_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMOVSCLR_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMSWINC_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMSWINC_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMOVSSET_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMOVSSET_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCFGR_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCFGR -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCR_EL0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCR_EL0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMITCTRL_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMITCTRL -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCLAIMSET_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCLAIMSET -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCLAIMCLR_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCLAIMCLR -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMDEVAFF0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMDEVAFF0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMDEVAFF1_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMDEVAFF1 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMLAR_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMLAR -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMLSR_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMLSR -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMAUTHSTATUS_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMAUTHSTATUS -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMDEVARCH_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMDEVARCH -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMDEVID2_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMDEVID2 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMDEVID1_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMDEVID1 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMDEVID_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMDEVID -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMDEVTYPE_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMDEVTYPE -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMPIDR4_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMPIDR4 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMPIDR5_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMPIDR5 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMPIDR6_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMPIDR6 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMPIDR7_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMPIDR7 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMPIDR0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMPIDR0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMPIDR1_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMPIDR1 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMPIDR2_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMPIDR2 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMPIDR3_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMPIDR3 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCIDR0_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCIDR0 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCIDR1_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCIDR1 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCIDR2_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCIDR2 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)

#define mmSPMU_PMCIDR3_OFFSET	\
			(mmDCORE0_TPC0_EML_SPMU_PMCIDR3 -	\
				mmDCORE0_TPC0_EML_SPMU_BASE)


/* BMON OFFSETS - same offsets for all BMONs*/
#define mmBMON_CR_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_CR -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_RESET_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_REG_RESET -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_INT_CLR_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_INT_CLR -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_TRIG_TH_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_TRIG_TH -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_S0_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_S0 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_S0_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_S0 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_E0_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_E0 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_E0_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_E0 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_S1_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_S1 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_S1_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_S1 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_E1_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_E1 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_E1_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_E1 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_S2_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_S2 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_S2_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_S2 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_E2_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_E2 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_E2_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_E2 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_S3_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_S3 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_S3_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_S3 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_E3_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_E3 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_E3_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_E3 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_REDUCTION_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_REDUCTION -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_IDL_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_IDL -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_IDH_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_IDH -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_IDENL_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_IDENL -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_IDENH_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_IDENH -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_LATENCY_SMP_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_LATENCY_SMP -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ATTR_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ATTR -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ATTREN_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ATTREN -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_USRENL_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_USRENL -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_USRL_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_USRL -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_USRENH_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_USRENH -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_USRH_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_USRH -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_CAPTURE_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_CAPTURE -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_RELEASE_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_RELEASE -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_WIN_CAPTURE_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_WIN_CAPTURE -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_BW_WIN_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_BW_WIN -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_MATCH_CNT_SOD_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_MATCH_CNT_SOD -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_MATCH_CNT_WIN_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_MATCH_CNT_WIN -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_CYCCNT_L_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_CYCCNT_L -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_CYCCNT_H_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_CYCCNT_H -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_MAXLAT_SOD_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_MAXLAT_SOD -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_MINLAT_SOD_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_MINLAT_SOD -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_MAXBW_SOD_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_MAXBW_SOD -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_MINBW_SOD_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_MINBW_SOD -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_MAXOS_SOD_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_MAXOS_SOD -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_MINOS_SOD_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_MINOS_SOD -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRL_SNAPSHOT_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRL_SNAPSHOT -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ADDRH_SNAPSHOT_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ADDRH_SNAPSHOT -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_IDL_SNAPSHOT_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_IDL_SNAPSHOT -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_IDH_SNAPSHOT_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_IDH_SNAPSHOT -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_ATTR_SNAPSHOT_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_ATTR_SNAPSHOT -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_STM_TRC_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_STM_TRC -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_STM_TRC_DROP_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_STM_TRC_DROP -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_DEVARCH_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_DEVARCH -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PMDEVID2_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PMDEVID2 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PMDEVID1_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PMDEVID1 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PMDEVID_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PMDEVID -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_DEVTYPE_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_DEVTYPE -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PIDR4_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PIDR4 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PIDR5_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PIDR5 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PIDR6_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PIDR6 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PIDR7_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PIDR7 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PIDR0_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PIDR0 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PIDR1_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PIDR1 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PIDR2_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PIDR2 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_PIDR3_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_PIDR3 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_CIDR0_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_CIDR0 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_CIDR1_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_CIDR1 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_CIDR2_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_CIDR2 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)

#define mmBMON_CIDR3_OFFSET	\
			(mmDCORE0_TPC0_EML_BUSMON_0_CIDR3 -	\
				mmDCORE0_TPC0_EML_BUSMON_0_BASE)


/* Coresight unlock offset */
#define  mmCORESIGHT_UNLOCK_REGISTER_OFFSET mmSTM_STMLAR_OFFSET
#define  mmCORESIGHT_UNLOCK_STATUS_REGISTER_OFFSET mmSTM_STMLSR_OFFSET

#endif /* GAUDI2_CORESIGHT_REGS_DRV_H_ */
