Title: Support and Bug Reports
SPDX-License-Identifier: LGPL-2.1-or-later
SPDX-FileCopyrightText: 2002 Matthias Clasen
SPDX-FileCopyrightText: 2018 Collabora, Ltd.
SPDX-FileCopyrightText: 2019 Emmanuele Bassi

# Support and Bug Reports

## Filing a Bug Report or Feature Request

If you encounter a bug, misfeature, or missing feature in GLib, please
file a bug report on the issue tracker at
[https://gitlab.gnome.org/GNOME/glib/issues/new](https://gitlab.gnome.org/GNOME/glib/issues/new).
We’d also appreciate reports of incomplete or misleading information in 
the GLib documentation; file those with the ‘Documentation’ label.

Don’t hesitate to file a bug report, even if you think we may know
about it already, or aren’t sure of the details. Just give us as much
information as you have, and if it’s already fixed or has already been
discussed, we’ll add a note to that effect in the report.

The issue tracker should definitely be used for feature requests, it’s
not only for bugs. We track all GLib development in GitLab, so it’s
the way to be sure the GLib developers won’t forget about an issue.

## Code Contributions

If you develop a bugfix or enhancement for GLib, please open a merge request
for that in GitLab as well. All branches must be offered under the terms of
the GNU LGPL license, so be sure you  are authorized to give us the branch
under those terms.

If you want to discuss your branch before or after developing it, open a
topic on [Discourse](https://discourse.gnome.org/tags/glib).
But be sure to create the GitLab merge request as well; if the branch is only
on the list and not in GitLab, it’s likely to slip through the cracks.

## Discussions and User Questions

The [GLib issue tracker](https://gitlab.gnome.org/GNOME/glib/issues)
is meant for discussions with actionable topics. If you want to ask a question
about using GLib, or discuss new features, you should use
[the `glib` tag on Discourse](https://discourse.gnome.org/tags/glib).
