dnl
dnl autoconf macros for GPH
dnl


dnl GPH_PROG_DB2ANY()
dnl Check whether we have the needed Docbook tools
dnl and issue a warning if this is not the case.
dnl
dnl This test defines these variables for substitution:
dnl    DB2ANY  - script used to render Docbook
dnl
dnl (wk 2000-05-16)
dnl
AC_DEFUN(GPH_PROG_DB2ANY,
  [  AC_REQUIRE([AC_CONFIG_AUX_DIR_DEFAULT])dnl
     working_db2any=no
     if $ac_aux_dir/db2any --systemcheck; then
	working_db2any=yes
	DB2ANY=`cd $ac_aux_dir && pwd`/db2any
     else
	DB2ANY=": "
	AC_MSG_WARN([[
***
*** It seems that the Docbook environment is not installed as required.
*** We will try to build everything,  but if you either touch some files
*** or use a bogus make tool, you may run into problems.
*** Docbook is normally only needed to build the documentation.
*** To further investigate the problem you can run the command
***    $ac_aux_dir/db2any --systemcheck --verbose
***]])
    fi
    AC_SUBST(DB2ANY)
    AM_CONDITIONAL(WORKING_DB2ANY, test "$working_db2any" != yes )
  ])


