/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICCLI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateCloseINI(void)

	Close the opened INI file and install it as the real INI file.

ob(ject): cfgCreateCloseINI
su(bsystem): inifile
sh(ort description):  Closes a currently opened INI file
lo(ng description): Close the temporary INI file currently opened for writing and, on success, install the temporary file as the real INI file.
 Any resources allocated for the write action only are freed.
re(lated to): cfg_wrOpen cfgCreateINI cfgCreateSectionINI cfgEraseSection cfgCreateIgnoreINI
fi(le): cfgiccli.c
in(itialized by): cfgCreateINI cfgCreateSectionINI cfgEraseSection 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "dfn.h"
#include "supplio.h"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICCLI.C 1.5 2001/02/27 01:27:23 ska Exp ska $";
#endif

int cfgCreateCloseINI(void)
{	int rv;

	DBG_ENTER("cfgCreateCloseINI", Suppl_inifile)

	StrFree(cfgi_data);
	StrFree(cfgi_string);

	if(!cfgi_ini)		DBG_RETURN_I( CFG_ERR_NOTOPEN)

	assert(cfgi_fnam);

	chkHeap
	CFGI_NXTLINE

	chkHeap
	Fyclose(cfgi_ini);		/* close file, but preserve extended attributes */

	chkHeap
	switch(dfnfreplace(cfgi_fnam, Fxinfo(cfgi_ini)->sea_fnam)) {
	case 1:		rv = CFG_ERR_MEM;
	case 0: 	break;		/* OK */
	default:	rv = CFG_ERR_ACCESS; break;
	}

	chkHeap
	Fxclose(cfgi_ini);		/* delete extended attributes */
		/* and if dfnreplace() failed, remove the temporary file */

	chkHeap
	StrFree(cfgi_fnam);
	chkHeap
	cfgi_ini = 0;		/* indicate: no opened INI file */

	DBG_RETURN_I( rv)
}
