/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_WSO.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_wrSecOpen(fpos_t *pos, int isSecLine);

	Enter write mode in WSECTION mode, copy all bytes upto pos into the
	output file and prepare that the wrClose() function copies the
	following sections when closed.
	If isSecLine is true, the position points to the section name of
	the current section and must be skipped in order to fetch the
	next section. In fact, one section is skipped, not only one line.

ob: cfgi_wrSecOpen
ty: L
su: inifile/2
sh: Enter write mode for the current section
lo: Opens the INI file for writing, copies everything preceeding the section
	into the temporary INI file and prepares that cfgi_wrClose() copies
	everything following this section into the INI file.\par
	If \para{isSecLine} is true, the specified position is the file offset
	of the line with the section mark in it, which must be skipped.
re: 
fi: cfgi_wso.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_WSO.C 1.4 2000/03/31 09:08:54 ska Exp ska $";
#endif

int cfgi_wrSecOpen(const fpos_t * const pos, int isSecLine)
{	int rv;

	DBG_ENTER("cfgi_wrSecOpen", Suppl_inifile2)
	DBG_ARGUMENTS( ("isSectionLine=%d", isSecLine) )

	chkHeap
	if((rv = cfgi_wrOpen()) == CFG_ERR_NONE
	 && (rv = cfgi_copyallto(pos)) == CFG_ERR_NONE) {
		chkHeap
	 	/* search the next section */
	 	rv = cfgi_nxtSec(usrini.cfgi_fp);
	 	if(rv == CFG_ERR_NONE && isSecLine)
	 		/* skip over the first found section */
			rv = cfgi_nxtSec(usrini.cfgi_fp);

		chkHeap
		switch(rv) {
		case CFG_ERR_NONE:		/* key found */
			/* where to start copy the remaining parts of the INI file */
			Fposcpy(aS(I(writePos)), aS(I(curpos)));
			I(writeOpen) = CFG_WSECTION;

			/* fall through */

		case CFG_ERR_KEY:		/* at EOF */
			/* remain in WFILE mode as there is nothing to copy */
			if(Fsetpos(usrini.cfgi_fp, pos))
				DBG_RETURN_I( CFG_ERR_ACC)
			DBG_RETURN_I( CFG_ERR_NONE)
		}
	}

	chkHeap
	DBG_RETURN_I( rv)
}
